from pathlib import Path

from .base_classes import BaseSpriteLoader


class JournalMonsterSheet(BaseSpriteLoader):
    _sprite_sheet_path = Path("Data/Textures/journal_entry_mons.png")
    _chunk_size = 160
    _chunk_map = {
        "journal_snake": (0, 0, 1, 1),
        "journal_spider": (1, 0, 2, 1),
        "journal_hang_spider": (2, 0, 3, 1),
        "journal_bat": (3, 0, 4, 1),
        "journal_cave_man": (4, 0, 5, 1),
        "journal_skeleton": (5, 0, 6, 1),
        "journal_scorpion": (6, 0, 7, 1),
        "journal_horned_lizard": (7, 0, 8, 1),
        "journal_man_trap": (8, 0, 9, 1),
        "journal_tiki_man": (9, 0, 10, 1),
        "journal_witch_doctor": (0, 1, 1, 2),
        "journal_mosquito": (1, 1, 2, 2),
        "journal_monkey": (2, 1, 3, 2),
        "journal_magmar": (3, 1, 4, 2),
        "journal_robot": (4, 1, 5, 2),
        "journal_fire_bug": (5, 1, 6, 2),
        "journal_vampire": (7, 1, 8, 2),
        "journal_vlad": (8, 1, 9, 2),
        "journal_croc_man": (9, 1, 10, 2),
        "journal_cobra": (0, 2, 1, 3),
        "journal_sorceress": (1, 2, 2, 3),
        "journal_cat_mummy": (2, 2, 3, 3),
        "journal_jiangshi": (3, 2, 4, 3),
        "journal_flying_fish": (4, 2, 5, 3),
        "journal_octopy": (5, 2, 6, 3),
        "journal_hermit_crab": (6, 2, 7, 3),
        "journal_ufo": (7, 2, 8, 3),
        "journal_alien": (8, 2, 9, 3),
        "journal_yeti": (9, 2, 10, 3),
        "journal_olmite": (0, 3, 1, 4),
        "journal_necromancer": (1, 3, 2, 4),
        "journal_bee": (2, 3, 3, 4),
        "journal_poochi": (4, 3, 5, 4),
        "journal_monty": (5, 3, 6, 4),
        "journal_golden_monkey": (6, 3, 7, 4),
        "journal_jiangshi_assassin": (7, 3, 8, 4),
        "journal_mole": (8, 3, 9, 4),
        "journal_percy": (9, 3, 10, 4),
        "journal_proto_shopkeeper": (0, 4, 1, 5),
        "journal_grub": (1, 4, 2, 5),
        "journal_frog": (2, 4, 3, 5),
        "journal_fire_frog": (3, 4, 4, 5),
        "journal_leprechain": (4, 4, 5, 5),
        "journal_egg_plup": (5, 4, 6, 5),
        "journal_ghist": (6, 4, 7, 5),
        "journal_tadpole": (7, 4, 8, 5),
        "journal_turkey": (8, 4, 9, 5),
        "journal_rockdog": (9, 4, 10, 5),
        "journal_axolotl": (0, 5, 1, 6),
        "journal_qilin": (1, 5, 2, 6),
    }
