# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['runrestic', 'runrestic.metrics', 'runrestic.restic', 'runrestic.runrestic']

package_data = \
{'': ['*']}

install_requires = \
['jsonschema>=3.0,<4.0', 'requests>=2.27.1,<3.0.0', 'toml>=0.10,<0.11']

entry_points = \
{'console_scripts': ['runrestic = runrestic.runrestic.runrestic:runrestic']}

setup_kwargs = {
    'name': 'runrestic',
    'version': '0.5.27',
    'description': 'A wrapper script for Restic backup software that inits, creates, prunes and checks backups',
    'long_description': '![python version](https://img.shields.io/badge/python-3.7+-blue.svg)\n[![Code style: black](https://img.shields.io/badge/code%20style-black-000000.svg)](https://github.com/psf/black)\n![Travis (.com)](https://api.travis-ci.com/sinnwerkstatt/runrestic.svg?branch=main)\n![PyPI](https://img.shields.io/pypi/v/runrestic)\n[![Stackshare: runrestic](https://img.shields.io/badge/stackshare-runrestic-068DFE.svg)](https://stackshare.io/runrestic)\n![PyPI - Downloads](https://img.shields.io/pypi/dm/runrestic)\n\n# Runrestic\n\nrunrestic is a simple Python wrapper script for the\n[Restic](https://restic.net/) backup software that initiates a backup,\nprunes any old backups according to a retention policy, and validates backups\nfor consistency. The script supports specifying your settings in a declarative\nconfiguration file rather than having to put them all on the command-line, and\nhandles common errors.\n\n## Example config\n\n```toml\nrepositories = [\n    "/tmp/restic-repo",\n    "sftp:user@host:/srv/restic-repo",\n    "s3:s3.amazonaws.com/bucket_name"\n    ]\n\n[environment]\nRESTIC_PASSWORD = "CHANGEME"\n\n[backup]\nsources = [\n    "/home",\n    "/var"\n    ]\n\n[prune]\nkeep-last =  3\nkeep-hourly =  5\n```\n\nAlternatively you can also just use JSON. For a more comprehensive example see the [example.toml](https://github.com/sinnwerkstatt/runrestic/blob/main/sample/example.toml)\nor check the [schema.json](https://github.com/sinnwerkstatt/runrestic/blob/main/runrestic/runrestic/schema.json)\n\n## Getting started\n\n### Installing runrestic and restic\n\nTo install **runrestic**, run the following command to download and install it:\n\n```bash\nsudo pip3 install --upgrade runrestic\n```\n\n<br>\nYou can either manually download and install [Restic](https://restic.net/) or you can just run `runrestic` and it\'ll try to download it for you.\n\n### Initializing and running\n\nOnce you have `restic` and `runrestic` ready, you should put a config file in on of the scanned locations, namely:\n\n- /etc/runrestic.toml\n- /etc/runrestic/_example_.toml\n- ~/.config/runrestic/_example_.toml\n- /etc/runrestic.json\n- /etc/runrestic/_example_.json\n- ~/.config/runrestic/_example_.json\n\nAfterwards, run\n\n```bash\nrunrestic init # to initialize all the repos in `repositories`\n\nrunrestic  # without actions will do: runrestic backup prune check\n# or\nrunrestic [action]\n```\n\n<br>\nCertain `restic` flags like `--dry-run/-n` are built into `runrestic` as well and will be passed to restic where applicable.\n\nIf, however, you need to pass along arbitrary other flags you can now add them to the end of your `runrestic` call like so:\n\n```bash\nrunrestic backup -- --one-file-system\n```\n\n#### Logs for restic and hooks\n\nThe output of `restic` and the configured pre/post-hooks is added to the `runrestic` logs at the level defined in\n`[execution] proc_log_level` (default: DEBUG), which can be overwritten with the CLI option `-p/--proc-log-level`.\n\nFor process log levels greater than `INFO` the output of file names is suppressed and for log levels greater than WARNING\n`restic` is executed with the `--quiet` option. If the process log level is set to `DEBUG`, then restic is executed\nwith the `--verbose` option.\n\nIt is also possible to add `restic` progress messages to the logs by using the CLI option `--show-progress INTERVAL`\nwhere the `INTERVAL` is the number of seconds between the progress messages.\n\n### Restic shell\n\nTo use the options defined in `runrestic` with `restic` (e.g. for a backup restore), you can use the `shell` action:\n\n```bash\nrunrestic shell\n```\n\nIf you are using multiple repositories or configurations, you can select one now.\n\n### Prometheus / Grafana metrics\n\n[@d-matt](https://github.com/d-matt) created a nice dashboard for Grafana here: https://grafana.com/grafana/dashboards/11064/revisions\n\n### systemd timer or cron\n\nIf you want to run runrestic automatically, say once a day, the you can\nconfigure a job runner to invoke it periodically.\n\n#### systemd\n\nIf you\'re using systemd instead of cron to run jobs, download the [sample systemd service file](https://raw.githubusercontent.com/sinnwerkstatt/runrestic/main/sample/systemd/runrestic.service)\nand the [sample systemd timer file](https://raw.githubusercontent.com/sinnwerkstatt/runrestic/main/sample/systemd/runrestic.timer).\nThen, from the directory where you downloaded them:\n\n```bash\nsudo mv runrestic.service runrestic.timer /etc/systemd/system/\nsudo systemctl enable runrestic.timer\nsudo systemctl start runrestic.timer\n```\n\n#### cron\n\nIf you\'re using cron, download the [sample cron file](https://raw.githubusercontent.com/sinnwerkstatt/runrestic/main/sample/cron/runrestic).\nThen, from the directory where you downloaded it:\n\n```bash\nsudo mv runrestic /etc/cron.d/runrestic\nsudo chmod +x /etc/cron.d/runrestic\n```\n\n## Changelog\n\n- v0.5.27\n  - Fix output parsing for new restic version 0.14.0\n  - Introduce failsafe output parser which supports default values\n- v0.5.26\n  - Add output messages from `restic` and pre/post-hook commands to runrestic logs.\n  - New CLI argument `--show-progress INTERVAL` for the restic progress update interval in seconds (default None)\n- v0.5.25\n  - Drop support for Python 3.6, add support for Python 3.9 and 3.10, update dependencies\n- v0.5.24\n  - Exit the script with returncode = 1 if there was an error in any of the tasks\n- v0.5.23\n  - support JSON config files.\n- v0.5.21\n\n  - fix issue where "check" does not count towards overall "errors"-metric\n\n- v**0.5**! Expect breaking changes.\n  - metrics output is a bit different\n  - see new `parallel` and `retry_*` options.\n\n## Ansible\n\n@tabic wrote an ansible role, you can find it here: https://github.com/outwire/ansible-role-restic . (I have neither checked nor tested it.)\n\n## Development\n\nThis project is managed with [poetry](https://python-poetry.org/)\n\n[Install it](https://github.com/python-poetry/poetry#installation) if not already present:\n\n```bash\ncurl -sSL https://raw.githubusercontent.com/python-poetry/poetry/master/get-poetry.py | python\n# or\npip install --user poetry\n```\n\n### Installing dependencies\n\n```bash\npoetry install\n```\n\n### Running Tests\n\n```bash\npoetry run pytest\n```\n\n### Using VScode devcontainer\n\nThe project contains a `.devcontainer` folder with the settings for VScode to [develop inside container](https://code.visualstudio.com/docs/remote/containers). The Python virtual environment\ncreated by poetry is stored outside the container in the projects path `.virtualenvs` so that it survives container rebuilds.\n\nThe Ubuntu 22.04 based container uses Python 3.10 as system version and includes minimal Python 3.7, 3.8 and 3.9 versions\nfor creating virtual environments in any of those versions.\n\nIt is possible to switch the Python version used by `poetry` with the command `poetry use <version>`,\nsee [poetry managing environments](https://python-poetry.org/docs/managing-environments/) for more details.\n\n# Thanks\n\nThis project was initially based on [borgmatic](https://github.com/witten/borgmatic/) but has since evolved into something else.\n',
    'author': 'Andreas Nüßlein',
    'author_email': 'andreas@nuessle.in',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://github.com/sinnwerkstatt/runrestic',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
