# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['igit', 'igit.models', 'igit.storage', 'igit.trees', 'tests']

package_data = \
{'': ['*']}

install_requires = \
['Jinja2[server]>=2.11.3,<3.0.0',
 'aiohttp[server]>=3.7.4,<4.0.0',
 'click',
 'cryptography>=3.4.7,<4.0.0',
 'dill>=0.3.3,<0.4.0',
 'fastapi[server]>=0.63.0,<0.64.0',
 'fsspec>=2021.4.0,<2022.0.0',
 'hypothesis[numpy,pandas]>=6.10.1,<7.0.0',
 'intervaltree>=3.1.0,<4.0.0',
 'msgpack-numpy>=0.4.7,<0.5.0',
 'msgpack>=1.0.2,<2.0.0',
 'pydantic>=1.8.1,<2.0.0',
 'pymongo>=3.11.3,<4.0.0',
 'requests[server]>=2.25.1,<3.0.0',
 'treelib>=1.6.1,<2.0.0',
 'zict>=2.0.0,<3.0.0']

entry_points = \
{'console_scripts': ['igit = igit.cli:main']}

setup_kwargs = {
    'name': 'interval-git',
    'version': '0.1.0',
    'description': 'Top-level package for igit.',
    'long_description': '====\niGit\n====\n\nGit-like interval versioning.\n\n\n**EXPERIMENTAL** Use at your own risk.\n\n\n.. image:: https://img.shields.io/pypi/v/igit.svg\n        :target: https://pypi.python.org/pypi/igit\n\n.. image:: https://img.shields.io/travis/jmosbacher/igit.svg\n        :target: https://travis-ci.com/jmosbacher/igit\n\n.. image:: https://readthedocs.org/projects/igit/badge/?version=latest\n        :target: https://igit.readthedocs.io/en/latest/?badge=latest\n        :alt: Documentation Status\n\n\nGit-like version control of data that is organized using interval trees as well as the simple string->value trees used in file systems.\n\nAnalogies to git:\n\n=========== =============\n**git**         **igit**\n----------- -------------\nblob        blob\nfilename    interval\ntree/folder interval-tree\n=========== =============\n\n\nGit is great for source code\n----------------------------\nGit is not so great for the objects the code creates and the configuration parameters the code consumes.\n  \n**The objects the code creates (usually serialized and saved to binary files)**\nGit tracks hierchies of folders and text content. Technically it can track binary data but it has no way of identifying which part of the object the binary file represents has changed and which is the same so it will save the entire file for even the smallest change, this defeats the purpose of the git object store and the repository quickly becomes massive.\n\n**The configuration parameters the code consumes**\nGit is meant to track changes over time in a distributed manner but at any time there is only one working tree. \nConfiguration values can have time dependence, and a change to the value relavent to a specific time interval should not\ncause a merge conflict with an edit of a different time interval. Git will easily merge two changes made to different\nfiles but there is no way of defining the interval of validity for a file change.\n    \n**iGit is here to help**\niGit supports interval trees as first class citizens.Interval could be intervals of time or intervals \nof array indices or anything else you can think of. The concept of a filename is generalized to an interval,\nso changes to two different intervals in iGit is equivalent to changing two different files in git. \nThis allows for easy merging of changes being done on different intervals. e.g. two people working on the ideal \nparameters for processing two different datasets, taken e.g. at different times. Both analysts want to use the same \nalgorithms and code but just tune the parameters to different values and then merge the results together for a combined \nconfiguration used by the entire collaboration. But they also want to version their configurations. So do they make two\nconfig files and add them to a repository? what if they later on discover that the data actually should be split in three\nparts with three configs? git is simply not designed for this kind of data with validity intervals attached to them.\n\niGit is built from the ground up with these use cases in mind but reusing gits architecture and reimplementing it for \narbitrary tree structures as well as python objects.\n\nin iGit the structure being versioned is a hiearchy of trees and blobs like git, only instead of just \nsupporting folder-like trees (string->value mapping) iGit supports interval trees as well.\nAn interval tree maps intervals to data, data can contain a python object (analog of a file) or\nanother tree (analog of a folder). This kind of structure is useful e.g. when tracking chunks of large arrays of data or \nconfiguration parameters that have defined intervals of validity attached to them. In these cases its useful\nto be able to associate a unique piece of data with an interval between two integers (e.g. array indices or timestamps)\ninstead of a string of characters like a filename.\n\nExample usage\n-------------\n.. code-block:: python\n   \n   # init repo, If you pass a valid fsspec uri, the matching filesystem protocol will be used \n   # and mapped to a python string-->bytes mapping. You can also pass in a python Mapping object.\n   r = igit.Repo.init("file://./igit_test")\n\n   # add some data\n   c = r.new_config_group("config")\n   to_pe = c.new_interval_group("to_pe")\n   to_pe[1,10] = 11\n   to_pe[10,100] = 20\n   gains = c.new_interval_group("gains")\n   gains[1,10] = [1,2,3,4]\n   gains[5,30] = [4,3,2,1]\n   gains[30,200] = [1,1,1,1]\n\n   run_id = c.new_interval_group("run_id")\n   times = range(0,200, 15)\n   for i, period in enumerate(zip(times[:-1], times[1:])):\n      run_id[period] = f"run{i:04}"\n\n   r.new_interval_group("setting1")\n   r.new_label_group("setting2")\n   r.setting2.new_interval_group("subsetting1")\n   r.setting2.new_interval_group("subsetting2")\n   r.setting1[1,10] = 9\n   r.setting1[9,20] = 11\n   r.setting1.new_label_group((20,25))\n   r.setting2.subsetting1[9,100] = 99\n   r.setting2.subsetting2[9,100] = 102\n   r.setting1[(20,25)]["subsetting5"] = 9\n   r.setting2["subsetting3"] = "text"\n   r.setting2["subsetting4"] = "A very long text field to show how long values are cut short in the tree view"\n\n   # Stage and commit\n   r.igit.add()\n   r.igit.commit(f"commit {random.randint(1,10)}")\n\n   # make some changes\n   r.setting2["subsetting7"] = 9\n\n   #stage and commit again\n   r.igit.add()\n   r.igit.commit(f"second commit {random.randint(20,30)}")\n\nThe repo has a string repr that shows the current working tree:\n\n.. image:: docs/assets/images/tree_repr.png\n   :alt: Tree string repr\n\nThere are also some nice visualizations of the working tree built in:   \n\n.. code-block:: python\n\n   r.echarts_tree()\n\n\n.. image:: docs/assets/images/echarts_tree_view.png\n   :alt: Tree echarts\n\nThe are utilities to help manage the interval based data, such as splitting on interval boundaries:\n\n.. image:: docs/assets/images/interval_chunking.png\n   :alt: Interval chunking\n\nAnd of course it wouldnt be git if you cant poke around the commit history\n\n.. code-block:: python\n\n   r.browse_history()\n\n.. image:: docs/assets/images/history_viewer.png\n   :alt: History (commit) viewer\n\nInterval indexing, who needs it?\n================================\nExteremely useful for relating data with varying scales of resolution.\n\n\nExample:\n   - A pmt waveform sampled at 10ns resolution in non uniform intervals.\n   - PMT gain measurement sampled at 0.5 week +- 1day resolution \n   - A processing algorithm that needs to correct the waveform by gain. eg corrected = counts/gain\n   \nThe expression `corrected = counts/gain` is not well defined for `len(counts) != len(gain) != 1` algorithm needs to be fed both the counts and the gain for every sample.\n   \n**"Brute force" solution**\n \nFeed the algorithm an "upsampled" array of the lower resolution measurement gain.\n \n.. code-block:: python\n\n   counts_array = [1,5,43,768,234,123,34,2345,345,23,342,36,46,4,6567,4,34]\n   gain = [3,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,4,4]\n\nThis is obviously inefficient but is guarenteed to always work given enough resources.\n\n**Alternative approach**\nBatch the high resolution array into chunks of constant value of the low resolution array. Run the algorithm on each batch where gain is constant and therefore the operation `corrected = counts/gain` is well defined. Works well and very efficient.\n\nBut what happens when you have a third value with a completely different resolution? e.g. QE, now you need to take all of these scales into account when batching the high res array.\n\nHow can this be generalized to arbitrary resolutions? Interval indexing.\n\nMost indexes define a one-to-one mapping from some label space to an offset for rapid lookup, an index can be used to "align" array binary operations on array of different length/different sorting. The interval index maps between continous intervals and indices, where the query is on overlap rather than equality.\nThe downside is that overlap queries can be very expensive using brute force methods, for efficient indexing on intervals, tree-like structures are needed, e.g the interval tree and nested containement list.\n\nThe O(logn+m) complexity of overlap queries allow for real time upsampling at varying resolution as well as splitting on intersection techniques to scale to large arrays.\n\n**Further complications**\n   - Many times some of the values can change over time and therefore need to be versioned for reproducability.\n   - Some values are not values at all but rather algorithms/collections of values.\n\n\n**Solution: meet igit**\nA git-like version management system that supports interval trees as first class citizens as well as (almost) arbitrary python objects.\n\n\n\n* Free software: Apache-2.0\n* Documentation: https://igit.readthedocs.io.\n\n\nFeatures\n--------\n\n* IntervalGroup tree for intervaltree based "folders"\n* LabelGroup tree for dict-like "folders"\n* ConfigGroup for tracking interval of validity configuration objects\n* Visualization tools\n* Config "interval_chunking", splits your config into intervals of constant parameter values (for a subset of parameters or all)\n* Optional in-flight compression\n* Optional in-flight encryption\n* Supports remote/local file systems using fsspec \n  \nFuture Improvements\n-------------------\n* Option to add custom tree classes via plugins\n* Option to add custom encoding (hashing/serialization/compression) classes via plugins\n* Merge strategies\n\nCredits\n-------\nThis package relies on the intervaltree_ package for all interval tree manipulation\n\nThis package relies on the fsspec_ package for file system abstraction.\n\nThis package was created with Cookiecutter_ and the `briggySmalls/cookiecutter-pypackage`_ project template.\n\n.. _intervaltree: https://github.com/chaimleib/intervaltree\n.. _fsspec: https://github.com/intake/filesystem_spec/\n.. _Cookiecutter: https://github.com/audreyr/cookiecutter\n.. _`briggySmalls/cookiecutter-pypackage`: https://github.com/briggySmalls/cookiecutter-pypackage\n',
    'author': 'Yossi Mosbacher',
    'author_email': 'joe.mosbacher@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/jmosbacher/igit',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.7',
}


setup(**setup_kwargs)
