# Generated by Django 3.1.1 on 2020-09-25 14:54

import django.db.models.deletion
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):

    replaces = [
        ("event_management", "0001_initial"),
        ("event_management", "0002_event_active"),
        ("event_management", "0003_auto_20200825_1351"),
        ("event_management", "0004_auto_20200829_1535"),
        ("event_management", "0005_auto_20200829_2348"),
        ("event_management", "0006_auto_20200830_0116"),
        ("event_management", "0007_auto_20200902_0016"),
        ("event_management", "0008_event_mail_updates"),
        ("event_management", "0009_auto_20200921_2155"),
    ]

    initial = True

    dependencies = [
        ("contenttypes", "0002_remove_content_type_name"),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name="EventSeries",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True, primary_key=True, serialize=False, verbose_name="ID"
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="EventType",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True, primary_key=True, serialize=False, verbose_name="ID"
                    ),
                ),
                ("title", models.CharField(max_length=254, verbose_name="title")),
                (
                    "can_grant_qualification",
                    models.BooleanField(verbose_name="can grant qualification"),
                ),
            ],
            options={
                "verbose_name": "event type",
                "verbose_name_plural": "event types",
            },
        ),
        migrations.CreateModel(
            name="Event",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True, primary_key=True, serialize=False, verbose_name="ID"
                    ),
                ),
                ("title", models.CharField(max_length=254, verbose_name="title")),
                (
                    "description",
                    models.TextField(blank=True, null=True, verbose_name="description"),
                ),
                ("location", models.CharField(max_length=254, verbose_name="location")),
                (
                    "series",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="event_management.eventseries",
                    ),
                ),
                (
                    "type",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="event_management.eventtype",
                        verbose_name="event type",
                    ),
                ),
                ("active", models.BooleanField(default=False)),
                (
                    "mail_updates",
                    models.BooleanField(default=True, verbose_name="send updates via mail"),
                ),
            ],
            options={
                "verbose_name": "event",
                "verbose_name_plural": "events",
                "permissions": [("view_past_event", "Can view past events")],
            },
        ),
        migrations.CreateModel(
            name="Shift",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True, primary_key=True, serialize=False, verbose_name="ID"
                    ),
                ),
                ("meeting_time", models.DateTimeField(verbose_name="meeting time")),
                ("start_time", models.DateTimeField(verbose_name="start time")),
                ("end_time", models.DateTimeField(verbose_name="end time")),
                ("signup_method_slug", models.SlugField(verbose_name="signup method")),
                ("signup_configuration", models.JSONField(default=dict)),
                (
                    "event",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="shifts",
                        to="event_management.event",
                        verbose_name="shifts",
                    ),
                ),
            ],
            options={
                "verbose_name": "shift",
                "verbose_name_plural": "shifts",
            },
        ),
        migrations.CreateModel(
            name="AbstractParticipation",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True, primary_key=True, serialize=False, verbose_name="ID"
                    ),
                ),
                (
                    "state",
                    models.IntegerField(
                        choices=[
                            (0, "requested"),
                            (1, "confirmed"),
                            (2, "declined by user"),
                            (3, "rejected by responsible"),
                        ],
                        default=0,
                        verbose_name="state",
                    ),
                ),
                (
                    "shift",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="event_management.shift",
                        verbose_name="shift",
                    ),
                ),
                (
                    "polymorphic_ctype",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="polymorphic_event_management.abstractparticipation_set+",
                        to="contenttypes.contenttype",
                    ),
                ),
            ],
            options={
                "base_manager_name": "objects",
            },
        ),
        migrations.CreateModel(
            name="LocalParticipation",
            fields=[
                (
                    "abstractparticipation_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        serialize=False,
                        to="event_management.abstractparticipation",
                    ),
                ),
                (
                    "user",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL
                    ),
                ),
            ],
            options={
                "base_manager_name": "objects",
            },
            bases=("event_management.abstractparticipation",),
        ),
    ]
