"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Network = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_ec2_1 = require("@aws-cdk/aws-ec2");
const core_1 = require("@aws-cdk/core");
/**
 * Network settings for the manager and runners.
 *
 * All EC2 instances should belong to the same subnet, availability zone and vpc.
 *
 * @stability stable
 */
class Network extends core_1.Construct {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        var _b;
        super(scope, id);
        this.vpc = (_b = props === null || props === void 0 ? void 0 : props.vpc) !== null && _b !== void 0 ? _b : new aws_ec2_1.Vpc(scope, `Vpc`, {
            maxAzs: 1,
        });
        this.subnet = this.findSubnet(this.vpc, props === null || props === void 0 ? void 0 : props.subnetSelection);
        this.availabilityZone = this.subnet.availabilityZone;
        if (!this.hasPrivateSubnet(this.vpc)) {
            core_1.Annotations.of(this).addWarning(`No private network found in ${this.vpc.vpcId}, using public addresses.`);
        }
    }
    hasPrivateSubnet(vpc) {
        return !!vpc.privateSubnets.length;
    }
    /**
     * Returns the first private or public subnet. Optionally filters by AZ.
     *
     * @exception Throws an error if no private or public is found.
     */
    findSubnet(vpc, subnetSelection) {
        const selectedSubnets = vpc.selectSubnets(subnetSelection || {
            subnetType: this.hasPrivateSubnet(vpc) ? aws_ec2_1.SubnetType.PRIVATE_WITH_NAT : aws_ec2_1.SubnetType.PUBLIC,
            availabilityZones: vpc.availabilityZones,
        });
        const subnet = selectedSubnets.subnets.find(() => true);
        if (!subnet) {
            throw new Error(`Neither a private nor a public subnet is found in ${vpc.vpcId}`);
        }
        return subnet;
    }
}
exports.Network = Network;
_a = JSII_RTTI_SYMBOL_1;
Network[_a] = { fqn: "@pepperize/cdk-autoscaling-gitlab-runner.Network", version: "0.0.85" };
//# sourceMappingURL=data:application/json;base64,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