/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.common.propertysheet;

import com.l2fprod.common.beans.ExtendedPropertyDescriptor;
import com.l2fprod.common.propertysheet.Property;
import com.l2fprod.common.propertysheet.PropertyDescriptorAdapter;
import com.l2fprod.common.propertysheet.PropertyRendererFactory;
import com.l2fprod.common.swing.renderer.BooleanCellRenderer;
import com.l2fprod.common.swing.renderer.ColorCellRenderer;
import com.l2fprod.common.swing.renderer.DateRenderer;
import com.l2fprod.common.swing.renderer.DefaultCellRenderer;
import java.beans.PropertyDescriptor;
import java.util.HashMap;
import java.util.Map;
import javax.swing.table.TableCellRenderer;

public class PropertyRendererRegistry
implements PropertyRendererFactory {
    private Map typeToRenderer = new HashMap();
    private Map propertyToRenderer = new HashMap();
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$awt$Color;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$util$Date;

    public PropertyRendererRegistry() {
        this.registerDefaults();
    }

    public TableCellRenderer createTableCellRenderer(Property property) {
        return this.getRenderer(property);
    }

    public TableCellRenderer createTableCellRenderer(Class type) {
        return this.getRenderer(type);
    }

    public synchronized TableCellRenderer getRenderer(Property property) {
        Object value;
        PropertyDescriptor descriptor;
        TableCellRenderer renderer = null;
        if (property instanceof PropertyDescriptorAdapter && (descriptor = ((PropertyDescriptorAdapter)property).getDescriptor()) instanceof ExtendedPropertyDescriptor && ((ExtendedPropertyDescriptor)descriptor).getPropertyTableRendererClass() != null) {
            try {
                return (TableCellRenderer)((ExtendedPropertyDescriptor)descriptor).getPropertyTableRendererClass().newInstance();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if ((value = this.propertyToRenderer.get(property)) instanceof TableCellRenderer) {
            renderer = (TableCellRenderer)value;
        } else if (value instanceof Class) {
            try {
                renderer = (TableCellRenderer)((Class)value).newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            renderer = this.getRenderer(property.getType());
        }
        return renderer;
    }

    public synchronized TableCellRenderer getRenderer(Class type) {
        TableCellRenderer renderer = null;
        Object value = this.typeToRenderer.get(type);
        if (value instanceof TableCellRenderer) {
            renderer = (TableCellRenderer)value;
        } else if (value instanceof Class) {
            try {
                renderer = (TableCellRenderer)((Class)value).newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return renderer;
    }

    public synchronized void registerRenderer(Class type, Class rendererClass) {
        this.typeToRenderer.put(type, rendererClass);
    }

    public synchronized void registerRenderer(Class type, TableCellRenderer renderer) {
        this.typeToRenderer.put(type, renderer);
    }

    public synchronized void unregisterRenderer(Class type) {
        this.typeToRenderer.remove(type);
    }

    public synchronized void registerRenderer(Property property, Class rendererClass) {
        this.propertyToRenderer.put(property, rendererClass);
    }

    public synchronized void registerRenderer(Property property, TableCellRenderer renderer) {
        this.propertyToRenderer.put(property, renderer);
    }

    public synchronized void unregisterRenderer(Property property) {
        this.propertyToRenderer.remove(property);
    }

    public void registerDefaults() {
        this.typeToRenderer.clear();
        this.propertyToRenderer.clear();
        DefaultCellRenderer renderer = new DefaultCellRenderer();
        renderer.setShowOddAndEvenRows(false);
        ColorCellRenderer colorRenderer = new ColorCellRenderer();
        colorRenderer.setShowOddAndEvenRows(false);
        BooleanCellRenderer booleanRenderer = new BooleanCellRenderer();
        DateRenderer dateRenderer = new DateRenderer();
        dateRenderer.setShowOddAndEvenRows(false);
        this.registerRenderer(class$java$lang$Object == null ? (class$java$lang$Object = PropertyRendererRegistry.class$("java.lang.Object")) : class$java$lang$Object, (TableCellRenderer)renderer);
        this.registerRenderer(class$java$awt$Color == null ? (class$java$awt$Color = PropertyRendererRegistry.class$("java.awt.Color")) : class$java$awt$Color, (TableCellRenderer)colorRenderer);
        this.registerRenderer(Boolean.TYPE, (TableCellRenderer)booleanRenderer);
        this.registerRenderer(class$java$lang$Boolean == null ? (class$java$lang$Boolean = PropertyRendererRegistry.class$("java.lang.Boolean")) : class$java$lang$Boolean, (TableCellRenderer)booleanRenderer);
        this.registerRenderer(Byte.TYPE, (TableCellRenderer)renderer);
        this.registerRenderer(class$java$lang$Byte == null ? (class$java$lang$Byte = PropertyRendererRegistry.class$("java.lang.Byte")) : class$java$lang$Byte, (TableCellRenderer)renderer);
        this.registerRenderer(Character.TYPE, (TableCellRenderer)renderer);
        this.registerRenderer(class$java$lang$Character == null ? (class$java$lang$Character = PropertyRendererRegistry.class$("java.lang.Character")) : class$java$lang$Character, (TableCellRenderer)renderer);
        this.registerRenderer(Double.TYPE, (TableCellRenderer)renderer);
        this.registerRenderer(class$java$lang$Double == null ? (class$java$lang$Double = PropertyRendererRegistry.class$("java.lang.Double")) : class$java$lang$Double, (TableCellRenderer)renderer);
        this.registerRenderer(Float.TYPE, (TableCellRenderer)renderer);
        this.registerRenderer(class$java$lang$Float == null ? (class$java$lang$Float = PropertyRendererRegistry.class$("java.lang.Float")) : class$java$lang$Float, (TableCellRenderer)renderer);
        this.registerRenderer(Integer.TYPE, (TableCellRenderer)renderer);
        this.registerRenderer(class$java$lang$Integer == null ? (class$java$lang$Integer = PropertyRendererRegistry.class$("java.lang.Integer")) : class$java$lang$Integer, (TableCellRenderer)renderer);
        this.registerRenderer(Long.TYPE, (TableCellRenderer)renderer);
        this.registerRenderer(class$java$lang$Long == null ? (class$java$lang$Long = PropertyRendererRegistry.class$("java.lang.Long")) : class$java$lang$Long, (TableCellRenderer)renderer);
        this.registerRenderer(Short.TYPE, (TableCellRenderer)renderer);
        this.registerRenderer(class$java$lang$Short == null ? (class$java$lang$Short = PropertyRendererRegistry.class$("java.lang.Short")) : class$java$lang$Short, (TableCellRenderer)renderer);
        this.registerRenderer(class$java$util$Date == null ? (class$java$util$Date = PropertyRendererRegistry.class$("java.util.Date")) : class$java$util$Date, (TableCellRenderer)dateRenderer);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

