/*
 * Decompiled with CFR 0.152.
 */
package ambit2.core.io;

import ambit2.core.io.FilesWithHeaderWriter;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.io.formats.IResourceFormat;

public class ArffWriter
extends FilesWithHeaderWriter {
    protected BufferedWriter writer;

    public ArffWriter(Writer writer) {
        try {
            this.writer = new BufferedWriter(writer);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    protected void writeHeader() throws IOException {
        this.writer.write(String.format("@relation %s\n\n", "Dataset"));
        for (int i = 0; i < this.getHeader().size(); ++i) {
            Object e = this.getHeader().get(i);
            this.writer.write(String.format("@attribute %s numeric\n", e.toString()));
        }
        this.writer.write("\n@data\n");
    }

    public void setWriter(Writer writer) throws CDKException {
        try {
            this.writer = new BufferedWriter(writer);
        }
        catch (Exception exception) {
            throw new CDKException(exception.getMessage());
        }
    }

    public void setWriter(OutputStream outputStream) throws CDKException {
        this.setWriter(new OutputStreamWriter(outputStream));
    }

    public void write(IChemObject iChemObject) throws CDKException {
        try {
            for (int i = 0; i < this.getHeader().size(); ++i) {
                Object object;
                Object e = this.getHeader().get(i);
                if (i > 0) {
                    this.writer.write(44);
                }
                this.writer.write((object = iChemObject.getProperty(e)) == null ? "?" : object.toString());
            }
            this.writer.write(10);
        }
        catch (IOException iOException) {
            throw new CDKException(iOException.getMessage());
        }
    }

    public boolean accepts(Class clazz) {
        return false;
    }

    public void close() throws IOException {
        this.writer.close();
    }

    public IResourceFormat getFormat() {
        return null;
    }
}

