# generated by datamodel-codegen:
#   filename:  schema/operations/pipelines/databaseServiceMetadataPipeline.json
#   timestamp: 2022-02-01T07:33:31+00:00

from __future__ import annotations

from typing import List, Optional

from pydantic import BaseModel, Field


class FilterPattern(BaseModel):
    includes: Optional[List[str]] = Field(
        None,
        description='List of strings/regex patterns to match and include only database entities that match.',
    )
    excludes: Optional[List[str]] = Field(
        None,
        description='List of strings/regex patterns to match and exclude only database entities that match.',
    )


class DatabaseserviceMetadataPipeline(BaseModel):
    markDeletedTables: Optional[bool] = Field(
        'true',
        description='Optional configuration to soft delete tables in OpenMetadata if the source tables are deleted.',
    )
    includeViews: Optional[bool] = Field(
        'true',
        description='Optional configuration to turn off fetching metadata for views.',
    )
    generateSampleData: Optional[bool] = Field(
        'true',
        description='Option to turn on/off generating sample data during metadata extraction.',
    )
    sampleDataQuery: Optional[str] = Field(
        'select * from {}.{} limit 50', description='Sample data extraction query.'
    )
    enableDataProfiler: Optional[bool] = Field(
        'false',
        description='Run data profiler as part of this metadata ingestion to get table profile data.',
    )
    schemaFilterPattern: Optional[FilterPattern] = Field(
        None,
        description='Regex to only fetch tables or databases that matches the pattern.',
    )
    tableFilterPattern: Optional[FilterPattern] = Field(
        None, description='Regex exclude tables or databases that matches the pattern.'
    )
    dbtCatalogFilePath: Optional[str] = Field(
        None,
        description='DBT catalog file to extract dbt models with their column schemas.',
    )
    dbtManifestFilePath: Optional[str] = Field(
        None,
        description='DBT manifest file path to extract dbt models and associate with tables.',
    )
