# Generated by Django 2.1.7 on 2020-06-30 14:43

import compositefk.fields
from django.conf import settings
import django.contrib.auth.models
import django.contrib.auth.validators
from django.db import migrations, models
import django.db.models.deletion
import django.db.models.manager
import django.utils.timezone


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('auth', '0009_alter_user_last_name_max_length'),
        ('core', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='Profile',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('password', models.CharField(max_length=128, verbose_name='password')),
                ('last_login', models.DateTimeField(blank=True, null=True, verbose_name='last login')),
                ('is_superuser', models.BooleanField(default=False, help_text='Designates that this user has all permissions without explicitly assigning them.', verbose_name='superuser status')),
                ('username', models.CharField(error_messages={'unique': 'A user with that username already exists.'}, help_text='Required. 150 characters or fewer. Letters, digits and @/./+/-/_ only.', max_length=150, unique=True, validators=[django.contrib.auth.validators.UnicodeUsernameValidator()], verbose_name='username')),
                ('first_name', models.CharField(blank=True, max_length=30, verbose_name='first name')),
                ('last_name', models.CharField(blank=True, max_length=150, verbose_name='last name')),
                ('email', models.EmailField(blank=True, max_length=254, verbose_name='email address')),
                ('is_staff', models.BooleanField(default=False, help_text='Designates whether the user can log into this admin site.', verbose_name='staff status')),
                ('is_active', models.BooleanField(default=True, help_text='Designates whether this user should be treated as active. Unselect this instead of deleting accounts.', verbose_name='active')),
                ('date_joined', models.DateTimeField(default=django.utils.timezone.now, verbose_name='date joined')),
                ('dat_insercao', models.DateTimeField(auto_now_add=True, null=True)),
                ('dat_edicao', models.DateTimeField(auto_now=True, null=True)),
                ('dat_delete', models.DateTimeField(null=True)),
                ('status', models.BooleanField(default=True, null=True)),
                ('nm_completo', models.CharField(max_length=200, null=True)),
                ('tipo_codigo', models.CharField(max_length=200, null=True)),
                ('tipo_tipo', models.CharField(default='USR.PROFILE.TIPO', max_length=200, null=True)),
                ('groups', models.ManyToManyField(blank=True, help_text='The groups this user belongs to. A user will get all permissions granted to each of their groups.', related_name='user_set', related_query_name='user', to='auth.Group', verbose_name='groups')),
                ('tipo', compositefk.fields.CompositeForeignKey(null=True, null_if_equal=[], on_delete=django.db.models.deletion.DO_NOTHING, related_name='usr_profile_tipo', to='core.Tipo', to_fields={'codigo': compositefk.fields.LocalFieldValue('tipo_codigo'), 'tipo': compositefk.fields.LocalFieldValue('tipo_tipo')})),
                ('user_permissions', models.ManyToManyField(blank=True, help_text='Specific permissions for this user.', related_name='user_set', related_query_name='user', to='auth.Permission', verbose_name='user permissions')),
                ('usr_delete', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='usr_profile_usr_delete', to=settings.AUTH_USER_MODEL)),
                ('usr_edicao', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='usr_profile_usr_edicao', to=settings.AUTH_USER_MODEL)),
                ('usr_insercao', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='usr_profile_usr_insercao', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'db_table': 'profile',
            },
            managers=[
                ('objects', django.contrib.auth.models.UserManager()),
            ],
        ),
        migrations.CreateModel(
            name='Grupo',
            fields=[
                ('dat_insercao', models.DateTimeField(auto_now_add=True, null=True)),
                ('dat_edicao', models.DateTimeField(auto_now=True, null=True)),
                ('dat_delete', models.DateTimeField(null=True)),
                ('status', models.BooleanField(default=True, null=True)),
                ('nivel', models.IntegerField(null=True)),
                ('ist_login', models.BooleanField(null=True)),
                ('ist_staff', models.BooleanField(default=False)),
                ('nome', models.CharField(max_length=200, primary_key=True, serialize=False)),
                ('nm_descritivo', models.CharField(max_length=200, null=True)),
                ('descricao', models.CharField(max_length=500, null=True)),
            ],
            options={
                'db_table': 'grupo',
            },
            managers=[
                ('normal_objects', django.db.models.manager.Manager()),
            ],
        ),
        migrations.CreateModel(
            name='GrupoLogin',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('dat_insercao', models.DateTimeField(auto_now_add=True, null=True)),
                ('dat_edicao', models.DateTimeField(auto_now=True, null=True)),
                ('dat_delete', models.DateTimeField(null=True)),
                ('status', models.BooleanField(default=True, null=True)),
                ('view_inicial', models.CharField(max_length=200, null=True)),
                ('cod_1', models.CharField(max_length=50, null=True)),
                ('cod_2', models.CharField(max_length=50, null=True)),
                ('cod_3', models.CharField(max_length=50, null=True)),
                ('grupo', models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, to='usr.Grupo')),
                ('sistema', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, to='core.Sistema')),
                ('usr_delete', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='usr_grupologin_usr_delete', to=settings.AUTH_USER_MODEL)),
                ('usr_edicao', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='usr_grupologin_usr_edicao', to=settings.AUTH_USER_MODEL)),
                ('usr_insercao', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='usr_grupologin_usr_insercao', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'db_table': 'grupologin',
            },
            managers=[
                ('normal_objects', django.db.models.manager.Manager()),
            ],
        ),
        migrations.CreateModel(
            name='GrupoUser',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('dat_insercao', models.DateTimeField(auto_now_add=True, null=True)),
                ('dat_edicao', models.DateTimeField(auto_now=True, null=True)),
                ('dat_delete', models.DateTimeField(null=True)),
                ('status', models.BooleanField(default=True, null=True)),
                ('ist_admin', models.BooleanField(default=False, null=True)),
                ('dt_ini', models.DateField(null=True)),
                ('dt_fim', models.DateField(null=True)),
                ('grupo', models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, to='usr.Grupo')),
                ('usr', models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, to=settings.AUTH_USER_MODEL)),
                ('usr_delete', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='usr_grupouser_usr_delete', to=settings.AUTH_USER_MODEL)),
                ('usr_edicao', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='usr_grupouser_usr_edicao', to=settings.AUTH_USER_MODEL)),
                ('usr_insercao', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='usr_grupouser_usr_insercao', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'db_table': 'grupouser',
            },
            managers=[
                ('normal_objects', django.db.models.manager.Manager()),
            ],
        ),
        migrations.CreateModel(
            name='PontoFuncao',
            fields=[
                ('dat_insercao', models.DateTimeField(auto_now_add=True, null=True)),
                ('dat_edicao', models.DateTimeField(auto_now=True, null=True)),
                ('dat_delete', models.DateTimeField(null=True)),
                ('status', models.BooleanField(default=True, null=True)),
                ('acao', models.CharField(max_length=100, primary_key=True, serialize=False)),
                ('codigo', models.IntegerField(null=True)),
                ('versao', models.CharField(max_length=10, null=True)),
                ('descricao', models.CharField(max_length=500, null=True)),
                ('modulo', models.CharField(max_length=100, null=True)),
                ('pagina', models.CharField(max_length=100, null=True)),
                ('lugares', models.TextField(null=True)),
                ('sistema', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, to='core.Sistema')),
                ('usr_delete', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='usr_pontofuncao_usr_delete', to=settings.AUTH_USER_MODEL)),
                ('usr_edicao', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='usr_pontofuncao_usr_edicao', to=settings.AUTH_USER_MODEL)),
                ('usr_insercao', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='usr_pontofuncao_usr_insercao', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'db_table': 'pontofuncao',
            },
            managers=[
                ('normal_objects', django.db.models.manager.Manager()),
            ],
        ),
        migrations.CreateModel(
            name='PontoFuncaoRelacao',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('dat_insercao', models.DateTimeField(auto_now_add=True, null=True)),
                ('dat_edicao', models.DateTimeField(auto_now=True, null=True)),
                ('dat_delete', models.DateTimeField(null=True)),
                ('status', models.BooleanField(default=True, null=True)),
                ('codigo', models.CharField(max_length=200, null=True)),
                ('tipo', models.CharField(max_length=200, null=True)),
                ('pontofuncao', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, to='usr.PontoFuncao')),
                ('usr_delete', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='usr_pontofuncaorelacao_usr_delete', to=settings.AUTH_USER_MODEL)),
                ('usr_edicao', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='usr_pontofuncaorelacao_usr_edicao', to=settings.AUTH_USER_MODEL)),
                ('usr_insercao', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='usr_pontofuncaorelacao_usr_insercao', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'db_table': 'pontofuncaorelacao',
            },
            managers=[
                ('normal_objects', django.db.models.manager.Manager()),
            ],
        ),
        migrations.AddField(
            model_name='grupo',
            name='usr',
            field=models.ManyToManyField(through='usr.GrupoUser', to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name='grupo',
            name='usr_delete',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='usr_grupo_usr_delete', to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name='grupo',
            name='usr_edicao',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='usr_grupo_usr_edicao', to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name='grupo',
            name='usr_insercao',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='usr_grupo_usr_insercao', to=settings.AUTH_USER_MODEL),
        ),
    ]
