from configparser import ConfigParser
from pkgutil import get_data

from inspyred_print import Color, Format

from inspyre_toolbox.pypi.packages import up_to_date

_color = Color()
_format = Format()
_red = _color.red
_end = _format.end_mod

__ver_parser = ConfigParser()
__ver = get_data('inspyre_toolbox', 'VERSION').decode('UTF8')
__ver_parser.read_string(__ver)

print(__ver_parser.sections())


class Version(object):

    def _check_most_current(self):
        """
        The _check_most_current function checks whether the most recent
        version of inspyre_toolbox is installed. If it is not, then the function returns
         False and a warning message will be printed to stdout.
        Otherwise, it returns True

        Args:
            self: Access attributes of the class within methods

        Returns:
            A boolean value
        """
        res = up_to_date('inspyre_toolbox')

        self.is_latest = res

        return res

    def __init__(self, version_info):
        print(dir(version_info))
        self.info = version_info['VERSION']
        self.number = self.info['number']
        self.pre_release = version_info.getboolean('VERSION', 'pre-release')

        if self.pre_release:
            self.pr_info = version_info['PRE-RELEASE']
            self.pr_type = self.pr_info['type']
            self.pr_num = self.pr_info['build-no']
            if self.pr_type.lower() == 'alpha':
                prt_tag = 'a'
            elif self.pr_type.lower() == 'beta':
                prt_tag = 'b'
            self.pr_tag = str(f"{prt_tag}{self.pr_num}")
        else:
            self.pr_info = None
            self.pr_type = None
            self.pr_num = None
            self.pr_tag = ""

        self.full = str(f"{self.number}{self.pr_tag}")
        self.is_latest = None
        self._check_most_current()


VERSION = Version(__ver_parser)
FULL = VERSION.full
UPDATE_PENDING = not VERSION.is_latest
