"""Contains constants."""
from __future__ import annotations

from enum import IntEnum, unique
from typing import Final

STATE_ON: Final = "on"
STATE_OFF: Final = "off"

ATTR_NAME: Final = "name"
ATTR_VALUE: Final = "value"
ATTR_EXTRA: Final = "extra"
ATTR_ECOMAX_SENSORS: Final = "sensors"
ATTR_ECOMAX_PARAMETERS: Final = "parameters"
ATTR_PENDING_ALERTS: Final = "pending_alerts"
ATTR_ALERTS: Final = "alerts"
ATTR_FAN_POWER: Final = "fan_power"
ATTR_FRAME_VERSIONS: Final = "frames"
ATTR_FUEL_CONSUMPTION: Final = "fuel_consumption"
ATTR_FUEL_LEVEL: Final = "fuel_level"
ATTR_FUEL_BURNED: Final = "fuel_burned"
ATTR_LOAD: Final = "load"
ATTR_MIXERS: Final = "mixers"
ATTR_MIXER_SENSORS: Final = "mixer_sensors"
ATTR_MIXER_PARAMETERS: Final = "mixer_parameters"
ATTR_MODE: Final = "mode"
ATTR_MODULES: Final = "modules"
ATTR_POWER: Final = "power"
ATTR_THERMOSTAT: Final = "thermostat"
ATTR_THERMOSTATS: Final = "thermostats"
ATTR_TRANSMISSION: Final = "transmission"
ATTR_PRODUCT: Final = "product"
ATTR_NETWORK: Final = "network"
ATTR_VERSION: Final = "version"
ATTR_PASSWORD: Final = "password"
ATTR_SCHEMA: Final = "schema"
ATTR_REGDATA: Final = "regdata"
ATTR_LAMBDA_SENSOR: Final = "lambda"
ATTR_SCHEDULES: Final = "schedules"
ATTR_TYPE: Final = "type"
ATTR_SWITCH: Final = "switch"
ATTR_PARAMETER: Final = "parameter"
ATTR_SCHEDULE: Final = "schedule"

BYTE_UNDEFINED: Final = 0xFF


@unique
class AddressTypes(IntEnum):
    """Contains device addresses."""

    BROADCAST = 0
    ECOMAX = 69
    ECOSTER = 81
    ECONET = 86


@unique
class FrameTypes(IntEnum):
    """Contains frame types."""

    REQUEST_STOP_MASTER = 24
    REQUEST_START_MASTER = 25
    REQUEST_CHECK_DEVICE = 48
    REQUEST_ECOMAX_PARAMETERS = 49
    REQUEST_MIXER_PARAMETERS = 50
    REQUEST_SET_ECOMAX_PARAMETER = 51
    REQUEST_SET_MIXER_PARAMETER = 52
    REQUEST_SCHEDULES = 54
    REQUEST_SET_SCHEDULE = 55
    REQUEST_UID = 57
    REQUEST_PASSWORD = 58
    REQUEST_ECOMAX_CONTROL = 59
    REQUEST_ALERTS = 61
    REQUEST_PROGRAM_VERSION = 64
    REQUEST_DATA_SCHEMA = 85
    RESPONSE_DEVICE_AVAILABLE = 176
    RESPONSE_ECOMAX_PARAMETERS = 177
    RESPONSE_MIXER_PARAMETERS = 178
    RESPONSE_SET_ECOMAX_PARAMETER = 179
    RESPONSE_SET_MIXER_PARAMETER = 180
    RESPONSE_SCHEDULES = 182
    RESPONSE_UID = 185
    RESPONSE_PASSWORD = 186
    RESPONSE_ECOMAX_CONTROL = 187
    RESPONSE_ALERTS = 189
    RESPONSE_PROGRAM_VERSION = 192
    RESPONSE_DATA_SCHEMA = 213
    MESSAGE_REGULATOR_DATA = 8
    MESSAGE_SENSOR_DATA = 53
