# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/00_colab.ipynb.

# %% auto 0
__all__ = ['get_colab_url', 'has_colab_badge', 'create_colab_badge_cell', 'add_colab_badge', 'add_colab_metadata']

# %% ../nbs/00_colab.ipynb 3
from pathlib import Path
from IPython import get_ipython
from IPython.display import display, Markdown

from fastcore.basics import ifnone

from execnb.nbio import NbCell, read_nb

from .utils import git_main_name, git_origin_repo, git_local_repo, search_cell, git_current_branch

# %% ../nbs/00_colab.ipynb 5
def get_colab_url(fname, branch):
    "Get git repo url, to append to colab"
    fname = Path(fname).resolve()
    github_repo = git_origin_repo(fname)
    fname = fname.relative_to(git_local_repo(fname))

    return f"https://colab.research.google.com/github/{github_repo}/blob/{branch}/{str(fname)}"

# %% ../nbs/00_colab.ipynb 7
_badge_meta = {"id": "view-in-github", "colab_type": "text"}

# %% ../nbs/00_colab.ipynb 10
def has_colab_badge(nb):
    "Check if notebook has colab badge, returns the cell position, -1 if not present"
    for i, cell in enumerate(nb["cells"]):
        if search_cell(cell, "Open In Colab"):
            return i
    return -1

# %% ../nbs/00_colab.ipynb 12
def create_colab_badge_cell(fname, branch=None, meta={}, tracker=None):
    "Create a colab badge cell from `fname`"
    # get main/master name
    branch = ifnone(branch, git_main_name(fname))
    url = get_colab_url(fname, branch)
    colab_cell = _create_colab_cell(url, meta, tracker)
    return colab_cell

# %% ../nbs/00_colab.ipynb 14
def add_colab_badge(notebook, fname, branch=None, idx=0, meta=_badge_meta, tracker=None):
    "Add a badge to Open In Colab in the `idx` cell"
    idx_colab_badge = has_colab_badge(notebook)
    if idx_colab_badge != -1:
        notebook["cells"].pop(idx_colab_badge)
    colab_cell = create_colab_badge_cell(fname, branch, meta, tracker)
    notebook["cells"].insert(idx, colab_cell)
    return notebook

# %% ../nbs/00_colab.ipynb 19
_colab_meta = {
    "accelerator": "GPU",
    "colab": {"include_colab_link": True, "toc_visible": True},
}

# %% ../nbs/00_colab.ipynb 20
def add_colab_metadata(notebook, meta=_colab_meta):
    "Adds GPU and colab meta to `notebook`"
    notebook["metadata"].update(_colab_meta)
    return notebook
