#!/usr/bin/env python3
# -*- coding: UTF-8 -*-

"""
A template for new submodules
"""

__version__ = '4.0'
__author__ = "evb"

content = {
        'design_headline':[
                '<#^,design_claim#>',
                #'<#^,design_names#>',
                '<#^,design_question#>',
                '<#^,design_conclusion#>'
                ],
        'design_section':['Design', 'Design', 'Design', 'Design', 'New design', 'Goodies', 'Nice to haves', 'Typography'],
        'design_ankeiler':['<#^,design_question#>','<#^,design_claim#>','<#^,design_work_description#>',],
        'design_sentence':[
                '<#design_names#>: “<#design_quote#>”.',
                '<#^,design_question#>',
                '<#^,design_work_description#>',
                '<#design_claim#>, <#design_question_more#>',
                '<#design_claim#>, <#design_glue#><#design_work_description#>',
                '<#design_claim#>, <#design_glue#><#design_work_description#>',
                '<#design_claim#>, <#design_glue#><#design_work_description#>',
                '<#design_claim#>, <#design_glue#><#design_counterclaim#>',
                '<#design_claim#>, <#design_glue#><#design_counterclaim#>',
                '<#design_claim#>, <#design_glue#><#design_counterclaim#>, <#design_glue#><#design_conclusion#>',
                '<#design_claim#>, <#design_glue#><#design_claim#>, <#design_glue#><#design_conclusion#>',
                '<#design_claim#>, <#design_glue#><#design_conclusion#>',
                '<#design_claim#>, <#design_glue#><#design_conclusion#>',
                '<#design_claim#>, <#design_glue#><#design_conclusion#>',
                ],
        'design_article_byline':[
                'studied <#design_theory_noun#> at <#university#> and writes for <#design_magazines#>, <#design_magazines#> and <#design_magazines#>.',
                ],
        'design_article_author': [
                '<#name_male#>'
                ],
        'design_article_title':[
                '<#^,design_question#>',
                '<#^,design_theory#>',
                '<#^,design_names#> and <#design_theory#>',
                ],

        'design_focus_discipline':[
                'graphic design', 'typography',
                ],
        'design_focus_name':[
                'graphic design','typography','information design','cognitice science','pscychology',
                'artificial intelligence', 'social design', 'interaction design', 'product design',
                ],
        'design_names':[
                #'Paul Renner','Harry Sierman','Walter Nikkels','Karel Treebus',
                #'Piet Zwart','Gerrit Noordzij',
                '<#name_male#>',
                '<#name_male#>',
                '<#name_male#>',
                '<#name_male#>',
                '<#name_male#>',
                '<#name_male#>',
                '<#name_male#>',
                '<#name_male#>',
                '<#name_female#>',
                '<#name_female#>',
                '<#name_female#>',
                '<#name_female#>',
                '<#name_female#>',
                '<#name_female#>',
                '<#name_female#>',
                '<#name_female#>',
                '<#name_japanese#>',
                '<#name_japanese#>',
                #'Gert Dumbar', 'Wim Crouwel',  'Sjoerd de Roos',
                #'Jan van Krimpen', 'Oswald Cooper', 'Ellen Lupton', 'Dawn Barrett',
                #'Joost Swarte', 'April Greiman', 'Ann Burdick', 'Rudy Vanderlans',
                #'Max Bruinsma', 'Robin Kinross', 'Rick Poynor', 'Lorainne Wild',
                'Louise Sandhaus', 'Brian Eno', 'David Byrne', 'David Bowie',
                #'Umberto Eco', 'Erik Spiekermann',
                #'Hannes Krüger',
                'Allan Turing',
                'Don Knuth',
                'Andy Warhol',
                'William Gibson',
                #'Wim T. Schippers',
                'Marshal Mcluhan',
                'Frank Lloyd Wright',
                #'Rem Koolhaas',
                #'Peter Saville',
                #'Christian Schwarz',
                'Frank Gehry',
                #"Peter Bil’ak",
                #'Stuart Bailey',
                #'Paul Barnes',
                ],
        'design_worktitles_num':['', '', '', '', '', '', '', '', '', '', ' <#num_roman#>', ' <-randint(1960,2060)->'],
        'design_worktitles_parts':['untitled',
                '<#^,p_figures_pop#>', '<#^,p_oldbiz_sx#>',
                '<#cities_USmajor#>',
                ],
        'design_worktitles':[
                '<#^,design_worktitles_parts#><#design_worktitles_num#>',
                '<#^,design_worktitles_parts#> and <#^,design_worktitles_parts#><#design_worktitles_num#>',
                '<#^,design_worktitles_parts#> vs. <#^,design_worktitles_parts#><#design_worktitles_num#>',
                                ],
        'design_work_medium':[
                'the work', 'the video installation', 'the installation',
                'the monograph',
                'a book', 'the piece', 'an article', 'the performance art piece',
                'the product placement', 'the corporate information architecture', 'the information concept',
                'personal hygiene products', 'the retrospect', 'the image store', 'the image concept',
                'the branding',
                'the corporate identity', 'the information strategy','the advertising concept', 'the product planning',
                ],
        'design_commissioner': ['<#company#>', '<#company_consolidated#>', '<#corporation_japanese#>',
                '<#bank_company#>', '<#co_creative#>'],
        'design_work':[
                '<#design_work_medium#> for <#design_commissioner#>',
                '<#design_work_medium#> for <#design_commissioner#>',
                '<#design_work_medium#> “<#design_worktitles#>”',
                '<#design_work_medium#> “<#design_worktitles#>” (<#design_sources#>)',
                ],
        'design_work_parts':[
                'line', 'text', 'image', 'photograph', 'hue', 'saturation', 'layout', 'page', 'material',
                'vision', 'responsive layouts',
                'composition', '<#design_theory_adj#> reference', 'contrast', 'brightness',
                'description', 'caption', 'font',

                ],
        'design_work_detail':[
                'mix of <#design_work_parts#> and <#design_work_parts#>',
                'relation between <#design_work_parts#> and <#design_work_parts#>',
                'juxtaposition of <#design_work_parts#> and <#design_work_parts#>',
                'strong line','vivid color','experimental typography', 'the new font', 'digital tool',
                'a <#design_theory_adj#> reference if anything', '<#design_theory_adj#> connotations',
                'juxtaposed text', 'serifs', '<#design_theory_noun#>',
                '<#design_theory_adj#> imagery', '<#design_theory_adj#> visions',
                'composition', 'layout', 'spread'
                ],
        'design_work_description_followup':[
                '', '', '', '', '', '', '',
                ', changing from <#design_work_detail#> to <#design_work_detail#>'
                ', though the artist contends it is <#design_theory_short#>',
                ', it is more like <#article,design_names#> or <#article,design_names#>',
                ', more or less like <#design_names#> predicted at the time',
                ', quite similar to what <#design_names#> proposed',
                ', but that falls outside the scope of this article',
                ', something this article will look at later on',
            ],
        'design_work_description':[
                '<#design_work_detail#> was strongly influenced by <#design_theory_short#><#design_work_description_followup#>',
                '<#design_work#> marks the move from <#design_theory_short#> to <#design_theory_short#><#design_work_description_followup#>',
                'the <#design_work_detail#> of <#design_theory_short#> emphasize the links to <#design_theory_short#><#design_work_description_followup#>',
                'the <#design_work_detail#> and <#design_work_detail#> are definitely <#design_theory_short#><#design_work_description_followup#>',
                ],

        'design_location':[
                'the workplace',
                '<#city#>',
                '<#design_sources#>',
                ],
        'design_magazines':[
                'EYE', 'Form & Zweck', 'Compres', 'Druk', 'Items', 'ID', 'Wired',
                'DotDotDot', 'Emigre', 'Hard Werken', 'LetterLetter',
                'A.D.', 'Acro [AKPO]', 'Adbusters', 'ADGtext', 'Add!ct', 'Adobe Magazine',
                'Affiche', 'AGD Quartal', 'AGI-NGT', 'AIGA Journal of Graphic Design',
                'Akademische Mitteilungen', 'Aktuell Grafisk Information', 'Alphabet',
                'Applies Arts', 'Apply', 'ARCA International', 'Argos',
                'Architext Design', 'Ark', 'Art View', 'Baseline', 'BAT', 'Bauhaus',
                'Blueprint', 'Bulldozer', 'Cactus', 'CMYK', 'Colors', 'Columnum', 'Da!',
                'De Stijl', 'DaDa', 'Design Digest', 'Design Issues', 'Design Report',
                'Domus', 'Fine Print', 'The Fleuron', 'FontZine', 'Form', 'Frieze',
                'Fuse', 'Graficar', 'Graphis', 'Grafische Nachrichten', 'Hard Werken',
                'Hfg Forum', 'House', 'I.D.', 'HQ High Quality', 'iM [Identity Matters]',
                'Icographic', 'Kak',
                'Journal of <#^,design_theory_adj#> <#^,design_theory_noun#>',
                'Journal of <#^,design_theory_adj#> <#^,design_theory_noun#>',
                ],
        'design_sources':[
                '<#design_magazines#> <#time_months#> <-randint(2000, 2012)->',
                ],
        'design_period':[
                '<-randint(1900,1950)->',
                '<-randint(18,20)->th century'
                ],
        'design_example_object':[
                'book cover', 'advertisement', 'book', 'book on <#design_names#>',
                'small press edition for <#name_somewhiteguy#> in <-randint(1900,1960)->'
                ],
        'design_theory_title':    [
                'Introduction to <#design_theory#>',
                'A critical analysis of <#design_theory#>',
                'Dictionary of <#design_theory#>'

                ],
        'design_theory_px':[
            '', '', '', '', '', '', '', '', '', '', 'early ', 'post-', 'counter ', 'non-', 'new ', 'neo-', 'ethno-',
            ],
        'design_theory_short':[
                '<#design_theory_px#><#design_buzzword#>',
                '<#design_theory_px#><#design_buzzword#>',
                '<#design_theory_px#><#design_buzzword#>',
                '<#design_theory_px#><#design_buzzword#>',
                '<#design_theory_px#><#design_buzzword#>',
                '<#design_theory_px#><#design_buzzword#>',
                '<#design_work#>',
                '<#design_work#>',
                '<#design_buzzword#>: <#design_work#>',
                '<#design_buzzword#>: <#design_work#>',
                ],
        'design_theory':[
            '<#design_theory_px#><#design_theory_adj#> yet <#design_buzzword#>',
            '<#design_theory_px#><#design_buzzword#>',
            '<#design_theory_px#><#design_buzzword#>',
            '<#design_theory_px#><#design_buzzword#> in <#sci_isms#>',
            '<#design_theory_px#><#design_buzzword#>',
            '<#design_theory_px#><#design_buzzword#> and <#design_theory_noun#>',
            '<#design_theory_px#><#design_buzzword#> in <#design_theory_noun#>',
                ],
        'design_nounspecific':    [
                'typography', 'graphic design', 'design', 'architecture',
                ],
        'design_theory_noun':[
            'resistance', 'criticism', 'experimentation', 'visualisation',
            'performance', 'evaluation', 'assumption', 'revival', 'language',
            'form', 'photography', 'typography', 'cliché',
            'communication', 'modernism', 'vision', 'cognition',
            'composition', 'detail', 'programming', 'pop-culture',
            'finance', 'design', 'vernacular', 'revival', 'thinking', 'beauty', 'perception',
            'verticalisation', 'improvisation', 'creation', 'philosophy',
            'semiotics', 'semantics', 'syntax', 'reasoning', 'statement',
            'subsidies', 'intuition',
            'concept', 'construct', 'theory', 'theorem', 'meme', 'design theory',
                ],
        'design_theory_verb':[
                'quantification', 'digitisation', 'midification', 'industrialisation', 'personification',
                'deliberation', 'investigation',
                ],
        'design_theory_adj':[
            'critical', 'virtual', 'aesthetical', 'theoretical', 'problematic', 'erratic', 'random',
            'counter cultural', 'ethnic', 'cultural', 'investigative', 'vernacular', 'feminist',
            'expressive', 'modernist', 'techno', 'sustainable', '<#colors_elaborate#>', 'environmental',
            'formal', 'technological', 'cognitive', 'relevant', 'digital', 'intellectual',
            'recursive', 'pre-existing', 'lateral', 'material', 'immaterial',
            'gender oriented', 'scientific', 'intuitive', 'cognitive',
                ],
        'design_theory_adj_ness':[
                '“<#design_theory_adj#>-ness”'
                ],
        'design_work_form':    [
            'a first example of ',
            'an essay on',
            'a review of', 'a study of', 'a foray into', 'an overview of'
                ],
        'design_subtitle':    [
                '<#design_work_form#> <#design_theory#>',
                ],
        'design_title':    [
                '<#design_theory#>: <#design_subtitle#>',
                ],
        'design_verb_to_be':    ['is', 'is', 'is', 'is', 'is', 'is', 'was',
                 ],
        'design_questionstarters':['', '', '', '', 'why ', 'how '],
        'design_question': [
                '<#design_questionstarters#><#design_verb_to_be#> <#design_theory#> as <#design_theory_adj#> as <#design_names#> claims it <#design_verb_to_be#>?',
                '<#design_questionstarters#><#design_verb_to_be#> <#design_theory#> really all about <#design_theory_noun#>?',
                '<#design_questionstarters#><#design_verb_to_be#> <#design_theory#> just about <#design_theory_noun#>?',
                '<#design_questionstarters#><#design_verb_to_be#> <#design_theory#> still relevant in the light of <#design_theory#>?',
                '<#design_questionstarters#><#design_verb_to_be#> it hard to support <#design_theory#>?',
                'can <#design_theory#> be seen as a part of <#design_theory#>?',
                '<#design_questionstarters#><#design_verb_to_be#> <#design_technology#> really that <#design_theory_adj#>?',
                'what does <#design_names#> mean with “<#design_quote#>”?',
                'how does <#design_theory#> influence <#design_focus_discipline#>?',
                ],
        'design_question_more':[
                'but <#design_verb_to_be#> that really the case?',
                'but <#design_verb_to_be#> that true?',
                'how does that reflect on <#design_theory#>?',
                'does that affect the <#design_theory_verb#> of <#design_theory#>?',
                'exactly why <#design_verb_to_be#> <#design_theory#>?',
                ],
        'design_buzzword': [
                '<#design_theory_adj#> <#design_theory_noun#>',
                '<#design_theory_adj#> <#design_theory_noun#>',
                '<#design_theory_adj#> <#design_theory_noun#>',
                '<#design_theory_adj#> <#design_theory_noun#>',
                '<#design_theory_adj#> <#design_theory_noun#>',
                '<#design_theory_adj#> <#design_theory_noun#>',
                '<#design_theory_adj#> <#design_theory_noun#>',
                '<#design_theory_adj#> <#design_theory_noun#>',
                '<#design_theory_adj#> <#design_theory_noun#> in <#design_nounspecific#>',
                '<#design_theory_adj#> <#design_theory_noun#> in <#design_nounspecific#>',
                '<#design_theory_adj#> <#design_theory_noun#> in <#design_nounspecific#>',
                '<#design_theory_adj#> <#design_theory_noun#> in <#design_nounspecific#>',
                '<#design_theory_adj#> <#design_theory_noun#> in information <#design_nounspecific#>',
                '<#design_theory_adj#> <#design_theory_noun#>',
                '<#design_theory_adj#> <#design_theory_verb#>',
                ],
        'design_designer': [
                '<#design_names#>',
                ],
        'design_claim': [
                '<#design_buzzword#> promises <#design_theory#>',
                '<#design_buzzword#> offers insight into <#design_theory#>',
                '<#design_buzzword#> as such does not cover <#design_theory#>',
                '<#design_buzzword#> explained <#design_theory#>',
                '<#design_buzzword#> founds <#design_theory#>',
                '<#design_buzzword#> suppositions <#design_theory#>',
                '<#design_theory#> cannot replace <#design_theory#> as a <#design_theory_noun#>',
                '<#design_theory#> <#design_verb_to_be#> <#design_theory_adj#>',
                '<#design_theory#> <#design_verb_to_be#> <#design_theory_adj#>, not <#design_theory_adj#>',
                '<#design_buzzword#> as described by <#design_names#> <#design_verb_to_be#> not <#design_theory_adj#>',
                'the role of <#design_technology#> <#design_verb_to_be#> <#design_word_thingy#><#design_theory_adj#>',
                '<#design_theory#> puts <#design_theory_noun#> in a <#design_theory_adj#> perspective',
                'in <#design_sources#> <#design_names#> claimed that “<#design_quote#>”',
                'the work of <#design_names#> in <#design_location#> is an example of <#design_theory#>',
                'looking at <#design_theory#>, the <#design_theory_noun#> becomes <#design_theory_adj#>',
                'studying <#design_theory#>, the <#design_theory_noun#> becomes <#design_theory_adj#> instead',
                '<#design_work#> <#design_ref#> brings <#design_theory_noun#> into <#design_theory#>',
                '<#design_work#> shows <#design_theory_noun#> has a place in <#design_theory#>',
                '<#design_work#> is one of <#design_names#> most important projects',
                ],
        'design_ref':    [
                ', (<#design_names#>: <#^,refthing#>, <-randint(1900, 1950)->, <-randint(1950,2000)->)',
                ', (<#design_names#> on <#^,refthing#> <-randint(1950,2000)->)',
                ', (<#^,refthing#>, <-randint(1920,2000)->)',
                ],
        'refthing':['realism', 'language', 'philosophy', 'critical thinking', 'internet', "AI", "<#design_magazines#>" ],
        'design_counterclaim':    [
                'the problem with <#^,design_buzzword#>  is that <#design_claim#>',
                'rather, <#design_buzzword#> is explained by <#design_claim#>',
                'rather, <#design_claim#>',
                'but <#design_claim#>',
                'but how about <#design_work#> and <#design_work#>',
                'but how to explain <#design_work#> in the context of <#design_buzzword#>',
                'and <#design_claim#>',
                'on the other hand, <#design_claim#>',
                '<#design_question#>',
                '<#design_question#>',
                '<#design_question_more#>',
                ],
        'design_argument':    [
                '<#design_names#> stated: “<#design_claim#>”',
                '<#design_names#> wrote: “<#design_claim#>”',
                '<#design_names#> writes: “<#design_claim#>”',
                '<#design_names#> observes: “<#design_claim#>”',
                '<#design_names#> observed: “<#design_claim#>”',
                '<#design_names#> remarks: “<#design_claim#>”',
                '<#design_names#> proposed: “<#design_claim#>”',
                '<#design_names#> suggested: “<#design_claim#>”',
                '<#design_names#> says about this: “<#design_work_description#>”',
                '<#design_names#> <#design_verb#> <#design_theory_adj_ness#>',
                ],
        'design_word_thingy':    [
                'merely ', 'sometimes ', 'never ', '', '', '', '', '', '', '', '',
                ],
        'design_word_thingy2':    [
                'enough ', 'anymore ', '', '', '', '', '', '', '', '',
                ],
        'design_verb':    [
                'strongly believed in',
                'liked the idea of',
                'publicly supported',
                'seriously considered',
                ],
        'design_conclusion':[
                'later <#design_names#> proved <#design_theory_noun#> <#design_verb_to_be#> <#design_theory#>',
                'current developments in <#design_technology#> point to the contrary',
                'an interaction with <#design_theory#> is necessary',
                '<#design_theory#> <#design_verb_to_be#> about <#design_theory_noun#>',
                '<#design_theory#> certainly <#design_verb_to_be#> not just <#design_theory_adj#>',
                '<#design_counterclaim#>',
                '<#design_counterclaim#>',
                '<#design_counterclaim#>',
                '<#design_claim#>',
                '<#design_claim#>',
                '<#design_claim#>',
                ],
        'design_quote_stopper':    [
                '', '', '', '', '', '', '', '',
                '', '', '', '', '', '', '', '',
                ' [...]',
                ' [sic]',
                ' [ed.]',
                ],
        'design_quote_starter':    [
                '', '', '', '', '', '', '', '',
                '', '', '', '', '', '', '', '',
                '[it seems] ', '[I think] ' , '[it follows] ', '[assume] '
                ],
        'design_quote_infrequent':[
                '<#design_theory_noun#> is dead',
                '<#dibbi=design_theory_noun#><#dibbi#> is <#dibbi#> is <#dibbi#>',
                ],
        'design_quote_glue':['is like', 'was', 'is not at the same as', 'can be compared to', 'should be treated the same as'],
        'design_quote':[
                "I don’t like <#design_technology#>",
                "I hate <#design_technology#>",
                'you can’t compare <#design_theory_noun#> with <#design_theory_noun#>',
                '<#design_quote_infrequent#>',
                '<#design_quote_infrequent#>',
                'my take on that was always that <#design_theory#>',
                'I always said that <#design_theory#>',
                #'I don�t think that <#design_theory#> is like <#odd_action#><#design_quote_stopper#>',
                #'I like <#odd_action#>',
                #'<#design_technology#> is <#odd_action#>',
                #'I like <#odd_action#>',
                #'<#design_technology#> is <#odd_action#>',
                #'I like <#odd_action#>',
                #'<#design_technology#> is <#odd_action#>',
                #'I like <#odd_action#>',
                #'<#design_technology#> is <#odd_action#>',
                '<#design_theory#> is nonsense',
                #'<#design_quote_starter#>that <#design_theory#> <#design_quote_glue#> <#odd_action#><#design_quote_stopper#>',
                '<#design_quote_starter#>that <#design_claim#> and <#design_claim#><#design_quote_stopper#>',
                '<#design_quote_starter#>that <#design_theory#> <#design_quote_glue#> <#design_theory_adj#><#design_quote_stopper#>',
                '<#design_quote_starter#><#design_theory_noun#> <#design_verb_to_be#> <#design_theory_noun#><#design_quote_stopper#>',
                '<#design_quote_starter#><#design_theory_noun#> <#design_verb_to_be#> all about <#design_theory_noun#><#design_quote_stopper#>',
                ],
        'design_technology':[
                'desktop-publishing', 'critical thought', 'early <#design_theory_noun#>' , 'late <#design_theory_noun#>'
                'movable type', 'breathmints', 'information design',
                'language', 'the internet', 'the web', 'the marketplace', 'Apple Macintosh', 'the digital tool',
                "responsive", "IOT", "the dark web", "rectangles"
                ],
        'design_interjection':    [
            #    '', '', '', '', '', '', '', '', '',
                ', <#design_names#> said as much in <-randint(1900,1950)->,',
                ', <#design_theory_adj#> itself does not explain it,',
                ', without his knowledge,'
                ],
        'design_glue':    [
                '', '', '', '', '', '', '', '', '', '',
                'so ', 'therefore ', 'but ', 'eventhough ', 'though ', 'and ', 'rather ',
                ],
        'design_sentencetest':[
            '<#design_claim#>, <#design_glue#> <#design_claim#><#design_interjection#>, <#design_glue#> <#design_conclusion#>',
            ],
        }


if __name__ == "__main__":
    keys = content.keys()
