/*
 * SPDX-FileCopyrightText: 2006-2021 Istituto Italiano di Tecnologia (IIT)
 * SPDX-License-Identifier: BSD-3-Clause
 */

// Autogenerated by Thrift Compiler (0.14.1-yarped)
//
// This is an automatically generated file.
// It could get re-generated if the ALLOW_IDL_GENERATION flag is on.

#include <MultipleAnalogSensorsMetadata.h>

#include <yarp/os/idl/WireTypes.h>

// getMetadata helper class declaration
class MultipleAnalogSensorsMetadata_getMetadata_helper :
        public yarp::os::Portable
{
public:
    MultipleAnalogSensorsMetadata_getMetadata_helper() = default;
    bool write(yarp::os::ConnectionWriter& connection) const override;
    bool read(yarp::os::ConnectionReader& connection) override;

    class Command :
            public yarp::os::idl::WirePortable
    {
    public:
        Command() = default;
        ~Command() override = default;

        bool write(yarp::os::ConnectionWriter& connection) const override;
        bool read(yarp::os::ConnectionReader& connection) override;

        bool write(const yarp::os::idl::WireWriter& writer) const override;
        bool writeTag(const yarp::os::idl::WireWriter& writer) const;
        bool writeArgs(const yarp::os::idl::WireWriter& writer) const;

        bool read(yarp::os::idl::WireReader& reader) override;
        bool readTag(yarp::os::idl::WireReader& reader);
        bool readArgs(yarp::os::idl::WireReader& reader);
    };

    class Reply :
            public yarp::os::idl::WirePortable
    {
    public:
        Reply() = default;
        ~Reply() override = default;

        bool write(yarp::os::ConnectionWriter& connection) const override;
        bool read(yarp::os::ConnectionReader& connection) override;

        bool write(const yarp::os::idl::WireWriter& writer) const override;
        bool read(yarp::os::idl::WireReader& reader) override;

        SensorRPCData return_helper{};
    };

    using funcptr_t = SensorRPCData (*)();
    void call(MultipleAnalogSensorsMetadata* ptr);

    Command cmd;
    Reply reply;

    static constexpr const char* s_tag{"getMetadata"};
    static constexpr size_t s_tag_len{1};
    static constexpr size_t s_cmd_len{1};
    static constexpr size_t s_reply_len{10};
    static constexpr const char* s_prototype{"SensorRPCData MultipleAnalogSensorsMetadata::getMetadata()"};
    static constexpr const char* s_help{
        "Read the sensor metadata necessary to configure the MultipleAnalogSensorsClient device."
    };
};

// getMetadata helper class implementation
bool MultipleAnalogSensorsMetadata_getMetadata_helper::write(yarp::os::ConnectionWriter& connection) const
{
    return cmd.write(connection);
}

bool MultipleAnalogSensorsMetadata_getMetadata_helper::read(yarp::os::ConnectionReader& connection)
{
    return reply.read(connection);
}

bool MultipleAnalogSensorsMetadata_getMetadata_helper::Command::write(yarp::os::ConnectionWriter& connection) const
{
    yarp::os::idl::WireWriter writer(connection);
    if (!writer.writeListHeader(s_cmd_len)) {
        return false;
    }
    return write(writer);
}

bool MultipleAnalogSensorsMetadata_getMetadata_helper::Command::read(yarp::os::ConnectionReader& connection)
{
    yarp::os::idl::WireReader reader(connection);
    if (!reader.readListHeader()) {
        reader.fail();
        return false;
    }
    return read(reader);
}

bool MultipleAnalogSensorsMetadata_getMetadata_helper::Command::write(const yarp::os::idl::WireWriter& writer) const
{
    if (!writeTag(writer)) {
        return false;
    }
    if (!writeArgs(writer)) {
        return false;
    }
    return true;
}

bool MultipleAnalogSensorsMetadata_getMetadata_helper::Command::writeTag(const yarp::os::idl::WireWriter& writer) const
{
    if (!writer.writeTag(s_tag, 1, s_tag_len)) {
        return false;
    }
    return true;
}

bool MultipleAnalogSensorsMetadata_getMetadata_helper::Command::writeArgs(const yarp::os::idl::WireWriter& writer [[maybe_unused]]) const
{
    return true;
}

bool MultipleAnalogSensorsMetadata_getMetadata_helper::Command::read(yarp::os::idl::WireReader& reader)
{
    if (!readTag(reader)) {
        return false;
    }
    if (!readArgs(reader)) {
        return false;
    }
    return true;
}

bool MultipleAnalogSensorsMetadata_getMetadata_helper::Command::readTag(yarp::os::idl::WireReader& reader)
{
    std::string tag = reader.readTag();
    if (reader.isError()) {
        return false;
    }
    if (tag != s_tag) {
        reader.fail();
        return false;
    }
    return true;
}

bool MultipleAnalogSensorsMetadata_getMetadata_helper::Command::readArgs(yarp::os::idl::WireReader& reader)
{
    if (!reader.noMore()) {
        reader.fail();
        return false;
    }
    return true;
}

bool MultipleAnalogSensorsMetadata_getMetadata_helper::Reply::write(yarp::os::ConnectionWriter& connection) const
{
    yarp::os::idl::WireWriter writer(connection);
    return write(writer);
}

bool MultipleAnalogSensorsMetadata_getMetadata_helper::Reply::read(yarp::os::ConnectionReader& connection)
{
    yarp::os::idl::WireReader reader(connection);
    return read(reader);
}

bool MultipleAnalogSensorsMetadata_getMetadata_helper::Reply::write(const yarp::os::idl::WireWriter& writer) const
{
    if (!writer.isNull()) {
        if (!writer.writeListHeader(s_reply_len)) {
            return false;
        }
        if (!writer.write(return_helper)) {
            return false;
        }
    }
    return true;
}

bool MultipleAnalogSensorsMetadata_getMetadata_helper::Reply::read(yarp::os::idl::WireReader& reader)
{
    if (!reader.readListReturn()) {
        return false;
    }
    if (reader.noMore()) {
        reader.fail();
        return false;
    }
    if (!reader.read(return_helper)) {
        reader.fail();
        return false;
    }
    return true;
}

void MultipleAnalogSensorsMetadata_getMetadata_helper::call(MultipleAnalogSensorsMetadata* ptr)
{
    reply.return_helper = ptr->getMetadata();
}

// Constructor
MultipleAnalogSensorsMetadata::MultipleAnalogSensorsMetadata()
{
    yarp().setOwner(*this);
}

SensorRPCData MultipleAnalogSensorsMetadata::getMetadata()
{
    if (!yarp().canWrite()) {
        yError("Missing server method '%s'?", MultipleAnalogSensorsMetadata_getMetadata_helper::s_prototype);
    }
    MultipleAnalogSensorsMetadata_getMetadata_helper helper{};
    bool ok = yarp().write(helper, helper);
    return ok ? helper.reply.return_helper : SensorRPCData{};
}

// help method
std::vector<std::string> MultipleAnalogSensorsMetadata::help(const std::string& functionName)
{
    bool showAll = (functionName == "--all");
    std::vector<std::string> helpString;
    if (showAll) {
        helpString.emplace_back("*** Available commands:");
        helpString.emplace_back(MultipleAnalogSensorsMetadata_getMetadata_helper::s_tag);
        helpString.emplace_back("help");
    } else {
        if (functionName == MultipleAnalogSensorsMetadata_getMetadata_helper::s_tag) {
            helpString.emplace_back(MultipleAnalogSensorsMetadata_getMetadata_helper::s_prototype);
            helpString.emplace_back(MultipleAnalogSensorsMetadata_getMetadata_helper::s_help);
        }
        if (functionName == "help") {
            helpString.emplace_back("std::vector<std::string> help(const std::string& functionName = \"--all\")");
            helpString.emplace_back("Return list of available commands, or help message for a specific function");
            helpString.emplace_back("@param functionName name of command for which to get a detailed description. If none or '--all' is provided, print list of available commands");
            helpString.emplace_back("@return list of strings (one string per line)");
        }
    }
    if (helpString.empty()) {
        helpString.emplace_back("Command not found");
    }
    return helpString;
}

// read from ConnectionReader
bool MultipleAnalogSensorsMetadata::read(yarp::os::ConnectionReader& connection)
{
    yarp::os::idl::WireReader reader(connection);
    reader.expectAccept();
    if (!reader.readListHeader()) {
        reader.fail();
        return false;
    }

    std::string tag = reader.readTag();
    bool direct = (tag == "__direct__");
    if (direct) {
        tag = reader.readTag();
    }
    while (!reader.isError()) {
        if (tag == MultipleAnalogSensorsMetadata_getMetadata_helper::s_tag) {
            MultipleAnalogSensorsMetadata_getMetadata_helper helper;
            if (!helper.cmd.readArgs(reader)) {
                return false;
            }

            helper.call(this);

            yarp::os::idl::WireWriter writer(reader);
            if (!helper.reply.write(writer)) {
                return false;
            }
            reader.accept();
            return true;
        }
        if (tag == "help") {
            std::string functionName;
            if (!reader.readString(functionName)) {
                functionName = "--all";
            }
            auto help_strings = help(functionName);
            yarp::os::idl::WireWriter writer(reader);
            if (!writer.isNull()) {
                if (!writer.writeListHeader(2)) {
                    return false;
                }
                if (!writer.writeTag("many", 1, 0)) {
                    return false;
                }
                if (!writer.writeListBegin(BOTTLE_TAG_INT32, static_cast<uint32_t>(help_strings.size()))) {
                    return false;
                }
                for (const auto& help_string : help_strings) {
                    if (!writer.writeString(help_string)) {
                        return false;
                    }
                }
                if (!writer.writeListEnd()) {
                    return false;
                }
            }
            reader.accept();
            return true;
        }
        if (reader.noMore()) {
            reader.fail();
            return false;
        }
        std::string next_tag = reader.readTag();
        if (next_tag.empty()) {
            break;
        }
        tag.append("_").append(next_tag);
    }
    return false;
}
