from .context import gpytoolbox as gpy
from .context import numpy as np
from .context import unittest

class TestAngleDefect(unittest.TestCase):

    def test_uniform_grid(self):
        n = 40
        v,f = gpy.regular_square_mesh(n)

        k = gpy.angle_defect(v,f)

        self.assertTrue(np.isclose(k,0.).all())


    def test_bunny_oded(self):
        v,f = gpy.read_mesh("test/unit_tests_data/bunny_oded.obj")
        k = gpy.angle_defect(v,f)

        k_gt = np.array([-4.50508955e-02, -8.81930581e-02, -1.34181183e-01,  5.53685886e-03,
       -4.61576667e-02, -9.97077470e-02,  8.22479449e-02, -1.26371762e-01,
        3.50643732e-02,  1.44790198e-01, -1.00967449e-01,  7.16458595e-02,
        4.34571955e-02, -1.02223941e-01,  1.78033819e-02,  3.02651541e-02,
        1.67097539e-01, -1.89272140e-02,  2.43204679e-02,  2.72978178e-02,
       -5.88436064e-02,  1.32716180e-02,  6.52627121e-02,  5.63111012e-02,
       -1.31128853e-02, -3.51629618e-02,  6.51949025e-02,  9.62482355e-02,
        6.26951410e-02, -1.64585323e-02, -1.98575754e-03,  1.44137219e-02,
        1.34424473e-02,  5.60608431e-02, -5.85730183e-02, -2.84949346e-02,
        9.97461658e-03,  1.22637151e-02,  2.67738979e-02, -1.23532133e-01,
       -7.75691005e-03,  1.25413890e-02,  2.21293515e-02,  7.66831103e-03,
       -8.77726782e-03, -3.18160725e-02, -1.15323671e-03,  4.26924251e-02,
        8.09061553e-02,  1.11350241e-01,  9.82438971e-02, -2.54758750e-02,
       -1.56629237e-03, -4.36315150e-03, -2.17026040e-02, -2.73760127e-02,
       -1.58517802e-02,  7.14756894e-03, -1.31098687e-01, -4.91582116e-02,
        1.80296814e-02,  7.29430797e-02,  1.92666826e-02,  2.86232211e-02,
       -2.03549427e-01,  4.37533192e-03, -2.48898569e-04, -3.04423100e-02,
       -2.05520191e-02,  8.67351742e-03, -1.65367710e-02, -3.44068781e-02,
       -5.90033156e-02, -2.54384527e-02,  3.59904274e-02,  7.02243368e-02,
        1.08447590e-01,  1.42971941e-01,  4.76854815e-02,  4.07506015e-03,
       -4.01088776e-03,  3.15346322e-03,  4.14229132e-03,  1.51772278e-04,
       -1.15188679e-02,  3.15639484e-02, -4.42149187e-02,  3.77256788e-03,
       -6.38441475e-02, -4.17445170e-02,  2.43194590e-02,  4.35660597e-02,
        4.27167645e-02,  1.02794104e-02, -4.94955171e-01,  6.88789896e-04,
        1.35566413e-02, -1.61694403e-02,  7.81565138e-02,  9.83250539e-03,
       -6.24305044e-03,  3.07684970e-03,  7.53438041e-03,  1.84741251e-02,
        1.41217323e-01,  3.97209023e-02, -3.39598559e-03,  9.82904382e-04,
        3.98868568e-02,  3.39528721e-02,  1.39193723e-01,  2.60081780e-01,
        1.67168961e-02,  9.65755979e-04, -8.02124412e-02, -2.02531826e-03,
       -2.88234153e-03, -4.74245453e-03, -6.87421574e-03,  4.22550497e-02,
       -1.30672573e-02,  6.59596461e-03, -2.54839622e-02, -9.52354466e-04,
        6.62805462e-03, -3.08876815e-02, -1.11537885e-02,  2.17406404e-02,
        3.37740766e-02,  2.06282232e-02,  1.73031304e-02,  5.65591195e-03,
       -1.40807583e-01, -3.29152638e-02,  2.85609713e-02, -8.80757926e-03,
       -2.30525621e-02, -2.28003454e-02,  2.61926883e-02,  7.70877243e-03,
        5.25430667e-04, -4.39987660e-02,  6.59152375e-02, -9.03035161e-02,
       -3.06635881e-02,  8.91663410e-02,  1.34931650e-02,  1.31593700e-02,
        7.00548938e-02,  2.74798205e-02,  1.57402692e-01,  4.84255871e-02,
        3.84490710e-03,  1.12080704e-02,  3.48398423e-03,  1.37941744e-02,
        9.37654787e-03,  4.95900704e-04,  1.68163552e-02, -6.30903951e-03,
       -7.13427379e-02, -2.11002897e-03,  6.14164665e-03, -2.41555368e-02,
       -7.00014046e-03,  5.48475792e-03,  1.46093371e-02, -1.42255777e-02,
       -2.60494251e-03,  1.70332098e-02,  2.63418306e-02,  2.99809311e-02,
        1.71861177e-02,  1.05409572e-02,  1.93163694e-03, -1.91793343e-01,
       -1.05744187e-02, -2.34180579e-04, -2.71481115e-02, -5.53260494e-03,
       -1.24569453e-03, -7.63670934e-04, -7.42589413e-04, -1.28734641e-02,
        1.88501659e-02,  1.22861015e-02, -3.98171662e-02,  5.77248081e-03,
        1.42606928e-01, -2.95131214e-02,  3.20519895e-02,  1.33405615e-01,
        6.80295252e-03,  4.43966703e-02,  5.94101445e-02,  7.33636364e-02,
        4.85420925e-02,  1.67586246e-01, -1.31471078e-01,  6.11631031e-03,
        1.75222275e-02,  7.93063159e-03, -1.88306002e-03,  2.25607965e-03,
       -1.94601876e-04,  4.69351951e-03,  2.43914890e-02,  1.10341577e-01,
        5.74121518e-03,  2.07399921e-02, -2.28264256e-02, -2.69047953e-02,
       -5.36553007e-03,  2.77542800e-02,  1.70957945e-02, -5.37299119e-03,
       -2.53219678e-01,  2.00600370e-02,  7.58552698e-03,  1.06058670e-02,
        4.78569390e-02,  6.08075314e-02, -2.27622021e-03,  2.79664662e-02,
       -8.08229601e-03, -1.41427539e-01, -8.31043248e-04, -2.46564102e-06,
        2.10923489e-02, -7.52279248e-03,  1.13035752e-02,  2.45948186e-02,
       -6.29671115e-03, -5.44520490e-02,  7.51201975e-03, -2.26971739e-03,
        9.71051313e-03, -5.17145078e-02, -3.69271172e-02, -8.42060637e-03,
        1.06852148e-01,  1.35970734e-02,  2.97615535e-04,  1.81213541e-02,
       -5.00827997e-02,  3.55121265e-02,  1.26676589e-01,  2.79768138e-02,
        2.26801687e-01,  1.05802990e-01, -4.00730609e-01, -2.63434002e-03,
        1.50354051e-02, -1.70438317e-03, -1.53751426e-03,  1.26486957e-03,
        8.39039745e-03,  3.14255465e-02,  9.77885156e-04,  2.56743411e-02,
       -3.72368035e-02, -9.47090671e-03,  1.18402811e-02, -1.21734251e-02,
        4.32773306e-02,  5.82966232e-02, -1.58652920e-03, -2.25660701e-02,
        7.99262206e-03, -5.21389869e-02,  2.35103106e-01,  2.22353791e-02,
        5.55437597e-02,  2.53656017e-02,  3.53713729e-02,  8.88589202e-03,
        1.78647848e-02, -1.08299732e-02,  2.79329241e-02, -1.70358747e-02,
        3.18001671e-03, -2.14110620e-01, -1.84422992e-03, -1.50012814e-04,
       -1.25658925e-02, -2.31514734e-03, -1.49872801e-03, -2.36252253e-02,
        2.75470098e-02,  5.51174335e-02,  8.20679891e-03,  1.32017386e-02,
        3.86939604e-02,  2.65903494e-02,  6.08081363e-02, -9.46243656e-02,
       -1.03172016e-02,  2.06521359e-01,  5.12010733e-04,  4.45674816e-02,
        6.15866676e-02, -2.20595710e-01,  2.31583351e-01,  4.12630373e-02,
        1.13787333e-01,  1.96311685e-01,  5.88423992e-02, -6.21818426e-02,
        2.71135696e-02,  1.37726594e-02,  4.72466538e-03, -7.68481012e-04,
        3.21508265e-02,  4.82065717e-03,  3.11627729e-02,  1.59291632e-02,
        3.83579132e-03,  9.42869208e-03, -9.52958315e-02,  1.37046641e-02,
        1.03709175e-02, -7.02264768e-04, -7.75553036e-03, -7.88317287e-03,
       -8.05797898e-03, -7.49122835e-02, -2.01231453e-02,  3.17148157e-02,
        6.28461802e-02, -9.18719027e-03,  4.08774781e-02,  5.62069343e-03,
        9.50569989e-03,  1.32798925e-02,  3.75152787e-02,  2.83901298e-02,
        1.31455217e-01, -2.46512371e-02, -1.21600260e-02,  4.93959603e-02,
        5.93883175e-03, -3.24820204e-02, -4.23420621e-03, -2.05077207e-02,
        2.52890680e-02,  8.09712172e-03, -3.59225617e-03,  1.71360806e-02,
       -2.30968213e-03,  2.40707498e-02, -2.10861707e-02, -1.36544586e-02,
        1.05168401e-01, -3.37727108e-04, -4.83978867e-03, -2.39901043e-02,
       -1.68699954e-02, -1.04444011e-03,  3.07555616e-03, -2.27383821e-03,
        4.66612906e-02,  1.12090342e-02,  7.98256134e-05,  3.43409821e-01,
        9.83654913e-02,  8.92924977e-02,  5.60878905e-02,  2.15021063e-02,
        6.19192826e-02,  1.32333673e-02,  7.18958465e-03,  1.17906741e-02,
        4.40510450e-03,  4.93340366e-03,  6.43555018e-03,  8.07859332e-03,
        1.49104339e-02, -4.34395527e-03,  2.97061339e-02, -3.96704838e-03,
        4.39846102e-03,  6.22159548e-03, -3.36497801e-02, -1.28048954e-02,
       -2.37979406e-03,  3.54858606e-03, -9.06494559e-03,  1.18733592e-02,
        5.95642295e-03, -1.67794302e-02, -1.84548161e-02,  2.99916620e-03,
       -1.21827223e-02, -2.50479118e-03,  1.73505829e-02,  8.12600053e-02,
        2.13556365e-02,  3.93558142e-02,  4.10227663e-02,  1.85430155e-01,
       -4.16872698e-03,  2.30219426e-02,  2.06925317e-02,  8.65766680e-03,
       -8.72422474e-03, -8.93790980e-03,  5.66206478e-03,  7.47185211e-03,
        1.21089319e-02,  2.41185726e-02, -2.56751700e-02, -1.20286449e-02,
        1.12918668e-02,  7.97417330e-03, -6.91280225e-02, -2.05686507e-02,
        3.45352982e-02, -2.50682629e-02, -3.41876372e-02,  2.79964986e-02,
        4.06599541e-02, -3.27783030e-02, -5.35737055e-03, -6.08739868e-03,
       -3.90683588e-03, -1.94900548e-02, -1.01647196e-02, -9.18292344e-03,
       -1.13060679e-01, -4.50711066e-02,  2.51482279e-02, -1.13465562e-01,
        1.39971315e-02, -2.39895265e-01,  9.02664660e-05,  4.33081406e-04,
        9.74156523e-04, -1.01574028e-03,  1.73327654e-03,  7.65218693e-03,
        1.24436820e-02,  4.09019246e-03,  8.32367222e-04, -1.41346521e-03,
        4.51085343e-02,  1.91146412e-02, -2.36178622e-02,  4.69102821e-02,
       -5.34896973e-03, -3.52344479e-02,  2.93129097e-02,  2.73835882e-02,
        1.70637742e-02,  5.27109751e-02, -2.29278588e-03, -1.27975712e-03,
       -1.91760354e-02, -6.28337146e-02, -1.12142722e-01, -6.41937102e-02,
        8.07908386e-05,  3.90023069e-03, -2.07510276e-04,  4.56323759e-02,
        1.01347463e-01,  1.61920229e-02,  9.38702908e-02,  4.02956543e-02,
       -2.32133182e-02, -2.65291645e-02, -2.00834570e-02, -9.84812720e-03,
       -7.11398124e-03,  4.59933134e-02,  2.86113673e-02, -1.39434738e-02,
        4.09981227e-03, -1.07640141e-02,  8.85194446e-03,  1.26065200e-03,
        9.90396167e-02,  1.62607339e-04,  5.91061142e-02,  7.69404098e-02,
        4.62587306e-02, -4.75828487e-02,  2.03605168e-02, -1.40380107e-02,
        4.46096861e-02, -4.43057507e-02, -1.80156987e-01, -4.65163106e-03,
       -1.25959785e-02, -2.51453664e-02, -1.01079468e-01,  2.90170843e-03,
       -8.48643261e-03, -1.54439975e-03, -1.57915608e-02,  1.18804067e-02,
       -8.63621552e-02, -5.30571103e-03,  3.09502413e-03,  6.31502248e-03,
        1.46312934e-02,  7.85430553e-03, -4.28782503e-03,  4.83672048e-03,
       -1.20296622e-02, -2.22367649e-03,  1.36589181e-02,  2.01741315e-03,
        5.89776515e-04, -1.99004949e-02,  9.10371693e-03,  1.10462513e-02,
        2.05895926e-02, -4.05869978e-03, -1.20831008e-02,  1.95642885e-02,
        7.31973570e-02, -6.74380299e-02,  1.02893888e-02, -1.62335811e-02,
        1.63971316e-04, -6.59006961e-03,  4.31668006e-03, -4.58734167e-02,
        1.52489369e-04, -1.25365010e-02,  3.38184427e-05,  3.87306977e-02,
       -2.02920769e-02, -8.00239738e-02,  3.78709995e-02, -4.32406991e-02,
        6.51600046e-03,  8.70352183e-03, -1.76298377e-02,  7.91216157e-03,
        6.16076590e-03, -7.46375270e-03, -5.18229668e-03,  4.52008267e-02,
        8.69873643e-03,  6.59380314e-02,  3.53914535e-02, -8.37651521e-03,
        1.03611382e-02, -4.61664009e-03, -4.20825832e-05,  3.00763276e-02,
       -1.10809394e-02, -1.94938112e-02, -3.65487412e-03,  1.86273270e-02,
       -6.32775696e-02, -1.49783823e-02, -3.33604220e-02,  4.93588331e-02,
       -8.24796718e-03,  5.00562621e-02, -1.31374061e-01,  5.38502313e-03,
       -1.66917003e-02, -9.37805036e-03, -7.88838890e-03,  1.91924459e-02,
        2.59583114e-01, -1.06656550e-02,  2.48717660e-03,  1.76693785e-02,
        7.86010275e-03,  3.94372027e-02,  6.25043938e-04,  1.02747001e-02,
        6.41270163e-03, -1.36562810e-02, -3.36783064e-02, -5.81278355e-03,
       -2.30275326e-02,  9.71637178e-02, -1.03976615e-02,  2.43661592e-02,
        5.05562125e-02,  5.76529991e-03,  2.44830735e-02,  1.04907949e-03,
        1.66944644e-02,  3.49888926e-02,  7.80173759e-02,  2.62630254e-02,
       -9.46841282e-03, -3.33032624e-02,  2.72227882e-03, -1.27256871e-01,
       -6.72762057e-05, -2.05144010e-04,  5.99482233e-02,  1.53961597e-02,
       -1.39505588e-05, -2.64426549e-03, -3.62087933e-04, -2.78434880e-01,
       -3.36264114e-02, -8.87152845e-02, -2.93756911e-02, -2.00687867e-01,
        7.09439153e-03,  2.69976972e-02,  5.02287583e-02, -2.10808722e-02,
       -1.75895488e-02,  1.50248381e-02, -1.93139637e-02,  1.40981982e-02,
        1.09405926e-02, -4.36589537e-03, -1.20835775e-02,  7.72453065e-04,
       -4.83747995e-02,  6.32216563e-03,  7.69658876e-02,  2.77172485e-02,
       -2.71224372e-03,  9.89641037e-03,  2.21592390e-03, -2.62610587e-02,
       -6.21841407e-02, -2.40735044e-02, -3.66607386e-03,  4.78375862e-02,
       -1.34129302e-02, -7.87737893e-02, -2.74840141e-02,  6.70820895e-04,
       -8.82369813e-03, -3.60961537e-01,  2.37844411e-02, -7.63267885e-03,
        2.30532102e-02, -2.75755526e-02,  7.25351742e-03,  7.88859472e-04,
        3.69960885e-03,  3.99185543e-03,  4.37186384e-04,  9.33627507e-03,
        8.50986122e-03,  2.31217741e-02,  3.68700763e-03,  2.32127712e-02,
        1.08157894e-02, -1.65145570e-02, -4.21515364e-02, -1.60268258e-02,
        2.48844600e-02, -1.62776991e-02, -4.18612919e-02, -4.74932097e-03,
        2.77598756e-02, -7.05100184e-02, -5.77623934e-02, -1.86471384e-02,
       -3.26194320e-02, -4.46619635e-03, -3.60156623e-04, -8.67459493e-03,
       -7.10911772e-04, -1.11310836e-01,  4.02903417e-02, -1.77817704e-04,
        1.71424196e-04,  3.74331351e-02,  5.07761948e-02, -5.33380861e-05,
       -1.00296040e-02,  1.15107381e-02,  1.75489839e-02, -2.75377619e-02,
        8.72772771e-02,  3.27844108e-02, -1.54230529e-02, -1.77137809e-02,
       -2.27167650e-02, -1.38131566e-03,  5.81486932e-02, -1.33351752e-02,
        2.85324109e-02,  1.15774993e-02, -5.67416096e-03,  9.45424784e-03,
       -3.01496930e-03, -2.51184015e-02, -2.97991537e-02,  2.24314404e-03,
       -2.13798951e-03, -3.07118146e-03,  4.22179213e-03,  6.03013252e-03,
       -6.10407776e-03,  3.81827522e-02, -8.24726230e-03,  4.37649385e-02,
       -2.47654119e-03, -2.89147423e-03, -9.82760076e-03, -5.98828318e-04,
        6.16626022e-03, -4.12047046e-02, -7.73792939e-03, -4.20469089e-01,
        4.87914416e-03, -8.03457806e-02, -1.00678952e-02,  1.38501814e-02,
       -4.97785988e-04, -1.40742340e-04,  6.08488450e-03,  1.37693202e-02,
        2.14762794e-02,  8.28989523e-03,  1.70208226e-02,  4.61250162e-02,
        2.17496719e-02,  7.13676856e-03,  1.14309352e-02, -1.15114598e-02,
       -2.34463361e-02, -1.39805458e-02, -4.12812231e-02,  9.63175716e-02,
        6.28107038e-02, -9.36393203e-03,  1.79709949e-01, -1.17778143e-01,
       -1.58974203e-02,  4.41363699e-02, -3.39995040e-02, -1.03821602e-02,
       -3.24492403e-04, -1.25969338e-03,  2.78827395e-02,  2.70767616e-01,
       -5.70462086e-05, -1.46189481e-06, -1.06901427e-01, -1.55416091e-01,
       -4.11099412e-04,  3.53527509e-05,  3.56178085e-02,  2.59980971e-01,
        8.44947434e-02, -4.55695679e-05, -2.69712742e-02, -5.28059045e-02,
        7.88315077e-04,  1.03173863e-03, -1.11895310e-02,  3.30935929e-02,
       -2.51576960e-02,  8.53866870e-02, -1.97165577e-02, -9.47061106e-04,
       -1.89417523e-02,  6.12409363e-02, -2.43020414e-02, -7.86595769e-03,
       -4.78941280e-03,  4.40337753e-03,  3.63239867e-02,  2.89092940e-02,
       -2.65712436e-02, -7.11462509e-02,  6.68039268e-02,  2.55365018e-02,
       -6.51315438e-02, -8.00914294e-02, -6.03132349e-02, -1.19287442e-02,
        2.89824200e-02, -2.12935656e-02, -1.23641561e-03, -1.44550036e-01,
       -9.33054245e-04, -5.11040405e-04,  7.09578906e-02,  5.79837946e-02,
        7.76066227e-02,  5.37848688e-02, -8.01632265e-03, -2.20617006e-03,
        1.63384763e-03,  9.91543827e-03,  2.09082209e-03,  4.37265124e-03,
        3.41814449e-03,  4.95088372e-03,  2.59131118e-02,  2.00483582e-02,
        7.50475345e-03, -1.68211098e-03, -3.08456975e-02,  2.98591148e-02,
        7.39980315e-03, -5.15881799e-03, -1.31665897e-02, -8.97771695e-03,
        1.43712941e-02, -1.23863184e-02,  1.22107228e-03, -9.41670685e-04,
       -5.81198856e-02,  2.09207615e-01, -9.44521757e-02,  8.53369219e-02,
        4.69874834e-02, -4.99356322e-05, -6.20400379e-06, -1.41992696e-04,
       -1.32569297e-05, -3.93271087e-04,  3.23309868e-02,  4.64237737e-02,
       -8.18021914e-05, -4.39168365e-04,  2.60787370e-03,  4.76605805e-02,
       -1.43965679e-03, -2.92986179e-03, -7.22075419e-03,  1.20143467e-02,
       -3.43426322e-03,  1.62928733e-02, -5.34311633e-02,  8.07272345e-02,
        8.78867470e-02,  1.76112094e-02,  4.86815818e-02, -2.41406923e-02,
       -1.30480872e-02, -7.75116866e-03,  7.19481512e-03,  1.40755438e-03,
        3.58390742e-02,  1.64224729e-02, -1.30437411e-02,  2.91107292e-03,
       -1.11059770e-02,  1.40420937e-02,  9.53667135e-03,  1.10202266e-01,
       -3.54453195e-03,  1.82727738e-02,  1.14923474e-02,  3.10070749e-01,
        7.35460454e-02, -1.18063948e-02,  6.73523415e-02, -7.42663727e-03,
       -9.99954327e-05, -3.71066457e-02,  1.29925852e-02,  1.85988590e-02,
        4.27916527e-02,  3.22741391e-01,  2.06676477e-01,  7.87921301e-02,
        5.69410936e-02,  6.67008389e-04,  1.69316870e-01,  1.57392295e-02,
       -1.36241978e-02, -5.91876625e-02,  3.42085310e-03,  6.23088689e-03,
        5.99914205e-03,  5.18354983e-03,  2.41208796e-02,  1.02933599e-02,
        4.25882803e-03,  3.73004426e-03,  6.02001543e-03,  1.00014816e-02,
       -1.45958071e-02, -1.49712288e-02,  3.28578670e-03,  4.54930540e-02,
       -1.15563790e-02, -5.01335849e-03,  7.33901804e-03,  3.12399242e-02,
        2.48390902e-02,  1.20207723e-01,  1.10573743e-02, -2.83081370e-02,
       -5.41070425e-03, -1.15675584e-02,  6.14077973e-02, -4.84389764e-02,
       -5.75578410e-05, -3.06428767e-05, -5.72864339e-05,  3.65091267e-05,
        6.46749201e-05, -6.81724322e-04,  3.59649379e-02,  3.34644408e-02,
       -2.57401294e-02, -1.46978394e-04, -2.88332999e-03,  2.65142310e-02,
        7.87507160e-02, -1.18666434e-02, -2.60625975e-02,  1.54180074e-02,
        1.27522602e-02, -3.59699448e-03,  2.05265702e-02, -2.49824913e-02,
        2.68584277e-02, -7.79161502e-03,  5.55835075e-03, -1.92571547e-02,
        1.90073903e-03, -5.02718421e-03, -3.90327698e-03,  4.41190395e-03,
        1.78470774e-02,  1.95296257e-02, -2.11369401e-04,  3.67676801e-02,
       -8.60634654e-03, -4.28928572e-02,  6.97132465e-03,  9.22213221e-03,
        4.26863946e-03,  8.66719884e-02,  1.34822410e-02,  6.76598424e-02,
        1.01435900e-01,  9.19743244e-02,  3.70449618e-03,  1.08092091e-01,
        3.32650835e-03,  2.41962717e-02,  4.38329885e-03,  2.76169529e-02,
        3.00023463e-01,  1.00572706e-01,  4.94598902e-02,  1.03365991e-02,
        4.17857567e-02,  2.48242219e-01,  1.98571333e-01,  1.91563033e-01,
       -3.50841594e-02, -1.32110936e-01,  1.54599631e-03,  4.63931064e-03,
        1.06663233e-02, -9.43737170e-04,  1.37570811e-02,  5.14649925e-02,
        2.12951547e-03,  7.06024736e-03,  9.93674706e-03,  7.87107978e-02,
        8.33262944e-03, -3.08584204e-02,  2.97665584e-02,  4.66649791e-02,
       -4.46762119e-03,  1.61567483e-04, -1.51684238e-01, -8.69310346e-03,
        4.14134383e-02,  5.32474376e-02,  2.57794137e-02, -2.35164813e-02,
       -4.38722577e-03,  7.11310965e-03, -3.58889080e-03,  4.81505698e-02,
       -1.32014660e-03, -7.15109873e-05, -1.13642146e-05,  9.71656647e-07,
       -1.21882835e-04, -1.98692491e-03, -5.06104613e-04, -8.28592411e-03,
        2.18434711e-02, -1.14159689e-02,  1.34155694e-02, -4.30649114e-02,
       -4.41398672e-02,  9.05364683e-02,  9.81245133e-03, -4.48552738e-02,
       -3.39613586e-02,  1.05431390e-02, -3.97961316e-02, -5.18177096e-02,
       -9.96052965e-02, -3.83287795e-02, -1.84393053e-02,  5.46487778e-02,
       -5.33297181e-03,  1.38578645e-02, -2.46595336e-03,  3.41727282e-03,
        2.77320282e-04, -4.09377918e-03, -7.56260333e-03, -1.06897210e-02,
        6.10295055e-02,  1.74601826e-02,  4.83095093e-03,  1.21700440e-02,
       -2.11166022e-02,  1.28255412e-01,  7.69163652e-02,  6.88931833e-02,
        2.05320977e-02, -5.51446854e-05,  1.07973216e-02, -3.09154265e-02,
       -4.11394723e-02, -1.36940306e-02, -4.89541573e-02,  2.60237497e-01,
       -7.84399868e-03, -1.57335770e-02,  3.68982976e-01,  1.04302201e-02,
        3.08037181e-01, -2.65025172e-03, -1.24837770e-02, -2.66684441e-01,
       -2.65190182e-02, -2.55500670e-02,  4.14748970e-04,  3.13670511e-02,
        1.07401068e-02,  8.92820790e-03,  1.81010090e-02,  1.06090272e-02,
        2.45736483e-02,  5.76072460e-03,  2.77225091e-03,  3.11919059e-02,
       -1.22893954e-02,  2.83918489e-02, -4.18655060e-04,  5.98492444e-03,
        7.68264904e-04,  6.07893797e-02,  5.80771306e-03, -1.58750055e-01,
        2.91207293e-04, -1.81314526e-02, -6.65638306e-03,  3.97953728e-03,
        1.30996100e-02, -3.86517999e-03,  4.97668354e-02, -3.95936791e-02,
       -7.37449265e-03, -2.17721900e-02, -1.14926015e-02,  1.83861118e-05,
       -4.98617237e-05,  2.02855534e-04,  1.20952274e-03, -2.31409249e-03,
       -1.28088679e-02, -4.68703505e-02,  3.30056994e-03,  7.66367860e-03,
       -1.73623409e-03,  3.89038300e-02, -8.26307022e-02,  2.82462563e-01,
        3.80780033e-02, -3.94865479e-02,  2.26971855e-03, -3.37906437e-02,
       -2.34798494e-02,  9.44289017e-03, -4.59895069e-03,  5.26190606e-03,
       -2.01549974e-02, -2.55016692e-03, -2.39261379e-02,  3.87944965e-03,
        2.87790456e-03, -1.09346838e-02, -1.80436331e-02, -2.18806950e-03,
        4.69218967e-03,  1.65050143e-03,  2.49202303e-03, -1.06017991e-02,
       -6.67180687e-02, -2.14985844e-02, -4.47705007e-02, -1.79081890e-02,
       -1.41141242e-01,  4.73836841e-02, -1.77787878e-02, -2.62507986e-03,
       -6.53641423e-03, -1.15360180e-02, -6.73127673e-02,  5.13688252e-02,
       -7.38397343e-01, -7.13640399e-02, -6.06243825e-02, -3.46560847e-02,
        1.48836958e-01, -5.91467620e-02, -3.41276345e-02,  7.21577382e-03,
        1.65144654e-01,  5.00516447e-03,  3.50721260e-03,  1.95436762e-03,
        3.63564426e-03,  4.41408813e-03,  7.90829323e-03,  4.27203253e-03,
        1.34229063e-02,  9.04428492e-03,  1.45555706e-02, -7.53867712e-03,
        9.16669155e-03,  5.28843770e-02,  1.51293807e-03,  1.50164884e-02,
        1.45609804e-02,  3.71958732e-03, -2.59240471e-02, -1.29041261e-02,
       -2.19086722e-01, -1.06216538e-02, -7.70570434e-03, -6.30487987e-03,
       -3.41748097e-02,  6.63625545e-03, -3.21122799e-03,  2.60688569e-02,
       -5.74114167e-03, -3.25061061e-03, -1.01285245e-03,  2.03497798e-04,
        5.43483064e-05,  3.91838005e-05, -3.37867423e-04, -1.69537518e-02,
        3.94038338e-02,  1.18956623e-02,  1.89610341e-02, -2.89884795e-03,
       -1.24733676e-02, -1.91966670e-02, -8.47628033e-02, -4.40144115e-02,
        8.34737594e-03,  2.03542612e-02,  7.75223080e-03, -2.18524769e-02,
       -3.73266124e-02, -9.98665570e-02,  9.42568661e-03, -7.60667623e-03,
       -1.20467862e-02, -2.03233974e-02, -3.94343198e-02, -8.96349941e-03,
       -1.65000986e-02, -2.63984077e-03,  6.85948137e-05, -4.68314648e-02,
       -2.37223958e-03,  3.37254181e-03,  1.69686723e-02,  3.01759992e-02,
        1.95863099e-02, -1.59417285e-03,  5.16190086e-02, -2.06586760e-01,
        1.68161613e-02,  1.06404961e-01,  2.17277474e-02,  4.50443263e-03,
       -6.50858269e-02,  3.85008579e-02,  4.79223830e-03,  4.66814247e-02,
       -6.89247319e-02, -4.61697123e-01, -2.55326582e-02, -4.45418837e-03,
       -3.81060040e-02,  2.34475345e-03, -1.20209921e-01, -1.65145767e-02,
        3.43015486e-04, -2.93736030e-03, -2.00296081e-02,  5.77109610e-03,
        5.05066739e-03,  1.09029919e-02,  3.61396584e-02,  1.11309329e-02,
        4.35887570e-03,  1.11734837e-02, -3.61475637e-05,  2.36997778e-03,
        4.04091282e-02,  8.60616674e-03,  2.19182737e-02,  8.22105966e-03,
        9.15168326e-03,  2.88785630e-04,  1.76444062e-02, -2.69438771e-03,
       -1.11518924e-02, -2.22157649e-03, -6.97541903e-02, -4.05678652e-02,
        5.08624424e-03,  1.72410551e-02,  6.05284388e-02, -1.90777530e-02,
       -2.46487023e-03, -2.22222032e-02, -6.53688927e-05,  2.03263738e-04,
       -1.78360540e-03,  3.50054806e-05,  6.25946869e-04, -1.37402137e-03,
        2.26084144e-02, -3.93319852e-02, -1.66581069e-02, -4.65786044e-02,
       -5.64977393e-05, -6.93280228e-03, -2.80861766e-03, -2.95358113e-02,
       -1.84160003e-02,  8.86374039e-02, -1.81886230e-03, -6.06089243e-03,
       -6.67677570e-04, -5.46665533e-02, -5.91211189e-02, -1.95104667e-02,
       -3.35097731e-01,  3.36759454e-03, -4.90625112e-03,  6.53399180e-02,
       -9.69186229e-03, -2.22867042e-02, -1.07171783e-02, -1.34205329e-02,
       -1.73395856e-02, -5.01166142e-03, -5.42543063e-03, -6.72492189e-02,
       -1.86557249e-03,  2.53289330e-02,  2.14086629e-02, -1.82584463e-02,
       -1.99818278e-01,  9.53983401e-02, -7.09357050e-02,  2.55640571e-01,
       -8.60063728e-02,  2.16346413e-02, -2.29824714e-03, -4.28477093e-03,
       -1.19550270e-02, -1.16130587e-02, -7.85148306e-03, -4.49636567e-02,
        2.73819433e-02, -4.02894400e-02, -7.78850851e-02, -2.24020851e-01,
       -3.36100366e-02, -3.64293609e-04, -6.38157186e-03,  4.39771312e-02,
        8.06230357e-03,  9.87271186e-03,  2.68021594e-02,  1.47487898e-02,
        1.88725613e-02,  5.67214905e-03,  1.17671786e-02,  2.02763768e-02,
        1.05007725e-02,  1.51781585e-02,  1.11971629e-02,  6.30290808e-03,
        2.13674852e-02,  9.43269851e-03,  2.98530694e-02, -2.18679361e-03,
        5.57212947e-04, -1.62268154e-03,  3.00215839e-02, -9.42559208e-02,
       -8.05001896e-03, -1.65820000e-02,  3.48656213e-02, -6.51744142e-03,
        3.04397822e-02, -3.32556264e-03, -3.76189312e-02, -1.02705898e-02,
       -3.41265959e-03, -4.87850027e-03, -1.65923466e-03, -4.71207972e-04,
        2.67562552e-04,  4.13445605e-02, -5.75992658e-04,  5.84545283e-02,
        1.46112879e-03,  1.48123526e-02,  7.25464594e-03,  8.33789915e-02,
       -8.72874766e-03,  5.74547347e-02, -5.48334798e-03, -7.35313919e-03,
       -5.10984939e-02, -3.15003607e-01,  2.90527550e-02, -5.54298366e-04,
       -5.66310494e-04,  4.08261513e-02,  3.46703541e-02,  5.59129593e-03,
       -4.43250471e-02,  4.64757949e-02, -5.11928552e-03, -1.55092315e-04,
       -2.42193523e-02,  2.68778713e-02, -8.57902512e-02,  8.96408697e-03,
        1.44128483e-02,  2.30969781e-02,  5.05625080e-03, -1.55608247e-03,
       -1.78454383e-03, -4.45388018e-02, -1.08119948e-01, -2.33077811e-02,
       -5.56422960e-02,  1.55578709e-03, -1.23434337e-02, -3.31830161e-03,
        6.13823700e-02,  1.18963222e-02,  2.11029717e-01,  8.66264919e-02,
        3.37423101e-02, -5.13005946e-03, -3.66627756e-02, -2.08216015e-02,
       -1.69153473e-01, -1.81471767e-02, -3.54648215e-03, -5.38580232e-04,
        2.26970938e-02,  9.14308708e-02,  1.07102454e-02,  1.10145849e-02,
        1.57296580e-02,  2.29391361e-02,  2.05872572e-02, -2.50446025e-02,
       -1.81034801e-02,  6.97493733e-03,  1.06929209e-03,  1.90918607e-02,
        2.96957779e-02,  1.67804808e-02,  5.19515124e-03,  9.96210050e-04,
        1.79509103e-02,  7.24323566e-04, -4.11513820e-03, -5.99363673e-02,
        7.00127865e-02, -2.61122383e-02, -5.97038917e-04,  1.91376966e-02,
        3.40464117e-04,  2.85923946e-02, -1.77547976e-03, -1.22696870e-02,
       -3.19887960e-03,  2.52030406e-02,  6.64293874e-03, -1.23977258e-02,
       -1.37283398e-03,  1.62892276e-01, -4.95949564e-04,  6.99596195e-02,
       -4.65614981e-03, -2.24524675e-02, -3.47427248e-02,  2.81208677e-02,
       -1.41507536e-02, -5.43602126e-03, -5.40751847e-02, -7.18830683e-03,
       -1.91076797e-02, -9.73332341e-03, -1.68728182e-01, -4.55974674e-02,
       -1.63550357e-01, -1.81409529e-03, -3.06641055e-04, -9.91383938e-04,
        1.49154276e-03, -1.01037089e-02, -1.81860202e-03, -1.91660622e-02,
       -2.34516275e-03,  4.13349523e-03, -1.36797781e-02, -1.86940181e-02,
        1.46387976e-01,  2.33549226e-02, -3.52840896e-03,  8.35182998e-03,
       -1.06937647e-02, -3.97623509e-03, -1.56330981e-03, -7.08933262e-03,
       -4.54448429e-02, -6.31620847e-02,  2.21069655e-01,  1.65562501e-03,
        4.52304743e-02, -1.55116064e-02, -1.07360374e-02, -1.64261267e-02,
       -2.46064187e-02,  3.02869674e-01,  2.24360690e-01,  6.90047404e-02,
       -1.29911876e-01, -6.99940277e-02, -2.17289466e-02, -7.49645796e-02,
       -1.78457574e-01, -7.61264262e-03,  7.65222976e-03, -7.31508617e-04,
       -1.75044010e-02,  7.07436065e-03, -4.11941026e-02,  9.25911986e-03,
        1.14479007e-02,  1.39046550e-02,  2.32965960e-03,  4.43480597e-02,
       -3.80342074e-03,  1.15862199e-02,  5.60438191e-04,  8.69910028e-03,
        2.21868248e-02,  1.13428274e-02, -6.76516267e-05,  3.04931117e-03,
       -1.56756250e-02, -4.33157206e-02, -5.40835575e-02, -3.51016825e-04,
       -5.92351341e-02, -3.10215150e-02, -2.69371412e-03,  2.04453387e-02,
        1.46212878e-02, -2.38373997e-03, -2.80458147e-04, -7.19120657e-04,
        2.38743680e-03,  2.93197782e-02, -1.41062527e-01,  2.39558360e-02,
        1.23210584e-01,  1.48122339e-01, -1.29599983e-01,  9.16219178e-02,
       -2.05430016e-02, -2.97693395e-02, -1.16145606e-02, -3.83232193e-02,
        8.04659586e-03, -1.20879531e-02,  2.90145749e-03, -1.32170349e-02,
        9.51837923e-03,  3.95529892e-03,  7.76754628e-02, -1.83331109e-01,
       -1.35287842e-01,  1.88597763e-02,  6.52805916e-04,  2.59209551e-04,
        1.20060269e-02,  1.55616262e-01, -6.53768091e-03, -5.99587741e-03,
       -5.50003218e-03, -6.76009471e-02, -2.06450057e-03, -5.48896660e-02,
       -4.63803202e-02,  2.18333618e-02, -4.31300301e-03, -1.44350343e-03,
       -7.37486219e-04, -1.46749022e-03,  5.30438780e-02, -3.76072877e-02,
       -3.42663263e-02, -5.34925603e-02, -6.58193200e-02,  6.94737257e-03,
        3.18573405e-02, -1.80983746e-02, -9.74110882e-03, -3.28767676e-03,
       -5.08277767e-03, -1.14391332e+00, -3.42259346e-01,  8.88356275e-02,
        1.11615693e-01,  3.15772402e-01,  2.68743954e-02, -1.15467148e-02,
       -5.68232905e-03,  2.19839001e-02, -9.06877497e-02, -8.50946907e-02,
       -8.88433071e-02,  2.38006396e-02,  5.11670879e-02, -5.32155046e-03,
        2.35181925e-02, -1.25367454e-02,  3.45477583e-02, -5.18220548e-02,
        5.28576185e-03,  9.01160920e-03,  9.48071012e-03,  3.69159754e-02,
        2.74401520e-02,  5.44260138e-03,  2.89019275e-03,  3.20164205e-03,
        7.26212083e-03,  6.63635175e-03,  7.87461440e-04, -6.79701020e-04,
       -2.11543929e-02,  1.98089121e-01, -4.54355549e-02, -7.91041985e-03,
       -2.62164220e-02, -4.51305666e-02, -9.16032680e-03,  4.47515097e-03,
        2.31101409e-04, -2.84075450e-02, -1.93615746e-02,  2.67172429e-03,
        2.13294598e-02, -1.66401207e-03, -2.22072995e-03, -2.50151481e-01,
        2.25373800e-02, -4.64279362e-02, -6.00847278e-02, -5.16633025e-02,
       -1.59700180e-02, -1.26151356e-01, -2.33198272e-03, -3.21228493e-02,
       -8.60947820e-02, -6.89783668e-03, -5.29131686e-04, -1.50618953e-03,
       -4.06065362e-04, -2.29211420e-03, -5.20149171e-04,  1.26834736e-01,
       -6.11625301e-02, -7.14349745e-02,  1.08357800e-02,  6.42014559e-01,
        8.18272870e-03, -1.24560637e-01, -2.41974227e-02,  7.02468413e-03,
        9.13402915e-03,  1.03726068e-02,  5.59293043e-02,  1.11188986e-02,
        9.13459769e-04, -6.22088035e-02, -1.03816341e-02, -8.74700266e-03,
        6.43196147e-03, -7.27824467e-04, -1.96918772e-03, -2.53596631e-02,
        2.48042973e-01, -2.22126730e-02, -7.23917918e-02, -3.94068153e-02,
       -8.15019500e-03, -4.78824933e-03, -1.26996061e-03,  5.73640716e-02,
       -1.25762420e-01, -2.07961739e-01, -3.63668099e-02,  2.24920113e-01,
        7.49815997e-02,  3.35540032e-02,  9.23710615e-02,  7.21923405e-03,
        9.16793712e-03,  1.13349298e-02, -9.02863269e-04, -3.59385612e-02,
       -8.54286208e-02, -4.37800559e-02,  1.92598958e-02,  3.23664608e-01,
        2.31057373e-01,  1.93097549e-02,  4.35996061e-02,  1.84377364e-02,
        3.96594887e-03,  6.72169892e-03,  2.78163449e-03,  1.79566365e-02,
        1.37086150e-02, -2.14158146e-02,  2.95911821e-03,  2.82524171e-03,
        9.33601631e-03,  4.42491275e-03, -3.87541813e-03, -6.47892922e-03,
       -1.21851935e-02,  4.66848101e-03, -1.33003592e-02,  1.26554131e-02,
        1.61152750e-02,  5.47870181e-03, -1.63165720e-02,  2.17276121e-02,
       -1.10832216e-02, -6.80435502e-03,  1.85551419e-03, -3.71879579e-02,
       -6.82851255e-03, -1.04145486e-03, -3.48652473e-03, -7.23454087e-03,
       -3.45313852e-03,  1.06581082e-02,  3.25565324e-03, -1.13147968e-02,
       -1.29357560e-02, -1.85246085e-02, -2.01780215e-03, -2.07169190e-02,
        6.30671447e-02,  3.38500073e-01, -1.88011363e-04, -2.16344705e-04,
       -3.75636164e-03,  4.76203223e-02, -5.08647779e-02, -1.96667093e-02,
        3.23769756e-02,  7.62549657e-02,  2.36550064e-03, -5.00098819e-03,
        5.98856821e-02,  2.34004491e-03,  7.48520868e-02,  6.65939581e-01,
        1.82508126e-01,  5.13852958e-02,  3.20681695e-02, -4.46306211e-03,
       -4.19440045e-04, -1.14383487e-01, -1.42610662e-02,  3.41138608e-02,
        8.97672677e-02, -1.13349287e-02, -1.11113240e-02,  5.98828873e-03,
       -2.26220989e-03, -4.43622351e-02, -3.90784615e-02, -1.32406150e-02,
        2.39956598e-02,  5.84923353e-02,  9.34487927e-02,  3.92365664e-02,
       -3.32376077e-03, -4.25687378e-01,  1.88481785e-02, -2.25622146e-02,
        7.41056725e-04, -1.82518362e-04, -2.63950664e-01, -1.35732612e-01,
        7.16464371e-02,  1.03692808e-02,  5.08692666e-02,  6.31750590e-02,
        2.59384207e-02,  7.72904518e-03,  1.76421269e-02,  4.21880878e-03,
        3.25313905e-03, -5.59482651e-02, -4.91543363e-02, -6.44315028e-02,
       -3.47828239e-02,  3.78298377e-03, -2.91391810e-03, -1.02178591e-02,
        7.49437121e-03,  2.76265676e-02,  3.45242120e-03, -2.85694976e-02,
        2.95223421e-02, -4.35612834e-03,  4.19053776e-03,  1.40973203e-02,
        2.09861386e-03,  7.25819078e-03,  3.23336478e-03, -9.91600889e-03,
        1.46943446e-03,  2.56689637e-02, -3.73591723e-02,  4.97383876e-02,
        1.13969685e-02, -7.41671769e-02, -2.10413550e-02,  5.79798792e-02,
        8.50996587e-02,  1.08695211e-02, -1.28041076e-01,  3.12641135e-03,
       -2.27273729e-03, -8.05226829e-02, -4.00731856e-03,  1.70962531e-02,
        1.43140306e-02, -1.07375828e-02, -4.04067686e-02,  1.09632514e-01,
       -5.36670478e-01, -6.87263110e-01, -5.31786480e-02,  7.83239405e-03,
       -5.27373280e-03,  1.01941848e-03, -1.07138100e-01,  6.09488031e-01,
       -1.88472345e-04,  9.18573551e-05, -2.17629958e-03,  8.27892907e-03,
        5.71537312e-02,  3.16105766e-03, -9.03394688e-03,  7.14778095e-02,
        3.17468063e-03, -6.92335296e-03,  1.24851141e-02,  9.02162387e-03,
       -2.88901192e-02, -1.90838836e-03, -1.23035976e-02,  3.30919185e-03,
       -8.28209580e-03,  5.97762377e-03,  4.37196266e-03, -3.34244043e-02,
       -1.35782188e-02,  2.43900297e-02,  4.50990688e-02,  2.05733889e-02,
        7.60950527e-02,  6.81027349e-03, -8.45832555e-02, -3.37828102e-02,
       -1.92624376e-01,  4.90763601e-03, -1.92443358e-01,  1.43615403e-01,
       -3.22636893e-03,  1.84018156e-05, -3.00379198e-03,  1.60282727e-01,
        7.81829777e-01,  1.23255046e-01,  1.76327378e-02,  6.36477383e-03,
        5.01148934e-03,  8.18579252e-03,  2.44316100e-02,  4.63149469e-03,
       -5.10059366e-02,  1.61997321e-01,  2.36445150e-01,  8.44483318e-01,
        4.39617906e-03,  1.95736284e-02, -1.27480077e-02,  7.83535703e-03,
        3.19078290e-02, -1.18628044e-02, -1.00169445e-02, -7.58466348e-03,
       -6.44990386e-03, -2.93552207e-03, -2.56506660e-02,  8.05348550e-04,
        5.19178377e-04, -8.14053914e-03, -1.23064022e-01, -7.71996626e-02,
       -3.91684913e-04,  1.03090771e-02, -1.41204462e-02, -5.31381962e-02,
        1.27073639e-02, -2.09795747e-01,  4.96776607e-02, -5.23292838e-02,
       -2.64694304e-02,  1.22196565e-03, -1.77118978e-02, -1.66152059e-02,
        2.36960968e-02,  3.54464348e-02,  2.19903645e-02, -9.38968907e-03,
        7.90711532e-03,  5.71709163e-02,  1.10406436e-02,  7.94184211e-02,
        1.34610070e-01,  1.87335107e-01,  8.94059263e-01, -1.75949417e-02,
        6.25430092e-03, -1.59380142e-01, -4.43987509e-03,  1.13338539e-02,
        2.81627946e-01,  2.25801848e-03,  2.97917820e-02, -6.45798322e-04,
       -4.18725628e-03,  1.86344424e-02,  3.33279693e-02,  9.41472100e-03,
       -4.06079407e-02, -2.39287053e-03, -7.43322341e-03,  4.35129662e-03,
       -7.51416516e-03,  4.58837072e-03, -1.91424626e-02, -1.36554291e-02,
        9.08008048e-03, -1.81093039e-02, -2.27995862e-02, -2.23247803e-02,
        9.35788018e-03, -3.94775082e-02, -9.97567726e-02, -5.33605284e-03,
       -1.79167921e-02,  5.53677808e-04, -3.25098467e-02,  5.31333934e-03,
        2.70135954e-02,  2.58111030e-02,  1.82512890e-01,  2.84396675e-01,
       -4.08023634e-02,  1.72205131e-01,  9.79511253e-02,  1.26010696e-01,
        8.40915233e-03,  6.42607537e-02,  1.23230961e-03,  2.95423852e-02,
        1.03068719e-02,  9.24359331e-04, -8.54081861e-03, -5.39949544e-02,
       -1.90280600e-01,  1.89510515e-01, -3.97699332e-02,  1.15537680e-03,
       -5.13959751e-03,  3.30382935e-02,  4.09103157e-02, -9.26998134e-03,
       -5.04297180e-03, -4.89082959e-03,  2.92688589e-03, -1.89950317e-03,
        2.09293381e-03, -1.28677767e-03, -6.65783664e-03, -1.53353136e-01,
        2.84727704e-01, -3.31002920e-01,  1.29206654e-02,  1.64959483e-02,
       -5.49450495e-03, -1.71335586e-02, -7.77090511e-02, -1.39013734e-01,
       -1.22184341e-02,  1.72724411e-02,  5.36441736e-02, -7.74717903e-03,
       -8.27405598e-04, -4.87328196e-03,  5.97778061e-02,  3.55938252e-02,
        2.76028549e-02, -1.61853970e-02,  2.49417109e-02,  1.47728488e-02,
       -1.71762771e-01,  2.32753038e-02, -9.25424038e-02,  4.20018841e-03,
        8.97378177e-02,  4.20832932e-01,  1.30182972e-01,  3.52158786e-01,
       -7.57314017e-02,  1.13179409e-01,  1.78058158e-02,  1.24593288e-02,
        5.14937685e-02,  3.55296179e-02,  2.78885583e-02, -1.84862926e-02,
       -2.79774856e-02, -1.87341545e-02, -1.78590418e-02,  1.42653095e-02,
        1.45464427e-02, -9.39281548e-03, -1.60873070e-02,  3.08075977e-02,
       -6.59386894e-03,  1.21090405e-02,  9.40759113e-02, -4.38579738e-04,
        9.85017514e-02, -1.12380452e-01, -6.55605565e-03, -4.37533231e-02,
       -2.45324834e-03, -4.32367647e-02,  5.80478610e-03,  1.42278762e-02,
       -4.26952638e-03,  2.55846914e-02, -6.96805657e-03,  2.40652379e-02,
        1.08701176e-01, -2.07883205e-01,  6.76185276e-02,  7.73626943e-02,
        4.47332010e-03,  4.06104910e-02, -7.03304168e-04,  4.06770093e-02,
        8.87546593e-02,  2.01227087e-02, -2.52263414e-02,  1.99637863e-02,
        3.45428848e-02, -1.99465062e-02, -2.61324280e-01,  1.24087871e-02,
        2.60926198e-02,  4.14995332e-02,  9.95416340e-02, -4.88159835e-03,
       -1.10416728e-02, -1.37115016e-02, -9.05754718e-03, -3.57147213e-03,
       -1.15373514e-02, -8.36125566e-03, -8.38422475e-03, -4.18576167e-01,
       -1.78919850e-02,  1.07497594e-02, -8.04210775e-03,  1.01935522e-02,
       -4.23042330e-02, -2.92846560e-02, -7.41801942e-02, -6.12103861e-03,
        6.71265922e-02,  2.82516574e-02,  1.13747279e-02,  3.29614573e-02,
        5.82376011e-04,  3.63159467e-03, -1.40483251e-02,  5.89388884e-03,
        1.91770733e-02,  3.73495847e-02, -2.11023128e-02,  1.36291971e-01,
        3.50752927e-02, -3.56017224e-02, -1.00349922e-01, -1.25833338e-02,
       -9.95333252e-03,  1.35002295e-01,  8.99009678e-02, -2.61983228e-01,
        1.21296056e-02,  5.02891469e-03,  1.87941390e-02,  3.22602992e-02,
        3.06724675e-02, -6.06588715e-02,  3.42388013e-02, -2.08705434e-02,
        4.12568937e-02, -1.13364235e-03, -2.98902124e-02, -2.68068447e-02,
        2.64538924e-02,  5.55622071e-02, -8.48256074e-02,  7.56617441e-03,
        3.95554032e-03, -5.11248599e-03,  1.42539019e-03, -2.07364732e-03,
        2.50492772e-02, -1.92586361e-02,  7.22358765e-01,  3.34439774e-01,
        2.27869153e-01,  1.66622915e-01, -5.52880948e-03, -3.54993598e-01,
       -2.99217894e-02,  3.51624996e-02, -3.70903392e-01,  1.68609080e-02,
       -4.19574248e-02,  2.25722541e-03, -2.84451789e-03,  3.23096721e-02,
       -3.24852039e-02,  5.17369295e-02,  7.39715511e-03,  1.10069430e-03,
       -2.61512239e-01, -2.62128674e-02,  5.11958053e-02,  1.01065944e-01,
        7.54238891e-03,  7.94507045e-02, -2.12090141e-02, -7.33405812e-03,
       -2.82791791e-02, -1.74037356e-02,  1.33719787e-04,  9.99049282e-03,
       -8.13984082e-02, -8.05958576e-02, -3.65516576e-01,  3.82626818e-02,
       -1.84321095e-03, -2.25918187e-02,  1.08478987e-02, -6.00856421e-02,
       -3.46055518e-02, -7.13544322e-03,  1.30838623e-02,  1.39667052e-02,
        1.21681143e-02, -1.04132408e-01,  1.73894584e-02, -1.67342020e-02,
        8.24734768e-04,  8.91447362e-03, -1.44768430e-02,  4.54644784e-02,
        3.19663235e-02,  5.85422074e-02,  1.48048426e-02, -2.45351312e-02,
        2.32271990e-02, -4.93483282e-02, -1.17518043e-01, -7.55921078e-02,
       -1.42454762e-01,  9.37090785e-03, -4.42594027e-03, -1.37406286e-02,
        1.03104302e-01,  2.90586255e-03,  5.25961404e-02, -5.01980406e-02,
       -1.06234239e-01,  2.09026522e-02, -8.86940609e-03,  2.52634389e-02,
       -3.44934167e-02, -5.09775013e-02,  5.81039700e-03, -2.59570931e-01,
        4.55201782e-03,  4.34166149e-03, -4.71124601e-03, -7.49021930e-03,
       -1.18304276e-02, -1.50175990e-02, -1.39853360e-01,  6.48069601e-02,
       -2.30592738e-01,  6.79964112e-02,  4.26506254e-02, -1.20603053e-02,
       -2.00503464e-01, -8.17525678e-02, -5.95371213e-03,  3.59757425e-03,
        2.74436541e-02,  7.04989524e-02, -1.45178502e-02,  7.64135881e-03,
       -1.10541832e-02, -2.67102148e-02, -6.00036800e-03,  5.53506688e-02,
        4.95482850e-02,  6.47302575e-02, -4.04718984e-02, -7.26697338e-02,
       -3.04177524e-02, -4.50410967e-02, -1.96615352e-02,  1.14432999e-02,
        8.94452070e-02,  2.78487983e-02,  5.38140483e-02, -3.32208949e-03,
       -3.50544089e-01, -7.82766481e-04,  3.18370460e-04, -1.23614023e-02,
       -1.06730654e-01,  1.52087615e-02, -1.73207007e-02, -2.76130993e-02,
       -2.77983631e-04, -5.23867615e-03, -7.87599963e-04,  1.05950480e-02,
       -5.30122935e-02, -6.96688854e-02, -6.42196148e-02, -1.80436647e-02,
       -6.59005436e-03,  4.78327238e-03,  5.59841173e-02,  1.59431847e-02,
       -4.93227549e-02, -3.13173816e-02, -4.11619557e-02, -4.86360999e-02,
       -4.26495760e-02, -7.92676759e-03,  1.13458229e-01, -6.95931812e-04,
       -5.40037208e-03, -1.07574291e-01, -5.28869622e-02,  2.60450152e-03,
       -2.73682359e-02, -1.45046127e-02, -7.57605505e-03,  4.77527977e-02,
       -9.56480263e-02,  9.32299503e-03,  2.31906279e-02,  8.15223854e-03,
       -6.91774396e-03, -1.57642752e-02, -8.75505805e-03,  7.03205571e-02,
       -5.00456275e-02, -2.35750219e-02, -3.66803728e-02, -3.44485222e-02,
       -7.80651298e-02, -1.05663546e-01,  6.91398232e-03,  4.63781134e-04,
        3.86979108e-03,  5.81678775e-03, -1.97924898e-03,  4.37744215e-04,
       -5.47256997e-03,  4.28040358e-02, -1.55025467e-01, -1.47273321e-02,
       -3.46902291e-03, -1.09792856e-02, -8.95377692e-04,  6.72373243e-02,
        4.78098772e-02, -1.60597682e-02, -2.91101133e-02,  1.83240222e-02,
        3.13414323e-01,  1.80978872e-01,  1.63188857e-01, -1.18408118e-03,
        2.32149373e-02, -1.24153461e-01, -1.25841888e-02, -2.41995805e-02,
        3.55126514e-03, -1.06893099e-01, -2.61978052e-02, -4.21911642e-02,
       -1.81356532e-02, -4.76312555e-03,  1.57283333e-02,  7.38885802e-03,
        8.39796631e-04,  1.03390667e-01,  1.33584256e-02, -9.25438268e-02,
       -1.64938599e-02, -3.81089257e-02, -6.37785455e-03,  2.15294678e-02,
        1.48687955e-02, -3.71649988e-02, -3.46822370e-02, -4.04818453e-02,
       -2.24899471e-02, -2.09079206e-02,  1.97885870e-03,  1.93419801e-02,
        5.00758716e-04, -4.72674632e-03, -3.46308846e-02, -1.41572198e-01,
       -4.98143975e-03, -1.74204789e-02, -8.48299743e-03, -3.67561761e-02,
       -9.31208722e-02,  5.47808639e-03,  2.32651798e-02,  2.84350008e-02,
        1.11478097e-01, -1.81811282e-02,  2.35196752e-02, -4.64779852e-02,
        4.37672094e-02,  1.25365148e-02, -3.14715976e-02, -2.43610490e-02,
       -1.16254101e-01,  1.09799753e-02,  1.83170784e-02, -2.97174513e-03,
        4.39542030e-03, -7.81536447e-03, -1.72111420e-02, -1.03323087e-03,
        3.74690904e-02, -5.73663402e-03, -2.40144898e-02, -1.76413331e-02,
       -2.18356857e-01,  3.97059853e-02,  1.87923746e-02,  5.19010306e-02,
        4.48666204e-03,  1.63706786e-03, -2.89299711e-02,  2.82302103e-01,
       -7.38931257e-02,  1.09811402e-01,  1.63145779e-01,  2.56160702e-02,
        3.52931786e-02, -1.07407391e-02,  8.23147148e-02, -5.33303792e-02,
        4.49754727e-03, -6.20661459e-02, -9.95186396e-02, -3.63775896e-02,
       -3.13313653e-02, -1.50732110e-01, -1.98672793e-02, -1.56894178e-02,
        1.03336513e-01,  2.98967059e-02, -8.18755144e-03, -3.47852763e-02,
       -1.89727288e-02, -3.01783974e-02, -1.40005564e-02, -1.98517760e-02,
       -3.82671041e-02,  8.47662913e-03,  7.87811795e-03, -2.75985429e-03,
       -6.34967893e-02, -1.85367714e-02, -6.05962466e-03, -6.05193814e-03,
       -4.55204632e-02, -2.47868650e-02, -8.40829623e-03, -1.38812041e-03,
       -3.10607333e-04, -2.76302003e-02,  2.05254860e-03,  1.08965640e-02,
        2.60088266e-03, -4.99965669e-02,  3.91965480e-02,  1.15945958e-02,
        2.54053338e-02,  1.58955637e-02,  4.99904819e-02,  1.63318251e-02,
       -6.20220213e-02,  4.44782139e-02,  8.19732485e-02, -3.09313255e-02,
       -9.56478070e-03,  1.12301425e-02,  4.09877320e-02,  2.23655718e-02,
       -1.37132734e-02,  5.40385612e-02, -1.90573475e-03,  3.50816597e-02,
        4.81377896e-03, -1.89069759e-02, -6.24363052e-02,  1.10872707e-02,
       -3.38563747e-02,  3.07873220e-02,  2.97224181e-02,  3.20144197e-02,
       -6.05523815e-03,  2.01834759e-02, -1.72773798e-02,  8.39456129e-02,
       -1.06481848e-01,  7.26453454e-02, -4.62075412e-02,  6.50499077e-02,
        1.00510596e-01,  1.45236036e-01, -2.24646216e-02,  2.35991240e-02,
       -4.46102549e-02, -2.18960860e-01, -7.95773503e-02, -3.35118946e-01,
       -3.12408590e-01, -1.11294460e-01, -4.80313355e-02, -1.41436147e-02,
       -7.86036968e-02,  2.33085291e-02, -1.10055674e-02, -2.03262915e-02,
        3.59389532e-02,  3.67939639e-02, -2.79780723e-02,  8.00857358e-02,
       -4.87588728e-04, -1.06561323e-02, -3.59196924e-02, -8.77991655e-02,
       -1.68869626e-02, -1.19836265e-02,  1.59856800e-01,  2.93217478e-02,
       -1.08481261e-02, -3.64401211e-03, -2.75830282e-02, -7.13130487e-03,
        4.89245786e-02, -1.98796104e-02,  4.08722089e-02, -6.40635392e-02,
        1.45958228e-02,  3.52511915e-02,  3.20451035e-02,  1.10501513e-02,
        1.88377489e-02,  6.18371568e-03, -1.04438870e-01, -1.38932691e-01,
       -9.88323229e-02, -5.58137586e-02, -1.85763517e-02, -1.93188767e-04,
       -1.09935116e-02, -2.40129227e-02, -1.10989045e-02, -6.65863369e-03,
       -1.35596325e-02, -1.20614529e-02,  1.51433325e-02,  2.72015812e-02,
       -5.08372987e-03,  2.29319539e-02,  3.64296441e-02,  2.76625082e-02,
        7.49955614e-03, -1.21267797e-02,  3.05572003e-02,  1.39796911e-02,
       -2.33365555e-02, -4.54793874e-02, -1.46736957e-02, -2.32959832e-02,
        1.57607414e-01,  6.93660710e-02,  1.56931415e-01, -1.23162001e-02,
        6.19375535e-02, -1.89893128e-02, -7.92628642e-03, -7.18203771e-02,
       -1.18013605e-01, -3.50864486e-01, -9.82487511e-02, -3.00337328e-02,
       -8.99726067e-02,  1.08955202e-01, -7.10394472e-02, -8.15084349e-03,
        2.66655320e-02,  4.16253437e-02,  3.41070406e-02,  9.65526959e-03,
        1.91571428e-01,  1.58773940e-01,  2.93261766e-01, -8.28743651e-03,
        3.78379887e-03,  4.57028926e-02, -3.10892783e-02,  1.96608881e-02,
        1.31425983e-02, -2.49639234e-02, -1.41601882e-03,  1.52645799e-02,
        5.76787348e-02, -1.06119627e-02, -2.68163986e-02, -1.78548843e-01,
       -2.44002788e-03,  3.72171885e-02,  1.03923089e-01,  3.70572395e-02,
        7.56533741e-03, -6.80961727e-03, -1.67079988e-02, -2.23672401e-01,
       -5.58531868e-02, -1.98997902e-01, -1.37179654e-01,  8.87716440e-02,
        1.53433706e-01, -2.35056708e-02,  2.50448249e-02,  7.82027875e-02,
        4.43756541e-02,  5.26328456e-03,  1.33528788e-02,  1.98449814e-02,
        3.24841458e-02,  1.57578535e-03, -4.23670019e-03,  2.04160172e-02,
        3.09417077e-02,  1.47252744e-02, -3.19358097e-02,  1.82159432e-02,
        7.15183602e-03,  6.45818947e-03, -2.00790001e-02,  6.72471046e-02,
        3.39237089e-02,  1.32418412e-01,  1.13981447e-01,  1.04181999e-01,
        8.66437062e-03, -9.01778993e-02, -5.80426801e-03, -8.14121515e-03,
       -1.32981996e-02, -8.95272038e-02, -1.84112923e-02, -2.98800496e-01,
       -5.57939352e-02,  1.10854200e-03, -7.32442075e-03, -8.64192732e-02,
        6.28535675e-02, -1.99361089e-01,  6.03115796e-03,  5.91607691e-03,
        1.83697532e-02,  1.51196621e-02, -1.96915201e-03,  5.83522856e-02,
        6.46692918e-02,  1.06425205e-01,  3.46173134e-02,  1.00717151e-01,
        1.17737612e-02, -4.33594055e-03,  1.89789178e-02, -4.27909900e-03,
       -8.52229302e-03, -1.53746464e-02,  1.77040346e-02, -2.04845112e-01,
       -3.48787823e-02, -1.54148342e-01,  3.62962861e-02,  4.60078968e-02,
        1.96912514e-03, -1.70525451e-03,  3.18544991e-02,  2.49261745e-02,
        1.71304841e-02, -4.40829577e-02, -1.00787487e-01, -2.37943239e-02,
       -2.43253941e-01, -4.95058607e-02, -1.38924442e-02,  1.00397675e-02,
        1.13059306e-02,  1.76939014e-02, -4.23117977e-03,  3.60728683e-02,
        1.59274077e-02,  3.87672260e-02,  3.02879038e-02,  2.14133457e-02,
        4.94568837e-02,  2.48599377e-02,  2.12495827e-02,  1.21265916e-02,
       -8.60895754e-02,  1.50711238e-02,  2.33190299e-02,  2.25719124e-02,
       -3.03805568e-02, -1.75689824e-01,  5.79249316e-02,  8.72506816e-02,
        2.10251959e-02,  1.48671743e-01,  9.20283699e-02, -8.27850708e-02,
        1.30777481e-04, -1.67984903e-04, -4.83947126e-03, -3.40912138e-02,
        1.00829265e-01, -1.13694625e-02, -1.04931444e-01,  4.17428608e-02,
       -3.88908217e-02,  7.55452339e-03, -2.71969751e-02, -1.20013715e-01,
        8.13967163e-03, -4.43262668e-02, -2.38566242e-01,  3.43784615e-02,
       -1.29169759e-03, -4.27880445e-03,  4.24328074e-02,  4.17590073e-02,
        3.38420941e-03,  4.36120347e-02,  3.49207179e-02,  5.02118116e-03,
       -1.75994885e-03,  1.88355824e-03, -1.16840804e-02,  5.28146092e-02,
        1.58656470e-02,  7.92239813e-03, -1.02355576e-01, -1.84015928e-02,
       -8.42281404e-02,  1.75659827e-02,  7.07901632e-02,  4.34683326e-02,
       -4.53041630e-03, -4.33248443e-03,  1.97306410e-02,  5.08316107e-03,
       -1.06810174e-01, -7.13328071e-02, -3.79729363e-02, -2.56152394e-02,
       -1.05109061e-02, -2.46154545e-02, -2.11636525e-02,  1.69458344e-03,
        5.07288829e-03,  1.46562629e-02,  5.23186906e-03, -1.22925933e-03,
        2.79744422e-02,  4.86971697e-03,  3.53756387e-02,  3.28699414e-02,
        4.59976918e-02, -1.22589324e-02,  1.98082380e-04, -2.87232945e-02,
       -1.11880650e-03, -2.29108431e-03,  2.91334601e-02, -8.22546563e-03,
       -5.69694026e-02,  3.16211617e-02,  4.66933839e-02, -1.19959008e-02,
        7.08089131e-02, -2.13178324e-02,  2.66907793e-02, -1.16374933e-04,
       -1.36665705e-03, -1.96817222e-02, -5.02736655e-05, -2.89005596e-01,
       -1.02038979e-02, -2.25800164e-01, -5.69109166e-02,  5.61619907e-03,
        1.23765336e-02, -9.38407409e-03, -1.23771432e-02, -3.89749177e-02,
       -1.68151881e-02, -3.08027378e-02,  1.46795193e-01, -1.98120079e-02,
        2.25252527e-03, -2.31465905e-01,  1.97269460e-02,  8.04336212e-03,
        8.33550404e-03,  1.57426886e-02,  3.21549032e-02,  3.18371394e-02,
        8.75175886e-03,  1.61480047e-02,  1.24426316e-02, -1.98376774e-02,
        5.32026550e-02, -8.39397225e-03,  5.46560305e-03,  1.71009444e-03,
       -1.87095654e-02, -3.49437957e-02,  4.11470028e-03,  5.87596500e-02,
        2.06939264e-02,  2.55519639e-02, -3.66116290e-03, -2.52237397e-02,
       -1.30413285e-03,  2.16759180e-04, -4.05187637e-01, -1.30914604e-02,
       -6.92693937e-03, -2.05846255e-01,  1.21545398e-02, -1.83499731e-02,
        5.31005051e-04,  1.94131315e-03,  1.65100780e-02,  8.18906005e-03,
        2.65508069e-02,  1.10314263e-02,  5.51771658e-04,  3.88852298e-03,
        2.25797805e-02, -1.93013453e-02, -2.01946190e-02,  9.28705520e-04,
        3.27561400e-03, -1.09238185e-02,  5.58383286e-04,  7.08849021e-02,
        1.52890126e-02, -2.04411527e-02,  1.48169082e-02, -2.94509105e-02,
       -1.34822101e-03,  1.05833896e-02,  5.87127798e-03, -3.96875451e-02,
       -2.31348402e-01, -5.92346348e-02, -6.28859747e-01, -6.42248639e-04,
       -1.56499948e-01, -1.09136067e-02,  4.94291242e-03,  1.12148698e-03,
       -1.32223380e-02,  1.89803907e-03, -2.02380219e-02, -5.41993745e-02,
        5.43070842e-02, -1.09905930e-02,  9.87375015e-03, -1.08119266e-01,
       -2.33678412e-03, -1.96277349e-01, -2.78822021e-02, -7.19632099e-02,
        1.19769348e-02,  2.48426143e-02,  2.34371696e-02,  8.31904567e-03,
        8.69539073e-03,  8.12868376e-03,  1.95300857e-03,  1.12867752e-02,
        1.84787621e-02,  1.96892651e-02, -8.18319279e-03, -1.39934830e-02,
        2.25803489e-02,  2.86697638e-02,  1.53991620e-02,  1.55330672e-02,
       -8.85160214e-04, -4.39217924e-02,  2.15463491e-02,  1.58931439e-02,
       -2.28541487e-01, -1.41571734e-01, -2.09342985e-01, -7.52226750e-03,
       -1.49983555e-03,  2.37421220e-01,  8.87284775e-03, -2.52430426e-01,
       -1.88819015e-03,  3.03771432e-03,  8.68289894e-04,  6.33146136e-03,
        1.07479256e-02,  4.23474948e-02,  2.07842773e-03, -9.07562600e-02,
        3.79329472e-04, -1.88930224e-03, -1.86622355e-03,  1.02853806e-02,
        3.71044806e-03,  4.20668083e-02, -2.71980156e-03,  1.53757919e-02,
       -1.90148934e-01,  3.39737992e-03,  1.39387731e-02,  8.11918883e-03,
       -5.38050812e-02, -4.51643668e-01, -3.12313728e-02, -8.52559773e-02,
       -6.98391198e-02,  1.41340938e-02,  2.25598691e-02,  7.61370999e-03,
        8.27837102e-04, -4.03601274e-03,  8.50496182e-03, -1.24696316e-02,
        8.21163630e-03,  6.71447483e-02,  4.46852072e-02, -4.83597333e-02,
        4.79605599e-03, -2.92506092e-03,  1.59199728e-02, -4.09329236e-02,
       -4.57399616e-02,  5.84153336e-03,  1.20912402e-02,  1.27437415e-02,
        1.25223393e-02, -2.92620707e-02,  5.28604440e-02,  2.41236102e-03,
        2.29206301e-02,  4.26774078e-03, -1.80248698e-03,  4.98359384e-03,
        1.36969122e-02,  1.60956563e-02,  4.23620328e-03, -4.68497834e-02,
       -3.14201452e-03,  1.47644959e-02, -2.25546559e-01,  2.89604676e-02,
       -8.82799338e-03, -9.26858320e-02, -1.16085628e-02,  3.55224882e-01,
        2.61819530e-03,  2.43043945e-04,  1.75654808e-02,  5.50816220e-03,
        1.36550358e-02,  2.12587457e-02,  1.01647414e-02,  5.70662551e-04,
       -9.19544164e-02,  3.24839360e-03,  1.27042652e-02, -8.91770643e-03,
        1.15672968e-02, -6.25022933e-02, -1.13071737e-02, -5.85264377e-02,
        2.83301711e-02, -1.13604891e-02,  3.33374936e-03, -1.28092474e-01,
       -2.65945449e-01, -9.78511405e-03, -2.19361463e-02, -1.07302642e-02,
       -6.38928425e-02,  3.13349854e-02, -8.41466116e-03,  2.93773735e-03,
       -3.20909835e-04,  1.24625366e-02,  6.36703971e-03,  2.91556042e-02,
       -1.61278686e-03,  8.07481276e-02,  2.38238590e-03, -1.82820046e-02,
        4.28664790e-02,  5.12822834e-02, -1.70900558e-02, -2.44539286e-03,
       -1.74951466e-01, -3.97221861e-02,  1.73403569e-02,  1.19586120e-02,
       -1.43971556e-02,  9.33629229e-02,  7.87641434e-02, -5.42288821e-02,
        1.06733014e-01, -9.49230898e-02, -7.98891273e-02, -5.76366899e-03,
        6.41576077e-02,  8.28769047e-03, -1.67516175e-02, -2.05588105e-02,
       -1.82333805e-02,  1.05879094e-02,  1.03388584e-02, -3.02664502e-02,
       -3.95512732e-02, -1.65390361e-02, -1.31994687e-02, -8.87116904e-03,
        7.91533488e-02, -7.49000266e-03,  5.49702009e-03,  1.03723610e-02,
        9.33613153e-03,  1.68095708e-02,  7.62195135e-03,  2.39234224e-02,
       -4.59451345e-02,  2.29340553e-02, -1.95901331e-02, -2.19538427e-02,
       -1.06642305e-02, -9.55446350e-03, -2.23349552e-02,  7.25384480e-03,
       -2.29680093e-01, -1.95456859e-01,  9.16874389e-03,  4.49388393e-04,
       -4.24336232e-03,  1.35927714e-03, -9.34085934e-02, -8.00450298e-03,
        2.10785166e-02,  2.91008696e-02,  4.00326565e-02,  2.46892422e-02,
        1.48110967e-02, -1.44268810e-04, -2.61990867e-02, -3.63880605e-02,
       -3.59064285e-02,  3.47919165e-02,  2.66792737e-02,  1.27426587e-02,
       -4.29339620e-02, -3.59348905e-03, -1.01833987e-01, -5.63108580e-02,
        2.84206364e-02,  3.40403122e-02,  9.21041246e-02,  7.77559032e-03,
        5.11658896e-02, -2.15132709e-02, -3.45527046e-03, -4.31764944e-02,
       -8.01459646e-03,  1.20030688e-02, -6.14045139e-02,  2.53211313e-02,
        1.45603848e-02,  1.22388464e-03,  6.97876011e-03, -2.01809387e-02,
       -3.43072182e-03, -2.14418029e-01, -3.56891306e-03,  1.93986530e-02,
        1.72166820e-02,  3.22344405e-02,  3.73701061e-02,  2.38951540e-02,
       -1.06217035e-01,  2.94568693e-02, -1.44147258e-02, -2.90830428e-02,
       -2.00539942e-04,  5.23692877e-02, -2.54112863e-02, -6.67401022e-02,
       -5.20247882e-02,  4.09731945e-02,  1.60269217e-02,  1.11236124e-02,
        1.35420823e-04,  2.19614123e-02, -4.18178155e-02,  8.12034018e-03,
        3.17725826e-02,  3.51035376e-03,  1.35328340e-03, -5.37757113e-03,
       -2.27188666e-02,  5.36727503e-02, -1.29523025e-02, -6.05043316e-03,
        4.51584566e-02,  2.41168079e-02, -9.68296743e-04,  8.07738717e-03,
       -6.58190475e-02,  3.01976058e-02,  7.14637096e-02,  2.36031501e-02,
       -2.13207192e-03, -2.53004583e-02,  5.74266242e-02, -6.69649014e-03,
       -1.28223381e-01,  2.94228422e-02, -1.08494724e-02, -5.12969783e-02,
       -1.18667625e-02,  1.11718548e-02,  6.82183585e-03, -1.67619559e-02,
        5.23511626e-01, -8.88494172e-04, -1.29406372e-01, -1.63967878e-01,
       -1.64133868e-02,  5.58626123e-02,  1.47433409e-01,  3.34660269e-02,
        1.63121080e-02, -4.64667340e-02, -3.76090127e-02, -1.29097903e-02,
       -6.00099933e-02, -9.59020441e-02, -1.33943664e-02,  2.19097569e-02,
        1.83967368e-02,  1.59402738e-02,  8.37843718e-03,  2.31717993e-02,
        2.76873418e-02, -3.69136147e-02,  3.15711848e-03,  3.56619597e-03,
        2.97722448e-03, -5.17389241e-03, -1.31621596e-02, -2.65322606e-02,
       -5.00667183e-02,  2.46544284e-03, -3.33752141e-02, -2.06529291e-03,
        5.61568528e-02,  1.64411095e-03, -9.55609652e-04, -4.83277107e-02,
        4.80505261e-02,  7.62951499e-02,  1.26090749e-01, -7.68915021e-02,
        3.37773568e-01, -1.55131330e-02, -4.47558647e-02, -3.30307465e-02,
        1.01516986e-01, -8.01445491e-03, -6.62923541e-02, -5.15888080e-03,
        2.77759287e-02,  1.46821057e-02, -1.36621548e-02,  3.25936512e-02,
        2.74620819e-03, -1.10943807e-01,  1.75329982e-01, -8.05258765e-03,
        9.80369537e-03,  1.24684181e-02,  1.11924335e-02,  1.25774084e-02,
        1.93478678e-02,  1.81518175e-02,  2.93625684e-02,  6.74910576e-02,
       -2.26829537e-03,  1.02435484e-03, -9.85487706e-03, -2.00426855e-02,
       -1.47999412e-02, -3.09443290e-02, -4.77080319e-03, -7.36426182e-03,
        2.19315571e-02,  8.31709859e-02, -8.22292409e-04, -7.18748366e-04,
       -1.66657225e-02, -1.37169945e-02,  5.66749894e-02, -1.86870454e-02,
        1.73145174e-02, -1.89900137e-03,  3.44584723e-03,  2.68568906e-01,
       -7.24900754e-05, -6.75906302e-03,  1.14105755e-02,  8.32977390e-03,
        5.53957592e-03,  1.70682915e-03, -3.45096302e-02,  4.30089930e-03,
       -1.02749698e-01, -9.14572243e-03, -1.23704452e-02, -1.72084926e-02,
       -2.38046579e-02, -2.09895876e-02, -2.63955064e-02, -1.25630231e-02,
       -2.11117003e-02,  7.66103317e-02,  9.20285867e-02, -1.23140082e-02,
       -4.49479678e-03, -6.95574260e-03,  7.52089439e-02, -5.98458293e-02,
       -1.51622288e-02,  1.75890723e-01, -4.69559674e-02, -2.39997756e-02,
       -9.65971707e-03,  4.86619909e-01, -1.14720503e-02, -1.07149102e-03,
        1.13441863e-02,  2.01425837e-02,  2.23849624e-02,  2.49379022e-02,
        3.74788776e-02, -1.22421469e-02, -2.04165074e-02, -1.81439965e-02,
       -2.76650771e-02, -3.77859205e-02,  5.76484552e-04,  4.56562673e-01,
       -2.09247876e-02, -3.66051274e-02,  4.27060165e-02,  3.73176966e-01,
       -3.10696492e-02, -2.21874598e-02,  2.92071029e-02, -3.63405514e-02,
       -7.30019319e-03, -8.60433542e-03,  2.89138325e-01,  7.12311872e-02,
       -1.18705615e-02, -1.88813288e-02, -1.33600025e-02, -1.19702693e-02,
       -1.98301493e-02,  2.75408508e-03,  1.99891852e-02,  1.46456154e-02,
        9.28602673e-03, -1.87130071e-02, -3.47207335e-02, -3.19926236e-02,
       -2.69134517e-02,  2.40344835e-02,  1.28582569e-02,  5.19730804e-01,
       -2.71323498e-02,  2.17990649e-03,  4.74732938e-01,  1.41763072e-01,
       -2.65997765e-02, -1.23230689e-02, -2.05437883e-02, -6.62512907e-03,
       -6.63785386e-03,  1.42057536e-01,  8.59336710e-02, -8.23106366e-03,
       -9.15997123e-03, -1.51119930e-02, -2.24282552e-02, -1.45492531e-02,
       -2.33257350e-02, -8.55408068e-03,  1.14080267e-02,  1.10903255e-02,
       -1.65885006e-02, -2.25502141e-02,  5.68291600e-02,  8.31612618e-02,
        3.23011601e-02,  7.11088533e-01,  3.31101000e-02,  7.99865439e-01,
       -1.22381508e-02, -2.06268246e-02, -9.41726492e-03, -5.95288279e-03,
        6.30310881e-02,  2.71163132e-01, -1.17476444e-02, -1.16333190e-02,
        4.73031338e-01, -2.89576770e-02, -2.33019411e-02, -3.81471234e-02,
       -3.08204355e-02, -7.08864874e-02,  6.47092251e-02, -9.77180674e-03,
        1.01017767e+00, -1.20225400e-02, -1.26465857e-02, -7.85544332e-03,
       -8.31675015e-03,  1.12866115e-01,  1.12265054e-01,  1.14909118e-01,
       -1.07799508e-01, -2.98501291e-02, -2.90527633e-02, -3.15235861e-02,
       -8.46183429e-04, -1.29264458e-02,  1.21352053e-01,  2.33622534e-02,
       -8.93104439e-03, -1.79328001e-02, -1.62782845e-02, -1.63455756e-02,
        2.07120952e-01,  1.97546669e-01,  7.09364192e-01, -4.70783355e-02,
       -1.16116921e-02,  2.15563308e-02,  2.72224823e-02,  1.37797511e-01,
        3.59567019e-02,  6.39555695e-01, -1.01508232e-02, -1.43531564e-02,
       -1.53832543e-02, -4.59635848e-02,  4.85584591e-02,  2.48652193e-01,
       -4.95230372e-02,  2.43616505e-01,  1.15345556e-01,  1.81356225e-01,
        8.12370238e-01,  3.71014224e-02, -9.89419726e-03, -1.38549015e-02,
       -1.48423892e-02,  7.57404011e-01,  1.09995527e+00, -1.49919212e-01,
       -1.42985722e-01,  8.71251602e-01, -5.10823873e-02, -1.04642017e-01,
        4.06278133e-02])

        self.assertTrue(np.isclose(k,k_gt).all())

if __name__ == '__main__':
    unittest.main()
