/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.ProtectionDomain;
import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.engine.util.ProtectionDomainFactory;
import net.sf.jasperreports.engine.util.SingleProtectionDomainFactory;

public class JRClassLoader
extends ClassLoader {
    private static final Map<String, String> PRIMITIVE_COMPONENT_ENCODING = new HashMap<String, String>();
    private static ProtectionDomainFactory protectionDomainFactory;
    private ProtectionDomain protectionDomain;

    public static synchronized ProtectionDomainFactory getProtectionDomainFactory() {
        if (protectionDomainFactory == null) {
            protectionDomainFactory = new SingleProtectionDomainFactory(JRClassLoader.class.getProtectionDomain());
        }
        return protectionDomainFactory;
    }

    public static void setProtectionDomain(ProtectionDomain protectionDomain) {
        SingleProtectionDomainFactory factory = new SingleProtectionDomainFactory(protectionDomain);
        JRClassLoader.setProtectionDomainFactory(factory);
    }

    public static void setProtectionDomainFactory(ProtectionDomainFactory protectionDomainFactory) {
        JRClassLoader.protectionDomainFactory = protectionDomainFactory;
    }

    protected JRClassLoader() {
    }

    protected JRClassLoader(ClassLoader parent) {
        super(parent);
    }

    public static Class<?> loadClassForName(String className) throws ClassNotFoundException {
        Class<?> clazz = null;
        String classRealName = className;
        ClassNotFoundException initialEx = null;
        try {
            clazz = JRClassLoader.loadClassForRealName(classRealName);
        }
        catch (ClassNotFoundException e) {
            initialEx = e;
        }
        int lastDotIndex = 0;
        while (clazz == null && (lastDotIndex = classRealName.lastIndexOf(46)) > 0) {
            classRealName = classRealName.substring(0, lastDotIndex) + "$" + classRealName.substring(lastDotIndex + 1);
            try {
                clazz = JRClassLoader.loadClassForRealName(classRealName);
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        if (clazz == null) {
            throw initialEx;
        }
        return clazz;
    }

    public static Class<?> loadClassForRealName(String className) throws ClassNotFoundException {
        Class<?> clazz = null;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader != null) {
            try {
                clazz = Class.forName(className, true, classLoader);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (clazz == null) {
            classLoader = JRClassLoader.class.getClassLoader();
            clazz = classLoader == null ? Class.forName(className) : Class.forName(className, true, classLoader);
        }
        return clazz;
    }

    public static Class<?> loadClassFromFile(String className, File file) throws IOException {
        Class<?> clazz = null;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader != null) {
            try {
                clazz = new JRClassLoader(classLoader).loadClass(className, file);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
        }
        if (clazz == null) {
            classLoader = JRClassLoader.class.getClassLoader();
            clazz = classLoader == null ? new JRClassLoader().loadClass(className, file) : new JRClassLoader(classLoader).loadClass(className, file);
        }
        return clazz;
    }

    public static Class<?> loadClassFromBytes(String className, byte[] bytecodes) {
        Class<?> clazz = null;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader != null) {
            try {
                clazz = new JRClassLoader(classLoader).loadClass(className, bytecodes);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
        }
        if (clazz == null) {
            classLoader = JRClassLoader.class.getClassLoader();
            clazz = classLoader == null ? new JRClassLoader().loadClass(className, bytecodes) : new JRClassLoader(classLoader).loadClass(className, bytecodes);
        }
        return clazz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Class<?> loadClass(String className, File file) throws IOException {
        FileInputStream fis = null;
        ByteArrayOutputStream baos = null;
        byte[] bytecodes = new byte[10000];
        int ln = 0;
        try {
            fis = new FileInputStream(file);
            baos = new ByteArrayOutputStream();
            while ((ln = fis.read(bytecodes)) > 0) {
                baos.write(bytecodes, 0, ln);
            }
            baos.flush();
        }
        finally {
            if (baos != null) {
                try {
                    baos.close();
                }
                catch (IOException iOException) {}
            }
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
        }
        return this.loadClass(className, baos.toByteArray());
    }

    protected synchronized ProtectionDomain getProtectionDomain() {
        if (this.protectionDomain == null) {
            this.protectionDomain = JRClassLoader.getProtectionDomainFactory().getProtectionDomain(this);
        }
        return this.protectionDomain;
    }

    protected Class<?> loadClass(String className, byte[] bytecodes) {
        Class<?> clazz = null;
        clazz = this.defineClass(className, bytecodes, 0, bytecodes.length, this.getProtectionDomain());
        return clazz;
    }

    public static String getClassRealName(String className) {
        if (className == null) {
            return null;
        }
        int arrayDimension = 0;
        int classNameEnd = className.length();
        int index = 0;
        int pos = 0;
        while (index < classNameEnd && (pos = className.indexOf(91, index)) >= 0) {
            if (index == 0) {
                classNameEnd = pos;
            }
            index = pos;
            ++arrayDimension;
        }
        if (arrayDimension > 0) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < arrayDimension; ++i) {
                sb.append('[');
            }
            String componentClass = className.substring(0, classNameEnd);
            String primitiveEncoding = PRIMITIVE_COMPONENT_ENCODING.get(componentClass);
            if (primitiveEncoding == null) {
                sb.append('L');
                sb.append(componentClass);
                sb.append(';');
            } else {
                sb.append(primitiveEncoding);
            }
            return sb.toString();
        }
        return className;
    }

    static {
        PRIMITIVE_COMPONENT_ENCODING.put(Boolean.TYPE.getName(), "Z");
        PRIMITIVE_COMPONENT_ENCODING.put(Byte.TYPE.getName(), "B");
        PRIMITIVE_COMPONENT_ENCODING.put(Character.TYPE.getName(), "C");
        PRIMITIVE_COMPONENT_ENCODING.put(Double.TYPE.getName(), "D");
        PRIMITIVE_COMPONENT_ENCODING.put(Float.TYPE.getName(), "F");
        PRIMITIVE_COMPONENT_ENCODING.put(Integer.TYPE.getName(), "I");
        PRIMITIVE_COMPONENT_ENCODING.put(Long.TYPE.getName(), "J");
        PRIMITIVE_COMPONENT_ENCODING.put(Short.TYPE.getName(), "S");
    }
}

