/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fonts;

import java.awt.Font;
import java.awt.FontFormatException;
import java.io.IOException;
import java.io.InputStream;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRCloneable;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.fonts.FontFace;
import net.sf.jasperreports.engine.fonts.FontUtil;
import net.sf.jasperreports.engine.fonts.InvalidFontException;
import net.sf.jasperreports.repo.RepositoryUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SimpleFontFace
implements FontFace,
JRCloneable {
    private static final Log log = LogFactory.getLog(SimpleFontFace.class);
    private JasperReportsContext jasperReportsContext;
    private String ttf;
    private Font font;
    private String pdf;
    private String eot;
    private String svg;
    private String woff;

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new JRRuntimeException(e);
        }
    }

    public static SimpleFontFace getInstance(JasperReportsContext jasperReportsContext, String fontName) {
        SimpleFontFace fontFace = null;
        if (fontName != null) {
            fontFace = new SimpleFontFace(jasperReportsContext);
            fontFace.setTtf(fontName);
        }
        return fontFace;
    }

    public SimpleFontFace(JasperReportsContext jasperReportsContext, String ttf) {
        this(jasperReportsContext);
        this.setTtf(ttf);
    }

    public SimpleFontFace(String file) {
        this(DefaultJasperReportsContext.getInstance());
        this.setTtf(file);
    }

    public SimpleFontFace(Font font) {
        this.font = font;
    }

    public SimpleFontFace(JasperReportsContext jasperReportsContext) {
        this.jasperReportsContext = jasperReportsContext;
    }

    @Override
    public String getName() {
        return this.font == null ? null : this.font.getName();
    }

    @Override
    public String getFile() {
        return this.getTtf();
    }

    @Override
    public String getTtf() {
        return this.ttf;
    }

    public void setTtf(String ttf) {
        this.setTtf(ttf, true);
    }

    public void setTtf(String ttf, boolean load) {
        this.ttf = ttf;
        this.font = null;
        if (load) {
            this.loadFont();
        }
    }

    public void loadFont() throws InvalidFontException {
        if (this.ttf != null && this.font == null) {
            String upperCaseTtf;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Loading font " + this.ttf));
            }
            if ((upperCaseTtf = this.ttf.trim().toUpperCase()).endsWith(".TTF") || upperCaseTtf.endsWith(".OTF")) {
                InputStream is = null;
                try {
                    is = RepositoryUtil.getInstance(this.jasperReportsContext).getInputStreamFromLocation(this.ttf);
                }
                catch (JRException e) {
                    throw new InvalidFontException(this.ttf, e);
                }
                try {
                    this.font = Font.createFont(0, is);
                }
                catch (FontFormatException e) {
                    throw new InvalidFontException(this.ttf, e);
                }
                catch (IOException e) {
                    throw new InvalidFontException(this.ttf, e);
                }
                finally {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            FontUtil.getInstance(this.jasperReportsContext).checkAwtFont(this.ttf, JRPropertiesUtil.getInstance(this.jasperReportsContext).getBooleanProperty("net.sf.jasperreports.awt.ignore.missing.font"));
            this.font = new Font(this.ttf, 0, JRPropertiesUtil.getInstance(this.jasperReportsContext).getIntegerProperty("net.sf.jasperreports.default.font.size"));
        }
    }

    @Override
    public Font getFont() {
        return this.font;
    }

    @Override
    public String getPdf() {
        return this.pdf;
    }

    public void setPdf(String pdf) {
        this.pdf = pdf;
    }

    @Override
    public String getEot() {
        return this.eot;
    }

    public void setEot(String eot) {
        this.eot = eot;
    }

    @Override
    public String getSvg() {
        return this.svg;
    }

    public void setSvg(String svg) {
        this.svg = svg;
    }

    @Override
    public String getWoff() {
        return this.woff;
    }

    public void setWoff(String woff) {
        this.woff = woff;
    }
}

