/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfGraphics2D;
import java.awt.Font;
import java.awt.Shape;
import java.awt.font.GlyphVector;
import java.awt.font.TextAttribute;
import java.text.AttributedCharacterIterator;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.sf.jasperreports.engine.export.JRPdfExporter;

public class PdfGlyphGraphics2D
extends PdfGraphics2D {
    private static final float BOLD_STRIKE_FACTOR = 0.033333335f;
    private static final float ITALIC_ANGLE = 0.21256f;
    private boolean initialized = true;
    private PdfContentByte pdfContentByte;
    private JRPdfExporter pdfExporter;
    private Locale locale;

    public PdfGlyphGraphics2D(PdfContentByte pdfContentByte, JRPdfExporter pdfExporter, Locale locale) {
        super(pdfContentByte, (float)pdfExporter.getCurrentPageFormat().getPageWidth().intValue(), (float)pdfExporter.getCurrentPageFormat().getPageHeight().intValue(), null, true, false, 0.0f);
        this.pdfContentByte = pdfContentByte;
        this.pdfExporter = pdfExporter;
        this.locale = locale;
    }

    public void clip(Shape s) {
        if (!this.initialized) {
            return;
        }
        super.clip(s);
    }

    public void drawGlyphVector(GlyphVector glyphVector, float x, float y) {
        Font awtFont = glyphVector.getFont();
        HashMap<AttributedCharacterIterator.Attribute, Object> fontAttrs = new HashMap<AttributedCharacterIterator.Attribute, Object>();
        Map<TextAttribute, ?> awtFontAttributes = awtFont.getAttributes();
        fontAttrs.putAll(awtFontAttributes);
        com.lowagie.text.Font currentFont = this.pdfExporter.getFont(fontAttrs, this.locale, false);
        boolean bold = (currentFont.getStyle() & 1) != 0;
        boolean italic = (currentFont.getStyle() & 2) != 0;
        PdfContentByte text = this.pdfContentByte.getDuplicate();
        text.beginText();
        float[] originalCoords = new float[]{x, y};
        float[] transformedCoors = new float[2];
        this.getTransform().transform(originalCoords, 0, transformedCoors, 0, 1);
        text.setTextMatrix(1.0f, 0.0f, italic ? 0.21256f : 0.0f, 1.0f, transformedCoors[0], (float)this.pdfExporter.getCurrentPageFormat().getPageHeight().intValue() - transformedCoors[1]);
        double scaleX = awtFont.getTransform().getScaleX();
        double scaleY = awtFont.getTransform().getScaleY();
        double minScale = Math.min(scaleX, scaleY);
        text.setFontAndSize(currentFont.getBaseFont(), (float)(minScale * (double)awtFont.getSize2D()));
        if (bold) {
            text.setTextRenderingMode(2);
            text.setLineWidth(currentFont.getSize() * 0.033333335f);
            text.setColorStroke(this.getColor());
        }
        text.setColorFill(this.getColor());
        text.showText(glyphVector);
        text.resetRGBColorFill();
        if (bold) {
            text.setTextRenderingMode(0);
            text.setLineWidth(1.0f);
            text.resetRGBColorStroke();
        }
        text.endText();
        this.pdfContentByte.add(text);
    }
}

