/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.runtime.tree;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org.antlr.runtime.tree.BaseTree;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.CommonTreeAdaptor;
import org.antlr.runtime.tree.Tree;
import org.antlr.runtime.tree.TreeAdaptor;
import org.antlr.runtime.tree.TreeNodeStream;

public class CommonTreeNodeStream
implements TreeNodeStream,
Iterator {
    public static final int INITIAL_LOOKAHEAD_BUFFER_SIZE = 5;
    public static final DummyTree DOWN = new NavDownNode();
    public static final DummyTree UP = new NavUpNode();
    public static final DummyTree EOF_NODE = new EOFNode();
    protected boolean uniqueNavigationNodes = false;
    protected Tree root;
    TreeAdaptor adaptor;
    protected Stack nodeStack = new Stack();
    protected Stack indexStack = new Stack();
    protected int lastMarker;
    protected Tree currentNode;
    protected Tree previousNode;
    protected int currentChildIndex;
    protected int absoluteNodeIndex;
    protected Tree[] lookahead = new Tree[5];
    protected int head;
    protected int tail;
    protected List markers;

    public CommonTreeNodeStream(Tree tree) {
        this(new CommonTreeAdaptor(), tree);
    }

    public CommonTreeNodeStream(TreeAdaptor treeAdaptor, Tree tree) {
        this.root = tree;
        this.adaptor = treeAdaptor;
        this.reset();
    }

    public void reset() {
        this.currentNode = this.root;
        this.previousNode = null;
        this.currentChildIndex = -1;
        this.absoluteNodeIndex = -1;
        this.tail = 0;
        this.head = 0;
    }

    public Object LT(int n) {
        if (n == -1) {
            return this.previousNode;
        }
        if (n < 0) {
            throw new IllegalArgumentException("tree node streams cannot look backwards more than 1 node");
        }
        if (n == 0) {
            return Tree.INVALID_NODE;
        }
        this.fill(n);
        return this.lookahead[(this.head + n - 1) % this.lookahead.length];
    }

    public Object getTreeSource() {
        return this.root;
    }

    protected void fill(int n) {
        int n2 = this.getLookaheadSize();
        for (int i = 1; i <= n - n2; ++i) {
            this.next();
        }
    }

    protected void addLookahead(Tree tree) {
        this.lookahead[this.tail] = tree;
        this.tail = (this.tail + 1) % this.lookahead.length;
        if (this.tail == this.head) {
            Tree[] treeArray = new Tree[2 * this.lookahead.length];
            int n = this.lookahead.length - this.head;
            System.arraycopy(this.lookahead, this.head, treeArray, 0, n);
            System.arraycopy(this.lookahead, 0, treeArray, n, this.tail);
            this.lookahead = treeArray;
            this.head = 0;
            this.tail += n;
        }
    }

    public void consume() {
        this.fill(1);
        ++this.absoluteNodeIndex;
        this.previousNode = this.lookahead[this.head];
        this.head = (this.head + 1) % this.lookahead.length;
    }

    public int LA(int n) {
        Tree tree = (Tree)this.LT(n);
        if (tree == null) {
            return 0;
        }
        return tree.getType();
    }

    public int mark() {
        if (this.markers == null) {
            this.markers = new ArrayList();
        }
        TreeWalkState treeWalkState = new TreeWalkState();
        treeWalkState.absoluteNodeIndex = this.absoluteNodeIndex;
        treeWalkState.currentChildIndex = this.currentChildIndex;
        treeWalkState.currentNode = this.currentNode;
        treeWalkState.previousNode = this.previousNode;
        treeWalkState.nodeStackSize = this.nodeStack.size();
        treeWalkState.indexStackSize = this.indexStack.size();
        int n = this.getLookaheadSize();
        int n2 = 0;
        treeWalkState.lookahead = new Tree[n];
        int n3 = 1;
        while (n3 <= n) {
            treeWalkState.lookahead[n2] = (Tree)this.LT(n3);
            ++n3;
            ++n2;
        }
        this.markers.add(treeWalkState);
        return this.markers.size();
    }

    public void release(int n) {
        throw new NoSuchMethodError("can't release tree parse; email parrt@antlr.org");
    }

    public void rewind(int n) {
        if (this.markers == null || this.markers.size() < n) {
            return;
        }
        TreeWalkState treeWalkState = (TreeWalkState)this.markers.get(n - 1);
        this.markers.remove(n - 1);
        this.absoluteNodeIndex = treeWalkState.absoluteNodeIndex;
        this.currentChildIndex = treeWalkState.currentChildIndex;
        this.currentNode = treeWalkState.currentNode;
        this.previousNode = treeWalkState.previousNode;
        this.nodeStack.setSize(treeWalkState.nodeStackSize);
        this.indexStack.setSize(treeWalkState.indexStackSize);
        this.tail = 0;
        this.head = 0;
        while (this.tail < treeWalkState.lookahead.length) {
            this.lookahead[this.tail] = treeWalkState.lookahead[this.tail];
            ++this.tail;
        }
    }

    public void rewind() {
        this.rewind(this.lastMarker);
    }

    public void seek(int n) {
        if (n < this.index()) {
            throw new IllegalArgumentException("can't seek backwards in node stream");
        }
        while (this.index() < n) {
            this.consume();
        }
    }

    public int index() {
        return this.absoluteNodeIndex + 1;
    }

    public int size() {
        return this.absoluteNodeIndex + 1;
    }

    public boolean hasNext() {
        return this.currentNode != null;
    }

    public Object next() {
        if (this.currentNode == null) {
            this.addLookahead(EOF_NODE);
            return null;
        }
        if (this.currentChildIndex == -1) {
            return this.handleRootNode();
        }
        if (this.currentChildIndex < this.currentNode.getChildCount()) {
            return this.visitChild(this.currentChildIndex);
        }
        this.walkBackToMostRecentNodeWithUnvisitedChildren();
        if (this.currentNode != null) {
            return this.visitChild(this.currentChildIndex);
        }
        return null;
    }

    protected Tree handleRootNode() {
        Tree tree = this.currentNode;
        this.currentChildIndex = 0;
        if (tree.isNil()) {
            tree = this.visitChild(this.currentChildIndex);
        } else {
            this.addLookahead(tree);
            if (this.currentNode.getChildCount() == 0) {
                this.currentNode = null;
            }
        }
        return tree;
    }

    protected Tree visitChild(int n) {
        Tree tree = null;
        this.nodeStack.push(this.currentNode);
        this.indexStack.push(new Integer(n));
        if (n == 0 && !this.currentNode.isNil()) {
            this.addNavigationNode(2);
        }
        this.currentNode = this.currentNode.getChild(n);
        this.currentChildIndex = 0;
        tree = this.currentNode;
        this.addLookahead(tree);
        this.walkBackToMostRecentNodeWithUnvisitedChildren();
        return tree;
    }

    protected void addNavigationNode(int n) {
        DummyTree dummyTree = null;
        dummyTree = n == 2 ? (this.hasUniqueNavigationNodes() ? new NavDownNode() : DOWN) : (this.hasUniqueNavigationNodes() ? new NavUpNode() : UP);
        this.addLookahead(dummyTree);
    }

    protected void walkBackToMostRecentNodeWithUnvisitedChildren() {
        while (this.currentNode != null && this.currentChildIndex >= this.currentNode.getChildCount()) {
            this.currentNode = (Tree)this.nodeStack.pop();
            this.currentChildIndex = (Integer)this.indexStack.pop();
            ++this.currentChildIndex;
            if (this.currentChildIndex < this.currentNode.getChildCount()) continue;
            if (!this.currentNode.isNil()) {
                this.addNavigationNode(3);
            }
            if (this.currentNode != this.root) continue;
            this.currentNode = null;
        }
    }

    public void remove() {
        throw new NoSuchMethodError();
    }

    public TreeAdaptor getTreeAdaptor() {
        return this.adaptor;
    }

    public boolean hasUniqueNavigationNodes() {
        return this.uniqueNavigationNodes;
    }

    public void setUniqueNavigationNodes(boolean bl) {
        this.uniqueNavigationNodes = bl;
    }

    public String toNodesOnlyString() {
        StringBuffer stringBuffer = new StringBuffer();
        while (this.hasNext()) {
            CommonTree commonTree = (CommonTree)this.next();
            stringBuffer.append(" ");
            stringBuffer.append(commonTree.getType());
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return this.toString(this.root, null);
    }

    protected int getLookaheadSize() {
        return this.tail < this.head ? this.lookahead.length - this.head + this.tail : this.tail - this.head;
    }

    public String toString(Object object, Object object2) {
        StringBuffer stringBuffer = new StringBuffer();
        this.toStringWork((Tree)object, (Tree)object2, stringBuffer);
        return stringBuffer.toString();
    }

    protected void toStringWork(Tree tree, Tree tree2, StringBuffer stringBuffer) {
        if (!tree.isNil()) {
            String string = ((Object)tree).toString();
            if (string == null) {
                string = " " + String.valueOf(tree.getType());
            }
            stringBuffer.append(string);
        }
        if (tree == tree2) {
            return;
        }
        int n = tree.getChildCount();
        if (n > 0 && !tree.isNil()) {
            stringBuffer.append(" ");
            stringBuffer.append(2);
        }
        for (int i = 0; i < n; ++i) {
            Tree tree3 = tree.getChild(i);
            this.toStringWork(tree3, tree2, stringBuffer);
        }
        if (n > 0 && !tree.isNil()) {
            stringBuffer.append(" ");
            stringBuffer.append(3);
        }
    }

    protected class TreeWalkState {
        int currentChildIndex;
        int absoluteNodeIndex;
        Tree currentNode;
        Tree previousNode;
        int nodeStackSize;
        int indexStackSize;
        Tree[] lookahead;

        protected TreeWalkState() {
        }
    }

    public static class EOFNode
    extends DummyTree {
        public int getType() {
            return -1;
        }

        public String getText() {
            return "EOF";
        }

        public String toString() {
            return "EOF";
        }
    }

    public static class NavUpNode
    extends DummyTree {
        public int getType() {
            return 3;
        }

        public String getText() {
            return "UP";
        }

        public String toString() {
            return "UP";
        }
    }

    public static class NavDownNode
    extends DummyTree {
        public int getType() {
            return 2;
        }

        public String getText() {
            return "DOWN";
        }

        public String toString() {
            return "DOWN";
        }
    }

    protected static abstract class DummyTree
    extends BaseTree {
        protected DummyTree() {
        }

        public Tree dupNode() {
            return null;
        }
    }
}

