/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.runtime.debug;

import org.antlr.runtime.Token;
import org.antlr.runtime.debug.DebugEventListener;
import org.antlr.runtime.tree.TreeAdaptor;

public class DebugTreeAdaptor
implements TreeAdaptor {
    protected DebugEventListener dbg;
    protected TreeAdaptor adaptor;

    public DebugTreeAdaptor(DebugEventListener debugEventListener, TreeAdaptor treeAdaptor) {
        this.dbg = debugEventListener;
        this.adaptor = treeAdaptor;
    }

    public Object create(Token token) {
        Object object = this.adaptor.create(token);
        this.dbg.createNode(this.adaptor.getUniqueID(object), token.getTokenIndex());
        return object;
    }

    public Object dupTree(Object object) {
        return this.adaptor.dupTree(object);
    }

    public Object dupNode(Object object) {
        return this.adaptor.dupNode(object);
    }

    public Object nil() {
        Object object = this.adaptor.nil();
        this.dbg.nilNode(this.adaptor.getUniqueID(object));
        return object;
    }

    public void addChild(Object object, Object object2) {
        this.adaptor.addChild(object, object2);
        this.dbg.addChild(this.adaptor.getUniqueID(object), this.adaptor.getUniqueID(object2));
    }

    public Object becomeRoot(Object object, Object object2) {
        Object object3 = this.adaptor.becomeRoot(object, object2);
        this.dbg.becomeRoot(this.adaptor.getUniqueID(object3), this.adaptor.getUniqueID(object2));
        return object3;
    }

    public Object rulePostProcessing(Object object) {
        return this.adaptor.rulePostProcessing(object);
    }

    public void addChild(Object object, Token token) {
        Object object2 = this.create(token);
        this.addChild(object, object2);
    }

    public Object becomeRoot(Token token, Object object) {
        Object object2 = this.create(token);
        this.adaptor.becomeRoot(object2, object);
        this.dbg.becomeRoot(this.adaptor.getUniqueID(object2), this.adaptor.getUniqueID(object));
        return object2;
    }

    public Object create(int n, Token token) {
        Object object = this.adaptor.create(n, token);
        this.dbg.createNode(this.adaptor.getUniqueID(object), token.getText(), n);
        return object;
    }

    public Object create(int n, Token token, String string) {
        Object object = this.adaptor.create(n, token, string);
        this.dbg.createNode(this.adaptor.getUniqueID(object), string, n);
        return object;
    }

    public Object create(int n, String string) {
        Object object = this.adaptor.create(n, string);
        this.dbg.createNode(this.adaptor.getUniqueID(object), string, n);
        return object;
    }

    public int getType(Object object) {
        return this.adaptor.getType(object);
    }

    public void setType(Object object, int n) {
        this.adaptor.setType(object, n);
    }

    public String getText(Object object) {
        return this.adaptor.getText(object);
    }

    public void setText(Object object, String string) {
        this.adaptor.setText(object, string);
    }

    public void setTokenBoundaries(Object object, Token token, Token token2) {
        this.adaptor.setTokenBoundaries(object, token, token2);
        if (object != null && token != null && token2 != null) {
            this.dbg.setTokenBoundaries(this.adaptor.getUniqueID(object), token.getTokenIndex(), token2.getTokenIndex());
        }
    }

    public int getTokenStartIndex(Object object) {
        return this.adaptor.getTokenStartIndex(object);
    }

    public int getTokenStopIndex(Object object) {
        return this.adaptor.getTokenStopIndex(object);
    }

    public Object getChild(Object object, int n) {
        return this.adaptor.getChild(object, n);
    }

    public int getChildCount(Object object) {
        return this.adaptor.getChildCount(object);
    }

    public int getUniqueID(Object object) {
        return this.adaptor.getUniqueID(object);
    }

    public DebugEventListener getDebugEventListener() {
        return this.dbg;
    }

    public TreeAdaptor getTreeAdaptor() {
        return this.adaptor;
    }
}

