#!/usr/bin/env python3
# encoding: utf-8

import setuptools

#with open("README.md", "r") as fh:
#    long_description = fh.read()

long_description = """

# Network file share space out of control? FileCensus can fix that.

Old files, unused apps, and employees' personal files all suck up valuable storage space, slow down file searches, increase data storage costs, and cause a ton of other storage issues.

What if you could reclaim that space, reduce costs, avoid future issues, and plan for your company's future needs all in just a couple of clicks?


## Whether you want to recover more space, migrate data, or plan for the future, our Storage Resource Management (SRM) tool makes it easy.

FileCensus provides the insights and answers to what is claiming your storage space. and why.


# More Space, Better Performance, Recovered Costs.

It's easy to implement and easier to use. With FileCensus you can:

## Find Files.

Find any file you need in an instant with fine-tuned queries. Plus, receive FileCensus' instantly generated, easy-to-understand reports that display the file types, used space, and available space across your entire storage environment.

## Recover Space.

Optimize your data storage and maximize your file storage investments. And all in just a few clicks. FileCensus' powerful automation capabilities allow you to schedule scans, script deletions, and typically recover up to 40% of your data storage environment.

## Predict Growth.

Identify data growth rates and usage patterns with analytical insights, so you can accurately forecast and plan for future data storage needs and expenditures.

# A storage management tool without support is just another expense you don't need.

FileCensus is more than software: it's a team of experts dedicated to supporting you and continuously improving your storage management.

The right equipment combined with the right team lowers overall costs and reduces unplanned storage problems. FileCensus empowers you to work faster and smarter.

# Start Understanding Your Environment for FREE with FileCensus

## Download to rapidly get more value out of your current storage environment.

https://www.intermine.com/resources/

"""

setuptools.setup(
    name="FileCensus",
    version="4.42.10",
    author="Scott McCallum (https intermine.com)",
    author_email="Sales@Intermine.com",
    description="FileCensus provides the insights and answers to what is claiming your storage space. and why.",
    long_description=long_description,
    long_description_content_type="text/markdown",
    url="https://intermine.com",
    packages=setuptools.find_packages(),
    classifiers=[
        "Programming Language :: Python :: 3",
        "Operating System :: OS Independent",
    ],
    python_requires='>=3.6',
)
