# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from ... import _serialization

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models


class ApiError(_serialization.Model):
    """Api error.

    :ivar details: The Api error details.
    :vartype details: list[~azure.mgmt.compute.v2022_03_03.models.ApiErrorBase]
    :ivar innererror: The Api inner error.
    :vartype innererror: ~azure.mgmt.compute.v2022_03_03.models.InnerError
    :ivar code: The error code.
    :vartype code: str
    :ivar target: The target of the particular error.
    :vartype target: str
    :ivar message: The error message.
    :vartype message: str
    """

    _attribute_map = {
        "details": {"key": "details", "type": "[ApiErrorBase]"},
        "innererror": {"key": "innererror", "type": "InnerError"},
        "code": {"key": "code", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(
        self,
        *,
        details: Optional[List["_models.ApiErrorBase"]] = None,
        innererror: Optional["_models.InnerError"] = None,
        code: Optional[str] = None,
        target: Optional[str] = None,
        message: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword details: The Api error details.
        :paramtype details: list[~azure.mgmt.compute.v2022_03_03.models.ApiErrorBase]
        :keyword innererror: The Api inner error.
        :paramtype innererror: ~azure.mgmt.compute.v2022_03_03.models.InnerError
        :keyword code: The error code.
        :paramtype code: str
        :keyword target: The target of the particular error.
        :paramtype target: str
        :keyword message: The error message.
        :paramtype message: str
        """
        super().__init__(**kwargs)
        self.details = details
        self.innererror = innererror
        self.code = code
        self.target = target
        self.message = message


class ApiErrorBase(_serialization.Model):
    """Api error base.

    :ivar code: The error code.
    :vartype code: str
    :ivar target: The target of the particular error.
    :vartype target: str
    :ivar message: The error message.
    :vartype message: str
    """

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(
        self, *, code: Optional[str] = None, target: Optional[str] = None, message: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword code: The error code.
        :paramtype code: str
        :keyword target: The target of the particular error.
        :paramtype target: str
        :keyword message: The error message.
        :paramtype message: str
        """
        super().__init__(**kwargs)
        self.code = code
        self.target = target
        self.message = message


class PirCommunityGalleryResource(_serialization.Model):
    """Base information about the community gallery resource in pir.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Resource name.
    :vartype name: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar unique_id: The unique id of this community gallery.
    :vartype unique_id: str
    """

    _validation = {
        "name": {"readonly": True},
        "location": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "unique_id": {"key": "identifier.uniqueId", "type": "str"},
    }

    def __init__(self, *, unique_id: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword unique_id: The unique id of this community gallery.
        :paramtype unique_id: str
        """
        super().__init__(**kwargs)
        self.name = None
        self.location = None
        self.type = None
        self.unique_id = unique_id


class CommunityGallery(PirCommunityGalleryResource):
    """Specifies information about the Community Gallery that you want to create or update.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Resource name.
    :vartype name: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar unique_id: The unique id of this community gallery.
    :vartype unique_id: str
    """

    _validation = {
        "name": {"readonly": True},
        "location": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "unique_id": {"key": "identifier.uniqueId", "type": "str"},
    }

    def __init__(self, *, unique_id: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword unique_id: The unique id of this community gallery.
        :paramtype unique_id: str
        """
        super().__init__(unique_id=unique_id, **kwargs)


class CommunityGalleryImage(PirCommunityGalleryResource):  # pylint: disable=too-many-instance-attributes
    """Specifies information about the gallery image definition that you want to create or update.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Resource name.
    :vartype name: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar unique_id: The unique id of this community gallery.
    :vartype unique_id: str
    :ivar os_type: This property allows you to specify the type of the OS that is included in the
     disk when creating a VM from a managed image. :code:`<br>`:code:`<br>` Possible values are:
     :code:`<br>`:code:`<br>` **Windows** :code:`<br>`:code:`<br>` **Linux**. Known values are:
     "Windows" and "Linux".
    :vartype os_type: str or ~azure.mgmt.compute.v2022_03_03.models.OperatingSystemTypes
    :ivar os_state: This property allows the user to specify whether the virtual machines created
     under this image are 'Generalized' or 'Specialized'. Known values are: "Generalized" and
     "Specialized".
    :vartype os_state: str or ~azure.mgmt.compute.v2022_03_03.models.OperatingSystemStateTypes
    :ivar end_of_life_date: The end of life date of the gallery image definition. This property can
     be used for decommissioning purposes. This property is updatable.
    :vartype end_of_life_date: ~datetime.datetime
    :ivar identifier: This is the community gallery image definition identifier.
    :vartype identifier: ~azure.mgmt.compute.v2022_03_03.models.CommunityGalleryImageIdentifier
    :ivar recommended: The properties describe the recommended machine configuration for this Image
     Definition. These properties are updatable.
    :vartype recommended: ~azure.mgmt.compute.v2022_03_03.models.RecommendedMachineConfiguration
    :ivar disallowed: Describes the disallowed disk types.
    :vartype disallowed: ~azure.mgmt.compute.v2022_03_03.models.Disallowed
    :ivar hyper_v_generation: The hypervisor generation of the Virtual Machine. Applicable to OS
     disks only. Known values are: "V1" and "V2".
    :vartype hyper_v_generation: str or ~azure.mgmt.compute.v2022_03_03.models.HyperVGeneration
    :ivar features: A list of gallery image features.
    :vartype features: list[~azure.mgmt.compute.v2022_03_03.models.GalleryImageFeature]
    :ivar purchase_plan: Describes the gallery image definition purchase plan. This is used by
     marketplace images.
    :vartype purchase_plan: ~azure.mgmt.compute.v2022_03_03.models.ImagePurchasePlan
    :ivar architecture: The architecture of the image. Applicable to OS disks only. Known values
     are: "x64" and "Arm64".
    :vartype architecture: str or ~azure.mgmt.compute.v2022_03_03.models.Architecture
    :ivar privacy_statement_uri: Privacy statement uri for the current community gallery image.
    :vartype privacy_statement_uri: str
    :ivar eula: End-user license agreement for the current community gallery image.
    :vartype eula: str
    """

    _validation = {
        "name": {"readonly": True},
        "location": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "unique_id": {"key": "identifier.uniqueId", "type": "str"},
        "os_type": {"key": "properties.osType", "type": "str"},
        "os_state": {"key": "properties.osState", "type": "str"},
        "end_of_life_date": {"key": "properties.endOfLifeDate", "type": "iso-8601"},
        "identifier": {"key": "properties.identifier", "type": "CommunityGalleryImageIdentifier"},
        "recommended": {"key": "properties.recommended", "type": "RecommendedMachineConfiguration"},
        "disallowed": {"key": "properties.disallowed", "type": "Disallowed"},
        "hyper_v_generation": {"key": "properties.hyperVGeneration", "type": "str"},
        "features": {"key": "properties.features", "type": "[GalleryImageFeature]"},
        "purchase_plan": {"key": "properties.purchasePlan", "type": "ImagePurchasePlan"},
        "architecture": {"key": "properties.architecture", "type": "str"},
        "privacy_statement_uri": {"key": "properties.privacyStatementUri", "type": "str"},
        "eula": {"key": "properties.eula", "type": "str"},
    }

    def __init__(
        self,
        *,
        unique_id: Optional[str] = None,
        os_type: Optional[Union[str, "_models.OperatingSystemTypes"]] = None,
        os_state: Optional[Union[str, "_models.OperatingSystemStateTypes"]] = None,
        end_of_life_date: Optional[datetime.datetime] = None,
        identifier: Optional["_models.CommunityGalleryImageIdentifier"] = None,
        recommended: Optional["_models.RecommendedMachineConfiguration"] = None,
        disallowed: Optional["_models.Disallowed"] = None,
        hyper_v_generation: Optional[Union[str, "_models.HyperVGeneration"]] = None,
        features: Optional[List["_models.GalleryImageFeature"]] = None,
        purchase_plan: Optional["_models.ImagePurchasePlan"] = None,
        architecture: Optional[Union[str, "_models.Architecture"]] = None,
        privacy_statement_uri: Optional[str] = None,
        eula: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword unique_id: The unique id of this community gallery.
        :paramtype unique_id: str
        :keyword os_type: This property allows you to specify the type of the OS that is included in
         the disk when creating a VM from a managed image. :code:`<br>`:code:`<br>` Possible values are:
         :code:`<br>`:code:`<br>` **Windows** :code:`<br>`:code:`<br>` **Linux**. Known values are:
         "Windows" and "Linux".
        :paramtype os_type: str or ~azure.mgmt.compute.v2022_03_03.models.OperatingSystemTypes
        :keyword os_state: This property allows the user to specify whether the virtual machines
         created under this image are 'Generalized' or 'Specialized'. Known values are: "Generalized"
         and "Specialized".
        :paramtype os_state: str or ~azure.mgmt.compute.v2022_03_03.models.OperatingSystemStateTypes
        :keyword end_of_life_date: The end of life date of the gallery image definition. This property
         can be used for decommissioning purposes. This property is updatable.
        :paramtype end_of_life_date: ~datetime.datetime
        :keyword identifier: This is the community gallery image definition identifier.
        :paramtype identifier: ~azure.mgmt.compute.v2022_03_03.models.CommunityGalleryImageIdentifier
        :keyword recommended: The properties describe the recommended machine configuration for this
         Image Definition. These properties are updatable.
        :paramtype recommended: ~azure.mgmt.compute.v2022_03_03.models.RecommendedMachineConfiguration
        :keyword disallowed: Describes the disallowed disk types.
        :paramtype disallowed: ~azure.mgmt.compute.v2022_03_03.models.Disallowed
        :keyword hyper_v_generation: The hypervisor generation of the Virtual Machine. Applicable to OS
         disks only. Known values are: "V1" and "V2".
        :paramtype hyper_v_generation: str or ~azure.mgmt.compute.v2022_03_03.models.HyperVGeneration
        :keyword features: A list of gallery image features.
        :paramtype features: list[~azure.mgmt.compute.v2022_03_03.models.GalleryImageFeature]
        :keyword purchase_plan: Describes the gallery image definition purchase plan. This is used by
         marketplace images.
        :paramtype purchase_plan: ~azure.mgmt.compute.v2022_03_03.models.ImagePurchasePlan
        :keyword architecture: The architecture of the image. Applicable to OS disks only. Known values
         are: "x64" and "Arm64".
        :paramtype architecture: str or ~azure.mgmt.compute.v2022_03_03.models.Architecture
        :keyword privacy_statement_uri: Privacy statement uri for the current community gallery image.
        :paramtype privacy_statement_uri: str
        :keyword eula: End-user license agreement for the current community gallery image.
        :paramtype eula: str
        """
        super().__init__(unique_id=unique_id, **kwargs)
        self.os_type = os_type
        self.os_state = os_state
        self.end_of_life_date = end_of_life_date
        self.identifier = identifier
        self.recommended = recommended
        self.disallowed = disallowed
        self.hyper_v_generation = hyper_v_generation
        self.features = features
        self.purchase_plan = purchase_plan
        self.architecture = architecture
        self.privacy_statement_uri = privacy_statement_uri
        self.eula = eula


class CommunityGalleryImageIdentifier(_serialization.Model):
    """This is the community gallery image definition identifier.

    :ivar publisher: The name of the gallery image definition publisher.
    :vartype publisher: str
    :ivar offer: The name of the gallery image definition offer.
    :vartype offer: str
    :ivar sku: The name of the gallery image definition SKU.
    :vartype sku: str
    """

    _attribute_map = {
        "publisher": {"key": "publisher", "type": "str"},
        "offer": {"key": "offer", "type": "str"},
        "sku": {"key": "sku", "type": "str"},
    }

    def __init__(
        self, *, publisher: Optional[str] = None, offer: Optional[str] = None, sku: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword publisher: The name of the gallery image definition publisher.
        :paramtype publisher: str
        :keyword offer: The name of the gallery image definition offer.
        :paramtype offer: str
        :keyword sku: The name of the gallery image definition SKU.
        :paramtype sku: str
        """
        super().__init__(**kwargs)
        self.publisher = publisher
        self.offer = offer
        self.sku = sku


class CommunityGalleryImageList(_serialization.Model):
    """The List Community Gallery Images operation response.

    All required parameters must be populated in order to send to Azure.

    :ivar value: A list of community gallery images. Required.
    :vartype value: list[~azure.mgmt.compute.v2022_03_03.models.CommunityGalleryImage]
    :ivar next_link: The uri to fetch the next page of community gallery images. Call ListNext()
     with this to fetch the next page of community gallery images.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[CommunityGalleryImage]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: List["_models.CommunityGalleryImage"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: A list of community gallery images. Required.
        :paramtype value: list[~azure.mgmt.compute.v2022_03_03.models.CommunityGalleryImage]
        :keyword next_link: The uri to fetch the next page of community gallery images. Call ListNext()
         with this to fetch the next page of community gallery images.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class CommunityGalleryImageVersion(PirCommunityGalleryResource):
    """Specifies information about the gallery image version that you want to create or update.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Resource name.
    :vartype name: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar unique_id: The unique id of this community gallery.
    :vartype unique_id: str
    :ivar published_date: The published date of the gallery image version Definition. This property
     can be used for decommissioning purposes. This property is updatable.
    :vartype published_date: ~datetime.datetime
    :ivar end_of_life_date: The end of life date of the gallery image version Definition. This
     property can be used for decommissioning purposes. This property is updatable.
    :vartype end_of_life_date: ~datetime.datetime
    :ivar exclude_from_latest: If set to true, Virtual Machines deployed from the latest version of
     the Image Definition won't use this Image Version.
    :vartype exclude_from_latest: bool
    :ivar storage_profile: Describes the storage profile of the image version.
    :vartype storage_profile:
     ~azure.mgmt.compute.v2022_03_03.models.SharedGalleryImageVersionStorageProfile
    """

    _validation = {
        "name": {"readonly": True},
        "location": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "unique_id": {"key": "identifier.uniqueId", "type": "str"},
        "published_date": {"key": "properties.publishedDate", "type": "iso-8601"},
        "end_of_life_date": {"key": "properties.endOfLifeDate", "type": "iso-8601"},
        "exclude_from_latest": {"key": "properties.excludeFromLatest", "type": "bool"},
        "storage_profile": {"key": "properties.storageProfile", "type": "SharedGalleryImageVersionStorageProfile"},
    }

    def __init__(
        self,
        *,
        unique_id: Optional[str] = None,
        published_date: Optional[datetime.datetime] = None,
        end_of_life_date: Optional[datetime.datetime] = None,
        exclude_from_latest: Optional[bool] = None,
        storage_profile: Optional["_models.SharedGalleryImageVersionStorageProfile"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword unique_id: The unique id of this community gallery.
        :paramtype unique_id: str
        :keyword published_date: The published date of the gallery image version Definition. This
         property can be used for decommissioning purposes. This property is updatable.
        :paramtype published_date: ~datetime.datetime
        :keyword end_of_life_date: The end of life date of the gallery image version Definition. This
         property can be used for decommissioning purposes. This property is updatable.
        :paramtype end_of_life_date: ~datetime.datetime
        :keyword exclude_from_latest: If set to true, Virtual Machines deployed from the latest version
         of the Image Definition won't use this Image Version.
        :paramtype exclude_from_latest: bool
        :keyword storage_profile: Describes the storage profile of the image version.
        :paramtype storage_profile:
         ~azure.mgmt.compute.v2022_03_03.models.SharedGalleryImageVersionStorageProfile
        """
        super().__init__(unique_id=unique_id, **kwargs)
        self.published_date = published_date
        self.end_of_life_date = end_of_life_date
        self.exclude_from_latest = exclude_from_latest
        self.storage_profile = storage_profile


class CommunityGalleryImageVersionList(_serialization.Model):
    """The List Community Gallery Image versions operation response.

    All required parameters must be populated in order to send to Azure.

    :ivar value: A list of community gallery image versions. Required.
    :vartype value: list[~azure.mgmt.compute.v2022_03_03.models.CommunityGalleryImageVersion]
    :ivar next_link: The uri to fetch the next page of community gallery image versions. Call
     ListNext() with this to fetch the next page of community gallery image versions.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[CommunityGalleryImageVersion]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: List["_models.CommunityGalleryImageVersion"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: A list of community gallery image versions. Required.
        :paramtype value: list[~azure.mgmt.compute.v2022_03_03.models.CommunityGalleryImageVersion]
        :keyword next_link: The uri to fetch the next page of community gallery image versions. Call
         ListNext() with this to fetch the next page of community gallery image versions.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class CommunityGalleryInfo(_serialization.Model):
    """Information of community gallery if current gallery is shared to community.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar publisher_uri: The link to the publisher website. Visible to all users.
    :vartype publisher_uri: str
    :ivar publisher_contact: Community gallery publisher support email. The email address of the
     publisher. Visible to all users.
    :vartype publisher_contact: str
    :ivar eula: End-user license agreement for community gallery image.
    :vartype eula: str
    :ivar public_name_prefix: The prefix of the gallery name that will be displayed publicly.
     Visible to all users.
    :vartype public_name_prefix: str
    :ivar community_gallery_enabled: Contains info about whether community gallery sharing is
     enabled.
    :vartype community_gallery_enabled: bool
    :ivar public_names: Community gallery public name list.
    :vartype public_names: list[str]
    """

    _validation = {
        "community_gallery_enabled": {"readonly": True},
        "public_names": {"readonly": True},
    }

    _attribute_map = {
        "publisher_uri": {"key": "publisherUri", "type": "str"},
        "publisher_contact": {"key": "publisherContact", "type": "str"},
        "eula": {"key": "eula", "type": "str"},
        "public_name_prefix": {"key": "publicNamePrefix", "type": "str"},
        "community_gallery_enabled": {"key": "communityGalleryEnabled", "type": "bool"},
        "public_names": {"key": "publicNames", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        publisher_uri: Optional[str] = None,
        publisher_contact: Optional[str] = None,
        eula: Optional[str] = None,
        public_name_prefix: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword publisher_uri: The link to the publisher website. Visible to all users.
        :paramtype publisher_uri: str
        :keyword publisher_contact: Community gallery publisher support email. The email address of the
         publisher. Visible to all users.
        :paramtype publisher_contact: str
        :keyword eula: End-user license agreement for community gallery image.
        :paramtype eula: str
        :keyword public_name_prefix: The prefix of the gallery name that will be displayed publicly.
         Visible to all users.
        :paramtype public_name_prefix: str
        """
        super().__init__(**kwargs)
        self.publisher_uri = publisher_uri
        self.publisher_contact = publisher_contact
        self.eula = eula
        self.public_name_prefix = public_name_prefix
        self.community_gallery_enabled = None
        self.public_names = None


class DiskImageEncryption(_serialization.Model):
    """This is the disk image encryption base class.

    :ivar disk_encryption_set_id: A relative URI containing the resource ID of the disk encryption
     set.
    :vartype disk_encryption_set_id: str
    """

    _attribute_map = {
        "disk_encryption_set_id": {"key": "diskEncryptionSetId", "type": "str"},
    }

    def __init__(self, *, disk_encryption_set_id: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword disk_encryption_set_id: A relative URI containing the resource ID of the disk
         encryption set.
        :paramtype disk_encryption_set_id: str
        """
        super().__init__(**kwargs)
        self.disk_encryption_set_id = disk_encryption_set_id


class DataDiskImageEncryption(DiskImageEncryption):
    """Contains encryption settings for a data disk image.

    All required parameters must be populated in order to send to Azure.

    :ivar disk_encryption_set_id: A relative URI containing the resource ID of the disk encryption
     set.
    :vartype disk_encryption_set_id: str
    :ivar lun: This property specifies the logical unit number of the data disk. This value is used
     to identify data disks within the Virtual Machine and therefore must be unique for each data
     disk attached to the Virtual Machine. Required.
    :vartype lun: int
    """

    _validation = {
        "lun": {"required": True},
    }

    _attribute_map = {
        "disk_encryption_set_id": {"key": "diskEncryptionSetId", "type": "str"},
        "lun": {"key": "lun", "type": "int"},
    }

    def __init__(self, *, lun: int, disk_encryption_set_id: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword disk_encryption_set_id: A relative URI containing the resource ID of the disk
         encryption set.
        :paramtype disk_encryption_set_id: str
        :keyword lun: This property specifies the logical unit number of the data disk. This value is
         used to identify data disks within the Virtual Machine and therefore must be unique for each
         data disk attached to the Virtual Machine. Required.
        :paramtype lun: int
        """
        super().__init__(disk_encryption_set_id=disk_encryption_set_id, **kwargs)
        self.lun = lun


class Disallowed(_serialization.Model):
    """Describes the disallowed disk types.

    :ivar disk_types: A list of disk types.
    :vartype disk_types: list[str]
    """

    _attribute_map = {
        "disk_types": {"key": "diskTypes", "type": "[str]"},
    }

    def __init__(self, *, disk_types: Optional[List[str]] = None, **kwargs: Any) -> None:
        """
        :keyword disk_types: A list of disk types.
        :paramtype disk_types: list[str]
        """
        super().__init__(**kwargs)
        self.disk_types = disk_types


class EncryptionImages(_serialization.Model):
    """Optional. Allows users to provide customer managed keys for encrypting the OS and data disks in
    the gallery artifact.

    :ivar os_disk_image: Contains encryption settings for an OS disk image.
    :vartype os_disk_image: ~azure.mgmt.compute.v2022_03_03.models.OSDiskImageEncryption
    :ivar data_disk_images: A list of encryption specifications for data disk images.
    :vartype data_disk_images: list[~azure.mgmt.compute.v2022_03_03.models.DataDiskImageEncryption]
    """

    _attribute_map = {
        "os_disk_image": {"key": "osDiskImage", "type": "OSDiskImageEncryption"},
        "data_disk_images": {"key": "dataDiskImages", "type": "[DataDiskImageEncryption]"},
    }

    def __init__(
        self,
        *,
        os_disk_image: Optional["_models.OSDiskImageEncryption"] = None,
        data_disk_images: Optional[List["_models.DataDiskImageEncryption"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword os_disk_image: Contains encryption settings for an OS disk image.
        :paramtype os_disk_image: ~azure.mgmt.compute.v2022_03_03.models.OSDiskImageEncryption
        :keyword data_disk_images: A list of encryption specifications for data disk images.
        :paramtype data_disk_images:
         list[~azure.mgmt.compute.v2022_03_03.models.DataDiskImageEncryption]
        """
        super().__init__(**kwargs)
        self.os_disk_image = os_disk_image
        self.data_disk_images = data_disk_images


class ExtendedLocation(_serialization.Model):
    """The complex type of the extended location.

    :ivar name: The name of the extended location.
    :vartype name: str
    :ivar type: The type of the extended location. "EdgeZone"
    :vartype type: str or ~azure.mgmt.compute.v2022_03_03.models.ExtendedLocationTypes
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        type: Optional[Union[str, "_models.ExtendedLocationTypes"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The name of the extended location.
        :paramtype name: str
        :keyword type: The type of the extended location. "EdgeZone"
        :paramtype type: str or ~azure.mgmt.compute.v2022_03_03.models.ExtendedLocationTypes
        """
        super().__init__(**kwargs)
        self.name = name
        self.type = type


class Resource(_serialization.Model):
    """The Resource model definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location. Required.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, *, location: str, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword location: Resource location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = location
        self.tags = tags


class Gallery(Resource):  # pylint: disable=too-many-instance-attributes
    """Specifies information about the Shared Image Gallery that you want to create or update.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location. Required.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar description: The description of this Shared Image Gallery resource. This property is
     updatable.
    :vartype description: str
    :ivar identifier: Describes the gallery unique name.
    :vartype identifier: ~azure.mgmt.compute.v2022_03_03.models.GalleryIdentifier
    :ivar provisioning_state: The provisioning state, which only appears in the response. Known
     values are: "Creating", "Updating", "Failed", "Succeeded", "Deleting", and "Migrating".
    :vartype provisioning_state: str or
     ~azure.mgmt.compute.v2022_03_03.models.GalleryProvisioningState
    :ivar sharing_profile: Profile for gallery sharing to subscription or tenant.
    :vartype sharing_profile: ~azure.mgmt.compute.v2022_03_03.models.SharingProfile
    :ivar soft_delete_policy: Contains information about the soft deletion policy of the gallery.
    :vartype soft_delete_policy: ~azure.mgmt.compute.v2022_03_03.models.SoftDeletePolicy
    :ivar sharing_status: Sharing status of current gallery.
    :vartype sharing_status: ~azure.mgmt.compute.v2022_03_03.models.SharingStatus
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
        "provisioning_state": {"readonly": True},
        "sharing_status": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "description": {"key": "properties.description", "type": "str"},
        "identifier": {"key": "properties.identifier", "type": "GalleryIdentifier"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "sharing_profile": {"key": "properties.sharingProfile", "type": "SharingProfile"},
        "soft_delete_policy": {"key": "properties.softDeletePolicy", "type": "SoftDeletePolicy"},
        "sharing_status": {"key": "properties.sharingStatus", "type": "SharingStatus"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        description: Optional[str] = None,
        identifier: Optional["_models.GalleryIdentifier"] = None,
        sharing_profile: Optional["_models.SharingProfile"] = None,
        soft_delete_policy: Optional["_models.SoftDeletePolicy"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: Resource location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword description: The description of this Shared Image Gallery resource. This property is
         updatable.
        :paramtype description: str
        :keyword identifier: Describes the gallery unique name.
        :paramtype identifier: ~azure.mgmt.compute.v2022_03_03.models.GalleryIdentifier
        :keyword sharing_profile: Profile for gallery sharing to subscription or tenant.
        :paramtype sharing_profile: ~azure.mgmt.compute.v2022_03_03.models.SharingProfile
        :keyword soft_delete_policy: Contains information about the soft deletion policy of the
         gallery.
        :paramtype soft_delete_policy: ~azure.mgmt.compute.v2022_03_03.models.SoftDeletePolicy
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.description = description
        self.identifier = identifier
        self.provisioning_state = None
        self.sharing_profile = sharing_profile
        self.soft_delete_policy = soft_delete_policy
        self.sharing_status = None


class GalleryApplication(Resource):  # pylint: disable=too-many-instance-attributes
    """Specifies information about the gallery Application Definition that you want to create or
    update.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location. Required.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar description: The description of this gallery Application Definition resource. This
     property is updatable.
    :vartype description: str
    :ivar eula: The Eula agreement for the gallery Application Definition.
    :vartype eula: str
    :ivar privacy_statement_uri: The privacy statement uri.
    :vartype privacy_statement_uri: str
    :ivar release_note_uri: The release note uri.
    :vartype release_note_uri: str
    :ivar end_of_life_date: The end of life date of the gallery Application Definition. This
     property can be used for decommissioning purposes. This property is updatable.
    :vartype end_of_life_date: ~datetime.datetime
    :ivar supported_os_type: This property allows you to specify the supported type of the OS that
     application is built for. :code:`<br>`:code:`<br>` Possible values are:
     :code:`<br>`:code:`<br>` **Windows** :code:`<br>`:code:`<br>` **Linux**. Known values are:
     "Windows" and "Linux".
    :vartype supported_os_type: str or ~azure.mgmt.compute.v2022_03_03.models.OperatingSystemTypes
    :ivar custom_actions: A list of custom actions that can be performed with all of the Gallery
     Application Versions within this Gallery Application.
    :vartype custom_actions:
     list[~azure.mgmt.compute.v2022_03_03.models.GalleryApplicationCustomAction]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "description": {"key": "properties.description", "type": "str"},
        "eula": {"key": "properties.eula", "type": "str"},
        "privacy_statement_uri": {"key": "properties.privacyStatementUri", "type": "str"},
        "release_note_uri": {"key": "properties.releaseNoteUri", "type": "str"},
        "end_of_life_date": {"key": "properties.endOfLifeDate", "type": "iso-8601"},
        "supported_os_type": {"key": "properties.supportedOSType", "type": "str"},
        "custom_actions": {"key": "properties.customActions", "type": "[GalleryApplicationCustomAction]"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        description: Optional[str] = None,
        eula: Optional[str] = None,
        privacy_statement_uri: Optional[str] = None,
        release_note_uri: Optional[str] = None,
        end_of_life_date: Optional[datetime.datetime] = None,
        supported_os_type: Optional[Union[str, "_models.OperatingSystemTypes"]] = None,
        custom_actions: Optional[List["_models.GalleryApplicationCustomAction"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: Resource location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword description: The description of this gallery Application Definition resource. This
         property is updatable.
        :paramtype description: str
        :keyword eula: The Eula agreement for the gallery Application Definition.
        :paramtype eula: str
        :keyword privacy_statement_uri: The privacy statement uri.
        :paramtype privacy_statement_uri: str
        :keyword release_note_uri: The release note uri.
        :paramtype release_note_uri: str
        :keyword end_of_life_date: The end of life date of the gallery Application Definition. This
         property can be used for decommissioning purposes. This property is updatable.
        :paramtype end_of_life_date: ~datetime.datetime
        :keyword supported_os_type: This property allows you to specify the supported type of the OS
         that application is built for. :code:`<br>`:code:`<br>` Possible values are:
         :code:`<br>`:code:`<br>` **Windows** :code:`<br>`:code:`<br>` **Linux**. Known values are:
         "Windows" and "Linux".
        :paramtype supported_os_type: str or
         ~azure.mgmt.compute.v2022_03_03.models.OperatingSystemTypes
        :keyword custom_actions: A list of custom actions that can be performed with all of the Gallery
         Application Versions within this Gallery Application.
        :paramtype custom_actions:
         list[~azure.mgmt.compute.v2022_03_03.models.GalleryApplicationCustomAction]
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.description = description
        self.eula = eula
        self.privacy_statement_uri = privacy_statement_uri
        self.release_note_uri = release_note_uri
        self.end_of_life_date = end_of_life_date
        self.supported_os_type = supported_os_type
        self.custom_actions = custom_actions


class GalleryApplicationCustomAction(_serialization.Model):
    """A custom action that can be performed with a Gallery Application Version.

    All required parameters must be populated in order to send to Azure.

    :ivar name: The name of the custom action.  Must be unique within the Gallery Application
     Version. Required.
    :vartype name: str
    :ivar script: The script to run when executing this custom action. Required.
    :vartype script: str
    :ivar description: Description to help the users understand what this custom action does.
    :vartype description: str
    :ivar parameters: The parameters that this custom action uses.
    :vartype parameters:
     list[~azure.mgmt.compute.v2022_03_03.models.GalleryApplicationCustomActionParameter]
    """

    _validation = {
        "name": {"required": True},
        "script": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "script": {"key": "script", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "parameters": {"key": "parameters", "type": "[GalleryApplicationCustomActionParameter]"},
    }

    def __init__(
        self,
        *,
        name: str,
        script: str,
        description: Optional[str] = None,
        parameters: Optional[List["_models.GalleryApplicationCustomActionParameter"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The name of the custom action.  Must be unique within the Gallery Application
         Version. Required.
        :paramtype name: str
        :keyword script: The script to run when executing this custom action. Required.
        :paramtype script: str
        :keyword description: Description to help the users understand what this custom action does.
        :paramtype description: str
        :keyword parameters: The parameters that this custom action uses.
        :paramtype parameters:
         list[~azure.mgmt.compute.v2022_03_03.models.GalleryApplicationCustomActionParameter]
        """
        super().__init__(**kwargs)
        self.name = name
        self.script = script
        self.description = description
        self.parameters = parameters


class GalleryApplicationCustomActionParameter(_serialization.Model):
    """The definition of a parameter that can be passed to a custom action of a Gallery Application
    Version.

    All required parameters must be populated in order to send to Azure.

    :ivar name: The name of the custom action.  Must be unique within the Gallery Application
     Version. Required.
    :vartype name: str
    :ivar required: Indicates whether this parameter must be passed when running the custom action.
    :vartype required: bool
    :ivar type: Specifies the type of the custom action parameter. Possible values are: String,
     ConfigurationDataBlob or LogOutputBlob. Known values are: "String", "ConfigurationDataBlob",
     and "LogOutputBlob".
    :vartype type: str or
     ~azure.mgmt.compute.v2022_03_03.models.GalleryApplicationCustomActionParameterType
    :ivar default_value: The default value of the parameter.  Only applies to string types.
    :vartype default_value: str
    :ivar description: A description to help users understand what this parameter means.
    :vartype description: str
    """

    _validation = {
        "name": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "required": {"key": "required", "type": "bool"},
        "type": {"key": "type", "type": "str"},
        "default_value": {"key": "defaultValue", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: str,
        required: Optional[bool] = None,
        type: Optional[Union[str, "_models.GalleryApplicationCustomActionParameterType"]] = None,
        default_value: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The name of the custom action.  Must be unique within the Gallery Application
         Version. Required.
        :paramtype name: str
        :keyword required: Indicates whether this parameter must be passed when running the custom
         action.
        :paramtype required: bool
        :keyword type: Specifies the type of the custom action parameter. Possible values are: String,
         ConfigurationDataBlob or LogOutputBlob. Known values are: "String", "ConfigurationDataBlob",
         and "LogOutputBlob".
        :paramtype type: str or
         ~azure.mgmt.compute.v2022_03_03.models.GalleryApplicationCustomActionParameterType
        :keyword default_value: The default value of the parameter.  Only applies to string types.
        :paramtype default_value: str
        :keyword description: A description to help users understand what this parameter means.
        :paramtype description: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.required = required
        self.type = type
        self.default_value = default_value
        self.description = description


class GalleryApplicationList(_serialization.Model):
    """The List Gallery Applications operation response.

    All required parameters must be populated in order to send to Azure.

    :ivar value: A list of Gallery Applications. Required.
    :vartype value: list[~azure.mgmt.compute.v2022_03_03.models.GalleryApplication]
    :ivar next_link: The uri to fetch the next page of Application Definitions in the Application
     Gallery. Call ListNext() with this to fetch the next page of gallery Application Definitions.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[GalleryApplication]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: List["_models.GalleryApplication"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: A list of Gallery Applications. Required.
        :paramtype value: list[~azure.mgmt.compute.v2022_03_03.models.GalleryApplication]
        :keyword next_link: The uri to fetch the next page of Application Definitions in the
         Application Gallery. Call ListNext() with this to fetch the next page of gallery Application
         Definitions.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class UpdateResourceDefinition(_serialization.Model):
    """The Update Resource model definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, *, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.tags = tags


class GalleryApplicationUpdate(UpdateResourceDefinition):  # pylint: disable=too-many-instance-attributes
    """Specifies information about the gallery Application Definition that you want to update.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar description: The description of this gallery Application Definition resource. This
     property is updatable.
    :vartype description: str
    :ivar eula: The Eula agreement for the gallery Application Definition.
    :vartype eula: str
    :ivar privacy_statement_uri: The privacy statement uri.
    :vartype privacy_statement_uri: str
    :ivar release_note_uri: The release note uri.
    :vartype release_note_uri: str
    :ivar end_of_life_date: The end of life date of the gallery Application Definition. This
     property can be used for decommissioning purposes. This property is updatable.
    :vartype end_of_life_date: ~datetime.datetime
    :ivar supported_os_type: This property allows you to specify the supported type of the OS that
     application is built for. :code:`<br>`:code:`<br>` Possible values are:
     :code:`<br>`:code:`<br>` **Windows** :code:`<br>`:code:`<br>` **Linux**. Known values are:
     "Windows" and "Linux".
    :vartype supported_os_type: str or ~azure.mgmt.compute.v2022_03_03.models.OperatingSystemTypes
    :ivar custom_actions: A list of custom actions that can be performed with all of the Gallery
     Application Versions within this Gallery Application.
    :vartype custom_actions:
     list[~azure.mgmt.compute.v2022_03_03.models.GalleryApplicationCustomAction]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "description": {"key": "properties.description", "type": "str"},
        "eula": {"key": "properties.eula", "type": "str"},
        "privacy_statement_uri": {"key": "properties.privacyStatementUri", "type": "str"},
        "release_note_uri": {"key": "properties.releaseNoteUri", "type": "str"},
        "end_of_life_date": {"key": "properties.endOfLifeDate", "type": "iso-8601"},
        "supported_os_type": {"key": "properties.supportedOSType", "type": "str"},
        "custom_actions": {"key": "properties.customActions", "type": "[GalleryApplicationCustomAction]"},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        description: Optional[str] = None,
        eula: Optional[str] = None,
        privacy_statement_uri: Optional[str] = None,
        release_note_uri: Optional[str] = None,
        end_of_life_date: Optional[datetime.datetime] = None,
        supported_os_type: Optional[Union[str, "_models.OperatingSystemTypes"]] = None,
        custom_actions: Optional[List["_models.GalleryApplicationCustomAction"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword description: The description of this gallery Application Definition resource. This
         property is updatable.
        :paramtype description: str
        :keyword eula: The Eula agreement for the gallery Application Definition.
        :paramtype eula: str
        :keyword privacy_statement_uri: The privacy statement uri.
        :paramtype privacy_statement_uri: str
        :keyword release_note_uri: The release note uri.
        :paramtype release_note_uri: str
        :keyword end_of_life_date: The end of life date of the gallery Application Definition. This
         property can be used for decommissioning purposes. This property is updatable.
        :paramtype end_of_life_date: ~datetime.datetime
        :keyword supported_os_type: This property allows you to specify the supported type of the OS
         that application is built for. :code:`<br>`:code:`<br>` Possible values are:
         :code:`<br>`:code:`<br>` **Windows** :code:`<br>`:code:`<br>` **Linux**. Known values are:
         "Windows" and "Linux".
        :paramtype supported_os_type: str or
         ~azure.mgmt.compute.v2022_03_03.models.OperatingSystemTypes
        :keyword custom_actions: A list of custom actions that can be performed with all of the Gallery
         Application Versions within this Gallery Application.
        :paramtype custom_actions:
         list[~azure.mgmt.compute.v2022_03_03.models.GalleryApplicationCustomAction]
        """
        super().__init__(tags=tags, **kwargs)
        self.description = description
        self.eula = eula
        self.privacy_statement_uri = privacy_statement_uri
        self.release_note_uri = release_note_uri
        self.end_of_life_date = end_of_life_date
        self.supported_os_type = supported_os_type
        self.custom_actions = custom_actions


class GalleryApplicationVersion(Resource):
    """Specifies information about the gallery Application Version that you want to create or update.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location. Required.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar publishing_profile: The publishing profile of a gallery image version.
    :vartype publishing_profile:
     ~azure.mgmt.compute.v2022_03_03.models.GalleryApplicationVersionPublishingProfile
    :ivar safety_profile: The safety profile of the Gallery Application Version.
    :vartype safety_profile:
     ~azure.mgmt.compute.v2022_03_03.models.GalleryApplicationVersionSafetyProfile
    :ivar provisioning_state: The provisioning state, which only appears in the response. Known
     values are: "Creating", "Updating", "Failed", "Succeeded", "Deleting", and "Migrating".
    :vartype provisioning_state: str or
     ~azure.mgmt.compute.v2022_03_03.models.GalleryProvisioningState
    :ivar replication_status: This is the replication status of the gallery image version.
    :vartype replication_status: ~azure.mgmt.compute.v2022_03_03.models.ReplicationStatus
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
        "provisioning_state": {"readonly": True},
        "replication_status": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "publishing_profile": {
            "key": "properties.publishingProfile",
            "type": "GalleryApplicationVersionPublishingProfile",
        },
        "safety_profile": {"key": "properties.safetyProfile", "type": "GalleryApplicationVersionSafetyProfile"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "replication_status": {"key": "properties.replicationStatus", "type": "ReplicationStatus"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        publishing_profile: Optional["_models.GalleryApplicationVersionPublishingProfile"] = None,
        safety_profile: Optional["_models.GalleryApplicationVersionSafetyProfile"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: Resource location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword publishing_profile: The publishing profile of a gallery image version.
        :paramtype publishing_profile:
         ~azure.mgmt.compute.v2022_03_03.models.GalleryApplicationVersionPublishingProfile
        :keyword safety_profile: The safety profile of the Gallery Application Version.
        :paramtype safety_profile:
         ~azure.mgmt.compute.v2022_03_03.models.GalleryApplicationVersionSafetyProfile
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.publishing_profile = publishing_profile
        self.safety_profile = safety_profile
        self.provisioning_state = None
        self.replication_status = None


class GalleryApplicationVersionList(_serialization.Model):
    """The List Gallery Application version operation response.

    All required parameters must be populated in order to send to Azure.

    :ivar value: A list of gallery Application Versions. Required.
    :vartype value: list[~azure.mgmt.compute.v2022_03_03.models.GalleryApplicationVersion]
    :ivar next_link: The uri to fetch the next page of gallery Application Versions. Call
     ListNext() with this to fetch the next page of gallery Application Versions.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[GalleryApplicationVersion]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: List["_models.GalleryApplicationVersion"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: A list of gallery Application Versions. Required.
        :paramtype value: list[~azure.mgmt.compute.v2022_03_03.models.GalleryApplicationVersion]
        :keyword next_link: The uri to fetch the next page of gallery Application Versions. Call
         ListNext() with this to fetch the next page of gallery Application Versions.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class GalleryArtifactPublishingProfileBase(_serialization.Model):
    """Describes the basic gallery artifact publishing profile.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar target_regions: The target regions where the Image Version is going to be replicated to.
     This property is updatable.
    :vartype target_regions: list[~azure.mgmt.compute.v2022_03_03.models.TargetRegion]
    :ivar replica_count: The number of replicas of the Image Version to be created per region. This
     property would take effect for a region when regionalReplicaCount is not specified. This
     property is updatable.
    :vartype replica_count: int
    :ivar exclude_from_latest: If set to true, Virtual Machines deployed from the latest version of
     the Image Definition won't use this Image Version.
    :vartype exclude_from_latest: bool
    :ivar published_date: The timestamp for when the gallery image version is published.
    :vartype published_date: ~datetime.datetime
    :ivar end_of_life_date: The end of life date of the gallery image version. This property can be
     used for decommissioning purposes. This property is updatable.
    :vartype end_of_life_date: ~datetime.datetime
    :ivar storage_account_type: Specifies the storage account type to be used to store the image.
     This property is not updatable. Known values are: "Standard_LRS", "Standard_ZRS", and
     "Premium_LRS".
    :vartype storage_account_type: str or ~azure.mgmt.compute.v2022_03_03.models.StorageAccountType
    :ivar replication_mode: Optional parameter which specifies the mode to be used for replication.
     This property is not updatable. Known values are: "Full" and "Shallow".
    :vartype replication_mode: str or ~azure.mgmt.compute.v2022_03_03.models.ReplicationMode
    :ivar target_extended_locations: The target extended locations where the Image Version is going
     to be replicated to. This property is updatable.
    :vartype target_extended_locations:
     list[~azure.mgmt.compute.v2022_03_03.models.GalleryTargetExtendedLocation]
    """

    _validation = {
        "published_date": {"readonly": True},
    }

    _attribute_map = {
        "target_regions": {"key": "targetRegions", "type": "[TargetRegion]"},
        "replica_count": {"key": "replicaCount", "type": "int"},
        "exclude_from_latest": {"key": "excludeFromLatest", "type": "bool"},
        "published_date": {"key": "publishedDate", "type": "iso-8601"},
        "end_of_life_date": {"key": "endOfLifeDate", "type": "iso-8601"},
        "storage_account_type": {"key": "storageAccountType", "type": "str"},
        "replication_mode": {"key": "replicationMode", "type": "str"},
        "target_extended_locations": {"key": "targetExtendedLocations", "type": "[GalleryTargetExtendedLocation]"},
    }

    def __init__(
        self,
        *,
        target_regions: Optional[List["_models.TargetRegion"]] = None,
        replica_count: Optional[int] = None,
        exclude_from_latest: Optional[bool] = None,
        end_of_life_date: Optional[datetime.datetime] = None,
        storage_account_type: Optional[Union[str, "_models.StorageAccountType"]] = None,
        replication_mode: Optional[Union[str, "_models.ReplicationMode"]] = None,
        target_extended_locations: Optional[List["_models.GalleryTargetExtendedLocation"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword target_regions: The target regions where the Image Version is going to be replicated
         to. This property is updatable.
        :paramtype target_regions: list[~azure.mgmt.compute.v2022_03_03.models.TargetRegion]
        :keyword replica_count: The number of replicas of the Image Version to be created per region.
         This property would take effect for a region when regionalReplicaCount is not specified. This
         property is updatable.
        :paramtype replica_count: int
        :keyword exclude_from_latest: If set to true, Virtual Machines deployed from the latest version
         of the Image Definition won't use this Image Version.
        :paramtype exclude_from_latest: bool
        :keyword end_of_life_date: The end of life date of the gallery image version. This property can
         be used for decommissioning purposes. This property is updatable.
        :paramtype end_of_life_date: ~datetime.datetime
        :keyword storage_account_type: Specifies the storage account type to be used to store the
         image. This property is not updatable. Known values are: "Standard_LRS", "Standard_ZRS", and
         "Premium_LRS".
        :paramtype storage_account_type: str or
         ~azure.mgmt.compute.v2022_03_03.models.StorageAccountType
        :keyword replication_mode: Optional parameter which specifies the mode to be used for
         replication. This property is not updatable. Known values are: "Full" and "Shallow".
        :paramtype replication_mode: str or ~azure.mgmt.compute.v2022_03_03.models.ReplicationMode
        :keyword target_extended_locations: The target extended locations where the Image Version is
         going to be replicated to. This property is updatable.
        :paramtype target_extended_locations:
         list[~azure.mgmt.compute.v2022_03_03.models.GalleryTargetExtendedLocation]
        """
        super().__init__(**kwargs)
        self.target_regions = target_regions
        self.replica_count = replica_count
        self.exclude_from_latest = exclude_from_latest
        self.published_date = None
        self.end_of_life_date = end_of_life_date
        self.storage_account_type = storage_account_type
        self.replication_mode = replication_mode
        self.target_extended_locations = target_extended_locations


class GalleryApplicationVersionPublishingProfile(
    GalleryArtifactPublishingProfileBase
):  # pylint: disable=too-many-instance-attributes
    """The publishing profile of a gallery image version.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar target_regions: The target regions where the Image Version is going to be replicated to.
     This property is updatable.
    :vartype target_regions: list[~azure.mgmt.compute.v2022_03_03.models.TargetRegion]
    :ivar replica_count: The number of replicas of the Image Version to be created per region. This
     property would take effect for a region when regionalReplicaCount is not specified. This
     property is updatable.
    :vartype replica_count: int
    :ivar exclude_from_latest: If set to true, Virtual Machines deployed from the latest version of
     the Image Definition won't use this Image Version.
    :vartype exclude_from_latest: bool
    :ivar published_date: The timestamp for when the gallery image version is published.
    :vartype published_date: ~datetime.datetime
    :ivar end_of_life_date: The end of life date of the gallery image version. This property can be
     used for decommissioning purposes. This property is updatable.
    :vartype end_of_life_date: ~datetime.datetime
    :ivar storage_account_type: Specifies the storage account type to be used to store the image.
     This property is not updatable. Known values are: "Standard_LRS", "Standard_ZRS", and
     "Premium_LRS".
    :vartype storage_account_type: str or ~azure.mgmt.compute.v2022_03_03.models.StorageAccountType
    :ivar replication_mode: Optional parameter which specifies the mode to be used for replication.
     This property is not updatable. Known values are: "Full" and "Shallow".
    :vartype replication_mode: str or ~azure.mgmt.compute.v2022_03_03.models.ReplicationMode
    :ivar target_extended_locations: The target extended locations where the Image Version is going
     to be replicated to. This property is updatable.
    :vartype target_extended_locations:
     list[~azure.mgmt.compute.v2022_03_03.models.GalleryTargetExtendedLocation]
    :ivar source: The source image from which the Image Version is going to be created. Required.
    :vartype source: ~azure.mgmt.compute.v2022_03_03.models.UserArtifactSource
    :ivar manage_actions:
    :vartype manage_actions: ~azure.mgmt.compute.v2022_03_03.models.UserArtifactManage
    :ivar settings: Additional settings for the VM app that contains the target package and config
     file name when it is deployed to target VM or VM scale set.
    :vartype settings: ~azure.mgmt.compute.v2022_03_03.models.UserArtifactSettings
    :ivar advanced_settings: Optional. Additional settings to pass to the vm-application-manager
     extension. For advanced use only.
    :vartype advanced_settings: dict[str, str]
    :ivar enable_health_check: Optional. Whether or not this application reports health.
    :vartype enable_health_check: bool
    :ivar custom_actions: A list of custom actions that can be performed with this Gallery
     Application Version.
    :vartype custom_actions:
     list[~azure.mgmt.compute.v2022_03_03.models.GalleryApplicationCustomAction]
    """

    _validation = {
        "published_date": {"readonly": True},
        "source": {"required": True},
    }

    _attribute_map = {
        "target_regions": {"key": "targetRegions", "type": "[TargetRegion]"},
        "replica_count": {"key": "replicaCount", "type": "int"},
        "exclude_from_latest": {"key": "excludeFromLatest", "type": "bool"},
        "published_date": {"key": "publishedDate", "type": "iso-8601"},
        "end_of_life_date": {"key": "endOfLifeDate", "type": "iso-8601"},
        "storage_account_type": {"key": "storageAccountType", "type": "str"},
        "replication_mode": {"key": "replicationMode", "type": "str"},
        "target_extended_locations": {"key": "targetExtendedLocations", "type": "[GalleryTargetExtendedLocation]"},
        "source": {"key": "source", "type": "UserArtifactSource"},
        "manage_actions": {"key": "manageActions", "type": "UserArtifactManage"},
        "settings": {"key": "settings", "type": "UserArtifactSettings"},
        "advanced_settings": {"key": "advancedSettings", "type": "{str}"},
        "enable_health_check": {"key": "enableHealthCheck", "type": "bool"},
        "custom_actions": {"key": "customActions", "type": "[GalleryApplicationCustomAction]"},
    }

    def __init__(
        self,
        *,
        source: "_models.UserArtifactSource",
        target_regions: Optional[List["_models.TargetRegion"]] = None,
        replica_count: Optional[int] = None,
        exclude_from_latest: Optional[bool] = None,
        end_of_life_date: Optional[datetime.datetime] = None,
        storage_account_type: Optional[Union[str, "_models.StorageAccountType"]] = None,
        replication_mode: Optional[Union[str, "_models.ReplicationMode"]] = None,
        target_extended_locations: Optional[List["_models.GalleryTargetExtendedLocation"]] = None,
        manage_actions: Optional["_models.UserArtifactManage"] = None,
        settings: Optional["_models.UserArtifactSettings"] = None,
        advanced_settings: Optional[Dict[str, str]] = None,
        enable_health_check: Optional[bool] = None,
        custom_actions: Optional[List["_models.GalleryApplicationCustomAction"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword target_regions: The target regions where the Image Version is going to be replicated
         to. This property is updatable.
        :paramtype target_regions: list[~azure.mgmt.compute.v2022_03_03.models.TargetRegion]
        :keyword replica_count: The number of replicas of the Image Version to be created per region.
         This property would take effect for a region when regionalReplicaCount is not specified. This
         property is updatable.
        :paramtype replica_count: int
        :keyword exclude_from_latest: If set to true, Virtual Machines deployed from the latest version
         of the Image Definition won't use this Image Version.
        :paramtype exclude_from_latest: bool
        :keyword end_of_life_date: The end of life date of the gallery image version. This property can
         be used for decommissioning purposes. This property is updatable.
        :paramtype end_of_life_date: ~datetime.datetime
        :keyword storage_account_type: Specifies the storage account type to be used to store the
         image. This property is not updatable. Known values are: "Standard_LRS", "Standard_ZRS", and
         "Premium_LRS".
        :paramtype storage_account_type: str or
         ~azure.mgmt.compute.v2022_03_03.models.StorageAccountType
        :keyword replication_mode: Optional parameter which specifies the mode to be used for
         replication. This property is not updatable. Known values are: "Full" and "Shallow".
        :paramtype replication_mode: str or ~azure.mgmt.compute.v2022_03_03.models.ReplicationMode
        :keyword target_extended_locations: The target extended locations where the Image Version is
         going to be replicated to. This property is updatable.
        :paramtype target_extended_locations:
         list[~azure.mgmt.compute.v2022_03_03.models.GalleryTargetExtendedLocation]
        :keyword source: The source image from which the Image Version is going to be created.
         Required.
        :paramtype source: ~azure.mgmt.compute.v2022_03_03.models.UserArtifactSource
        :keyword manage_actions:
        :paramtype manage_actions: ~azure.mgmt.compute.v2022_03_03.models.UserArtifactManage
        :keyword settings: Additional settings for the VM app that contains the target package and
         config file name when it is deployed to target VM or VM scale set.
        :paramtype settings: ~azure.mgmt.compute.v2022_03_03.models.UserArtifactSettings
        :keyword advanced_settings: Optional. Additional settings to pass to the vm-application-manager
         extension. For advanced use only.
        :paramtype advanced_settings: dict[str, str]
        :keyword enable_health_check: Optional. Whether or not this application reports health.
        :paramtype enable_health_check: bool
        :keyword custom_actions: A list of custom actions that can be performed with this Gallery
         Application Version.
        :paramtype custom_actions:
         list[~azure.mgmt.compute.v2022_03_03.models.GalleryApplicationCustomAction]
        """
        super().__init__(
            target_regions=target_regions,
            replica_count=replica_count,
            exclude_from_latest=exclude_from_latest,
            end_of_life_date=end_of_life_date,
            storage_account_type=storage_account_type,
            replication_mode=replication_mode,
            target_extended_locations=target_extended_locations,
            **kwargs
        )
        self.source = source
        self.manage_actions = manage_actions
        self.settings = settings
        self.advanced_settings = advanced_settings
        self.enable_health_check = enable_health_check
        self.custom_actions = custom_actions


class GalleryArtifactSafetyProfileBase(_serialization.Model):
    """This is the safety profile of the Gallery Artifact Version.

    :ivar allow_deletion_of_replicated_locations: Indicates whether or not removing this Gallery
     Image Version from replicated regions is allowed.
    :vartype allow_deletion_of_replicated_locations: bool
    """

    _attribute_map = {
        "allow_deletion_of_replicated_locations": {"key": "allowDeletionOfReplicatedLocations", "type": "bool"},
    }

    def __init__(self, *, allow_deletion_of_replicated_locations: Optional[bool] = None, **kwargs: Any) -> None:
        """
        :keyword allow_deletion_of_replicated_locations: Indicates whether or not removing this Gallery
         Image Version from replicated regions is allowed.
        :paramtype allow_deletion_of_replicated_locations: bool
        """
        super().__init__(**kwargs)
        self.allow_deletion_of_replicated_locations = allow_deletion_of_replicated_locations


class GalleryApplicationVersionSafetyProfile(GalleryArtifactSafetyProfileBase):
    """The safety profile of the Gallery Application Version.

    :ivar allow_deletion_of_replicated_locations: Indicates whether or not removing this Gallery
     Image Version from replicated regions is allowed.
    :vartype allow_deletion_of_replicated_locations: bool
    """

    _attribute_map = {
        "allow_deletion_of_replicated_locations": {"key": "allowDeletionOfReplicatedLocations", "type": "bool"},
    }

    def __init__(self, *, allow_deletion_of_replicated_locations: Optional[bool] = None, **kwargs: Any) -> None:
        """
        :keyword allow_deletion_of_replicated_locations: Indicates whether or not removing this Gallery
         Image Version from replicated regions is allowed.
        :paramtype allow_deletion_of_replicated_locations: bool
        """
        super().__init__(allow_deletion_of_replicated_locations=allow_deletion_of_replicated_locations, **kwargs)


class GalleryApplicationVersionUpdate(UpdateResourceDefinition):
    """Specifies information about the gallery Application Version that you want to update.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar publishing_profile: The publishing profile of a gallery image version.
    :vartype publishing_profile:
     ~azure.mgmt.compute.v2022_03_03.models.GalleryApplicationVersionPublishingProfile
    :ivar safety_profile: The safety profile of the Gallery Application Version.
    :vartype safety_profile:
     ~azure.mgmt.compute.v2022_03_03.models.GalleryApplicationVersionSafetyProfile
    :ivar provisioning_state: The provisioning state, which only appears in the response. Known
     values are: "Creating", "Updating", "Failed", "Succeeded", "Deleting", and "Migrating".
    :vartype provisioning_state: str or
     ~azure.mgmt.compute.v2022_03_03.models.GalleryProvisioningState
    :ivar replication_status: This is the replication status of the gallery image version.
    :vartype replication_status: ~azure.mgmt.compute.v2022_03_03.models.ReplicationStatus
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "replication_status": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "publishing_profile": {
            "key": "properties.publishingProfile",
            "type": "GalleryApplicationVersionPublishingProfile",
        },
        "safety_profile": {"key": "properties.safetyProfile", "type": "GalleryApplicationVersionSafetyProfile"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "replication_status": {"key": "properties.replicationStatus", "type": "ReplicationStatus"},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        publishing_profile: Optional["_models.GalleryApplicationVersionPublishingProfile"] = None,
        safety_profile: Optional["_models.GalleryApplicationVersionSafetyProfile"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword publishing_profile: The publishing profile of a gallery image version.
        :paramtype publishing_profile:
         ~azure.mgmt.compute.v2022_03_03.models.GalleryApplicationVersionPublishingProfile
        :keyword safety_profile: The safety profile of the Gallery Application Version.
        :paramtype safety_profile:
         ~azure.mgmt.compute.v2022_03_03.models.GalleryApplicationVersionSafetyProfile
        """
        super().__init__(tags=tags, **kwargs)
        self.publishing_profile = publishing_profile
        self.safety_profile = safety_profile
        self.provisioning_state = None
        self.replication_status = None


class GalleryArtifactSource(_serialization.Model):
    """The source image from which the Image Version is going to be created.

    All required parameters must be populated in order to send to Azure.

    :ivar managed_image: The managed artifact. Required.
    :vartype managed_image: ~azure.mgmt.compute.v2022_03_03.models.ManagedArtifact
    """

    _validation = {
        "managed_image": {"required": True},
    }

    _attribute_map = {
        "managed_image": {"key": "managedImage", "type": "ManagedArtifact"},
    }

    def __init__(self, *, managed_image: "_models.ManagedArtifact", **kwargs: Any) -> None:
        """
        :keyword managed_image: The managed artifact. Required.
        :paramtype managed_image: ~azure.mgmt.compute.v2022_03_03.models.ManagedArtifact
        """
        super().__init__(**kwargs)
        self.managed_image = managed_image


class GalleryArtifactVersionSource(_serialization.Model):
    """The gallery artifact version source.

    :ivar id: The id of the gallery artifact version source. Can specify a disk uri, snapshot uri,
     user image or storage account resource.
    :vartype id: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, *, id: Optional[str] = None, **kwargs: Any) -> None:  # pylint: disable=redefined-builtin
        """
        :keyword id: The id of the gallery artifact version source. Can specify a disk uri, snapshot
         uri, user image or storage account resource.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id


class GalleryArtifactVersionFullSource(GalleryArtifactVersionSource):
    """The source of the gallery artifact version.

    :ivar id: The id of the gallery artifact version source. Can specify a disk uri, snapshot uri,
     user image or storage account resource.
    :vartype id: str
    :ivar community_gallery_image_id: The resource Id of the source Community Gallery Image.  Only
     required when using Community Gallery Image as a source.
    :vartype community_gallery_image_id: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "community_gallery_image_id": {"key": "communityGalleryImageId", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        community_gallery_image_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: The id of the gallery artifact version source. Can specify a disk uri, snapshot
         uri, user image or storage account resource.
        :paramtype id: str
        :keyword community_gallery_image_id: The resource Id of the source Community Gallery Image.
         Only required when using Community Gallery Image as a source.
        :paramtype community_gallery_image_id: str
        """
        super().__init__(id=id, **kwargs)
        self.community_gallery_image_id = community_gallery_image_id


class GalleryDiskImage(_serialization.Model):
    """This is the disk image base class.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar size_in_gb: This property indicates the size of the VHD to be created.
    :vartype size_in_gb: int
    :ivar host_caching: The host caching of the disk. Valid values are 'None', 'ReadOnly', and
     'ReadWrite'. Known values are: "None", "ReadOnly", and "ReadWrite".
    :vartype host_caching: str or ~azure.mgmt.compute.v2022_03_03.models.HostCaching
    :ivar source: The source for the disk image.
    :vartype source: ~azure.mgmt.compute.v2022_03_03.models.GalleryDiskImageSource
    """

    _validation = {
        "size_in_gb": {"readonly": True},
    }

    _attribute_map = {
        "size_in_gb": {"key": "sizeInGB", "type": "int"},
        "host_caching": {"key": "hostCaching", "type": "str"},
        "source": {"key": "source", "type": "GalleryDiskImageSource"},
    }

    def __init__(
        self,
        *,
        host_caching: Optional[Union[str, "_models.HostCaching"]] = None,
        source: Optional["_models.GalleryDiskImageSource"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword host_caching: The host caching of the disk. Valid values are 'None', 'ReadOnly', and
         'ReadWrite'. Known values are: "None", "ReadOnly", and "ReadWrite".
        :paramtype host_caching: str or ~azure.mgmt.compute.v2022_03_03.models.HostCaching
        :keyword source: The source for the disk image.
        :paramtype source: ~azure.mgmt.compute.v2022_03_03.models.GalleryDiskImageSource
        """
        super().__init__(**kwargs)
        self.size_in_gb = None
        self.host_caching = host_caching
        self.source = source


class GalleryDataDiskImage(GalleryDiskImage):
    """This is the data disk image.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar size_in_gb: This property indicates the size of the VHD to be created.
    :vartype size_in_gb: int
    :ivar host_caching: The host caching of the disk. Valid values are 'None', 'ReadOnly', and
     'ReadWrite'. Known values are: "None", "ReadOnly", and "ReadWrite".
    :vartype host_caching: str or ~azure.mgmt.compute.v2022_03_03.models.HostCaching
    :ivar source: The source for the disk image.
    :vartype source: ~azure.mgmt.compute.v2022_03_03.models.GalleryDiskImageSource
    :ivar lun: This property specifies the logical unit number of the data disk. This value is used
     to identify data disks within the Virtual Machine and therefore must be unique for each data
     disk attached to the Virtual Machine. Required.
    :vartype lun: int
    """

    _validation = {
        "size_in_gb": {"readonly": True},
        "lun": {"required": True},
    }

    _attribute_map = {
        "size_in_gb": {"key": "sizeInGB", "type": "int"},
        "host_caching": {"key": "hostCaching", "type": "str"},
        "source": {"key": "source", "type": "GalleryDiskImageSource"},
        "lun": {"key": "lun", "type": "int"},
    }

    def __init__(
        self,
        *,
        lun: int,
        host_caching: Optional[Union[str, "_models.HostCaching"]] = None,
        source: Optional["_models.GalleryDiskImageSource"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword host_caching: The host caching of the disk. Valid values are 'None', 'ReadOnly', and
         'ReadWrite'. Known values are: "None", "ReadOnly", and "ReadWrite".
        :paramtype host_caching: str or ~azure.mgmt.compute.v2022_03_03.models.HostCaching
        :keyword source: The source for the disk image.
        :paramtype source: ~azure.mgmt.compute.v2022_03_03.models.GalleryDiskImageSource
        :keyword lun: This property specifies the logical unit number of the data disk. This value is
         used to identify data disks within the Virtual Machine and therefore must be unique for each
         data disk attached to the Virtual Machine. Required.
        :paramtype lun: int
        """
        super().__init__(host_caching=host_caching, source=source, **kwargs)
        self.lun = lun


class GalleryDiskImageSource(GalleryArtifactVersionSource):
    """The source for the disk image.

    :ivar id: The id of the gallery artifact version source. Can specify a disk uri, snapshot uri,
     user image or storage account resource.
    :vartype id: str
    :ivar uri: The uri of the gallery artifact version source. Currently used to specify vhd/blob
     source.
    :vartype uri: str
    :ivar storage_account_id: The Storage Account Id that contains the vhd blob being used as a
     source for this artifact version.
    :vartype storage_account_id: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "uri": {"key": "uri", "type": "str"},
        "storage_account_id": {"key": "storageAccountId", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        uri: Optional[str] = None,
        storage_account_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: The id of the gallery artifact version source. Can specify a disk uri, snapshot
         uri, user image or storage account resource.
        :paramtype id: str
        :keyword uri: The uri of the gallery artifact version source. Currently used to specify
         vhd/blob source.
        :paramtype uri: str
        :keyword storage_account_id: The Storage Account Id that contains the vhd blob being used as a
         source for this artifact version.
        :paramtype storage_account_id: str
        """
        super().__init__(id=id, **kwargs)
        self.uri = uri
        self.storage_account_id = storage_account_id


class GalleryExtendedLocation(_serialization.Model):
    """The name of the extended location.

    :ivar name:
    :vartype name: str
    :ivar type: It is type of the extended location. Known values are: "EdgeZone" and "Unknown".
    :vartype type: str or ~azure.mgmt.compute.v2022_03_03.models.GalleryExtendedLocationType
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        type: Optional[Union[str, "_models.GalleryExtendedLocationType"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name:
        :paramtype name: str
        :keyword type: It is type of the extended location. Known values are: "EdgeZone" and "Unknown".
        :paramtype type: str or ~azure.mgmt.compute.v2022_03_03.models.GalleryExtendedLocationType
        """
        super().__init__(**kwargs)
        self.name = name
        self.type = type


class GalleryIdentifier(_serialization.Model):
    """Describes the gallery unique name.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar unique_name: The unique name of the Shared Image Gallery. This name is generated
     automatically by Azure.
    :vartype unique_name: str
    """

    _validation = {
        "unique_name": {"readonly": True},
    }

    _attribute_map = {
        "unique_name": {"key": "uniqueName", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.unique_name = None


class GalleryImage(Resource):  # pylint: disable=too-many-instance-attributes
    """Specifies information about the gallery image definition that you want to create or update.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location. Required.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar description: The description of this gallery image definition resource. This property is
     updatable.
    :vartype description: str
    :ivar eula: The Eula agreement for the gallery image definition.
    :vartype eula: str
    :ivar privacy_statement_uri: The privacy statement uri.
    :vartype privacy_statement_uri: str
    :ivar release_note_uri: The release note uri.
    :vartype release_note_uri: str
    :ivar os_type: This property allows you to specify the type of the OS that is included in the
     disk when creating a VM from a managed image. :code:`<br>`:code:`<br>` Possible values are:
     :code:`<br>`:code:`<br>` **Windows** :code:`<br>`:code:`<br>` **Linux**. Known values are:
     "Windows" and "Linux".
    :vartype os_type: str or ~azure.mgmt.compute.v2022_03_03.models.OperatingSystemTypes
    :ivar os_state: This property allows the user to specify whether the virtual machines created
     under this image are 'Generalized' or 'Specialized'. Known values are: "Generalized" and
     "Specialized".
    :vartype os_state: str or ~azure.mgmt.compute.v2022_03_03.models.OperatingSystemStateTypes
    :ivar hyper_v_generation: The hypervisor generation of the Virtual Machine. Applicable to OS
     disks only. Known values are: "V1" and "V2".
    :vartype hyper_v_generation: str or ~azure.mgmt.compute.v2022_03_03.models.HyperVGeneration
    :ivar end_of_life_date: The end of life date of the gallery image definition. This property can
     be used for decommissioning purposes. This property is updatable.
    :vartype end_of_life_date: ~datetime.datetime
    :ivar identifier: This is the gallery image definition identifier.
    :vartype identifier: ~azure.mgmt.compute.v2022_03_03.models.GalleryImageIdentifier
    :ivar recommended: The properties describe the recommended machine configuration for this Image
     Definition. These properties are updatable.
    :vartype recommended: ~azure.mgmt.compute.v2022_03_03.models.RecommendedMachineConfiguration
    :ivar disallowed: Describes the disallowed disk types.
    :vartype disallowed: ~azure.mgmt.compute.v2022_03_03.models.Disallowed
    :ivar purchase_plan: Describes the gallery image definition purchase plan. This is used by
     marketplace images.
    :vartype purchase_plan: ~azure.mgmt.compute.v2022_03_03.models.ImagePurchasePlan
    :ivar provisioning_state: The provisioning state, which only appears in the response. Known
     values are: "Creating", "Updating", "Failed", "Succeeded", "Deleting", and "Migrating".
    :vartype provisioning_state: str or
     ~azure.mgmt.compute.v2022_03_03.models.GalleryProvisioningState
    :ivar features: A list of gallery image features.
    :vartype features: list[~azure.mgmt.compute.v2022_03_03.models.GalleryImageFeature]
    :ivar architecture: The architecture of the image. Applicable to OS disks only. Known values
     are: "x64" and "Arm64".
    :vartype architecture: str or ~azure.mgmt.compute.v2022_03_03.models.Architecture
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "description": {"key": "properties.description", "type": "str"},
        "eula": {"key": "properties.eula", "type": "str"},
        "privacy_statement_uri": {"key": "properties.privacyStatementUri", "type": "str"},
        "release_note_uri": {"key": "properties.releaseNoteUri", "type": "str"},
        "os_type": {"key": "properties.osType", "type": "str"},
        "os_state": {"key": "properties.osState", "type": "str"},
        "hyper_v_generation": {"key": "properties.hyperVGeneration", "type": "str"},
        "end_of_life_date": {"key": "properties.endOfLifeDate", "type": "iso-8601"},
        "identifier": {"key": "properties.identifier", "type": "GalleryImageIdentifier"},
        "recommended": {"key": "properties.recommended", "type": "RecommendedMachineConfiguration"},
        "disallowed": {"key": "properties.disallowed", "type": "Disallowed"},
        "purchase_plan": {"key": "properties.purchasePlan", "type": "ImagePurchasePlan"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "features": {"key": "properties.features", "type": "[GalleryImageFeature]"},
        "architecture": {"key": "properties.architecture", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        description: Optional[str] = None,
        eula: Optional[str] = None,
        privacy_statement_uri: Optional[str] = None,
        release_note_uri: Optional[str] = None,
        os_type: Optional[Union[str, "_models.OperatingSystemTypes"]] = None,
        os_state: Optional[Union[str, "_models.OperatingSystemStateTypes"]] = None,
        hyper_v_generation: Optional[Union[str, "_models.HyperVGeneration"]] = None,
        end_of_life_date: Optional[datetime.datetime] = None,
        identifier: Optional["_models.GalleryImageIdentifier"] = None,
        recommended: Optional["_models.RecommendedMachineConfiguration"] = None,
        disallowed: Optional["_models.Disallowed"] = None,
        purchase_plan: Optional["_models.ImagePurchasePlan"] = None,
        features: Optional[List["_models.GalleryImageFeature"]] = None,
        architecture: Optional[Union[str, "_models.Architecture"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: Resource location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword description: The description of this gallery image definition resource. This property
         is updatable.
        :paramtype description: str
        :keyword eula: The Eula agreement for the gallery image definition.
        :paramtype eula: str
        :keyword privacy_statement_uri: The privacy statement uri.
        :paramtype privacy_statement_uri: str
        :keyword release_note_uri: The release note uri.
        :paramtype release_note_uri: str
        :keyword os_type: This property allows you to specify the type of the OS that is included in
         the disk when creating a VM from a managed image. :code:`<br>`:code:`<br>` Possible values are:
         :code:`<br>`:code:`<br>` **Windows** :code:`<br>`:code:`<br>` **Linux**. Known values are:
         "Windows" and "Linux".
        :paramtype os_type: str or ~azure.mgmt.compute.v2022_03_03.models.OperatingSystemTypes
        :keyword os_state: This property allows the user to specify whether the virtual machines
         created under this image are 'Generalized' or 'Specialized'. Known values are: "Generalized"
         and "Specialized".
        :paramtype os_state: str or ~azure.mgmt.compute.v2022_03_03.models.OperatingSystemStateTypes
        :keyword hyper_v_generation: The hypervisor generation of the Virtual Machine. Applicable to OS
         disks only. Known values are: "V1" and "V2".
        :paramtype hyper_v_generation: str or ~azure.mgmt.compute.v2022_03_03.models.HyperVGeneration
        :keyword end_of_life_date: The end of life date of the gallery image definition. This property
         can be used for decommissioning purposes. This property is updatable.
        :paramtype end_of_life_date: ~datetime.datetime
        :keyword identifier: This is the gallery image definition identifier.
        :paramtype identifier: ~azure.mgmt.compute.v2022_03_03.models.GalleryImageIdentifier
        :keyword recommended: The properties describe the recommended machine configuration for this
         Image Definition. These properties are updatable.
        :paramtype recommended: ~azure.mgmt.compute.v2022_03_03.models.RecommendedMachineConfiguration
        :keyword disallowed: Describes the disallowed disk types.
        :paramtype disallowed: ~azure.mgmt.compute.v2022_03_03.models.Disallowed
        :keyword purchase_plan: Describes the gallery image definition purchase plan. This is used by
         marketplace images.
        :paramtype purchase_plan: ~azure.mgmt.compute.v2022_03_03.models.ImagePurchasePlan
        :keyword features: A list of gallery image features.
        :paramtype features: list[~azure.mgmt.compute.v2022_03_03.models.GalleryImageFeature]
        :keyword architecture: The architecture of the image. Applicable to OS disks only. Known values
         are: "x64" and "Arm64".
        :paramtype architecture: str or ~azure.mgmt.compute.v2022_03_03.models.Architecture
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.description = description
        self.eula = eula
        self.privacy_statement_uri = privacy_statement_uri
        self.release_note_uri = release_note_uri
        self.os_type = os_type
        self.os_state = os_state
        self.hyper_v_generation = hyper_v_generation
        self.end_of_life_date = end_of_life_date
        self.identifier = identifier
        self.recommended = recommended
        self.disallowed = disallowed
        self.purchase_plan = purchase_plan
        self.provisioning_state = None
        self.features = features
        self.architecture = architecture


class GalleryImageFeature(_serialization.Model):
    """A feature for gallery image.

    :ivar name: The name of the gallery image feature.
    :vartype name: str
    :ivar value: The value of the gallery image feature.
    :vartype value: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "value": {"key": "value", "type": "str"},
    }

    def __init__(self, *, name: Optional[str] = None, value: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword name: The name of the gallery image feature.
        :paramtype name: str
        :keyword value: The value of the gallery image feature.
        :paramtype value: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.value = value


class GalleryImageIdentifier(_serialization.Model):
    """This is the gallery image definition identifier.

    All required parameters must be populated in order to send to Azure.

    :ivar publisher: The name of the gallery image definition publisher. Required.
    :vartype publisher: str
    :ivar offer: The name of the gallery image definition offer. Required.
    :vartype offer: str
    :ivar sku: The name of the gallery image definition SKU. Required.
    :vartype sku: str
    """

    _validation = {
        "publisher": {"required": True},
        "offer": {"required": True},
        "sku": {"required": True},
    }

    _attribute_map = {
        "publisher": {"key": "publisher", "type": "str"},
        "offer": {"key": "offer", "type": "str"},
        "sku": {"key": "sku", "type": "str"},
    }

    def __init__(self, *, publisher: str, offer: str, sku: str, **kwargs: Any) -> None:
        """
        :keyword publisher: The name of the gallery image definition publisher. Required.
        :paramtype publisher: str
        :keyword offer: The name of the gallery image definition offer. Required.
        :paramtype offer: str
        :keyword sku: The name of the gallery image definition SKU. Required.
        :paramtype sku: str
        """
        super().__init__(**kwargs)
        self.publisher = publisher
        self.offer = offer
        self.sku = sku


class GalleryImageList(_serialization.Model):
    """The List Gallery Images operation response.

    All required parameters must be populated in order to send to Azure.

    :ivar value: A list of Shared Image Gallery images. Required.
    :vartype value: list[~azure.mgmt.compute.v2022_03_03.models.GalleryImage]
    :ivar next_link: The uri to fetch the next page of Image Definitions in the Shared Image
     Gallery. Call ListNext() with this to fetch the next page of gallery image definitions.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[GalleryImage]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.GalleryImage"], next_link: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword value: A list of Shared Image Gallery images. Required.
        :paramtype value: list[~azure.mgmt.compute.v2022_03_03.models.GalleryImage]
        :keyword next_link: The uri to fetch the next page of Image Definitions in the Shared Image
         Gallery. Call ListNext() with this to fetch the next page of gallery image definitions.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class GalleryImageUpdate(UpdateResourceDefinition):  # pylint: disable=too-many-instance-attributes
    """Specifies information about the gallery image definition that you want to update.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar description: The description of this gallery image definition resource. This property is
     updatable.
    :vartype description: str
    :ivar eula: The Eula agreement for the gallery image definition.
    :vartype eula: str
    :ivar privacy_statement_uri: The privacy statement uri.
    :vartype privacy_statement_uri: str
    :ivar release_note_uri: The release note uri.
    :vartype release_note_uri: str
    :ivar os_type: This property allows you to specify the type of the OS that is included in the
     disk when creating a VM from a managed image. :code:`<br>`:code:`<br>` Possible values are:
     :code:`<br>`:code:`<br>` **Windows** :code:`<br>`:code:`<br>` **Linux**. Known values are:
     "Windows" and "Linux".
    :vartype os_type: str or ~azure.mgmt.compute.v2022_03_03.models.OperatingSystemTypes
    :ivar os_state: This property allows the user to specify whether the virtual machines created
     under this image are 'Generalized' or 'Specialized'. Known values are: "Generalized" and
     "Specialized".
    :vartype os_state: str or ~azure.mgmt.compute.v2022_03_03.models.OperatingSystemStateTypes
    :ivar hyper_v_generation: The hypervisor generation of the Virtual Machine. Applicable to OS
     disks only. Known values are: "V1" and "V2".
    :vartype hyper_v_generation: str or ~azure.mgmt.compute.v2022_03_03.models.HyperVGeneration
    :ivar end_of_life_date: The end of life date of the gallery image definition. This property can
     be used for decommissioning purposes. This property is updatable.
    :vartype end_of_life_date: ~datetime.datetime
    :ivar identifier: This is the gallery image definition identifier.
    :vartype identifier: ~azure.mgmt.compute.v2022_03_03.models.GalleryImageIdentifier
    :ivar recommended: The properties describe the recommended machine configuration for this Image
     Definition. These properties are updatable.
    :vartype recommended: ~azure.mgmt.compute.v2022_03_03.models.RecommendedMachineConfiguration
    :ivar disallowed: Describes the disallowed disk types.
    :vartype disallowed: ~azure.mgmt.compute.v2022_03_03.models.Disallowed
    :ivar purchase_plan: Describes the gallery image definition purchase plan. This is used by
     marketplace images.
    :vartype purchase_plan: ~azure.mgmt.compute.v2022_03_03.models.ImagePurchasePlan
    :ivar provisioning_state: The provisioning state, which only appears in the response. Known
     values are: "Creating", "Updating", "Failed", "Succeeded", "Deleting", and "Migrating".
    :vartype provisioning_state: str or
     ~azure.mgmt.compute.v2022_03_03.models.GalleryProvisioningState
    :ivar features: A list of gallery image features.
    :vartype features: list[~azure.mgmt.compute.v2022_03_03.models.GalleryImageFeature]
    :ivar architecture: The architecture of the image. Applicable to OS disks only. Known values
     are: "x64" and "Arm64".
    :vartype architecture: str or ~azure.mgmt.compute.v2022_03_03.models.Architecture
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "description": {"key": "properties.description", "type": "str"},
        "eula": {"key": "properties.eula", "type": "str"},
        "privacy_statement_uri": {"key": "properties.privacyStatementUri", "type": "str"},
        "release_note_uri": {"key": "properties.releaseNoteUri", "type": "str"},
        "os_type": {"key": "properties.osType", "type": "str"},
        "os_state": {"key": "properties.osState", "type": "str"},
        "hyper_v_generation": {"key": "properties.hyperVGeneration", "type": "str"},
        "end_of_life_date": {"key": "properties.endOfLifeDate", "type": "iso-8601"},
        "identifier": {"key": "properties.identifier", "type": "GalleryImageIdentifier"},
        "recommended": {"key": "properties.recommended", "type": "RecommendedMachineConfiguration"},
        "disallowed": {"key": "properties.disallowed", "type": "Disallowed"},
        "purchase_plan": {"key": "properties.purchasePlan", "type": "ImagePurchasePlan"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "features": {"key": "properties.features", "type": "[GalleryImageFeature]"},
        "architecture": {"key": "properties.architecture", "type": "str"},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        description: Optional[str] = None,
        eula: Optional[str] = None,
        privacy_statement_uri: Optional[str] = None,
        release_note_uri: Optional[str] = None,
        os_type: Optional[Union[str, "_models.OperatingSystemTypes"]] = None,
        os_state: Optional[Union[str, "_models.OperatingSystemStateTypes"]] = None,
        hyper_v_generation: Optional[Union[str, "_models.HyperVGeneration"]] = None,
        end_of_life_date: Optional[datetime.datetime] = None,
        identifier: Optional["_models.GalleryImageIdentifier"] = None,
        recommended: Optional["_models.RecommendedMachineConfiguration"] = None,
        disallowed: Optional["_models.Disallowed"] = None,
        purchase_plan: Optional["_models.ImagePurchasePlan"] = None,
        features: Optional[List["_models.GalleryImageFeature"]] = None,
        architecture: Optional[Union[str, "_models.Architecture"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword description: The description of this gallery image definition resource. This property
         is updatable.
        :paramtype description: str
        :keyword eula: The Eula agreement for the gallery image definition.
        :paramtype eula: str
        :keyword privacy_statement_uri: The privacy statement uri.
        :paramtype privacy_statement_uri: str
        :keyword release_note_uri: The release note uri.
        :paramtype release_note_uri: str
        :keyword os_type: This property allows you to specify the type of the OS that is included in
         the disk when creating a VM from a managed image. :code:`<br>`:code:`<br>` Possible values are:
         :code:`<br>`:code:`<br>` **Windows** :code:`<br>`:code:`<br>` **Linux**. Known values are:
         "Windows" and "Linux".
        :paramtype os_type: str or ~azure.mgmt.compute.v2022_03_03.models.OperatingSystemTypes
        :keyword os_state: This property allows the user to specify whether the virtual machines
         created under this image are 'Generalized' or 'Specialized'. Known values are: "Generalized"
         and "Specialized".
        :paramtype os_state: str or ~azure.mgmt.compute.v2022_03_03.models.OperatingSystemStateTypes
        :keyword hyper_v_generation: The hypervisor generation of the Virtual Machine. Applicable to OS
         disks only. Known values are: "V1" and "V2".
        :paramtype hyper_v_generation: str or ~azure.mgmt.compute.v2022_03_03.models.HyperVGeneration
        :keyword end_of_life_date: The end of life date of the gallery image definition. This property
         can be used for decommissioning purposes. This property is updatable.
        :paramtype end_of_life_date: ~datetime.datetime
        :keyword identifier: This is the gallery image definition identifier.
        :paramtype identifier: ~azure.mgmt.compute.v2022_03_03.models.GalleryImageIdentifier
        :keyword recommended: The properties describe the recommended machine configuration for this
         Image Definition. These properties are updatable.
        :paramtype recommended: ~azure.mgmt.compute.v2022_03_03.models.RecommendedMachineConfiguration
        :keyword disallowed: Describes the disallowed disk types.
        :paramtype disallowed: ~azure.mgmt.compute.v2022_03_03.models.Disallowed
        :keyword purchase_plan: Describes the gallery image definition purchase plan. This is used by
         marketplace images.
        :paramtype purchase_plan: ~azure.mgmt.compute.v2022_03_03.models.ImagePurchasePlan
        :keyword features: A list of gallery image features.
        :paramtype features: list[~azure.mgmt.compute.v2022_03_03.models.GalleryImageFeature]
        :keyword architecture: The architecture of the image. Applicable to OS disks only. Known values
         are: "x64" and "Arm64".
        :paramtype architecture: str or ~azure.mgmt.compute.v2022_03_03.models.Architecture
        """
        super().__init__(tags=tags, **kwargs)
        self.description = description
        self.eula = eula
        self.privacy_statement_uri = privacy_statement_uri
        self.release_note_uri = release_note_uri
        self.os_type = os_type
        self.os_state = os_state
        self.hyper_v_generation = hyper_v_generation
        self.end_of_life_date = end_of_life_date
        self.identifier = identifier
        self.recommended = recommended
        self.disallowed = disallowed
        self.purchase_plan = purchase_plan
        self.provisioning_state = None
        self.features = features
        self.architecture = architecture


class GalleryImageVersion(Resource):
    """Specifies information about the gallery image version that you want to create or update.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location. Required.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar publishing_profile: The publishing profile of a gallery image Version.
    :vartype publishing_profile:
     ~azure.mgmt.compute.v2022_03_03.models.GalleryImageVersionPublishingProfile
    :ivar provisioning_state: The provisioning state, which only appears in the response. Known
     values are: "Creating", "Updating", "Failed", "Succeeded", "Deleting", and "Migrating".
    :vartype provisioning_state: str or
     ~azure.mgmt.compute.v2022_03_03.models.GalleryProvisioningState
    :ivar storage_profile: This is the storage profile of a Gallery Image Version.
    :vartype storage_profile:
     ~azure.mgmt.compute.v2022_03_03.models.GalleryImageVersionStorageProfile
    :ivar safety_profile: This is the safety profile of the Gallery Image Version.
    :vartype safety_profile:
     ~azure.mgmt.compute.v2022_03_03.models.GalleryImageVersionSafetyProfile
    :ivar replication_status: This is the replication status of the gallery image version.
    :vartype replication_status: ~azure.mgmt.compute.v2022_03_03.models.ReplicationStatus
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
        "provisioning_state": {"readonly": True},
        "replication_status": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "publishing_profile": {"key": "properties.publishingProfile", "type": "GalleryImageVersionPublishingProfile"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "storage_profile": {"key": "properties.storageProfile", "type": "GalleryImageVersionStorageProfile"},
        "safety_profile": {"key": "properties.safetyProfile", "type": "GalleryImageVersionSafetyProfile"},
        "replication_status": {"key": "properties.replicationStatus", "type": "ReplicationStatus"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        publishing_profile: Optional["_models.GalleryImageVersionPublishingProfile"] = None,
        storage_profile: Optional["_models.GalleryImageVersionStorageProfile"] = None,
        safety_profile: Optional["_models.GalleryImageVersionSafetyProfile"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: Resource location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword publishing_profile: The publishing profile of a gallery image Version.
        :paramtype publishing_profile:
         ~azure.mgmt.compute.v2022_03_03.models.GalleryImageVersionPublishingProfile
        :keyword storage_profile: This is the storage profile of a Gallery Image Version.
        :paramtype storage_profile:
         ~azure.mgmt.compute.v2022_03_03.models.GalleryImageVersionStorageProfile
        :keyword safety_profile: This is the safety profile of the Gallery Image Version.
        :paramtype safety_profile:
         ~azure.mgmt.compute.v2022_03_03.models.GalleryImageVersionSafetyProfile
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.publishing_profile = publishing_profile
        self.provisioning_state = None
        self.storage_profile = storage_profile
        self.safety_profile = safety_profile
        self.replication_status = None


class GalleryImageVersionList(_serialization.Model):
    """The List Gallery Image version operation response.

    All required parameters must be populated in order to send to Azure.

    :ivar value: A list of gallery image versions. Required.
    :vartype value: list[~azure.mgmt.compute.v2022_03_03.models.GalleryImageVersion]
    :ivar next_link: The uri to fetch the next page of gallery image versions. Call ListNext() with
     this to fetch the next page of gallery image versions.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[GalleryImageVersion]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: List["_models.GalleryImageVersion"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: A list of gallery image versions. Required.
        :paramtype value: list[~azure.mgmt.compute.v2022_03_03.models.GalleryImageVersion]
        :keyword next_link: The uri to fetch the next page of gallery image versions. Call ListNext()
         with this to fetch the next page of gallery image versions.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class GalleryImageVersionPublishingProfile(GalleryArtifactPublishingProfileBase):
    """The publishing profile of a gallery image Version.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar target_regions: The target regions where the Image Version is going to be replicated to.
     This property is updatable.
    :vartype target_regions: list[~azure.mgmt.compute.v2022_03_03.models.TargetRegion]
    :ivar replica_count: The number of replicas of the Image Version to be created per region. This
     property would take effect for a region when regionalReplicaCount is not specified. This
     property is updatable.
    :vartype replica_count: int
    :ivar exclude_from_latest: If set to true, Virtual Machines deployed from the latest version of
     the Image Definition won't use this Image Version.
    :vartype exclude_from_latest: bool
    :ivar published_date: The timestamp for when the gallery image version is published.
    :vartype published_date: ~datetime.datetime
    :ivar end_of_life_date: The end of life date of the gallery image version. This property can be
     used for decommissioning purposes. This property is updatable.
    :vartype end_of_life_date: ~datetime.datetime
    :ivar storage_account_type: Specifies the storage account type to be used to store the image.
     This property is not updatable. Known values are: "Standard_LRS", "Standard_ZRS", and
     "Premium_LRS".
    :vartype storage_account_type: str or ~azure.mgmt.compute.v2022_03_03.models.StorageAccountType
    :ivar replication_mode: Optional parameter which specifies the mode to be used for replication.
     This property is not updatable. Known values are: "Full" and "Shallow".
    :vartype replication_mode: str or ~azure.mgmt.compute.v2022_03_03.models.ReplicationMode
    :ivar target_extended_locations: The target extended locations where the Image Version is going
     to be replicated to. This property is updatable.
    :vartype target_extended_locations:
     list[~azure.mgmt.compute.v2022_03_03.models.GalleryTargetExtendedLocation]
    """

    _validation = {
        "published_date": {"readonly": True},
    }

    _attribute_map = {
        "target_regions": {"key": "targetRegions", "type": "[TargetRegion]"},
        "replica_count": {"key": "replicaCount", "type": "int"},
        "exclude_from_latest": {"key": "excludeFromLatest", "type": "bool"},
        "published_date": {"key": "publishedDate", "type": "iso-8601"},
        "end_of_life_date": {"key": "endOfLifeDate", "type": "iso-8601"},
        "storage_account_type": {"key": "storageAccountType", "type": "str"},
        "replication_mode": {"key": "replicationMode", "type": "str"},
        "target_extended_locations": {"key": "targetExtendedLocations", "type": "[GalleryTargetExtendedLocation]"},
    }

    def __init__(
        self,
        *,
        target_regions: Optional[List["_models.TargetRegion"]] = None,
        replica_count: Optional[int] = None,
        exclude_from_latest: Optional[bool] = None,
        end_of_life_date: Optional[datetime.datetime] = None,
        storage_account_type: Optional[Union[str, "_models.StorageAccountType"]] = None,
        replication_mode: Optional[Union[str, "_models.ReplicationMode"]] = None,
        target_extended_locations: Optional[List["_models.GalleryTargetExtendedLocation"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword target_regions: The target regions where the Image Version is going to be replicated
         to. This property is updatable.
        :paramtype target_regions: list[~azure.mgmt.compute.v2022_03_03.models.TargetRegion]
        :keyword replica_count: The number of replicas of the Image Version to be created per region.
         This property would take effect for a region when regionalReplicaCount is not specified. This
         property is updatable.
        :paramtype replica_count: int
        :keyword exclude_from_latest: If set to true, Virtual Machines deployed from the latest version
         of the Image Definition won't use this Image Version.
        :paramtype exclude_from_latest: bool
        :keyword end_of_life_date: The end of life date of the gallery image version. This property can
         be used for decommissioning purposes. This property is updatable.
        :paramtype end_of_life_date: ~datetime.datetime
        :keyword storage_account_type: Specifies the storage account type to be used to store the
         image. This property is not updatable. Known values are: "Standard_LRS", "Standard_ZRS", and
         "Premium_LRS".
        :paramtype storage_account_type: str or
         ~azure.mgmt.compute.v2022_03_03.models.StorageAccountType
        :keyword replication_mode: Optional parameter which specifies the mode to be used for
         replication. This property is not updatable. Known values are: "Full" and "Shallow".
        :paramtype replication_mode: str or ~azure.mgmt.compute.v2022_03_03.models.ReplicationMode
        :keyword target_extended_locations: The target extended locations where the Image Version is
         going to be replicated to. This property is updatable.
        :paramtype target_extended_locations:
         list[~azure.mgmt.compute.v2022_03_03.models.GalleryTargetExtendedLocation]
        """
        super().__init__(
            target_regions=target_regions,
            replica_count=replica_count,
            exclude_from_latest=exclude_from_latest,
            end_of_life_date=end_of_life_date,
            storage_account_type=storage_account_type,
            replication_mode=replication_mode,
            target_extended_locations=target_extended_locations,
            **kwargs
        )


class GalleryImageVersionSafetyProfile(GalleryArtifactSafetyProfileBase):
    """This is the safety profile of the Gallery Image Version.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar allow_deletion_of_replicated_locations: Indicates whether or not removing this Gallery
     Image Version from replicated regions is allowed.
    :vartype allow_deletion_of_replicated_locations: bool
    :ivar reported_for_policy_violation: Indicates whether this image has been reported as
     violating Microsoft's policies.
    :vartype reported_for_policy_violation: bool
    :ivar policy_violations: A list of Policy Violations that have been reported for this Gallery
     Image Version.
    :vartype policy_violations: list[~azure.mgmt.compute.v2022_03_03.models.PolicyViolation]
    """

    _validation = {
        "reported_for_policy_violation": {"readonly": True},
        "policy_violations": {"readonly": True},
    }

    _attribute_map = {
        "allow_deletion_of_replicated_locations": {"key": "allowDeletionOfReplicatedLocations", "type": "bool"},
        "reported_for_policy_violation": {"key": "reportedForPolicyViolation", "type": "bool"},
        "policy_violations": {"key": "policyViolations", "type": "[PolicyViolation]"},
    }

    def __init__(self, *, allow_deletion_of_replicated_locations: Optional[bool] = None, **kwargs: Any) -> None:
        """
        :keyword allow_deletion_of_replicated_locations: Indicates whether or not removing this Gallery
         Image Version from replicated regions is allowed.
        :paramtype allow_deletion_of_replicated_locations: bool
        """
        super().__init__(allow_deletion_of_replicated_locations=allow_deletion_of_replicated_locations, **kwargs)
        self.reported_for_policy_violation = None
        self.policy_violations = None


class GalleryImageVersionStorageProfile(_serialization.Model):
    """This is the storage profile of a Gallery Image Version.

    :ivar source: The source of the gallery artifact version.
    :vartype source: ~azure.mgmt.compute.v2022_03_03.models.GalleryArtifactVersionFullSource
    :ivar os_disk_image: This is the OS disk image.
    :vartype os_disk_image: ~azure.mgmt.compute.v2022_03_03.models.GalleryOSDiskImage
    :ivar data_disk_images: A list of data disk images.
    :vartype data_disk_images: list[~azure.mgmt.compute.v2022_03_03.models.GalleryDataDiskImage]
    """

    _attribute_map = {
        "source": {"key": "source", "type": "GalleryArtifactVersionFullSource"},
        "os_disk_image": {"key": "osDiskImage", "type": "GalleryOSDiskImage"},
        "data_disk_images": {"key": "dataDiskImages", "type": "[GalleryDataDiskImage]"},
    }

    def __init__(
        self,
        *,
        source: Optional["_models.GalleryArtifactVersionFullSource"] = None,
        os_disk_image: Optional["_models.GalleryOSDiskImage"] = None,
        data_disk_images: Optional[List["_models.GalleryDataDiskImage"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword source: The source of the gallery artifact version.
        :paramtype source: ~azure.mgmt.compute.v2022_03_03.models.GalleryArtifactVersionFullSource
        :keyword os_disk_image: This is the OS disk image.
        :paramtype os_disk_image: ~azure.mgmt.compute.v2022_03_03.models.GalleryOSDiskImage
        :keyword data_disk_images: A list of data disk images.
        :paramtype data_disk_images: list[~azure.mgmt.compute.v2022_03_03.models.GalleryDataDiskImage]
        """
        super().__init__(**kwargs)
        self.source = source
        self.os_disk_image = os_disk_image
        self.data_disk_images = data_disk_images


class GalleryImageVersionUpdate(UpdateResourceDefinition):
    """Specifies information about the gallery image version that you want to update.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar publishing_profile: The publishing profile of a gallery image Version.
    :vartype publishing_profile:
     ~azure.mgmt.compute.v2022_03_03.models.GalleryImageVersionPublishingProfile
    :ivar provisioning_state: The provisioning state, which only appears in the response. Known
     values are: "Creating", "Updating", "Failed", "Succeeded", "Deleting", and "Migrating".
    :vartype provisioning_state: str or
     ~azure.mgmt.compute.v2022_03_03.models.GalleryProvisioningState
    :ivar storage_profile: This is the storage profile of a Gallery Image Version.
    :vartype storage_profile:
     ~azure.mgmt.compute.v2022_03_03.models.GalleryImageVersionStorageProfile
    :ivar safety_profile: This is the safety profile of the Gallery Image Version.
    :vartype safety_profile:
     ~azure.mgmt.compute.v2022_03_03.models.GalleryImageVersionSafetyProfile
    :ivar replication_status: This is the replication status of the gallery image version.
    :vartype replication_status: ~azure.mgmt.compute.v2022_03_03.models.ReplicationStatus
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "replication_status": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "publishing_profile": {"key": "properties.publishingProfile", "type": "GalleryImageVersionPublishingProfile"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "storage_profile": {"key": "properties.storageProfile", "type": "GalleryImageVersionStorageProfile"},
        "safety_profile": {"key": "properties.safetyProfile", "type": "GalleryImageVersionSafetyProfile"},
        "replication_status": {"key": "properties.replicationStatus", "type": "ReplicationStatus"},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        publishing_profile: Optional["_models.GalleryImageVersionPublishingProfile"] = None,
        storage_profile: Optional["_models.GalleryImageVersionStorageProfile"] = None,
        safety_profile: Optional["_models.GalleryImageVersionSafetyProfile"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword publishing_profile: The publishing profile of a gallery image Version.
        :paramtype publishing_profile:
         ~azure.mgmt.compute.v2022_03_03.models.GalleryImageVersionPublishingProfile
        :keyword storage_profile: This is the storage profile of a Gallery Image Version.
        :paramtype storage_profile:
         ~azure.mgmt.compute.v2022_03_03.models.GalleryImageVersionStorageProfile
        :keyword safety_profile: This is the safety profile of the Gallery Image Version.
        :paramtype safety_profile:
         ~azure.mgmt.compute.v2022_03_03.models.GalleryImageVersionSafetyProfile
        """
        super().__init__(tags=tags, **kwargs)
        self.publishing_profile = publishing_profile
        self.provisioning_state = None
        self.storage_profile = storage_profile
        self.safety_profile = safety_profile
        self.replication_status = None


class GalleryList(_serialization.Model):
    """The List Galleries operation response.

    All required parameters must be populated in order to send to Azure.

    :ivar value: A list of galleries. Required.
    :vartype value: list[~azure.mgmt.compute.v2022_03_03.models.Gallery]
    :ivar next_link: The uri to fetch the next page of galleries. Call ListNext() with this to
     fetch the next page of galleries.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Gallery]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.Gallery"], next_link: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword value: A list of galleries. Required.
        :paramtype value: list[~azure.mgmt.compute.v2022_03_03.models.Gallery]
        :keyword next_link: The uri to fetch the next page of galleries. Call ListNext() with this to
         fetch the next page of galleries.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class GalleryOSDiskImage(GalleryDiskImage):
    """This is the OS disk image.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar size_in_gb: This property indicates the size of the VHD to be created.
    :vartype size_in_gb: int
    :ivar host_caching: The host caching of the disk. Valid values are 'None', 'ReadOnly', and
     'ReadWrite'. Known values are: "None", "ReadOnly", and "ReadWrite".
    :vartype host_caching: str or ~azure.mgmt.compute.v2022_03_03.models.HostCaching
    :ivar source: The source for the disk image.
    :vartype source: ~azure.mgmt.compute.v2022_03_03.models.GalleryDiskImageSource
    """

    _validation = {
        "size_in_gb": {"readonly": True},
    }

    _attribute_map = {
        "size_in_gb": {"key": "sizeInGB", "type": "int"},
        "host_caching": {"key": "hostCaching", "type": "str"},
        "source": {"key": "source", "type": "GalleryDiskImageSource"},
    }

    def __init__(
        self,
        *,
        host_caching: Optional[Union[str, "_models.HostCaching"]] = None,
        source: Optional["_models.GalleryDiskImageSource"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword host_caching: The host caching of the disk. Valid values are 'None', 'ReadOnly', and
         'ReadWrite'. Known values are: "None", "ReadOnly", and "ReadWrite".
        :paramtype host_caching: str or ~azure.mgmt.compute.v2022_03_03.models.HostCaching
        :keyword source: The source for the disk image.
        :paramtype source: ~azure.mgmt.compute.v2022_03_03.models.GalleryDiskImageSource
        """
        super().__init__(host_caching=host_caching, source=source, **kwargs)


class GalleryTargetExtendedLocation(_serialization.Model):
    """GalleryTargetExtendedLocation.

    :ivar name: The name of the region.
    :vartype name: str
    :ivar extended_location: The name of the extended location.
    :vartype extended_location: ~azure.mgmt.compute.v2022_03_03.models.GalleryExtendedLocation
    :ivar extended_location_replica_count: The number of replicas of the Image Version to be
     created per extended location. This property is updatable.
    :vartype extended_location_replica_count: int
    :ivar storage_account_type: Specifies the storage account type to be used to store the image.
     This property is not updatable. Known values are: "Standard_LRS", "Standard_ZRS",
     "StandardSSD_LRS", and "Premium_LRS".
    :vartype storage_account_type: str or
     ~azure.mgmt.compute.v2022_03_03.models.EdgeZoneStorageAccountType
    :ivar encryption: Optional. Allows users to provide customer managed keys for encrypting the OS
     and data disks in the gallery artifact.
    :vartype encryption: ~azure.mgmt.compute.v2022_03_03.models.EncryptionImages
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "extended_location": {"key": "extendedLocation", "type": "GalleryExtendedLocation"},
        "extended_location_replica_count": {"key": "extendedLocationReplicaCount", "type": "int"},
        "storage_account_type": {"key": "storageAccountType", "type": "str"},
        "encryption": {"key": "encryption", "type": "EncryptionImages"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        extended_location: Optional["_models.GalleryExtendedLocation"] = None,
        extended_location_replica_count: Optional[int] = None,
        storage_account_type: Optional[Union[str, "_models.EdgeZoneStorageAccountType"]] = None,
        encryption: Optional["_models.EncryptionImages"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The name of the region.
        :paramtype name: str
        :keyword extended_location: The name of the extended location.
        :paramtype extended_location: ~azure.mgmt.compute.v2022_03_03.models.GalleryExtendedLocation
        :keyword extended_location_replica_count: The number of replicas of the Image Version to be
         created per extended location. This property is updatable.
        :paramtype extended_location_replica_count: int
        :keyword storage_account_type: Specifies the storage account type to be used to store the
         image. This property is not updatable. Known values are: "Standard_LRS", "Standard_ZRS",
         "StandardSSD_LRS", and "Premium_LRS".
        :paramtype storage_account_type: str or
         ~azure.mgmt.compute.v2022_03_03.models.EdgeZoneStorageAccountType
        :keyword encryption: Optional. Allows users to provide customer managed keys for encrypting the
         OS and data disks in the gallery artifact.
        :paramtype encryption: ~azure.mgmt.compute.v2022_03_03.models.EncryptionImages
        """
        super().__init__(**kwargs)
        self.name = name
        self.extended_location = extended_location
        self.extended_location_replica_count = extended_location_replica_count
        self.storage_account_type = storage_account_type
        self.encryption = encryption


class GalleryUpdate(UpdateResourceDefinition):
    """Specifies information about the Shared Image Gallery that you want to update.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar description: The description of this Shared Image Gallery resource. This property is
     updatable.
    :vartype description: str
    :ivar identifier: Describes the gallery unique name.
    :vartype identifier: ~azure.mgmt.compute.v2022_03_03.models.GalleryIdentifier
    :ivar provisioning_state: The provisioning state, which only appears in the response. Known
     values are: "Creating", "Updating", "Failed", "Succeeded", "Deleting", and "Migrating".
    :vartype provisioning_state: str or
     ~azure.mgmt.compute.v2022_03_03.models.GalleryProvisioningState
    :ivar sharing_profile: Profile for gallery sharing to subscription or tenant.
    :vartype sharing_profile: ~azure.mgmt.compute.v2022_03_03.models.SharingProfile
    :ivar soft_delete_policy: Contains information about the soft deletion policy of the gallery.
    :vartype soft_delete_policy: ~azure.mgmt.compute.v2022_03_03.models.SoftDeletePolicy
    :ivar sharing_status: Sharing status of current gallery.
    :vartype sharing_status: ~azure.mgmt.compute.v2022_03_03.models.SharingStatus
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "sharing_status": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "description": {"key": "properties.description", "type": "str"},
        "identifier": {"key": "properties.identifier", "type": "GalleryIdentifier"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "sharing_profile": {"key": "properties.sharingProfile", "type": "SharingProfile"},
        "soft_delete_policy": {"key": "properties.softDeletePolicy", "type": "SoftDeletePolicy"},
        "sharing_status": {"key": "properties.sharingStatus", "type": "SharingStatus"},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        description: Optional[str] = None,
        identifier: Optional["_models.GalleryIdentifier"] = None,
        sharing_profile: Optional["_models.SharingProfile"] = None,
        soft_delete_policy: Optional["_models.SoftDeletePolicy"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword description: The description of this Shared Image Gallery resource. This property is
         updatable.
        :paramtype description: str
        :keyword identifier: Describes the gallery unique name.
        :paramtype identifier: ~azure.mgmt.compute.v2022_03_03.models.GalleryIdentifier
        :keyword sharing_profile: Profile for gallery sharing to subscription or tenant.
        :paramtype sharing_profile: ~azure.mgmt.compute.v2022_03_03.models.SharingProfile
        :keyword soft_delete_policy: Contains information about the soft deletion policy of the
         gallery.
        :paramtype soft_delete_policy: ~azure.mgmt.compute.v2022_03_03.models.SoftDeletePolicy
        """
        super().__init__(tags=tags, **kwargs)
        self.description = description
        self.identifier = identifier
        self.provisioning_state = None
        self.sharing_profile = sharing_profile
        self.soft_delete_policy = soft_delete_policy
        self.sharing_status = None


class ImagePurchasePlan(_serialization.Model):
    """Describes the gallery image definition purchase plan. This is used by marketplace images.

    :ivar name: The plan ID.
    :vartype name: str
    :ivar publisher: The publisher ID.
    :vartype publisher: str
    :ivar product: The product ID.
    :vartype product: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "publisher": {"key": "publisher", "type": "str"},
        "product": {"key": "product", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        publisher: Optional[str] = None,
        product: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The plan ID.
        :paramtype name: str
        :keyword publisher: The publisher ID.
        :paramtype publisher: str
        :keyword product: The product ID.
        :paramtype product: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.publisher = publisher
        self.product = product


class InnerError(_serialization.Model):
    """Inner error details.

    :ivar exceptiontype: The exception type.
    :vartype exceptiontype: str
    :ivar errordetail: The internal error message or exception dump.
    :vartype errordetail: str
    """

    _attribute_map = {
        "exceptiontype": {"key": "exceptiontype", "type": "str"},
        "errordetail": {"key": "errordetail", "type": "str"},
    }

    def __init__(
        self, *, exceptiontype: Optional[str] = None, errordetail: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword exceptiontype: The exception type.
        :paramtype exceptiontype: str
        :keyword errordetail: The internal error message or exception dump.
        :paramtype errordetail: str
        """
        super().__init__(**kwargs)
        self.exceptiontype = exceptiontype
        self.errordetail = errordetail


class LatestGalleryImageVersion(_serialization.Model):
    """The gallery image version with latest version in a particular region.

    :ivar latest_version_name: The name of the latest version in the region.
    :vartype latest_version_name: str
    :ivar location: region of the Gallery Image Version.
    :vartype location: str
    """

    _attribute_map = {
        "latest_version_name": {"key": "latestVersionName", "type": "str"},
        "location": {"key": "location", "type": "str"},
    }

    def __init__(
        self, *, latest_version_name: Optional[str] = None, location: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword latest_version_name: The name of the latest version in the region.
        :paramtype latest_version_name: str
        :keyword location: region of the Gallery Image Version.
        :paramtype location: str
        """
        super().__init__(**kwargs)
        self.latest_version_name = latest_version_name
        self.location = location


class ManagedArtifact(_serialization.Model):
    """The managed artifact.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The managed artifact id. Required.
    :vartype id: str
    """

    _validation = {
        "id": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, *, id: str, **kwargs: Any) -> None:  # pylint: disable=redefined-builtin
        """
        :keyword id: The managed artifact id. Required.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id


class OSDiskImageEncryption(DiskImageEncryption):
    """Contains encryption settings for an OS disk image.

    :ivar disk_encryption_set_id: A relative URI containing the resource ID of the disk encryption
     set.
    :vartype disk_encryption_set_id: str
    :ivar security_profile: This property specifies the security profile of an OS disk image.
    :vartype security_profile: ~azure.mgmt.compute.v2022_03_03.models.OSDiskImageSecurityProfile
    """

    _attribute_map = {
        "disk_encryption_set_id": {"key": "diskEncryptionSetId", "type": "str"},
        "security_profile": {"key": "securityProfile", "type": "OSDiskImageSecurityProfile"},
    }

    def __init__(
        self,
        *,
        disk_encryption_set_id: Optional[str] = None,
        security_profile: Optional["_models.OSDiskImageSecurityProfile"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword disk_encryption_set_id: A relative URI containing the resource ID of the disk
         encryption set.
        :paramtype disk_encryption_set_id: str
        :keyword security_profile: This property specifies the security profile of an OS disk image.
        :paramtype security_profile: ~azure.mgmt.compute.v2022_03_03.models.OSDiskImageSecurityProfile
        """
        super().__init__(disk_encryption_set_id=disk_encryption_set_id, **kwargs)
        self.security_profile = security_profile


class OSDiskImageSecurityProfile(_serialization.Model):
    """Contains security profile for an OS disk image.

    :ivar confidential_vm_encryption_type: confidential VM encryption types. Known values are:
     "EncryptedVMGuestStateOnlyWithPmk", "EncryptedWithPmk", and "EncryptedWithCmk".
    :vartype confidential_vm_encryption_type: str or
     ~azure.mgmt.compute.v2022_03_03.models.ConfidentialVMEncryptionType
    :ivar secure_vm_disk_encryption_set_id: secure VM disk encryption set id.
    :vartype secure_vm_disk_encryption_set_id: str
    """

    _attribute_map = {
        "confidential_vm_encryption_type": {"key": "confidentialVMEncryptionType", "type": "str"},
        "secure_vm_disk_encryption_set_id": {"key": "secureVMDiskEncryptionSetId", "type": "str"},
    }

    def __init__(
        self,
        *,
        confidential_vm_encryption_type: Optional[Union[str, "_models.ConfidentialVMEncryptionType"]] = None,
        secure_vm_disk_encryption_set_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword confidential_vm_encryption_type: confidential VM encryption types. Known values are:
         "EncryptedVMGuestStateOnlyWithPmk", "EncryptedWithPmk", and "EncryptedWithCmk".
        :paramtype confidential_vm_encryption_type: str or
         ~azure.mgmt.compute.v2022_03_03.models.ConfidentialVMEncryptionType
        :keyword secure_vm_disk_encryption_set_id: secure VM disk encryption set id.
        :paramtype secure_vm_disk_encryption_set_id: str
        """
        super().__init__(**kwargs)
        self.confidential_vm_encryption_type = confidential_vm_encryption_type
        self.secure_vm_disk_encryption_set_id = secure_vm_disk_encryption_set_id


class PirResource(_serialization.Model):
    """The Resource model definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Resource name.
    :vartype name: str
    :ivar location: Resource location.
    :vartype location: str
    """

    _validation = {
        "name": {"readonly": True},
        "location": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "location": {"key": "location", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.name = None
        self.location = None


class PirSharedGalleryResource(PirResource):
    """Base information about the shared gallery resource in pir.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Resource name.
    :vartype name: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar unique_id: The unique id of this shared gallery.
    :vartype unique_id: str
    """

    _validation = {
        "name": {"readonly": True},
        "location": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "unique_id": {"key": "identifier.uniqueId", "type": "str"},
    }

    def __init__(self, *, unique_id: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword unique_id: The unique id of this shared gallery.
        :paramtype unique_id: str
        """
        super().__init__(**kwargs)
        self.unique_id = unique_id


class PolicyViolation(_serialization.Model):
    """A policy violation reported against a gallery artifact.

    :ivar category: Describes the nature of the policy violation. Known values are: "Other",
     "ImageFlaggedUnsafe", "CopyrightValidation", and "IpTheft".
    :vartype category: str or ~azure.mgmt.compute.v2022_03_03.models.PolicyViolationCategory
    :ivar details: Describes specific details about why this policy violation was reported.
    :vartype details: str
    """

    _attribute_map = {
        "category": {"key": "category", "type": "str"},
        "details": {"key": "details", "type": "str"},
    }

    def __init__(
        self,
        *,
        category: Optional[Union[str, "_models.PolicyViolationCategory"]] = None,
        details: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword category: Describes the nature of the policy violation. Known values are: "Other",
         "ImageFlaggedUnsafe", "CopyrightValidation", and "IpTheft".
        :paramtype category: str or ~azure.mgmt.compute.v2022_03_03.models.PolicyViolationCategory
        :keyword details: Describes specific details about why this policy violation was reported.
        :paramtype details: str
        """
        super().__init__(**kwargs)
        self.category = category
        self.details = details


class RecommendedMachineConfiguration(_serialization.Model):
    """The properties describe the recommended machine configuration for this Image Definition. These
    properties are updatable.

    :ivar v_cp_us: Describes the resource range.
    :vartype v_cp_us: ~azure.mgmt.compute.v2022_03_03.models.ResourceRange
    :ivar memory: Describes the resource range.
    :vartype memory: ~azure.mgmt.compute.v2022_03_03.models.ResourceRange
    """

    _attribute_map = {
        "v_cp_us": {"key": "vCPUs", "type": "ResourceRange"},
        "memory": {"key": "memory", "type": "ResourceRange"},
    }

    def __init__(
        self,
        *,
        v_cp_us: Optional["_models.ResourceRange"] = None,
        memory: Optional["_models.ResourceRange"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword v_cp_us: Describes the resource range.
        :paramtype v_cp_us: ~azure.mgmt.compute.v2022_03_03.models.ResourceRange
        :keyword memory: Describes the resource range.
        :paramtype memory: ~azure.mgmt.compute.v2022_03_03.models.ResourceRange
        """
        super().__init__(**kwargs)
        self.v_cp_us = v_cp_us
        self.memory = memory


class RegionalReplicationStatus(_serialization.Model):
    """This is the regional replication status.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar region: The region to which the gallery image version is being replicated to.
    :vartype region: str
    :ivar state: This is the regional replication state. Known values are: "Unknown",
     "Replicating", "Completed", and "Failed".
    :vartype state: str or ~azure.mgmt.compute.v2022_03_03.models.ReplicationState
    :ivar details: The details of the replication status.
    :vartype details: str
    :ivar progress: It indicates progress of the replication job.
    :vartype progress: int
    """

    _validation = {
        "region": {"readonly": True},
        "state": {"readonly": True},
        "details": {"readonly": True},
        "progress": {"readonly": True},
    }

    _attribute_map = {
        "region": {"key": "region", "type": "str"},
        "state": {"key": "state", "type": "str"},
        "details": {"key": "details", "type": "str"},
        "progress": {"key": "progress", "type": "int"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.region = None
        self.state = None
        self.details = None
        self.progress = None


class RegionalSharingStatus(_serialization.Model):
    """Gallery regional sharing status.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar region: Region name.
    :vartype region: str
    :ivar state: Gallery sharing state in current region. Known values are: "Succeeded",
     "InProgress", "Failed", and "Unknown".
    :vartype state: str or ~azure.mgmt.compute.v2022_03_03.models.SharingState
    :ivar details: Details of gallery regional sharing failure.
    :vartype details: str
    """

    _validation = {
        "state": {"readonly": True},
    }

    _attribute_map = {
        "region": {"key": "region", "type": "str"},
        "state": {"key": "state", "type": "str"},
        "details": {"key": "details", "type": "str"},
    }

    def __init__(self, *, region: Optional[str] = None, details: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword region: Region name.
        :paramtype region: str
        :keyword details: Details of gallery regional sharing failure.
        :paramtype details: str
        """
        super().__init__(**kwargs)
        self.region = region
        self.state = None
        self.details = details


class ReplicationStatus(_serialization.Model):
    """This is the replication status of the gallery image version.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar aggregated_state: This is the aggregated replication status based on all the regional
     replication status flags. Known values are: "Unknown", "InProgress", "Completed", and "Failed".
    :vartype aggregated_state: str or
     ~azure.mgmt.compute.v2022_03_03.models.AggregatedReplicationState
    :ivar summary: This is a summary of replication status for each region.
    :vartype summary: list[~azure.mgmt.compute.v2022_03_03.models.RegionalReplicationStatus]
    """

    _validation = {
        "aggregated_state": {"readonly": True},
        "summary": {"readonly": True},
    }

    _attribute_map = {
        "aggregated_state": {"key": "aggregatedState", "type": "str"},
        "summary": {"key": "summary", "type": "[RegionalReplicationStatus]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.aggregated_state = None
        self.summary = None


class ResourceRange(_serialization.Model):
    """Describes the resource range.

    :ivar min: The minimum number of the resource.
    :vartype min: int
    :ivar max: The maximum number of the resource.
    :vartype max: int
    """

    _attribute_map = {
        "min": {"key": "min", "type": "int"},
        "max": {"key": "max", "type": "int"},
    }

    def __init__(
        self,
        *,
        min: Optional[int] = None,  # pylint: disable=redefined-builtin
        max: Optional[int] = None,  # pylint: disable=redefined-builtin
        **kwargs: Any
    ) -> None:
        """
        :keyword min: The minimum number of the resource.
        :paramtype min: int
        :keyword max: The maximum number of the resource.
        :paramtype max: int
        """
        super().__init__(**kwargs)
        self.min = min
        self.max = max


class ResourceWithOptionalLocation(_serialization.Model):
    """The Resource model definition with location property as optional.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar location: Resource location.
    :vartype location: str
    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "location": {"key": "location", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, *, location: Optional[str] = None, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.location = location
        self.id = None
        self.name = None
        self.type = None
        self.tags = tags


class SharedGallery(PirSharedGalleryResource):
    """Specifies information about the Shared Gallery that you want to create or update.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Resource name.
    :vartype name: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar unique_id: The unique id of this shared gallery.
    :vartype unique_id: str
    """

    _validation = {
        "name": {"readonly": True},
        "location": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "unique_id": {"key": "identifier.uniqueId", "type": "str"},
    }

    def __init__(self, *, unique_id: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword unique_id: The unique id of this shared gallery.
        :paramtype unique_id: str
        """
        super().__init__(unique_id=unique_id, **kwargs)


class SharedGalleryDiskImage(_serialization.Model):
    """This is the disk image base class.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar disk_size_gb: This property indicates the size of the VHD to be created.
    :vartype disk_size_gb: int
    :ivar host_caching: The host caching of the disk. Valid values are 'None', 'ReadOnly', and
     'ReadWrite'. Known values are: "None", "ReadOnly", and "ReadWrite".
    :vartype host_caching: str or ~azure.mgmt.compute.v2022_03_03.models.SharedGalleryHostCaching
    """

    _validation = {
        "disk_size_gb": {"readonly": True},
    }

    _attribute_map = {
        "disk_size_gb": {"key": "diskSizeGB", "type": "int"},
        "host_caching": {"key": "hostCaching", "type": "str"},
    }

    def __init__(
        self, *, host_caching: Optional[Union[str, "_models.SharedGalleryHostCaching"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword host_caching: The host caching of the disk. Valid values are 'None', 'ReadOnly', and
         'ReadWrite'. Known values are: "None", "ReadOnly", and "ReadWrite".
        :paramtype host_caching: str or ~azure.mgmt.compute.v2022_03_03.models.SharedGalleryHostCaching
        """
        super().__init__(**kwargs)
        self.disk_size_gb = None
        self.host_caching = host_caching


class SharedGalleryDataDiskImage(SharedGalleryDiskImage):
    """This is the data disk image.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar disk_size_gb: This property indicates the size of the VHD to be created.
    :vartype disk_size_gb: int
    :ivar host_caching: The host caching of the disk. Valid values are 'None', 'ReadOnly', and
     'ReadWrite'. Known values are: "None", "ReadOnly", and "ReadWrite".
    :vartype host_caching: str or ~azure.mgmt.compute.v2022_03_03.models.SharedGalleryHostCaching
    :ivar lun: This property specifies the logical unit number of the data disk. This value is used
     to identify data disks within the Virtual Machine and therefore must be unique for each data
     disk attached to the Virtual Machine. Required.
    :vartype lun: int
    """

    _validation = {
        "disk_size_gb": {"readonly": True},
        "lun": {"required": True},
    }

    _attribute_map = {
        "disk_size_gb": {"key": "diskSizeGB", "type": "int"},
        "host_caching": {"key": "hostCaching", "type": "str"},
        "lun": {"key": "lun", "type": "int"},
    }

    def __init__(
        self, *, lun: int, host_caching: Optional[Union[str, "_models.SharedGalleryHostCaching"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword host_caching: The host caching of the disk. Valid values are 'None', 'ReadOnly', and
         'ReadWrite'. Known values are: "None", "ReadOnly", and "ReadWrite".
        :paramtype host_caching: str or ~azure.mgmt.compute.v2022_03_03.models.SharedGalleryHostCaching
        :keyword lun: This property specifies the logical unit number of the data disk. This value is
         used to identify data disks within the Virtual Machine and therefore must be unique for each
         data disk attached to the Virtual Machine. Required.
        :paramtype lun: int
        """
        super().__init__(host_caching=host_caching, **kwargs)
        self.lun = lun


class SharedGalleryImage(PirSharedGalleryResource):  # pylint: disable=too-many-instance-attributes
    """Specifies information about the gallery image definition that you want to create or update.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Resource name.
    :vartype name: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar unique_id: The unique id of this shared gallery.
    :vartype unique_id: str
    :ivar os_type: This property allows you to specify the type of the OS that is included in the
     disk when creating a VM from a managed image. :code:`<br>`:code:`<br>` Possible values are:
     :code:`<br>`:code:`<br>` **Windows** :code:`<br>`:code:`<br>` **Linux**. Known values are:
     "Windows" and "Linux".
    :vartype os_type: str or ~azure.mgmt.compute.v2022_03_03.models.OperatingSystemTypes
    :ivar os_state: This property allows the user to specify whether the virtual machines created
     under this image are 'Generalized' or 'Specialized'. Known values are: "Generalized" and
     "Specialized".
    :vartype os_state: str or ~azure.mgmt.compute.v2022_03_03.models.OperatingSystemStateTypes
    :ivar end_of_life_date: The end of life date of the gallery image definition. This property can
     be used for decommissioning purposes. This property is updatable.
    :vartype end_of_life_date: ~datetime.datetime
    :ivar identifier: This is the gallery image definition identifier.
    :vartype identifier: ~azure.mgmt.compute.v2022_03_03.models.GalleryImageIdentifier
    :ivar recommended: The properties describe the recommended machine configuration for this Image
     Definition. These properties are updatable.
    :vartype recommended: ~azure.mgmt.compute.v2022_03_03.models.RecommendedMachineConfiguration
    :ivar disallowed: Describes the disallowed disk types.
    :vartype disallowed: ~azure.mgmt.compute.v2022_03_03.models.Disallowed
    :ivar hyper_v_generation: The hypervisor generation of the Virtual Machine. Applicable to OS
     disks only. Known values are: "V1" and "V2".
    :vartype hyper_v_generation: str or ~azure.mgmt.compute.v2022_03_03.models.HyperVGeneration
    :ivar features: A list of gallery image features.
    :vartype features: list[~azure.mgmt.compute.v2022_03_03.models.GalleryImageFeature]
    :ivar purchase_plan: Describes the gallery image definition purchase plan. This is used by
     marketplace images.
    :vartype purchase_plan: ~azure.mgmt.compute.v2022_03_03.models.ImagePurchasePlan
    :ivar architecture: The architecture of the image. Applicable to OS disks only. Known values
     are: "x64" and "Arm64".
    :vartype architecture: str or ~azure.mgmt.compute.v2022_03_03.models.Architecture
    :ivar privacy_statement_uri: Privacy statement uri for the current community gallery image.
    :vartype privacy_statement_uri: str
    :ivar eula: End-user license agreement for the current community gallery image.
    :vartype eula: str
    """

    _validation = {
        "name": {"readonly": True},
        "location": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "unique_id": {"key": "identifier.uniqueId", "type": "str"},
        "os_type": {"key": "properties.osType", "type": "str"},
        "os_state": {"key": "properties.osState", "type": "str"},
        "end_of_life_date": {"key": "properties.endOfLifeDate", "type": "iso-8601"},
        "identifier": {"key": "properties.identifier", "type": "GalleryImageIdentifier"},
        "recommended": {"key": "properties.recommended", "type": "RecommendedMachineConfiguration"},
        "disallowed": {"key": "properties.disallowed", "type": "Disallowed"},
        "hyper_v_generation": {"key": "properties.hyperVGeneration", "type": "str"},
        "features": {"key": "properties.features", "type": "[GalleryImageFeature]"},
        "purchase_plan": {"key": "properties.purchasePlan", "type": "ImagePurchasePlan"},
        "architecture": {"key": "properties.architecture", "type": "str"},
        "privacy_statement_uri": {"key": "properties.privacyStatementUri", "type": "str"},
        "eula": {"key": "properties.eula", "type": "str"},
    }

    def __init__(
        self,
        *,
        unique_id: Optional[str] = None,
        os_type: Optional[Union[str, "_models.OperatingSystemTypes"]] = None,
        os_state: Optional[Union[str, "_models.OperatingSystemStateTypes"]] = None,
        end_of_life_date: Optional[datetime.datetime] = None,
        identifier: Optional["_models.GalleryImageIdentifier"] = None,
        recommended: Optional["_models.RecommendedMachineConfiguration"] = None,
        disallowed: Optional["_models.Disallowed"] = None,
        hyper_v_generation: Optional[Union[str, "_models.HyperVGeneration"]] = None,
        features: Optional[List["_models.GalleryImageFeature"]] = None,
        purchase_plan: Optional["_models.ImagePurchasePlan"] = None,
        architecture: Optional[Union[str, "_models.Architecture"]] = None,
        privacy_statement_uri: Optional[str] = None,
        eula: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword unique_id: The unique id of this shared gallery.
        :paramtype unique_id: str
        :keyword os_type: This property allows you to specify the type of the OS that is included in
         the disk when creating a VM from a managed image. :code:`<br>`:code:`<br>` Possible values are:
         :code:`<br>`:code:`<br>` **Windows** :code:`<br>`:code:`<br>` **Linux**. Known values are:
         "Windows" and "Linux".
        :paramtype os_type: str or ~azure.mgmt.compute.v2022_03_03.models.OperatingSystemTypes
        :keyword os_state: This property allows the user to specify whether the virtual machines
         created under this image are 'Generalized' or 'Specialized'. Known values are: "Generalized"
         and "Specialized".
        :paramtype os_state: str or ~azure.mgmt.compute.v2022_03_03.models.OperatingSystemStateTypes
        :keyword end_of_life_date: The end of life date of the gallery image definition. This property
         can be used for decommissioning purposes. This property is updatable.
        :paramtype end_of_life_date: ~datetime.datetime
        :keyword identifier: This is the gallery image definition identifier.
        :paramtype identifier: ~azure.mgmt.compute.v2022_03_03.models.GalleryImageIdentifier
        :keyword recommended: The properties describe the recommended machine configuration for this
         Image Definition. These properties are updatable.
        :paramtype recommended: ~azure.mgmt.compute.v2022_03_03.models.RecommendedMachineConfiguration
        :keyword disallowed: Describes the disallowed disk types.
        :paramtype disallowed: ~azure.mgmt.compute.v2022_03_03.models.Disallowed
        :keyword hyper_v_generation: The hypervisor generation of the Virtual Machine. Applicable to OS
         disks only. Known values are: "V1" and "V2".
        :paramtype hyper_v_generation: str or ~azure.mgmt.compute.v2022_03_03.models.HyperVGeneration
        :keyword features: A list of gallery image features.
        :paramtype features: list[~azure.mgmt.compute.v2022_03_03.models.GalleryImageFeature]
        :keyword purchase_plan: Describes the gallery image definition purchase plan. This is used by
         marketplace images.
        :paramtype purchase_plan: ~azure.mgmt.compute.v2022_03_03.models.ImagePurchasePlan
        :keyword architecture: The architecture of the image. Applicable to OS disks only. Known values
         are: "x64" and "Arm64".
        :paramtype architecture: str or ~azure.mgmt.compute.v2022_03_03.models.Architecture
        :keyword privacy_statement_uri: Privacy statement uri for the current community gallery image.
        :paramtype privacy_statement_uri: str
        :keyword eula: End-user license agreement for the current community gallery image.
        :paramtype eula: str
        """
        super().__init__(unique_id=unique_id, **kwargs)
        self.os_type = os_type
        self.os_state = os_state
        self.end_of_life_date = end_of_life_date
        self.identifier = identifier
        self.recommended = recommended
        self.disallowed = disallowed
        self.hyper_v_generation = hyper_v_generation
        self.features = features
        self.purchase_plan = purchase_plan
        self.architecture = architecture
        self.privacy_statement_uri = privacy_statement_uri
        self.eula = eula


class SharedGalleryImageList(_serialization.Model):
    """The List Shared Gallery Images operation response.

    All required parameters must be populated in order to send to Azure.

    :ivar value: A list of shared gallery images. Required.
    :vartype value: list[~azure.mgmt.compute.v2022_03_03.models.SharedGalleryImage]
    :ivar next_link: The uri to fetch the next page of shared gallery images. Call ListNext() with
     this to fetch the next page of shared gallery images.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[SharedGalleryImage]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: List["_models.SharedGalleryImage"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: A list of shared gallery images. Required.
        :paramtype value: list[~azure.mgmt.compute.v2022_03_03.models.SharedGalleryImage]
        :keyword next_link: The uri to fetch the next page of shared gallery images. Call ListNext()
         with this to fetch the next page of shared gallery images.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class SharedGalleryImageVersion(PirSharedGalleryResource):
    """Specifies information about the gallery image version that you want to create or update.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Resource name.
    :vartype name: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar unique_id: The unique id of this shared gallery.
    :vartype unique_id: str
    :ivar published_date: The published date of the gallery image version Definition. This property
     can be used for decommissioning purposes. This property is updatable.
    :vartype published_date: ~datetime.datetime
    :ivar end_of_life_date: The end of life date of the gallery image version Definition. This
     property can be used for decommissioning purposes. This property is updatable.
    :vartype end_of_life_date: ~datetime.datetime
    :ivar exclude_from_latest: If set to true, Virtual Machines deployed from the latest version of
     the Image Definition won't use this Image Version.
    :vartype exclude_from_latest: bool
    :ivar storage_profile: Describes the storage profile of the image version.
    :vartype storage_profile:
     ~azure.mgmt.compute.v2022_03_03.models.SharedGalleryImageVersionStorageProfile
    """

    _validation = {
        "name": {"readonly": True},
        "location": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "unique_id": {"key": "identifier.uniqueId", "type": "str"},
        "published_date": {"key": "properties.publishedDate", "type": "iso-8601"},
        "end_of_life_date": {"key": "properties.endOfLifeDate", "type": "iso-8601"},
        "exclude_from_latest": {"key": "properties.excludeFromLatest", "type": "bool"},
        "storage_profile": {"key": "properties.storageProfile", "type": "SharedGalleryImageVersionStorageProfile"},
    }

    def __init__(
        self,
        *,
        unique_id: Optional[str] = None,
        published_date: Optional[datetime.datetime] = None,
        end_of_life_date: Optional[datetime.datetime] = None,
        exclude_from_latest: Optional[bool] = None,
        storage_profile: Optional["_models.SharedGalleryImageVersionStorageProfile"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword unique_id: The unique id of this shared gallery.
        :paramtype unique_id: str
        :keyword published_date: The published date of the gallery image version Definition. This
         property can be used for decommissioning purposes. This property is updatable.
        :paramtype published_date: ~datetime.datetime
        :keyword end_of_life_date: The end of life date of the gallery image version Definition. This
         property can be used for decommissioning purposes. This property is updatable.
        :paramtype end_of_life_date: ~datetime.datetime
        :keyword exclude_from_latest: If set to true, Virtual Machines deployed from the latest version
         of the Image Definition won't use this Image Version.
        :paramtype exclude_from_latest: bool
        :keyword storage_profile: Describes the storage profile of the image version.
        :paramtype storage_profile:
         ~azure.mgmt.compute.v2022_03_03.models.SharedGalleryImageVersionStorageProfile
        """
        super().__init__(unique_id=unique_id, **kwargs)
        self.published_date = published_date
        self.end_of_life_date = end_of_life_date
        self.exclude_from_latest = exclude_from_latest
        self.storage_profile = storage_profile


class SharedGalleryImageVersionList(_serialization.Model):
    """The List Shared Gallery Image versions operation response.

    All required parameters must be populated in order to send to Azure.

    :ivar value: A list of shared gallery images versions. Required.
    :vartype value: list[~azure.mgmt.compute.v2022_03_03.models.SharedGalleryImageVersion]
    :ivar next_link: The uri to fetch the next page of shared gallery image versions. Call
     ListNext() with this to fetch the next page of shared gallery image versions.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[SharedGalleryImageVersion]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: List["_models.SharedGalleryImageVersion"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: A list of shared gallery images versions. Required.
        :paramtype value: list[~azure.mgmt.compute.v2022_03_03.models.SharedGalleryImageVersion]
        :keyword next_link: The uri to fetch the next page of shared gallery image versions. Call
         ListNext() with this to fetch the next page of shared gallery image versions.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class SharedGalleryImageVersionStorageProfile(_serialization.Model):
    """This is the storage profile of a Gallery Image Version.

    :ivar os_disk_image: This is the OS disk image.
    :vartype os_disk_image: ~azure.mgmt.compute.v2022_03_03.models.SharedGalleryOSDiskImage
    :ivar data_disk_images: A list of data disk images.
    :vartype data_disk_images:
     list[~azure.mgmt.compute.v2022_03_03.models.SharedGalleryDataDiskImage]
    """

    _attribute_map = {
        "os_disk_image": {"key": "osDiskImage", "type": "SharedGalleryOSDiskImage"},
        "data_disk_images": {"key": "dataDiskImages", "type": "[SharedGalleryDataDiskImage]"},
    }

    def __init__(
        self,
        *,
        os_disk_image: Optional["_models.SharedGalleryOSDiskImage"] = None,
        data_disk_images: Optional[List["_models.SharedGalleryDataDiskImage"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword os_disk_image: This is the OS disk image.
        :paramtype os_disk_image: ~azure.mgmt.compute.v2022_03_03.models.SharedGalleryOSDiskImage
        :keyword data_disk_images: A list of data disk images.
        :paramtype data_disk_images:
         list[~azure.mgmt.compute.v2022_03_03.models.SharedGalleryDataDiskImage]
        """
        super().__init__(**kwargs)
        self.os_disk_image = os_disk_image
        self.data_disk_images = data_disk_images


class SharedGalleryList(_serialization.Model):
    """The List Shared Galleries operation response.

    All required parameters must be populated in order to send to Azure.

    :ivar value: A list of shared galleries. Required.
    :vartype value: list[~azure.mgmt.compute.v2022_03_03.models.SharedGallery]
    :ivar next_link: The uri to fetch the next page of shared galleries. Call ListNext() with this
     to fetch the next page of shared galleries.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[SharedGallery]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.SharedGallery"], next_link: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword value: A list of shared galleries. Required.
        :paramtype value: list[~azure.mgmt.compute.v2022_03_03.models.SharedGallery]
        :keyword next_link: The uri to fetch the next page of shared galleries. Call ListNext() with
         this to fetch the next page of shared galleries.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class SharedGalleryOSDiskImage(SharedGalleryDiskImage):
    """This is the OS disk image.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar disk_size_gb: This property indicates the size of the VHD to be created.
    :vartype disk_size_gb: int
    :ivar host_caching: The host caching of the disk. Valid values are 'None', 'ReadOnly', and
     'ReadWrite'. Known values are: "None", "ReadOnly", and "ReadWrite".
    :vartype host_caching: str or ~azure.mgmt.compute.v2022_03_03.models.SharedGalleryHostCaching
    """

    _validation = {
        "disk_size_gb": {"readonly": True},
    }

    _attribute_map = {
        "disk_size_gb": {"key": "diskSizeGB", "type": "int"},
        "host_caching": {"key": "hostCaching", "type": "str"},
    }

    def __init__(
        self, *, host_caching: Optional[Union[str, "_models.SharedGalleryHostCaching"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword host_caching: The host caching of the disk. Valid values are 'None', 'ReadOnly', and
         'ReadWrite'. Known values are: "None", "ReadOnly", and "ReadWrite".
        :paramtype host_caching: str or ~azure.mgmt.compute.v2022_03_03.models.SharedGalleryHostCaching
        """
        super().__init__(host_caching=host_caching, **kwargs)


class SharingProfile(_serialization.Model):
    """Profile for gallery sharing to subscription or tenant.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar permissions: This property allows you to specify the permission of sharing gallery.
     :code:`<br>`:code:`<br>` Possible values are: :code:`<br>`:code:`<br>` **Private**
     :code:`<br>`:code:`<br>` **Groups** :code:`<br>`:code:`<br>` **Community**. Known values are:
     "Private", "Groups", and "Community".
    :vartype permissions: str or
     ~azure.mgmt.compute.v2022_03_03.models.GallerySharingPermissionTypes
    :ivar groups: A list of sharing profile groups.
    :vartype groups: list[~azure.mgmt.compute.v2022_03_03.models.SharingProfileGroup]
    :ivar community_gallery_info: Information of community gallery if current gallery is shared to
     community.
    :vartype community_gallery_info: ~azure.mgmt.compute.v2022_03_03.models.CommunityGalleryInfo
    """

    _validation = {
        "groups": {"readonly": True},
    }

    _attribute_map = {
        "permissions": {"key": "permissions", "type": "str"},
        "groups": {"key": "groups", "type": "[SharingProfileGroup]"},
        "community_gallery_info": {"key": "communityGalleryInfo", "type": "CommunityGalleryInfo"},
    }

    def __init__(
        self,
        *,
        permissions: Optional[Union[str, "_models.GallerySharingPermissionTypes"]] = None,
        community_gallery_info: Optional["_models.CommunityGalleryInfo"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword permissions: This property allows you to specify the permission of sharing gallery.
         :code:`<br>`:code:`<br>` Possible values are: :code:`<br>`:code:`<br>` **Private**
         :code:`<br>`:code:`<br>` **Groups** :code:`<br>`:code:`<br>` **Community**. Known values are:
         "Private", "Groups", and "Community".
        :paramtype permissions: str or
         ~azure.mgmt.compute.v2022_03_03.models.GallerySharingPermissionTypes
        :keyword community_gallery_info: Information of community gallery if current gallery is shared
         to community.
        :paramtype community_gallery_info: ~azure.mgmt.compute.v2022_03_03.models.CommunityGalleryInfo
        """
        super().__init__(**kwargs)
        self.permissions = permissions
        self.groups = None
        self.community_gallery_info = community_gallery_info


class SharingProfileGroup(_serialization.Model):
    """Group of the gallery sharing profile.

    :ivar type: This property allows you to specify the type of sharing group.
     :code:`<br>`:code:`<br>` Possible values are: :code:`<br>`:code:`<br>` **Subscriptions**
     :code:`<br>`:code:`<br>` **AADTenants**. Known values are: "Subscriptions" and "AADTenants".
    :vartype type: str or ~azure.mgmt.compute.v2022_03_03.models.SharingProfileGroupTypes
    :ivar ids: A list of subscription/tenant ids the gallery is aimed to be shared to.
    :vartype ids: list[str]
    """

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "ids": {"key": "ids", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "_models.SharingProfileGroupTypes"]] = None,
        ids: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword type: This property allows you to specify the type of sharing group.
         :code:`<br>`:code:`<br>` Possible values are: :code:`<br>`:code:`<br>` **Subscriptions**
         :code:`<br>`:code:`<br>` **AADTenants**. Known values are: "Subscriptions" and "AADTenants".
        :paramtype type: str or ~azure.mgmt.compute.v2022_03_03.models.SharingProfileGroupTypes
        :keyword ids: A list of subscription/tenant ids the gallery is aimed to be shared to.
        :paramtype ids: list[str]
        """
        super().__init__(**kwargs)
        self.type = type
        self.ids = ids


class SharingStatus(_serialization.Model):
    """Sharing status of current gallery.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar aggregated_state: Aggregated sharing state of current gallery. Known values are:
     "Succeeded", "InProgress", "Failed", and "Unknown".
    :vartype aggregated_state: str or ~azure.mgmt.compute.v2022_03_03.models.SharingState
    :ivar summary: Summary of all regional sharing status.
    :vartype summary: list[~azure.mgmt.compute.v2022_03_03.models.RegionalSharingStatus]
    """

    _validation = {
        "aggregated_state": {"readonly": True},
    }

    _attribute_map = {
        "aggregated_state": {"key": "aggregatedState", "type": "str"},
        "summary": {"key": "summary", "type": "[RegionalSharingStatus]"},
    }

    def __init__(self, *, summary: Optional[List["_models.RegionalSharingStatus"]] = None, **kwargs: Any) -> None:
        """
        :keyword summary: Summary of all regional sharing status.
        :paramtype summary: list[~azure.mgmt.compute.v2022_03_03.models.RegionalSharingStatus]
        """
        super().__init__(**kwargs)
        self.aggregated_state = None
        self.summary = summary


class SharingUpdate(_serialization.Model):
    """Specifies information about the gallery sharing profile update.

    All required parameters must be populated in order to send to Azure.

    :ivar operation_type: This property allows you to specify the operation type of gallery sharing
     update. :code:`<br>`:code:`<br>` Possible values are: :code:`<br>`:code:`<br>` **Add**
     :code:`<br>`:code:`<br>` **Remove** :code:`<br>`:code:`<br>` **Reset**. Required. Known values
     are: "Add", "Remove", "Reset", and "EnableCommunity".
    :vartype operation_type: str or
     ~azure.mgmt.compute.v2022_03_03.models.SharingUpdateOperationTypes
    :ivar groups: A list of sharing profile groups.
    :vartype groups: list[~azure.mgmt.compute.v2022_03_03.models.SharingProfileGroup]
    """

    _validation = {
        "operation_type": {"required": True},
    }

    _attribute_map = {
        "operation_type": {"key": "operationType", "type": "str"},
        "groups": {"key": "groups", "type": "[SharingProfileGroup]"},
    }

    def __init__(
        self,
        *,
        operation_type: Union[str, "_models.SharingUpdateOperationTypes"],
        groups: Optional[List["_models.SharingProfileGroup"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword operation_type: This property allows you to specify the operation type of gallery
         sharing update. :code:`<br>`:code:`<br>` Possible values are: :code:`<br>`:code:`<br>` **Add**
         :code:`<br>`:code:`<br>` **Remove** :code:`<br>`:code:`<br>` **Reset**. Required. Known values
         are: "Add", "Remove", "Reset", and "EnableCommunity".
        :paramtype operation_type: str or
         ~azure.mgmt.compute.v2022_03_03.models.SharingUpdateOperationTypes
        :keyword groups: A list of sharing profile groups.
        :paramtype groups: list[~azure.mgmt.compute.v2022_03_03.models.SharingProfileGroup]
        """
        super().__init__(**kwargs)
        self.operation_type = operation_type
        self.groups = groups


class SoftDeletePolicy(_serialization.Model):
    """Contains information about the soft deletion policy of the gallery.

    :ivar is_soft_delete_enabled: Enables soft-deletion for resources in this gallery, allowing
     them to be recovered within retention time.
    :vartype is_soft_delete_enabled: bool
    """

    _attribute_map = {
        "is_soft_delete_enabled": {"key": "isSoftDeleteEnabled", "type": "bool"},
    }

    def __init__(self, *, is_soft_delete_enabled: Optional[bool] = None, **kwargs: Any) -> None:
        """
        :keyword is_soft_delete_enabled: Enables soft-deletion for resources in this gallery, allowing
         them to be recovered within retention time.
        :paramtype is_soft_delete_enabled: bool
        """
        super().__init__(**kwargs)
        self.is_soft_delete_enabled = is_soft_delete_enabled


class SubResource(_serialization.Model):
    """SubResource.

    :ivar id: Resource Id.
    :vartype id: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, *, id: Optional[str] = None, **kwargs: Any) -> None:  # pylint: disable=redefined-builtin
        """
        :keyword id: Resource Id.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id


class SubResourceReadOnly(_serialization.Model):
    """SubResourceReadOnly.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    """

    _validation = {
        "id": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id = None


class SystemData(_serialization.Model):
    """The system meta data relating to this resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar created_at: Specifies the time in UTC at which the Cloud Service (extended support)
     resource was created. :code:`<br />`Minimum api-version: 2022-04-04.
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_at: Specifies the time in UTC at which the Cloud Service (extended support)
     resource was last modified. :code:`<br />`Minimum api-version: 2022-04-04.
    :vartype last_modified_at: ~datetime.datetime
    """

    _validation = {
        "created_at": {"readonly": True},
        "last_modified_at": {"readonly": True},
    }

    _attribute_map = {
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.created_at = None
        self.last_modified_at = None


class TargetRegion(_serialization.Model):
    """Describes the target region information.

    All required parameters must be populated in order to send to Azure.

    :ivar name: The name of the region. Required.
    :vartype name: str
    :ivar regional_replica_count: The number of replicas of the Image Version to be created per
     region. This property is updatable.
    :vartype regional_replica_count: int
    :ivar storage_account_type: Specifies the storage account type to be used to store the image.
     This property is not updatable. Known values are: "Standard_LRS", "Standard_ZRS", and
     "Premium_LRS".
    :vartype storage_account_type: str or ~azure.mgmt.compute.v2022_03_03.models.StorageAccountType
    :ivar encryption: Optional. Allows users to provide customer managed keys for encrypting the OS
     and data disks in the gallery artifact.
    :vartype encryption: ~azure.mgmt.compute.v2022_03_03.models.EncryptionImages
    :ivar exclude_from_latest: Contains the flag setting to hide an image when users specify
     version='latest'.
    :vartype exclude_from_latest: bool
    """

    _validation = {
        "name": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "regional_replica_count": {"key": "regionalReplicaCount", "type": "int"},
        "storage_account_type": {"key": "storageAccountType", "type": "str"},
        "encryption": {"key": "encryption", "type": "EncryptionImages"},
        "exclude_from_latest": {"key": "excludeFromLatest", "type": "bool"},
    }

    def __init__(
        self,
        *,
        name: str,
        regional_replica_count: Optional[int] = None,
        storage_account_type: Optional[Union[str, "_models.StorageAccountType"]] = None,
        encryption: Optional["_models.EncryptionImages"] = None,
        exclude_from_latest: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The name of the region. Required.
        :paramtype name: str
        :keyword regional_replica_count: The number of replicas of the Image Version to be created per
         region. This property is updatable.
        :paramtype regional_replica_count: int
        :keyword storage_account_type: Specifies the storage account type to be used to store the
         image. This property is not updatable. Known values are: "Standard_LRS", "Standard_ZRS", and
         "Premium_LRS".
        :paramtype storage_account_type: str or
         ~azure.mgmt.compute.v2022_03_03.models.StorageAccountType
        :keyword encryption: Optional. Allows users to provide customer managed keys for encrypting the
         OS and data disks in the gallery artifact.
        :paramtype encryption: ~azure.mgmt.compute.v2022_03_03.models.EncryptionImages
        :keyword exclude_from_latest: Contains the flag setting to hide an image when users specify
         version='latest'.
        :paramtype exclude_from_latest: bool
        """
        super().__init__(**kwargs)
        self.name = name
        self.regional_replica_count = regional_replica_count
        self.storage_account_type = storage_account_type
        self.encryption = encryption
        self.exclude_from_latest = exclude_from_latest


class UserArtifactManage(_serialization.Model):
    """UserArtifactManage.

    All required parameters must be populated in order to send to Azure.

    :ivar install: Required. The path and arguments to install the gallery application. This is
     limited to 4096 characters. Required.
    :vartype install: str
    :ivar remove: Required. The path and arguments to remove the gallery application. This is
     limited to 4096 characters. Required.
    :vartype remove: str
    :ivar update: Optional. The path and arguments to update the gallery application. If not
     present, then update operation will invoke remove command on the previous version and install
     command on the current version of the gallery application. This is limited to 4096 characters.
    :vartype update: str
    """

    _validation = {
        "install": {"required": True},
        "remove": {"required": True},
    }

    _attribute_map = {
        "install": {"key": "install", "type": "str"},
        "remove": {"key": "remove", "type": "str"},
        "update": {"key": "update", "type": "str"},
    }

    def __init__(self, *, install: str, remove: str, update: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword install: Required. The path and arguments to install the gallery application. This is
         limited to 4096 characters. Required.
        :paramtype install: str
        :keyword remove: Required. The path and arguments to remove the gallery application. This is
         limited to 4096 characters. Required.
        :paramtype remove: str
        :keyword update: Optional. The path and arguments to update the gallery application. If not
         present, then update operation will invoke remove command on the previous version and install
         command on the current version of the gallery application. This is limited to 4096 characters.
        :paramtype update: str
        """
        super().__init__(**kwargs)
        self.install = install
        self.remove = remove
        self.update = update


class UserArtifactSettings(_serialization.Model):
    """Additional settings for the VM app that contains the target package and config file name when
    it is deployed to target VM or VM scale set.

    :ivar package_file_name: Optional. The name to assign the downloaded package file on the VM.
     This is limited to 4096 characters. If not specified, the package file will be named the same
     as the Gallery Application name.
    :vartype package_file_name: str
    :ivar config_file_name: Optional. The name to assign the downloaded config file on the VM. This
     is limited to 4096 characters. If not specified, the config file will be named the Gallery
     Application name appended with "_config".
    :vartype config_file_name: str
    """

    _attribute_map = {
        "package_file_name": {"key": "packageFileName", "type": "str"},
        "config_file_name": {"key": "configFileName", "type": "str"},
    }

    def __init__(
        self, *, package_file_name: Optional[str] = None, config_file_name: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword package_file_name: Optional. The name to assign the downloaded package file on the VM.
         This is limited to 4096 characters. If not specified, the package file will be named the same
         as the Gallery Application name.
        :paramtype package_file_name: str
        :keyword config_file_name: Optional. The name to assign the downloaded config file on the VM.
         This is limited to 4096 characters. If not specified, the config file will be named the Gallery
         Application name appended with "_config".
        :paramtype config_file_name: str
        """
        super().__init__(**kwargs)
        self.package_file_name = package_file_name
        self.config_file_name = config_file_name


class UserArtifactSource(_serialization.Model):
    """The source image from which the Image Version is going to be created.

    All required parameters must be populated in order to send to Azure.

    :ivar media_link: Required. The mediaLink of the artifact, must be a readable storage page
     blob. Required.
    :vartype media_link: str
    :ivar default_configuration_link: Optional. The defaultConfigurationLink of the artifact, must
     be a readable storage page blob.
    :vartype default_configuration_link: str
    """

    _validation = {
        "media_link": {"required": True},
    }

    _attribute_map = {
        "media_link": {"key": "mediaLink", "type": "str"},
        "default_configuration_link": {"key": "defaultConfigurationLink", "type": "str"},
    }

    def __init__(self, *, media_link: str, default_configuration_link: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword media_link: Required. The mediaLink of the artifact, must be a readable storage page
         blob. Required.
        :paramtype media_link: str
        :keyword default_configuration_link: Optional. The defaultConfigurationLink of the artifact,
         must be a readable storage page blob.
        :paramtype default_configuration_link: str
        """
        super().__init__(**kwargs)
        self.media_link = media_link
        self.default_configuration_link = default_configuration_link


class UserAssignedIdentitiesValue(_serialization.Model):
    """UserAssignedIdentitiesValue.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal id of user assigned identity.
    :vartype principal_id: str
    :ivar client_id: The client id of user assigned identity.
    :vartype client_id: str
    """

    _validation = {
        "principal_id": {"readonly": True},
        "client_id": {"readonly": True},
    }

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "client_id": {"key": "clientId", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.principal_id = None
        self.client_id = None
