#!/usr/bin/env python
# -*- coding: utf-8 -*-

import json
from pathlib import Path

###############################################################################

ANNOTATIONS_DIR = Path(__file__).parent / "annotations"
NAME_MAPPINGS = {
    "Teresa Mosqueda": "Mosqueda",
    "Lorena Gonzalez": "Gonzalez",
    "Debora Juarez": "Juarez",
    "Lisa Herbold": "Herbold",
    "Dan Strauss": "Strauss",
    "Alex Pedersen": "Pedersen",
    "Pederson": "Pedersen",
    "Tammy Morales": "Morales",
}

###############################################################################

for annotation_file in ANNOTATIONS_DIR.glob("*.json"):
    # Open new annotation file
    with open(annotation_file, "r") as open_f:
        annotations = json.load(open_f)

    # Iter through each "monologue" section and update the speaker id
    update_counts = {}
    for monologue in annotations["monologues"]:
        speaker = monologue["speaker"]["id"]
        # See if needs updating
        if speaker in NAME_MAPPINGS:
            # Make the update
            monologue["speaker"]["id"] = NAME_MAPPINGS[speaker]

            # Log update
            if speaker not in update_counts:
                update_counts[speaker] = 1
            else:
                update_counts[speaker] += 1

    # Write back out the file
    with open(annotation_file, "w") as open_f:
        json.dump(annotations, open_f)

    if len(update_counts) > 0:
        print(f"Updated file: {annotation_file}")
        for speaker, count in update_counts.items():
            print(
                f"\t'{speaker}' was updated to '{NAME_MAPPINGS[speaker]}' "
                f"{count} time(s)."
            )
