/*  SWIG interface code generated by apiwrapper for GAMS Version 33.2.0
 *
 * GAMS - Loading mechanism for GAMS Expert-Level APIs
 *
 * Copyright (c) 2016-2020 GAMS Software GmbH <support@gams.com>
 * Copyright (c) 2016-2020 GAMS Development Corp. <support@gams.com>
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
%module(moduleimport="import $module") gdxcc
%include cpointer.i
%include typemaps.i
%include carrays.i
%include cstring.i

%{
/* Put header files here or function declarations like below */
#define SWIG_FILE_WITH_INIT
#include "gdxcc.h"
#include "gclgms.h"
#define gdxHandleToPtr
#define ptrTogdxHandle
%}

%apply long long { INT64 };
%apply const long long& { const INT64& };

// This tells SWIG to treat char ** as a special case
// but this is only save for input-values
%typemap(in) char *UelFilterStr_in[](PyObject* stringList){
  /* Check if is a list */
  if (PyList_Check($input)) {
    int i = 0;
    int listSize = PyList_Size($input);
    $1 = (char **) malloc((listSize+1)*sizeof(char *));
%#if PY_MAJOR_VERSION > 2
    stringList = PyList_New(listSize);
%#endif
    for (i = 0; i < listSize; i++) {
      PyObject *o = PyList_GetItem($input,i);
%#if PY_MAJOR_VERSION > 2
      if (PyUnicode_Check(o)) {
        o = PyUnicode_AsUTF8String(o);
        PyList_SetItem(stringList,  i, o);
        $1[i] = PyString_AsString(o);
      }
%#else
      if (PyString_Check(o))
        $1[i] = PyString_AsString(o);
%#endif
      else {
        PyErr_SetString(PyExc_TypeError,"list must contain strings");
        free($1);
        return NULL;
      }
    }
    $1[i] = 0;
  } else {
    PyErr_SetString(PyExc_TypeError,"not a list");
    return NULL;
  }
}

%typemap(freearg) char *UelFilterStr_in[]{
%#if PY_MAJOR_VERSION > 2
  Py_DECREF(stringList$argnum);
%#endif
  free((char **) $1);
}

%typemap(in) char *KeyStr_in[](PyObject* stringList){
  /* Check if is a list */
  if (PyList_Check($input)) {
    int i = 0;
    int listSize = PyList_Size($input);
    $1 = (char **) malloc((listSize+1)*sizeof(char *));
%#if PY_MAJOR_VERSION > 2
    stringList = PyList_New(listSize);
%#endif
    for (i = 0; i < listSize; i++) {
      PyObject *o = PyList_GetItem($input,i);
%#if PY_MAJOR_VERSION > 2
      if (PyUnicode_Check(o)) {
        o = PyUnicode_AsUTF8String(o);
        PyList_SetItem(stringList,  i, o);
        $1[i] = PyString_AsString(o);
      }
%#else
      if (PyString_Check(o))
        $1[i] = PyString_AsString(o);
%#endif
      else {
        PyErr_SetString(PyExc_TypeError,"list must contain strings");
        free($1);
        return NULL;
      }
    }
    $1[i] = 0;
  } else {
    PyErr_SetString(PyExc_TypeError,"not a list");
    return NULL;
  }
}

%typemap(freearg) char *KeyStr_in[]{
%#if PY_MAJOR_VERSION > 2
  Py_DECREF(stringList$argnum);
%#endif
  free((char **) $1);
}

%typemap(in) char *DomainIDs_in[](PyObject* stringList){
  /* Check if is a list */
  if (PyList_Check($input)) {
    int i = 0;
    int listSize = PyList_Size($input);
    $1 = (char **) malloc((listSize+1)*sizeof(char *));
%#if PY_MAJOR_VERSION > 2
    stringList = PyList_New(listSize);
%#endif
    for (i = 0; i < listSize; i++) {
      PyObject *o = PyList_GetItem($input,i);
%#if PY_MAJOR_VERSION > 2
      if (PyUnicode_Check(o)) {
        o = PyUnicode_AsUTF8String(o);
        PyList_SetItem(stringList,  i, o);
        $1[i] = PyString_AsString(o);
      }
%#else
      if (PyString_Check(o))
        $1[i] = PyString_AsString(o);
%#endif
      else {
        PyErr_SetString(PyExc_TypeError,"list must contain strings");
        free($1);
        return NULL;
      }
    }
    $1[i] = 0;
  } else {
    PyErr_SetString(PyExc_TypeError,"not a list");
    return NULL;
  }
}

%typemap(freearg) char *DomainIDs_in[]{
%#if PY_MAJOR_VERSION > 2
  Py_DECREF(stringList$argnum);
%#endif
  free((char **) $1);
}

// special treatment for out int arrays
%typemap(in, numinputs=0) int KeyInt_out[]{
  static gdxUelIndex_t KeyInt;
  $1 = KeyInt;
}

%typemap(argout) int KeyInt_out[]{
    int loc_i = 0;
    PyObject *list;
    int loc_dim = gdxCurrentDim(arg1);
    list = PyList_New(loc_dim);
    for(loc_i=0; loc_i<loc_dim; loc_i++){
      PyList_SetItem(list, loc_i, PyInt_FromLong($1[loc_i]));
    }
    $result = SWIG_Python_AppendOutput($result, list);
}

%typemap(in, numinputs=0) int ElemCounts_out[]{
  static gdxUelIndex_t ElemCounts;
  $1 = ElemCounts;
}

%typemap(argout) int ElemCounts_out[]{
    int loc_i = 0;
    PyObject *list;
    int loc_dim = gdxCurrentDim(arg1);
    list = PyList_New(loc_dim);
    for(loc_i=0; loc_i<loc_dim; loc_i++){
      PyList_SetItem(list, loc_i, PyInt_FromLong($1[loc_i]));
    }
    $result = SWIG_Python_AppendOutput($result, list);
}

%typemap(in, numinputs=0) int LengthInfo_out[]{
  static gdxUelIndex_t LengthInfo;
  $1 = LengthInfo;
}

%typemap(argout) int LengthInfo_out[]{
    int loc_i = 0;
    PyObject *list;
    int loc_dim = gdxCurrentDim(arg1);
    list = PyList_New(loc_dim);
    for(loc_i=0; loc_i<loc_dim; loc_i++){
      PyList_SetItem(list, loc_i, PyInt_FromLong($1[loc_i]));
    }
    $result = SWIG_Python_AppendOutput($result, list);
}

%typemap(in, numinputs=0) int DomainSyNrs_out[]{
  static gdxUelIndex_t DomainSyNrs;
  $1 = DomainSyNrs;
}

%typemap(argout) int DomainSyNrs_out[]{
    int loc_i = 0;
    PyObject *list;
    int loc_dim = gdxCurrentDim(arg1);
    list = PyList_New(loc_dim);
    for(loc_i=0; loc_i<loc_dim; loc_i++){
      PyList_SetItem(list, loc_i, PyInt_FromLong($1[loc_i]));
    }
    $result = SWIG_Python_AppendOutput($result, list);
}

// special treatment for out double arrays
%typemap(in, numinputs=0) double Values_out[]{
  static gdxValues_t Values;
  $1 = Values;
}

%typemap(argout) double Values_out[]{
    int loc_i = 0;
    PyObject *list = PyList_New(5);
    for(loc_i=0; loc_i<5; loc_i++){
      PyList_SetItem(list, loc_i, PyFloat_FromDouble($1[loc_i]));
    }
    $result = SWIG_Python_AppendOutput($result, list);
}

// special treatment for out string arrays
%typemap(in, numinputs=0) char *KeyStr_out[]{
  static gdxStrIndexPtrs_t KeyStr;
  static gdxStrIndex_t     KeyStrXXX;
  GDXSTRINDEXPTRS_INIT(KeyStrXXX, KeyStr);
  $1 = KeyStr;
}

%typemap(argout) char *KeyStr_out[]{
    int loc_i = 0;
    PyObject *list;
    int loc_dim = gdxCurrentDim(arg1);
    list = PyList_New(loc_dim);
    for(loc_i=0; loc_i<loc_dim; loc_i++){
      PyList_SetItem(list, loc_i, PyString_FromString($1[loc_i]));
    }
    $result = SWIG_Python_AppendOutput($result, list);
}

%typemap(in, numinputs=0) char *DomainIDs_out[]{
  static gdxStrIndexPtrs_t DomainIDs;
  static gdxStrIndex_t     DomainIDsXXX;
  GDXSTRINDEXPTRS_INIT(DomainIDsXXX, DomainIDs);
  $1 = DomainIDs;
}

%typemap(argout) char *DomainIDs_out[]{
    int loc_i = 0;
    PyObject *list;
    int loc_dim = gdxCurrentDim(arg1);
    list = PyList_New(loc_dim);
    for(loc_i=0; loc_i<loc_dim; loc_i++){
      PyList_SetItem(list, loc_i, PyString_FromString($1[loc_i]));
    }
    $result = SWIG_Python_AppendOutput($result, list);
}

%typemap(argout) (int SyNr, char *DomainIDs_out[]){
    int loc_i = 0;
    PyObject *list;
    int loc_dim = gdxSymbolDim(arg1, $1);
    list = PyList_New(loc_dim);
    for(loc_i=0; loc_i<loc_dim; loc_i++){
      PyList_SetItem(list, loc_i, PyString_FromString($2[loc_i]));
    }
    $result = SWIG_Python_AppendOutput($result, list);
}

%array_class(int, intArray);
%array_class(double, doubleArray);
%pointer_functions(int, intp);
%pointer_functions(double, doublep);
%pointer_functions(gdxHandle_t, gdxHandle_tp);

%typemap(in) void *{
    int res = SWIG_ConvertPtr($input,SWIG_as_voidptrptr(&$1), SWIGTYPE_p_void, 0);
    if (!SWIG_IsOK(res)) {
    SWIG_exception_fail(SWIG_ArgError(res), "in method '" "$symname" "', argument " " of type '" "void *""'");
  }
}

%typemap(in) void **{
    void *$1__p;
    int res = SWIG_ConvertPtr($input,SWIG_as_voidptrptr(&$1__p), SWIGTYPE_p_void, 0);
    if (!SWIG_IsOK(res)) {
    SWIG_exception_fail(SWIG_ArgError(res), "in method '" "$symname" "', argument " " of type '" "void *""'");
    }
    $1 = &$1__p;
}

%typemap(out) gdxHandle_t {
  resultobj = SWIG_NewPointerObj((gdxHandle_t *)memcpy((gdxHandle_t *)malloc(sizeof(gdxHandle_t)),&result,sizeof(gdxHandle_t)), SWIGTYPE_p_gdxHandle_t, 0 |  0 );
}

%typemap(in) TDataStoreProc_t{
    if ($input == Py_None)
      $1 = NULL;
    else
    {
      void *argp;
      int ret = SWIG_ConvertPtr($input, &argp, SWIGTYPE_p_TDataStoreProc_t,  0 );
      if (!SWIG_IsOK(ret)) {
        SWIG_exception_fail(SWIG_ArgError(ret), "in method '" "$symname" "', argument " " of type '" "TDataStoreProc_t""'");
      }
      if (!argp) {
        SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "$symname" "', argument of type '" "TDataStoreProc_t""'");
      } else {
        $1 = *((TDataStoreProc_t *)(argp));
      }
    }
}
%typemap(in) TDataStoreFiltProc_t{
    if ($input == Py_None)
      $1 = NULL;
    else
    {
      void *argp;
      int ret = SWIG_ConvertPtr($input, &argp, SWIGTYPE_p_TDataStoreFiltProc_t,  0 );
      if (!SWIG_IsOK(ret)) {
        SWIG_exception_fail(SWIG_ArgError(ret), "in method '" "$symname" "', argument " " of type '" "TDataStoreFiltProc_t""'");
      }
      if (!argp) {
        SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "$symname" "', argument of type '" "TDataStoreFiltProc_t""'");
      } else {
        $1 = *((TDataStoreFiltProc_t *)(argp));
      }
    }
}
%typemap(in) TDomainIndexProc_t{
    if ($input == Py_None)
      $1 = NULL;
    else
    {
      void *argp;
      int ret = SWIG_ConvertPtr($input, &argp, SWIGTYPE_p_TDomainIndexProc_t,  0 );
      if (!SWIG_IsOK(ret)) {
        SWIG_exception_fail(SWIG_ArgError(ret), "in method '" "$symname" "', argument " " of type '" "TDomainIndexProc_t""'");
      }
      if (!argp) {
        SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "$symname" "', argument of type '" "TDomainIndexProc_t""'");
      } else {
        $1 = *((TDomainIndexProc_t *)(argp));
      }
    }
}
%pointer_functions(TDataStoreProc_t, TDataStoreProc_tp);
%pointer_functions(TDataStoreFiltProc_t, TDataStoreFiltProc_tp);
%pointer_functions(TDomainIndexProc_t, TDomainIndexProc_tp);

%cstring_bounded_output(char *msgBuf_out, GMS_SSSIZE);
%cstring_bounded_output(char *AName_out, GMS_SSSIZE);
%cstring_bounded_output(char *Txt_out, GMS_SSSIZE);
%cstring_bounded_output(char *V_out, GMS_SSSIZE);
%cstring_bounded_output(char *SyId_out, GMS_SSSIZE);
%cstring_bounded_output(char *ExplTxt_out, GMS_SSSIZE);
%cstring_bounded_output(char *ErrMsg_out, GMS_SSSIZE);
%cstring_bounded_output(char *FileStr_out, GMS_SSSIZE);
%cstring_bounded_output(char *ProduceStr_out, GMS_SSSIZE);
%cstring_bounded_output(char *Uel_out, GMS_SSSIZE);

%feature("autodoc", "0");

extern void *gdxHandleToPtr (gdxHandle_t pgdx);
extern gdxHandle_t ptrTogdxHandle (void *vptr);
extern int gdxGetReady (char *msgBuf_out, int msgBufSize);
extern int gdxGetReadyD (const char *dirName, char *msgBuf_out, int msgBufSize);
extern int gdxGetReadyL (const char *libName, char *msgBuf_out, int msgBufSize);
extern int gdxCreate (gdxHandle_t *pgdx, char *msgBuf_out, int msgBufSize);
extern int gdxCreateD (gdxHandle_t *pgdx, const char *dirName, char *msgBuf_out, int msgBufSize);
extern int gdxCreateL (gdxHandle_t *pgdx, const char *libName, char *msgBuf_out, int msgBufSize);
extern int gdxFree (gdxHandle_t *pgdx);
extern int gdxLibraryLoaded(void);
extern int gdxLibraryUnload(void);
extern int gdxGetScreenIndicator(void);
extern void gdxSetScreenIndicator(int scrind);
extern int gdxGetExceptionIndicator(void);
extern void gdxSetExceptionIndicator(int excind);
extern int gdxGetExitIndicator(void);
extern void gdxSetExitIndicator(int extind);
extern gdxErrorCallback_t gdxGetErrorCallback(void);
extern void gdxSetErrorCallback(gdxErrorCallback_t func);
extern int gdxGetAPIErrorCount(void);
extern void gdxSetAPIErrorCount(int ecnt);
extern void gdxErrorHandling(const char *msg);
extern int  gdxAcronymAdd (gdxHandle_t pgdx, const char *AName, const char *Txt, int AIndx);
extern int  gdxAcronymCount (gdxHandle_t pgdx);
extern int  gdxAcronymGetInfo (gdxHandle_t pgdx, int N, char *AName_out, char *Txt_out, int *OUTPUT);
extern int  gdxAcronymGetMapping (gdxHandle_t pgdx, int N, int *OUTPUT, int *OUTPUT, int *OUTPUT);
extern int  gdxAcronymIndex (gdxHandle_t pgdx, double V);
extern int  gdxAcronymName (gdxHandle_t pgdx, double V, char *AName_out);
extern int  gdxAcronymNextNr (gdxHandle_t pgdx, int NV);
extern int  gdxAcronymSetInfo (gdxHandle_t pgdx, int N, const char *AName, const char *Txt, int AIndx);
extern double  gdxAcronymValue (gdxHandle_t pgdx, int AIndx);
extern int  gdxAddAlias (gdxHandle_t pgdx, const char *Id1, const char *Id2);
extern int  gdxAddSetText (gdxHandle_t pgdx, const char *Txt, int *OUTPUT);
extern int  gdxAutoConvert (gdxHandle_t pgdx, int NV);
extern int  gdxClose (gdxHandle_t pgdx);
extern int  gdxDataErrorCount (gdxHandle_t pgdx);
extern int  gdxDataErrorRecord (gdxHandle_t pgdx, int RecNr, int KeyInt_out[], double Values_out[]);
extern int  gdxDataErrorRecordX (gdxHandle_t pgdx, int RecNr, int KeyInt_out[], double Values_out[]);
extern int  gdxDataReadDone (gdxHandle_t pgdx);
extern int  gdxDataReadFilteredStart (gdxHandle_t pgdx, int SyNr, const int FilterAction[], int *OUTPUT);
extern int  gdxDataReadMap (gdxHandle_t pgdx, int RecNr, int KeyInt_out[], double Values_out[], int *OUTPUT);
extern int  gdxDataReadMapStart (gdxHandle_t pgdx, int SyNr, int *OUTPUT);
extern int  gdxDataReadRaw (gdxHandle_t pgdx, int KeyInt_out[], double Values_out[], int *OUTPUT);
extern int  gdxDataReadRawFast (gdxHandle_t pgdx, int SyNr, TDataStoreProc_t DP, int *OUTPUT);
extern int  gdxDataReadRawFastFilt (gdxHandle_t pgdx, int SyNr, const char *UelFilterStr_in[], TDataStoreFiltProc_t DP);
extern int  gdxDataReadRawStart (gdxHandle_t pgdx, int SyNr, int *OUTPUT);
extern int  gdxDataReadSlice (gdxHandle_t pgdx, const char *UelFilterStr_in[], int *OUTPUT, TDataStoreProc_t DP);
extern int  gdxDataReadSliceStart (gdxHandle_t pgdx, int SyNr, int ElemCounts_out[]);
extern int  gdxDataReadStr (gdxHandle_t pgdx, char *KeyStr_out[], double Values_out[], int *OUTPUT);
extern int  gdxDataReadStrStart (gdxHandle_t pgdx, int SyNr, int *OUTPUT);
extern int  gdxDataSliceUELS (gdxHandle_t pgdx, const int SliceKeyInt[], char *KeyStr_out[]);
extern int  gdxDataWriteDone (gdxHandle_t pgdx);
extern int  gdxDataWriteMap (gdxHandle_t pgdx, const int KeyInt[], const double Values[]);
extern int  gdxDataWriteMapStart (gdxHandle_t pgdx, const char *SyId, const char *ExplTxt, int Dimen, int Typ, int UserInfo);
extern int  gdxDataWriteRaw (gdxHandle_t pgdx, const int KeyInt[], const double Values[]);
extern int  gdxDataWriteRawStart (gdxHandle_t pgdx, const char *SyId, const char *ExplTxt, int Dimen, int Typ, int UserInfo);
extern int  gdxDataWriteStr (gdxHandle_t pgdx, const char *KeyStr_in[], const double Values[]);
extern int  gdxDataWriteStrStart (gdxHandle_t pgdx, const char *SyId, const char *ExplTxt, int Dimen, int Typ, int UserInfo);
extern int  gdxGetDLLVersion (gdxHandle_t pgdx, char *V_out);
extern int  gdxErrorCount (gdxHandle_t pgdx);
extern int  gdxErrorStr (gdxHandle_t pgdx, int ErrNr, char *ErrMsg_out);
extern int  gdxFileInfo (gdxHandle_t pgdx, int *OUTPUT, int *OUTPUT);
extern int  gdxFileVersion (gdxHandle_t pgdx, char *FileStr_out, char *ProduceStr_out);
extern int  gdxFilterExists (gdxHandle_t pgdx, int FilterNr);
extern int  gdxFilterRegister (gdxHandle_t pgdx, int UelMap);
extern int  gdxFilterRegisterDone (gdxHandle_t pgdx);
extern int  gdxFilterRegisterStart (gdxHandle_t pgdx, int FilterNr);
extern int  gdxFindSymbol (gdxHandle_t pgdx, const char *SyId, int *OUTPUT);
extern int  gdxGetElemText (gdxHandle_t pgdx, int TxtNr, char *Txt_out, int *OUTPUT);
extern int  gdxGetLastError (gdxHandle_t pgdx);
extern INT64  gdxGetMemoryUsed (gdxHandle_t pgdx);
extern int  gdxGetSpecialValues (gdxHandle_t pgdx, double AVals[]);
extern int  gdxGetUEL (gdxHandle_t pgdx, int UelNr, char *Uel_out);
extern int  gdxMapValue (gdxHandle_t pgdx, double D, int *OUTPUT);
extern int  gdxOpenAppend (gdxHandle_t pgdx, const char *FileName, const char *Producer, int *OUTPUT);
extern int  gdxOpenRead (gdxHandle_t pgdx, const char *FileName, int *OUTPUT);
extern int  gdxOpenReadEx (gdxHandle_t pgdx, const char *FileName, int ReadMode, int *OUTPUT);
extern int  gdxOpenWrite (gdxHandle_t pgdx, const char *FileName, const char *Producer, int *OUTPUT);
extern int  gdxOpenWriteEx (gdxHandle_t pgdx, const char *FileName, const char *Producer, int Compr, int *OUTPUT);
extern int  gdxResetSpecialValues (gdxHandle_t pgdx);
extern int  gdxSetHasText (gdxHandle_t pgdx, int SyNr);
extern int  gdxSetReadSpecialValues (gdxHandle_t pgdx, const double AVals[]);
extern int  gdxSetSpecialValues (gdxHandle_t pgdx, const double AVals[]);
extern int  gdxSetTextNodeNr (gdxHandle_t pgdx, int TxtNr, int Node);
extern int  gdxSetTraceLevel (gdxHandle_t pgdx, int N, const char *s);
extern int  gdxSymbIndxMaxLength (gdxHandle_t pgdx, int SyNr, int LengthInfo_out[]);
extern int  gdxSymbMaxLength (gdxHandle_t pgdx);
extern int  gdxSymbolAddComment (gdxHandle_t pgdx, int SyNr, const char *Txt);
extern int  gdxSymbolGetComment (gdxHandle_t pgdx, int SyNr, int N, char *Txt_out);
extern int  gdxSymbolGetDomain (gdxHandle_t pgdx, int SyNr, int DomainSyNrs_out[]);
extern int  gdxSymbolGetDomainX (gdxHandle_t pgdx, int SyNr, char *DomainIDs_out[]);
extern int  gdxSymbolDim (gdxHandle_t pgdx, int SyNr);
extern int  gdxSymbolInfo (gdxHandle_t pgdx, int SyNr, char *SyId_out, int *OUTPUT, int *OUTPUT);
extern int  gdxSymbolInfoX (gdxHandle_t pgdx, int SyNr, int *OUTPUT, int *OUTPUT, char *ExplTxt_out);
extern int  gdxSymbolSetDomain (gdxHandle_t pgdx, const char *DomainIDs_in[]);
extern int  gdxSymbolSetDomainX (gdxHandle_t pgdx, int SyNr, const char *DomainIDs_in[]);
extern int  gdxSystemInfo (gdxHandle_t pgdx, int *OUTPUT, int *OUTPUT);
extern int  gdxUELMaxLength (gdxHandle_t pgdx);
extern int  gdxUELRegisterDone (gdxHandle_t pgdx);
extern int  gdxUELRegisterMap (gdxHandle_t pgdx, int UMap, const char *Uel);
extern int  gdxUELRegisterMapStart (gdxHandle_t pgdx);
extern int  gdxUELRegisterRaw (gdxHandle_t pgdx, const char *Uel);
extern int  gdxUELRegisterRawStart (gdxHandle_t pgdx);
extern int  gdxUELRegisterStr (gdxHandle_t pgdx, const char *Uel, int *OUTPUT);
extern int  gdxUELRegisterStrStart (gdxHandle_t pgdx);
extern int  gdxUMFindUEL (gdxHandle_t pgdx, const char *Uel, int *OUTPUT, int *OUTPUT);
extern int  gdxUMUelGet (gdxHandle_t pgdx, int UelNr, char *Uel_out, int *OUTPUT);
extern int  gdxUMUelInfo (gdxHandle_t pgdx, int *OUTPUT, int *OUTPUT);
extern int  gdxGetDomainElements (gdxHandle_t pgdx, int SyNr, int DimPos, int FilterNr, TDomainIndexProc_t DP, int *OUTPUT, void *Uptr);
extern int  gdxCurrentDim (gdxHandle_t pgdx);
extern int  gdxRenameUEL (gdxHandle_t pgdx, const char *OldName, const char *NewName);
extern int  gdxStoreDomainSets (gdxHandle_t pgdx);
extern void gdxStoreDomainSetsSet (gdxHandle_t pgdx, const int x);

%include "gclgms_swig.h"
