"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const sns = require("@aws-cdk/aws-sns");
/**
 * Use an email address as a subscription target
 *
 * Email subscriptions require confirmation.
 */
class EmailSubscription {
    constructor(emailAddress, props = {}) {
        this.emailAddress = emailAddress;
        this.props = props;
    }
    /**
     * Returns a configuration for an email address to subscribe to an SNS topic
     */
    bind(_topic) {
        return {
            subscriberId: this.emailAddress,
            endpoint: this.emailAddress,
            protocol: this.props.json ? sns.SubscriptionProtocol.EMAIL_JSON : sns.SubscriptionProtocol.EMAIL,
            filterPolicy: this.props.filterPolicy,
        };
    }
}
exports.EmailSubscription = EmailSubscription;
//# sourceMappingURL=data:application/json;base64,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