#!/usr/bin/python
# -*- coding: utf-8 -*-

# Copyright (C) 2018  David Arroyo Menéndez

# Author: David Arroyo Menéndez <davidam@gnu.org>
# Maintainer: David Arroyo Menéndez <davidam@gnu.org>

# This file is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3, or (at your option)
# any later version.

# This file is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with damealgorithms; see the file LICENSE.  If not, write to
# the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
# Boston, MA 02110-1301 USA,

# http://interactivepython.org/UhZmZ/courselib/static/pythonds/SortSearch/TheQuickSort.html

class Quicksort(object):

    def __init__(self, v):
        self.vector = v

    def quickSortHelper(self, alist,first,last):
        if first<last:
            splitpoint = partition(alist,first,last)
            quickSortHelper(alist,first,splitpoint-1)
            quickSortHelper(alist,splitpoint+1,last)

    def quickSort(self, alist):
        quickSortHelper(alist,0,len(alist)-1)

    def partition(self, alist,first,last):
        pivotvalue = alist[first]
        leftmark = first+1
        rightmark = last
        done = False
        while not done:
            while leftmark <= rightmark and alist[leftmark] <= pivotvalue:
                leftmark = leftmark + 1

        while alist[rightmark] >= pivotvalue and rightmark >= leftmark:
           rightmark = rightmark -1

        if rightmark < leftmark:
           done = True
        else:
           temp = alist[leftmark]
           alist[leftmark] = alist[rightmark]
           alist[rightmark] = temp

        temp = alist[first]
        alist[first] = alist[rightmark]
        alist[rightmark] = temp
        return rightmark

# l = [54,26,93,17,77,31,44,55,20]
# q = Quicksort(l)
# print(q.quickSortHelper(l, 54, 20))
# print(q.quickSort(l))
# print(alist)
