"""Tests for WebAPI signals."""

from __future__ import unicode_literals

from django.contrib.auth.models import User
from kgb import SpyAgency

from djblets.testing.testcases import TestCase, TestModelsLoaderMixin
from djblets.webapi.models import BaseWebAPIToken
from djblets.webapi.signals import webapi_token_created, webapi_token_updated
from djblets.webapi.tests.test_api_token import WebAPIToken


class WebAPITokenSignalsTests(SpyAgency, TestModelsLoaderMixin, TestCase):
    """Tests for WebAPI token signals."""

    tests_app = 'djblets.webapi.tests'

    def setUp(self):
        super(WebAPITokenSignalsTests, self).setUp()

        self.user = User.objects.create_user(username='test_user',
                                             email='test@example.com')

    def test_webapi_token_created(self):
        """Testing WebAPIToken.objects.generate_token() emits
        webapi_token_created
        """
        def on_webapi_token_created(auto_generated, **kwargs):
            self.assertFalse(auto_generated)

        try:
            webapi_token_created.connect(on_webapi_token_created)
            self.spy_on(on_webapi_token_created)
            WebAPIToken.objects.generate_token(user=self.user)
            self.assertTrue(on_webapi_token_created.spy.called)
        finally:
            webapi_token_created.disconnect(on_webapi_token_created)

    def test_webapi_token_created_autogenerated(self):
        """Testing WebAPIToken.objects.generate_token() with
        auto_generated=True emits webapi_token_created with
        auto_generated=True
        """
        def on_webapi_token_created(auto_generated, **kwargs):
            self.assertTrue(auto_generated)

        try:
            webapi_token_created.connect(on_webapi_token_created)
            self.spy_on(on_webapi_token_created)
            WebAPIToken.objects.generate_token(user=self.user,
                                               auto_generated=True)
            self.assertTrue(on_webapi_token_created.spy.called)
        finally:
            webapi_token_created.disconnect(on_webapi_token_created)

    def test_webapi_token_updated(self):
        """Testing WebAPIToken.save() emits webapi_token_updated"""
        def on_webapi_token_created(**kwargs):
            pass

        def on_webapi_token_updated(**kwargs):
            pass

        try:
            webapi_token_created.connect(on_webapi_token_created)
            webapi_token_updated.connect(on_webapi_token_updated)

            self.spy_on(on_webapi_token_created)
            self.spy_on(on_webapi_token_updated)

            token = WebAPIToken.objects.generate_token(user=self.user)

            self.assertTrue(on_webapi_token_created.spy.called)
            self.assertFalse(on_webapi_token_updated.spy.called)

            on_webapi_token_created.spy.reset_calls()

            token.save()

            self.assertFalse(on_webapi_token_created.spy.called)
            self.assertTrue(on_webapi_token_updated.spy.called)
        finally:
            webapi_token_created.disconnect(on_webapi_token_created)
            webapi_token_updated.disconnect(on_webapi_token_updated)
