(function(){"use strict";(function(){var InstalledExtension=Backbone.Model.extend({defaults:{author:null,authorURL:null,configURL:null,dbURL:null,enabled:false,loadable:true,loadError:null,name:null,summary:null,version:null},url:function url(){return Backbone.Model.prototype.url.call(this)+"/"},enable:function enable(){var _this=this;return new Promise(function(resolve,reject){_this.save({enabled:true},{wait:true,success:function success(){return resolve()},error:function error(model,xhr){_this.set({loadable:false,loadError:xhr.errorRsp.load_error,canEnable:!xhr.errorRsp.needs_reload});reject(new Error(xhr.errorText))}})})},disable:function disable(){var _this2=this;return new Promise(function(resolve,reject){_this2.save({enabled:false},{wait:true,success:function success(){return resolve()},error:function error(xhr){return reject(new Error(xhr.errorText))}})})},toJSON:function toJSON(){return{enabled:this.get("enabled")}},parse:function parse(rsp){if(rsp.stat!==undefined){rsp=rsp.extension}var configLink=rsp.links["admin-configure"];var dbLink=rsp.links["admin-database"];return{author:rsp.author,authorURL:rsp.author_url,canDisable:rsp.can_disable,canEnable:rsp.can_enable,configURL:configLink?configLink.href:null,dbURL:dbLink?dbLink.href:null,enabled:rsp.enabled,loadable:rsp.loadable,loadError:rsp.load_error,id:rsp.class_name,name:rsp.name,summary:rsp.summary,version:rsp.version}},sync:function sync(method,model,options){Backbone.sync.call(this,method,model,_.defaults({contentType:"application/x-www-form-urlencoded",data:model.toJSON(options),processData:true,error:function error(xhr){var rsp=void 0;var text=void 0;try{rsp=$.parseJSON(xhr.responseText);text=rsp.err.msg}catch(e){text="HTTP "+xhr.status+" "+xhr.statusText;rsp={loadError:text,canEnable:false}}if(_.isFunction(options.error)){xhr.errorText=text;xhr.errorRsp=rsp;options.error(xhr,options)}}},options))}});var InstalledExtensionCollection=Backbone.Collection.extend({model:InstalledExtension,parse:function parse(rsp){return rsp.extensions}});Djblets.ExtensionManager=Backbone.Model.extend({defaults:{apiRoot:null},initialize:function initialize(){this.installedExtensions=new InstalledExtensionCollection;this.installedExtensions.url=this.get("apiRoot")},load:function load(){var _this3=this;this.trigger("loading");this.installedExtensions.fetch({success:function success(){return _this3.trigger("loaded")}})}})})();"use strict";(function(){var ExtensionItem=Djblets.Config.ListItem.extend({defaults:_.defaults({extension:null},Djblets.Config.ListItem.prototype.defaults),initialize:function initialize(){var _this=this;Djblets.Config.ListItem.prototype.initialize.apply(this,arguments);this._updateActions();this._updateItemState();this.listenTo(this.get("extension"),"change:loadable change:loadError change:enabled",function(){_this._updateItemState();_this._updateActions()})},_updateActions:function _updateActions(){var extension=this.get("extension");var actions=[];if(!extension.get("loadable")){actions.push({id:"reload",label:gettext("Reload")})}else if(extension.get("enabled")){var configURL=extension.get("configURL");var dbURL=extension.get("dbURL");if(dbURL){actions.push({id:"database",label:gettext("Database"),url:dbURL})}if(configURL){actions.push({id:"configure",label:gettext("Configure"),primary:true,url:configURL})}actions.push({id:"disable",label:gettext("Disable"),danger:true})}else{actions.push({id:"enable",label:gettext("Enable"),primary:true})}this.setActions(actions)},_updateItemState:function _updateItemState(){var extension=this.get("extension");var itemState=void 0;if(!extension.get("loadable")){itemState="error"}else if(extension.get("enabled")){itemState="enabled"}else{itemState="disabled"}this.set("itemState",itemState)}});var ExtensionItemView=Djblets.Config.TableItemView.extend({className:"djblets-c-extension-item djblets-c-config-forms-list__item",actionHandlers:{disable:"_onDisableClicked",enable:"_onEnableClicked",reload:"_onReloadClicked"},template:_.template('<td class="djblets-c-config-forms-list__item-main">\n <div class="djblets-c-extension-item__header">\n  <h3 class="djblets-c-extension-item__name"><%- name %></h3>\n  <span class="djblets-c-extension-item__version"><%- version %></span>\n  <div class="djblets-c-extension-item__author">\n   <% if (authorURL) { %>\n    <a href="<%- authorURL %>"><%- author %></a>\n   <% } else { %>\n    <%- author %>\n   <% } %>\n  </div>\n </div>\n <p class="djblets-c-extension-item__description">\n  <%- summary %>\n </p>\n <% if (!loadable) { %>\n  <pre class="djblets-c-extension-item__load-error"><%- loadError %></pre>\n <% } %>\n</td>\n<td class="djblets-c-config-forms-list__item-state"></td>\n<td></td>'),getRenderContext:function getRenderContext(){return this.model.get("extension").attributes},_onDisableClicked:function _onDisableClicked(){return this.model.get("extension").disable().catch(function(error){alert(interpolate(gettext("Failed to disable the extension: %(value1)s."),{value1:error.message},true))})},_onEnableClicked:function _onEnableClicked(){return this.model.get("extension").enable().catch(function(error){alert(interpolate(gettext("Failed to enable the extension: %(value1)s."),{value1:error.message},true))})},_onReloadClicked:function _onReloadClicked(){var _this2=this;return new Promise(function(){return _this2.model.trigger("needsReload")})}});Djblets.ExtensionManagerView=Backbone.View.extend({events:{"click .djblets-c-extensions__reload":"_reloadFull"},listItemsCollectionType:Djblets.Config.ListItems,listItemType:ExtensionItem,listItemViewType:ExtensionItemView,listViewType:Djblets.Config.TableView,initialize:function initialize(){this.list=new Djblets.Config.List({},{collection:new this.listItemsCollectionType([],{model:this.listItemType})})},render:function render(){var model=this.model;var list=this.list;this.listView=new this.listViewType({el:this.$(".djblets-c-config-forms-list"),model:list,ItemView:this.listItemViewType});this.listView.render().$el.removeAttr("aria-busy").addClass("-all-items-are-multiline");this._$listContainer=this.listView.$el.parent();this.listenTo(model,"loading",function(){return list.collection.reset()});this.listenTo(model,"loaded",this._onLoaded);model.load();return this},_onLoaded:function _onLoaded(){var _this3=this;var items=this.list.collection;this.model.installedExtensions.each(function(extension){var item=items.add({extension:extension});_this3.listenTo(item,"needsReload",_this3._reloadFull)})},_reloadFull:function _reloadFull(){this.el.submit()}})})()}).call(this);
