# Pentest

To prove the security of the *WebScripts Server*, I ran *web scanners* and tools for *web pentest* and printed the results.

I launch WebScripts with this command to perform scans:

```bash
python3 -m WebScripts --accept-unauthenticated-user --accept-unknow-user --blacklist-time 0 --auth-failures-to-blacklist 99999
```

## SkipFish

```bash
skipfish -H Api-Key=AdminAdminAdminAdminAdminAdminAdminAdminAdminAdminAdminAdminAdminAdminAdminAdminAdminAdminAdminAdminAdminAdminAdminAdminAdminAdminAdminAdminAdminAdminAdminAdmin -o ~/Documents/skipfish http://127.0.0.1:8000/
```

Scanner version: 2.10b

### Warnings and informations

Internal warning:

 1. Node should be a directory, detection error? *(2)*
    - http://127.0.0.1:8000/error_pages/Report/new
    - http://127.0.0.1:8000/web

Information note:

 - Incorrect or missing MIME type (low risk) *(2)*
    - http://127.0.0.1:8000/web *(Memo: application/javascript)*
    - http://127.0.0.1:8000/web/auth *(Memo: application/javascript)*
 - Hidden files / directories *(1)*
    - http://127.0.0.1:8000/auth/
 - Server error triggered *(3)*
    - http://127.0.0.1:8000/auth/
    - http://127.0.0.1:8000/error_pages/Report/
    - http://127.0.0.1:8000/error_pages/Report/new
 - Resource not directly accessible *(2)*
    - http://127.0.0.1:8000/auth/
    - http://127.0.0.1:8000/error_pages/Report/
 - New 404 signature seen *(2)*
    - http://127.0.0.1:8000/sfi9876
    - http://127.0.0.1:8000/sfi9876/
 - New 'X-\*' header value seen *(4)*
    - http://127.0.0.1:8000/ *(Memo: X-Frame-Options)*
    - http://127.0.0.1:8000/ *(Memo: X-XSS-Protection)*
    - http://127.0.0.1:8000/ *(Memo: X-Content-Type-Options)*
    - http://127.0.0.1:8000/ *(Memo: X-Server)*
 - New 'Server' header value seen *(1)*
    - http://127.0.0.1:8000/ *(Memo: WebScripts 0.0.7)*

### Pages and ressources
application/javascript (5)

 - http://127.0.0.1:8000/js/webscripts_index_js_scripts.js (2263 bytes)
 - http://127.0.0.1:8000/js/webscripts_js_scripts.js (4326 bytes)
 - http://127.0.0.1:8000/js/webscripts_script_js_scripts.js (20726 bytes)
 - http://127.0.0.1:8000/web (5399 bytes)
 - http://127.0.0.1:8000/web/auth (6591 bytes)

application/xhtml+xml (8)

 - http://127.0.0.1:8000/static/commons.html (43982 bytes)
 - http://127.0.0.1:8000/static/error_pages.html (8663 bytes)
 - http://127.0.0.1:8000/static/Errors.html (32865 bytes)
 - http://127.0.0.1:8000/static/manage_defaults_databases.html (27746 bytes)
 - http://127.0.0.1:8000/static/Pages.html (7678 bytes)
 - http://127.0.0.1:8000/static/uploads_management.html (13834 bytes)
 - http://127.0.0.1:8000/static/utils.html (17131 bytes)
 - http://127.0.0.1:8000/static/WebScripts.html (19858 bytes)

image/jpeg (1)

 - http://127.0.0.1:8000/static/webscripts_header.jpg (44039 bytes)

image/png (1)

 - http://127.0.0.1:8000/static/webscripts_icon.png (1741 bytes)

text/css (3)

 - http://127.0.0.1:8000/static/webscripts_script_style.css (2039 bytes)
 - http://127.0.0.1:8000/static/webscripts_style.css (5195 bytes)
 - http://127.0.0.1:8000/static/webscripts_index_style.css (874 bytes)

text/html (4)

 - http://127.0.0.1:8000/ (165 bytes)
 - http://127.0.0.1:8000/auth/ [Not linked (brute-forced)] \(8232 bytes)
 - http://127.0.0.1:8000/error_pages/Report/new (8199 bytes)
 - http://127.0.0.1:8000/error_pages/Report/new// (8227 bytes)

## WhatWeb

```bash
whatweb -u Admin:Admin -v -a 4 http://127.0.0.1:8000/
```

```text
WhatWeb report for http://127.0.0.1:8000/
Status    : 301 Moved Permanently
Title     : <None>
IP        : 127.0.0.1
Country   : RESERVED, ZZ

Summary   : Matomo, Strict-Transport-Security[max-age=63072000; includeSubDomains; preload], RedirectLocation[/web/], X-Frame-Options[deny], X-XSS-Protection[1; mode=block], UncommonHeaders[content-security-policy,x-content-type-options,referrer-policy,clear-site-data,feature-policy,permissions-policy,cross-origin-embedder-policy,cross-origin-opener-policy,cross-origin-resource-policy,x-server], HTTPServer[WebScripts 2.4.1], Script

Detected Plugins:
[ HTTPServer ]
        HTTP server header string. This plugin also attempts to 
        identify the operating system from the server header. 

        String       : WebScripts 2.4.1 (from server string)

[ Matomo ]
        Matomo is the leading open alternative to Google Analytics 
        that gives you full control over your data. Matomo lets you 
        easily collect data from websites, apps & the IoT and 
        visualise this data and extract insights. Privacy is 
        built-in. Matomo was formerly known as Piwik, and is 
        developed in PHP. 

        Aggressive function available (check plugin file or details).
        Google Dorks: (1)
        Website     : https://matomo.org

[ RedirectLocation ]
        HTTP Server string location. used with http-status 301 and 
        302 

        String       : /web/ (from location)

[ Script ]
        This plugin detects instances of script HTML elements and 
        returns the script language/type. 


[ Strict-Transport-Security ]
        Strict-Transport-Security is an HTTP header that restricts 
        a web browser from accessing a website without the security 
        of the HTTPS protocol. 

        String       : max-age=63072000; includeSubDomains; preload

[ UncommonHeaders ]
        Uncommon HTTP server headers. The blacklist includes all 
        the standard headers and many non standard but common ones. 
        Interesting but fairly common headers should have their own 
        plugins, eg. x-powered-by, server and x-aspnet-version. 
        Info about headers can be found at www.http-stats.com 

        String       : content-security-policy,x-content-type-options,referrer-policy,clear-site-data,feature-policy,permissions-policy,cross-origin-embedder-policy,cross-origin-opener-policy,cross-origin-resource-policy,x-server (from headers)                                                                      

[ X-Frame-Options ]
        This plugin retrieves the X-Frame-Options value from the 
        HTTP header. - More Info: 
        http://msdn.microsoft.com/en-us/library/cc288472%28VS.85%29.
        aspx

        String       : deny

[ X-XSS-Protection ]
        This plugin retrieves the X-XSS-Protection value from the 
        HTTP header. - More Info: 
        http://msdn.microsoft.com/en-us/library/cc288472%28VS.85%29.
        aspx

        String       : 1; mode=block

HTTP Headers:
        HTTP/1.0 301 Moved Permanently
        Date: Thu, 02 Dec 2021 19:36:43 GMT
        Server: WebScripts 2.4.1
        Content-Type: text/html; charset=utf-8
        Strict-Transport-Security: max-age=63072000; includeSubDomains; preload
        Content-Security-Policy: default-src 'self'; form-action 'none'; frame-ancestors 'none'
        X-Frame-Options: deny
        X-XSS-Protection: 1; mode=block
        X-Content-Type-Options: nosniff
        Referrer-Policy: origin-when-cross-origin
        Cache-Control: no-store
        Pragma: no-store
        Clear-Site-Data: "cache", "executionContexts"
        Feature-Policy: payment 'none'; geolocation 'none'; microphone 'none'; camera 'none'
        Permissions-Policy: microphone=(),camera=(),payment=(),geolocation=()
        Cross-Origin-Embedder-Policy: require-corp
        Cross-Origin-Opener-Policy: same-origin
        Cross-Origin-Resource-Policy: same-origin
        X-Server: WebScripts
        Location: /web/
        Content-Length: 165

WhatWeb report for http://127.0.0.1:8000/web/
Status    : 200 OK
Title     : Index of WebScripts Server
IP        : 127.0.0.1
Country   : RESERVED, ZZ

Summary   : Matomo, Strict-Transport-Security[max-age=63072000; includeSubDomains; preload], X-Frame-Options[deny], HTML5, X-XSS-Protection[1; mode=block], UncommonHeaders[content-security-policy,x-content-type-options,referrer-policy,clear-site-data,feature-policy,permissions-policy,cross-origin-embedder-policy,cross-origin-opener-policy,cross-origin-resource-policy,x-server], HTTPServer[WebScripts 2.4.1], Script[text/javascript]

Detected Plugins:
[ HTML5 ]
        HTML version 5, detected by the doctype declaration 


[ HTTPServer ]
        HTTP server header string. This plugin also attempts to 
        identify the operating system from the server header. 

        String       : WebScripts 2.4.1 (from server string)

[ Matomo ]
        Matomo is the leading open alternative to Google Analytics 
        that gives you full control over your data. Matomo lets you 
        easily collect data from websites, apps & the IoT and 
        visualise this data and extract insights. Privacy is 
        built-in. Matomo was formerly known as Piwik, and is 
        developed in PHP. 

        Aggressive function available (check plugin file or details).
        Google Dorks: (1)
        Website     : https://matomo.org

[ Script ]
        This plugin detects instances of script HTML elements and 
        returns the script language/type. 

        String       : text/javascript

[ Strict-Transport-Security ]
        Strict-Transport-Security is an HTTP header that restricts 
        a web browser from accessing a website without the security 
        of the HTTPS protocol. 

        String       : max-age=63072000; includeSubDomains; preload

[ UncommonHeaders ]
        Uncommon HTTP server headers. The blacklist includes all 
        the standard headers and many non standard but common ones. 
        Interesting but fairly common headers should have their own 
        plugins, eg. x-powered-by, server and x-aspnet-version. 
        Info about headers can be found at www.http-stats.com 

        String       : content-security-policy,x-content-type-options,referrer-policy,clear-site-data,feature-policy,permissions-policy,cross-origin-embedder-policy,cross-origin-opener-policy,cross-origin-resource-policy,x-server (from headers)                                                                      

[ X-Frame-Options ]
        This plugin retrieves the X-Frame-Options value from the 
        HTTP header. - More Info: 
        http://msdn.microsoft.com/en-us/library/cc288472%28VS.85%29.
        aspx

        String       : deny

[ X-XSS-Protection ]
        This plugin retrieves the X-XSS-Protection value from the 
        HTTP header. - More Info: 
        http://msdn.microsoft.com/en-us/library/cc288472%28VS.85%29.
        aspx

        String       : 1; mode=block

HTTP Headers:
        HTTP/1.0 200 OK
        Date: Thu, 02 Dec 2021 19:45:02 GMT
        Server: WebScripts 2.4.1
        Content-Type: text/html; charset=utf-8
        Strict-Transport-Security: max-age=63072000; includeSubDomains; preload
        Content-Security-Policy: default-src 'self'; form-action 'none'; frame-ancestors 'none'; script-src 'self' 'sha512-PrdxK6oDVtJdo252hYBGESefJT/X4juRfz9nEf9gFJ4JkLYYIkFqdmTUJ3Dj1Bbqt0yp5cwmUHsMYpCdGdSryg=='
        X-Frame-Options: deny
        X-XSS-Protection: 1; mode=block
        X-Content-Type-Options: nosniff
        Referrer-Policy: origin-when-cross-origin
        Cache-Control: no-store
        Pragma: no-store
        Clear-Site-Data: "cache", "executionContexts"
        Feature-Policy: payment 'none'; geolocation 'none'; microphone 'none'; camera 'none'
        Permissions-Policy: microphone=(),camera=(),payment=(),geolocation=()
        Cross-Origin-Embedder-Policy: require-corp
        Cross-Origin-Opener-Policy: same-origin
        Cross-Origin-Resource-Policy: same-origin
        X-Server: WebScripts
        Content-Length: 7579
```

## Test RCE (Remote Code Execution) on /API/

```text
[!] Start tests RCE (Remote Code Execution)...
[+] Injection: [';', 'cat', ' ', '/etc/passwd']
[*] Response: {'stdout': '<table>\r\n</table>\r\n', 'stderr': '', 'code': 0, 'Content-Type': 'text/html', 'error': 'No errors'}
[+] Injection: ;cat /etc/passwd
[*] Response: {'stdout': '<table>\r\n</table>\r\n', 'stderr': '', 'code': 0, 'Content-Type': 'text/html', 'error': 'No errors'}
[+] Injection: ['|', 'cat', ' ', '/etc/passwd']
[*] Response: {'stdout': '<table>\r\n</table>\r\n', 'stderr': '', 'code': 0, 'Content-Type': 'text/html', 'error': 'No errors'}
[+] Injection: |cat /etc/passwd
[*] Response: {'stdout': '<table>\r\n</table>\r\n', 'stderr': '', 'code': 0, 'Content-Type': 'text/html', 'error': 'No errors'}
[+] Injection: ['&&', 'cat', ' ', '/etc/passwd']
[*] Response: {'stdout': '<table>\r\n</table>\r\n', 'stderr': '', 'code': 0, 'Content-Type': 'text/html', 'error': 'No errors'}
[+] Injection: &&cat /etc/passwd
[*] Response: {'stdout': '<table>\r\n</table>\r\n', 'stderr': '', 'code': 0, 'Content-Type': 'text/html', 'error': 'No errors'}
[+] Injection: ['\n', 'cat', ' ', '/etc/passwd']
[*] Response: {'stdout': '<table>\r\n</table>\r\n', 'stderr': '', 'code': 0, 'Content-Type': 'text/html', 'error': 'No errors'}
[+] Injection:
cat /etc/passwd
[*] Response: {'stdout': '<table>\r\n</table>\r\n', 'stderr': '', 'code': 0, 'Content-Type': 'text/html', 'error': 'No errors'}
[+] Injection: ['&&', 'cat', ' ', '/etc/passwd', '&&']
[*] Response: {'stdout': '<table>\r\n</table>\r\n', 'stderr': '', 'code': 0, 'Content-Type': 'text/html', 'error': 'No errors'}
[+] Injection: &&cat /etc/passwd&&
[*] Response: {'stdout': '<table>\r\n</table>\r\n', 'stderr': '', 'code': 0, 'Content-Type': 'text/html', 'error': 'No errors'}
[+] Injection: [';', 'cat', ' ', '/etc/passwd', ';']
[*] Response: {'stdout': '<table>\r\n</table>\r\n', 'stderr': '', 'code': 0, 'Content-Type': 'text/html', 'error': 'No errors'}
[+] Injection: ;cat /etc/passwd;
[*] Response: {'stdout': '<table>\r\n</table>\r\n', 'stderr': '', 'code': 0, 'Content-Type': 'text/html', 'error': 'No errors'}
[+] Injection: ['|', 'cat', ' ', '/etc/passwd', '|']
[*] Response: {'stdout': '<table>\r\n</table>\r\n', 'stderr': '', 'code': 0, 'Content-Type': 'text/html', 'error': 'No errors'}
[+] Injection: |cat /etc/passwd|
[*] Response: {'stdout': '<table>\r\n</table>\r\n', 'stderr': '', 'code': 0, 'Content-Type': 'text/html', 'error': 'No errors'}
[+] Injection: [';', 'cat', ' ', '/etc/passwd', '|']
[*] Response: {'stdout': '<table>\r\n</table>\r\n', 'stderr': '', 'code': 0, 'Content-Type': 'text/html', 'error': 'No errors'}
[+] Injection: ;cat /etc/passwd|
[*] Response: {'stdout': '<table>\r\n</table>\r\n', 'stderr': '', 'code': 0, 'Content-Type': 'text/html', 'error': 'No errors'}
[+] Injection: ['\n', 'cat', ' ', '/etc/passwd', '\n']
[*] Response: {'stdout': '<table>\r\n</table>\r\n', 'stderr': '', 'code': 0, 'Content-Type': 'text/html', 'error': 'No errors'}
[+] Injection:
cat /etc/passwd

[*] Response: {'stdout': '<table>\r\n</table>\r\n', 'stderr': '', 'code': 0, 'Content-Type': 'text/html', 'error': 'No errors'}
[+] Injection: ['\\etc\\passwd']
[*] Response: {'stdout': '<table>\r\n</table>\r\n', 'stderr': '', 'code': 0, 'Content-Type': 'text/html', 'error': 'No errors'}
[+] Injection: \etc\passwd
[*] Response: {'stdout': '<table>\r\n</table>\r\n', 'stderr': '', 'code': 0, 'Content-Type': 'text/html', 'error': 'No errors'}
[+] Injection: ['.|./.|./.|./.|./.|./.|./.|./.|./.|./.|./.|./.|./etc/passwd']
[*] Response: {'stdout': '<table>\r\n</table>\r\n', 'stderr': '', 'code': 0, 'Content-Type': 'text/html', 'error': 'No errors'}
[+] Injection: .|./.|./.|./.|./.|./.|./.|./.|./.|./.|./.|./.|./etc/passwd
[*] Response: {'stdout': '<table>\r\n</table>\r\n', 'stderr': '', 'code': 0, 'Content-Type': 'text/html', 'error': 'No errors'}
[+] Injection: ['../../../../../../../bin/cat', ' ', '/etc/passwd', '|']
[*] Response: {'stdout': '<table>\r\n</table>\r\n', 'stderr': '', 'code': 0, 'Content-Type': 'text/html', 'error': 'No errors'}
[+] Injection: ../../../../../../../bin/cat /etc/passwd|
[*] Response: {'stdout': '<table>\r\n</table>\r\n', 'stderr': '', 'code': 0, 'Content-Type': 'text/html', 'error': 'No errors'}
[+] Injection: ['"', ';', 'system(cat /etc/passwd);']
[*] Response: {'stdout': '<table>\r\n</table>\r\n', 'stderr': '', 'code': 0, 'Content-Type': 'text/html', 'error': 'No errors'}
[+] Injection: ";system(cat /etc/passwd);
[*] Response: {'stdout': '<table>\r\n</table>\r\n', 'stderr': '', 'code': 0, 'Content-Type': 'text/html', 'error': 'No errors'}
[+] Injection: ['`cat /etc/passwd`']
[*] Response: {'stdout': '<table>\r\n</table>\r\n', 'stderr': '', 'code': 0, 'Content-Type': 'text/html', 'error': 'No errors'}
[+] Injection: `cat /etc/passwd`
[*] Response: {'stdout': '<table>\r\n</table>\r\n', 'stderr': '', 'code': 0, 'Content-Type': 'text/html', 'error': 'No errors'}
[+] Injection: [';', "system('cat /etc/passwd')"]
[*] Response: {'stdout': '<table>\r\n</table>\r\n', 'stderr': '', 'code': 0, 'Content-Type': 'text/html', 'error': 'No errors'}
[+] Injection: ;system('cat /etc/passwd')
[*] Response: {'stdout': '<table>\r\n</table>\r\n', 'stderr': '', 'code': 0, 'Content-Type': 'text/html', 'error': 'No errors'}
[+] Injection: ['&&', "system('cat /etc/passwd')"]
[*] Response: {'stdout': '<table>\r\n</table>\r\n', 'stderr': '', 'code': 0, 'Content-Type': 'text/html', 'error': 'No errors'}
[+] Injection: &&system('cat /etc/passwd')
[*] Response: {'stdout': '<table>\r\n</table>\r\n', 'stderr': '', 'code': 0, 'Content-Type': 'text/html', 'error': 'No errors'}
[+] Injection: ['|', "system('cat /etc/passwd')"]
[*] Response: {'stdout': '<table>\r\n</table>\r\n', 'stderr': '', 'code': 0, 'Content-Type': 'text/html', 'error': 'No errors'}
[+] Injection: |system('cat /etc/passwd')
[*] Response: {'stdout': '<table>\r\n</table>\r\n', 'stderr': '', 'code': 0, 'Content-Type': 'text/html', 'error': 'No errors'}
[+] Injection: ['|', "system('cat /etc/passwd');"]
[*] Response: {'stdout': '<table>\r\n</table>\r\n', 'stderr': '', 'code': 0, 'Content-Type': 'text/html', 'error': 'No errors'}
[+] Injection: |system('cat /etc/passwd');
[*] Response: {'stdout': '<table>\r\n</table>\r\n', 'stderr': '', 'code': 0, 'Content-Type': 'text/html', 'error': 'No errors'}
[+] Injection: ['perl', ' ', '-e"system(\'cat /etc/passwd\');"', "\n'"]
[*] Response: {'stdout': '<table>\r\n</table>\r\n', 'stderr': '', 'code': 0, 'Content-Type': 'text/html', 'error': 'No errors'}
[+] Injection: perl -e"system('cat /etc/passwd');"
'
[*] Response: {'stdout': '<table>\r\n</table>\r\n', 'stderr': '', 'code': 0, 'Content-Type': 'text/html', 'error': 'No errors'}
[+] Injection: ['/bin/cat', '/etc/passwd', '|', "'\n'"]
[*] Response: {'stdout': '<table>\r\n</table>\r\n', 'stderr': '', 'code': 0, 'Content-Type': 'text/html', 'error': 'No errors'}
[+] Injection: /bin/cat/etc/passwd|'
'
[*] Response: {'stdout': '<table>\r\n</table>\r\n', 'stderr': '', 'code': 0, 'Content-Type': 'text/html', 'error': 'No errors'}
[+] Injection: ['/bin/cat', '/etc/passwd', "|'"]
[*] Response: {'stdout': '<table>\r\n</table>\r\n', 'stderr': '', 'code': 0, 'Content-Type': 'text/html', 'error': 'No errors'}
[+] Injection: /bin/cat/etc/passwd|'
[*] Response: {'stdout': '<table>\r\n</table>\r\n', 'stderr': '', 'code': 0, 'Content-Type': 'text/html', 'error': 'No errors'}
[+] Injection: ['system("cat /etc/passwd")', ';', 'die']
[*] Response: {'stdout': '<table>\r\n</table>\r\n', 'stderr': '', 'code': 0, 'Content-Type': 'text/html', 'error': 'No errors'}
[+] Injection: system("cat /etc/passwd");die
[*] Response: {'stdout': '<table>\r\n</table>\r\n', 'stderr': '', 'code': 0, 'Content-Type': 'text/html', 'error': 'No errors'}
[+] Injection: ['";cat /etc/passwd;echo "']
[*] Response: {'stdout': '<table>\r\n</table>\r\n', 'stderr': '', 'code': 0, 'Content-Type': 'text/html', 'error': 'No errors'}
[+] Injection: ";cat /etc/passwd;echo "
[*] Response: {'stdout': '<table>\r\n</table>\r\n', 'stderr': '', 'code': 0, 'Content-Type': 'text/html', 'error': 'No errors'}
[!] End.
```

*WebScripts logs* on the **RCE pentests**:
```txt
[2021-09-11 19:33:12] INFO(20)         Admin get access to category Administration (['*'])
[2021-09-11 19:33:13] INFO(20)         Command: ['python3', './scripts/account/view_users.py', '--names', ';', 'cat', ' ', '/etc/passwd']
[2021-09-11 19:33:13] DEBUG(10)        SCRIPT "view_users.py" executed without error for user named "Admin".
127.0.0.1 - - [11/Sep/2021 19:33:13] "POST /api/scripts/view_users.py HTTP/1.1" 200 113
[2021-09-11 19:33:13] DEBUG(10)        Request (POST) from 127.0.0.1 on /api/scripts/view_users.py.
[2021-09-11 19:33:13] INFO(20)         Run authentication script.
[2021-09-11 19:33:14] DEBUG(10)        SCRIPT "auth.py" executed without error for user named "Not Authenticated".
[2021-09-11 19:33:14] INFO(20)         Admin get access to category Administration (['*'])
[2021-09-11 19:33:14] INFO(20)         Command: ['python3', './scripts/account/view_users.py', '--names', ';', 'cat', ' ', '/etc/passwd']
[2021-09-11 19:33:14] DEBUG(10)        SCRIPT "view_users.py" executed without error for user named "Admin".
127.0.0.1 - - [11/Sep/2021 19:33:14] "POST /api/scripts/view_users.py HTTP/1.1" 200 113
[2021-09-11 19:33:14] DEBUG(10)        Request (POST) from 127.0.0.1 on /api/scripts/view_users.py.
[2021-09-11 19:33:14] INFO(20)         Run authentication script.
[2021-09-11 19:33:15] DEBUG(10)        SCRIPT "auth.py" executed without error for user named "Not Authenticated".
[2021-09-11 19:33:15] INFO(20)         Admin get access to category Administration (['*'])
[2021-09-11 19:33:16] INFO(20)         Command: ['python3', './scripts/account/view_users.py', '--names', '|', 'cat', ' ', '/etc/passwd']
[2021-09-11 19:33:16] DEBUG(10)        SCRIPT "view_users.py" executed without error for user named "Admin".
127.0.0.1 - - [11/Sep/2021 19:33:16] "POST /api/scripts/view_users.py HTTP/1.1" 200 113
[2021-09-11 19:33:16] DEBUG(10)        Request (POST) from 127.0.0.1 on /api/scripts/view_users.py.
[2021-09-11 19:33:16] INFO(20)         Run authentication script.
[2021-09-11 19:33:16] DEBUG(10)        SCRIPT "auth.py" executed without error for user named "Not Authenticated".
[2021-09-11 19:33:16] INFO(20)         Admin get access to category Administration (['*'])
[2021-09-11 19:33:17] INFO(20)         Command: ['python3', './scripts/account/view_users.py', '--names', '|', 'cat', ' ', '/etc/passwd']
[2021-09-11 19:33:17] DEBUG(10)        SCRIPT "view_users.py" executed without error for user named "Admin".
127.0.0.1 - - [11/Sep/2021 19:33:17] "POST /api/scripts/view_users.py HTTP/1.1" 200 113
[2021-09-11 19:33:17] DEBUG(10)        Request (POST) from 127.0.0.1 on /api/scripts/view_users.py.
[2021-09-11 19:33:17] INFO(20)         Run authentication script.
[2021-09-11 19:33:17] DEBUG(10)        SCRIPT "auth.py" executed without error for user named "Not Authenticated".
[2021-09-11 19:33:17] INFO(20)         Admin get access to category Administration (['*'])
[2021-09-11 19:33:18] INFO(20)         Command: ['python3', './scripts/account/view_users.py', '--names', '&&', 'cat', ' ', '/etc/passwd']
[2021-09-11 19:33:18] DEBUG(10)        SCRIPT "view_users.py" executed without error for user named "Admin".
127.0.0.1 - - [11/Sep/2021 19:33:18] "POST /api/scripts/view_users.py HTTP/1.1" 200 113
[2021-09-11 19:33:18] DEBUG(10)        Request (POST) from 127.0.0.1 on /api/scripts/view_users.py.
[2021-09-11 19:33:18] INFO(20)         Run authentication script.
[2021-09-11 19:33:19] DEBUG(10)        SCRIPT "auth.py" executed without error for user named "Not Authenticated".
[2021-09-11 19:33:19] INFO(20)         Admin get access to category Administration (['*'])
[2021-09-11 19:33:19] INFO(20)         Command: ['python3', './scripts/account/view_users.py', '--names', '&&', 'cat', ' ', '/etc/passwd']
[2021-09-11 19:33:19] DEBUG(10)        SCRIPT "view_users.py" executed without error for user named "Admin".
127.0.0.1 - - [11/Sep/2021 19:33:19] "POST /api/scripts/view_users.py HTTP/1.1" 200 113
[2021-09-11 19:33:19] DEBUG(10)        Request (POST) from 127.0.0.1 on /api/scripts/view_users.py.
[2021-09-11 19:33:19] INFO(20)         Run authentication script.
[2021-09-11 19:33:20] DEBUG(10)        SCRIPT "auth.py" executed without error for user named "Not Authenticated".
[2021-09-11 19:33:20] INFO(20)         Admin get access to category Administration (['*'])
[2021-09-11 19:33:20] INFO(20)         Command: ['python3', './scripts/account/view_users.py', '--names', '\n', 'cat', ' ', '/etc/passwd']
[2021-09-11 19:33:20] DEBUG(10)        SCRIPT "view_users.py" executed without error for user named "Admin".
127.0.0.1 - - [11/Sep/2021 19:33:20] "POST /api/scripts/view_users.py HTTP/1.1" 200 113
[2021-09-11 19:33:20] DEBUG(10)        Request (POST) from 127.0.0.1 on /api/scripts/view_users.py.
[2021-09-11 19:33:20] INFO(20)         Run authentication script.
[2021-09-11 19:33:21] DEBUG(10)        SCRIPT "auth.py" executed without error for user named "Not Authenticated".
[2021-09-11 19:33:21] INFO(20)         Admin get access to category Administration (['*'])
[2021-09-11 19:33:22] INFO(20)         Command: ['python3', './scripts/account/view_users.py', '--names', '\n', 'cat', ' ', '/etc/passwd']
[2021-09-11 19:33:22] DEBUG(10)        SCRIPT "view_users.py" executed without error for user named "Admin".
127.0.0.1 - - [11/Sep/2021 19:33:22] "POST /api/scripts/view_users.py HTTP/1.1" 200 113
[2021-09-11 19:33:22] DEBUG(10)        Request (POST) from 127.0.0.1 on /api/scripts/view_users.py.
[2021-09-11 19:33:22] INFO(20)         Run authentication script.
[2021-09-11 19:33:22] DEBUG(10)        SCRIPT "auth.py" executed without error for user named "Not Authenticated".
[2021-09-11 19:33:22] INFO(20)         Admin get access to category Administration (['*'])
[2021-09-11 19:33:23] INFO(20)         Command: ['python3', './scripts/account/view_users.py', '--names', '&&', 'cat', ' ', '/etc/passwd', '&&']
[2021-09-11 19:33:23] DEBUG(10)        SCRIPT "view_users.py" executed without error for user named "Admin".
127.0.0.1 - - [11/Sep/2021 19:33:23] "POST /api/scripts/view_users.py HTTP/1.1" 200 113
[2021-09-11 19:33:23] DEBUG(10)        Request (POST) from 127.0.0.1 on /api/scripts/view_users.py.
[2021-09-11 19:33:23] INFO(20)         Run authentication script.
[2021-09-11 19:33:23] DEBUG(10)        SCRIPT "auth.py" executed without error for user named "Not Authenticated".
[2021-09-11 19:33:23] INFO(20)         Admin get access to category Administration (['*'])
[2021-09-11 19:33:24] INFO(20)         Command: ['python3', './scripts/account/view_users.py', '--names', '&&', 'cat', ' ', '/etc/passwd', '&&']
[2021-09-11 19:33:24] DEBUG(10)        SCRIPT "view_users.py" executed without error for user named "Admin".
127.0.0.1 - - [11/Sep/2021 19:33:24] "POST /api/scripts/view_users.py HTTP/1.1" 200 113
[2021-09-11 19:33:24] DEBUG(10)        Request (POST) from 127.0.0.1 on /api/scripts/view_users.py.
[2021-09-11 19:33:24] INFO(20)         Run authentication script.
[2021-09-11 19:33:25] DEBUG(10)        SCRIPT "auth.py" executed without error for user named "Not Authenticated".
[2021-09-11 19:33:25] INFO(20)         Admin get access to category Administration (['*'])
[2021-09-11 19:33:25] INFO(20)         Command: ['python3', './scripts/account/view_users.py', '--names', ';', 'cat', ' ', '/etc/passwd', ';']
[2021-09-11 19:33:25] DEBUG(10)        SCRIPT "view_users.py" executed without error for user named "Admin".
127.0.0.1 - - [11/Sep/2021 19:33:25] "POST /api/scripts/view_users.py HTTP/1.1" 200 113
[2021-09-11 19:33:25] DEBUG(10)        Request (POST) from 127.0.0.1 on /api/scripts/view_users.py.
[2021-09-11 19:33:25] INFO(20)         Run authentication script.
[2021-09-11 19:33:26] DEBUG(10)        SCRIPT "auth.py" executed without error for user named "Not Authenticated".
[2021-09-11 19:33:26] INFO(20)         Admin get access to category Administration (['*'])
[2021-09-11 19:33:27] INFO(20)         Command: ['python3', './scripts/account/view_users.py', '--names', ';', 'cat', ' ', '/etc/passwd', ';']
[2021-09-11 19:33:27] DEBUG(10)        SCRIPT "view_users.py" executed without error for user named "Admin".
127.0.0.1 - - [11/Sep/2021 19:33:27] "POST /api/scripts/view_users.py HTTP/1.1" 200 113
[2021-09-11 19:33:27] DEBUG(10)        Request (POST) from 127.0.0.1 on /api/scripts/view_users.py.
[2021-09-11 19:33:27] INFO(20)         Run authentication script.
[2021-09-11 19:33:27] DEBUG(10)        SCRIPT "auth.py" executed without error for user named "Not Authenticated".
[2021-09-11 19:33:27] INFO(20)         Admin get access to category Administration (['*'])
[2021-09-11 19:33:28] INFO(20)         Command: ['python3', './scripts/account/view_users.py', '--names', '|', 'cat', ' ', '/etc/passwd', '|']
[2021-09-11 19:33:28] DEBUG(10)        SCRIPT "view_users.py" executed without error for user named "Admin".
127.0.0.1 - - [11/Sep/2021 19:33:28] "POST /api/scripts/view_users.py HTTP/1.1" 200 113
[2021-09-11 19:33:28] DEBUG(10)        Request (POST) from 127.0.0.1 on /api/scripts/view_users.py.
[2021-09-11 19:33:28] INFO(20)         Run authentication script.
[2021-09-11 19:33:28] DEBUG(10)        SCRIPT "auth.py" executed without error for user named "Not Authenticated".
[2021-09-11 19:33:28] INFO(20)         Admin get access to category Administration (['*'])
[2021-09-11 19:33:29] INFO(20)         Command: ['python3', './scripts/account/view_users.py', '--names', '|', 'cat', ' ', '/etc/passwd', '|']
[2021-09-11 19:33:29] DEBUG(10)        SCRIPT "view_users.py" executed without error for user named "Admin".
127.0.0.1 - - [11/Sep/2021 19:33:29] "POST /api/scripts/view_users.py HTTP/1.1" 200 113
[2021-09-11 19:33:29] DEBUG(10)        Request (POST) from 127.0.0.1 on /api/scripts/view_users.py.
[2021-09-11 19:33:29] INFO(20)         Run authentication script.
[2021-09-11 19:33:30] DEBUG(10)        SCRIPT "auth.py" executed without error for user named "Not Authenticated".
[2021-09-11 19:33:30] INFO(20)         Admin get access to category Administration (['*'])
[2021-09-11 19:33:30] INFO(20)         Command: ['python3', './scripts/account/view_users.py', '--names', ';', 'cat', ' ', '/etc/passwd', '|']
[2021-09-11 19:33:30] DEBUG(10)        SCRIPT "view_users.py" executed without error for user named "Admin".
127.0.0.1 - - [11/Sep/2021 19:33:30] "POST /api/scripts/view_users.py HTTP/1.1" 200 113
[2021-09-11 19:33:30] DEBUG(10)        Request (POST) from 127.0.0.1 on /api/scripts/view_users.py.
[2021-09-11 19:33:30] INFO(20)         Run authentication script.
[2021-09-11 19:33:31] DEBUG(10)        SCRIPT "auth.py" executed without error for user named "Not Authenticated".
[2021-09-11 19:33:31] INFO(20)         Admin get access to category Administration (['*'])
[2021-09-11 19:33:31] INFO(20)         Command: ['python3', './scripts/account/view_users.py', '--names', ';', 'cat', ' ', '/etc/passwd', '|']
[2021-09-11 19:33:31] DEBUG(10)        SCRIPT "view_users.py" executed without error for user named "Admin".
127.0.0.1 - - [11/Sep/2021 19:33:31] "POST /api/scripts/view_users.py HTTP/1.1" 200 113
[2021-09-11 19:33:31] DEBUG(10)        Request (POST) from 127.0.0.1 on /api/scripts/view_users.py.
[2021-09-11 19:33:31] INFO(20)         Run authentication script.
[2021-09-11 19:33:32] DEBUG(10)        SCRIPT "auth.py" executed without error for user named "Not Authenticated".
[2021-09-11 19:33:32] INFO(20)         Admin get access to category Administration (['*'])
[2021-09-11 19:33:33] INFO(20)         Command: ['python3', './scripts/account/view_users.py', '--names', '\n', 'cat', ' ', '/etc/passwd', '\n']
[2021-09-11 19:33:33] DEBUG(10)        SCRIPT "view_users.py" executed without error for user named "Admin".
127.0.0.1 - - [11/Sep/2021 19:33:33] "POST /api/scripts/view_users.py HTTP/1.1" 200 113
[2021-09-11 19:33:33] DEBUG(10)        Request (POST) from 127.0.0.1 on /api/scripts/view_users.py.
[2021-09-11 19:33:33] INFO(20)         Run authentication script.
[2021-09-11 19:33:33] DEBUG(10)        SCRIPT "auth.py" executed without error for user named "Not Authenticated".
[2021-09-11 19:33:33] INFO(20)         Admin get access to category Administration (['*'])
[2021-09-11 19:33:34] INFO(20)         Command: ['python3', './scripts/account/view_users.py', '--names', '\n', 'cat', ' ', '/etc/passwd', '\n']
[2021-09-11 19:33:34] DEBUG(10)        SCRIPT "view_users.py" executed without error for user named "Admin".
127.0.0.1 - - [11/Sep/2021 19:33:34] "POST /api/scripts/view_users.py HTTP/1.1" 200 113
[2021-09-11 19:33:34] DEBUG(10)        Request (POST) from 127.0.0.1 on /api/scripts/view_users.py.
[2021-09-11 19:33:34] INFO(20)         Run authentication script.
[2021-09-11 19:33:35] DEBUG(10)        SCRIPT "auth.py" executed without error for user named "Not Authenticated".
[2021-09-11 19:33:35] INFO(20)         Admin get access to category Administration (['*'])
[2021-09-11 19:33:35] INFO(20)         Command: ['python3', './scripts/account/view_users.py', '--names', '/etc/passwd']
[2021-09-11 19:33:35] DEBUG(10)        SCRIPT "view_users.py" executed without error for user named "Admin".
127.0.0.1 - - [11/Sep/2021 19:33:35] "POST /api/scripts/view_users.py HTTP/1.1" 200 113
[2021-09-11 19:33:35] DEBUG(10)        Request (POST) from 127.0.0.1 on /api/scripts/view_users.py.
[2021-09-11 19:33:35] INFO(20)         Run authentication script.
[2021-09-11 19:33:36] DEBUG(10)        SCRIPT "auth.py" executed without error for user named "Not Authenticated".
[2021-09-11 19:33:36] INFO(20)         Admin get access to category Administration (['*'])
[2021-09-11 19:33:36] INFO(20)         Command: ['python3', './scripts/account/view_users.py', '--names', '/etc/passwd']
[2021-09-11 19:33:36] DEBUG(10)        SCRIPT "view_users.py" executed without error for user named "Admin".
127.0.0.1 - - [11/Sep/2021 19:33:36] "POST /api/scripts/view_users.py HTTP/1.1" 200 113
[2021-09-11 19:33:36] DEBUG(10)        Request (POST) from 127.0.0.1 on /api/scripts/view_users.py.
[2021-09-11 19:33:36] INFO(20)         Run authentication script.
[2021-09-11 19:33:37] DEBUG(10)        SCRIPT "auth.py" executed without error for user named "Not Authenticated".
[2021-09-11 19:33:37] INFO(20)         Admin get access to category Administration (['*'])
[2021-09-11 19:33:38] INFO(20)         Command: ['python3', './scripts/account/view_users.py', '--names', '.|./.|./.|./.|./.|./.|./.|./.|./.|./.|./.|./.|./etc/passwd']
[2021-09-11 19:33:38] DEBUG(10)        SCRIPT "view_users.py" executed without error for user named "Admin".
127.0.0.1 - - [11/Sep/2021 19:33:38] "POST /api/scripts/view_users.py HTTP/1.1" 200 113
[2021-09-11 19:33:38] DEBUG(10)        Request (POST) from 127.0.0.1 on /api/scripts/view_users.py.
[2021-09-11 19:33:38] INFO(20)         Run authentication script.
[2021-09-11 19:33:38] DEBUG(10)        SCRIPT "auth.py" executed without error for user named "Not Authenticated".
[2021-09-11 19:33:38] INFO(20)         Admin get access to category Administration (['*'])
[2021-09-11 19:33:39] INFO(20)         Command: ['python3', './scripts/account/view_users.py', '--names', '.|./.|./.|./.|./.|./.|./.|./.|./.|./.|./.|./.|./etc/passwd']
[2021-09-11 19:33:39] DEBUG(10)        SCRIPT "view_users.py" executed without error for user named "Admin".
127.0.0.1 - - [11/Sep/2021 19:33:39] "POST /api/scripts/view_users.py HTTP/1.1" 200 113
[2021-09-11 19:33:39] DEBUG(10)        Request (POST) from 127.0.0.1 on /api/scripts/view_users.py.
[2021-09-11 19:33:39] INFO(20)         Run authentication script.
[2021-09-11 19:33:40] DEBUG(10)        SCRIPT "auth.py" executed without error for user named "Not Authenticated".
[2021-09-11 19:33:40] INFO(20)         Admin get access to category Administration (['*'])
[2021-09-11 19:33:40] INFO(20)         Command: ['python3', './scripts/account/view_users.py', '--names', '../../../../../../../bin/cat', ' ', '/etc/passwd', '|']
[2021-09-11 19:33:40] DEBUG(10)        SCRIPT "view_users.py" executed without error for user named "Admin".
127.0.0.1 - - [11/Sep/2021 19:33:40] "POST /api/scripts/view_users.py HTTP/1.1" 200 113
[2021-09-11 19:33:40] DEBUG(10)        Request (POST) from 127.0.0.1 on /api/scripts/view_users.py.
[2021-09-11 19:33:40] INFO(20)         Run authentication script.
[2021-09-11 19:33:41] DEBUG(10)        SCRIPT "auth.py" executed without error for user named "Not Authenticated".
[2021-09-11 19:33:41] INFO(20)         Admin get access to category Administration (['*'])
[2021-09-11 19:33:41] INFO(20)         Command: ['python3', './scripts/account/view_users.py', '--names', '../../../../../../../bin/cat', ' ', '/etc/passwd', '|']
[2021-09-11 19:33:41] DEBUG(10)        SCRIPT "view_users.py" executed without error for user named "Admin".
127.0.0.1 - - [11/Sep/2021 19:33:41] "POST /api/scripts/view_users.py HTTP/1.1" 200 113
[2021-09-11 19:33:41] DEBUG(10)        Request (POST) from 127.0.0.1 on /api/scripts/view_users.py.
[2021-09-11 19:33:41] INFO(20)         Run authentication script.
[2021-09-11 19:33:42] DEBUG(10)        SCRIPT "auth.py" executed without error for user named "Not Authenticated".
[2021-09-11 19:33:42] INFO(20)         Admin get access to category Administration (['*'])
[2021-09-11 19:33:43] INFO(20)         Command: ['python3', './scripts/account/view_users.py', '--names', '"', ';', 'system(cat /etc/passwd);']
[2021-09-11 19:33:43] DEBUG(10)        SCRIPT "view_users.py" executed without error for user named "Admin".
127.0.0.1 - - [11/Sep/2021 19:33:43] "POST /api/scripts/view_users.py HTTP/1.1" 200 113
[2021-09-11 19:33:43] DEBUG(10)        Request (POST) from 127.0.0.1 on /api/scripts/view_users.py.
[2021-09-11 19:33:43] INFO(20)         Run authentication script.
[2021-09-11 19:33:43] DEBUG(10)        SCRIPT "auth.py" executed without error for user named "Not Authenticated".
[2021-09-11 19:33:43] INFO(20)         Admin get access to category Administration (['*'])
[2021-09-11 19:33:44] INFO(20)         Command: ['python3', './scripts/account/view_users.py', '--names', '"', ';', 'system(cat /etc/passwd);']
[2021-09-11 19:33:44] DEBUG(10)        SCRIPT "view_users.py" executed without error for user named "Admin".
127.0.0.1 - - [11/Sep/2021 19:33:44] "POST /api/scripts/view_users.py HTTP/1.1" 200 113
[2021-09-11 19:33:44] DEBUG(10)        Request (POST) from 127.0.0.1 on /api/scripts/view_users.py.
[2021-09-11 19:33:44] INFO(20)         Run authentication script.
[2021-09-11 19:33:45] DEBUG(10)        SCRIPT "auth.py" executed without error for user named "Not Authenticated".
[2021-09-11 19:33:45] INFO(20)         Admin get access to category Administration (['*'])
[2021-09-11 19:33:45] INFO(20)         Command: ['python3', './scripts/account/view_users.py', '--names', '`cat /etc/passwd`']
[2021-09-11 19:33:45] DEBUG(10)        SCRIPT "view_users.py" executed without error for user named "Admin".
127.0.0.1 - - [11/Sep/2021 19:33:45] "POST /api/scripts/view_users.py HTTP/1.1" 200 113
[2021-09-11 19:33:45] DEBUG(10)        Request (POST) from 127.0.0.1 on /api/scripts/view_users.py.
[2021-09-11 19:33:45] INFO(20)         Run authentication script.
[2021-09-11 19:33:46] DEBUG(10)        SCRIPT "auth.py" executed without error for user named "Not Authenticated".
[2021-09-11 19:33:46] INFO(20)         Admin get access to category Administration (['*'])
[2021-09-11 19:33:46] INFO(20)         Command: ['python3', './scripts/account/view_users.py', '--names', '`cat /etc/passwd`']
[2021-09-11 19:33:46] DEBUG(10)        SCRIPT "view_users.py" executed without error for user named "Admin".
127.0.0.1 - - [11/Sep/2021 19:33:46] "POST /api/scripts/view_users.py HTTP/1.1" 200 113
[2021-09-11 19:33:46] DEBUG(10)        Request (POST) from 127.0.0.1 on /api/scripts/view_users.py.
[2021-09-11 19:33:46] INFO(20)         Run authentication script.
[2021-09-11 19:33:47] DEBUG(10)        SCRIPT "auth.py" executed without error for user named "Not Authenticated".
[2021-09-11 19:33:47] INFO(20)         Admin get access to category Administration (['*'])
[2021-09-11 19:33:48] INFO(20)         Command: ['python3', './scripts/account/view_users.py', '--names', ';', "system('cat /etc/passwd')"]
[2021-09-11 19:33:48] DEBUG(10)        SCRIPT "view_users.py" executed without error for user named "Admin".
127.0.0.1 - - [11/Sep/2021 19:33:48] "POST /api/scripts/view_users.py HTTP/1.1" 200 113
[2021-09-11 19:33:48] DEBUG(10)        Request (POST) from 127.0.0.1 on /api/scripts/view_users.py.
[2021-09-11 19:33:48] INFO(20)         Run authentication script.
[2021-09-11 19:33:48] DEBUG(10)        SCRIPT "auth.py" executed without error for user named "Not Authenticated".
[2021-09-11 19:33:48] INFO(20)         Admin get access to category Administration (['*'])
[2021-09-11 19:33:49] INFO(20)         Command: ['python3', './scripts/account/view_users.py', '--names', ';', "system('cat /etc/passwd')"]
[2021-09-11 19:33:49] DEBUG(10)        SCRIPT "view_users.py" executed without error for user named "Admin".
127.0.0.1 - - [11/Sep/2021 19:33:49] "POST /api/scripts/view_users.py HTTP/1.1" 200 113
[2021-09-11 19:33:49] DEBUG(10)        Request (POST) from 127.0.0.1 on /api/scripts/view_users.py.
[2021-09-11 19:33:49] INFO(20)         Run authentication script.
[2021-09-11 19:33:50] DEBUG(10)        SCRIPT "auth.py" executed without error for user named "Not Authenticated".
[2021-09-11 19:33:50] INFO(20)         Admin get access to category Administration (['*'])
[2021-09-11 19:33:50] INFO(20)         Command: ['python3', './scripts/account/view_users.py', '--names', '&&', "system('cat /etc/passwd')"]
[2021-09-11 19:33:50] DEBUG(10)        SCRIPT "view_users.py" executed without error for user named "Admin".
127.0.0.1 - - [11/Sep/2021 19:33:50] "POST /api/scripts/view_users.py HTTP/1.1" 200 113
[2021-09-11 19:33:50] DEBUG(10)        Request (POST) from 127.0.0.1 on /api/scripts/view_users.py.
[2021-09-11 19:33:50] INFO(20)         Run authentication script.
[2021-09-11 19:33:51] DEBUG(10)        SCRIPT "auth.py" executed without error for user named "Not Authenticated".
[2021-09-11 19:33:51] INFO(20)         Admin get access to category Administration (['*'])
[2021-09-11 19:33:51] INFO(20)         Command: ['python3', './scripts/account/view_users.py', '--names', '&&', "system('cat /etc/passwd')"]
[2021-09-11 19:33:51] DEBUG(10)        SCRIPT "view_users.py" executed without error for user named "Admin".
127.0.0.1 - - [11/Sep/2021 19:33:51] "POST /api/scripts/view_users.py HTTP/1.1" 200 113
[2021-09-11 19:33:51] DEBUG(10)        Request (POST) from 127.0.0.1 on /api/scripts/view_users.py.
[2021-09-11 19:33:52] INFO(20)         Run authentication script.
[2021-09-11 19:33:52] DEBUG(10)        SCRIPT "auth.py" executed without error for user named "Not Authenticated".
[2021-09-11 19:33:52] INFO(20)         Admin get access to category Administration (['*'])
[2021-09-11 19:33:53] INFO(20)         Command: ['python3', './scripts/account/view_users.py', '--names', '|', "system('cat /etc/passwd')"]
[2021-09-11 19:33:53] DEBUG(10)        SCRIPT "view_users.py" executed without error for user named "Admin".
127.0.0.1 - - [11/Sep/2021 19:33:53] "POST /api/scripts/view_users.py HTTP/1.1" 200 113
[2021-09-11 19:33:53] DEBUG(10)        Request (POST) from 127.0.0.1 on /api/scripts/view_users.py.
[2021-09-11 19:33:53] INFO(20)         Run authentication script.
[2021-09-11 19:33:53] DEBUG(10)        SCRIPT "auth.py" executed without error for user named "Not Authenticated".
[2021-09-11 19:33:53] INFO(20)         Admin get access to category Administration (['*'])
[2021-09-11 19:33:54] INFO(20)         Command: ['python3', './scripts/account/view_users.py', '--names', '|', "system('cat /etc/passwd')"]
[2021-09-11 19:33:54] DEBUG(10)        SCRIPT "view_users.py" executed without error for user named "Admin".
127.0.0.1 - - [11/Sep/2021 19:33:54] "POST /api/scripts/view_users.py HTTP/1.1" 200 113
[2021-09-11 19:33:54] DEBUG(10)        Request (POST) from 127.0.0.1 on /api/scripts/view_users.py.
[2021-09-11 19:33:54] INFO(20)         Run authentication script.
[2021-09-11 19:33:55] DEBUG(10)        SCRIPT "auth.py" executed without error for user named "Not Authenticated".
[2021-09-11 19:33:55] INFO(20)         Admin get access to category Administration (['*'])
[2021-09-11 19:33:55] INFO(20)         Command: ['python3', './scripts/account/view_users.py', '--names', '|', "system('cat /etc/passwd');"]
[2021-09-11 19:33:55] DEBUG(10)        SCRIPT "view_users.py" executed without error for user named "Admin".
127.0.0.1 - - [11/Sep/2021 19:33:55] "POST /api/scripts/view_users.py HTTP/1.1" 200 113
[2021-09-11 19:33:55] DEBUG(10)        Request (POST) from 127.0.0.1 on /api/scripts/view_users.py.
[2021-09-11 19:33:55] INFO(20)         Run authentication script.
[2021-09-11 19:33:56] DEBUG(10)        SCRIPT "auth.py" executed without error for user named "Not Authenticated".
[2021-09-11 19:33:56] INFO(20)         Admin get access to category Administration (['*'])
[2021-09-11 19:33:57] INFO(20)         Command: ['python3', './scripts/account/view_users.py', '--names', '|', "system('cat /etc/passwd');"]
[2021-09-11 19:33:57] DEBUG(10)        SCRIPT "view_users.py" executed without error for user named "Admin".
127.0.0.1 - - [11/Sep/2021 19:33:57] "POST /api/scripts/view_users.py HTTP/1.1" 200 113
[2021-09-11 19:33:57] DEBUG(10)        Request (POST) from 127.0.0.1 on /api/scripts/view_users.py.
[2021-09-11 19:33:57] INFO(20)         Run authentication script.
[2021-09-11 19:33:57] DEBUG(10)        SCRIPT "auth.py" executed without error for user named "Not Authenticated".
[2021-09-11 19:33:57] INFO(20)         Admin get access to category Administration (['*'])
[2021-09-11 19:33:58] INFO(20)         Command: ['python3', './scripts/account/view_users.py', '--names', 'perl', ' ', '-e"system(\'cat /etc/passwd\');"', "\n'"]
[2021-09-11 19:33:58] DEBUG(10)        SCRIPT "view_users.py" executed without error for user named "Admin".
127.0.0.1 - - [11/Sep/2021 19:33:58] "POST /api/scripts/view_users.py HTTP/1.1" 200 113
[2021-09-11 19:33:58] DEBUG(10)        Request (POST) from 127.0.0.1 on /api/scripts/view_users.py.
[2021-09-11 19:33:58] INFO(20)         Run authentication script.
[2021-09-11 19:33:58] DEBUG(10)        SCRIPT "auth.py" executed without error for user named "Not Authenticated".
[2021-09-11 19:33:58] INFO(20)         Admin get access to category Administration (['*'])
[2021-09-11 19:33:59] INFO(20)         Command: ['python3', './scripts/account/view_users.py', '--names', 'perl', ' ', '-e"system(\'cat /etc/passwd\');"', "\n'"]
[2021-09-11 19:33:59] DEBUG(10)        SCRIPT "view_users.py" executed without error for user named "Admin".
127.0.0.1 - - [11/Sep/2021 19:33:59] "POST /api/scripts/view_users.py HTTP/1.1" 200 113
[2021-09-11 19:33:59] DEBUG(10)        Request (POST) from 127.0.0.1 on /api/scripts/view_users.py.
[2021-09-11 19:33:59] INFO(20)         Run authentication script.
[2021-09-11 19:34:00] DEBUG(10)        SCRIPT "auth.py" executed without error for user named "Not Authenticated".
[2021-09-11 19:34:00] INFO(20)         Admin get access to category Administration (['*'])
[2021-09-11 19:34:00] INFO(20)         Command: ['python3', './scripts/account/view_users.py', '--names', '/bin/cat', '/etc/passwd', '|', "'\n'"]
[2021-09-11 19:34:00] DEBUG(10)        SCRIPT "view_users.py" executed without error for user named "Admin".
127.0.0.1 - - [11/Sep/2021 19:34:00] "POST /api/scripts/view_users.py HTTP/1.1" 200 113
[2021-09-11 19:34:00] DEBUG(10)        Request (POST) from 127.0.0.1 on /api/scripts/view_users.py.
[2021-09-11 19:34:00] INFO(20)         Run authentication script.
[2021-09-11 19:34:01] DEBUG(10)        SCRIPT "auth.py" executed without error for user named "Not Authenticated".
[2021-09-11 19:34:01] INFO(20)         Admin get access to category Administration (['*'])
[2021-09-11 19:34:02] INFO(20)         Command: ['python3', './scripts/account/view_users.py', '--names', '/bin/cat', '/etc/passwd', '|', "'\n'"]
[2021-09-11 19:34:02] DEBUG(10)        SCRIPT "view_users.py" executed without error for user named "Admin".
127.0.0.1 - - [11/Sep/2021 19:34:02] "POST /api/scripts/view_users.py HTTP/1.1" 200 113
[2021-09-11 19:34:02] DEBUG(10)        Request (POST) from 127.0.0.1 on /api/scripts/view_users.py.
[2021-09-11 19:34:02] INFO(20)         Run authentication script.
[2021-09-11 19:34:02] DEBUG(10)        SCRIPT "auth.py" executed without error for user named "Not Authenticated".
[2021-09-11 19:34:02] INFO(20)         Admin get access to category Administration (['*'])
[2021-09-11 19:34:03] INFO(20)         Command: ['python3', './scripts/account/view_users.py', '--names', '/bin/cat', '/etc/passwd', "|'"]
[2021-09-11 19:34:03] DEBUG(10)        SCRIPT "view_users.py" executed without error for user named "Admin".
127.0.0.1 - - [11/Sep/2021 19:34:03] "POST /api/scripts/view_users.py HTTP/1.1" 200 113
[2021-09-11 19:34:03] DEBUG(10)        Request (POST) from 127.0.0.1 on /api/scripts/view_users.py.
[2021-09-11 19:34:03] INFO(20)         Run authentication script.
[2021-09-11 19:34:03] DEBUG(10)        SCRIPT "auth.py" executed without error for user named "Not Authenticated".
[2021-09-11 19:34:03] INFO(20)         Admin get access to category Administration (['*'])
[2021-09-11 19:34:04] INFO(20)         Command: ['python3', './scripts/account/view_users.py', '--names', '/bin/cat', '/etc/passwd', "|'"]
[2021-09-11 19:34:04] DEBUG(10)        SCRIPT "view_users.py" executed without error for user named "Admin".
127.0.0.1 - - [11/Sep/2021 19:34:04] "POST /api/scripts/view_users.py HTTP/1.1" 200 113
[2021-09-11 19:34:04] DEBUG(10)        Request (POST) from 127.0.0.1 on /api/scripts/view_users.py.
[2021-09-11 19:34:04] INFO(20)         Run authentication script.
[2021-09-11 19:34:05] DEBUG(10)        SCRIPT "auth.py" executed without error for user named "Not Authenticated".
[2021-09-11 19:34:05] INFO(20)         Admin get access to category Administration (['*'])
[2021-09-11 19:34:05] INFO(20)         Command: ['python3', './scripts/account/view_users.py', '--names', 'system("cat /etc/passwd")', ';', 'die']
[2021-09-11 19:34:05] DEBUG(10)        SCRIPT "view_users.py" executed without error for user named "Admin".
127.0.0.1 - - [11/Sep/2021 19:34:05] "POST /api/scripts/view_users.py HTTP/1.1" 200 113
[2021-09-11 19:34:05] DEBUG(10)        Request (POST) from 127.0.0.1 on /api/scripts/view_users.py.
[2021-09-11 19:34:05] INFO(20)         Run authentication script.
[2021-09-11 19:34:06] DEBUG(10)        SCRIPT "auth.py" executed without error for user named "Not Authenticated".
[2021-09-11 19:34:06] INFO(20)         Admin get access to category Administration (['*'])
[2021-09-11 19:34:07] INFO(20)         Command: ['python3', './scripts/account/view_users.py', '--names', 'system("cat /etc/passwd")', ';', 'die']
[2021-09-11 19:34:07] DEBUG(10)        SCRIPT "view_users.py" executed without error for user named "Admin".
127.0.0.1 - - [11/Sep/2021 19:34:07] "POST /api/scripts/view_users.py HTTP/1.1" 200 113
[2021-09-11 19:34:07] DEBUG(10)        Request (POST) from 127.0.0.1 on /api/scripts/view_users.py.
[2021-09-11 19:34:07] INFO(20)         Run authentication script.
[2021-09-11 19:34:07] DEBUG(10)        SCRIPT "auth.py" executed without error for user named "Not Authenticated".
[2021-09-11 19:34:07] INFO(20)         Admin get access to category Administration (['*'])
[2021-09-11 19:34:08] INFO(20)         Command: ['python3', './scripts/account/view_users.py', '--names', '";cat /etc/passwd;echo "']
[2021-09-11 19:34:08] DEBUG(10)        SCRIPT "view_users.py" executed without error for user named "Admin".
127.0.0.1 - - [11/Sep/2021 19:34:08] "POST /api/scripts/view_users.py HTTP/1.1" 200 113
[2021-09-11 19:34:08] DEBUG(10)        Request (POST) from 127.0.0.1 on /api/scripts/view_users.py.
[2021-09-11 19:34:08] INFO(20)         Run authentication script.
[2021-09-11 19:34:08] DEBUG(10)        SCRIPT "auth.py" executed without error for user named "Not Authenticated".
[2021-09-11 19:34:08] INFO(20)         Admin get access to category Administration (['*'])
[2021-09-11 19:34:09] INFO(20)         Command: ['python3', './scripts/account/view_users.py', '--names', '";cat /etc/passwd;echo "']
[2021-09-11 19:34:09] DEBUG(10)        SCRIPT "view_users.py" executed without error for user named "Admin".
127.0.0.1 - - [11/Sep/2021 19:34:09] "POST /api/scripts/view_users.py HTTP/1.1" 200 113
```

## Dirb

```bash
dirb http://127.0.0.1:8000/ -u Admin:Admin
```

```text
-----------------
DIRB v2.22    
By The Dark Raver
-----------------

START_TIME: Thu Dec  2 15:27:16 2021
URL_BASE: http://127.0.0.1:8000/
WORDLIST_FILES: /usr/share/dirb/wordlists/common.txt
AUTHORIZATION: Admin:abc

-----------------

GENERATED WORDS: 4612                                                          

---- Scanning URL: http://127.0.0.1:8000/ ----
                                                                                                                                                            
-----------------
END_TIME: Thu Dec  2 15:46:18 2021
DOWNLOADED: 4612 - FOUND: 0
```

## Nikto

```bash
nikto -o nikto.json -Format json -Tuning x -evasion 12345678AB -id Admin:Admin -C all -h http://127.0.0.1:8000/
```

```text
- Nikto v2.1.6
---------------------------------------------------------------------------
+ Target IP:          127.0.0.1
+ Target Hostname:    127.0.0.1
+ Target Port:        8000
+ Using Encoding:     Random URI encoding (non-UTF8)
+ Using Encoding:     Directory self-reference (/./)
+ Using Encoding:     Premature URL ending
+ Using Encoding:     Prepend long random string
+ Using Encoding:     Fake parameter
+ Using Encoding:     TAB as request spacer
+ Using Encoding:     Change the case of the URL
+ Using Encoding:     Use Windows directory separator (\)
+ Start Time:         2021-12-03 12:47:37 (GMT-5)
---------------------------------------------------------------------------
+ Server: WebScripts 2.4.1
+ Retrieved x-server header: WebScripts
+ Uncommon header 'cross-origin-embedder-policy' found, with contents: require-corp
+ Uncommon header 'clear-site-data' found, with contents: "cache", "executionContexts"
+ Uncommon header 'cross-origin-opener-policy' found, with contents: same-origin
+ Uncommon header 'cross-origin-resource-policy' found, with contents: same-origin
+ Uncommon header 'x-server' found, with contents: WebScripts
+ Uncommon header 'feature-policy' found, with contents: payment 'none'; geolocation 'none'; microphone 'none'; camera 'none'
+ Uncommon header 'permissions-policy' found, with contents: microphone=(),camera=(),payment=(),geolocation=()
+ Server banner has changed from 'WebScripts 2.4.1' to 'WSGIServer/0.2 Python/3.9.7' which may suggest a WAF, load balancer or proxy is in place
+ /oem_webstage/cgi-bin/oemapp_cgi: Oracle reveals the CGI source by prepending /oem_webstage to CGI URLs.
+ ERROR: Error limit (20) reached for host, giving up. Last error: 
+ Scan terminated:  0 error(s) and 9 item(s) reported on remote host
+ End Time:           2021-12-03 12:49:57 (GMT-5) (140 seconds)
---------------------------------------------------------------------------
+ 1 host(s) tested
```

```json
{
    "host": "127.0.0.1",
    "ip": "127.0.0.1",
    "port": "8000",
    "banner": "WebScripts 2.4.1",
    "vulnerabilities": [
        {
            "id": "999986",
            "OSVDB": "0",
            "method": "GET",
            "url": "/%20HTTP/1.1%0d%0aAccept%3a%20oxw9HEwpyxmV2/../../T2GQ3MuzjdQpg.html%3FAgq1KOQ0QDNI6o5c=/../%2f.\\E%32%42v%43jy%73q%78lJN%53%4b%79%50W%33%452%62%76c%6ay%73%51%58lJ%4eSK%59P%57%33E%32%62vCjysQxLjNsk%59pw3e%32%42V%63%4aYSQ%78%4cj%4e%53kY%70%77%33E%32%62%76%63JY%53qxlJNsk%79%50w3%45%32Bvcjy%73%51%78%4cJNsKY%50%573%452%42%56cj%59%73qx%4cjN%73k%79%50%57%33E%32%62%76C%4a%79SQX%4cJn%53%6byP%57%33E%32%62VcJ%59s%51%58LJN%73K%59%70W%33e%32%42%56%63j%79%73q%78%6cjN%73K%59%50%773e2bV%63jYs%71X%6c%4a%6eS%6b%79%50%573E%32b%76%63j%79%53%71xlj%6es%6by%50%77%33%65%32b%56C%6a%79s%51X%4cjn%73KYP%57%33%65%32b%76c%4aySq%58l%4an%73%4bY%50%77%33e2%42%76C%6aY%73q%78%6cJNSK%59%70%573%652%62V%43J%59SQ%78%6c%6a%6e%73KyP%57%33E2b%56%63%4a%79%53q%58%6cj%6e%73Ky%70w3%45%32%62V%43JY%53%71%78%6cj%6e%73%6b%59p%573%65%32%62%76%43j%59%73Q%78l%6an%53k%59P%573%45%32bvCJ%59%73qxljns%6bYPw%33%452bvCj%59s%51%78%6c%4a%4e%53K%79pW3%652B%76c%4aY%53q%58LJ%6e%73%4by%50%773e%32bvCjYsq%58L%4anSkY%70w3%65%32B%76%63J%59s%71%58l%6a%4e%73k%59%70%773E%32%42%56CjY%73q%78%4cj%4e%53K%79Pw%33%452%42V%43%6a%59%73%51%78lJn%73kY%70W3%652%42Vc%6a%59%73QXl%6aN%53%4b%79P%77%33%5c.\\..%5c%2e/",
            "msg": "Retrieved x-server header: WebScripts"
        },
        {
            "id": "999100",
            "OSVDB": "0",
            "method": "GET",
            "url": "/%20HTTP/1.1%0d%0aAccept%3a%20oxw9HEwpyxmV2/../../T2GQ3MuzjdQpg.html%3FAgq1KOQ0QDNI6o5c=/../%2f.\\E%32%42v%43jy%73q%78lJN%53%4b%79%50W%33%452%62%76c%6ay%73%51%58lJ%4eSK%59P%57%33E%32%62vCjysQxLjNsk%59pw3e%32%42V%63%4aYSQ%78%4cj%4e%53kY%70%77%33E%32%62%76%63JY%53qxlJNsk%79%50w3%45%32Bvcjy%73%51%78%4cJNsKY%50%573%452%42%56cj%59%73qx%4cjN%73k%79%50%57%33E%32%62%76C%4a%79SQX%4cJn%53%6byP%57%33E%32%62VcJ%59s%51%58LJN%73K%59%70W%33e%32%42%56%63j%79%73q%78%6cjN%73K%59%50%773e2bV%63jYs%71X%6c%4a%6eS%6b%79%50%573E%32b%76%63j%79%53%71xlj%6es%6by%50%77%33%65%32b%56C%6a%79s%51X%4cjn%73KYP%57%33%65%32b%76c%4aySq%58l%4an%73%4bY%50%77%33e2%42%76C%6aY%73q%78%6cJNSK%59%70%573%652%62V%43J%59SQ%78%6c%6a%6e%73KyP%57%33E2b%56%63%4a%79%53q%58%6cj%6e%73Ky%70w3%45%32%62V%43JY%53%71%78%6cj%6e%73%6b%59p%573%65%32%62%76%43j%59%73Q%78l%6an%53k%59P%573%45%32bvCJ%59%73qxljns%6bYPw%33%452bvCj%59s%51%78%6c%4a%4e%53K%79pW3%652B%76c%4aY%53q%58LJ%6e%73%4by%50%773e%32bvCjYsq%58L%4anSkY%70w3%65%32B%76%63J%59s%71%58l%6a%4e%73k%59%70%773E%32%42%56CjY%73q%78%4cj%4e%53K%79Pw%33%452%42V%43%6a%59%73%51%78lJn%73kY%70W3%652%42Vc%6a%59%73QXl%6aN%53%4b%79P%77%33%5c.\\..%5c%2e/",
            "msg": "Uncommon header 'permissions-policy' found, with contents: microphone=(),camera=(),payment=(),geolocation=()"
        },
        {
            "id": "999100",
            "OSVDB": "0",
            "method": "GET",
            "url": "/%20HTTP/1.1%0d%0aAccept%3a%20oxw9HEwpyxmV2/../../T2GQ3MuzjdQpg.html%3FAgq1KOQ0QDNI6o5c=/../%2f.\\E%32%42v%43jy%73q%78lJN%53%4b%79%50W%33%452%62%76c%6ay%73%51%58lJ%4eSK%59P%57%33E%32%62vCjysQxLjNsk%59pw3e%32%42V%63%4aYSQ%78%4cj%4e%53kY%70%77%33E%32%62%76%63JY%53qxlJNsk%79%50w3%45%32Bvcjy%73%51%78%4cJNsKY%50%573%452%42%56cj%59%73qx%4cjN%73k%79%50%57%33E%32%62%76C%4a%79SQX%4cJn%53%6byP%57%33E%32%62VcJ%59s%51%58LJN%73K%59%70W%33e%32%42%56%63j%79%73q%78%6cjN%73K%59%50%773e2bV%63jYs%71X%6c%4a%6eS%6b%79%50%573E%32b%76%63j%79%53%71xlj%6es%6by%50%77%33%65%32b%56C%6a%79s%51X%4cjn%73KYP%57%33%65%32b%76c%4aySq%58l%4an%73%4bY%50%77%33e2%42%76C%6aY%73q%78%6cJNSK%59%70%573%652%62V%43J%59SQ%78%6c%6a%6e%73KyP%57%33E2b%56%63%4a%79%53q%58%6cj%6e%73Ky%70w3%45%32%62V%43JY%53%71%78%6cj%6e%73%6b%59p%573%65%32%62%76%43j%59%73Q%78l%6an%53k%59P%573%45%32bvCJ%59%73qxljns%6bYPw%33%452bvCj%59s%51%78%6c%4a%4e%53K%79pW3%652B%76c%4aY%53q%58LJ%6e%73%4by%50%773e%32bvCjYsq%58L%4anSkY%70w3%65%32B%76%63J%59s%71%58l%6a%4e%73k%59%70%773E%32%42%56CjY%73q%78%4cj%4e%53K%79Pw%33%452%42V%43%6a%59%73%51%78lJn%73kY%70W3%652%42Vc%6a%59%73QXl%6aN%53%4b%79P%77%33%5c.\\..%5c%2e/",
            "msg": "Uncommon header 'cross-origin-embedder-policy' found, with contents: require-corp"
        },
        {
            "id": "999100",
            "OSVDB": "0",
            "method": "GET",
            "url": "/%20HTTP/1.1%0d%0aAccept%3a%20oxw9HEwpyxmV2/../../T2GQ3MuzjdQpg.html%3FAgq1KOQ0QDNI6o5c=/../%2f.\\E%32%42v%43jy%73q%78lJN%53%4b%79%50W%33%452%62%76c%6ay%73%51%58lJ%4eSK%59P%57%33E%32%62vCjysQxLjNsk%59pw3e%32%42V%63%4aYSQ%78%4cj%4e%53kY%70%77%33E%32%62%76%63JY%53qxlJNsk%79%50w3%45%32Bvcjy%73%51%78%4cJNsKY%50%573%452%42%56cj%59%73qx%4cjN%73k%79%50%57%33E%32%62%76C%4a%79SQX%4cJn%53%6byP%57%33E%32%62VcJ%59s%51%58LJN%73K%59%70W%33e%32%42%56%63j%79%73q%78%6cjN%73K%59%50%773e2bV%63jYs%71X%6c%4a%6eS%6b%79%50%573E%32b%76%63j%79%53%71xlj%6es%6by%50%77%33%65%32b%56C%6a%79s%51X%4cjn%73KYP%57%33%65%32b%76c%4aySq%58l%4an%73%4bY%50%77%33e2%42%76C%6aY%73q%78%6cJNSK%59%70%573%652%62V%43J%59SQ%78%6c%6a%6e%73KyP%57%33E2b%56%63%4a%79%53q%58%6cj%6e%73Ky%70w3%45%32%62V%43JY%53%71%78%6cj%6e%73%6b%59p%573%65%32%62%76%43j%59%73Q%78l%6an%53k%59P%573%45%32bvCJ%59%73qxljns%6bYPw%33%452bvCj%59s%51%78%6c%4a%4e%53K%79pW3%652B%76c%4aY%53q%58LJ%6e%73%4by%50%773e%32bvCjYsq%58L%4anSkY%70w3%65%32B%76%63J%59s%71%58l%6a%4e%73k%59%70%773E%32%42%56CjY%73q%78%4cj%4e%53K%79Pw%33%452%42V%43%6a%59%73%51%78lJn%73kY%70W3%652%42Vc%6a%59%73QXl%6aN%53%4b%79P%77%33%5c.\\..%5c%2e/",
            "msg": "Uncommon header 'cross-origin-opener-policy' found, with contents: same-origin"
        },
        {
            "id": "999100",
            "OSVDB": "0",
            "method": "GET",
            "url": "/%20HTTP/1.1%0d%0aAccept%3a%20oxw9HEwpyxmV2/../../T2GQ3MuzjdQpg.html%3FAgq1KOQ0QDNI6o5c=/../%2f.\\E%32%42v%43jy%73q%78lJN%53%4b%79%50W%33%452%62%76c%6ay%73%51%58lJ%4eSK%59P%57%33E%32%62vCjysQxLjNsk%59pw3e%32%42V%63%4aYSQ%78%4cj%4e%53kY%70%77%33E%32%62%76%63JY%53qxlJNsk%79%50w3%45%32Bvcjy%73%51%78%4cJNsKY%50%573%452%42%56cj%59%73qx%4cjN%73k%79%50%57%33E%32%62%76C%4a%79SQX%4cJn%53%6byP%57%33E%32%62VcJ%59s%51%58LJN%73K%59%70W%33e%32%42%56%63j%79%73q%78%6cjN%73K%59%50%773e2bV%63jYs%71X%6c%4a%6eS%6b%79%50%573E%32b%76%63j%79%53%71xlj%6es%6by%50%77%33%65%32b%56C%6a%79s%51X%4cjn%73KYP%57%33%65%32b%76c%4aySq%58l%4an%73%4bY%50%77%33e2%42%76C%6aY%73q%78%6cJNSK%59%70%573%652%62V%43J%59SQ%78%6c%6a%6e%73KyP%57%33E2b%56%63%4a%79%53q%58%6cj%6e%73Ky%70w3%45%32%62V%43JY%53%71%78%6cj%6e%73%6b%59p%573%65%32%62%76%43j%59%73Q%78l%6an%53k%59P%573%45%32bvCJ%59%73qxljns%6bYPw%33%452bvCj%59s%51%78%6c%4a%4e%53K%79pW3%652B%76c%4aY%53q%58LJ%6e%73%4by%50%773e%32bvCjYsq%58L%4anSkY%70w3%65%32B%76%63J%59s%71%58l%6a%4e%73k%59%70%773E%32%42%56CjY%73q%78%4cj%4e%53K%79Pw%33%452%42V%43%6a%59%73%51%78lJn%73kY%70W3%652%42Vc%6a%59%73QXl%6aN%53%4b%79P%77%33%5c.\\..%5c%2e/",
            "msg": "Uncommon header 'feature-policy' found, with contents: payment 'none'; geolocation 'none'; microphone 'none'; camera 'none'"
        },
        {
            "id": "999100",
            "OSVDB": "0",
            "method": "GET",
            "url": "/%20HTTP/1.1%0d%0aAccept%3a%20oxw9HEwpyxmV2/../../T2GQ3MuzjdQpg.html%3FAgq1KOQ0QDNI6o5c=/../%2f.\\E%32%42v%43jy%73q%78lJN%53%4b%79%50W%33%452%62%76c%6ay%73%51%58lJ%4eSK%59P%57%33E%32%62vCjysQxLjNsk%59pw3e%32%42V%63%4aYSQ%78%4cj%4e%53kY%70%77%33E%32%62%76%63JY%53qxlJNsk%79%50w3%45%32Bvcjy%73%51%78%4cJNsKY%50%573%452%42%56cj%59%73qx%4cjN%73k%79%50%57%33E%32%62%76C%4a%79SQX%4cJn%53%6byP%57%33E%32%62VcJ%59s%51%58LJN%73K%59%70W%33e%32%42%56%63j%79%73q%78%6cjN%73K%59%50%773e2bV%63jYs%71X%6c%4a%6eS%6b%79%50%573E%32b%76%63j%79%53%71xlj%6es%6by%50%77%33%65%32b%56C%6a%79s%51X%4cjn%73KYP%57%33%65%32b%76c%4aySq%58l%4an%73%4bY%50%77%33e2%42%76C%6aY%73q%78%6cJNSK%59%70%573%652%62V%43J%59SQ%78%6c%6a%6e%73KyP%57%33E2b%56%63%4a%79%53q%58%6cj%6e%73Ky%70w3%45%32%62V%43JY%53%71%78%6cj%6e%73%6b%59p%573%65%32%62%76%43j%59%73Q%78l%6an%53k%59P%573%45%32bvCJ%59%73qxljns%6bYPw%33%452bvCj%59s%51%78%6c%4a%4e%53K%79pW3%652B%76c%4aY%53q%58LJ%6e%73%4by%50%773e%32bvCjYsq%58L%4anSkY%70w3%65%32B%76%63J%59s%71%58l%6a%4e%73k%59%70%773E%32%42%56CjY%73q%78%4cj%4e%53K%79Pw%33%452%42V%43%6a%59%73%51%78lJn%73kY%70W3%652%42Vc%6a%59%73QXl%6aN%53%4b%79P%77%33%5c.\\..%5c%2e/",
            "msg": "Uncommon header 'clear-site-data' found, with contents: \"cache\", \"executionContexts\""
        },
        {
            "id": "999100",
            "OSVDB": "0",
            "method": "GET",
            "url": "/%20HTTP/1.1%0d%0aAccept%3a%20oxw9HEwpyxmV2/../../T2GQ3MuzjdQpg.html%3FAgq1KOQ0QDNI6o5c=/../%2f.\\E%32%42v%43jy%73q%78lJN%53%4b%79%50W%33%452%62%76c%6ay%73%51%58lJ%4eSK%59P%57%33E%32%62vCjysQxLjNsk%59pw3e%32%42V%63%4aYSQ%78%4cj%4e%53kY%70%77%33E%32%62%76%63JY%53qxlJNsk%79%50w3%45%32Bvcjy%73%51%78%4cJNsKY%50%573%452%42%56cj%59%73qx%4cjN%73k%79%50%57%33E%32%62%76C%4a%79SQX%4cJn%53%6byP%57%33E%32%62VcJ%59s%51%58LJN%73K%59%70W%33e%32%42%56%63j%79%73q%78%6cjN%73K%59%50%773e2bV%63jYs%71X%6c%4a%6eS%6b%79%50%573E%32b%76%63j%79%53%71xlj%6es%6by%50%77%33%65%32b%56C%6a%79s%51X%4cjn%73KYP%57%33%65%32b%76c%4aySq%58l%4an%73%4bY%50%77%33e2%42%76C%6aY%73q%78%6cJNSK%59%70%573%652%62V%43J%59SQ%78%6c%6a%6e%73KyP%57%33E2b%56%63%4a%79%53q%58%6cj%6e%73Ky%70w3%45%32%62V%43JY%53%71%78%6cj%6e%73%6b%59p%573%65%32%62%76%43j%59%73Q%78l%6an%53k%59P%573%45%32bvCJ%59%73qxljns%6bYPw%33%452bvCj%59s%51%78%6c%4a%4e%53K%79pW3%652B%76c%4aY%53q%58LJ%6e%73%4by%50%773e%32bvCjYsq%58L%4anSkY%70w3%65%32B%76%63J%59s%71%58l%6a%4e%73k%59%70%773E%32%42%56CjY%73q%78%4cj%4e%53K%79Pw%33%452%42V%43%6a%59%73%51%78lJn%73kY%70W3%652%42Vc%6a%59%73QXl%6aN%53%4b%79P%77%33%5c.\\..%5c%2e/",
            "msg": "Uncommon header 'x-server' found, with contents: WebScripts"
        },
        {
            "id": "999100",
            "OSVDB": "0",
            "method": "GET",
            "url": "/%20HTTP/1.1%0d%0aAccept%3a%20oxw9HEwpyxmV2/../../T2GQ3MuzjdQpg.html%3FAgq1KOQ0QDNI6o5c=/../%2f.\\E%32%42v%43jy%73q%78lJN%53%4b%79%50W%33%452%62%76c%6ay%73%51%58lJ%4eSK%59P%57%33E%32%62vCjysQxLjNsk%59pw3e%32%42V%63%4aYSQ%78%4cj%4e%53kY%70%77%33E%32%62%76%63JY%53qxlJNsk%79%50w3%45%32Bvcjy%73%51%78%4cJNsKY%50%573%452%42%56cj%59%73qx%4cjN%73k%79%50%57%33E%32%62%76C%4a%79SQX%4cJn%53%6byP%57%33E%32%62VcJ%59s%51%58LJN%73K%59%70W%33e%32%42%56%63j%79%73q%78%6cjN%73K%59%50%773e2bV%63jYs%71X%6c%4a%6eS%6b%79%50%573E%32b%76%63j%79%53%71xlj%6es%6by%50%77%33%65%32b%56C%6a%79s%51X%4cjn%73KYP%57%33%65%32b%76c%4aySq%58l%4an%73%4bY%50%77%33e2%42%76C%6aY%73q%78%6cJNSK%59%70%573%652%62V%43J%59SQ%78%6c%6a%6e%73KyP%57%33E2b%56%63%4a%79%53q%58%6cj%6e%73Ky%70w3%45%32%62V%43JY%53%71%78%6cj%6e%73%6b%59p%573%65%32%62%76%43j%59%73Q%78l%6an%53k%59P%573%45%32bvCJ%59%73qxljns%6bYPw%33%452bvCj%59s%51%78%6c%4a%4e%53K%79pW3%652B%76c%4aY%53q%58LJ%6e%73%4by%50%773e%32bvCjYsq%58L%4anSkY%70w3%65%32B%76%63J%59s%71%58l%6a%4e%73k%59%70%773E%32%42%56CjY%73q%78%4cj%4e%53K%79Pw%33%452%42V%43%6a%59%73%51%78lJn%73kY%70W3%652%42Vc%6a%59%73QXl%6aN%53%4b%79P%77%33%5c.\\..%5c%2e/",
            "msg": "Uncommon header 'cross-origin-resource-policy' found, with contents: same-origin"
        },
        {
            "id": "000257",
            "OSVDB": "0",
            "method": "GET",
            "url": "/%20HTTP/1.1%0d%0aAccept%3a%20FimWLUb8stnwdz/../../8gXgVDzS2yI.html%3Fga7z7fw4HBE=/..//.\u0006gzep%47%4eKGu%49%45Q3Qu6%67%5a%65%70%47Nkg%55%69E%51%33qu6%47%5aepgn%4b%47uIe%713%51U6%47%5aEP%67%6e%4b%47%55%69EQ%33Q%75%36%67ZE%50%47n%4b%67%75I%65Q%33%71U6gz%45%50%47nkG%55I%45Q3Q%756%67Ze%50%47N%4bG%75ie%71%33Q%55%36%47%5aePGn%6bGUie%51%33%51%556gZepg%4e%4b%47U%49%45Q%33%71%556%67ze%70%67NKG%75%49eQ%33%71U6%67Z%65PgNKGu%49E%51%33%71%75%36%47%7aEP%47%4e%6bGU%49%45q%33QU6%67Z%45PG%4e%4b%67u%69%65%713%51%756g%7aepg%4ekG%55i%65%513%51%55%36%47Z%45PgN%4b%47%75i%65q3%51%75%36%67%5aepG%4ek%47UiEq3Qu6%47Z%65%50%47%4e%6bGu%49%65q3%71%756%47%7aEP%47%6e%6bg%75%69E%71%33%71U6%67%7aE%50%67%6eKGuI%65%713%71U%36Gz%45pgnKg%55I%45q%33%51%55%36G%5a%45pg%4eKg%55IEQ%33qu6gZ%45pgNKG%55I%45%513%71U6%47%5aePGn%6b%47%55I%45Q3%51U%36%67zEp%47N%4bgUI%65Q3Q%55%36%47z%45PG%6ek%47U%49%45Q%33%71U6gze%50%67nk%47%75IEq%33Q%55%36g%7a%65%50%47%6ek%67u%49E%713%51u%36g%7aE%50GN%4b%47%75%69e%51%33q%756GzE%50%47NK%47U%49%45%51%33%71%756GZ%65Pgn%6bg%55%69E%71%33%71U%36g%7aePGn%4b%67%75%49E%513%71%556G%7aE%50G%6ek%67U%69%65Q3%71U\\%2e\\..%5c%2e%5c%6f%65M_%77EbSt%61ge\\.%5cc%47I%2dB%69n%5c.%5coe%4d%41%50%50_%43%67i",
            "msg": "/oem_webstage/cgi-bin/oemapp_cgi: Oracle reveals the CGI source by prepending /oem_webstage to CGI URLs."
        }
    ]
}
```

## ZAP

```json
{
        "@version": "2.11.0",
        "@generated": "Fri, 3 Dec 2021 13:53:50",
        "site":[ 
                {
                        "@name": "http://127.0.0.1:8000",
                        "@host": "127.0.0.1",
                        "@port": "8000",
                        "@ssl": "false",
                        "alerts": [ 
                                {
                                        "pluginid": "40028",
                                        "alertRef": "40028",
                                        "alert": "ELMAH Information Leak",
                                        "name": "ELMAH Information Leak",
                                        "riskcode": "2",
                                        "confidence": "1",
                                        "riskdesc": "Medium (Low)",
                                        "desc": "<p>The Error Logging Modules and Handlers (ELMAH [elmah.axd]) HTTP Module was found to be available. This module can leak a significant amount of valuable information.</p>",
                                        "instances":[ 
                                                {
                                                        "uri": "http://127.0.0.1:8000/elmah.axd",
                                                        "method": "GET",
                                                        "param": "",
                                                        "attack": "",
                                                        "evidence": "HTTP/1.0 301 Moved Permanently"
                                                }
                                        ],
                                        "count": "1",
                                        "solution": "<p>Consider whether or not ELMAH is actually required in production, if it isn't then disable it. If it is then ensure access to it requires authentication and authorization. See also: https://elmah.github.io/a/securing-error-log-pages/</p>",
                                        "otherinfo": "",
                                        "reference": "<p>https://www.troyhunt.com/aspnet-session-hijacking-with-google/</p><p>https://www.nuget.org/packages/elmah</p><p>https://elmah.github.io/</p>",
                                        "cweid": "94",
                                        "wascid": "14",
                                        "sourceid": "737"
                                }
                        ]
                }
        ]
}
```