import * as acmpca from 'aws-cdk-lib/aws-acmpca';
import * as ec2 from 'aws-cdk-lib/aws-ec2';
import * as kms from 'aws-cdk-lib/aws-kms';
import * as logs from 'aws-cdk-lib/aws-logs';
import * as s3 from 'aws-cdk-lib/aws-s3';
import * as core from 'aws-cdk-lib';
import * as constructs from 'constructs';
import { KafkaVersion } from './';
/**
 * (experimental) Represents a MSK Cluster.
 *
 * @experimental
 */
export interface ICluster extends core.IResource, ec2.IConnectable {
    /**
     * (experimental) The ARN of cluster.
     *
     * @experimental
     * @attribute true
     */
    readonly clusterArn: string;
    /**
     * (experimental) The physical name of the cluster.
     *
     * @experimental
     * @attribute true
     */
    readonly clusterName: string;
}
/**
 * A new or imported MSK Cluster.
 */
declare abstract class ClusterBase extends core.Resource implements ICluster {
    abstract readonly clusterArn: string;
    abstract readonly clusterName: string;
    /** @internal */
    protected _connections: ec2.Connections | undefined;
    /**
     * (experimental) Manages connections for the cluster.
     *
     * @experimental
     */
    get connections(): ec2.Connections;
}
/**
 * (experimental) Properties for a MSK Cluster.
 *
 * @experimental
 */
export interface ClusterProps {
    /**
     * (experimental) The physical name of the cluster.
     *
     * @experimental
     */
    readonly clusterName: string;
    /**
     * (experimental) The version of Apache Kafka.
     *
     * @experimental
     */
    readonly kafkaVersion: KafkaVersion;
    /**
     * (experimental) Number of Apache Kafka brokers deployed in each Availability Zone.
     *
     * @default 1
     * @experimental
     */
    readonly numberOfBrokerNodes?: number;
    /**
     * (experimental) Defines the virtual networking environment for this cluster.
     *
     * Must have at least 2 subnets in two different AZs.
     *
     * @experimental
     */
    readonly vpc: ec2.IVpc;
    /**
     * (experimental) Where to place the nodes within the VPC.
     *
     * Amazon MSK distributes the broker nodes evenly across the subnets that you specify.
     * The subnets that you specify must be in distinct Availability Zones.
     * Client subnets can't be in Availability Zone us-east-1e.
     *
     * @default - the Vpc default strategy if not specified.
     * @experimental
     */
    readonly vpcSubnets?: ec2.SubnetSelection;
    /**
     * (experimental) The EC2 instance type that you want Amazon MSK to use when it creates your brokers.
     *
     * @default kafka.m5.large
     * @see https://docs.aws.amazon.com/msk/latest/developerguide/msk-create-cluster.html#broker-instance-types
     * @experimental
     */
    readonly instanceType?: ec2.InstanceType;
    /**
     * (experimental) The AWS security groups to associate with the elastic network interfaces in order to specify who can connect to and communicate with the Amazon MSK cluster.
     *
     * @default - create new security group
     * @experimental
     */
    readonly securityGroups?: ec2.ISecurityGroup[];
    /**
     * (experimental) Information about storage volumes attached to MSK broker nodes.
     *
     * @default - 1000 GiB EBS volume
     * @experimental
     */
    readonly ebsStorageInfo?: EbsStorageInfo;
    /**
     * (experimental) The Amazon MSK configuration to use for the cluster.
     *
     * @default - none
     * @experimental
     */
    readonly configurationInfo?: ClusterConfigurationInfo;
    /**
     * (experimental) Cluster monitoring configuration.
     *
     * @default - DEFAULT monitoring level
     * @experimental
     */
    readonly monitoring?: MonitoringConfiguration;
    /**
     * (experimental) Configure your MSK cluster to send broker logs to different destination types.
     *
     * @default - disabled
     * @experimental
     */
    readonly logging?: BrokerLogging;
    /**
     * (experimental) Config details for encryption in transit.
     *
     * @default - enabled
     * @experimental
     */
    readonly encryptionInTransit?: EncryptionInTransitConfig;
    /**
     * (experimental) Configuration properties for client authentication.
     *
     * MSK supports using private TLS certificates or SASL/SCRAM to authenticate the identity of clients.
     *
     * @default - disabled
     * @experimental
     */
    readonly clientAuthentication?: ClientAuthentication;
    /**
     * (experimental) What to do when this resource is deleted from a stack.
     *
     * @default RemovalPolicy.RETAIN
     * @experimental
     */
    readonly removalPolicy?: core.RemovalPolicy;
}
/**
 * (experimental) EBS volume information.
 *
 * @experimental
 */
export interface EbsStorageInfo {
    /**
     * (experimental) The size in GiB of the EBS volume for the data drive on each broker node.
     *
     * @default 1000
     * @experimental
     */
    readonly volumeSize?: number;
    /**
     * (experimental) The AWS KMS key for encrypting data at rest.
     *
     * @default Uses AWS managed CMK (aws/kafka)
     * @experimental
     */
    readonly encryptionKey?: kms.IKey;
}
/**
 * (experimental) The Amazon MSK configuration to use for the cluster.
 *
 * Note: There is currently no Cloudformation Resource to create a Configuration
 *
 * @experimental
 */
export interface ClusterConfigurationInfo {
    /**
     * (experimental) The Amazon Resource Name (ARN) of the MSK configuration to use.
     *
     * For example, arn:aws:kafka:us-east-1:123456789012:configuration/example-configuration-name/abcdabcd-1234-abcd-1234-abcd123e8e8e-1.
     *
     * @experimental
     */
    readonly arn: string;
    /**
     * (experimental) The revision of the Amazon MSK configuration to use.
     *
     * @experimental
     */
    readonly revision: number;
}
/**
 * (experimental) The level of monitoring for the MSK cluster.
 *
 * @see https://docs.aws.amazon.com/msk/latest/developerguide/monitoring.html#metrics-details
 * @experimental
 */
export declare enum ClusterMonitoringLevel {
    /**
     * (experimental) Default metrics are the essential metrics to monitor.
     *
     * @experimental
     */
    DEFAULT = "DEFAULT",
    /**
     * (experimental) Per Broker metrics give you metrics at the broker level.
     *
     * @experimental
     */
    PER_BROKER = "PER_BROKER",
    /**
     * (experimental) Per Topic Per Broker metrics help you understand volume at the topic level.
     *
     * @experimental
     */
    PER_TOPIC_PER_BROKER = "PER_TOPIC_PER_BROKER",
    /**
     * (experimental) Per Topic Per Partition metrics help you understand consumer group lag at the topic partition level.
     *
     * @experimental
     */
    PER_TOPIC_PER_PARTITION = "PER_TOPIC_PER_PARTITION"
}
/**
 * (experimental) Monitoring Configuration.
 *
 * @experimental
 */
export interface MonitoringConfiguration {
    /**
     * (experimental) Specifies the level of monitoring for the MSK cluster.
     *
     * @default DEFAULT
     * @experimental
     */
    readonly clusterMonitoringLevel?: ClusterMonitoringLevel;
    /**
     * (experimental) Indicates whether you want to enable or disable the JMX Exporter.
     *
     * @default false
     * @experimental
     */
    readonly enablePrometheusJmxExporter?: boolean;
    /**
     * (experimental) Indicates whether you want to enable or disable the Prometheus Node Exporter.
     *
     * You can use the Prometheus Node Exporter to get CPU and disk metrics for the broker nodes.
     *
     * @default false
     * @experimental
     */
    readonly enablePrometheusNodeExporter?: boolean;
}
/**
 * (experimental) Configuration details related to broker logs.
 *
 * @experimental
 */
export interface BrokerLogging {
    /**
     * (experimental) The Kinesis Data Firehose delivery stream that is the destination for broker logs.
     *
     * @default - disabled
     * @experimental
     */
    readonly firehoseDeliveryStreamName?: string;
    /**
     * (experimental) The CloudWatch Logs group that is the destination for broker logs.
     *
     * @default - disabled
     * @experimental
     */
    readonly cloudwatchLogGroup?: logs.ILogGroup;
    /**
     * (experimental) Details of the Amazon S3 destination for broker logs.
     *
     * @default - disabled
     * @experimental
     */
    readonly s3?: S3LoggingConfiguration;
}
/**
 * (experimental) Details of the Amazon S3 destination for broker logs.
 *
 * @experimental
 */
export interface S3LoggingConfiguration {
    /**
     * (experimental) The S3 bucket that is the destination for broker logs.
     *
     * @experimental
     */
    readonly bucket: s3.IBucket;
    /**
     * (experimental) The S3 prefix that is the destination for broker logs.
     *
     * @default - no prefix
     * @experimental
     */
    readonly prefix?: string;
}
/**
 * (experimental) Indicates the encryption setting for data in transit between clients and brokers.
 *
 * @experimental
 */
export declare enum ClientBrokerEncryption {
    /**
     * (experimental) TLS means that client-broker communication is enabled with TLS only.
     *
     * @experimental
     */
    TLS = "TLS",
    /**
     * (experimental) TLS_PLAINTEXT means that client-broker communication is enabled for both TLS-encrypted, as well as plaintext data.
     *
     * @experimental
     */
    TLS_PLAINTEXT = "TLS_PLAINTEXT",
    /**
     * (experimental) PLAINTEXT means that client-broker communication is enabled in plaintext only.
     *
     * @experimental
     */
    PLAINTEXT = "PLAINTEXT"
}
/**
 * (experimental) The settings for encrypting data in transit.
 *
 * @see https://docs.aws.amazon.com/msk/latest/developerguide/msk-encryption.html#msk-encryption-in-transit
 * @experimental
 */
export interface EncryptionInTransitConfig {
    /**
     * (experimental) Indicates the encryption setting for data in transit between clients and brokers.
     *
     * @default - TLS
     * @experimental
     */
    readonly clientBroker?: ClientBrokerEncryption;
    /**
     * (experimental) Indicates that data communication among the broker nodes of the cluster is encrypted.
     *
     * @default true
     * @experimental
     */
    readonly enableInCluster?: boolean;
}
/**
 * (experimental) SASL authentication properties.
 *
 * @experimental
 */
export interface SaslAuthProps {
    /**
     * (experimental) Enable SASL/SCRAM authentication.
     *
     * @default false
     * @experimental
     */
    readonly scram?: boolean;
    /**
     * (experimental) Enable IAM access control.
     *
     * @default false
     * @experimental
     */
    readonly iam?: boolean;
    /**
     * (experimental) KMS Key to encrypt SASL/SCRAM secrets.
     *
     * You must use a customer master key (CMK) when creating users in secrets manager.
     * You cannot use a Secret with Amazon MSK that uses the default Secrets Manager encryption key.
     *
     * @default - CMK will be created with alias msk/{clusterName}/sasl/scram
     * @experimental
     */
    readonly key?: kms.IKey;
}
/**
 * (experimental) TLS authentication properties.
 *
 * @experimental
 */
export interface TlsAuthProps {
    /**
     * (experimental) List of ACM Certificate Authorities to enable TLS authentication.
     *
     * @default - none
     * @experimental
     */
    readonly certificateAuthorities?: acmpca.ICertificateAuthority[];
}
/**
 * (experimental) Configuration properties for client authentication.
 *
 * @experimental
 */
export declare class ClientAuthentication {
    readonly saslProps?: SaslAuthProps | undefined;
    readonly tlsProps?: TlsAuthProps | undefined;
    /**
     * (experimental) SASL authentication.
     *
     * @experimental
     */
    static sasl(props: SaslAuthProps): ClientAuthentication;
    /**
     * (experimental) TLS authentication.
     *
     * @experimental
     */
    static tls(props: TlsAuthProps): ClientAuthentication;
    /**
     * @param saslProps - properties for SASL authentication
     * @param tlsProps - properties for TLS authentication
     */
    private constructor();
}
/**
 * (experimental) Create a MSK Cluster.
 *
 * @experimental
 * @resource AWS::MSK::Cluster
 */
export declare class Cluster extends ClusterBase {
    /**
     * (experimental) Reference an existing cluster, defined outside of the CDK code, by name.
     *
     * @experimental
     */
    static fromClusterArn(scope: constructs.Construct, id: string, clusterArn: string): ICluster;
    /**
     * (experimental) The ARN of cluster.
     *
     * @experimental
     */
    readonly clusterArn: string;
    /**
     * (experimental) The physical name of the cluster.
     *
     * @experimental
     */
    readonly clusterName: string;
    /**
     * (experimental) Key used to encrypt SASL/SCRAM users.
     *
     * @experimental
     */
    readonly saslScramAuthenticationKey?: kms.IKey;
    private _clusterDescription?;
    private _clusterBootstrapBrokers?;
    /**
     * @experimental
     */
    constructor(scope: constructs.Construct, id: string, props: ClusterProps);
    private mskInstanceType;
    /**
     * Get the ZooKeeper Connection string
     *
     * Uses a Custom Resource to make an API call to `describeCluster` using the Javascript SDK
     *
     * @param responseField Field to return from API call. eg. ZookeeperConnectString, ZookeeperConnectStringTls
     * @returns - The connection string to use to connect to the Apache ZooKeeper cluster.
     */
    private _zookeeperConnectionString;
    /**
     * (experimental) Get the ZooKeeper Connection string.
     *
     * Uses a Custom Resource to make an API call to `describeCluster` using the Javascript SDK
     *
     * @returns - The connection string to use to connect to the Apache ZooKeeper cluster.
     * @experimental
     */
    get zookeeperConnectionString(): string;
    /**
     * (experimental) Get the ZooKeeper Connection string for a TLS enabled cluster.
     *
     * Uses a Custom Resource to make an API call to `describeCluster` using the Javascript SDK
     *
     * @returns - The connection string to use to connect to zookeeper cluster on TLS port.
     * @experimental
     */
    get zookeeperConnectionStringTls(): string;
    /**
     * Get the list of brokers that a client application can use to bootstrap
     *
     * Uses a Custom Resource to make an API call to `getBootstrapBrokers` using the Javascript SDK
     *
     * @param responseField Field to return from API call. eg. BootstrapBrokerStringSaslScram, BootstrapBrokerString
     * @returns - A string containing one or more hostname:port pairs.
     */
    private _bootstrapBrokers;
    /**
     * (experimental) Get the list of brokers that a client application can use to bootstrap.
     *
     * Uses a Custom Resource to make an API call to `getBootstrapBrokers` using the Javascript SDK
     *
     * @returns - A string containing one or more hostname:port pairs.
     * @experimental
     */
    get bootstrapBrokers(): string;
    /**
     * (experimental) Get the list of brokers that a TLS authenticated client application can use to bootstrap.
     *
     * Uses a Custom Resource to make an API call to `getBootstrapBrokers` using the Javascript SDK
     *
     * @returns - A string containing one or more DNS names (or IP) and TLS port pairs.
     * @experimental
     */
    get bootstrapBrokersTls(): string;
    /**
     * (experimental) Get the list of brokers that a SASL/SCRAM authenticated client application can use to bootstrap.
     *
     * Uses a Custom Resource to make an API call to `getBootstrapBrokers` using the Javascript SDK
     *
     * @returns - A string containing one or more dns name (or IP) and SASL SCRAM port pairs.
     * @experimental
     */
    get bootstrapBrokersSaslScram(): string;
    /**
     * (experimental) A list of usersnames to register with the cluster.
     *
     * The password will automatically be generated using Secrets
     * Manager and the { username, password } JSON object stored in Secrets Manager as `AmazonMSK_username`.
     *
     * Must be using the SASL/SCRAM authentication mechanism.
     *
     * @param usernames - username(s) to register with the cluster.
     * @experimental
     */
    addUser(...usernames: string[]): void;
}
export {};
