import { Construct } from 'constructs';
import { INextable } from '../types';
import { State } from './state';
/**
 * Properties for defining a Fail state.
 *
 * @stability stable
 */
export interface FailProps {
    /**
     * An optional description for this state.
     *
     * @default No comment
     * @stability stable
     */
    readonly comment?: string;
    /**
     * Error code used to represent this failure.
     *
     * @default No error code
     * @stability stable
     */
    readonly error?: string;
    /**
     * A description for the cause of the failure.
     *
     * @default No description
     * @stability stable
     */
    readonly cause?: string;
}
/**
 * Define a Fail state in the state machine.
 *
 * Reaching a Fail state terminates the state execution in failure.
 *
 * @stability stable
 */
export declare class Fail extends State {
    /**
     * Continuable states of this Chainable.
     *
     * @stability stable
     */
    readonly endStates: INextable[];
    private readonly error?;
    private readonly cause?;
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, props?: FailProps);
    /**
     * Return the Amazon States Language object for this state.
     *
     * @stability stable
     */
    toStateJson(): object;
}
