# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['pycheckpoint_api',
 'pycheckpoint_api.management',
 'pycheckpoint_api.management.abstract',
 'pycheckpoint_api.management.access_control_nat',
 'pycheckpoint_api.management.misc',
 'pycheckpoint_api.management.network_objects',
 'pycheckpoint_api.management.policy',
 'pycheckpoint_api.management.service_applications']

package_data = \
{'': ['*']}

install_requires = \
['restfly>=1.4.6,<2.0.0']

setup_kwargs = {
    'name': 'pycheckpoint-api',
    'version': '1.1.3',
    'description': 'A python SDK for the Checkpoint firewalls',
    'long_description': '[![pyCheckpoint-API](https://letmer00t.github.io/pyCheckpoint-API/_static/logo.png)](https://github.com/LetMeR00t/pyCheckpoint-API)\n# pyCheckpoint-API - An unofficial Python SDK for Checkpoint API\n\n[![PyPI Version](https://img.shields.io/pypi/v/pycheckpoint-api.svg)](https://pypi.org/project/pyCheckpoint-API)\n[![GitHub Release](https://img.shields.io/github/release/LetMeR00t/pyCheckpoint-API.svg)](https://github.com/LetMeR00t/pyCheckpoint-API/releases/)\n[![PyPI pyversions](https://img.shields.io/pypi/pyversions/pycheckpoint-api.svg)](https://pypi.python.org/pypi/pycheckpoint-api/)\n[![Documentation Status](https://readthedocs.org/projects/pycheckpoint-api/badge/?version=latest)](https://pycheckpoint-api.readthedocs.io/?badge=latest)\n[![Build Status](https://github.com/LetMeR00t/pyCheckpoint-API/actions/workflows/build_by_version.yml/badge.svg)](https://github.com/LetMeR00t/pyCheckpoint-API/actions/workflows/build_by_version.yml)\n[![Codacy Badge](https://app.codacy.com/project/badge/Grade/352850b074e74a6890a2412c85b738c0)](https://www.codacy.com/gh/LetMeR00t/pyCheckpoint-API/dashboard?utm_source=github.com&amp;utm_medium=referral&amp;utm_content=LetMeR00t/pyCheckpoint-API&amp;utm_campaign=Badge_Grade)\n[![codecov](https://codecov.io/gh/LetMeR00t/pyCheckpoint-API/branch/main/graph/badge.svg?token=0A583STZI7)](https://codecov.io/gh/LetMeR00t/pyCheckpoint-API)\n[![License](https://img.shields.io/github/license/LetMeR00t/pyCheckpoint-API.svg)](https://github.com/LetMeR00t/pyCheckpoint-API)\n\npyCheckpoint-API is an SDK that provides a uniform and easy-to-use interface for each of the Checkpoint Firewall product API versions.\n\nThis SDK is not affiliated with, nor supported by Checkpoint in any way.\n\n## Overview\nCheckpoint firewalls solution are now using a well detailed API. This SDK simplifies software development using the Checkpoint Firewall API in Python.\n\nThis SDK is based on the [Checkpoint official API documentation](https://sc1.checkpoint.com/documents/latest/APIs/#introduction~v1.8%20).\n\nThis SDK leverages the [RESTfly framework](https://restfly.readthedocs.io/en/latest/index.html) developed by Steve McGrath.\n\nThis SDK implementation was largely inspired from the [pyZscaler](https://github.com/mitchos/pyZscaler) SDK development.\n\n## Features\n-  Simplified authentication with Checkpoint API versions.\n-  Uniform interaction with the Checkpoint API versions.\n-  Uses [python-box](https://github.com/cdgriffith/Box/wiki) to add dot notation access to json data structures.\n-  Various quality of life enhancements for object CRUD methods.\n\n## Products\n-  [Checkpoint](https://www.checkpoint.com/) Firewall\n\n## Installation\n\nThe most recent version can be installed from pypi as per below.\n\n   $ pip install pycheckpoint-api\n\n## Usage\n\nBefore you can interact with the Checkpoint API, you may need to generate API keys directly in the management interface or use a classic username/password at each connection.\n\nOnce you have the requirements and you have installed pyCheckpoint-API, you\'re ready to go.\n\n### Quick Examples\n\n#### API login/logout\n```python\n   from pycheckpoint_api.management import Management\n   from pprint import pprint\n\n   # Please note that, as it\'s an example, we enabled the SSL verify to False to avoid having SSL certificate issues.\n   # However, it\'s highly recommanded to use certificates with know certificate authorities.\n   # If you want to use an API key instead, remove the \'user\' and \'password\' fields and use the \'api_key\' field.\n   with Management(\n      hostname=\'HOSTNAME\',\n      port=\'PORT\',\n      user=\'USER\',\n      password=\'PASSWORD\',\n      version=\'VERSION\',\n      domain=\'DOMAIN\',\n      ssl_verify=False,\n   ) as api:\n\n      pprint(\n        "Connection is successfull, we have a token: "\n        + api._session.headers["X-chkp-sid"]\n      )\n\n   # Since we are out of the previous block, the API has been disconnected\n   pprint("Logout is successfull")\n```\n\n## Documentation\n### Web API Coverage\nLegend: \n-  🟢 means "Fully covered"\n-  🟡 means "Partially covered"\n-  🔴 means "Not covered yet"\n\n> **Why not all features from the list below are not yet implemented ?**: As you might understand, it takes time to implement every feature of the Checkpoint API (code + tests + docs). If you are very interested in some features below, please raise an issue and ask for those and they will be implemented in priority.\n\n\n\nHere is the list of endpoints that are currently supported by this SDK and base on the [Checkpoint official API reference](https://sc1.checkpoint.com/documents/latest/APIs/#introduction~v1.8%20).:\n-  🟢 Session Management\n-  🟢 Network Objects\n-  🔴 Compliance\n-  🔴 Gaia Best Practice\n-  🔴 Data Center\n-  🔴 Azure Active Directory\n-  🔴 Updatable Objects\n-  🟢 Service & Applications\n-  🟢 Access Control & NAT\n-  🔴 VPN\n-  🔴 VSX\n-  🔴 Threat Prevention\n-  🔴 HTTPS Inspection\n-  🟢 Policy\n-  🔴 Multi-Domain\n-  🔴 Migration\n-  🔴 SmartTasks\n-  🔴 Package Deployment\n-  🔴 Users\n-  🔴 High Availability\n-  🔴 Manage & Settings\n-  🔴 Logs\n-  🟡 Misc.\n   -  🔴 add-objects-batch\n   -  🔴 set-objects-batch\n   -  🔴 delete-objects-batch\n   -  🔴 cme-api\n   -  🔴 gaia-api\n   -  🔴 export\n   -  🔴 show-changes\n   -  🔴 show-api-versions\n   -  🔴 put-file\n   -  🔴 where-used\n   -  🔴 run-script\n   -  🔴 show-unused-objects\n   -  🔴 show-gateways-and-servers\n   -  🔴 show-layer-structure\n   -  🔴 show-validations\n   -  🔴 show-commands\n   -  🔴 install-database\n   -  🔴 Task\n   -  🔴 Object\n   -  🟢 generic-objects (rulebaseaction)\n\n### User Documentation\nTODO\n\n## Is It Tested?\nYes! pyCheckpoint-API has a complete test suite that fully covers all implemented methods\n\n## Contributing\n\nContributions to pyCheckpoint-API are absolutely welcome.\n\nPlease see the [Contribution Guidelines](https://github.com/LetMeR00t/pyCheckpoint-API/blob/main/CONTRIBUTING.md) for more information.\n\n[Poetry](https://python-poetry.org/docs/) is currently being used for builds and management. You\'ll want to have poetry installed and available in your environment.\n\nOnce Poetry is installed, you can create and validate your development environment using those commands:\n\n```sh\npoetry install\n# this is installing the package using poetry\n\npoetry build\n# this is building the package locally (not required)\n   \npoetry shell\n# this is usind the dedicated virtual environment for development\n   \npytest\n# Run the tests\n```\n\nYou should then see the output of pytest results with all tests passed.\n\n## Issues\nPlease feel free to open an issue using [Github Issues](https://github.com/LetMeR00t/pyCheckpoint-API/issues) if you run into any problems using pyCheckpoint-API.\n\n## License\nMIT License\n\nCopyright (c) 2022 LmR\n\nPermission is hereby granted, free of charge, to any person obtaining a copy\nof this software and associated documentation files (the "Software"), to deal\nin the Software without restriction, including without limitation the rights\nto use, copy, modify, merge, publish, distribute, sublicense, and/or sell\ncopies of the Software, and to permit persons to whom the Software is\nfurnished to do so, subject to the following conditions:\n\nThe above copyright notice and this permission notice shall be included in all\ncopies or substantial portions of the Software.\n\nTHE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR\nIMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,\nFITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE\nAUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER\nLIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,\nOUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE\nSOFTWARE.\n',
    'author': 'LmR',
    'author_email': 'letmer00t@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/LetMeR00t/pyCheckpoint-API',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
