while getopts q:a:l:o:x: flag
do
    case "${flag}" in
	q) query_dir=${OPTARG};;
	a) accessory_dir=${OPTARG};;
  l) aligned=${OPTARG};;
  o) out_dir=${OPTARG};;
  x) cores=${OPTARG};;
    esac
done
out_dir=${out_dir}/depp_results
echo "aligning sequences..."
if [ -z "${aligned+x}" ]
then
  for f in ${query_dir}/*.fa; do
    # $1 gene
    # $2 accessory_dir
    # $3 query_dir
    # $4 out_dir
    f=$(basename -- "$f")
    f="${f%.*}"
#    echo $f
    run_upp.sh ${f} ${accessory_dir} ${query_dir} ${cores} > /dev/null 2>&1 &
  done
  wait
fi
echo "finish alignment!"
echo "calculating distance matrices..."
if [ -z "${aligned+x}" ]
then
  for f in ${query_dir}/p*aligned.fa; do
    f=$(basename -- "$f")
    f="${f%_*}"
    distance_depp.sh -q ${query_dir}/${f}_aligned.fa -b ${accessory_dir}/${f}.fa -m ${accessory_dir}/${f}.ckpt -t ${accessory_dir}/wol.nwk -o ${out_dir}/${f} > /dev/null 2>&1 &
  done
  wait
  for f in ${query_dir}/16*aligned.fa; do
    f=$(basename -- "$f")
    f="${f%_*}"
    distance_depp.sh -q ${query_dir}/${f}_aligned.fa -b ${accessory_dir}/${f}.fa -m ${accessory_dir}/${f}.ckpt -t ${accessory_dir}/wol.nwk -o ${out_dir}/${f} -r True > /dev/null 2>&1 &
  done
  wait
else
  for f in ${query_dir}/p*.fa; do
    f=$(basename -- "$f")
    f="${f%.*}"
    distance_depp.sh -q ${query_dir}/${f}.fa -b ${accessory_dir}/${f}.fa -m ${accessory_dir}/${f}.ckpt -t ${accessory_dir}/wol.nwk -o ${out_dir}/${f} > /dev/null 2>&1 &
  done
  wait
  for f in ${query_dir}/16*.fa; do
    f=$(basename -- "$f")
    f="${f%.*}"
    distance_depp.sh -q ${query_dir}/${f}.fa -b ${accessory_dir}/${f}.fa -m ${accessory_dir}/${f}.ckpt -t ${accessory_dir}/wol.nwk -o ${out_dir}/${f} -r True> /dev/null 2>&1 &
  done
  wait
fi
echo "finish distance matrices!"
echo "placing queries..."

count1=`ls -1 ${query_dir}/p* 2>/dev/null | wc -l`
count2=`ls -1 ${query_dir}/16* 2>/dev/null | wc -l`
if [ $count1!=0 ]
then
  agg_dist.py -o ${out_dir} -a ${accessory_dir} -p p
  run_apples.py -d ${out_dir}/summary/marker_genes_dist.csv -t ${accessory_dir}/wol.nwk -o ${out_dir}/summary/marker_genes_placement.jplace -f 0.25 -b 25
elif [ $count2!=0 ]
then
  for f in ${query_dir}/16*.fa; do
      f=$(basename -- "$f")
      f="${f%.*}"
      run_apples.py -d ${out_dir}/${f}/depp_correction.csv -t ${accessory_dir}/wol.nwk -o ${out_dir}/summary/${f}_placement.jplace -f 0.25 -b 25
      if [ $count1!=0 ]
      then
      merge_json.py --asv ${f} --out-dir ${out_dir}
      fi
    done
    wait
fi

gappa examine graft --jplace-path ${out_dir}/summary/ --out-dir ${out_dir}/summary/ --allow-file-overwriting > /dev/null 2>&1
echo "finish queries placement!"