# generated by datamodel-codegen:
#   filename:  Hardware.json
#   timestamp: 2023-01-07T13:05:48+00:00

from __future__ import annotations

from enum import Enum
from typing import TYPE_CHECKING, Any, List, Optional
from uuid import UUID, uuid4

from pydantic import BaseModel, Field
from typing_extensions import Literal

if TYPE_CHECKING:
    from dataclasses import dataclass as _basemodel_decorator
else:
    _basemodel_decorator = lambda x: x  # noqa: E731


class LangCode(Enum):
    en = "en"
    de = "de"


class OslBaseModel(BaseModel):
    def full_dict(self, **kwargs):  # extent BaseClass export function
        d = super().dict(**kwargs)
        for key in ("_osl_template", "_osl_footer"):
            if hasattr(self, key):
                d[key] = getattr(
                    self, key
                )  # include selected private properites. note: private properties are not considered as discriminator
        return d


@_basemodel_decorator
class Label(OslBaseModel):
    osl_template: Optional[Literal["OslTemplate:Label"]] = "OslTemplate:Label"
    text: str = Field(..., title="Text")
    lang: Optional[LangCode] = Field("en", title="Lang code")


@_basemodel_decorator
class Statement(OslBaseModel):
    osl_template: Optional[Literal["OslTemplate:Statement"]] = "OslTemplate:Statement"
    label: Optional[Label] = Field(None, title="Label")
    """
    Human readable name
    """
    uuid: UUID = Field(default_factory=uuid4, title="UUID")
    subject: Optional[str] = None
    predicate: str
    object: Optional[str] = None
    substatements: Optional[List[Statement]] = Field(None, title="Substatements")


@_basemodel_decorator
class Entity(OslBaseModel):
    uuid: UUID = Field(default_factory=uuid4, title="UUID")
    label: Label = Field(..., title="Label")
    """
    Human readable name
    """
    query_label: Optional[str] = Field(None, title="Label")
    additional_labels: Optional[List[Label]] = Field(None, title="Additional Labels")
    image: Optional[str] = Field(None, title="Image")
    statements: Optional[List[Statement]] = Field(None, title="Statements")
    extensions: Optional[List[Any]] = Field(None, title="Extensions")


class Item(Entity):
    type: Optional[List[str]] = Field(["Category:Item"], min_length=1)


Statement.update_forward_refs()
