"use strict";
var _a, _b, _c, _d, _e, _f, _g;
Object.defineProperty(exports, "__esModule", { value: true });
exports.VehicleModel = exports.CanDefinition = exports.NetworkFileDefinition = exports.CanVehicleSignal = exports.VehicleSignal = exports.CanVehicleInterface = exports.VehicleInterface = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("aws-cdk-lib");
const constructs_1 = require("constructs");
const handler_1 = require("./handler");
const provider_1 = require("./provider");
class VehicleInterface {
    constructor() {
        this.intf = {};
    }
    toObject() {
        return (this.intf);
    }
}
exports.VehicleInterface = VehicleInterface;
_a = JSII_RTTI_SYMBOL_1;
VehicleInterface[_a] = { fqn: "cdk-aws-iotfleetwise.VehicleInterface", version: "0.2.10" };
class CanVehicleInterface extends VehicleInterface {
    constructor(interfaceId, name) {
        super();
        this.intf = {
            type: 'CAN_INTERFACE',
            interfaceId,
            canInterface: {
                canInterfaceName: name,
                protocolName: 'CAN',
                protocolVersion: '2.0b',
            },
        };
    }
}
exports.CanVehicleInterface = CanVehicleInterface;
_b = JSII_RTTI_SYMBOL_1;
CanVehicleInterface[_b] = { fqn: "cdk-aws-iotfleetwise.CanVehicleInterface", version: "0.2.10" };
class VehicleSignal {
    constructor() {
        this.signal = {};
    }
    toObject() {
        return (this.signal);
    }
}
exports.VehicleSignal = VehicleSignal;
_c = JSII_RTTI_SYMBOL_1;
VehicleSignal[_c] = { fqn: "cdk-aws-iotfleetwise.VehicleSignal", version: "0.2.10" };
class CanVehicleSignal extends VehicleSignal {
    constructor(name, fullyQualifiedName, interfaceId, messageId, factor, isBigEndian, isSigned, length, offset, startBit) {
        super();
        this.signal = {
            type: 'CAN_SIGNAL',
            fullyQualifiedName,
            interfaceId,
            canSignal: {
                canSignalName: name,
                factor,
                isBigEndian,
                isSigned,
                length,
                messageId,
                offset,
                startBit,
            },
        };
    }
}
exports.CanVehicleSignal = CanVehicleSignal;
_d = JSII_RTTI_SYMBOL_1;
CanVehicleSignal[_d] = { fqn: "cdk-aws-iotfleetwise.CanVehicleSignal", version: "0.2.10" };
class NetworkFileDefinition {
    constructor() {
        this.definition = {};
    }
    toObject() {
        return (this.definition);
    }
}
exports.NetworkFileDefinition = NetworkFileDefinition;
_e = JSII_RTTI_SYMBOL_1;
NetworkFileDefinition[_e] = { fqn: "cdk-aws-iotfleetwise.NetworkFileDefinition", version: "0.2.10" };
class CanDefinition extends NetworkFileDefinition {
    constructor(networkInterface, signalsMap, canDbcFiles) {
        super();
        this.definition = {
            networkFileType: 'CAN_DBC',
            canDbc: {
                canDbcFiles: canDbcFiles.map(file => Buffer.from(file).toString('base64')),
                networkInterface,
                signalsMap,
            },
        };
    }
}
exports.CanDefinition = CanDefinition;
_f = JSII_RTTI_SYMBOL_1;
CanDefinition[_f] = { fqn: "cdk-aws-iotfleetwise.CanDefinition", version: "0.2.10" };
class VehicleModel extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.name = '';
        this.signalCatalog = {};
        this.name = props.name || '';
        this.signalCatalog = props.signalCatalog;
        const handler = new handler_1.Handler(this, 'Handler', {
            handler: 'vehiclemodelhandler.on_event',
        });
        const resource = new cdk.CustomResource(this, 'Resource', {
            serviceToken: provider_1.Provider.getOrCreate(this, handler).provider.serviceToken,
            properties: {
                name: this.name,
                signal_catalog_arn: props.signalCatalog.arn,
                model_manifest_arn: `arn:aws:iotfleetwise:${cdk.Aws.REGION}:${cdk.Aws.ACCOUNT_ID}:model-manifest/${this.name}`,
                description: props.description,
                network_interfaces: JSON.stringify(props.networkInterfaces.map(i => i.toObject())),
                signals: (props.signals) ? JSON.stringify(props.signals.map(s => s.toObject())) : '{}',
                network_file_definitions: (props.networkFileDefinitions) ? JSON.stringify(props.networkFileDefinitions.map(s => s.toObject())) : '{}',
            },
        });
        resource.node.addDependency(this.signalCatalog);
    }
}
exports.VehicleModel = VehicleModel;
_g = JSII_RTTI_SYMBOL_1;
VehicleModel[_g] = { fqn: "cdk-aws-iotfleetwise.VehicleModel", version: "0.2.10" };
//# sourceMappingURL=data:application/json;base64,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