"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Handler = void 0;
const path = require("path");
const cdk = require("aws-cdk-lib");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const boto3layerversion_1 = require("./boto3layerversion");
const handlerrole_1 = require("./handlerrole");
class Handler extends aws_cdk_lib_1.aws_lambda.SingletonFunction {
    constructor(scope, id, props) {
        super(scope, id, {
            uuid: `${props.handler}`,
            code: aws_cdk_lib_1.aws_lambda.AssetCode.fromAsset(path.join(__dirname, '/../src/handlers')),
            handler: props.handler,
            timeout: cdk.Duration.seconds(300),
            runtime: aws_cdk_lib_1.aws_lambda.Runtime.PYTHON_3_9,
            layers: [boto3layerversion_1.Boto3LayerVersion.getOrCreate(scope).lambdaLayer],
            role: handlerrole_1.HandlerRole.getOrCreate(scope).role,
            logRetention: aws_cdk_lib_1.aws_logs.RetentionDays.ONE_DAY,
        });
        this.handler = props.handler;
    }
}
exports.Handler = Handler;
//# sourceMappingURL=data:application/json;base64,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