"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Fleet = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("aws-cdk-lib");
const constructs_1 = require("constructs");
const handler_1 = require("./handler");
const provider_1 = require("./provider");
/**
 * The fleet of vehicles
 */
class Fleet extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.fleetId = '';
        this.signalCatalog = {};
        this.vehicles = undefined;
        this.arn = `arn:aws:iotfleetwise:${cdk.Aws.REGION}:${cdk.Aws.ACCOUNT_ID}:fleet/${props.fleetId}`;
        this.signalCatalog = props.signalCatalog;
        this.fleetId = props.fleetId;
        this.vehicles = props.vehicles || [];
        const handler = new handler_1.Handler(this, 'Handler', {
            handler: 'fleethandler.on_event',
        });
        const resource = new cdk.CustomResource(this, 'Resource', {
            serviceToken: provider_1.Provider.getOrCreate(this, handler).provider.serviceToken,
            properties: {
                fleet_id: this.fleetId,
                signal_catalog_arn: this.signalCatalog.arn,
                description: props.description || ' ',
                vehicle_ids: this.vehicles.map(v => v.vehicleId),
            },
        });
        resource.node.addDependency(this.signalCatalog);
        this.vehicles.map(v => resource.node.addDependency(v));
    }
}
exports.Fleet = Fleet;
_a = JSII_RTTI_SYMBOL_1;
Fleet[_a] = { fqn: "cdk-aws-iotfleetwise.Fleet", version: "0.2.10" };
//# sourceMappingURL=data:application/json;base64,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