"use strict";
var _a, _b, _c, _d;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Campaign = exports.CampaignSignal = exports.TimeBasedCollectionScheme = exports.CollectionScheme = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("aws-cdk-lib");
const constructs_1 = require("constructs");
const handler_1 = require("./handler");
const provider_1 = require("./provider");
class CollectionScheme {
    constructor() {
        this.scheme = {};
    }
    toObject() {
        return (this.scheme);
    }
}
exports.CollectionScheme = CollectionScheme;
_a = JSII_RTTI_SYMBOL_1;
CollectionScheme[_a] = { fqn: "cdk-aws-iotfleetwise.CollectionScheme", version: "0.2.10" };
class TimeBasedCollectionScheme extends CollectionScheme {
    constructor(period) {
        super();
        this.scheme = {
            timeBasedCollectionScheme: {
                periodMs: period.toMilliseconds(),
            },
        };
    }
}
exports.TimeBasedCollectionScheme = TimeBasedCollectionScheme;
_b = JSII_RTTI_SYMBOL_1;
TimeBasedCollectionScheme[_b] = { fqn: "cdk-aws-iotfleetwise.TimeBasedCollectionScheme", version: "0.2.10" };
class CampaignSignal {
    constructor(name, maxSampleCount, minimumSamplingInterval) {
        this.signal = {
            signalName: name,
            ...maxSampleCount && { maxSampleCount },
            ...minimumSamplingInterval && { minimumSamplingInterval },
        };
    }
    toObject() {
        return (this.signal);
    }
}
exports.CampaignSignal = CampaignSignal;
_c = JSII_RTTI_SYMBOL_1;
CampaignSignal[_c] = { fqn: "cdk-aws-iotfleetwise.CampaignSignal", version: "0.2.10" };
class Campaign extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.name = '';
        this.arn = '';
        this.target = {};
        this.name = props.name;
        this.arn = `arn:aws:iotfleetwise:${cdk.Aws.REGION}:${cdk.Aws.ACCOUNT_ID}:vehicle/${props.target}`;
        this.target = props.target;
        const handler = new handler_1.Handler(this, 'Handler', {
            handler: 'campaignhandler.on_event',
        });
        const resource = new cdk.CustomResource(this, 'Resource', {
            serviceToken: provider_1.Provider.getOrCreate(this, handler).provider.serviceToken,
            properties: {
                campaign_name: this.name,
                signal_catalog_arn: this.target.vehicleModel.signalCatalog.arn,
                target_arn: this.target.arn,
                collection_scheme: JSON.stringify(props.collectionScheme.toObject()),
                signals_to_collect: JSON.stringify(props.signals.map(s => s.toObject())),
                auto_approve: props.autoApprove || false,
            },
        });
        resource.node.addDependency(this.target);
    }
}
exports.Campaign = Campaign;
_d = JSII_RTTI_SYMBOL_1;
Campaign[_d] = { fqn: "cdk-aws-iotfleetwise.Campaign", version: "0.2.10" };
//# sourceMappingURL=data:application/json;base64,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