# coding: utf-8

"""
    Engines API

    Allow clients to fetch Analytics through APIs.  # noqa: E501

    The version of the OpenAPI document: v2:[pa,spar,vault,pub],v1:[fiab,fi,axp,afi,npo,bpm,fpo]
    Contact: analytics.api.support@factset.com
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from fds.analyticsapi.engines.configuration import Configuration


class FIABCalculationParameters(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'fiabdocument': 'str',
        'account': 'FIABIdentifier',
        'dates': 'FIABDateParameters',
        'msl': 'str',
        'fisettingsdocument': 'str'
    }

    attribute_map = {
        'fiabdocument': 'fiabdocument',
        'account': 'account',
        'dates': 'dates',
        'msl': 'msl',
        'fisettingsdocument': 'fisettingsdocument'
    }

    def __init__(self, fiabdocument=None, account=None, dates=None, msl=None, fisettingsdocument=None, local_vars_configuration=None):  # noqa: E501
        """FIABCalculationParameters - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._fiabdocument = None
        self._account = None
        self._dates = None
        self._msl = None
        self._fisettingsdocument = None
        self.discriminator = None

        if fiabdocument is not None:
            self.fiabdocument = fiabdocument
        self.account = account
        self.dates = dates
        if msl is not None:
            self.msl = msl
        if fisettingsdocument is not None:
            self.fisettingsdocument = fisettingsdocument

    @property
    def fiabdocument(self):
        """Gets the fiabdocument of this FIABCalculationParameters.  # noqa: E501

        FiabDocument (optional) - FIAB document to use as a template. Should  be a path to a FIAB document. Expects a GUI-style path (Client:/foo/bar)  # noqa: E501

        :return: The fiabdocument of this FIABCalculationParameters.  # noqa: E501
        :rtype: str
        """
        return self._fiabdocument

    @fiabdocument.setter
    def fiabdocument(self, fiabdocument):
        """Sets the fiabdocument of this FIABCalculationParameters.

        FiabDocument (optional) - FIAB document to use as a template. Should  be a path to a FIAB document. Expects a GUI-style path (Client:/foo/bar)  # noqa: E501

        :param fiabdocument: The fiabdocument of this FIABCalculationParameters.  # noqa: E501
        :type: str
        """

        self._fiabdocument = fiabdocument

    @property
    def account(self):
        """Gets the account of this FIABCalculationParameters.  # noqa: E501


        :return: The account of this FIABCalculationParameters.  # noqa: E501
        :rtype: FIABIdentifier
        """
        return self._account

    @account.setter
    def account(self, account):
        """Sets the account of this FIABCalculationParameters.


        :param account: The account of this FIABCalculationParameters.  # noqa: E501
        :type: FIABIdentifier
        """
        if self.local_vars_configuration.client_side_validation and account is None:  # noqa: E501
            raise ValueError("Invalid value for `account`, must not be `None`")  # noqa: E501

        self._account = account

    @property
    def dates(self):
        """Gets the dates of this FIABCalculationParameters.  # noqa: E501


        :return: The dates of this FIABCalculationParameters.  # noqa: E501
        :rtype: FIABDateParameters
        """
        return self._dates

    @dates.setter
    def dates(self, dates):
        """Sets the dates of this FIABCalculationParameters.


        :param dates: The dates of this FIABCalculationParameters.  # noqa: E501
        :type: FIABDateParameters
        """
        if self.local_vars_configuration.client_side_validation and dates is None:  # noqa: E501
            raise ValueError("Invalid value for `dates`, must not be `None`")  # noqa: E501

        self._dates = dates

    @property
    def msl(self):
        """Gets the msl of this FIABCalculationParameters.  # noqa: E501

        Master FISecurity List. Analytics results will be written to the selected MSL. Expects a GUI-style path (Client:/foo/bar)  # noqa: E501

        :return: The msl of this FIABCalculationParameters.  # noqa: E501
        :rtype: str
        """
        return self._msl

    @msl.setter
    def msl(self, msl):
        """Sets the msl of this FIABCalculationParameters.

        Master FISecurity List. Analytics results will be written to the selected MSL. Expects a GUI-style path (Client:/foo/bar)  # noqa: E501

        :param msl: The msl of this FIABCalculationParameters.  # noqa: E501
        :type: str
        """

        self._msl = msl

    @property
    def fisettingsdocument(self):
        """Gets the fisettingsdocument of this FIABCalculationParameters.  # noqa: E501

        FISettingsDocument (optional) - The given @FIS document will be used to  configure analytics assumptions and settings. Expects a GUI-style path (Client:/foo/bar)  # noqa: E501

        :return: The fisettingsdocument of this FIABCalculationParameters.  # noqa: E501
        :rtype: str
        """
        return self._fisettingsdocument

    @fisettingsdocument.setter
    def fisettingsdocument(self, fisettingsdocument):
        """Sets the fisettingsdocument of this FIABCalculationParameters.

        FISettingsDocument (optional) - The given @FIS document will be used to  configure analytics assumptions and settings. Expects a GUI-style path (Client:/foo/bar)  # noqa: E501

        :param fisettingsdocument: The fisettingsdocument of this FIABCalculationParameters.  # noqa: E501
        :type: str
        """

        self._fisettingsdocument = fisettingsdocument

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, FIABCalculationParameters):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, FIABCalculationParameters):
            return True

        return self.to_dict() != other.to_dict()
