#!/usr/bin/env python
# -*- coding: utf-8 -*-

# Note: To use the 'upload' functionality of this file, you must:
# $ python3 setup.py build

import io
import os
import sys
from shutil import rmtree

from setuptools import find_packages, setup, Command

# Package meta-data.
NAME = 'reter'
DESCRIPTION = 'A unix/posix terminal manipulation library for python3'
URL = 'https://github.com/ZackeryRSmith/Reter'
EMAIL = 'zackery.smith82307@gmail.com'
AUTHOR = 'Zackery Smith'
REQUIRES_PYTHON = '>=3.0.0'
VERSION = '1.0.7'

# Packages to build
#PACKAGES = [
#    "src.reter",  # Whole package
#    "src.reter.lib.cursor",  # Cursor
#    "src.reter.lib.errhandler",  # Error handler
#    "src.reter.lib.event.input.keyboard",  # Keybaord
#    "src.reter.lib.event.input.map",  # Key mappings
#    "src.reter.lib.style",  # Colours + indicator
#    "src.reter.lib.terminal",  # Screen, line, term
#]

# What packages are required for this module to be executed?
REQUIRED = open("reter/requirements.txt").readlines()

# What packages are optional?
EXTRAS = {
    # None,
}

# Get parent
here = os.path.abspath(os.path.dirname(__file__))

# Import the README and use it as the long-description.
# Note: this will only work if 'README.md' is present in your MANIFEST.in file!
try:
    with io.open(os.path.join(here, 'PYPI.md'), encoding='utf-8') as f:
        long_description = '\n' + f.read()
except FileNotFoundError:
    long_description = DESCRIPTION

# Load the package's __version__.py module as a dictionary.
about = {}
if not VERSION:
    project_slug = NAME.lower().replace("-", "_").replace(" ", "_")
    with open(os.path.join(here, project_slug, '__version__.py')) as f:
        exec(f.read(), about)
else:
    about['__version__'] = VERSION


class UploadCommand(Command):
    """Support setup.py upload."""

    description = 'Build and publish the package.'
    user_options = []

    @staticmethod
    def status(s):
        """Prints things in bold."""
        print('\033[1m{0}\033[0m'.format(s))

    def initialize_options(self):
        pass

    def finalize_options(self):
        pass

    def run(self):
        try:
            self.status('Removing previous builds…')
            rmtree(os.path.join(here, 'dist'))
        except OSError:
            pass

        self.status('Building Source and Wheel (universal) distribution…')
        os.system('{0} setup.py sdist bdist_wheel --universal'.format(sys.executable))

        try:
            self.status('Uploading the package to PyPI via Twine…')
            os.system('twine upload dist/*')
        except KeyboardInterrupt:
            print('\033[1m{0}\033[0m'.format("Quitting"))
            
        sys.exit()


# Where the magic happens:
setup(
    name=NAME,
    version=about['__version__'],
    description=DESCRIPTION,
    long_description=long_description,
    long_description_content_type='text/markdown',
    author=AUTHOR,
    author_email=EMAIL,
    python_requires=REQUIRES_PYTHON,
    url=URL,
    # packages=find_packages(exclude=["tests", "*.tests", "*.tests.*", "tests.*"]),
    packages=find_packages(),
    # If package is a single module, use this instead of 'packages':
    # py_modules=['reter'],
    #
    # entry_points={
    #     'console_scripts': ['mycli=mymodule:cli'],
    # },
    install_requires=REQUIRED,
    extras_require=EXTRAS,
    include_package_data=True,
    license='GNU GPL-3.0',
    classifiers=[
        # Trove classifiers
        # Full list: https://pypi.python.org/pypi?%3Aaction=list_classifiers
        'License :: OSI Approved :: GNU General Public License v3 (GPLv3)',
        'Programming Language :: Python',
        'Programming Language :: Python :: 3',
        'Programming Language :: Python :: 3.6',
        'Programming Language :: Python :: 3.9',
        'Programming Language :: Python :: 3.10',
    ],
    # $ setup.py publish support.
    cmdclass={
        'upload': UploadCommand,
    },
)
