import * as cdk from '@aws-cdk/core';
/**
 * Schema for Module Fragment of type AWSQS::VPC::VPCQS::MODULE.
 *
 * @schema CfnModuleProps
 */
export interface CfnModuleProps {
    /**
     * @schema CfnModuleProps#Parameters
     */
    readonly parameters?: CfnModulePropsParameters;
    /**
     * @schema CfnModuleProps#Resources
     */
    readonly resources?: CfnModulePropsResources;
}
/**
 * Converts an object of type 'CfnModuleProps' to JSON representation.
 */
export declare function toJson_CfnModuleProps(obj: CfnModuleProps | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsParameters
 */
export interface CfnModulePropsParameters {
    /**
     * List of Availability Zones to use for the subnets in the VPC.
     *
     * Note: The logical order is preserved.
     *
     * @schema CfnModulePropsParameters#AvailabilityZones
     */
    readonly availabilityZones?: CfnModulePropsParametersAvailabilityZones;
    /**
     * Set to true to create a network ACL protected subnet in each Availability Zone.
     *
     * If false, the CIDR parameters for those subnets will be ignored. If true, it also requires that the 'Create private subnets' parameter is also true to have any effect.
     *
     * @schema CfnModulePropsParameters#CreateAdditionalPrivateSubnets
     */
    readonly createAdditionalPrivateSubnets?: CfnModulePropsParametersCreateAdditionalPrivateSubnets;
    /**
     * Set to false when creating only private subnets.
     *
     * If True, both CreatePublicSubnets and CreatePrivateSubnets must also be true.
     *
     * @schema CfnModulePropsParameters#CreateNATGateways
     */
    readonly createNatGateways?: CfnModulePropsParametersCreateNatGateways;
    /**
     * Set to false to create only private subnets.
     *
     * If false, CreatePrivateSubnets must be True and the CIDR parameters for ALL public subnets will be ignored
     *
     * @schema CfnModulePropsParameters#CreatePublicSubnets
     */
    readonly createPublicSubnets?: CfnModulePropsParametersCreatePublicSubnets;
    /**
     * Set to false to create only public subnets.
     *
     * If false, the CIDR parameters for ALL private subnets will be ignored.
     *
     * @schema CfnModulePropsParameters#CreatePrivateSubnets
     */
    readonly createPrivateSubnets?: CfnModulePropsParametersCreatePrivateSubnets;
    /**
     * Set to true to create VPC flow logs for the VPC and publish them to CloudWatch.
     *
     * If false, VPC flow logs will not be created.
     *
     * @schema CfnModulePropsParameters#CreateVPCFlowLogsToCloudWatch
     */
    readonly createVpcFlowLogsToCloudWatch?: CfnModulePropsParametersCreateVpcFlowLogsToCloudWatch;
    /**
     * Number of Availability Zones to use in the VPC.
     *
     * This must match your selections in the list of Availability Zones parameter.
     *
     * @schema CfnModulePropsParameters#NumberOfAZs
     */
    readonly numberOfAZs?: CfnModulePropsParametersNumberOfAZs;
    /**
     * CIDR block for private subnet 1A located in Availability Zone 1.
     *
     * @schema CfnModulePropsParameters#PrivateSubnet1ACIDR
     */
    readonly privateSubnet1Acidr?: CfnModulePropsParametersPrivateSubnet1Acidr;
    /**
     * CIDR block for private subnet 1B with dedicated network ACL located in Availability Zone 1.
     *
     * @schema CfnModulePropsParameters#PrivateSubnet1BCIDR
     */
    readonly privateSubnet1Bcidr?: CfnModulePropsParametersPrivateSubnet1Bcidr;
    /**
     * CIDR block for private subnet 2A located in Availability Zone 2.
     *
     * @schema CfnModulePropsParameters#PrivateSubnet2ACIDR
     */
    readonly privateSubnet2Acidr?: CfnModulePropsParametersPrivateSubnet2Acidr;
    /**
     * CIDR block for private subnet 2B with dedicated network ACL located in Availability Zone 2.
     *
     * @schema CfnModulePropsParameters#PrivateSubnet2BCIDR
     */
    readonly privateSubnet2Bcidr?: CfnModulePropsParametersPrivateSubnet2Bcidr;
    /**
     * CIDR block for private subnet 3A located in Availability Zone 3.
     *
     * @schema CfnModulePropsParameters#PrivateSubnet3ACIDR
     */
    readonly privateSubnet3Acidr?: CfnModulePropsParametersPrivateSubnet3Acidr;
    /**
     * CIDR block for private subnet 3B with dedicated network ACL located in Availability Zone 3.
     *
     * @schema CfnModulePropsParameters#PrivateSubnet3BCIDR
     */
    readonly privateSubnet3Bcidr?: CfnModulePropsParametersPrivateSubnet3Bcidr;
    /**
     * CIDR block for private subnet 4A located in Availability Zone 4.
     *
     * @schema CfnModulePropsParameters#PrivateSubnet4ACIDR
     */
    readonly privateSubnet4Acidr?: CfnModulePropsParametersPrivateSubnet4Acidr;
    /**
     * CIDR block for private subnet 4B with dedicated network ACL located in Availability Zone 4.
     *
     * @schema CfnModulePropsParameters#PrivateSubnet4BCIDR
     */
    readonly privateSubnet4Bcidr?: CfnModulePropsParametersPrivateSubnet4Bcidr;
    /**
     * tag to add to private subnets A, in format Key=Value (Optional).
     *
     * @schema CfnModulePropsParameters#PrivateSubnetATag1
     */
    readonly privateSubnetATag1?: CfnModulePropsParametersPrivateSubnetATag1;
    /**
     * tag to add to private subnets A, in format Key=Value (Optional).
     *
     * @schema CfnModulePropsParameters#PrivateSubnetATag2
     */
    readonly privateSubnetATag2?: CfnModulePropsParametersPrivateSubnetATag2;
    /**
     * tag to add to private subnets A, in format Key=Value (Optional).
     *
     * @schema CfnModulePropsParameters#PrivateSubnetATag3
     */
    readonly privateSubnetATag3?: CfnModulePropsParametersPrivateSubnetATag3;
    /**
     * tag to add to private subnets B, in format Key=Value (Optional).
     *
     * @schema CfnModulePropsParameters#PrivateSubnetBTag1
     */
    readonly privateSubnetBTag1?: CfnModulePropsParametersPrivateSubnetBTag1;
    /**
     * tag to add to private subnets B, in format Key=Value (Optional).
     *
     * @schema CfnModulePropsParameters#PrivateSubnetBTag2
     */
    readonly privateSubnetBTag2?: CfnModulePropsParametersPrivateSubnetBTag2;
    /**
     * tag to add to private subnets B, in format Key=Value (Optional).
     *
     * @schema CfnModulePropsParameters#PrivateSubnetBTag3
     */
    readonly privateSubnetBTag3?: CfnModulePropsParametersPrivateSubnetBTag3;
    /**
     * CIDR block for the public DMZ subnet 1 located in Availability Zone 1.
     *
     * @schema CfnModulePropsParameters#PublicSubnet1CIDR
     */
    readonly publicSubnet1Cidr?: CfnModulePropsParametersPublicSubnet1Cidr;
    /**
     * CIDR block for the public DMZ subnet 2 located in Availability Zone 2.
     *
     * @schema CfnModulePropsParameters#PublicSubnet2CIDR
     */
    readonly publicSubnet2Cidr?: CfnModulePropsParametersPublicSubnet2Cidr;
    /**
     * CIDR block for the public DMZ subnet 3 located in Availability Zone 3.
     *
     * @schema CfnModulePropsParameters#PublicSubnet3CIDR
     */
    readonly publicSubnet3Cidr?: CfnModulePropsParametersPublicSubnet3Cidr;
    /**
     * CIDR block for the public DMZ subnet 4 located in Availability Zone 4.
     *
     * @schema CfnModulePropsParameters#PublicSubnet4CIDR
     */
    readonly publicSubnet4Cidr?: CfnModulePropsParametersPublicSubnet4Cidr;
    /**
     * tag to add to public subnets, in format Key=Value (Optional).
     *
     * @schema CfnModulePropsParameters#PublicSubnetTag1
     */
    readonly publicSubnetTag1?: CfnModulePropsParametersPublicSubnetTag1;
    /**
     * tag to add to public subnets, in format Key=Value (Optional).
     *
     * @schema CfnModulePropsParameters#PublicSubnetTag2
     */
    readonly publicSubnetTag2?: CfnModulePropsParametersPublicSubnetTag2;
    /**
     * tag to add to public subnets, in format Key=Value (Optional).
     *
     * @schema CfnModulePropsParameters#PublicSubnetTag3
     */
    readonly publicSubnetTag3?: CfnModulePropsParametersPublicSubnetTag3;
    /**
     * CIDR block for the VPC.
     *
     * @schema CfnModulePropsParameters#VPCCIDR
     */
    readonly vpccidr?: CfnModulePropsParametersVpccidr;
    /**
     * (Optional) KMS Key ARN to use for encrypting the VPC flow logs data.
     *
     * If empty, encryption is enabled with CloudWatch Logs managing the server-side encryption keys.
     *
     * @schema CfnModulePropsParameters#VPCFlowLogsCloudWatchKMSKey
     */
    readonly vpcFlowLogsCloudWatchKmsKey?: CfnModulePropsParametersVpcFlowLogsCloudWatchKmsKey;
    /**
     * The fields to include in the flow log record, in the order in which they should appear.
     *
     * Specify the fields using the ${field-id} format, separated by spaces. Using the Default Format as the default value.
     *
     * @schema CfnModulePropsParameters#VPCFlowLogsLogFormat
     */
    readonly vpcFlowLogsLogFormat?: CfnModulePropsParametersVpcFlowLogsLogFormat;
    /**
     * Number of days to retain the VPC Flow Logs in CloudWatch.
     *
     * @schema CfnModulePropsParameters#VPCFlowLogsLogGroupRetention
     */
    readonly vpcFlowLogsLogGroupRetention?: CfnModulePropsParametersVpcFlowLogsLogGroupRetention;
    /**
     * The maximum interval of time during which a flow of packets is captured and aggregated into a flow log record.
     *
     * You can specify 60 seconds (1 minute) or 600 seconds (10 minutes).
     *
     * @schema CfnModulePropsParameters#VPCFlowLogsMaxAggregationInterval
     */
    readonly vpcFlowLogsMaxAggregationInterval?: CfnModulePropsParametersVpcFlowLogsMaxAggregationInterval;
    /**
     * The type of traffic to log.
     *
     * You can log traffic that the resource accepts or rejects, or all traffic.
     *
     * @schema CfnModulePropsParameters#VPCFlowLogsTrafficType
     */
    readonly vpcFlowLogsTrafficType?: CfnModulePropsParametersVpcFlowLogsTrafficType;
    /**
     * The allowed tenancy of instances launched into the VPC.
     *
     * @schema CfnModulePropsParameters#VPCTenancy
     */
    readonly vpcTenancy?: CfnModulePropsParametersVpcTenancy;
}
/**
 * Converts an object of type 'CfnModulePropsParameters' to JSON representation.
 */
export declare function toJson_CfnModulePropsParameters(obj: CfnModulePropsParameters | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResources
 */
export interface CfnModulePropsResources {
    /**
     * @schema CfnModulePropsResources#DHCPOptions
     */
    readonly dhcpOptions?: CfnModulePropsResourcesDhcpOptions;
    /**
     * @schema CfnModulePropsResources#VPC
     */
    readonly vpc?: CfnModulePropsResourcesVpc;
    /**
     * @schema CfnModulePropsResources#VPCDHCPOptionsAssociation
     */
    readonly vpcdhcpOptionsAssociation?: CfnModulePropsResourcesVpcdhcpOptionsAssociation;
    /**
     * @schema CfnModulePropsResources#InternetGateway
     */
    readonly internetGateway?: CfnModulePropsResourcesInternetGateway;
    /**
     * @schema CfnModulePropsResources#VPCGatewayAttachment
     */
    readonly vpcGatewayAttachment?: CfnModulePropsResourcesVpcGatewayAttachment;
    /**
     * @schema CfnModulePropsResources#PrivateSubnet1A
     */
    readonly privateSubnet1A?: CfnModulePropsResourcesPrivateSubnet1A;
    /**
     * @schema CfnModulePropsResources#PrivateSubnet1B
     */
    readonly privateSubnet1B?: CfnModulePropsResourcesPrivateSubnet1B;
    /**
     * @schema CfnModulePropsResources#PrivateSubnet2A
     */
    readonly privateSubnet2A?: CfnModulePropsResourcesPrivateSubnet2A;
    /**
     * @schema CfnModulePropsResources#PrivateSubnet2B
     */
    readonly privateSubnet2B?: CfnModulePropsResourcesPrivateSubnet2B;
    /**
     * @schema CfnModulePropsResources#PrivateSubnet3A
     */
    readonly privateSubnet3A?: CfnModulePropsResourcesPrivateSubnet3A;
    /**
     * @schema CfnModulePropsResources#PrivateSubnet3B
     */
    readonly privateSubnet3B?: CfnModulePropsResourcesPrivateSubnet3B;
    /**
     * @schema CfnModulePropsResources#PrivateSubnet4A
     */
    readonly privateSubnet4A?: CfnModulePropsResourcesPrivateSubnet4A;
    /**
     * @schema CfnModulePropsResources#PrivateSubnet4B
     */
    readonly privateSubnet4B?: CfnModulePropsResourcesPrivateSubnet4B;
    /**
     * @schema CfnModulePropsResources#PublicSubnet1
     */
    readonly publicSubnet1?: CfnModulePropsResourcesPublicSubnet1;
    /**
     * @schema CfnModulePropsResources#PublicSubnet2
     */
    readonly publicSubnet2?: CfnModulePropsResourcesPublicSubnet2;
    /**
     * @schema CfnModulePropsResources#PublicSubnet3
     */
    readonly publicSubnet3?: CfnModulePropsResourcesPublicSubnet3;
    /**
     * @schema CfnModulePropsResources#PublicSubnet4
     */
    readonly publicSubnet4?: CfnModulePropsResourcesPublicSubnet4;
    /**
     * @schema CfnModulePropsResources#PrivateSubnet1ARouteTable
     */
    readonly privateSubnet1ARouteTable?: CfnModulePropsResourcesPrivateSubnet1ARouteTable;
    /**
     * @schema CfnModulePropsResources#PrivateSubnet1ARoute
     */
    readonly privateSubnet1ARoute?: CfnModulePropsResourcesPrivateSubnet1ARoute;
    /**
     * @schema CfnModulePropsResources#PrivateSubnet1ARouteTableAssociation
     */
    readonly privateSubnet1ARouteTableAssociation?: CfnModulePropsResourcesPrivateSubnet1ARouteTableAssociation;
    /**
     * @schema CfnModulePropsResources#PrivateSubnet2ARouteTable
     */
    readonly privateSubnet2ARouteTable?: CfnModulePropsResourcesPrivateSubnet2ARouteTable;
    /**
     * @schema CfnModulePropsResources#PrivateSubnet2ARoute
     */
    readonly privateSubnet2ARoute?: CfnModulePropsResourcesPrivateSubnet2ARoute;
    /**
     * @schema CfnModulePropsResources#PrivateSubnet2ARouteTableAssociation
     */
    readonly privateSubnet2ARouteTableAssociation?: CfnModulePropsResourcesPrivateSubnet2ARouteTableAssociation;
    /**
     * @schema CfnModulePropsResources#PrivateSubnet3ARouteTable
     */
    readonly privateSubnet3ARouteTable?: CfnModulePropsResourcesPrivateSubnet3ARouteTable;
    /**
     * @schema CfnModulePropsResources#PrivateSubnet3ARoute
     */
    readonly privateSubnet3ARoute?: CfnModulePropsResourcesPrivateSubnet3ARoute;
    /**
     * @schema CfnModulePropsResources#PrivateSubnet3ARouteTableAssociation
     */
    readonly privateSubnet3ARouteTableAssociation?: CfnModulePropsResourcesPrivateSubnet3ARouteTableAssociation;
    /**
     * @schema CfnModulePropsResources#PrivateSubnet4ARouteTable
     */
    readonly privateSubnet4ARouteTable?: CfnModulePropsResourcesPrivateSubnet4ARouteTable;
    /**
     * @schema CfnModulePropsResources#PrivateSubnet4ARoute
     */
    readonly privateSubnet4ARoute?: CfnModulePropsResourcesPrivateSubnet4ARoute;
    /**
     * @schema CfnModulePropsResources#PrivateSubnet4ARouteTableAssociation
     */
    readonly privateSubnet4ARouteTableAssociation?: CfnModulePropsResourcesPrivateSubnet4ARouteTableAssociation;
    /**
     * @schema CfnModulePropsResources#PrivateSubnet1BRouteTable
     */
    readonly privateSubnet1BRouteTable?: CfnModulePropsResourcesPrivateSubnet1BRouteTable;
    /**
     * @schema CfnModulePropsResources#PrivateSubnet1BRoute
     */
    readonly privateSubnet1BRoute?: CfnModulePropsResourcesPrivateSubnet1BRoute;
    /**
     * @schema CfnModulePropsResources#PrivateSubnet1BRouteTableAssociation
     */
    readonly privateSubnet1BRouteTableAssociation?: CfnModulePropsResourcesPrivateSubnet1BRouteTableAssociation;
    /**
     * @schema CfnModulePropsResources#PrivateSubnet1BNetworkAcl
     */
    readonly privateSubnet1BNetworkAcl?: CfnModulePropsResourcesPrivateSubnet1BNetworkAcl;
    /**
     * @schema CfnModulePropsResources#PrivateSubnet1BNetworkAclEntryInbound
     */
    readonly privateSubnet1BNetworkAclEntryInbound?: CfnModulePropsResourcesPrivateSubnet1BNetworkAclEntryInbound;
    /**
     * @schema CfnModulePropsResources#PrivateSubnet1BNetworkAclEntryOutbound
     */
    readonly privateSubnet1BNetworkAclEntryOutbound?: CfnModulePropsResourcesPrivateSubnet1BNetworkAclEntryOutbound;
    /**
     * @schema CfnModulePropsResources#PrivateSubnet1BNetworkAclAssociation
     */
    readonly privateSubnet1BNetworkAclAssociation?: CfnModulePropsResourcesPrivateSubnet1BNetworkAclAssociation;
    /**
     * @schema CfnModulePropsResources#PrivateSubnet2BRouteTable
     */
    readonly privateSubnet2BRouteTable?: CfnModulePropsResourcesPrivateSubnet2BRouteTable;
    /**
     * @schema CfnModulePropsResources#PrivateSubnet2BRoute
     */
    readonly privateSubnet2BRoute?: CfnModulePropsResourcesPrivateSubnet2BRoute;
    /**
     * @schema CfnModulePropsResources#PrivateSubnet2BRouteTableAssociation
     */
    readonly privateSubnet2BRouteTableAssociation?: CfnModulePropsResourcesPrivateSubnet2BRouteTableAssociation;
    /**
     * @schema CfnModulePropsResources#PrivateSubnet2BNetworkAcl
     */
    readonly privateSubnet2BNetworkAcl?: CfnModulePropsResourcesPrivateSubnet2BNetworkAcl;
    /**
     * @schema CfnModulePropsResources#PrivateSubnet2BNetworkAclEntryInbound
     */
    readonly privateSubnet2BNetworkAclEntryInbound?: CfnModulePropsResourcesPrivateSubnet2BNetworkAclEntryInbound;
    /**
     * @schema CfnModulePropsResources#PrivateSubnet2BNetworkAclEntryOutbound
     */
    readonly privateSubnet2BNetworkAclEntryOutbound?: CfnModulePropsResourcesPrivateSubnet2BNetworkAclEntryOutbound;
    /**
     * @schema CfnModulePropsResources#PrivateSubnet2BNetworkAclAssociation
     */
    readonly privateSubnet2BNetworkAclAssociation?: CfnModulePropsResourcesPrivateSubnet2BNetworkAclAssociation;
    /**
     * @schema CfnModulePropsResources#PrivateSubnet3BRouteTable
     */
    readonly privateSubnet3BRouteTable?: CfnModulePropsResourcesPrivateSubnet3BRouteTable;
    /**
     * @schema CfnModulePropsResources#PrivateSubnet3BRoute
     */
    readonly privateSubnet3BRoute?: CfnModulePropsResourcesPrivateSubnet3BRoute;
    /**
     * @schema CfnModulePropsResources#PrivateSubnet3BRouteTableAssociation
     */
    readonly privateSubnet3BRouteTableAssociation?: CfnModulePropsResourcesPrivateSubnet3BRouteTableAssociation;
    /**
     * @schema CfnModulePropsResources#PrivateSubnet3BNetworkAcl
     */
    readonly privateSubnet3BNetworkAcl?: CfnModulePropsResourcesPrivateSubnet3BNetworkAcl;
    /**
     * @schema CfnModulePropsResources#PrivateSubnet3BNetworkAclEntryInbound
     */
    readonly privateSubnet3BNetworkAclEntryInbound?: CfnModulePropsResourcesPrivateSubnet3BNetworkAclEntryInbound;
    /**
     * @schema CfnModulePropsResources#PrivateSubnet3BNetworkAclEntryOutbound
     */
    readonly privateSubnet3BNetworkAclEntryOutbound?: CfnModulePropsResourcesPrivateSubnet3BNetworkAclEntryOutbound;
    /**
     * @schema CfnModulePropsResources#PrivateSubnet3BNetworkAclAssociation
     */
    readonly privateSubnet3BNetworkAclAssociation?: CfnModulePropsResourcesPrivateSubnet3BNetworkAclAssociation;
    /**
     * @schema CfnModulePropsResources#PrivateSubnet4BRouteTable
     */
    readonly privateSubnet4BRouteTable?: CfnModulePropsResourcesPrivateSubnet4BRouteTable;
    /**
     * @schema CfnModulePropsResources#PrivateSubnet4BRoute
     */
    readonly privateSubnet4BRoute?: CfnModulePropsResourcesPrivateSubnet4BRoute;
    /**
     * @schema CfnModulePropsResources#PrivateSubnet4BRouteTableAssociation
     */
    readonly privateSubnet4BRouteTableAssociation?: CfnModulePropsResourcesPrivateSubnet4BRouteTableAssociation;
    /**
     * @schema CfnModulePropsResources#PrivateSubnet4BNetworkAcl
     */
    readonly privateSubnet4BNetworkAcl?: CfnModulePropsResourcesPrivateSubnet4BNetworkAcl;
    /**
     * @schema CfnModulePropsResources#PrivateSubnet4BNetworkAclEntryInbound
     */
    readonly privateSubnet4BNetworkAclEntryInbound?: CfnModulePropsResourcesPrivateSubnet4BNetworkAclEntryInbound;
    /**
     * @schema CfnModulePropsResources#PrivateSubnet4BNetworkAclEntryOutbound
     */
    readonly privateSubnet4BNetworkAclEntryOutbound?: CfnModulePropsResourcesPrivateSubnet4BNetworkAclEntryOutbound;
    /**
     * @schema CfnModulePropsResources#PrivateSubnet4BNetworkAclAssociation
     */
    readonly privateSubnet4BNetworkAclAssociation?: CfnModulePropsResourcesPrivateSubnet4BNetworkAclAssociation;
    /**
     * @schema CfnModulePropsResources#PublicSubnetRouteTable
     */
    readonly publicSubnetRouteTable?: CfnModulePropsResourcesPublicSubnetRouteTable;
    /**
     * @schema CfnModulePropsResources#PublicSubnetRoute
     */
    readonly publicSubnetRoute?: CfnModulePropsResourcesPublicSubnetRoute;
    /**
     * @schema CfnModulePropsResources#PublicSubnet1RouteTableAssociation
     */
    readonly publicSubnet1RouteTableAssociation?: CfnModulePropsResourcesPublicSubnet1RouteTableAssociation;
    /**
     * @schema CfnModulePropsResources#PublicSubnet2RouteTableAssociation
     */
    readonly publicSubnet2RouteTableAssociation?: CfnModulePropsResourcesPublicSubnet2RouteTableAssociation;
    /**
     * @schema CfnModulePropsResources#PublicSubnet3RouteTableAssociation
     */
    readonly publicSubnet3RouteTableAssociation?: CfnModulePropsResourcesPublicSubnet3RouteTableAssociation;
    /**
     * @schema CfnModulePropsResources#PublicSubnet4RouteTableAssociation
     */
    readonly publicSubnet4RouteTableAssociation?: CfnModulePropsResourcesPublicSubnet4RouteTableAssociation;
    /**
     * @schema CfnModulePropsResources#NAT1EIP
     */
    readonly nat1Eip?: CfnModulePropsResourcesNat1Eip;
    /**
     * @schema CfnModulePropsResources#NAT2EIP
     */
    readonly nat2Eip?: CfnModulePropsResourcesNat2Eip;
    /**
     * @schema CfnModulePropsResources#NAT3EIP
     */
    readonly nat3Eip?: CfnModulePropsResourcesNat3Eip;
    /**
     * @schema CfnModulePropsResources#NAT4EIP
     */
    readonly nat4Eip?: CfnModulePropsResourcesNat4Eip;
    /**
     * @schema CfnModulePropsResources#NATGateway1
     */
    readonly natGateway1?: CfnModulePropsResourcesNatGateway1;
    /**
     * @schema CfnModulePropsResources#NATGateway2
     */
    readonly natGateway2?: CfnModulePropsResourcesNatGateway2;
    /**
     * @schema CfnModulePropsResources#NATGateway3
     */
    readonly natGateway3?: CfnModulePropsResourcesNatGateway3;
    /**
     * @schema CfnModulePropsResources#NATGateway4
     */
    readonly natGateway4?: CfnModulePropsResourcesNatGateway4;
    /**
     * @schema CfnModulePropsResources#S3VPCEndpoint
     */
    readonly s3VpcEndpoint?: CfnModulePropsResourcesS3VpcEndpoint;
    /**
     * @schema CfnModulePropsResources#VPCFlowLogsRole
     */
    readonly vpcFlowLogsRole?: CfnModulePropsResourcesVpcFlowLogsRole;
    /**
     * @schema CfnModulePropsResources#VPCFlowLogsLogGroup
     */
    readonly vpcFlowLogsLogGroup?: CfnModulePropsResourcesVpcFlowLogsLogGroup;
    /**
     * @schema CfnModulePropsResources#VPCFlowLogsToCloudWatch
     */
    readonly vpcFlowLogsToCloudWatch?: CfnModulePropsResourcesVpcFlowLogsToCloudWatch;
}
/**
 * Converts an object of type 'CfnModulePropsResources' to JSON representation.
 */
export declare function toJson_CfnModulePropsResources(obj: CfnModulePropsResources | undefined): Record<string, any> | undefined;
/**
 * List of Availability Zones to use for the subnets in the VPC.
 *
 * Note: The logical order is preserved.
 *
 * @schema CfnModulePropsParametersAvailabilityZones
 */
export interface CfnModulePropsParametersAvailabilityZones {
    /**
     * @schema CfnModulePropsParametersAvailabilityZones#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersAvailabilityZones#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersAvailabilityZones' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersAvailabilityZones(obj: CfnModulePropsParametersAvailabilityZones | undefined): Record<string, any> | undefined;
/**
 * Set to true to create a network ACL protected subnet in each Availability Zone.
 *
 * If false, the CIDR parameters for those subnets will be ignored. If true, it also requires that the 'Create private subnets' parameter is also true to have any effect.
 *
 * @schema CfnModulePropsParametersCreateAdditionalPrivateSubnets
 */
export interface CfnModulePropsParametersCreateAdditionalPrivateSubnets {
    /**
     * @schema CfnModulePropsParametersCreateAdditionalPrivateSubnets#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersCreateAdditionalPrivateSubnets#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersCreateAdditionalPrivateSubnets' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersCreateAdditionalPrivateSubnets(obj: CfnModulePropsParametersCreateAdditionalPrivateSubnets | undefined): Record<string, any> | undefined;
/**
 * Set to false when creating only private subnets.
 *
 * If True, both CreatePublicSubnets and CreatePrivateSubnets must also be true.
 *
 * @schema CfnModulePropsParametersCreateNatGateways
 */
export interface CfnModulePropsParametersCreateNatGateways {
    /**
     * @schema CfnModulePropsParametersCreateNatGateways#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersCreateNatGateways#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersCreateNatGateways' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersCreateNatGateways(obj: CfnModulePropsParametersCreateNatGateways | undefined): Record<string, any> | undefined;
/**
 * Set to false to create only private subnets.
 *
 * If false, CreatePrivateSubnets must be True and the CIDR parameters for ALL public subnets will be ignored
 *
 * @schema CfnModulePropsParametersCreatePublicSubnets
 */
export interface CfnModulePropsParametersCreatePublicSubnets {
    /**
     * @schema CfnModulePropsParametersCreatePublicSubnets#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersCreatePublicSubnets#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersCreatePublicSubnets' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersCreatePublicSubnets(obj: CfnModulePropsParametersCreatePublicSubnets | undefined): Record<string, any> | undefined;
/**
 * Set to false to create only public subnets.
 *
 * If false, the CIDR parameters for ALL private subnets will be ignored.
 *
 * @schema CfnModulePropsParametersCreatePrivateSubnets
 */
export interface CfnModulePropsParametersCreatePrivateSubnets {
    /**
     * @schema CfnModulePropsParametersCreatePrivateSubnets#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersCreatePrivateSubnets#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersCreatePrivateSubnets' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersCreatePrivateSubnets(obj: CfnModulePropsParametersCreatePrivateSubnets | undefined): Record<string, any> | undefined;
/**
 * Set to true to create VPC flow logs for the VPC and publish them to CloudWatch.
 *
 * If false, VPC flow logs will not be created.
 *
 * @schema CfnModulePropsParametersCreateVpcFlowLogsToCloudWatch
 */
export interface CfnModulePropsParametersCreateVpcFlowLogsToCloudWatch {
    /**
     * @schema CfnModulePropsParametersCreateVpcFlowLogsToCloudWatch#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersCreateVpcFlowLogsToCloudWatch#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersCreateVpcFlowLogsToCloudWatch' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersCreateVpcFlowLogsToCloudWatch(obj: CfnModulePropsParametersCreateVpcFlowLogsToCloudWatch | undefined): Record<string, any> | undefined;
/**
 * Number of Availability Zones to use in the VPC.
 *
 * This must match your selections in the list of Availability Zones parameter.
 *
 * @schema CfnModulePropsParametersNumberOfAZs
 */
export interface CfnModulePropsParametersNumberOfAZs {
    /**
     * @schema CfnModulePropsParametersNumberOfAZs#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersNumberOfAZs#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersNumberOfAZs' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersNumberOfAZs(obj: CfnModulePropsParametersNumberOfAZs | undefined): Record<string, any> | undefined;
/**
 * CIDR block for private subnet 1A located in Availability Zone 1.
 *
 * @schema CfnModulePropsParametersPrivateSubnet1Acidr
 */
export interface CfnModulePropsParametersPrivateSubnet1Acidr {
    /**
     * @schema CfnModulePropsParametersPrivateSubnet1Acidr#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersPrivateSubnet1Acidr#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersPrivateSubnet1Acidr' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersPrivateSubnet1Acidr(obj: CfnModulePropsParametersPrivateSubnet1Acidr | undefined): Record<string, any> | undefined;
/**
 * CIDR block for private subnet 1B with dedicated network ACL located in Availability Zone 1.
 *
 * @schema CfnModulePropsParametersPrivateSubnet1Bcidr
 */
export interface CfnModulePropsParametersPrivateSubnet1Bcidr {
    /**
     * @schema CfnModulePropsParametersPrivateSubnet1Bcidr#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersPrivateSubnet1Bcidr#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersPrivateSubnet1Bcidr' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersPrivateSubnet1Bcidr(obj: CfnModulePropsParametersPrivateSubnet1Bcidr | undefined): Record<string, any> | undefined;
/**
 * CIDR block for private subnet 2A located in Availability Zone 2.
 *
 * @schema CfnModulePropsParametersPrivateSubnet2Acidr
 */
export interface CfnModulePropsParametersPrivateSubnet2Acidr {
    /**
     * @schema CfnModulePropsParametersPrivateSubnet2Acidr#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersPrivateSubnet2Acidr#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersPrivateSubnet2Acidr' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersPrivateSubnet2Acidr(obj: CfnModulePropsParametersPrivateSubnet2Acidr | undefined): Record<string, any> | undefined;
/**
 * CIDR block for private subnet 2B with dedicated network ACL located in Availability Zone 2.
 *
 * @schema CfnModulePropsParametersPrivateSubnet2Bcidr
 */
export interface CfnModulePropsParametersPrivateSubnet2Bcidr {
    /**
     * @schema CfnModulePropsParametersPrivateSubnet2Bcidr#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersPrivateSubnet2Bcidr#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersPrivateSubnet2Bcidr' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersPrivateSubnet2Bcidr(obj: CfnModulePropsParametersPrivateSubnet2Bcidr | undefined): Record<string, any> | undefined;
/**
 * CIDR block for private subnet 3A located in Availability Zone 3.
 *
 * @schema CfnModulePropsParametersPrivateSubnet3Acidr
 */
export interface CfnModulePropsParametersPrivateSubnet3Acidr {
    /**
     * @schema CfnModulePropsParametersPrivateSubnet3Acidr#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersPrivateSubnet3Acidr#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersPrivateSubnet3Acidr' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersPrivateSubnet3Acidr(obj: CfnModulePropsParametersPrivateSubnet3Acidr | undefined): Record<string, any> | undefined;
/**
 * CIDR block for private subnet 3B with dedicated network ACL located in Availability Zone 3.
 *
 * @schema CfnModulePropsParametersPrivateSubnet3Bcidr
 */
export interface CfnModulePropsParametersPrivateSubnet3Bcidr {
    /**
     * @schema CfnModulePropsParametersPrivateSubnet3Bcidr#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersPrivateSubnet3Bcidr#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersPrivateSubnet3Bcidr' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersPrivateSubnet3Bcidr(obj: CfnModulePropsParametersPrivateSubnet3Bcidr | undefined): Record<string, any> | undefined;
/**
 * CIDR block for private subnet 4A located in Availability Zone 4.
 *
 * @schema CfnModulePropsParametersPrivateSubnet4Acidr
 */
export interface CfnModulePropsParametersPrivateSubnet4Acidr {
    /**
     * @schema CfnModulePropsParametersPrivateSubnet4Acidr#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersPrivateSubnet4Acidr#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersPrivateSubnet4Acidr' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersPrivateSubnet4Acidr(obj: CfnModulePropsParametersPrivateSubnet4Acidr | undefined): Record<string, any> | undefined;
/**
 * CIDR block for private subnet 4B with dedicated network ACL located in Availability Zone 4.
 *
 * @schema CfnModulePropsParametersPrivateSubnet4Bcidr
 */
export interface CfnModulePropsParametersPrivateSubnet4Bcidr {
    /**
     * @schema CfnModulePropsParametersPrivateSubnet4Bcidr#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersPrivateSubnet4Bcidr#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersPrivateSubnet4Bcidr' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersPrivateSubnet4Bcidr(obj: CfnModulePropsParametersPrivateSubnet4Bcidr | undefined): Record<string, any> | undefined;
/**
 * tag to add to private subnets A, in format Key=Value (Optional).
 *
 * @schema CfnModulePropsParametersPrivateSubnetATag1
 */
export interface CfnModulePropsParametersPrivateSubnetATag1 {
    /**
     * @schema CfnModulePropsParametersPrivateSubnetATag1#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersPrivateSubnetATag1#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersPrivateSubnetATag1' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersPrivateSubnetATag1(obj: CfnModulePropsParametersPrivateSubnetATag1 | undefined): Record<string, any> | undefined;
/**
 * tag to add to private subnets A, in format Key=Value (Optional).
 *
 * @schema CfnModulePropsParametersPrivateSubnetATag2
 */
export interface CfnModulePropsParametersPrivateSubnetATag2 {
    /**
     * @schema CfnModulePropsParametersPrivateSubnetATag2#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersPrivateSubnetATag2#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersPrivateSubnetATag2' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersPrivateSubnetATag2(obj: CfnModulePropsParametersPrivateSubnetATag2 | undefined): Record<string, any> | undefined;
/**
 * tag to add to private subnets A, in format Key=Value (Optional).
 *
 * @schema CfnModulePropsParametersPrivateSubnetATag3
 */
export interface CfnModulePropsParametersPrivateSubnetATag3 {
    /**
     * @schema CfnModulePropsParametersPrivateSubnetATag3#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersPrivateSubnetATag3#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersPrivateSubnetATag3' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersPrivateSubnetATag3(obj: CfnModulePropsParametersPrivateSubnetATag3 | undefined): Record<string, any> | undefined;
/**
 * tag to add to private subnets B, in format Key=Value (Optional).
 *
 * @schema CfnModulePropsParametersPrivateSubnetBTag1
 */
export interface CfnModulePropsParametersPrivateSubnetBTag1 {
    /**
     * @schema CfnModulePropsParametersPrivateSubnetBTag1#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersPrivateSubnetBTag1#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersPrivateSubnetBTag1' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersPrivateSubnetBTag1(obj: CfnModulePropsParametersPrivateSubnetBTag1 | undefined): Record<string, any> | undefined;
/**
 * tag to add to private subnets B, in format Key=Value (Optional).
 *
 * @schema CfnModulePropsParametersPrivateSubnetBTag2
 */
export interface CfnModulePropsParametersPrivateSubnetBTag2 {
    /**
     * @schema CfnModulePropsParametersPrivateSubnetBTag2#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersPrivateSubnetBTag2#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersPrivateSubnetBTag2' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersPrivateSubnetBTag2(obj: CfnModulePropsParametersPrivateSubnetBTag2 | undefined): Record<string, any> | undefined;
/**
 * tag to add to private subnets B, in format Key=Value (Optional).
 *
 * @schema CfnModulePropsParametersPrivateSubnetBTag3
 */
export interface CfnModulePropsParametersPrivateSubnetBTag3 {
    /**
     * @schema CfnModulePropsParametersPrivateSubnetBTag3#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersPrivateSubnetBTag3#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersPrivateSubnetBTag3' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersPrivateSubnetBTag3(obj: CfnModulePropsParametersPrivateSubnetBTag3 | undefined): Record<string, any> | undefined;
/**
 * CIDR block for the public DMZ subnet 1 located in Availability Zone 1.
 *
 * @schema CfnModulePropsParametersPublicSubnet1Cidr
 */
export interface CfnModulePropsParametersPublicSubnet1Cidr {
    /**
     * @schema CfnModulePropsParametersPublicSubnet1Cidr#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersPublicSubnet1Cidr#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersPublicSubnet1Cidr' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersPublicSubnet1Cidr(obj: CfnModulePropsParametersPublicSubnet1Cidr | undefined): Record<string, any> | undefined;
/**
 * CIDR block for the public DMZ subnet 2 located in Availability Zone 2.
 *
 * @schema CfnModulePropsParametersPublicSubnet2Cidr
 */
export interface CfnModulePropsParametersPublicSubnet2Cidr {
    /**
     * @schema CfnModulePropsParametersPublicSubnet2Cidr#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersPublicSubnet2Cidr#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersPublicSubnet2Cidr' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersPublicSubnet2Cidr(obj: CfnModulePropsParametersPublicSubnet2Cidr | undefined): Record<string, any> | undefined;
/**
 * CIDR block for the public DMZ subnet 3 located in Availability Zone 3.
 *
 * @schema CfnModulePropsParametersPublicSubnet3Cidr
 */
export interface CfnModulePropsParametersPublicSubnet3Cidr {
    /**
     * @schema CfnModulePropsParametersPublicSubnet3Cidr#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersPublicSubnet3Cidr#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersPublicSubnet3Cidr' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersPublicSubnet3Cidr(obj: CfnModulePropsParametersPublicSubnet3Cidr | undefined): Record<string, any> | undefined;
/**
 * CIDR block for the public DMZ subnet 4 located in Availability Zone 4.
 *
 * @schema CfnModulePropsParametersPublicSubnet4Cidr
 */
export interface CfnModulePropsParametersPublicSubnet4Cidr {
    /**
     * @schema CfnModulePropsParametersPublicSubnet4Cidr#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersPublicSubnet4Cidr#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersPublicSubnet4Cidr' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersPublicSubnet4Cidr(obj: CfnModulePropsParametersPublicSubnet4Cidr | undefined): Record<string, any> | undefined;
/**
 * tag to add to public subnets, in format Key=Value (Optional).
 *
 * @schema CfnModulePropsParametersPublicSubnetTag1
 */
export interface CfnModulePropsParametersPublicSubnetTag1 {
    /**
     * @schema CfnModulePropsParametersPublicSubnetTag1#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersPublicSubnetTag1#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersPublicSubnetTag1' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersPublicSubnetTag1(obj: CfnModulePropsParametersPublicSubnetTag1 | undefined): Record<string, any> | undefined;
/**
 * tag to add to public subnets, in format Key=Value (Optional).
 *
 * @schema CfnModulePropsParametersPublicSubnetTag2
 */
export interface CfnModulePropsParametersPublicSubnetTag2 {
    /**
     * @schema CfnModulePropsParametersPublicSubnetTag2#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersPublicSubnetTag2#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersPublicSubnetTag2' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersPublicSubnetTag2(obj: CfnModulePropsParametersPublicSubnetTag2 | undefined): Record<string, any> | undefined;
/**
 * tag to add to public subnets, in format Key=Value (Optional).
 *
 * @schema CfnModulePropsParametersPublicSubnetTag3
 */
export interface CfnModulePropsParametersPublicSubnetTag3 {
    /**
     * @schema CfnModulePropsParametersPublicSubnetTag3#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersPublicSubnetTag3#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersPublicSubnetTag3' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersPublicSubnetTag3(obj: CfnModulePropsParametersPublicSubnetTag3 | undefined): Record<string, any> | undefined;
/**
 * CIDR block for the VPC.
 *
 * @schema CfnModulePropsParametersVpccidr
 */
export interface CfnModulePropsParametersVpccidr {
    /**
     * @schema CfnModulePropsParametersVpccidr#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersVpccidr#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersVpccidr' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersVpccidr(obj: CfnModulePropsParametersVpccidr | undefined): Record<string, any> | undefined;
/**
 * (Optional) KMS Key ARN to use for encrypting the VPC flow logs data.
 *
 * If empty, encryption is enabled with CloudWatch Logs managing the server-side encryption keys.
 *
 * @schema CfnModulePropsParametersVpcFlowLogsCloudWatchKmsKey
 */
export interface CfnModulePropsParametersVpcFlowLogsCloudWatchKmsKey {
    /**
     * @schema CfnModulePropsParametersVpcFlowLogsCloudWatchKmsKey#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersVpcFlowLogsCloudWatchKmsKey#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersVpcFlowLogsCloudWatchKmsKey' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersVpcFlowLogsCloudWatchKmsKey(obj: CfnModulePropsParametersVpcFlowLogsCloudWatchKmsKey | undefined): Record<string, any> | undefined;
/**
 * The fields to include in the flow log record, in the order in which they should appear.
 *
 * Specify the fields using the ${field-id} format, separated by spaces. Using the Default Format as the default value.
 *
 * @schema CfnModulePropsParametersVpcFlowLogsLogFormat
 */
export interface CfnModulePropsParametersVpcFlowLogsLogFormat {
    /**
     * @schema CfnModulePropsParametersVpcFlowLogsLogFormat#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersVpcFlowLogsLogFormat#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersVpcFlowLogsLogFormat' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersVpcFlowLogsLogFormat(obj: CfnModulePropsParametersVpcFlowLogsLogFormat | undefined): Record<string, any> | undefined;
/**
 * Number of days to retain the VPC Flow Logs in CloudWatch.
 *
 * @schema CfnModulePropsParametersVpcFlowLogsLogGroupRetention
 */
export interface CfnModulePropsParametersVpcFlowLogsLogGroupRetention {
    /**
     * @schema CfnModulePropsParametersVpcFlowLogsLogGroupRetention#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersVpcFlowLogsLogGroupRetention#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersVpcFlowLogsLogGroupRetention' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersVpcFlowLogsLogGroupRetention(obj: CfnModulePropsParametersVpcFlowLogsLogGroupRetention | undefined): Record<string, any> | undefined;
/**
 * The maximum interval of time during which a flow of packets is captured and aggregated into a flow log record.
 *
 * You can specify 60 seconds (1 minute) or 600 seconds (10 minutes).
 *
 * @schema CfnModulePropsParametersVpcFlowLogsMaxAggregationInterval
 */
export interface CfnModulePropsParametersVpcFlowLogsMaxAggregationInterval {
    /**
     * @schema CfnModulePropsParametersVpcFlowLogsMaxAggregationInterval#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersVpcFlowLogsMaxAggregationInterval#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersVpcFlowLogsMaxAggregationInterval' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersVpcFlowLogsMaxAggregationInterval(obj: CfnModulePropsParametersVpcFlowLogsMaxAggregationInterval | undefined): Record<string, any> | undefined;
/**
 * The type of traffic to log.
 *
 * You can log traffic that the resource accepts or rejects, or all traffic.
 *
 * @schema CfnModulePropsParametersVpcFlowLogsTrafficType
 */
export interface CfnModulePropsParametersVpcFlowLogsTrafficType {
    /**
     * @schema CfnModulePropsParametersVpcFlowLogsTrafficType#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersVpcFlowLogsTrafficType#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersVpcFlowLogsTrafficType' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersVpcFlowLogsTrafficType(obj: CfnModulePropsParametersVpcFlowLogsTrafficType | undefined): Record<string, any> | undefined;
/**
 * The allowed tenancy of instances launched into the VPC.
 *
 * @schema CfnModulePropsParametersVpcTenancy
 */
export interface CfnModulePropsParametersVpcTenancy {
    /**
     * @schema CfnModulePropsParametersVpcTenancy#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersVpcTenancy#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersVpcTenancy' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersVpcTenancy(obj: CfnModulePropsParametersVpcTenancy | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesDhcpOptions
 */
export interface CfnModulePropsResourcesDhcpOptions {
    /**
     * @schema CfnModulePropsResourcesDhcpOptions#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesDhcpOptions#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesDhcpOptions' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesDhcpOptions(obj: CfnModulePropsResourcesDhcpOptions | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesVpc
 */
export interface CfnModulePropsResourcesVpc {
    /**
     * @schema CfnModulePropsResourcesVpc#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesVpc#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesVpc' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesVpc(obj: CfnModulePropsResourcesVpc | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesVpcdhcpOptionsAssociation
 */
export interface CfnModulePropsResourcesVpcdhcpOptionsAssociation {
    /**
     * @schema CfnModulePropsResourcesVpcdhcpOptionsAssociation#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesVpcdhcpOptionsAssociation#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesVpcdhcpOptionsAssociation' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesVpcdhcpOptionsAssociation(obj: CfnModulePropsResourcesVpcdhcpOptionsAssociation | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesInternetGateway
 */
export interface CfnModulePropsResourcesInternetGateway {
    /**
     * @schema CfnModulePropsResourcesInternetGateway#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesInternetGateway#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesInternetGateway' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesInternetGateway(obj: CfnModulePropsResourcesInternetGateway | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesVpcGatewayAttachment
 */
export interface CfnModulePropsResourcesVpcGatewayAttachment {
    /**
     * @schema CfnModulePropsResourcesVpcGatewayAttachment#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesVpcGatewayAttachment#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesVpcGatewayAttachment' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesVpcGatewayAttachment(obj: CfnModulePropsResourcesVpcGatewayAttachment | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesPrivateSubnet1A
 */
export interface CfnModulePropsResourcesPrivateSubnet1A {
    /**
     * @schema CfnModulePropsResourcesPrivateSubnet1A#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesPrivateSubnet1A#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesPrivateSubnet1A' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesPrivateSubnet1A(obj: CfnModulePropsResourcesPrivateSubnet1A | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesPrivateSubnet1B
 */
export interface CfnModulePropsResourcesPrivateSubnet1B {
    /**
     * @schema CfnModulePropsResourcesPrivateSubnet1B#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesPrivateSubnet1B#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesPrivateSubnet1B' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesPrivateSubnet1B(obj: CfnModulePropsResourcesPrivateSubnet1B | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesPrivateSubnet2A
 */
export interface CfnModulePropsResourcesPrivateSubnet2A {
    /**
     * @schema CfnModulePropsResourcesPrivateSubnet2A#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesPrivateSubnet2A#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesPrivateSubnet2A' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesPrivateSubnet2A(obj: CfnModulePropsResourcesPrivateSubnet2A | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesPrivateSubnet2B
 */
export interface CfnModulePropsResourcesPrivateSubnet2B {
    /**
     * @schema CfnModulePropsResourcesPrivateSubnet2B#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesPrivateSubnet2B#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesPrivateSubnet2B' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesPrivateSubnet2B(obj: CfnModulePropsResourcesPrivateSubnet2B | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesPrivateSubnet3A
 */
export interface CfnModulePropsResourcesPrivateSubnet3A {
    /**
     * @schema CfnModulePropsResourcesPrivateSubnet3A#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesPrivateSubnet3A#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesPrivateSubnet3A' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesPrivateSubnet3A(obj: CfnModulePropsResourcesPrivateSubnet3A | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesPrivateSubnet3B
 */
export interface CfnModulePropsResourcesPrivateSubnet3B {
    /**
     * @schema CfnModulePropsResourcesPrivateSubnet3B#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesPrivateSubnet3B#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesPrivateSubnet3B' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesPrivateSubnet3B(obj: CfnModulePropsResourcesPrivateSubnet3B | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesPrivateSubnet4A
 */
export interface CfnModulePropsResourcesPrivateSubnet4A {
    /**
     * @schema CfnModulePropsResourcesPrivateSubnet4A#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesPrivateSubnet4A#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesPrivateSubnet4A' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesPrivateSubnet4A(obj: CfnModulePropsResourcesPrivateSubnet4A | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesPrivateSubnet4B
 */
export interface CfnModulePropsResourcesPrivateSubnet4B {
    /**
     * @schema CfnModulePropsResourcesPrivateSubnet4B#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesPrivateSubnet4B#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesPrivateSubnet4B' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesPrivateSubnet4B(obj: CfnModulePropsResourcesPrivateSubnet4B | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesPublicSubnet1
 */
export interface CfnModulePropsResourcesPublicSubnet1 {
    /**
     * @schema CfnModulePropsResourcesPublicSubnet1#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesPublicSubnet1#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesPublicSubnet1' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesPublicSubnet1(obj: CfnModulePropsResourcesPublicSubnet1 | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesPublicSubnet2
 */
export interface CfnModulePropsResourcesPublicSubnet2 {
    /**
     * @schema CfnModulePropsResourcesPublicSubnet2#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesPublicSubnet2#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesPublicSubnet2' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesPublicSubnet2(obj: CfnModulePropsResourcesPublicSubnet2 | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesPublicSubnet3
 */
export interface CfnModulePropsResourcesPublicSubnet3 {
    /**
     * @schema CfnModulePropsResourcesPublicSubnet3#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesPublicSubnet3#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesPublicSubnet3' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesPublicSubnet3(obj: CfnModulePropsResourcesPublicSubnet3 | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesPublicSubnet4
 */
export interface CfnModulePropsResourcesPublicSubnet4 {
    /**
     * @schema CfnModulePropsResourcesPublicSubnet4#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesPublicSubnet4#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesPublicSubnet4' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesPublicSubnet4(obj: CfnModulePropsResourcesPublicSubnet4 | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesPrivateSubnet1ARouteTable
 */
export interface CfnModulePropsResourcesPrivateSubnet1ARouteTable {
    /**
     * @schema CfnModulePropsResourcesPrivateSubnet1ARouteTable#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesPrivateSubnet1ARouteTable#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesPrivateSubnet1ARouteTable' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesPrivateSubnet1ARouteTable(obj: CfnModulePropsResourcesPrivateSubnet1ARouteTable | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesPrivateSubnet1ARoute
 */
export interface CfnModulePropsResourcesPrivateSubnet1ARoute {
    /**
     * @schema CfnModulePropsResourcesPrivateSubnet1ARoute#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesPrivateSubnet1ARoute#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesPrivateSubnet1ARoute' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesPrivateSubnet1ARoute(obj: CfnModulePropsResourcesPrivateSubnet1ARoute | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesPrivateSubnet1ARouteTableAssociation
 */
export interface CfnModulePropsResourcesPrivateSubnet1ARouteTableAssociation {
    /**
     * @schema CfnModulePropsResourcesPrivateSubnet1ARouteTableAssociation#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesPrivateSubnet1ARouteTableAssociation#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesPrivateSubnet1ARouteTableAssociation' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesPrivateSubnet1ARouteTableAssociation(obj: CfnModulePropsResourcesPrivateSubnet1ARouteTableAssociation | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesPrivateSubnet2ARouteTable
 */
export interface CfnModulePropsResourcesPrivateSubnet2ARouteTable {
    /**
     * @schema CfnModulePropsResourcesPrivateSubnet2ARouteTable#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesPrivateSubnet2ARouteTable#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesPrivateSubnet2ARouteTable' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesPrivateSubnet2ARouteTable(obj: CfnModulePropsResourcesPrivateSubnet2ARouteTable | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesPrivateSubnet2ARoute
 */
export interface CfnModulePropsResourcesPrivateSubnet2ARoute {
    /**
     * @schema CfnModulePropsResourcesPrivateSubnet2ARoute#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesPrivateSubnet2ARoute#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesPrivateSubnet2ARoute' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesPrivateSubnet2ARoute(obj: CfnModulePropsResourcesPrivateSubnet2ARoute | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesPrivateSubnet2ARouteTableAssociation
 */
export interface CfnModulePropsResourcesPrivateSubnet2ARouteTableAssociation {
    /**
     * @schema CfnModulePropsResourcesPrivateSubnet2ARouteTableAssociation#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesPrivateSubnet2ARouteTableAssociation#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesPrivateSubnet2ARouteTableAssociation' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesPrivateSubnet2ARouteTableAssociation(obj: CfnModulePropsResourcesPrivateSubnet2ARouteTableAssociation | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesPrivateSubnet3ARouteTable
 */
export interface CfnModulePropsResourcesPrivateSubnet3ARouteTable {
    /**
     * @schema CfnModulePropsResourcesPrivateSubnet3ARouteTable#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesPrivateSubnet3ARouteTable#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesPrivateSubnet3ARouteTable' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesPrivateSubnet3ARouteTable(obj: CfnModulePropsResourcesPrivateSubnet3ARouteTable | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesPrivateSubnet3ARoute
 */
export interface CfnModulePropsResourcesPrivateSubnet3ARoute {
    /**
     * @schema CfnModulePropsResourcesPrivateSubnet3ARoute#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesPrivateSubnet3ARoute#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesPrivateSubnet3ARoute' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesPrivateSubnet3ARoute(obj: CfnModulePropsResourcesPrivateSubnet3ARoute | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesPrivateSubnet3ARouteTableAssociation
 */
export interface CfnModulePropsResourcesPrivateSubnet3ARouteTableAssociation {
    /**
     * @schema CfnModulePropsResourcesPrivateSubnet3ARouteTableAssociation#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesPrivateSubnet3ARouteTableAssociation#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesPrivateSubnet3ARouteTableAssociation' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesPrivateSubnet3ARouteTableAssociation(obj: CfnModulePropsResourcesPrivateSubnet3ARouteTableAssociation | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesPrivateSubnet4ARouteTable
 */
export interface CfnModulePropsResourcesPrivateSubnet4ARouteTable {
    /**
     * @schema CfnModulePropsResourcesPrivateSubnet4ARouteTable#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesPrivateSubnet4ARouteTable#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesPrivateSubnet4ARouteTable' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesPrivateSubnet4ARouteTable(obj: CfnModulePropsResourcesPrivateSubnet4ARouteTable | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesPrivateSubnet4ARoute
 */
export interface CfnModulePropsResourcesPrivateSubnet4ARoute {
    /**
     * @schema CfnModulePropsResourcesPrivateSubnet4ARoute#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesPrivateSubnet4ARoute#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesPrivateSubnet4ARoute' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesPrivateSubnet4ARoute(obj: CfnModulePropsResourcesPrivateSubnet4ARoute | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesPrivateSubnet4ARouteTableAssociation
 */
export interface CfnModulePropsResourcesPrivateSubnet4ARouteTableAssociation {
    /**
     * @schema CfnModulePropsResourcesPrivateSubnet4ARouteTableAssociation#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesPrivateSubnet4ARouteTableAssociation#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesPrivateSubnet4ARouteTableAssociation' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesPrivateSubnet4ARouteTableAssociation(obj: CfnModulePropsResourcesPrivateSubnet4ARouteTableAssociation | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesPrivateSubnet1BRouteTable
 */
export interface CfnModulePropsResourcesPrivateSubnet1BRouteTable {
    /**
     * @schema CfnModulePropsResourcesPrivateSubnet1BRouteTable#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesPrivateSubnet1BRouteTable#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesPrivateSubnet1BRouteTable' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesPrivateSubnet1BRouteTable(obj: CfnModulePropsResourcesPrivateSubnet1BRouteTable | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesPrivateSubnet1BRoute
 */
export interface CfnModulePropsResourcesPrivateSubnet1BRoute {
    /**
     * @schema CfnModulePropsResourcesPrivateSubnet1BRoute#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesPrivateSubnet1BRoute#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesPrivateSubnet1BRoute' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesPrivateSubnet1BRoute(obj: CfnModulePropsResourcesPrivateSubnet1BRoute | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesPrivateSubnet1BRouteTableAssociation
 */
export interface CfnModulePropsResourcesPrivateSubnet1BRouteTableAssociation {
    /**
     * @schema CfnModulePropsResourcesPrivateSubnet1BRouteTableAssociation#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesPrivateSubnet1BRouteTableAssociation#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesPrivateSubnet1BRouteTableAssociation' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesPrivateSubnet1BRouteTableAssociation(obj: CfnModulePropsResourcesPrivateSubnet1BRouteTableAssociation | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesPrivateSubnet1BNetworkAcl
 */
export interface CfnModulePropsResourcesPrivateSubnet1BNetworkAcl {
    /**
     * @schema CfnModulePropsResourcesPrivateSubnet1BNetworkAcl#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesPrivateSubnet1BNetworkAcl#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesPrivateSubnet1BNetworkAcl' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesPrivateSubnet1BNetworkAcl(obj: CfnModulePropsResourcesPrivateSubnet1BNetworkAcl | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesPrivateSubnet1BNetworkAclEntryInbound
 */
export interface CfnModulePropsResourcesPrivateSubnet1BNetworkAclEntryInbound {
    /**
     * @schema CfnModulePropsResourcesPrivateSubnet1BNetworkAclEntryInbound#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesPrivateSubnet1BNetworkAclEntryInbound#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesPrivateSubnet1BNetworkAclEntryInbound' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesPrivateSubnet1BNetworkAclEntryInbound(obj: CfnModulePropsResourcesPrivateSubnet1BNetworkAclEntryInbound | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesPrivateSubnet1BNetworkAclEntryOutbound
 */
export interface CfnModulePropsResourcesPrivateSubnet1BNetworkAclEntryOutbound {
    /**
     * @schema CfnModulePropsResourcesPrivateSubnet1BNetworkAclEntryOutbound#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesPrivateSubnet1BNetworkAclEntryOutbound#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesPrivateSubnet1BNetworkAclEntryOutbound' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesPrivateSubnet1BNetworkAclEntryOutbound(obj: CfnModulePropsResourcesPrivateSubnet1BNetworkAclEntryOutbound | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesPrivateSubnet1BNetworkAclAssociation
 */
export interface CfnModulePropsResourcesPrivateSubnet1BNetworkAclAssociation {
    /**
     * @schema CfnModulePropsResourcesPrivateSubnet1BNetworkAclAssociation#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesPrivateSubnet1BNetworkAclAssociation#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesPrivateSubnet1BNetworkAclAssociation' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesPrivateSubnet1BNetworkAclAssociation(obj: CfnModulePropsResourcesPrivateSubnet1BNetworkAclAssociation | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesPrivateSubnet2BRouteTable
 */
export interface CfnModulePropsResourcesPrivateSubnet2BRouteTable {
    /**
     * @schema CfnModulePropsResourcesPrivateSubnet2BRouteTable#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesPrivateSubnet2BRouteTable#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesPrivateSubnet2BRouteTable' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesPrivateSubnet2BRouteTable(obj: CfnModulePropsResourcesPrivateSubnet2BRouteTable | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesPrivateSubnet2BRoute
 */
export interface CfnModulePropsResourcesPrivateSubnet2BRoute {
    /**
     * @schema CfnModulePropsResourcesPrivateSubnet2BRoute#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesPrivateSubnet2BRoute#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesPrivateSubnet2BRoute' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesPrivateSubnet2BRoute(obj: CfnModulePropsResourcesPrivateSubnet2BRoute | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesPrivateSubnet2BRouteTableAssociation
 */
export interface CfnModulePropsResourcesPrivateSubnet2BRouteTableAssociation {
    /**
     * @schema CfnModulePropsResourcesPrivateSubnet2BRouteTableAssociation#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesPrivateSubnet2BRouteTableAssociation#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesPrivateSubnet2BRouteTableAssociation' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesPrivateSubnet2BRouteTableAssociation(obj: CfnModulePropsResourcesPrivateSubnet2BRouteTableAssociation | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesPrivateSubnet2BNetworkAcl
 */
export interface CfnModulePropsResourcesPrivateSubnet2BNetworkAcl {
    /**
     * @schema CfnModulePropsResourcesPrivateSubnet2BNetworkAcl#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesPrivateSubnet2BNetworkAcl#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesPrivateSubnet2BNetworkAcl' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesPrivateSubnet2BNetworkAcl(obj: CfnModulePropsResourcesPrivateSubnet2BNetworkAcl | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesPrivateSubnet2BNetworkAclEntryInbound
 */
export interface CfnModulePropsResourcesPrivateSubnet2BNetworkAclEntryInbound {
    /**
     * @schema CfnModulePropsResourcesPrivateSubnet2BNetworkAclEntryInbound#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesPrivateSubnet2BNetworkAclEntryInbound#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesPrivateSubnet2BNetworkAclEntryInbound' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesPrivateSubnet2BNetworkAclEntryInbound(obj: CfnModulePropsResourcesPrivateSubnet2BNetworkAclEntryInbound | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesPrivateSubnet2BNetworkAclEntryOutbound
 */
export interface CfnModulePropsResourcesPrivateSubnet2BNetworkAclEntryOutbound {
    /**
     * @schema CfnModulePropsResourcesPrivateSubnet2BNetworkAclEntryOutbound#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesPrivateSubnet2BNetworkAclEntryOutbound#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesPrivateSubnet2BNetworkAclEntryOutbound' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesPrivateSubnet2BNetworkAclEntryOutbound(obj: CfnModulePropsResourcesPrivateSubnet2BNetworkAclEntryOutbound | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesPrivateSubnet2BNetworkAclAssociation
 */
export interface CfnModulePropsResourcesPrivateSubnet2BNetworkAclAssociation {
    /**
     * @schema CfnModulePropsResourcesPrivateSubnet2BNetworkAclAssociation#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesPrivateSubnet2BNetworkAclAssociation#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesPrivateSubnet2BNetworkAclAssociation' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesPrivateSubnet2BNetworkAclAssociation(obj: CfnModulePropsResourcesPrivateSubnet2BNetworkAclAssociation | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesPrivateSubnet3BRouteTable
 */
export interface CfnModulePropsResourcesPrivateSubnet3BRouteTable {
    /**
     * @schema CfnModulePropsResourcesPrivateSubnet3BRouteTable#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesPrivateSubnet3BRouteTable#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesPrivateSubnet3BRouteTable' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesPrivateSubnet3BRouteTable(obj: CfnModulePropsResourcesPrivateSubnet3BRouteTable | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesPrivateSubnet3BRoute
 */
export interface CfnModulePropsResourcesPrivateSubnet3BRoute {
    /**
     * @schema CfnModulePropsResourcesPrivateSubnet3BRoute#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesPrivateSubnet3BRoute#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesPrivateSubnet3BRoute' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesPrivateSubnet3BRoute(obj: CfnModulePropsResourcesPrivateSubnet3BRoute | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesPrivateSubnet3BRouteTableAssociation
 */
export interface CfnModulePropsResourcesPrivateSubnet3BRouteTableAssociation {
    /**
     * @schema CfnModulePropsResourcesPrivateSubnet3BRouteTableAssociation#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesPrivateSubnet3BRouteTableAssociation#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesPrivateSubnet3BRouteTableAssociation' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesPrivateSubnet3BRouteTableAssociation(obj: CfnModulePropsResourcesPrivateSubnet3BRouteTableAssociation | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesPrivateSubnet3BNetworkAcl
 */
export interface CfnModulePropsResourcesPrivateSubnet3BNetworkAcl {
    /**
     * @schema CfnModulePropsResourcesPrivateSubnet3BNetworkAcl#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesPrivateSubnet3BNetworkAcl#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesPrivateSubnet3BNetworkAcl' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesPrivateSubnet3BNetworkAcl(obj: CfnModulePropsResourcesPrivateSubnet3BNetworkAcl | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesPrivateSubnet3BNetworkAclEntryInbound
 */
export interface CfnModulePropsResourcesPrivateSubnet3BNetworkAclEntryInbound {
    /**
     * @schema CfnModulePropsResourcesPrivateSubnet3BNetworkAclEntryInbound#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesPrivateSubnet3BNetworkAclEntryInbound#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesPrivateSubnet3BNetworkAclEntryInbound' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesPrivateSubnet3BNetworkAclEntryInbound(obj: CfnModulePropsResourcesPrivateSubnet3BNetworkAclEntryInbound | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesPrivateSubnet3BNetworkAclEntryOutbound
 */
export interface CfnModulePropsResourcesPrivateSubnet3BNetworkAclEntryOutbound {
    /**
     * @schema CfnModulePropsResourcesPrivateSubnet3BNetworkAclEntryOutbound#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesPrivateSubnet3BNetworkAclEntryOutbound#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesPrivateSubnet3BNetworkAclEntryOutbound' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesPrivateSubnet3BNetworkAclEntryOutbound(obj: CfnModulePropsResourcesPrivateSubnet3BNetworkAclEntryOutbound | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesPrivateSubnet3BNetworkAclAssociation
 */
export interface CfnModulePropsResourcesPrivateSubnet3BNetworkAclAssociation {
    /**
     * @schema CfnModulePropsResourcesPrivateSubnet3BNetworkAclAssociation#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesPrivateSubnet3BNetworkAclAssociation#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesPrivateSubnet3BNetworkAclAssociation' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesPrivateSubnet3BNetworkAclAssociation(obj: CfnModulePropsResourcesPrivateSubnet3BNetworkAclAssociation | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesPrivateSubnet4BRouteTable
 */
export interface CfnModulePropsResourcesPrivateSubnet4BRouteTable {
    /**
     * @schema CfnModulePropsResourcesPrivateSubnet4BRouteTable#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesPrivateSubnet4BRouteTable#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesPrivateSubnet4BRouteTable' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesPrivateSubnet4BRouteTable(obj: CfnModulePropsResourcesPrivateSubnet4BRouteTable | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesPrivateSubnet4BRoute
 */
export interface CfnModulePropsResourcesPrivateSubnet4BRoute {
    /**
     * @schema CfnModulePropsResourcesPrivateSubnet4BRoute#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesPrivateSubnet4BRoute#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesPrivateSubnet4BRoute' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesPrivateSubnet4BRoute(obj: CfnModulePropsResourcesPrivateSubnet4BRoute | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesPrivateSubnet4BRouteTableAssociation
 */
export interface CfnModulePropsResourcesPrivateSubnet4BRouteTableAssociation {
    /**
     * @schema CfnModulePropsResourcesPrivateSubnet4BRouteTableAssociation#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesPrivateSubnet4BRouteTableAssociation#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesPrivateSubnet4BRouteTableAssociation' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesPrivateSubnet4BRouteTableAssociation(obj: CfnModulePropsResourcesPrivateSubnet4BRouteTableAssociation | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesPrivateSubnet4BNetworkAcl
 */
export interface CfnModulePropsResourcesPrivateSubnet4BNetworkAcl {
    /**
     * @schema CfnModulePropsResourcesPrivateSubnet4BNetworkAcl#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesPrivateSubnet4BNetworkAcl#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesPrivateSubnet4BNetworkAcl' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesPrivateSubnet4BNetworkAcl(obj: CfnModulePropsResourcesPrivateSubnet4BNetworkAcl | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesPrivateSubnet4BNetworkAclEntryInbound
 */
export interface CfnModulePropsResourcesPrivateSubnet4BNetworkAclEntryInbound {
    /**
     * @schema CfnModulePropsResourcesPrivateSubnet4BNetworkAclEntryInbound#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesPrivateSubnet4BNetworkAclEntryInbound#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesPrivateSubnet4BNetworkAclEntryInbound' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesPrivateSubnet4BNetworkAclEntryInbound(obj: CfnModulePropsResourcesPrivateSubnet4BNetworkAclEntryInbound | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesPrivateSubnet4BNetworkAclEntryOutbound
 */
export interface CfnModulePropsResourcesPrivateSubnet4BNetworkAclEntryOutbound {
    /**
     * @schema CfnModulePropsResourcesPrivateSubnet4BNetworkAclEntryOutbound#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesPrivateSubnet4BNetworkAclEntryOutbound#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesPrivateSubnet4BNetworkAclEntryOutbound' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesPrivateSubnet4BNetworkAclEntryOutbound(obj: CfnModulePropsResourcesPrivateSubnet4BNetworkAclEntryOutbound | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesPrivateSubnet4BNetworkAclAssociation
 */
export interface CfnModulePropsResourcesPrivateSubnet4BNetworkAclAssociation {
    /**
     * @schema CfnModulePropsResourcesPrivateSubnet4BNetworkAclAssociation#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesPrivateSubnet4BNetworkAclAssociation#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesPrivateSubnet4BNetworkAclAssociation' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesPrivateSubnet4BNetworkAclAssociation(obj: CfnModulePropsResourcesPrivateSubnet4BNetworkAclAssociation | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesPublicSubnetRouteTable
 */
export interface CfnModulePropsResourcesPublicSubnetRouteTable {
    /**
     * @schema CfnModulePropsResourcesPublicSubnetRouteTable#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesPublicSubnetRouteTable#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesPublicSubnetRouteTable' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesPublicSubnetRouteTable(obj: CfnModulePropsResourcesPublicSubnetRouteTable | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesPublicSubnetRoute
 */
export interface CfnModulePropsResourcesPublicSubnetRoute {
    /**
     * @schema CfnModulePropsResourcesPublicSubnetRoute#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesPublicSubnetRoute#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesPublicSubnetRoute' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesPublicSubnetRoute(obj: CfnModulePropsResourcesPublicSubnetRoute | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesPublicSubnet1RouteTableAssociation
 */
export interface CfnModulePropsResourcesPublicSubnet1RouteTableAssociation {
    /**
     * @schema CfnModulePropsResourcesPublicSubnet1RouteTableAssociation#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesPublicSubnet1RouteTableAssociation#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesPublicSubnet1RouteTableAssociation' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesPublicSubnet1RouteTableAssociation(obj: CfnModulePropsResourcesPublicSubnet1RouteTableAssociation | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesPublicSubnet2RouteTableAssociation
 */
export interface CfnModulePropsResourcesPublicSubnet2RouteTableAssociation {
    /**
     * @schema CfnModulePropsResourcesPublicSubnet2RouteTableAssociation#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesPublicSubnet2RouteTableAssociation#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesPublicSubnet2RouteTableAssociation' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesPublicSubnet2RouteTableAssociation(obj: CfnModulePropsResourcesPublicSubnet2RouteTableAssociation | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesPublicSubnet3RouteTableAssociation
 */
export interface CfnModulePropsResourcesPublicSubnet3RouteTableAssociation {
    /**
     * @schema CfnModulePropsResourcesPublicSubnet3RouteTableAssociation#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesPublicSubnet3RouteTableAssociation#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesPublicSubnet3RouteTableAssociation' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesPublicSubnet3RouteTableAssociation(obj: CfnModulePropsResourcesPublicSubnet3RouteTableAssociation | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesPublicSubnet4RouteTableAssociation
 */
export interface CfnModulePropsResourcesPublicSubnet4RouteTableAssociation {
    /**
     * @schema CfnModulePropsResourcesPublicSubnet4RouteTableAssociation#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesPublicSubnet4RouteTableAssociation#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesPublicSubnet4RouteTableAssociation' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesPublicSubnet4RouteTableAssociation(obj: CfnModulePropsResourcesPublicSubnet4RouteTableAssociation | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesNat1Eip
 */
export interface CfnModulePropsResourcesNat1Eip {
    /**
     * @schema CfnModulePropsResourcesNat1Eip#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesNat1Eip#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesNat1Eip' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesNat1Eip(obj: CfnModulePropsResourcesNat1Eip | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesNat2Eip
 */
export interface CfnModulePropsResourcesNat2Eip {
    /**
     * @schema CfnModulePropsResourcesNat2Eip#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesNat2Eip#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesNat2Eip' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesNat2Eip(obj: CfnModulePropsResourcesNat2Eip | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesNat3Eip
 */
export interface CfnModulePropsResourcesNat3Eip {
    /**
     * @schema CfnModulePropsResourcesNat3Eip#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesNat3Eip#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesNat3Eip' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesNat3Eip(obj: CfnModulePropsResourcesNat3Eip | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesNat4Eip
 */
export interface CfnModulePropsResourcesNat4Eip {
    /**
     * @schema CfnModulePropsResourcesNat4Eip#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesNat4Eip#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesNat4Eip' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesNat4Eip(obj: CfnModulePropsResourcesNat4Eip | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesNatGateway1
 */
export interface CfnModulePropsResourcesNatGateway1 {
    /**
     * @schema CfnModulePropsResourcesNatGateway1#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesNatGateway1#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesNatGateway1' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesNatGateway1(obj: CfnModulePropsResourcesNatGateway1 | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesNatGateway2
 */
export interface CfnModulePropsResourcesNatGateway2 {
    /**
     * @schema CfnModulePropsResourcesNatGateway2#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesNatGateway2#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesNatGateway2' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesNatGateway2(obj: CfnModulePropsResourcesNatGateway2 | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesNatGateway3
 */
export interface CfnModulePropsResourcesNatGateway3 {
    /**
     * @schema CfnModulePropsResourcesNatGateway3#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesNatGateway3#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesNatGateway3' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesNatGateway3(obj: CfnModulePropsResourcesNatGateway3 | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesNatGateway4
 */
export interface CfnModulePropsResourcesNatGateway4 {
    /**
     * @schema CfnModulePropsResourcesNatGateway4#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesNatGateway4#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesNatGateway4' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesNatGateway4(obj: CfnModulePropsResourcesNatGateway4 | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesS3VpcEndpoint
 */
export interface CfnModulePropsResourcesS3VpcEndpoint {
    /**
     * @schema CfnModulePropsResourcesS3VpcEndpoint#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesS3VpcEndpoint#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesS3VpcEndpoint' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesS3VpcEndpoint(obj: CfnModulePropsResourcesS3VpcEndpoint | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesVpcFlowLogsRole
 */
export interface CfnModulePropsResourcesVpcFlowLogsRole {
    /**
     * @schema CfnModulePropsResourcesVpcFlowLogsRole#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesVpcFlowLogsRole#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesVpcFlowLogsRole' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesVpcFlowLogsRole(obj: CfnModulePropsResourcesVpcFlowLogsRole | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesVpcFlowLogsLogGroup
 */
export interface CfnModulePropsResourcesVpcFlowLogsLogGroup {
    /**
     * @schema CfnModulePropsResourcesVpcFlowLogsLogGroup#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesVpcFlowLogsLogGroup#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesVpcFlowLogsLogGroup' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesVpcFlowLogsLogGroup(obj: CfnModulePropsResourcesVpcFlowLogsLogGroup | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesVpcFlowLogsToCloudWatch
 */
export interface CfnModulePropsResourcesVpcFlowLogsToCloudWatch {
    /**
     * @schema CfnModulePropsResourcesVpcFlowLogsToCloudWatch#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesVpcFlowLogsToCloudWatch#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesVpcFlowLogsToCloudWatch' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesVpcFlowLogsToCloudWatch(obj: CfnModulePropsResourcesVpcFlowLogsToCloudWatch | undefined): Record<string, any> | undefined;
/**
 * A CloudFormation `AWSQS::VPC::VPCQS::MODULE`.
 *
 * @external
 * @cloudformationResource AWSQS::VPC::VPCQS::MODULE
 * @link http://unknown-url
 */
export declare class CfnModule extends cdk.CfnResource {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWSQS::VPC::VPCQS::MODULE";
    /**
     * Resource props.
     *
     * @external
     */
    readonly props: CfnModuleProps;
    /**
     * Create a new `AWSQS::VPC::VPCQS::MODULE`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnModuleProps);
}
