r"""
Copyright &copy; 2020 NetApp Inc.
All rights reserved.


"""

from marshmallow import EXCLUDE, fields  # type: ignore
from netapp_ontap.resource import Resource, ResourceSchema, ImpreciseDateTime, Size


__all__ = ["ErrorArguments", "ErrorArgumentsSchema"]
__pdoc__ = {
    "ErrorArgumentsSchema.resource": False,
    "ErrorArguments": False,
}


class ErrorArgumentsSchema(ResourceSchema):
    """The fields of the ErrorArguments object"""

    code = fields.Str(data_key="code")
    r""" Argument code """

    message = fields.Str(data_key="message")
    r""" Message argument """

    @property
    def resource(self):
        return ErrorArguments

    gettable_fields = [
        "code",
        "message",
    ]
    """code,message,"""

    patchable_fields = [
    ]
    """"""

    postable_fields = [
    ]
    """"""


class ErrorArguments(Resource):

    _schema = ErrorArgumentsSchema
