r"""
Copyright &copy; 2020 NetApp Inc.
All rights reserved.


"""

from marshmallow import EXCLUDE, fields  # type: ignore
from netapp_ontap.resource import Resource, ResourceSchema, ImpreciseDateTime, Size


__all__ = ["EmsEventParameter", "EmsEventParameterSchema"]
__pdoc__ = {
    "EmsEventParameterSchema.resource": False,
    "EmsEventParameter": False,
}


class EmsEventParameterSchema(ResourceSchema):
    """The fields of the EmsEventParameter object"""

    name = fields.Str(data_key="name")
    r""" Name of parameter

Example: numOps """

    value = fields.Str(data_key="value")
    r""" Value of parameter

Example: 123 """

    @property
    def resource(self):
        return EmsEventParameter

    gettable_fields = [
        "name",
        "value",
    ]
    """name,value,"""

    patchable_fields = [
    ]
    """"""

    postable_fields = [
    ]
    """"""


class EmsEventParameter(Resource):

    _schema = EmsEventParameterSchema
