"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SecretKey = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * A reCaptcha secret key.
 */
class SecretKey {
    /**
     * @returns {SecretKey} a secret key from a string in plain text.
     * @param {string} secretKey The secret key in plain text.
     */
    static fromPlainText(secretKey) {
        return {
            environment: {
                SECRET_KEY: secretKey
            },
            secretKeyType: 'PLAIN_TEXT'
        };
    }
    /**
     * @returns {SecretKey} a secret key from a parameter stored in AWS Systems Manager Parameter Store.
     * @param {ssm.IParameter} secretKeyParameter The parameter in which the secret key is stored.
     */
    static fromSsmParameter(secretKeyParameter) {
        return {
            environment: {
                SECRET_KEY_PARAMETER: secretKeyParameter.parameterName
            },
            grantRead: grantee => secretKeyParameter.grantRead(grantee),
            secretKeyType: 'SSM_PARAMETER'
        };
    }
    /**
     * @returns {SecretKey} a secret key from a secret stored in AWS Secrets Manager.
     * @param {secretsmanager.ISecret} secretKeySecret The secret in which the secret key is stored.
     * @param {string} field the name of the field with the value that you want to use as the secret key.
     * Only values in JSON format are supported. If you do not specify a JSON field, then the full
     * content of the secret is used.
     */
    static fromSecretsManager(secretKeySecret, field) {
        const environment = {
            SECRET_KEY_SECRET_ARN: secretKeySecret.secretArn
        };
        if (field) {
            environment.SECRET_KEY_FIELD = field;
        }
        return {
            environment,
            grantRead: grantee => secretKeySecret.grantRead(grantee),
            secretKeyType: 'SECRETS_MANAGER'
        };
    }
}
exports.SecretKey = SecretKey;
_a = JSII_RTTI_SYMBOL_1;
SecretKey[_a] = { fqn: "cdk-recaptcha-authorizer.SecretKey", version: "2.1.4" };
//# sourceMappingURL=data:application/json;base64,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