# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/01_utils.ipynb.

# %% auto 0
__all__ = ['yaml2dict', 'extract_api_content', 'extract_api_syntax', 'extract_api_name']

# %% ../nbs/01_utils.ipynb 4
import yaml
import re
from typing import Optional

# %% ../nbs/01_utils.ipynb 5
def yaml2dict(file_path):
    with open(file_path, "r") as file:
        data = yaml.safe_load(file)
    return data

# %% ../nbs/01_utils.ipynb 6
def extract_api_content(text: str, api_name: str) -> str:
    """Extract the content of an API request from a given text."""
    start_tag = f"{api_name}("
    end_tag = ")"
    start_idx = text.find(start_tag)
    if start_idx == -1:
        return None
    start_idx += len(start_tag)
    end_idx = text.find(end_tag, start_idx)
    if end_idx == -1:
        return None
    return text[start_idx:end_idx]

# %% ../nbs/01_utils.ipynb 7
def extract_api_syntax(text: str, api_name: str) -> str:
    """Extract the API Syntax from a given text."""
    pattern = r"\[{}\(.*?\)\]".format(api_name)
    matches = re.findall(pattern, text)
    return matches

# %% ../nbs/01_utils.ipynb 8
def extract_api_name(text: str, is_end_token: bool = True) -> Optional[str]:
    if is_end_token:
        pattern = r'\[(\w+)\(.+\]\s?'
    else:
        pattern = r'\[(\w+)\(.+\s?'
    
    match = re.search(pattern, text)

    if match:
        return match.group(1)
    else:
        return None
