import { TransformerContext } from './TransformerContext';
import { ITransformer } from './ITransformer';
import { DirectiveDefinitionNode, DirectiveNode, ObjectTypeDefinitionNode, InterfaceTypeDefinitionNode, FieldDefinitionNode, UnionTypeDefinitionNode, EnumTypeDefinitionNode, ScalarTypeDefinitionNode, InputObjectTypeDefinitionNode, InputValueDefinitionNode, EnumValueDefinitionNode, TypeDefinitionNode, DocumentNode } from 'graphql';
export declare class Transformer implements ITransformer {
    name: string;
    directive: DirectiveDefinitionNode;
    typeDefinitions: TypeDefinitionNode[];
    constructor(name: string, document: DocumentNode | string);
    before?: (acc: TransformerContext) => void;
    after?: (acc: TransformerContext) => void;
    object?: (definition: ObjectTypeDefinitionNode, directive: DirectiveNode, acc: TransformerContext) => void;
    interface?: (definition: InterfaceTypeDefinitionNode, directive: DirectiveNode, acc: TransformerContext) => void;
    field?: (parent: ObjectTypeDefinitionNode | InterfaceTypeDefinitionNode, definition: FieldDefinitionNode, directive: DirectiveNode, acc: TransformerContext) => void;
    argument?: (definition: InputValueDefinitionNode, directive: DirectiveNode, acc: TransformerContext) => void;
    union?: (definition: UnionTypeDefinitionNode, directive: DirectiveNode, acc: TransformerContext) => void;
    enum?: (definition: EnumTypeDefinitionNode, directive: DirectiveNode, acc: TransformerContext) => void;
    enumValue?: (definition: EnumValueDefinitionNode, directive: DirectiveNode, acc: TransformerContext) => void;
    scalar?: (definition: ScalarTypeDefinitionNode, directive: DirectiveNode, acc: TransformerContext) => void;
    input?: (definition: InputObjectTypeDefinitionNode, directive: DirectiveNode, acc: TransformerContext) => void;
    inputValue?: (definition: InputValueDefinitionNode, directive: DirectiveNode, acc: TransformerContext) => void;
}
//# sourceMappingURL=Transformer.d.ts.map