# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ConfigArgs', 'Config']

@pulumi.input_type
class ConfigArgs:
    def __init__(__self__, *,
                 service_name: pulumi.Input[str],
                 apis: Optional[pulumi.Input[Sequence[pulumi.Input['ApiArgs']]]] = None,
                 authentication: Optional[pulumi.Input['AuthenticationArgs']] = None,
                 backend: Optional[pulumi.Input['BackendArgs']] = None,
                 billing: Optional[pulumi.Input['BillingArgs']] = None,
                 config_version: Optional[pulumi.Input[int]] = None,
                 context: Optional[pulumi.Input['ContextArgs']] = None,
                 control: Optional[pulumi.Input['ControlArgs']] = None,
                 custom_error: Optional[pulumi.Input['CustomErrorArgs']] = None,
                 documentation: Optional[pulumi.Input['DocumentationArgs']] = None,
                 endpoints: Optional[pulumi.Input[Sequence[pulumi.Input['EndpointArgs']]]] = None,
                 enums: Optional[pulumi.Input[Sequence[pulumi.Input['EnumArgs']]]] = None,
                 http: Optional[pulumi.Input['HttpArgs']] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 logging: Optional[pulumi.Input['LoggingArgs']] = None,
                 logs: Optional[pulumi.Input[Sequence[pulumi.Input['LogDescriptorArgs']]]] = None,
                 metrics: Optional[pulumi.Input[Sequence[pulumi.Input['MetricDescriptorArgs']]]] = None,
                 monitored_resources: Optional[pulumi.Input[Sequence[pulumi.Input['MonitoredResourceDescriptorArgs']]]] = None,
                 monitoring: Optional[pulumi.Input['MonitoringArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 producer_project_id: Optional[pulumi.Input[str]] = None,
                 quota: Optional[pulumi.Input['QuotaArgs']] = None,
                 source_info: Optional[pulumi.Input['SourceInfoArgs']] = None,
                 system_parameters: Optional[pulumi.Input['SystemParametersArgs']] = None,
                 system_types: Optional[pulumi.Input[Sequence[pulumi.Input['TypeArgs']]]] = None,
                 title: Optional[pulumi.Input[str]] = None,
                 types: Optional[pulumi.Input[Sequence[pulumi.Input['TypeArgs']]]] = None,
                 usage: Optional[pulumi.Input['UsageArgs']] = None):
        """
        The set of arguments for constructing a Config resource.
        :param pulumi.Input[Sequence[pulumi.Input['ApiArgs']]] apis: A list of API interfaces exported by this service. Only the `name` field of the google.protobuf.Api needs to be provided by the configuration author, as the remaining fields will be derived from the IDL during the normalization process. It is an error to specify an API interface here which cannot be resolved against the associated IDL files.
        :param pulumi.Input['AuthenticationArgs'] authentication: Auth configuration.
        :param pulumi.Input['BackendArgs'] backend: API backend configuration.
        :param pulumi.Input['BillingArgs'] billing: Billing configuration.
        :param pulumi.Input[int] config_version: Obsolete. Do not use. This field has no semantic meaning. The service config compiler always sets this field to `3`.
        :param pulumi.Input['ContextArgs'] context: Context configuration.
        :param pulumi.Input['ControlArgs'] control: Configuration for the service control plane.
        :param pulumi.Input['CustomErrorArgs'] custom_error: Custom error configuration.
        :param pulumi.Input['DocumentationArgs'] documentation: Additional API documentation.
        :param pulumi.Input[Sequence[pulumi.Input['EndpointArgs']]] endpoints: Configuration for network endpoints. If this is empty, then an endpoint with the same name as the service is automatically generated to service all defined APIs.
        :param pulumi.Input[Sequence[pulumi.Input['EnumArgs']]] enums: A list of all enum types included in this API service. Enums referenced directly or indirectly by the `apis` are automatically included. Enums which are not referenced but shall be included should be listed here by name. Example: enums: - name: google.someapi.v1.SomeEnum
        :param pulumi.Input['HttpArgs'] http: HTTP configuration.
        :param pulumi.Input[str] id: A unique ID for a specific instance of this message, typically assigned by the client for tracking purpose. Must be no longer than 63 characters and only lower case letters, digits, '.', '_' and '-' are allowed. If empty, the server may choose to generate one instead.
        :param pulumi.Input['LoggingArgs'] logging: Logging configuration.
        :param pulumi.Input[Sequence[pulumi.Input['LogDescriptorArgs']]] logs: Defines the logs used by this service.
        :param pulumi.Input[Sequence[pulumi.Input['MetricDescriptorArgs']]] metrics: Defines the metrics used by this service.
        :param pulumi.Input[Sequence[pulumi.Input['MonitoredResourceDescriptorArgs']]] monitored_resources: Defines the monitored resources used by this service. This is required by the Service.monitoring and Service.logging configurations.
        :param pulumi.Input['MonitoringArgs'] monitoring: Monitoring configuration.
        :param pulumi.Input[str] name: The service name, which is a DNS-like logical identifier for the service, such as `calendar.googleapis.com`. The service name typically goes through DNS verification to make sure the owner of the service also owns the DNS name.
        :param pulumi.Input[str] producer_project_id: The Google project that owns this service.
        :param pulumi.Input['QuotaArgs'] quota: Quota configuration.
        :param pulumi.Input['SourceInfoArgs'] source_info: The source information for this configuration if available.
        :param pulumi.Input['SystemParametersArgs'] system_parameters: System parameter configuration.
        :param pulumi.Input[Sequence[pulumi.Input['TypeArgs']]] system_types: A list of all proto message types included in this API service. It serves similar purpose as [google.api.Service.types], except that these types are not needed by user-defined APIs. Therefore, they will not show up in the generated discovery doc. This field should only be used to define system APIs in ESF.
        :param pulumi.Input[str] title: The product title for this service.
        :param pulumi.Input[Sequence[pulumi.Input['TypeArgs']]] types: A list of all proto message types included in this API service. Types referenced directly or indirectly by the `apis` are automatically included. Messages which are not referenced but shall be included, such as types used by the `google.protobuf.Any` type, should be listed here by name. Example: types: - name: google.protobuf.Int32
        :param pulumi.Input['UsageArgs'] usage: Configuration controlling usage of this service.
        """
        pulumi.set(__self__, "service_name", service_name)
        if apis is not None:
            pulumi.set(__self__, "apis", apis)
        if authentication is not None:
            pulumi.set(__self__, "authentication", authentication)
        if backend is not None:
            pulumi.set(__self__, "backend", backend)
        if billing is not None:
            pulumi.set(__self__, "billing", billing)
        if config_version is not None:
            pulumi.set(__self__, "config_version", config_version)
        if context is not None:
            pulumi.set(__self__, "context", context)
        if control is not None:
            pulumi.set(__self__, "control", control)
        if custom_error is not None:
            pulumi.set(__self__, "custom_error", custom_error)
        if documentation is not None:
            pulumi.set(__self__, "documentation", documentation)
        if endpoints is not None:
            pulumi.set(__self__, "endpoints", endpoints)
        if enums is not None:
            pulumi.set(__self__, "enums", enums)
        if http is not None:
            pulumi.set(__self__, "http", http)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if logging is not None:
            pulumi.set(__self__, "logging", logging)
        if logs is not None:
            pulumi.set(__self__, "logs", logs)
        if metrics is not None:
            pulumi.set(__self__, "metrics", metrics)
        if monitored_resources is not None:
            pulumi.set(__self__, "monitored_resources", monitored_resources)
        if monitoring is not None:
            pulumi.set(__self__, "monitoring", monitoring)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if producer_project_id is not None:
            pulumi.set(__self__, "producer_project_id", producer_project_id)
        if quota is not None:
            pulumi.set(__self__, "quota", quota)
        if source_info is not None:
            pulumi.set(__self__, "source_info", source_info)
        if system_parameters is not None:
            pulumi.set(__self__, "system_parameters", system_parameters)
        if system_types is not None:
            pulumi.set(__self__, "system_types", system_types)
        if title is not None:
            pulumi.set(__self__, "title", title)
        if types is not None:
            pulumi.set(__self__, "types", types)
        if usage is not None:
            pulumi.set(__self__, "usage", usage)

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Input[str]:
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "service_name", value)

    @property
    @pulumi.getter
    def apis(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApiArgs']]]]:
        """
        A list of API interfaces exported by this service. Only the `name` field of the google.protobuf.Api needs to be provided by the configuration author, as the remaining fields will be derived from the IDL during the normalization process. It is an error to specify an API interface here which cannot be resolved against the associated IDL files.
        """
        return pulumi.get(self, "apis")

    @apis.setter
    def apis(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApiArgs']]]]):
        pulumi.set(self, "apis", value)

    @property
    @pulumi.getter
    def authentication(self) -> Optional[pulumi.Input['AuthenticationArgs']]:
        """
        Auth configuration.
        """
        return pulumi.get(self, "authentication")

    @authentication.setter
    def authentication(self, value: Optional[pulumi.Input['AuthenticationArgs']]):
        pulumi.set(self, "authentication", value)

    @property
    @pulumi.getter
    def backend(self) -> Optional[pulumi.Input['BackendArgs']]:
        """
        API backend configuration.
        """
        return pulumi.get(self, "backend")

    @backend.setter
    def backend(self, value: Optional[pulumi.Input['BackendArgs']]):
        pulumi.set(self, "backend", value)

    @property
    @pulumi.getter
    def billing(self) -> Optional[pulumi.Input['BillingArgs']]:
        """
        Billing configuration.
        """
        return pulumi.get(self, "billing")

    @billing.setter
    def billing(self, value: Optional[pulumi.Input['BillingArgs']]):
        pulumi.set(self, "billing", value)

    @property
    @pulumi.getter(name="configVersion")
    def config_version(self) -> Optional[pulumi.Input[int]]:
        """
        Obsolete. Do not use. This field has no semantic meaning. The service config compiler always sets this field to `3`.
        """
        return pulumi.get(self, "config_version")

    @config_version.setter
    def config_version(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "config_version", value)

    @property
    @pulumi.getter
    def context(self) -> Optional[pulumi.Input['ContextArgs']]:
        """
        Context configuration.
        """
        return pulumi.get(self, "context")

    @context.setter
    def context(self, value: Optional[pulumi.Input['ContextArgs']]):
        pulumi.set(self, "context", value)

    @property
    @pulumi.getter
    def control(self) -> Optional[pulumi.Input['ControlArgs']]:
        """
        Configuration for the service control plane.
        """
        return pulumi.get(self, "control")

    @control.setter
    def control(self, value: Optional[pulumi.Input['ControlArgs']]):
        pulumi.set(self, "control", value)

    @property
    @pulumi.getter(name="customError")
    def custom_error(self) -> Optional[pulumi.Input['CustomErrorArgs']]:
        """
        Custom error configuration.
        """
        return pulumi.get(self, "custom_error")

    @custom_error.setter
    def custom_error(self, value: Optional[pulumi.Input['CustomErrorArgs']]):
        pulumi.set(self, "custom_error", value)

    @property
    @pulumi.getter
    def documentation(self) -> Optional[pulumi.Input['DocumentationArgs']]:
        """
        Additional API documentation.
        """
        return pulumi.get(self, "documentation")

    @documentation.setter
    def documentation(self, value: Optional[pulumi.Input['DocumentationArgs']]):
        pulumi.set(self, "documentation", value)

    @property
    @pulumi.getter
    def endpoints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EndpointArgs']]]]:
        """
        Configuration for network endpoints. If this is empty, then an endpoint with the same name as the service is automatically generated to service all defined APIs.
        """
        return pulumi.get(self, "endpoints")

    @endpoints.setter
    def endpoints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EndpointArgs']]]]):
        pulumi.set(self, "endpoints", value)

    @property
    @pulumi.getter
    def enums(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EnumArgs']]]]:
        """
        A list of all enum types included in this API service. Enums referenced directly or indirectly by the `apis` are automatically included. Enums which are not referenced but shall be included should be listed here by name. Example: enums: - name: google.someapi.v1.SomeEnum
        """
        return pulumi.get(self, "enums")

    @enums.setter
    def enums(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EnumArgs']]]]):
        pulumi.set(self, "enums", value)

    @property
    @pulumi.getter
    def http(self) -> Optional[pulumi.Input['HttpArgs']]:
        """
        HTTP configuration.
        """
        return pulumi.get(self, "http")

    @http.setter
    def http(self, value: Optional[pulumi.Input['HttpArgs']]):
        pulumi.set(self, "http", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        A unique ID for a specific instance of this message, typically assigned by the client for tracking purpose. Must be no longer than 63 characters and only lower case letters, digits, '.', '_' and '-' are allowed. If empty, the server may choose to generate one instead.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def logging(self) -> Optional[pulumi.Input['LoggingArgs']]:
        """
        Logging configuration.
        """
        return pulumi.get(self, "logging")

    @logging.setter
    def logging(self, value: Optional[pulumi.Input['LoggingArgs']]):
        pulumi.set(self, "logging", value)

    @property
    @pulumi.getter
    def logs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LogDescriptorArgs']]]]:
        """
        Defines the logs used by this service.
        """
        return pulumi.get(self, "logs")

    @logs.setter
    def logs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LogDescriptorArgs']]]]):
        pulumi.set(self, "logs", value)

    @property
    @pulumi.getter
    def metrics(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MetricDescriptorArgs']]]]:
        """
        Defines the metrics used by this service.
        """
        return pulumi.get(self, "metrics")

    @metrics.setter
    def metrics(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MetricDescriptorArgs']]]]):
        pulumi.set(self, "metrics", value)

    @property
    @pulumi.getter(name="monitoredResources")
    def monitored_resources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MonitoredResourceDescriptorArgs']]]]:
        """
        Defines the monitored resources used by this service. This is required by the Service.monitoring and Service.logging configurations.
        """
        return pulumi.get(self, "monitored_resources")

    @monitored_resources.setter
    def monitored_resources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MonitoredResourceDescriptorArgs']]]]):
        pulumi.set(self, "monitored_resources", value)

    @property
    @pulumi.getter
    def monitoring(self) -> Optional[pulumi.Input['MonitoringArgs']]:
        """
        Monitoring configuration.
        """
        return pulumi.get(self, "monitoring")

    @monitoring.setter
    def monitoring(self, value: Optional[pulumi.Input['MonitoringArgs']]):
        pulumi.set(self, "monitoring", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The service name, which is a DNS-like logical identifier for the service, such as `calendar.googleapis.com`. The service name typically goes through DNS verification to make sure the owner of the service also owns the DNS name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="producerProjectId")
    def producer_project_id(self) -> Optional[pulumi.Input[str]]:
        """
        The Google project that owns this service.
        """
        return pulumi.get(self, "producer_project_id")

    @producer_project_id.setter
    def producer_project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "producer_project_id", value)

    @property
    @pulumi.getter
    def quota(self) -> Optional[pulumi.Input['QuotaArgs']]:
        """
        Quota configuration.
        """
        return pulumi.get(self, "quota")

    @quota.setter
    def quota(self, value: Optional[pulumi.Input['QuotaArgs']]):
        pulumi.set(self, "quota", value)

    @property
    @pulumi.getter(name="sourceInfo")
    def source_info(self) -> Optional[pulumi.Input['SourceInfoArgs']]:
        """
        The source information for this configuration if available.
        """
        return pulumi.get(self, "source_info")

    @source_info.setter
    def source_info(self, value: Optional[pulumi.Input['SourceInfoArgs']]):
        pulumi.set(self, "source_info", value)

    @property
    @pulumi.getter(name="systemParameters")
    def system_parameters(self) -> Optional[pulumi.Input['SystemParametersArgs']]:
        """
        System parameter configuration.
        """
        return pulumi.get(self, "system_parameters")

    @system_parameters.setter
    def system_parameters(self, value: Optional[pulumi.Input['SystemParametersArgs']]):
        pulumi.set(self, "system_parameters", value)

    @property
    @pulumi.getter(name="systemTypes")
    def system_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TypeArgs']]]]:
        """
        A list of all proto message types included in this API service. It serves similar purpose as [google.api.Service.types], except that these types are not needed by user-defined APIs. Therefore, they will not show up in the generated discovery doc. This field should only be used to define system APIs in ESF.
        """
        return pulumi.get(self, "system_types")

    @system_types.setter
    def system_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TypeArgs']]]]):
        pulumi.set(self, "system_types", value)

    @property
    @pulumi.getter
    def title(self) -> Optional[pulumi.Input[str]]:
        """
        The product title for this service.
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "title", value)

    @property
    @pulumi.getter
    def types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TypeArgs']]]]:
        """
        A list of all proto message types included in this API service. Types referenced directly or indirectly by the `apis` are automatically included. Messages which are not referenced but shall be included, such as types used by the `google.protobuf.Any` type, should be listed here by name. Example: types: - name: google.protobuf.Int32
        """
        return pulumi.get(self, "types")

    @types.setter
    def types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TypeArgs']]]]):
        pulumi.set(self, "types", value)

    @property
    @pulumi.getter
    def usage(self) -> Optional[pulumi.Input['UsageArgs']]:
        """
        Configuration controlling usage of this service.
        """
        return pulumi.get(self, "usage")

    @usage.setter
    def usage(self, value: Optional[pulumi.Input['UsageArgs']]):
        pulumi.set(self, "usage", value)


class Config(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 apis: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ApiArgs']]]]] = None,
                 authentication: Optional[pulumi.Input[pulumi.InputType['AuthenticationArgs']]] = None,
                 backend: Optional[pulumi.Input[pulumi.InputType['BackendArgs']]] = None,
                 billing: Optional[pulumi.Input[pulumi.InputType['BillingArgs']]] = None,
                 config_version: Optional[pulumi.Input[int]] = None,
                 context: Optional[pulumi.Input[pulumi.InputType['ContextArgs']]] = None,
                 control: Optional[pulumi.Input[pulumi.InputType['ControlArgs']]] = None,
                 custom_error: Optional[pulumi.Input[pulumi.InputType['CustomErrorArgs']]] = None,
                 documentation: Optional[pulumi.Input[pulumi.InputType['DocumentationArgs']]] = None,
                 endpoints: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['EndpointArgs']]]]] = None,
                 enums: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['EnumArgs']]]]] = None,
                 http: Optional[pulumi.Input[pulumi.InputType['HttpArgs']]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 logging: Optional[pulumi.Input[pulumi.InputType['LoggingArgs']]] = None,
                 logs: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['LogDescriptorArgs']]]]] = None,
                 metrics: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MetricDescriptorArgs']]]]] = None,
                 monitored_resources: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MonitoredResourceDescriptorArgs']]]]] = None,
                 monitoring: Optional[pulumi.Input[pulumi.InputType['MonitoringArgs']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 producer_project_id: Optional[pulumi.Input[str]] = None,
                 quota: Optional[pulumi.Input[pulumi.InputType['QuotaArgs']]] = None,
                 service_name: Optional[pulumi.Input[str]] = None,
                 source_info: Optional[pulumi.Input[pulumi.InputType['SourceInfoArgs']]] = None,
                 system_parameters: Optional[pulumi.Input[pulumi.InputType['SystemParametersArgs']]] = None,
                 system_types: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TypeArgs']]]]] = None,
                 title: Optional[pulumi.Input[str]] = None,
                 types: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TypeArgs']]]]] = None,
                 usage: Optional[pulumi.Input[pulumi.InputType['UsageArgs']]] = None,
                 __props__=None):
        """
        Creates a new service configuration (version) for a managed service. This method only stores the service configuration. To roll out the service configuration to backend systems please call CreateServiceRollout. Only the 100 most recent service configurations and ones referenced by existing rollouts are kept for each service. The rest will be deleted eventually.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ApiArgs']]]] apis: A list of API interfaces exported by this service. Only the `name` field of the google.protobuf.Api needs to be provided by the configuration author, as the remaining fields will be derived from the IDL during the normalization process. It is an error to specify an API interface here which cannot be resolved against the associated IDL files.
        :param pulumi.Input[pulumi.InputType['AuthenticationArgs']] authentication: Auth configuration.
        :param pulumi.Input[pulumi.InputType['BackendArgs']] backend: API backend configuration.
        :param pulumi.Input[pulumi.InputType['BillingArgs']] billing: Billing configuration.
        :param pulumi.Input[int] config_version: Obsolete. Do not use. This field has no semantic meaning. The service config compiler always sets this field to `3`.
        :param pulumi.Input[pulumi.InputType['ContextArgs']] context: Context configuration.
        :param pulumi.Input[pulumi.InputType['ControlArgs']] control: Configuration for the service control plane.
        :param pulumi.Input[pulumi.InputType['CustomErrorArgs']] custom_error: Custom error configuration.
        :param pulumi.Input[pulumi.InputType['DocumentationArgs']] documentation: Additional API documentation.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['EndpointArgs']]]] endpoints: Configuration for network endpoints. If this is empty, then an endpoint with the same name as the service is automatically generated to service all defined APIs.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['EnumArgs']]]] enums: A list of all enum types included in this API service. Enums referenced directly or indirectly by the `apis` are automatically included. Enums which are not referenced but shall be included should be listed here by name. Example: enums: - name: google.someapi.v1.SomeEnum
        :param pulumi.Input[pulumi.InputType['HttpArgs']] http: HTTP configuration.
        :param pulumi.Input[str] id: A unique ID for a specific instance of this message, typically assigned by the client for tracking purpose. Must be no longer than 63 characters and only lower case letters, digits, '.', '_' and '-' are allowed. If empty, the server may choose to generate one instead.
        :param pulumi.Input[pulumi.InputType['LoggingArgs']] logging: Logging configuration.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['LogDescriptorArgs']]]] logs: Defines the logs used by this service.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MetricDescriptorArgs']]]] metrics: Defines the metrics used by this service.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MonitoredResourceDescriptorArgs']]]] monitored_resources: Defines the monitored resources used by this service. This is required by the Service.monitoring and Service.logging configurations.
        :param pulumi.Input[pulumi.InputType['MonitoringArgs']] monitoring: Monitoring configuration.
        :param pulumi.Input[str] name: The service name, which is a DNS-like logical identifier for the service, such as `calendar.googleapis.com`. The service name typically goes through DNS verification to make sure the owner of the service also owns the DNS name.
        :param pulumi.Input[str] producer_project_id: The Google project that owns this service.
        :param pulumi.Input[pulumi.InputType['QuotaArgs']] quota: Quota configuration.
        :param pulumi.Input[pulumi.InputType['SourceInfoArgs']] source_info: The source information for this configuration if available.
        :param pulumi.Input[pulumi.InputType['SystemParametersArgs']] system_parameters: System parameter configuration.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TypeArgs']]]] system_types: A list of all proto message types included in this API service. It serves similar purpose as [google.api.Service.types], except that these types are not needed by user-defined APIs. Therefore, they will not show up in the generated discovery doc. This field should only be used to define system APIs in ESF.
        :param pulumi.Input[str] title: The product title for this service.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TypeArgs']]]] types: A list of all proto message types included in this API service. Types referenced directly or indirectly by the `apis` are automatically included. Messages which are not referenced but shall be included, such as types used by the `google.protobuf.Any` type, should be listed here by name. Example: types: - name: google.protobuf.Int32
        :param pulumi.Input[pulumi.InputType['UsageArgs']] usage: Configuration controlling usage of this service.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ConfigArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates a new service configuration (version) for a managed service. This method only stores the service configuration. To roll out the service configuration to backend systems please call CreateServiceRollout. Only the 100 most recent service configurations and ones referenced by existing rollouts are kept for each service. The rest will be deleted eventually.

        :param str resource_name: The name of the resource.
        :param ConfigArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ConfigArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 apis: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ApiArgs']]]]] = None,
                 authentication: Optional[pulumi.Input[pulumi.InputType['AuthenticationArgs']]] = None,
                 backend: Optional[pulumi.Input[pulumi.InputType['BackendArgs']]] = None,
                 billing: Optional[pulumi.Input[pulumi.InputType['BillingArgs']]] = None,
                 config_version: Optional[pulumi.Input[int]] = None,
                 context: Optional[pulumi.Input[pulumi.InputType['ContextArgs']]] = None,
                 control: Optional[pulumi.Input[pulumi.InputType['ControlArgs']]] = None,
                 custom_error: Optional[pulumi.Input[pulumi.InputType['CustomErrorArgs']]] = None,
                 documentation: Optional[pulumi.Input[pulumi.InputType['DocumentationArgs']]] = None,
                 endpoints: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['EndpointArgs']]]]] = None,
                 enums: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['EnumArgs']]]]] = None,
                 http: Optional[pulumi.Input[pulumi.InputType['HttpArgs']]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 logging: Optional[pulumi.Input[pulumi.InputType['LoggingArgs']]] = None,
                 logs: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['LogDescriptorArgs']]]]] = None,
                 metrics: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MetricDescriptorArgs']]]]] = None,
                 monitored_resources: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MonitoredResourceDescriptorArgs']]]]] = None,
                 monitoring: Optional[pulumi.Input[pulumi.InputType['MonitoringArgs']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 producer_project_id: Optional[pulumi.Input[str]] = None,
                 quota: Optional[pulumi.Input[pulumi.InputType['QuotaArgs']]] = None,
                 service_name: Optional[pulumi.Input[str]] = None,
                 source_info: Optional[pulumi.Input[pulumi.InputType['SourceInfoArgs']]] = None,
                 system_parameters: Optional[pulumi.Input[pulumi.InputType['SystemParametersArgs']]] = None,
                 system_types: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TypeArgs']]]]] = None,
                 title: Optional[pulumi.Input[str]] = None,
                 types: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TypeArgs']]]]] = None,
                 usage: Optional[pulumi.Input[pulumi.InputType['UsageArgs']]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ConfigArgs.__new__(ConfigArgs)

            __props__.__dict__["apis"] = apis
            __props__.__dict__["authentication"] = authentication
            __props__.__dict__["backend"] = backend
            __props__.__dict__["billing"] = billing
            __props__.__dict__["config_version"] = config_version
            __props__.__dict__["context"] = context
            __props__.__dict__["control"] = control
            __props__.__dict__["custom_error"] = custom_error
            __props__.__dict__["documentation"] = documentation
            __props__.__dict__["endpoints"] = endpoints
            __props__.__dict__["enums"] = enums
            __props__.__dict__["http"] = http
            __props__.__dict__["id"] = id
            __props__.__dict__["logging"] = logging
            __props__.__dict__["logs"] = logs
            __props__.__dict__["metrics"] = metrics
            __props__.__dict__["monitored_resources"] = monitored_resources
            __props__.__dict__["monitoring"] = monitoring
            __props__.__dict__["name"] = name
            __props__.__dict__["producer_project_id"] = producer_project_id
            __props__.__dict__["quota"] = quota
            if service_name is None and not opts.urn:
                raise TypeError("Missing required property 'service_name'")
            __props__.__dict__["service_name"] = service_name
            __props__.__dict__["source_info"] = source_info
            __props__.__dict__["system_parameters"] = system_parameters
            __props__.__dict__["system_types"] = system_types
            __props__.__dict__["title"] = title
            __props__.__dict__["types"] = types
            __props__.__dict__["usage"] = usage
        super(Config, __self__).__init__(
            'google-native:servicemanagement/v1:Config',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Config':
        """
        Get an existing Config resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = ConfigArgs.__new__(ConfigArgs)

        __props__.__dict__["apis"] = None
        __props__.__dict__["authentication"] = None
        __props__.__dict__["backend"] = None
        __props__.__dict__["billing"] = None
        __props__.__dict__["config_version"] = None
        __props__.__dict__["context"] = None
        __props__.__dict__["control"] = None
        __props__.__dict__["custom_error"] = None
        __props__.__dict__["documentation"] = None
        __props__.__dict__["endpoints"] = None
        __props__.__dict__["enums"] = None
        __props__.__dict__["http"] = None
        __props__.__dict__["logging"] = None
        __props__.__dict__["logs"] = None
        __props__.__dict__["metrics"] = None
        __props__.__dict__["monitored_resources"] = None
        __props__.__dict__["monitoring"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["producer_project_id"] = None
        __props__.__dict__["quota"] = None
        __props__.__dict__["source_info"] = None
        __props__.__dict__["system_parameters"] = None
        __props__.__dict__["system_types"] = None
        __props__.__dict__["title"] = None
        __props__.__dict__["types"] = None
        __props__.__dict__["usage"] = None
        return Config(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def apis(self) -> pulumi.Output[Sequence['outputs.ApiResponse']]:
        """
        A list of API interfaces exported by this service. Only the `name` field of the google.protobuf.Api needs to be provided by the configuration author, as the remaining fields will be derived from the IDL during the normalization process. It is an error to specify an API interface here which cannot be resolved against the associated IDL files.
        """
        return pulumi.get(self, "apis")

    @property
    @pulumi.getter
    def authentication(self) -> pulumi.Output['outputs.AuthenticationResponse']:
        """
        Auth configuration.
        """
        return pulumi.get(self, "authentication")

    @property
    @pulumi.getter
    def backend(self) -> pulumi.Output['outputs.BackendResponse']:
        """
        API backend configuration.
        """
        return pulumi.get(self, "backend")

    @property
    @pulumi.getter
    def billing(self) -> pulumi.Output['outputs.BillingResponse']:
        """
        Billing configuration.
        """
        return pulumi.get(self, "billing")

    @property
    @pulumi.getter(name="configVersion")
    def config_version(self) -> pulumi.Output[int]:
        """
        Obsolete. Do not use. This field has no semantic meaning. The service config compiler always sets this field to `3`.
        """
        return pulumi.get(self, "config_version")

    @property
    @pulumi.getter
    def context(self) -> pulumi.Output['outputs.ContextResponse']:
        """
        Context configuration.
        """
        return pulumi.get(self, "context")

    @property
    @pulumi.getter
    def control(self) -> pulumi.Output['outputs.ControlResponse']:
        """
        Configuration for the service control plane.
        """
        return pulumi.get(self, "control")

    @property
    @pulumi.getter(name="customError")
    def custom_error(self) -> pulumi.Output['outputs.CustomErrorResponse']:
        """
        Custom error configuration.
        """
        return pulumi.get(self, "custom_error")

    @property
    @pulumi.getter
    def documentation(self) -> pulumi.Output['outputs.DocumentationResponse']:
        """
        Additional API documentation.
        """
        return pulumi.get(self, "documentation")

    @property
    @pulumi.getter
    def endpoints(self) -> pulumi.Output[Sequence['outputs.EndpointResponse']]:
        """
        Configuration for network endpoints. If this is empty, then an endpoint with the same name as the service is automatically generated to service all defined APIs.
        """
        return pulumi.get(self, "endpoints")

    @property
    @pulumi.getter
    def enums(self) -> pulumi.Output[Sequence['outputs.EnumResponse']]:
        """
        A list of all enum types included in this API service. Enums referenced directly or indirectly by the `apis` are automatically included. Enums which are not referenced but shall be included should be listed here by name. Example: enums: - name: google.someapi.v1.SomeEnum
        """
        return pulumi.get(self, "enums")

    @property
    @pulumi.getter
    def http(self) -> pulumi.Output['outputs.HttpResponse']:
        """
        HTTP configuration.
        """
        return pulumi.get(self, "http")

    @property
    @pulumi.getter
    def logging(self) -> pulumi.Output['outputs.LoggingResponse']:
        """
        Logging configuration.
        """
        return pulumi.get(self, "logging")

    @property
    @pulumi.getter
    def logs(self) -> pulumi.Output[Sequence['outputs.LogDescriptorResponse']]:
        """
        Defines the logs used by this service.
        """
        return pulumi.get(self, "logs")

    @property
    @pulumi.getter
    def metrics(self) -> pulumi.Output[Sequence['outputs.MetricDescriptorResponse']]:
        """
        Defines the metrics used by this service.
        """
        return pulumi.get(self, "metrics")

    @property
    @pulumi.getter(name="monitoredResources")
    def monitored_resources(self) -> pulumi.Output[Sequence['outputs.MonitoredResourceDescriptorResponse']]:
        """
        Defines the monitored resources used by this service. This is required by the Service.monitoring and Service.logging configurations.
        """
        return pulumi.get(self, "monitored_resources")

    @property
    @pulumi.getter
    def monitoring(self) -> pulumi.Output['outputs.MonitoringResponse']:
        """
        Monitoring configuration.
        """
        return pulumi.get(self, "monitoring")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The service name, which is a DNS-like logical identifier for the service, such as `calendar.googleapis.com`. The service name typically goes through DNS verification to make sure the owner of the service also owns the DNS name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="producerProjectId")
    def producer_project_id(self) -> pulumi.Output[str]:
        """
        The Google project that owns this service.
        """
        return pulumi.get(self, "producer_project_id")

    @property
    @pulumi.getter
    def quota(self) -> pulumi.Output['outputs.QuotaResponse']:
        """
        Quota configuration.
        """
        return pulumi.get(self, "quota")

    @property
    @pulumi.getter(name="sourceInfo")
    def source_info(self) -> pulumi.Output['outputs.SourceInfoResponse']:
        """
        The source information for this configuration if available.
        """
        return pulumi.get(self, "source_info")

    @property
    @pulumi.getter(name="systemParameters")
    def system_parameters(self) -> pulumi.Output['outputs.SystemParametersResponse']:
        """
        System parameter configuration.
        """
        return pulumi.get(self, "system_parameters")

    @property
    @pulumi.getter(name="systemTypes")
    def system_types(self) -> pulumi.Output[Sequence['outputs.TypeResponse']]:
        """
        A list of all proto message types included in this API service. It serves similar purpose as [google.api.Service.types], except that these types are not needed by user-defined APIs. Therefore, they will not show up in the generated discovery doc. This field should only be used to define system APIs in ESF.
        """
        return pulumi.get(self, "system_types")

    @property
    @pulumi.getter
    def title(self) -> pulumi.Output[str]:
        """
        The product title for this service.
        """
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def types(self) -> pulumi.Output[Sequence['outputs.TypeResponse']]:
        """
        A list of all proto message types included in this API service. Types referenced directly or indirectly by the `apis` are automatically included. Messages which are not referenced but shall be included, such as types used by the `google.protobuf.Any` type, should be listed here by name. Example: types: - name: google.protobuf.Int32
        """
        return pulumi.get(self, "types")

    @property
    @pulumi.getter
    def usage(self) -> pulumi.Output['outputs.UsageResponse']:
        """
        Configuration controlling usage of this service.
        """
        return pulumi.get(self, "usage")

