# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'AttributeResponse',
    'AuditConfigResponse',
    'AuditLogConfigResponse',
    'BindingResponse',
    'ExprResponse',
    'FieldResponse',
    'GoogleCloudHealthcareV1ConsentPolicyResponse',
    'GoogleCloudHealthcareV1FhirBigQueryDestinationResponse',
    'Hl7SchemaConfigResponse',
    'Hl7TypesConfigResponse',
    'Hl7V2NotificationConfigResponse',
    'ImageResponse',
    'NotificationConfigResponse',
    'ParsedDataResponse',
    'ParserConfigResponse',
    'PatientIdResponse',
    'SchemaConfigResponse',
    'SchemaPackageResponse',
    'SchematizedDataResponse',
    'SegmentResponse',
    'SignatureResponse',
    'StreamConfigResponse',
    'TypeResponse',
    'VersionSourceResponse',
]

@pulumi.output_type
class AttributeResponse(dict):
    """
    An attribute value for a Consent or User data mapping. Each Attribute must have a corresponding AttributeDefinition in the consent store that defines the default and allowed values.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "attributeDefinitionId":
            suggest = "attribute_definition_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AttributeResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AttributeResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AttributeResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 attribute_definition_id: str,
                 values: Sequence[str]):
        """
        An attribute value for a Consent or User data mapping. Each Attribute must have a corresponding AttributeDefinition in the consent store that defines the default and allowed values.
        :param str attribute_definition_id: Indicates the name of an attribute defined in the consent store.
        :param Sequence[str] values: Required. The value of the attribute. Must be an acceptable value as defined in the consent store. For example, if the consent store defines "data type" with acceptable values "questionnaire" and "step-count", when the attribute name is data type, this field must contain one of those values.
        """
        pulumi.set(__self__, "attribute_definition_id", attribute_definition_id)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter(name="attributeDefinitionId")
    def attribute_definition_id(self) -> str:
        """
        Indicates the name of an attribute defined in the consent store.
        """
        return pulumi.get(self, "attribute_definition_id")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        Required. The value of the attribute. Must be an acceptable value as defined in the consent store. For example, if the consent store defines "data type" with acceptable values "questionnaire" and "step-count", when the attribute name is data type, this field must contain one of those values.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class AuditConfigResponse(dict):
    """
    Specifies the audit configuration for a service. The configuration determines which permission types are logged, and what identities, if any, are exempted from logging. An AuditConfig must have one or more AuditLogConfigs. If there are AuditConfigs for both `allServices` and a specific service, the union of the two AuditConfigs is used for that service: the log_types specified in each AuditConfig are enabled, and the exempted_members in each AuditLogConfig are exempted. Example Policy with multiple AuditConfigs: { "audit_configs": [ { "service": "allServices", "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" }, { "log_type": "ADMIN_READ" } ] }, { "service": "sampleservice.googleapis.com", "audit_log_configs": [ { "log_type": "DATA_READ" }, { "log_type": "DATA_WRITE", "exempted_members": [ "user:aliya@example.com" ] } ] } ] } For sampleservice, this policy enables DATA_READ, DATA_WRITE and ADMIN_READ logging. It also exempts jose@example.com from DATA_READ logging, and aliya@example.com from DATA_WRITE logging.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "auditLogConfigs":
            suggest = "audit_log_configs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AuditConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AuditConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AuditConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 audit_log_configs: Sequence['outputs.AuditLogConfigResponse'],
                 service: str):
        """
        Specifies the audit configuration for a service. The configuration determines which permission types are logged, and what identities, if any, are exempted from logging. An AuditConfig must have one or more AuditLogConfigs. If there are AuditConfigs for both `allServices` and a specific service, the union of the two AuditConfigs is used for that service: the log_types specified in each AuditConfig are enabled, and the exempted_members in each AuditLogConfig are exempted. Example Policy with multiple AuditConfigs: { "audit_configs": [ { "service": "allServices", "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" }, { "log_type": "ADMIN_READ" } ] }, { "service": "sampleservice.googleapis.com", "audit_log_configs": [ { "log_type": "DATA_READ" }, { "log_type": "DATA_WRITE", "exempted_members": [ "user:aliya@example.com" ] } ] } ] } For sampleservice, this policy enables DATA_READ, DATA_WRITE and ADMIN_READ logging. It also exempts jose@example.com from DATA_READ logging, and aliya@example.com from DATA_WRITE logging.
        :param Sequence['AuditLogConfigResponse'] audit_log_configs: The configuration for logging of each type of permission.
        :param str service: Specifies a service that will be enabled for audit logging. For example, `storage.googleapis.com`, `cloudsql.googleapis.com`. `allServices` is a special value that covers all services.
        """
        pulumi.set(__self__, "audit_log_configs", audit_log_configs)
        pulumi.set(__self__, "service", service)

    @property
    @pulumi.getter(name="auditLogConfigs")
    def audit_log_configs(self) -> Sequence['outputs.AuditLogConfigResponse']:
        """
        The configuration for logging of each type of permission.
        """
        return pulumi.get(self, "audit_log_configs")

    @property
    @pulumi.getter
    def service(self) -> str:
        """
        Specifies a service that will be enabled for audit logging. For example, `storage.googleapis.com`, `cloudsql.googleapis.com`. `allServices` is a special value that covers all services.
        """
        return pulumi.get(self, "service")


@pulumi.output_type
class AuditLogConfigResponse(dict):
    """
    Provides the configuration for logging a type of permissions. Example: { "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" } ] } This enables 'DATA_READ' and 'DATA_WRITE' logging, while exempting jose@example.com from DATA_READ logging.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "exemptedMembers":
            suggest = "exempted_members"
        elif key == "logType":
            suggest = "log_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AuditLogConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AuditLogConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AuditLogConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 exempted_members: Sequence[str],
                 log_type: str):
        """
        Provides the configuration for logging a type of permissions. Example: { "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" } ] } This enables 'DATA_READ' and 'DATA_WRITE' logging, while exempting jose@example.com from DATA_READ logging.
        :param Sequence[str] exempted_members: Specifies the identities that do not cause logging for this type of permission. Follows the same format of Binding.members.
        :param str log_type: The log type that this config enables.
        """
        pulumi.set(__self__, "exempted_members", exempted_members)
        pulumi.set(__self__, "log_type", log_type)

    @property
    @pulumi.getter(name="exemptedMembers")
    def exempted_members(self) -> Sequence[str]:
        """
        Specifies the identities that do not cause logging for this type of permission. Follows the same format of Binding.members.
        """
        return pulumi.get(self, "exempted_members")

    @property
    @pulumi.getter(name="logType")
    def log_type(self) -> str:
        """
        The log type that this config enables.
        """
        return pulumi.get(self, "log_type")


@pulumi.output_type
class BindingResponse(dict):
    """
    Associates `members` with a `role`.
    """
    def __init__(__self__, *,
                 condition: 'outputs.ExprResponse',
                 members: Sequence[str],
                 role: str):
        """
        Associates `members` with a `role`.
        :param 'ExprResponse' condition: The condition that is associated with this binding. If the condition evaluates to `true`, then this binding applies to the current request. If the condition evaluates to `false`, then this binding does not apply to the current request. However, a different role binding might grant the same role to one or more of the members in this binding. To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
        :param Sequence[str] members: Specifies the identities requesting access for a Cloud Platform resource. `members` can have the following values: * `allUsers`: A special identifier that represents anyone who is on the internet; with or without a Google account. * `allAuthenticatedUsers`: A special identifier that represents anyone who is authenticated with a Google account or a service account. * `user:{emailid}`: An email address that represents a specific Google account. For example, `alice@example.com` . * `serviceAccount:{emailid}`: An email address that represents a service account. For example, `my-other-app@appspot.gserviceaccount.com`. * `group:{emailid}`: An email address that represents a Google group. For example, `admins@example.com`. * `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a user that has been recently deleted. For example, `alice@example.com?uid=123456789012345678901`. If the user is recovered, this value reverts to `user:{emailid}` and the recovered user retains the role in the binding. * `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a service account that has been recently deleted. For example, `my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the service account is undeleted, this value reverts to `serviceAccount:{emailid}` and the undeleted service account retains the role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a Google group that has been recently deleted. For example, `admins@example.com?uid=123456789012345678901`. If the group is recovered, this value reverts to `group:{emailid}` and the recovered group retains the role in the binding. * `domain:{domain}`: The G Suite domain (primary) that represents all the users of that domain. For example, `google.com` or `example.com`. 
        :param str role: Role that is assigned to `members`. For example, `roles/viewer`, `roles/editor`, or `roles/owner`.
        """
        pulumi.set(__self__, "condition", condition)
        pulumi.set(__self__, "members", members)
        pulumi.set(__self__, "role", role)

    @property
    @pulumi.getter
    def condition(self) -> 'outputs.ExprResponse':
        """
        The condition that is associated with this binding. If the condition evaluates to `true`, then this binding applies to the current request. If the condition evaluates to `false`, then this binding does not apply to the current request. However, a different role binding might grant the same role to one or more of the members in this binding. To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
        """
        return pulumi.get(self, "condition")

    @property
    @pulumi.getter
    def members(self) -> Sequence[str]:
        """
        Specifies the identities requesting access for a Cloud Platform resource. `members` can have the following values: * `allUsers`: A special identifier that represents anyone who is on the internet; with or without a Google account. * `allAuthenticatedUsers`: A special identifier that represents anyone who is authenticated with a Google account or a service account. * `user:{emailid}`: An email address that represents a specific Google account. For example, `alice@example.com` . * `serviceAccount:{emailid}`: An email address that represents a service account. For example, `my-other-app@appspot.gserviceaccount.com`. * `group:{emailid}`: An email address that represents a Google group. For example, `admins@example.com`. * `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a user that has been recently deleted. For example, `alice@example.com?uid=123456789012345678901`. If the user is recovered, this value reverts to `user:{emailid}` and the recovered user retains the role in the binding. * `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a service account that has been recently deleted. For example, `my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the service account is undeleted, this value reverts to `serviceAccount:{emailid}` and the undeleted service account retains the role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a Google group that has been recently deleted. For example, `admins@example.com?uid=123456789012345678901`. If the group is recovered, this value reverts to `group:{emailid}` and the recovered group retains the role in the binding. * `domain:{domain}`: The G Suite domain (primary) that represents all the users of that domain. For example, `google.com` or `example.com`. 
        """
        return pulumi.get(self, "members")

    @property
    @pulumi.getter
    def role(self) -> str:
        """
        Role that is assigned to `members`. For example, `roles/viewer`, `roles/editor`, or `roles/owner`.
        """
        return pulumi.get(self, "role")


@pulumi.output_type
class ExprResponse(dict):
    """
    Represents a textual expression in the Common Expression Language (CEL) syntax. CEL is a C-like expression language. The syntax and semantics of CEL are documented at https://github.com/google/cel-spec. Example (Comparison): title: "Summary size limit" description: "Determines if a summary is less than 100 chars" expression: "document.summary.size() < 100" Example (Equality): title: "Requestor is owner" description: "Determines if requestor is the document owner" expression: "document.owner == request.auth.claims.email" Example (Logic): title: "Public documents" description: "Determine whether the document should be publicly visible" expression: "document.type != 'private' && document.type != 'internal'" Example (Data Manipulation): title: "Notification string" description: "Create a notification string with a timestamp." expression: "'New message received at ' + string(document.create_time)" The exact variables and functions that may be referenced within an expression are determined by the service that evaluates it. See the service documentation for additional information.
    """
    def __init__(__self__, *,
                 description: str,
                 expression: str,
                 location: str,
                 title: str):
        """
        Represents a textual expression in the Common Expression Language (CEL) syntax. CEL is a C-like expression language. The syntax and semantics of CEL are documented at https://github.com/google/cel-spec. Example (Comparison): title: "Summary size limit" description: "Determines if a summary is less than 100 chars" expression: "document.summary.size() < 100" Example (Equality): title: "Requestor is owner" description: "Determines if requestor is the document owner" expression: "document.owner == request.auth.claims.email" Example (Logic): title: "Public documents" description: "Determine whether the document should be publicly visible" expression: "document.type != 'private' && document.type != 'internal'" Example (Data Manipulation): title: "Notification string" description: "Create a notification string with a timestamp." expression: "'New message received at ' + string(document.create_time)" The exact variables and functions that may be referenced within an expression are determined by the service that evaluates it. See the service documentation for additional information.
        :param str description: Optional. Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        :param str expression: Textual representation of an expression in Common Expression Language syntax.
        :param str location: Optional. String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
        :param str title: Optional. Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Optional. Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def expression(self) -> str:
        """
        Textual representation of an expression in Common Expression Language syntax.
        """
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def location(self) -> str:
        """
        Optional. String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def title(self) -> str:
        """
        Optional. Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
        """
        return pulumi.get(self, "title")


@pulumi.output_type
class FieldResponse(dict):
    """
    A (sub) field of a type.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxOccurs":
            suggest = "max_occurs"
        elif key == "minOccurs":
            suggest = "min_occurs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FieldResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FieldResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FieldResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_occurs: int,
                 min_occurs: int,
                 name: str,
                 table: str,
                 type: str):
        """
        A (sub) field of a type.
        :param int max_occurs: The maximum number of times this field can be repeated. 0 or -1 means unbounded.
        :param int min_occurs: The minimum number of times this field must be present/repeated.
        :param str name: The name of the field. For example, "PID-1" or just "1".
        :param str table: The HL7v2 table this field refers to. For example, PID-15 (Patient's Primary Language) usually refers to table "0296".
        :param str type: The type of this field. A Type with this name must be defined in an Hl7TypesConfig.
        """
        pulumi.set(__self__, "max_occurs", max_occurs)
        pulumi.set(__self__, "min_occurs", min_occurs)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "table", table)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="maxOccurs")
    def max_occurs(self) -> int:
        """
        The maximum number of times this field can be repeated. 0 or -1 means unbounded.
        """
        return pulumi.get(self, "max_occurs")

    @property
    @pulumi.getter(name="minOccurs")
    def min_occurs(self) -> int:
        """
        The minimum number of times this field must be present/repeated.
        """
        return pulumi.get(self, "min_occurs")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the field. For example, "PID-1" or just "1".
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def table(self) -> str:
        """
        The HL7v2 table this field refers to. For example, PID-15 (Patient's Primary Language) usually refers to table "0296".
        """
        return pulumi.get(self, "table")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of this field. A Type with this name must be defined in an Hl7TypesConfig.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GoogleCloudHealthcareV1ConsentPolicyResponse(dict):
    """
    Represents a user's consent in terms of the resources that can be accessed and under what conditions.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authorizationRule":
            suggest = "authorization_rule"
        elif key == "resourceAttributes":
            suggest = "resource_attributes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudHealthcareV1ConsentPolicyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudHealthcareV1ConsentPolicyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudHealthcareV1ConsentPolicyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 authorization_rule: 'outputs.ExprResponse',
                 resource_attributes: Sequence['outputs.AttributeResponse']):
        """
        Represents a user's consent in terms of the resources that can be accessed and under what conditions.
        :param 'ExprResponse' authorization_rule: Required. The request conditions to meet to grant access. In addition to any supported comparison operators, authorization rules may have `IN` operator as well as at most 10 logical operators that are limited to `AND` (`&&`), `OR` (`||`).
        :param Sequence['AttributeResponse'] resource_attributes: The resources that this policy applies to. A resource is a match if it matches all the attributes listed here. If empty, this policy applies to all User data mappings for the given user.
        """
        pulumi.set(__self__, "authorization_rule", authorization_rule)
        pulumi.set(__self__, "resource_attributes", resource_attributes)

    @property
    @pulumi.getter(name="authorizationRule")
    def authorization_rule(self) -> 'outputs.ExprResponse':
        """
        Required. The request conditions to meet to grant access. In addition to any supported comparison operators, authorization rules may have `IN` operator as well as at most 10 logical operators that are limited to `AND` (`&&`), `OR` (`||`).
        """
        return pulumi.get(self, "authorization_rule")

    @property
    @pulumi.getter(name="resourceAttributes")
    def resource_attributes(self) -> Sequence['outputs.AttributeResponse']:
        """
        The resources that this policy applies to. A resource is a match if it matches all the attributes listed here. If empty, this policy applies to all User data mappings for the given user.
        """
        return pulumi.get(self, "resource_attributes")


@pulumi.output_type
class GoogleCloudHealthcareV1FhirBigQueryDestinationResponse(dict):
    """
    The configuration for exporting to BigQuery.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "datasetUri":
            suggest = "dataset_uri"
        elif key == "schemaConfig":
            suggest = "schema_config"
        elif key == "writeDisposition":
            suggest = "write_disposition"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudHealthcareV1FhirBigQueryDestinationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudHealthcareV1FhirBigQueryDestinationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudHealthcareV1FhirBigQueryDestinationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dataset_uri: str,
                 force: bool,
                 schema_config: 'outputs.SchemaConfigResponse',
                 write_disposition: str):
        """
        The configuration for exporting to BigQuery.
        :param str dataset_uri: BigQuery URI to an existing dataset, up to 2000 characters long, in the format `bq://projectId.bqDatasetId`.
        :param bool force: If this flag is `TRUE`, all tables are deleted from the dataset before the new exported tables are written. If the flag is not set and the destination dataset contains tables, the export call returns an error. If `write_disposition` is specified, this parameter is ignored. force=false is equivalent to write_disposition=WRITE_EMPTY and force=true is equivalent to write_disposition=WRITE_TRUNCATE.
        :param 'SchemaConfigResponse' schema_config: The configuration for the exported BigQuery schema.
        :param str write_disposition: Determines if existing data in the destination dataset is overwritten, appended to, or not written if the tables contain data. If a write_disposition is specified, the `force` parameter is ignored.
        """
        pulumi.set(__self__, "dataset_uri", dataset_uri)
        pulumi.set(__self__, "force", force)
        pulumi.set(__self__, "schema_config", schema_config)
        pulumi.set(__self__, "write_disposition", write_disposition)

    @property
    @pulumi.getter(name="datasetUri")
    def dataset_uri(self) -> str:
        """
        BigQuery URI to an existing dataset, up to 2000 characters long, in the format `bq://projectId.bqDatasetId`.
        """
        return pulumi.get(self, "dataset_uri")

    @property
    @pulumi.getter
    def force(self) -> bool:
        """
        If this flag is `TRUE`, all tables are deleted from the dataset before the new exported tables are written. If the flag is not set and the destination dataset contains tables, the export call returns an error. If `write_disposition` is specified, this parameter is ignored. force=false is equivalent to write_disposition=WRITE_EMPTY and force=true is equivalent to write_disposition=WRITE_TRUNCATE.
        """
        return pulumi.get(self, "force")

    @property
    @pulumi.getter(name="schemaConfig")
    def schema_config(self) -> 'outputs.SchemaConfigResponse':
        """
        The configuration for the exported BigQuery schema.
        """
        return pulumi.get(self, "schema_config")

    @property
    @pulumi.getter(name="writeDisposition")
    def write_disposition(self) -> str:
        """
        Determines if existing data in the destination dataset is overwritten, appended to, or not written if the tables contain data. If a write_disposition is specified, the `force` parameter is ignored.
        """
        return pulumi.get(self, "write_disposition")


@pulumi.output_type
class Hl7SchemaConfigResponse(dict):
    """
    Root config message for HL7v2 schema. This contains a schema structure of groups and segments, and filters that determine which messages to apply the schema structure to.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "messageSchemaConfigs":
            suggest = "message_schema_configs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in Hl7SchemaConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        Hl7SchemaConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        Hl7SchemaConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 message_schema_configs: Mapping[str, str],
                 version: Sequence['outputs.VersionSourceResponse']):
        """
        Root config message for HL7v2 schema. This contains a schema structure of groups and segments, and filters that determine which messages to apply the schema structure to.
        :param Mapping[str, str] message_schema_configs: Map from each HL7v2 message type and trigger event pair, such as ADT_A04, to its schema configuration root group.
        :param Sequence['VersionSourceResponse'] version: Each VersionSource is tested and only if they all match is the schema used for the message.
        """
        pulumi.set(__self__, "message_schema_configs", message_schema_configs)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="messageSchemaConfigs")
    def message_schema_configs(self) -> Mapping[str, str]:
        """
        Map from each HL7v2 message type and trigger event pair, such as ADT_A04, to its schema configuration root group.
        """
        return pulumi.get(self, "message_schema_configs")

    @property
    @pulumi.getter
    def version(self) -> Sequence['outputs.VersionSourceResponse']:
        """
        Each VersionSource is tested and only if they all match is the schema used for the message.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class Hl7TypesConfigResponse(dict):
    """
    Root config for HL7v2 datatype definitions for a specific HL7v2 version.
    """
    def __init__(__self__, *,
                 type: Sequence['outputs.TypeResponse'],
                 version: Sequence['outputs.VersionSourceResponse']):
        """
        Root config for HL7v2 datatype definitions for a specific HL7v2 version.
        :param Sequence['TypeResponse'] type: The HL7v2 type definitions.
        :param Sequence['VersionSourceResponse'] version: The version selectors that this config applies to. A message must match ALL version sources to apply.
        """
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def type(self) -> Sequence['outputs.TypeResponse']:
        """
        The HL7v2 type definitions.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def version(self) -> Sequence['outputs.VersionSourceResponse']:
        """
        The version selectors that this config applies to. A message must match ALL version sources to apply.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class Hl7V2NotificationConfigResponse(dict):
    """
    Specifies where and whether to send notifications upon changes to a data store.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "pubsubTopic":
            suggest = "pubsub_topic"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in Hl7V2NotificationConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        Hl7V2NotificationConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        Hl7V2NotificationConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 filter: str,
                 pubsub_topic: str):
        """
        Specifies where and whether to send notifications upon changes to a data store.
        :param str filter: Restricts notifications sent for messages matching a filter. If this is empty, all messages are matched. The following syntax is available: * A string field value can be written as text inside quotation marks, for example `"query text"`. The only valid relational operation for text fields is equality (`=`), where text is searched within the field, rather than having the field be equal to the text. For example, `"Comment = great"` returns messages with `great` in the comment field. * A number field value can be written as an integer, a decimal, or an exponential. The valid relational operators for number fields are the equality operator (`=`), along with the less than/greater than operators (`<`, `<=`, `>`, `>=`). Note that there is no inequality (`!=`) operator. You can prepend the `NOT` operator to an expression to negate it. * A date field value must be written in `yyyy-mm-dd` form. Fields with date and time use the RFC3339 time format. Leading zeros are required for one-digit months and days. The valid relational operators for date fields are the equality operator (`=`) , along with the less than/greater than operators (`<`, `<=`, `>`, `>=`). Note that there is no inequality (`!=`) operator. You can prepend the `NOT` operator to an expression to negate it. * Multiple field query expressions can be combined in one query by adding `AND` or `OR` operators between the expressions. If a boolean operator appears within a quoted string, it is not treated as special, it's just another part of the character string to be matched. You can prepend the `NOT` operator to an expression to negate it. The following fields and functions are available for filtering: * `message_type`, from the MSH-9.1 field. For example, `NOT message_type = "ADT"`. * `send_date` or `sendDate`, the YYYY-MM-DD date the message was sent in the dataset's time_zone, from the MSH-7 segment. For example, `send_date < "2017-01-02"`. * `send_time`, the timestamp when the message was sent, using the RFC3339 time format for comparisons, from the MSH-7 segment. For example, `send_time < "2017-01-02T00:00:00-05:00"`. * `create_time`, the timestamp when the message was created in the HL7v2 store. Use the RFC3339 time format for comparisons. For example, `create_time < "2017-01-02T00:00:00-05:00"`. * `send_facility`, the care center that the message came from, from the MSH-4 segment. For example, `send_facility = "ABC"`. * `PatientId(value, type)`, which matches if the message lists a patient having an ID of the given value and type in the PID-2, PID-3, or PID-4 segments. For example, `PatientId("123456", "MRN")`. * `labels.x`, a string value of the label with key `x` as set using the Message.labels map. For example, `labels."priority"="high"`. The operator `:*` can be used to assert the existence of a label. For example, `labels."priority":*`.
        :param str pubsub_topic: The [Pub/Sub](https://cloud.google.com/pubsub/docs/) topic that notifications of changes are published on. Supplied by the client. The notification is a `PubsubMessage` with the following fields: * `PubsubMessage.Data` contains the resource name. * `PubsubMessage.MessageId` is the ID of this notification. It's guaranteed to be unique within the topic. * `PubsubMessage.PublishTime` is the time when the message was published. Note that notifications are only sent if the topic is non-empty. [Topic names](https://cloud.google.com/pubsub/docs/overview#names) must be scoped to a project. The Cloud Healthcare API service account, service-PROJECT_NUMBER@gcp-sa-healthcare.iam.gserviceaccount.com, must have publisher permissions on the given Pub/Sub topic. Not having adequate permissions causes the calls that send notifications to fail. If a notification cannot be published to Pub/Sub, errors are logged to Cloud Logging. For more information, see [Viewing error logs in Cloud Logging](https://cloud.google.com/healthcare/docs/how-tos/logging)).
        """
        pulumi.set(__self__, "filter", filter)
        pulumi.set(__self__, "pubsub_topic", pubsub_topic)

    @property
    @pulumi.getter
    def filter(self) -> str:
        """
        Restricts notifications sent for messages matching a filter. If this is empty, all messages are matched. The following syntax is available: * A string field value can be written as text inside quotation marks, for example `"query text"`. The only valid relational operation for text fields is equality (`=`), where text is searched within the field, rather than having the field be equal to the text. For example, `"Comment = great"` returns messages with `great` in the comment field. * A number field value can be written as an integer, a decimal, or an exponential. The valid relational operators for number fields are the equality operator (`=`), along with the less than/greater than operators (`<`, `<=`, `>`, `>=`). Note that there is no inequality (`!=`) operator. You can prepend the `NOT` operator to an expression to negate it. * A date field value must be written in `yyyy-mm-dd` form. Fields with date and time use the RFC3339 time format. Leading zeros are required for one-digit months and days. The valid relational operators for date fields are the equality operator (`=`) , along with the less than/greater than operators (`<`, `<=`, `>`, `>=`). Note that there is no inequality (`!=`) operator. You can prepend the `NOT` operator to an expression to negate it. * Multiple field query expressions can be combined in one query by adding `AND` or `OR` operators between the expressions. If a boolean operator appears within a quoted string, it is not treated as special, it's just another part of the character string to be matched. You can prepend the `NOT` operator to an expression to negate it. The following fields and functions are available for filtering: * `message_type`, from the MSH-9.1 field. For example, `NOT message_type = "ADT"`. * `send_date` or `sendDate`, the YYYY-MM-DD date the message was sent in the dataset's time_zone, from the MSH-7 segment. For example, `send_date < "2017-01-02"`. * `send_time`, the timestamp when the message was sent, using the RFC3339 time format for comparisons, from the MSH-7 segment. For example, `send_time < "2017-01-02T00:00:00-05:00"`. * `create_time`, the timestamp when the message was created in the HL7v2 store. Use the RFC3339 time format for comparisons. For example, `create_time < "2017-01-02T00:00:00-05:00"`. * `send_facility`, the care center that the message came from, from the MSH-4 segment. For example, `send_facility = "ABC"`. * `PatientId(value, type)`, which matches if the message lists a patient having an ID of the given value and type in the PID-2, PID-3, or PID-4 segments. For example, `PatientId("123456", "MRN")`. * `labels.x`, a string value of the label with key `x` as set using the Message.labels map. For example, `labels."priority"="high"`. The operator `:*` can be used to assert the existence of a label. For example, `labels."priority":*`.
        """
        return pulumi.get(self, "filter")

    @property
    @pulumi.getter(name="pubsubTopic")
    def pubsub_topic(self) -> str:
        """
        The [Pub/Sub](https://cloud.google.com/pubsub/docs/) topic that notifications of changes are published on. Supplied by the client. The notification is a `PubsubMessage` with the following fields: * `PubsubMessage.Data` contains the resource name. * `PubsubMessage.MessageId` is the ID of this notification. It's guaranteed to be unique within the topic. * `PubsubMessage.PublishTime` is the time when the message was published. Note that notifications are only sent if the topic is non-empty. [Topic names](https://cloud.google.com/pubsub/docs/overview#names) must be scoped to a project. The Cloud Healthcare API service account, service-PROJECT_NUMBER@gcp-sa-healthcare.iam.gserviceaccount.com, must have publisher permissions on the given Pub/Sub topic. Not having adequate permissions causes the calls that send notifications to fail. If a notification cannot be published to Pub/Sub, errors are logged to Cloud Logging. For more information, see [Viewing error logs in Cloud Logging](https://cloud.google.com/healthcare/docs/how-tos/logging)).
        """
        return pulumi.get(self, "pubsub_topic")


@pulumi.output_type
class ImageResponse(dict):
    """
    Raw bytes representing consent artifact content.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "gcsUri":
            suggest = "gcs_uri"
        elif key == "rawBytes":
            suggest = "raw_bytes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ImageResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ImageResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ImageResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 gcs_uri: str,
                 raw_bytes: str):
        """
        Raw bytes representing consent artifact content.
        :param str gcs_uri: Input only. Points to a Cloud Storage URI containing the consent artifact content. The URI must be in the following format: `gs://{bucket_id}/{object_id}`. The Cloud Healthcare API service account must have the `roles/storage.objectViewer` Cloud IAM role for this Cloud Storage location. The consent artifact content at this URI is copied to a Cloud Storage location managed by the Cloud Healthcare API. Responses to fetching requests return the consent artifact content in raw_bytes.
        :param str raw_bytes: Consent artifact content represented as a stream of bytes. This field is populated when returned in GetConsentArtifact response, but not included in CreateConsentArtifact and ListConsentArtifact response.
        """
        pulumi.set(__self__, "gcs_uri", gcs_uri)
        pulumi.set(__self__, "raw_bytes", raw_bytes)

    @property
    @pulumi.getter(name="gcsUri")
    def gcs_uri(self) -> str:
        """
        Input only. Points to a Cloud Storage URI containing the consent artifact content. The URI must be in the following format: `gs://{bucket_id}/{object_id}`. The Cloud Healthcare API service account must have the `roles/storage.objectViewer` Cloud IAM role for this Cloud Storage location. The consent artifact content at this URI is copied to a Cloud Storage location managed by the Cloud Healthcare API. Responses to fetching requests return the consent artifact content in raw_bytes.
        """
        return pulumi.get(self, "gcs_uri")

    @property
    @pulumi.getter(name="rawBytes")
    def raw_bytes(self) -> str:
        """
        Consent artifact content represented as a stream of bytes. This field is populated when returned in GetConsentArtifact response, but not included in CreateConsentArtifact and ListConsentArtifact response.
        """
        return pulumi.get(self, "raw_bytes")


@pulumi.output_type
class NotificationConfigResponse(dict):
    """
    Specifies where to send notifications upon changes to a data store.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "pubsubTopic":
            suggest = "pubsub_topic"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NotificationConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NotificationConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NotificationConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 pubsub_topic: str):
        """
        Specifies where to send notifications upon changes to a data store.
        :param str pubsub_topic: The [Pub/Sub](https://cloud.google.com/pubsub/docs/) topic that notifications of changes are published on. Supplied by the client. PubsubMessage.Data contains the resource name. PubsubMessage.MessageId is the ID of this message. It is guaranteed to be unique within the topic. PubsubMessage.PublishTime is the time at which the message was published. Notifications are only sent if the topic is non-empty. [Topic names](https://cloud.google.com/pubsub/docs/overview#names) must be scoped to a project. Cloud Healthcare API service account must have publisher permissions on the given Pub/Sub topic. Not having adequate permissions causes the calls that send notifications to fail. If a notification can't be published to Pub/Sub, errors are logged to Cloud Logging (see [Viewing error logs in Cloud Logging](https://cloud.google.com/healthcare/docs/how-tos/logging)). If the number of errors exceeds a certain rate, some aren't submitted. Note that not all operations trigger notifications, see [Configuring Pub/Sub notifications](https://cloud.google.com/healthcare/docs/how-tos/pubsub) for specific details.
        """
        pulumi.set(__self__, "pubsub_topic", pubsub_topic)

    @property
    @pulumi.getter(name="pubsubTopic")
    def pubsub_topic(self) -> str:
        """
        The [Pub/Sub](https://cloud.google.com/pubsub/docs/) topic that notifications of changes are published on. Supplied by the client. PubsubMessage.Data contains the resource name. PubsubMessage.MessageId is the ID of this message. It is guaranteed to be unique within the topic. PubsubMessage.PublishTime is the time at which the message was published. Notifications are only sent if the topic is non-empty. [Topic names](https://cloud.google.com/pubsub/docs/overview#names) must be scoped to a project. Cloud Healthcare API service account must have publisher permissions on the given Pub/Sub topic. Not having adequate permissions causes the calls that send notifications to fail. If a notification can't be published to Pub/Sub, errors are logged to Cloud Logging (see [Viewing error logs in Cloud Logging](https://cloud.google.com/healthcare/docs/how-tos/logging)). If the number of errors exceeds a certain rate, some aren't submitted. Note that not all operations trigger notifications, see [Configuring Pub/Sub notifications](https://cloud.google.com/healthcare/docs/how-tos/pubsub) for specific details.
        """
        return pulumi.get(self, "pubsub_topic")


@pulumi.output_type
class ParsedDataResponse(dict):
    """
    The content of a HL7v2 message in a structured format.
    """
    def __init__(__self__, *,
                 segments: Sequence['outputs.SegmentResponse']):
        """
        The content of a HL7v2 message in a structured format.
        """
        pulumi.set(__self__, "segments", segments)

    @property
    @pulumi.getter
    def segments(self) -> Sequence['outputs.SegmentResponse']:
        return pulumi.get(self, "segments")


@pulumi.output_type
class ParserConfigResponse(dict):
    """
    The configuration for the parser. It determines how the server parses the messages.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowNullHeader":
            suggest = "allow_null_header"
        elif key == "segmentTerminator":
            suggest = "segment_terminator"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ParserConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ParserConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ParserConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allow_null_header: bool,
                 schema: 'outputs.SchemaPackageResponse',
                 segment_terminator: str):
        """
        The configuration for the parser. It determines how the server parses the messages.
        :param bool allow_null_header: Determines whether messages with no header are allowed.
        :param 'SchemaPackageResponse' schema: Schemas used to parse messages in this store, if schematized parsing is desired.
        :param str segment_terminator: Byte(s) to use as the segment terminator. If this is unset, '\r' is used as segment terminator, matching the HL7 version 2 specification.
        """
        pulumi.set(__self__, "allow_null_header", allow_null_header)
        pulumi.set(__self__, "schema", schema)
        pulumi.set(__self__, "segment_terminator", segment_terminator)

    @property
    @pulumi.getter(name="allowNullHeader")
    def allow_null_header(self) -> bool:
        """
        Determines whether messages with no header are allowed.
        """
        return pulumi.get(self, "allow_null_header")

    @property
    @pulumi.getter
    def schema(self) -> 'outputs.SchemaPackageResponse':
        """
        Schemas used to parse messages in this store, if schematized parsing is desired.
        """
        return pulumi.get(self, "schema")

    @property
    @pulumi.getter(name="segmentTerminator")
    def segment_terminator(self) -> str:
        """
        Byte(s) to use as the segment terminator. If this is unset, '\r' is used as segment terminator, matching the HL7 version 2 specification.
        """
        return pulumi.get(self, "segment_terminator")


@pulumi.output_type
class PatientIdResponse(dict):
    """
    A patient identifier and associated type.
    """
    def __init__(__self__, *,
                 type: str,
                 value: str):
        """
        A patient identifier and associated type.
        :param str type: ID type. For example, MRN or NHS.
        :param str value: The patient's unique identifier.
        """
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        ID type. For example, MRN or NHS.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The patient's unique identifier.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class SchemaConfigResponse(dict):
    """
    Configuration for the FHIR BigQuery schema. Determines how the server generates the schema.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "recursiveStructureDepth":
            suggest = "recursive_structure_depth"
        elif key == "schemaType":
            suggest = "schema_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SchemaConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SchemaConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SchemaConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 recursive_structure_depth: str,
                 schema_type: str):
        """
        Configuration for the FHIR BigQuery schema. Determines how the server generates the schema.
        :param str recursive_structure_depth: The depth for all recursive structures in the output analytics schema. For example, `concept` in the CodeSystem resource is a recursive structure; when the depth is 2, the CodeSystem table will have a column called `concept.concept` but not `concept.concept.concept`. If not specified or set to 0, the server will use the default value 2. The maximum depth allowed is 5.
        :param str schema_type: Specifies the output schema type. Schema type is required.
        """
        pulumi.set(__self__, "recursive_structure_depth", recursive_structure_depth)
        pulumi.set(__self__, "schema_type", schema_type)

    @property
    @pulumi.getter(name="recursiveStructureDepth")
    def recursive_structure_depth(self) -> str:
        """
        The depth for all recursive structures in the output analytics schema. For example, `concept` in the CodeSystem resource is a recursive structure; when the depth is 2, the CodeSystem table will have a column called `concept.concept` but not `concept.concept.concept`. If not specified or set to 0, the server will use the default value 2. The maximum depth allowed is 5.
        """
        return pulumi.get(self, "recursive_structure_depth")

    @property
    @pulumi.getter(name="schemaType")
    def schema_type(self) -> str:
        """
        Specifies the output schema type. Schema type is required.
        """
        return pulumi.get(self, "schema_type")


@pulumi.output_type
class SchemaPackageResponse(dict):
    """
    A schema package contains a set of schemas and type definitions.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ignoreMinOccurs":
            suggest = "ignore_min_occurs"
        elif key == "schematizedParsingType":
            suggest = "schematized_parsing_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SchemaPackageResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SchemaPackageResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SchemaPackageResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ignore_min_occurs: bool,
                 schemas: Sequence['outputs.Hl7SchemaConfigResponse'],
                 schematized_parsing_type: str,
                 types: Sequence['outputs.Hl7TypesConfigResponse']):
        """
        A schema package contains a set of schemas and type definitions.
        :param bool ignore_min_occurs: Flag to ignore all min_occurs restrictions in the schema. This means that incoming messages can omit any group, segment, field, component, or subcomponent.
        :param Sequence['Hl7SchemaConfigResponse'] schemas: Schema configs that are layered based on their VersionSources that match the incoming message. Schema configs present in higher indices override those in lower indices with the same message type and trigger event if their VersionSources all match an incoming message.
        :param str schematized_parsing_type: Determines how messages that fail to parse are handled.
        :param Sequence['Hl7TypesConfigResponse'] types: Schema type definitions that are layered based on their VersionSources that match the incoming message. Type definitions present in higher indices override those in lower indices with the same type name if their VersionSources all match an incoming message.
        """
        pulumi.set(__self__, "ignore_min_occurs", ignore_min_occurs)
        pulumi.set(__self__, "schemas", schemas)
        pulumi.set(__self__, "schematized_parsing_type", schematized_parsing_type)
        pulumi.set(__self__, "types", types)

    @property
    @pulumi.getter(name="ignoreMinOccurs")
    def ignore_min_occurs(self) -> bool:
        """
        Flag to ignore all min_occurs restrictions in the schema. This means that incoming messages can omit any group, segment, field, component, or subcomponent.
        """
        return pulumi.get(self, "ignore_min_occurs")

    @property
    @pulumi.getter
    def schemas(self) -> Sequence['outputs.Hl7SchemaConfigResponse']:
        """
        Schema configs that are layered based on their VersionSources that match the incoming message. Schema configs present in higher indices override those in lower indices with the same message type and trigger event if their VersionSources all match an incoming message.
        """
        return pulumi.get(self, "schemas")

    @property
    @pulumi.getter(name="schematizedParsingType")
    def schematized_parsing_type(self) -> str:
        """
        Determines how messages that fail to parse are handled.
        """
        return pulumi.get(self, "schematized_parsing_type")

    @property
    @pulumi.getter
    def types(self) -> Sequence['outputs.Hl7TypesConfigResponse']:
        """
        Schema type definitions that are layered based on their VersionSources that match the incoming message. Type definitions present in higher indices override those in lower indices with the same type name if their VersionSources all match an incoming message.
        """
        return pulumi.get(self, "types")


@pulumi.output_type
class SchematizedDataResponse(dict):
    """
    The content of an HL7v2 message in a structured format as specified by a schema.
    """
    def __init__(__self__, *,
                 data: str,
                 error: str):
        """
        The content of an HL7v2 message in a structured format as specified by a schema.
        :param str data: JSON output of the parser.
        :param str error: The error output of the parser.
        """
        pulumi.set(__self__, "data", data)
        pulumi.set(__self__, "error", error)

    @property
    @pulumi.getter
    def data(self) -> str:
        """
        JSON output of the parser.
        """
        return pulumi.get(self, "data")

    @property
    @pulumi.getter
    def error(self) -> str:
        """
        The error output of the parser.
        """
        return pulumi.get(self, "error")


@pulumi.output_type
class SegmentResponse(dict):
    """
    A segment in a structured format.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "segmentId":
            suggest = "segment_id"
        elif key == "setId":
            suggest = "set_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SegmentResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SegmentResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SegmentResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 fields: Mapping[str, str],
                 segment_id: str,
                 set_id: str):
        """
        A segment in a structured format.
        :param Mapping[str, str] fields: A mapping from the positional location to the value. The key string uses zero-based indexes separated by dots to identify Fields, components and sub-components. A bracket notation is also used to identify different instances of a repeated field. Regex for key: (\d+)(\[\d+\])?(.\d+)?(.\d+)? Examples of (key, value) pairs: * (0.1, "hemoglobin") denotes that the first component of Field 0 has the value "hemoglobin". * (1.1.2, "CBC") denotes that the second sub-component of the first component of Field 1 has the value "CBC". * (1[0].1, "HbA1c") denotes that the first component of the first Instance of Field 1, which is repeated, has the value "HbA1c".
        :param str segment_id: A string that indicates the type of segment. For example, EVN or PID.
        :param str set_id: Set ID for segments that can be in a set. This can be empty if it's missing or isn't applicable.
        """
        pulumi.set(__self__, "fields", fields)
        pulumi.set(__self__, "segment_id", segment_id)
        pulumi.set(__self__, "set_id", set_id)

    @property
    @pulumi.getter
    def fields(self) -> Mapping[str, str]:
        """
        A mapping from the positional location to the value. The key string uses zero-based indexes separated by dots to identify Fields, components and sub-components. A bracket notation is also used to identify different instances of a repeated field. Regex for key: (\d+)(\[\d+\])?(.\d+)?(.\d+)? Examples of (key, value) pairs: * (0.1, "hemoglobin") denotes that the first component of Field 0 has the value "hemoglobin". * (1.1.2, "CBC") denotes that the second sub-component of the first component of Field 1 has the value "CBC". * (1[0].1, "HbA1c") denotes that the first component of the first Instance of Field 1, which is repeated, has the value "HbA1c".
        """
        return pulumi.get(self, "fields")

    @property
    @pulumi.getter(name="segmentId")
    def segment_id(self) -> str:
        """
        A string that indicates the type of segment. For example, EVN or PID.
        """
        return pulumi.get(self, "segment_id")

    @property
    @pulumi.getter(name="setId")
    def set_id(self) -> str:
        """
        Set ID for segments that can be in a set. This can be empty if it's missing or isn't applicable.
        """
        return pulumi.get(self, "set_id")


@pulumi.output_type
class SignatureResponse(dict):
    """
    User signature.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "signatureTime":
            suggest = "signature_time"
        elif key == "userId":
            suggest = "user_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SignatureResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SignatureResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SignatureResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 image: 'outputs.ImageResponse',
                 metadata: Mapping[str, str],
                 signature_time: str,
                 user_id: str):
        """
        User signature.
        :param 'ImageResponse' image: Optional. An image of the user's signature.
        :param Mapping[str, str] metadata: Optional. Metadata associated with the user's signature. For example, the user's name or the user's title.
        :param str signature_time: Optional. Timestamp of the signature.
        :param str user_id: Required. User's UUID provided by the client.
        """
        pulumi.set(__self__, "image", image)
        pulumi.set(__self__, "metadata", metadata)
        pulumi.set(__self__, "signature_time", signature_time)
        pulumi.set(__self__, "user_id", user_id)

    @property
    @pulumi.getter
    def image(self) -> 'outputs.ImageResponse':
        """
        Optional. An image of the user's signature.
        """
        return pulumi.get(self, "image")

    @property
    @pulumi.getter
    def metadata(self) -> Mapping[str, str]:
        """
        Optional. Metadata associated with the user's signature. For example, the user's name or the user's title.
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter(name="signatureTime")
    def signature_time(self) -> str:
        """
        Optional. Timestamp of the signature.
        """
        return pulumi.get(self, "signature_time")

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> str:
        """
        Required. User's UUID provided by the client.
        """
        return pulumi.get(self, "user_id")


@pulumi.output_type
class StreamConfigResponse(dict):
    """
    Contains configuration for streaming FHIR export.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bigqueryDestination":
            suggest = "bigquery_destination"
        elif key == "resourceTypes":
            suggest = "resource_types"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StreamConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StreamConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StreamConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bigquery_destination: 'outputs.GoogleCloudHealthcareV1FhirBigQueryDestinationResponse',
                 resource_types: Sequence[str]):
        """
        Contains configuration for streaming FHIR export.
        :param 'GoogleCloudHealthcareV1FhirBigQueryDestinationResponse' bigquery_destination: The destination BigQuery structure that contains both the dataset location and corresponding schema config. The output is organized in one table per resource type. The server reuses the existing tables (if any) that are named after the resource types. For example, "Patient", "Observation". When there is no existing table for a given resource type, the server attempts to create one. When a table schema doesn't align with the schema config, either because of existing incompatible schema or out of band incompatible modification, the server does not stream in new data. BigQuery imposes a 1 MB limit on streaming insert row size, therefore any resource mutation that generates more than 1 MB of BigQuery data is not streamed. One resolution in this case is to delete the incompatible table and let the server recreate one, though the newly created table only contains data after the table recreation. Results are appended to the corresponding BigQuery tables. Different versions of the same resource are distinguishable by the meta.versionId and meta.lastUpdated columns. The operation (CREATE/UPDATE/DELETE) that results in the new version is recorded in the meta.tag. The tables contain all historical resource versions since streaming was enabled. For query convenience, the server also creates one view per table of the same name containing only the current resource version. The streamed data in the BigQuery dataset is not guaranteed to be completely unique. The combination of the id and meta.versionId columns should ideally identify a single unique row. But in rare cases, duplicates may exist. At query time, users may use the SQL select statement to keep only one of the duplicate rows given an id and meta.versionId pair. Alternatively, the server created view mentioned above also filters out duplicates. If a resource mutation cannot be streamed to BigQuery, errors are logged to Cloud Logging. For more information, see [Viewing error logs in Cloud Logging](https://cloud.google.com/healthcare/docs/how-tos/logging)).
        :param Sequence[str] resource_types: Supply a FHIR resource type (such as "Patient" or "Observation"). See https://www.hl7.org/fhir/valueset-resource-types.html for a list of all FHIR resource types. The server treats an empty list as an intent to stream all the supported resource types in this FHIR store.
        """
        pulumi.set(__self__, "bigquery_destination", bigquery_destination)
        pulumi.set(__self__, "resource_types", resource_types)

    @property
    @pulumi.getter(name="bigqueryDestination")
    def bigquery_destination(self) -> 'outputs.GoogleCloudHealthcareV1FhirBigQueryDestinationResponse':
        """
        The destination BigQuery structure that contains both the dataset location and corresponding schema config. The output is organized in one table per resource type. The server reuses the existing tables (if any) that are named after the resource types. For example, "Patient", "Observation". When there is no existing table for a given resource type, the server attempts to create one. When a table schema doesn't align with the schema config, either because of existing incompatible schema or out of band incompatible modification, the server does not stream in new data. BigQuery imposes a 1 MB limit on streaming insert row size, therefore any resource mutation that generates more than 1 MB of BigQuery data is not streamed. One resolution in this case is to delete the incompatible table and let the server recreate one, though the newly created table only contains data after the table recreation. Results are appended to the corresponding BigQuery tables. Different versions of the same resource are distinguishable by the meta.versionId and meta.lastUpdated columns. The operation (CREATE/UPDATE/DELETE) that results in the new version is recorded in the meta.tag. The tables contain all historical resource versions since streaming was enabled. For query convenience, the server also creates one view per table of the same name containing only the current resource version. The streamed data in the BigQuery dataset is not guaranteed to be completely unique. The combination of the id and meta.versionId columns should ideally identify a single unique row. But in rare cases, duplicates may exist. At query time, users may use the SQL select statement to keep only one of the duplicate rows given an id and meta.versionId pair. Alternatively, the server created view mentioned above also filters out duplicates. If a resource mutation cannot be streamed to BigQuery, errors are logged to Cloud Logging. For more information, see [Viewing error logs in Cloud Logging](https://cloud.google.com/healthcare/docs/how-tos/logging)).
        """
        return pulumi.get(self, "bigquery_destination")

    @property
    @pulumi.getter(name="resourceTypes")
    def resource_types(self) -> Sequence[str]:
        """
        Supply a FHIR resource type (such as "Patient" or "Observation"). See https://www.hl7.org/fhir/valueset-resource-types.html for a list of all FHIR resource types. The server treats an empty list as an intent to stream all the supported resource types in this FHIR store.
        """
        return pulumi.get(self, "resource_types")


@pulumi.output_type
class TypeResponse(dict):
    """
    A type definition for some HL7v2 type (incl. Segments and Datatypes).
    """
    def __init__(__self__, *,
                 fields: Sequence['outputs.FieldResponse'],
                 name: str,
                 primitive: str):
        """
        A type definition for some HL7v2 type (incl. Segments and Datatypes).
        :param Sequence['FieldResponse'] fields: The (sub) fields this type has (if not primitive).
        :param str name: The name of this type. This would be the segment or datatype name. For example, "PID" or "XPN".
        :param str primitive: If this is a primitive type then this field is the type of the primitive For example, STRING. Leave unspecified for composite types.
        """
        pulumi.set(__self__, "fields", fields)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "primitive", primitive)

    @property
    @pulumi.getter
    def fields(self) -> Sequence['outputs.FieldResponse']:
        """
        The (sub) fields this type has (if not primitive).
        """
        return pulumi.get(self, "fields")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of this type. This would be the segment or datatype name. For example, "PID" or "XPN".
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def primitive(self) -> str:
        """
        If this is a primitive type then this field is the type of the primitive For example, STRING. Leave unspecified for composite types.
        """
        return pulumi.get(self, "primitive")


@pulumi.output_type
class VersionSourceResponse(dict):
    """
    Describes a selector for extracting and matching an MSH field to a value.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "mshField":
            suggest = "msh_field"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VersionSourceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VersionSourceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VersionSourceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 msh_field: str,
                 value: str):
        """
        Describes a selector for extracting and matching an MSH field to a value.
        :param str msh_field: The field to extract from the MSH segment. For example, "3.1" or "18[1].1".
        :param str value: The value to match with the field. For example, "My Application Name" or "2.3".
        """
        pulumi.set(__self__, "msh_field", msh_field)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter(name="mshField")
    def msh_field(self) -> str:
        """
        The field to extract from the MSH segment. For example, "3.1" or "18[1].1".
        """
        return pulumi.get(self, "msh_field")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The value to match with the field. For example, "My Application Name" or "2.3".
        """
        return pulumi.get(self, "value")


