# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DlpJobArgs', 'DlpJob']

@pulumi.input_type
class DlpJobArgs:
    def __init__(__self__, *,
                 location: pulumi.Input[str],
                 project: pulumi.Input[str],
                 inspect_job: Optional[pulumi.Input['GooglePrivacyDlpV2InspectJobConfigArgs']] = None,
                 job_id: Optional[pulumi.Input[str]] = None,
                 risk_job: Optional[pulumi.Input['GooglePrivacyDlpV2RiskAnalysisJobConfigArgs']] = None):
        """
        The set of arguments for constructing a DlpJob resource.
        :param pulumi.Input['GooglePrivacyDlpV2InspectJobConfigArgs'] inspect_job: An inspection job scans a storage repository for InfoTypes.
        :param pulumi.Input[str] job_id: The job id can contain uppercase and lowercase letters, numbers, and hyphens; that is, it must match the regular expression: `[a-zA-Z\d-_]+`. The maximum length is 100 characters. Can be empty to allow the system to generate one.
        :param pulumi.Input['GooglePrivacyDlpV2RiskAnalysisJobConfigArgs'] risk_job: A risk analysis job calculates re-identification risk metrics for a BigQuery table.
        """
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "project", project)
        if inspect_job is not None:
            pulumi.set(__self__, "inspect_job", inspect_job)
        if job_id is not None:
            pulumi.set(__self__, "job_id", job_id)
        if risk_job is not None:
            pulumi.set(__self__, "risk_job", risk_job)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[str]:
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[str]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def project(self) -> pulumi.Input[str]:
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: pulumi.Input[str]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="inspectJob")
    def inspect_job(self) -> Optional[pulumi.Input['GooglePrivacyDlpV2InspectJobConfigArgs']]:
        """
        An inspection job scans a storage repository for InfoTypes.
        """
        return pulumi.get(self, "inspect_job")

    @inspect_job.setter
    def inspect_job(self, value: Optional[pulumi.Input['GooglePrivacyDlpV2InspectJobConfigArgs']]):
        pulumi.set(self, "inspect_job", value)

    @property
    @pulumi.getter(name="jobId")
    def job_id(self) -> Optional[pulumi.Input[str]]:
        """
        The job id can contain uppercase and lowercase letters, numbers, and hyphens; that is, it must match the regular expression: `[a-zA-Z\d-_]+`. The maximum length is 100 characters. Can be empty to allow the system to generate one.
        """
        return pulumi.get(self, "job_id")

    @job_id.setter
    def job_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "job_id", value)

    @property
    @pulumi.getter(name="riskJob")
    def risk_job(self) -> Optional[pulumi.Input['GooglePrivacyDlpV2RiskAnalysisJobConfigArgs']]:
        """
        A risk analysis job calculates re-identification risk metrics for a BigQuery table.
        """
        return pulumi.get(self, "risk_job")

    @risk_job.setter
    def risk_job(self, value: Optional[pulumi.Input['GooglePrivacyDlpV2RiskAnalysisJobConfigArgs']]):
        pulumi.set(self, "risk_job", value)


class DlpJob(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 inspect_job: Optional[pulumi.Input[pulumi.InputType['GooglePrivacyDlpV2InspectJobConfigArgs']]] = None,
                 job_id: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 risk_job: Optional[pulumi.Input[pulumi.InputType['GooglePrivacyDlpV2RiskAnalysisJobConfigArgs']]] = None,
                 __props__=None):
        """
        Creates a new job to inspect storage or calculate risk metrics. See https://cloud.google.com/dlp/docs/inspecting-storage and https://cloud.google.com/dlp/docs/compute-risk-analysis to learn more. When no InfoTypes or CustomInfoTypes are specified in inspect jobs, the system will automatically choose what detectors to run. By default this may be all types, but may change over time as detectors are updated.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['GooglePrivacyDlpV2InspectJobConfigArgs']] inspect_job: An inspection job scans a storage repository for InfoTypes.
        :param pulumi.Input[str] job_id: The job id can contain uppercase and lowercase letters, numbers, and hyphens; that is, it must match the regular expression: `[a-zA-Z\d-_]+`. The maximum length is 100 characters. Can be empty to allow the system to generate one.
        :param pulumi.Input[pulumi.InputType['GooglePrivacyDlpV2RiskAnalysisJobConfigArgs']] risk_job: A risk analysis job calculates re-identification risk metrics for a BigQuery table.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DlpJobArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates a new job to inspect storage or calculate risk metrics. See https://cloud.google.com/dlp/docs/inspecting-storage and https://cloud.google.com/dlp/docs/compute-risk-analysis to learn more. When no InfoTypes or CustomInfoTypes are specified in inspect jobs, the system will automatically choose what detectors to run. By default this may be all types, but may change over time as detectors are updated.

        :param str resource_name: The name of the resource.
        :param DlpJobArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DlpJobArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 inspect_job: Optional[pulumi.Input[pulumi.InputType['GooglePrivacyDlpV2InspectJobConfigArgs']]] = None,
                 job_id: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 risk_job: Optional[pulumi.Input[pulumi.InputType['GooglePrivacyDlpV2RiskAnalysisJobConfigArgs']]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DlpJobArgs.__new__(DlpJobArgs)

            __props__.__dict__["inspect_job"] = inspect_job
            __props__.__dict__["job_id"] = job_id
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            if project is None and not opts.urn:
                raise TypeError("Missing required property 'project'")
            __props__.__dict__["project"] = project
            __props__.__dict__["risk_job"] = risk_job
            __props__.__dict__["create_time"] = None
            __props__.__dict__["end_time"] = None
            __props__.__dict__["errors"] = None
            __props__.__dict__["inspect_details"] = None
            __props__.__dict__["job_trigger_name"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["risk_details"] = None
            __props__.__dict__["start_time"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["type"] = None
        super(DlpJob, __self__).__init__(
            'google-native:dlp/v2:DlpJob',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'DlpJob':
        """
        Get an existing DlpJob resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = DlpJobArgs.__new__(DlpJobArgs)

        __props__.__dict__["create_time"] = None
        __props__.__dict__["end_time"] = None
        __props__.__dict__["errors"] = None
        __props__.__dict__["inspect_details"] = None
        __props__.__dict__["job_trigger_name"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["risk_details"] = None
        __props__.__dict__["start_time"] = None
        __props__.__dict__["state"] = None
        __props__.__dict__["type"] = None
        return DlpJob(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[str]:
        """
        Time when the job was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> pulumi.Output[str]:
        """
        Time when the job finished.
        """
        return pulumi.get(self, "end_time")

    @property
    @pulumi.getter
    def errors(self) -> pulumi.Output[Sequence['outputs.GooglePrivacyDlpV2ErrorResponse']]:
        """
        A stream of errors encountered running the job.
        """
        return pulumi.get(self, "errors")

    @property
    @pulumi.getter(name="inspectDetails")
    def inspect_details(self) -> pulumi.Output['outputs.GooglePrivacyDlpV2InspectDataSourceDetailsResponse']:
        """
        Results from inspecting a data source.
        """
        return pulumi.get(self, "inspect_details")

    @property
    @pulumi.getter(name="jobTriggerName")
    def job_trigger_name(self) -> pulumi.Output[str]:
        """
        If created by a job trigger, the resource name of the trigger that instantiated the job.
        """
        return pulumi.get(self, "job_trigger_name")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The server-assigned name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="riskDetails")
    def risk_details(self) -> pulumi.Output['outputs.GooglePrivacyDlpV2AnalyzeDataSourceRiskDetailsResponse']:
        """
        Results from analyzing risk of a data source.
        """
        return pulumi.get(self, "risk_details")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> pulumi.Output[str]:
        """
        Time when the job started.
        """
        return pulumi.get(self, "start_time")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        State of a job.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        The type of job.
        """
        return pulumi.get(self, "type")

