# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GoogleCloudDialogflowV2beta1AutomatedAgentConfigResponse',
    'GoogleCloudDialogflowV2beta1ContextResponse',
    'GoogleCloudDialogflowV2beta1ConversationPhoneNumberResponse',
    'GoogleCloudDialogflowV2beta1DocumentReloadStatusResponse',
    'GoogleCloudDialogflowV2beta1EntityTypeEntityResponse',
    'GoogleCloudDialogflowV2beta1FulfillmentFeatureResponse',
    'GoogleCloudDialogflowV2beta1FulfillmentGenericWebServiceResponse',
    'GoogleCloudDialogflowV2beta1FulfillmentResponse',
    'GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigConversationModelConfigResponse',
    'GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigMessageAnalysisConfigResponse',
    'GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigResponse',
    'GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionConfigResponse',
    'GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionFeatureConfigResponse',
    'GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionQueryConfigContextFilterSettingsResponse',
    'GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionQueryConfigDialogflowQuerySourceResponse',
    'GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionQueryConfigDocumentQuerySourceResponse',
    'GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionQueryConfigKnowledgeBaseQuerySourceResponse',
    'GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionQueryConfigResponse',
    'GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionTriggerSettingsResponse',
    'GoogleCloudDialogflowV2beta1HumanAgentHandoffConfigLivePersonConfigResponse',
    'GoogleCloudDialogflowV2beta1HumanAgentHandoffConfigResponse',
    'GoogleCloudDialogflowV2beta1HumanAgentHandoffConfigSalesforceLiveAgentConfigResponse',
    'GoogleCloudDialogflowV2beta1IntentFollowupIntentInfoResponse',
    'GoogleCloudDialogflowV2beta1IntentMessageBasicCardButtonOpenUriActionResponse',
    'GoogleCloudDialogflowV2beta1IntentMessageBasicCardButtonResponse',
    'GoogleCloudDialogflowV2beta1IntentMessageBasicCardResponse',
    'GoogleCloudDialogflowV2beta1IntentMessageBrowseCarouselCardBrowseCarouselCardItemOpenUrlActionResponse',
    'GoogleCloudDialogflowV2beta1IntentMessageBrowseCarouselCardBrowseCarouselCardItemResponse',
    'GoogleCloudDialogflowV2beta1IntentMessageBrowseCarouselCardResponse',
    'GoogleCloudDialogflowV2beta1IntentMessageCardButtonResponse',
    'GoogleCloudDialogflowV2beta1IntentMessageCardResponse',
    'GoogleCloudDialogflowV2beta1IntentMessageCarouselSelectItemResponse',
    'GoogleCloudDialogflowV2beta1IntentMessageCarouselSelectResponse',
    'GoogleCloudDialogflowV2beta1IntentMessageColumnPropertiesResponse',
    'GoogleCloudDialogflowV2beta1IntentMessageImageResponse',
    'GoogleCloudDialogflowV2beta1IntentMessageLinkOutSuggestionResponse',
    'GoogleCloudDialogflowV2beta1IntentMessageListSelectItemResponse',
    'GoogleCloudDialogflowV2beta1IntentMessageListSelectResponse',
    'GoogleCloudDialogflowV2beta1IntentMessageMediaContentResponse',
    'GoogleCloudDialogflowV2beta1IntentMessageMediaContentResponseMediaObjectResponse',
    'GoogleCloudDialogflowV2beta1IntentMessageQuickRepliesResponse',
    'GoogleCloudDialogflowV2beta1IntentMessageRbmCardContentRbmMediaResponse',
    'GoogleCloudDialogflowV2beta1IntentMessageRbmCardContentResponse',
    'GoogleCloudDialogflowV2beta1IntentMessageRbmCarouselCardResponse',
    'GoogleCloudDialogflowV2beta1IntentMessageRbmStandaloneCardResponse',
    'GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedActionRbmSuggestedActionDialResponse',
    'GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedActionRbmSuggestedActionOpenUriResponse',
    'GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedActionRbmSuggestedActionShareLocationResponse',
    'GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedActionResponse',
    'GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedReplyResponse',
    'GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestionResponse',
    'GoogleCloudDialogflowV2beta1IntentMessageRbmTextResponse',
    'GoogleCloudDialogflowV2beta1IntentMessageResponse',
    'GoogleCloudDialogflowV2beta1IntentMessageSelectItemInfoResponse',
    'GoogleCloudDialogflowV2beta1IntentMessageSimpleResponseResponse',
    'GoogleCloudDialogflowV2beta1IntentMessageSimpleResponsesResponse',
    'GoogleCloudDialogflowV2beta1IntentMessageSuggestionResponse',
    'GoogleCloudDialogflowV2beta1IntentMessageSuggestionsResponse',
    'GoogleCloudDialogflowV2beta1IntentMessageTableCardCellResponse',
    'GoogleCloudDialogflowV2beta1IntentMessageTableCardResponse',
    'GoogleCloudDialogflowV2beta1IntentMessageTableCardRowResponse',
    'GoogleCloudDialogflowV2beta1IntentMessageTelephonyPlayAudioResponse',
    'GoogleCloudDialogflowV2beta1IntentMessageTelephonySynthesizeSpeechResponse',
    'GoogleCloudDialogflowV2beta1IntentMessageTelephonyTransferCallResponse',
    'GoogleCloudDialogflowV2beta1IntentMessageTextResponse',
    'GoogleCloudDialogflowV2beta1IntentParameterResponse',
    'GoogleCloudDialogflowV2beta1IntentTrainingPhrasePartResponse',
    'GoogleCloudDialogflowV2beta1IntentTrainingPhraseResponse',
    'GoogleCloudDialogflowV2beta1LoggingConfigResponse',
    'GoogleCloudDialogflowV2beta1NotificationConfigResponse',
    'GoogleCloudDialogflowV2beta1SpeechToTextConfigResponse',
    'GoogleCloudDialogflowV2beta1SuggestionFeatureResponse',
    'GoogleCloudDialogflowV2beta1TextToSpeechSettingsResponse',
    'GoogleRpcStatusResponse',
]

@pulumi.output_type
class GoogleCloudDialogflowV2beta1AutomatedAgentConfigResponse(dict):
    """
    Defines the Automated Agent to connect to a conversation.
    """
    def __init__(__self__, *,
                 agent: str):
        """
        Defines the Automated Agent to connect to a conversation.
        :param str agent: Required. ID of the Dialogflow agent environment to use. This project needs to either be the same project as the conversation or you need to grant `service-@gcp-sa-dialogflow.iam.gserviceaccount.com` the `Dialogflow API Service Agent` role in this project. - For ES agents, use format: `projects//locations//agent/environments/`. If environment is not specified, the default `draft` environment is used. Refer to [DetectIntentRequest](/dialogflow/docs/reference/rpc/google.cloud.dialogflow.v2beta1#google.cloud.dialogflow.v2beta1.DetectIntentRequest) for more details. - For CX agents, use format `projects//locations//agents//environments/`. If environment is not specified, the default `draft` environment is used.
        """
        pulumi.set(__self__, "agent", agent)

    @property
    @pulumi.getter
    def agent(self) -> str:
        """
        Required. ID of the Dialogflow agent environment to use. This project needs to either be the same project as the conversation or you need to grant `service-@gcp-sa-dialogflow.iam.gserviceaccount.com` the `Dialogflow API Service Agent` role in this project. - For ES agents, use format: `projects//locations//agent/environments/`. If environment is not specified, the default `draft` environment is used. Refer to [DetectIntentRequest](/dialogflow/docs/reference/rpc/google.cloud.dialogflow.v2beta1#google.cloud.dialogflow.v2beta1.DetectIntentRequest) for more details. - For CX agents, use format `projects//locations//agents//environments/`. If environment is not specified, the default `draft` environment is used.
        """
        return pulumi.get(self, "agent")


@pulumi.output_type
class GoogleCloudDialogflowV2beta1ContextResponse(dict):
    """
    Dialogflow contexts are similar to natural language context. If a person says to you "they are orange", you need context in order to understand what "they" is referring to. Similarly, for Dialogflow to handle an end-user expression like that, it needs to be provided with context in order to correctly match an intent. Using contexts, you can control the flow of a conversation. You can configure contexts for an intent by setting input and output contexts, which are identified by string names. When an intent is matched, any configured output contexts for that intent become active. While any contexts are active, Dialogflow is more likely to match intents that are configured with input contexts that correspond to the currently active contexts. For more information about context, see the [Contexts guide](https://cloud.google.com/dialogflow/docs/contexts-overview).
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lifespanCount":
            suggest = "lifespan_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDialogflowV2beta1ContextResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDialogflowV2beta1ContextResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDialogflowV2beta1ContextResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 lifespan_count: int,
                 name: str,
                 parameters: Mapping[str, str]):
        """
        Dialogflow contexts are similar to natural language context. If a person says to you "they are orange", you need context in order to understand what "they" is referring to. Similarly, for Dialogflow to handle an end-user expression like that, it needs to be provided with context in order to correctly match an intent. Using contexts, you can control the flow of a conversation. You can configure contexts for an intent by setting input and output contexts, which are identified by string names. When an intent is matched, any configured output contexts for that intent become active. While any contexts are active, Dialogflow is more likely to match intents that are configured with input contexts that correspond to the currently active contexts. For more information about context, see the [Contexts guide](https://cloud.google.com/dialogflow/docs/contexts-overview).
        :param int lifespan_count: Optional. The number of conversational query requests after which the context expires. The default is `0`. If set to `0`, the context expires immediately. Contexts expire automatically after 20 minutes if there are no matching queries.
        :param str name: Required. The unique identifier of the context. Supported formats: - `projects//agent/sessions//contexts/`, - `projects//locations//agent/sessions//contexts/`, - `projects//agent/environments//users//sessions//contexts/`, - `projects//locations//agent/environments//users//sessions//contexts/`, The `Context ID` is always converted to lowercase, may only contain characters in a-zA-Z0-9_-% and may be at most 250 bytes long. If `Environment ID` is not specified, we assume default 'draft' environment. If `User ID` is not specified, we assume default '-' user. The following context names are reserved for internal use by Dialogflow. You should not use these contexts or create contexts with these names: * `__system_counters__` * `*_id_dialog_context` * `*_dialog_params_size`
        :param Mapping[str, str] parameters: Optional. The collection of parameters associated with this context. Depending on your protocol or client library language, this is a map, associative array, symbol table, dictionary, or JSON object composed of a collection of (MapKey, MapValue) pairs: - MapKey type: string - MapKey value: parameter name - MapValue type: - If parameter's entity type is a composite entity: map - Else: depending on parameter value type, could be one of string, number, boolean, null, list or map - MapValue value: - If parameter's entity type is a composite entity: map from composite entity property names to property values - Else: parameter value
        """
        pulumi.set(__self__, "lifespan_count", lifespan_count)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter(name="lifespanCount")
    def lifespan_count(self) -> int:
        """
        Optional. The number of conversational query requests after which the context expires. The default is `0`. If set to `0`, the context expires immediately. Contexts expire automatically after 20 minutes if there are no matching queries.
        """
        return pulumi.get(self, "lifespan_count")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Required. The unique identifier of the context. Supported formats: - `projects//agent/sessions//contexts/`, - `projects//locations//agent/sessions//contexts/`, - `projects//agent/environments//users//sessions//contexts/`, - `projects//locations//agent/environments//users//sessions//contexts/`, The `Context ID` is always converted to lowercase, may only contain characters in a-zA-Z0-9_-% and may be at most 250 bytes long. If `Environment ID` is not specified, we assume default 'draft' environment. If `User ID` is not specified, we assume default '-' user. The following context names are reserved for internal use by Dialogflow. You should not use these contexts or create contexts with these names: * `__system_counters__` * `*_id_dialog_context` * `*_dialog_params_size`
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def parameters(self) -> Mapping[str, str]:
        """
        Optional. The collection of parameters associated with this context. Depending on your protocol or client library language, this is a map, associative array, symbol table, dictionary, or JSON object composed of a collection of (MapKey, MapValue) pairs: - MapKey type: string - MapKey value: parameter name - MapValue type: - If parameter's entity type is a composite entity: map - Else: depending on parameter value type, could be one of string, number, boolean, null, list or map - MapValue value: - If parameter's entity type is a composite entity: map from composite entity property names to property values - Else: parameter value
        """
        return pulumi.get(self, "parameters")


@pulumi.output_type
class GoogleCloudDialogflowV2beta1ConversationPhoneNumberResponse(dict):
    """
    Represents a phone number for telephony integration. It allows for connecting a particular conversation over telephony.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "phoneNumber":
            suggest = "phone_number"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDialogflowV2beta1ConversationPhoneNumberResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDialogflowV2beta1ConversationPhoneNumberResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDialogflowV2beta1ConversationPhoneNumberResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 phone_number: str):
        """
        Represents a phone number for telephony integration. It allows for connecting a particular conversation over telephony.
        :param str phone_number: The phone number to connect to this conversation.
        """
        pulumi.set(__self__, "phone_number", phone_number)

    @property
    @pulumi.getter(name="phoneNumber")
    def phone_number(self) -> str:
        """
        The phone number to connect to this conversation.
        """
        return pulumi.get(self, "phone_number")


@pulumi.output_type
class GoogleCloudDialogflowV2beta1DocumentReloadStatusResponse(dict):
    """
    The status of a reload attempt.
    """
    def __init__(__self__, *,
                 status: 'outputs.GoogleRpcStatusResponse',
                 time: str):
        """
        The status of a reload attempt.
        :param 'GoogleRpcStatusResponse' status: The status of a reload attempt or the initial load.
        :param str time: The time of a reload attempt. This reload may have been triggered automatically or manually and may not have succeeded.
        """
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "time", time)

    @property
    @pulumi.getter
    def status(self) -> 'outputs.GoogleRpcStatusResponse':
        """
        The status of a reload attempt or the initial load.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def time(self) -> str:
        """
        The time of a reload attempt. This reload may have been triggered automatically or manually and may not have succeeded.
        """
        return pulumi.get(self, "time")


@pulumi.output_type
class GoogleCloudDialogflowV2beta1EntityTypeEntityResponse(dict):
    """
    An **entity entry** for an associated entity type.
    """
    def __init__(__self__, *,
                 synonyms: Sequence[str],
                 value: str):
        """
        An **entity entry** for an associated entity type.
        :param Sequence[str] synonyms: Required. A collection of value synonyms. For example, if the entity type is *vegetable*, and `value` is *scallions*, a synonym could be *green onions*. For `KIND_LIST` entity types: * This collection must contain exactly one synonym equal to `value`.
        :param str value: Required. The primary value associated with this entity entry. For example, if the entity type is *vegetable*, the value could be *scallions*. For `KIND_MAP` entity types: * A reference value to be used in place of synonyms. For `KIND_LIST` entity types: * A string that can contain references to other entity types (with or without aliases).
        """
        pulumi.set(__self__, "synonyms", synonyms)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def synonyms(self) -> Sequence[str]:
        """
        Required. A collection of value synonyms. For example, if the entity type is *vegetable*, and `value` is *scallions*, a synonym could be *green onions*. For `KIND_LIST` entity types: * This collection must contain exactly one synonym equal to `value`.
        """
        return pulumi.get(self, "synonyms")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        Required. The primary value associated with this entity entry. For example, if the entity type is *vegetable*, the value could be *scallions*. For `KIND_MAP` entity types: * A reference value to be used in place of synonyms. For `KIND_LIST` entity types: * A string that can contain references to other entity types (with or without aliases).
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GoogleCloudDialogflowV2beta1FulfillmentFeatureResponse(dict):
    """
    Whether fulfillment is enabled for the specific feature.
    """
    def __init__(__self__, *,
                 type: str):
        """
        Whether fulfillment is enabled for the specific feature.
        :param str type: The type of the feature that enabled for fulfillment.
        """
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the feature that enabled for fulfillment.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GoogleCloudDialogflowV2beta1FulfillmentGenericWebServiceResponse(dict):
    """
    Represents configuration for a generic web service. Dialogflow supports two mechanisms for authentications: - Basic authentication with username and password. - Authentication with additional authentication headers. More information could be found at: https://cloud.google.com/dialogflow/docs/fulfillment-configure.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isCloudFunction":
            suggest = "is_cloud_function"
        elif key == "requestHeaders":
            suggest = "request_headers"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDialogflowV2beta1FulfillmentGenericWebServiceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDialogflowV2beta1FulfillmentGenericWebServiceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDialogflowV2beta1FulfillmentGenericWebServiceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 is_cloud_function: bool,
                 password: str,
                 request_headers: Mapping[str, str],
                 uri: str,
                 username: str):
        """
        Represents configuration for a generic web service. Dialogflow supports two mechanisms for authentications: - Basic authentication with username and password. - Authentication with additional authentication headers. More information could be found at: https://cloud.google.com/dialogflow/docs/fulfillment-configure.
        :param bool is_cloud_function: Optional. Indicates if generic web service is created through Cloud Functions integration. Defaults to false. is_cloud_function is deprecated. Cloud functions can be configured by its uri as a regular web service now.
        :param str password: The password for HTTP Basic authentication.
        :param Mapping[str, str] request_headers: The HTTP request headers to send together with fulfillment requests.
        :param str uri: Required. The fulfillment URI for receiving POST requests. It must use https protocol.
        :param str username: The user name for HTTP Basic authentication.
        """
        pulumi.set(__self__, "is_cloud_function", is_cloud_function)
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "request_headers", request_headers)
        pulumi.set(__self__, "uri", uri)
        pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="isCloudFunction")
    def is_cloud_function(self) -> bool:
        """
        Optional. Indicates if generic web service is created through Cloud Functions integration. Defaults to false. is_cloud_function is deprecated. Cloud functions can be configured by its uri as a regular web service now.
        """
        return pulumi.get(self, "is_cloud_function")

    @property
    @pulumi.getter
    def password(self) -> str:
        """
        The password for HTTP Basic authentication.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="requestHeaders")
    def request_headers(self) -> Mapping[str, str]:
        """
        The HTTP request headers to send together with fulfillment requests.
        """
        return pulumi.get(self, "request_headers")

    @property
    @pulumi.getter
    def uri(self) -> str:
        """
        Required. The fulfillment URI for receiving POST requests. It must use https protocol.
        """
        return pulumi.get(self, "uri")

    @property
    @pulumi.getter
    def username(self) -> str:
        """
        The user name for HTTP Basic authentication.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class GoogleCloudDialogflowV2beta1FulfillmentResponse(dict):
    """
    By default, your agent responds to a matched intent with a static response. As an alternative, you can provide a more dynamic response by using fulfillment. When you enable fulfillment for an intent, Dialogflow responds to that intent by calling a service that you define. For example, if an end-user wants to schedule a haircut on Friday, your service can check your database and respond to the end-user with availability information for Friday. For more information, see the [fulfillment guide](https://cloud.google.com/dialogflow/docs/fulfillment-overview).
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "displayName":
            suggest = "display_name"
        elif key == "genericWebService":
            suggest = "generic_web_service"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDialogflowV2beta1FulfillmentResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDialogflowV2beta1FulfillmentResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDialogflowV2beta1FulfillmentResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 display_name: str,
                 enabled: bool,
                 features: Sequence['outputs.GoogleCloudDialogflowV2beta1FulfillmentFeatureResponse'],
                 generic_web_service: 'outputs.GoogleCloudDialogflowV2beta1FulfillmentGenericWebServiceResponse',
                 name: str):
        """
        By default, your agent responds to a matched intent with a static response. As an alternative, you can provide a more dynamic response by using fulfillment. When you enable fulfillment for an intent, Dialogflow responds to that intent by calling a service that you define. For example, if an end-user wants to schedule a haircut on Friday, your service can check your database and respond to the end-user with availability information for Friday. For more information, see the [fulfillment guide](https://cloud.google.com/dialogflow/docs/fulfillment-overview).
        :param str display_name: The human-readable name of the fulfillment, unique within the agent. This field is not used for Fulfillment in an Environment.
        :param bool enabled: Whether fulfillment is enabled.
        :param Sequence['GoogleCloudDialogflowV2beta1FulfillmentFeatureResponse'] features: The field defines whether the fulfillment is enabled for certain features.
        :param 'GoogleCloudDialogflowV2beta1FulfillmentGenericWebServiceResponse' generic_web_service: Configuration for a generic web service.
        :param str name: Required. The unique identifier of the fulfillment. Supported formats: - `projects//agent/fulfillment` - `projects//locations//agent/fulfillment` This field is not used for Fulfillment in an Environment.
        """
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "features", features)
        pulumi.set(__self__, "generic_web_service", generic_web_service)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        The human-readable name of the fulfillment, unique within the agent. This field is not used for Fulfillment in an Environment.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        Whether fulfillment is enabled.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def features(self) -> Sequence['outputs.GoogleCloudDialogflowV2beta1FulfillmentFeatureResponse']:
        """
        The field defines whether the fulfillment is enabled for certain features.
        """
        return pulumi.get(self, "features")

    @property
    @pulumi.getter(name="genericWebService")
    def generic_web_service(self) -> 'outputs.GoogleCloudDialogflowV2beta1FulfillmentGenericWebServiceResponse':
        """
        Configuration for a generic web service.
        """
        return pulumi.get(self, "generic_web_service")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Required. The unique identifier of the fulfillment. Supported formats: - `projects//agent/fulfillment` - `projects//locations//agent/fulfillment` This field is not used for Fulfillment in an Environment.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigConversationModelConfigResponse(dict):
    """
    Custom conversation models used in agent assist feature. Supported feature: ARTICLE_SUGGESTION, SMART_COMPOSE, SMART_REPLY.
    """
    def __init__(__self__, *,
                 model: str):
        """
        Custom conversation models used in agent assist feature. Supported feature: ARTICLE_SUGGESTION, SMART_COMPOSE, SMART_REPLY.
        :param str model: Required. Conversation model resource name. Format: `projects//conversationModels/`.
        """
        pulumi.set(__self__, "model", model)

    @property
    @pulumi.getter
    def model(self) -> str:
        """
        Required. Conversation model resource name. Format: `projects//conversationModels/`.
        """
        return pulumi.get(self, "model")


@pulumi.output_type
class GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigMessageAnalysisConfigResponse(dict):
    """
    Configuration for analyses to run on each conversation message.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enableEntityExtraction":
            suggest = "enable_entity_extraction"
        elif key == "enableSentimentAnalysis":
            suggest = "enable_sentiment_analysis"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigMessageAnalysisConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigMessageAnalysisConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigMessageAnalysisConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enable_entity_extraction: bool,
                 enable_sentiment_analysis: bool):
        """
        Configuration for analyses to run on each conversation message.
        :param bool enable_entity_extraction: Enable entity extraction in conversation messages on [agent assist stage](https://cloud.google.com/dialogflow/priv/docs/contact-center/basics#stages). If unspecified, defaults to false. Currently, this feature is not general available, please contact Google to get access.
        :param bool enable_sentiment_analysis: Enable sentiment analysis in conversation messages on [agent assist stage](https://cloud.google.com/dialogflow/priv/docs/contact-center/basics#stages). If unspecified, defaults to false. Sentiment analysis inspects user input and identifies the prevailing subjective opinion, especially to determine a user's attitude as positive, negative, or neutral: https://cloud.google.com/natural-language/docs/basics#sentiment_analysis For Participants.StreamingAnalyzeContent method, result will be in StreamingAnalyzeContentResponse.message.SentimentAnalysisResult. For Participants.AnalyzeContent method, result will be in AnalyzeContentResponse.message.SentimentAnalysisResult For Conversations.ListMessages method, result will be in ListMessagesResponse.messages.SentimentAnalysisResult If Pub/Sub notification is configured, result will be in ConversationEvent.new_message_payload.SentimentAnalysisResult.
        """
        pulumi.set(__self__, "enable_entity_extraction", enable_entity_extraction)
        pulumi.set(__self__, "enable_sentiment_analysis", enable_sentiment_analysis)

    @property
    @pulumi.getter(name="enableEntityExtraction")
    def enable_entity_extraction(self) -> bool:
        """
        Enable entity extraction in conversation messages on [agent assist stage](https://cloud.google.com/dialogflow/priv/docs/contact-center/basics#stages). If unspecified, defaults to false. Currently, this feature is not general available, please contact Google to get access.
        """
        return pulumi.get(self, "enable_entity_extraction")

    @property
    @pulumi.getter(name="enableSentimentAnalysis")
    def enable_sentiment_analysis(self) -> bool:
        """
        Enable sentiment analysis in conversation messages on [agent assist stage](https://cloud.google.com/dialogflow/priv/docs/contact-center/basics#stages). If unspecified, defaults to false. Sentiment analysis inspects user input and identifies the prevailing subjective opinion, especially to determine a user's attitude as positive, negative, or neutral: https://cloud.google.com/natural-language/docs/basics#sentiment_analysis For Participants.StreamingAnalyzeContent method, result will be in StreamingAnalyzeContentResponse.message.SentimentAnalysisResult. For Participants.AnalyzeContent method, result will be in AnalyzeContentResponse.message.SentimentAnalysisResult For Conversations.ListMessages method, result will be in ListMessagesResponse.messages.SentimentAnalysisResult If Pub/Sub notification is configured, result will be in ConversationEvent.new_message_payload.SentimentAnalysisResult.
        """
        return pulumi.get(self, "enable_sentiment_analysis")


@pulumi.output_type
class GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigResponse(dict):
    """
    Defines the Human Agent Assistant to connect to a conversation.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endUserSuggestionConfig":
            suggest = "end_user_suggestion_config"
        elif key == "humanAgentSuggestionConfig":
            suggest = "human_agent_suggestion_config"
        elif key == "messageAnalysisConfig":
            suggest = "message_analysis_config"
        elif key == "notificationConfig":
            suggest = "notification_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 end_user_suggestion_config: 'outputs.GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionConfigResponse',
                 human_agent_suggestion_config: 'outputs.GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionConfigResponse',
                 message_analysis_config: 'outputs.GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigMessageAnalysisConfigResponse',
                 notification_config: 'outputs.GoogleCloudDialogflowV2beta1NotificationConfigResponse'):
        """
        Defines the Human Agent Assistant to connect to a conversation.
        :param 'GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionConfigResponse' end_user_suggestion_config: Configuration for agent assistance of end user participant. Currently, this feature is not general available, please contact Google to get access.
        :param 'GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionConfigResponse' human_agent_suggestion_config: Configuration for agent assistance of human agent participant.
        :param 'GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigMessageAnalysisConfigResponse' message_analysis_config: Configuration for message analysis.
        :param 'GoogleCloudDialogflowV2beta1NotificationConfigResponse' notification_config: Pub/Sub topic on which to publish new agent assistant events.
        """
        pulumi.set(__self__, "end_user_suggestion_config", end_user_suggestion_config)
        pulumi.set(__self__, "human_agent_suggestion_config", human_agent_suggestion_config)
        pulumi.set(__self__, "message_analysis_config", message_analysis_config)
        pulumi.set(__self__, "notification_config", notification_config)

    @property
    @pulumi.getter(name="endUserSuggestionConfig")
    def end_user_suggestion_config(self) -> 'outputs.GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionConfigResponse':
        """
        Configuration for agent assistance of end user participant. Currently, this feature is not general available, please contact Google to get access.
        """
        return pulumi.get(self, "end_user_suggestion_config")

    @property
    @pulumi.getter(name="humanAgentSuggestionConfig")
    def human_agent_suggestion_config(self) -> 'outputs.GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionConfigResponse':
        """
        Configuration for agent assistance of human agent participant.
        """
        return pulumi.get(self, "human_agent_suggestion_config")

    @property
    @pulumi.getter(name="messageAnalysisConfig")
    def message_analysis_config(self) -> 'outputs.GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigMessageAnalysisConfigResponse':
        """
        Configuration for message analysis.
        """
        return pulumi.get(self, "message_analysis_config")

    @property
    @pulumi.getter(name="notificationConfig")
    def notification_config(self) -> 'outputs.GoogleCloudDialogflowV2beta1NotificationConfigResponse':
        """
        Pub/Sub topic on which to publish new agent assistant events.
        """
        return pulumi.get(self, "notification_config")


@pulumi.output_type
class GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionConfigResponse(dict):
    """
    Detail human agent assistant config.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "featureConfigs":
            suggest = "feature_configs"
        elif key == "groupSuggestionResponses":
            suggest = "group_suggestion_responses"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 feature_configs: Sequence['outputs.GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionFeatureConfigResponse'],
                 group_suggestion_responses: bool):
        """
        Detail human agent assistant config.
        :param Sequence['GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionFeatureConfigResponse'] feature_configs: Configuration of different suggestion features. One feature can have only one config.
        :param bool group_suggestion_responses: If `group_suggestion_responses` is false, and there are multiple `feature_configs` in `event based suggestion` or StreamingAnalyzeContent, we will try to deliver suggestions to customers as soon as we get new suggestion. Different type of suggestions based on the same context will be in separate Pub/Sub event or `StreamingAnalyzeContentResponse`. If `group_suggestion_responses` set to true. All the suggestions to the same participant based on the same context will be grouped into a single Pub/Sub event or StreamingAnalyzeContentResponse.
        """
        pulumi.set(__self__, "feature_configs", feature_configs)
        pulumi.set(__self__, "group_suggestion_responses", group_suggestion_responses)

    @property
    @pulumi.getter(name="featureConfigs")
    def feature_configs(self) -> Sequence['outputs.GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionFeatureConfigResponse']:
        """
        Configuration of different suggestion features. One feature can have only one config.
        """
        return pulumi.get(self, "feature_configs")

    @property
    @pulumi.getter(name="groupSuggestionResponses")
    def group_suggestion_responses(self) -> bool:
        """
        If `group_suggestion_responses` is false, and there are multiple `feature_configs` in `event based suggestion` or StreamingAnalyzeContent, we will try to deliver suggestions to customers as soon as we get new suggestion. Different type of suggestions based on the same context will be in separate Pub/Sub event or `StreamingAnalyzeContentResponse`. If `group_suggestion_responses` set to true. All the suggestions to the same participant based on the same context will be grouped into a single Pub/Sub event or StreamingAnalyzeContentResponse.
        """
        return pulumi.get(self, "group_suggestion_responses")


@pulumi.output_type
class GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionFeatureConfigResponse(dict):
    """
    Config for suggestion features.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "conversationModelConfig":
            suggest = "conversation_model_config"
        elif key == "enableEventBasedSuggestion":
            suggest = "enable_event_based_suggestion"
        elif key == "queryConfig":
            suggest = "query_config"
        elif key == "suggestionFeature":
            suggest = "suggestion_feature"
        elif key == "suggestionTriggerSettings":
            suggest = "suggestion_trigger_settings"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionFeatureConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionFeatureConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionFeatureConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 conversation_model_config: 'outputs.GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigConversationModelConfigResponse',
                 enable_event_based_suggestion: bool,
                 query_config: 'outputs.GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionQueryConfigResponse',
                 suggestion_feature: 'outputs.GoogleCloudDialogflowV2beta1SuggestionFeatureResponse',
                 suggestion_trigger_settings: 'outputs.GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionTriggerSettingsResponse'):
        """
        Config for suggestion features.
        :param 'GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigConversationModelConfigResponse' conversation_model_config: Configs of custom conversation model.
        :param bool enable_event_based_suggestion: Automatically iterates all participants and tries to compile suggestions. Supported features: ARTICLE_SUGGESTION, FAQ, DIALOGFLOW_ASSIST.
        :param 'GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionQueryConfigResponse' query_config: Configs of query.
        :param 'GoogleCloudDialogflowV2beta1SuggestionFeatureResponse' suggestion_feature: The suggestion feature.
        :param 'GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionTriggerSettingsResponse' suggestion_trigger_settings: Settings of suggestion trigger. Currently, only ARTICLE_SUGGESTION, FAQ, and DIALOGFLOW_ASSIST will use this field.
        """
        pulumi.set(__self__, "conversation_model_config", conversation_model_config)
        pulumi.set(__self__, "enable_event_based_suggestion", enable_event_based_suggestion)
        pulumi.set(__self__, "query_config", query_config)
        pulumi.set(__self__, "suggestion_feature", suggestion_feature)
        pulumi.set(__self__, "suggestion_trigger_settings", suggestion_trigger_settings)

    @property
    @pulumi.getter(name="conversationModelConfig")
    def conversation_model_config(self) -> 'outputs.GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigConversationModelConfigResponse':
        """
        Configs of custom conversation model.
        """
        return pulumi.get(self, "conversation_model_config")

    @property
    @pulumi.getter(name="enableEventBasedSuggestion")
    def enable_event_based_suggestion(self) -> bool:
        """
        Automatically iterates all participants and tries to compile suggestions. Supported features: ARTICLE_SUGGESTION, FAQ, DIALOGFLOW_ASSIST.
        """
        return pulumi.get(self, "enable_event_based_suggestion")

    @property
    @pulumi.getter(name="queryConfig")
    def query_config(self) -> 'outputs.GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionQueryConfigResponse':
        """
        Configs of query.
        """
        return pulumi.get(self, "query_config")

    @property
    @pulumi.getter(name="suggestionFeature")
    def suggestion_feature(self) -> 'outputs.GoogleCloudDialogflowV2beta1SuggestionFeatureResponse':
        """
        The suggestion feature.
        """
        return pulumi.get(self, "suggestion_feature")

    @property
    @pulumi.getter(name="suggestionTriggerSettings")
    def suggestion_trigger_settings(self) -> 'outputs.GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionTriggerSettingsResponse':
        """
        Settings of suggestion trigger. Currently, only ARTICLE_SUGGESTION, FAQ, and DIALOGFLOW_ASSIST will use this field.
        """
        return pulumi.get(self, "suggestion_trigger_settings")


@pulumi.output_type
class GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionQueryConfigContextFilterSettingsResponse(dict):
    """
    Settings that determine how to filter recent conversation context when generating suggestions.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dropHandoffMessages":
            suggest = "drop_handoff_messages"
        elif key == "dropIvrMessages":
            suggest = "drop_ivr_messages"
        elif key == "dropVirtualAgentMessages":
            suggest = "drop_virtual_agent_messages"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionQueryConfigContextFilterSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionQueryConfigContextFilterSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionQueryConfigContextFilterSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 drop_handoff_messages: bool,
                 drop_ivr_messages: bool,
                 drop_virtual_agent_messages: bool):
        """
        Settings that determine how to filter recent conversation context when generating suggestions.
        :param bool drop_handoff_messages: If set to true, the last message from virtual agent (hand off message) and the message before it (trigger message of hand off) are dropped.
        :param bool drop_ivr_messages: If set to true, all messages from ivr stage are dropped.
        :param bool drop_virtual_agent_messages: If set to true, all messages from virtual agent are dropped.
        """
        pulumi.set(__self__, "drop_handoff_messages", drop_handoff_messages)
        pulumi.set(__self__, "drop_ivr_messages", drop_ivr_messages)
        pulumi.set(__self__, "drop_virtual_agent_messages", drop_virtual_agent_messages)

    @property
    @pulumi.getter(name="dropHandoffMessages")
    def drop_handoff_messages(self) -> bool:
        """
        If set to true, the last message from virtual agent (hand off message) and the message before it (trigger message of hand off) are dropped.
        """
        return pulumi.get(self, "drop_handoff_messages")

    @property
    @pulumi.getter(name="dropIvrMessages")
    def drop_ivr_messages(self) -> bool:
        """
        If set to true, all messages from ivr stage are dropped.
        """
        return pulumi.get(self, "drop_ivr_messages")

    @property
    @pulumi.getter(name="dropVirtualAgentMessages")
    def drop_virtual_agent_messages(self) -> bool:
        """
        If set to true, all messages from virtual agent are dropped.
        """
        return pulumi.get(self, "drop_virtual_agent_messages")


@pulumi.output_type
class GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionQueryConfigDialogflowQuerySourceResponse(dict):
    """
    Dialogflow source setting. Supported feature: DIALOGFLOW_ASSIST.
    """
    def __init__(__self__, *,
                 agent: str):
        """
        Dialogflow source setting. Supported feature: DIALOGFLOW_ASSIST.
        :param str agent: Required. The name of a dialogflow virtual agent used for end user side intent detection and suggestion. Format: `projects//locations//agent`. When multiple agents are allowed in the same Dialogflow project.
        """
        pulumi.set(__self__, "agent", agent)

    @property
    @pulumi.getter
    def agent(self) -> str:
        """
        Required. The name of a dialogflow virtual agent used for end user side intent detection and suggestion. Format: `projects//locations//agent`. When multiple agents are allowed in the same Dialogflow project.
        """
        return pulumi.get(self, "agent")


@pulumi.output_type
class GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionQueryConfigDocumentQuerySourceResponse(dict):
    """
    Document source settings. Supported features: SMART_REPLY, SMART_COMPOSE.
    """
    def __init__(__self__, *,
                 documents: Sequence[str]):
        """
        Document source settings. Supported features: SMART_REPLY, SMART_COMPOSE.
        :param Sequence[str] documents: Required. Knowledge documents to query from. Format: `projects//locations//knowledgeBases//documents/`. Currently, only one document is supported.
        """
        pulumi.set(__self__, "documents", documents)

    @property
    @pulumi.getter
    def documents(self) -> Sequence[str]:
        """
        Required. Knowledge documents to query from. Format: `projects//locations//knowledgeBases//documents/`. Currently, only one document is supported.
        """
        return pulumi.get(self, "documents")


@pulumi.output_type
class GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionQueryConfigKnowledgeBaseQuerySourceResponse(dict):
    """
    Knowledge base source settings. Supported features: ARTICLE_SUGGESTION, FAQ.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "knowledgeBases":
            suggest = "knowledge_bases"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionQueryConfigKnowledgeBaseQuerySourceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionQueryConfigKnowledgeBaseQuerySourceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionQueryConfigKnowledgeBaseQuerySourceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 knowledge_bases: Sequence[str]):
        """
        Knowledge base source settings. Supported features: ARTICLE_SUGGESTION, FAQ.
        :param Sequence[str] knowledge_bases: Required. Knowledge bases to query. Format: `projects//locations//knowledgeBases/`. Currently, only one knowledge base is supported.
        """
        pulumi.set(__self__, "knowledge_bases", knowledge_bases)

    @property
    @pulumi.getter(name="knowledgeBases")
    def knowledge_bases(self) -> Sequence[str]:
        """
        Required. Knowledge bases to query. Format: `projects//locations//knowledgeBases/`. Currently, only one knowledge base is supported.
        """
        return pulumi.get(self, "knowledge_bases")


@pulumi.output_type
class GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionQueryConfigResponse(dict):
    """
    Config for suggestion query.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "confidenceThreshold":
            suggest = "confidence_threshold"
        elif key == "contextFilterSettings":
            suggest = "context_filter_settings"
        elif key == "dialogflowQuerySource":
            suggest = "dialogflow_query_source"
        elif key == "documentQuerySource":
            suggest = "document_query_source"
        elif key == "knowledgeBaseQuerySource":
            suggest = "knowledge_base_query_source"
        elif key == "maxResults":
            suggest = "max_results"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionQueryConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionQueryConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionQueryConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 confidence_threshold: float,
                 context_filter_settings: 'outputs.GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionQueryConfigContextFilterSettingsResponse',
                 dialogflow_query_source: 'outputs.GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionQueryConfigDialogflowQuerySourceResponse',
                 document_query_source: 'outputs.GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionQueryConfigDocumentQuerySourceResponse',
                 knowledge_base_query_source: 'outputs.GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionQueryConfigKnowledgeBaseQuerySourceResponse',
                 max_results: int):
        """
        Config for suggestion query.
        :param float confidence_threshold: Confidence threshold of query result. Agent Assist gives each suggestion a score in the range [0.0, 1.0], based on the relevance between the suggestion and the current conversation context. A score of 0.0 has no relevance, while a score of 1.0 has high relevance. Only suggestions with a score greater than or equal to the value of this field are included in the results. For a baseline model (the default), the recommended value is in the range [0.05, 0.1]. For a custom model, there is no recommended value. Tune this value by starting from a very low value and slowly increasing until you have desired results. If this field is not set, it is default to 0.0, which means that all suggestions are returned. Supported features: ARTICLE_SUGGESTION, FAQ, SMART_REPLY, SMART_COMPOSE.
        :param 'GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionQueryConfigContextFilterSettingsResponse' context_filter_settings: Determines how recent conversation context is filtered when generating suggestions. If unspecified, no messages will be dropped.
        :param 'GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionQueryConfigDialogflowQuerySourceResponse' dialogflow_query_source: Query from Dialogflow agent. It is used by DIALOGFLOW_ASSIST.
        :param 'GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionQueryConfigDocumentQuerySourceResponse' document_query_source: Query from knowledge base document. It is used by: SMART_REPLY, SMART_COMPOSE.
        :param 'GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionQueryConfigKnowledgeBaseQuerySourceResponse' knowledge_base_query_source: Query from knowledgebase. It is used by: ARTICLE_SUGGESTION, FAQ.
        :param int max_results: Maximum number of results to return. Currently, if unset, defaults to 10. And the max number is 20.
        """
        pulumi.set(__self__, "confidence_threshold", confidence_threshold)
        pulumi.set(__self__, "context_filter_settings", context_filter_settings)
        pulumi.set(__self__, "dialogflow_query_source", dialogflow_query_source)
        pulumi.set(__self__, "document_query_source", document_query_source)
        pulumi.set(__self__, "knowledge_base_query_source", knowledge_base_query_source)
        pulumi.set(__self__, "max_results", max_results)

    @property
    @pulumi.getter(name="confidenceThreshold")
    def confidence_threshold(self) -> float:
        """
        Confidence threshold of query result. Agent Assist gives each suggestion a score in the range [0.0, 1.0], based on the relevance between the suggestion and the current conversation context. A score of 0.0 has no relevance, while a score of 1.0 has high relevance. Only suggestions with a score greater than or equal to the value of this field are included in the results. For a baseline model (the default), the recommended value is in the range [0.05, 0.1]. For a custom model, there is no recommended value. Tune this value by starting from a very low value and slowly increasing until you have desired results. If this field is not set, it is default to 0.0, which means that all suggestions are returned. Supported features: ARTICLE_SUGGESTION, FAQ, SMART_REPLY, SMART_COMPOSE.
        """
        return pulumi.get(self, "confidence_threshold")

    @property
    @pulumi.getter(name="contextFilterSettings")
    def context_filter_settings(self) -> 'outputs.GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionQueryConfigContextFilterSettingsResponse':
        """
        Determines how recent conversation context is filtered when generating suggestions. If unspecified, no messages will be dropped.
        """
        return pulumi.get(self, "context_filter_settings")

    @property
    @pulumi.getter(name="dialogflowQuerySource")
    def dialogflow_query_source(self) -> 'outputs.GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionQueryConfigDialogflowQuerySourceResponse':
        """
        Query from Dialogflow agent. It is used by DIALOGFLOW_ASSIST.
        """
        return pulumi.get(self, "dialogflow_query_source")

    @property
    @pulumi.getter(name="documentQuerySource")
    def document_query_source(self) -> 'outputs.GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionQueryConfigDocumentQuerySourceResponse':
        """
        Query from knowledge base document. It is used by: SMART_REPLY, SMART_COMPOSE.
        """
        return pulumi.get(self, "document_query_source")

    @property
    @pulumi.getter(name="knowledgeBaseQuerySource")
    def knowledge_base_query_source(self) -> 'outputs.GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionQueryConfigKnowledgeBaseQuerySourceResponse':
        """
        Query from knowledgebase. It is used by: ARTICLE_SUGGESTION, FAQ.
        """
        return pulumi.get(self, "knowledge_base_query_source")

    @property
    @pulumi.getter(name="maxResults")
    def max_results(self) -> int:
        """
        Maximum number of results to return. Currently, if unset, defaults to 10. And the max number is 20.
        """
        return pulumi.get(self, "max_results")


@pulumi.output_type
class GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionTriggerSettingsResponse(dict):
    """
    Settings of suggestion trigger.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "noSmallTalk":
            suggest = "no_small_talk"
        elif key == "onlyEndUser":
            suggest = "only_end_user"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionTriggerSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionTriggerSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionTriggerSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 no_small_talk: bool,
                 only_end_user: bool):
        """
        Settings of suggestion trigger.
        :param bool no_small_talk: Do not trigger if last utterance is small talk.
        :param bool only_end_user: Only trigger suggestion if participant role of last utterance is END_USER.
        """
        pulumi.set(__self__, "no_small_talk", no_small_talk)
        pulumi.set(__self__, "only_end_user", only_end_user)

    @property
    @pulumi.getter(name="noSmallTalk")
    def no_small_talk(self) -> bool:
        """
        Do not trigger if last utterance is small talk.
        """
        return pulumi.get(self, "no_small_talk")

    @property
    @pulumi.getter(name="onlyEndUser")
    def only_end_user(self) -> bool:
        """
        Only trigger suggestion if participant role of last utterance is END_USER.
        """
        return pulumi.get(self, "only_end_user")


@pulumi.output_type
class GoogleCloudDialogflowV2beta1HumanAgentHandoffConfigLivePersonConfigResponse(dict):
    """
    Configuration specific to LivePerson (https://www.liveperson.com).
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accountNumber":
            suggest = "account_number"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDialogflowV2beta1HumanAgentHandoffConfigLivePersonConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDialogflowV2beta1HumanAgentHandoffConfigLivePersonConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDialogflowV2beta1HumanAgentHandoffConfigLivePersonConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 account_number: str):
        """
        Configuration specific to LivePerson (https://www.liveperson.com).
        :param str account_number: Required. Account number of the LivePerson account to connect. This is the account number you input at the login page.
        """
        pulumi.set(__self__, "account_number", account_number)

    @property
    @pulumi.getter(name="accountNumber")
    def account_number(self) -> str:
        """
        Required. Account number of the LivePerson account to connect. This is the account number you input at the login page.
        """
        return pulumi.get(self, "account_number")


@pulumi.output_type
class GoogleCloudDialogflowV2beta1HumanAgentHandoffConfigResponse(dict):
    """
    Defines the hand off to a live agent, typically on which external agent service provider to connect to a conversation. Currently, this feature is not general available, please contact Google to get access.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "livePersonConfig":
            suggest = "live_person_config"
        elif key == "salesforceLiveAgentConfig":
            suggest = "salesforce_live_agent_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDialogflowV2beta1HumanAgentHandoffConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDialogflowV2beta1HumanAgentHandoffConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDialogflowV2beta1HumanAgentHandoffConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 live_person_config: 'outputs.GoogleCloudDialogflowV2beta1HumanAgentHandoffConfigLivePersonConfigResponse',
                 salesforce_live_agent_config: 'outputs.GoogleCloudDialogflowV2beta1HumanAgentHandoffConfigSalesforceLiveAgentConfigResponse'):
        """
        Defines the hand off to a live agent, typically on which external agent service provider to connect to a conversation. Currently, this feature is not general available, please contact Google to get access.
        :param 'GoogleCloudDialogflowV2beta1HumanAgentHandoffConfigLivePersonConfigResponse' live_person_config: Uses LivePerson (https://www.liveperson.com).
        :param 'GoogleCloudDialogflowV2beta1HumanAgentHandoffConfigSalesforceLiveAgentConfigResponse' salesforce_live_agent_config: Uses Salesforce Live Agent.
        """
        pulumi.set(__self__, "live_person_config", live_person_config)
        pulumi.set(__self__, "salesforce_live_agent_config", salesforce_live_agent_config)

    @property
    @pulumi.getter(name="livePersonConfig")
    def live_person_config(self) -> 'outputs.GoogleCloudDialogflowV2beta1HumanAgentHandoffConfigLivePersonConfigResponse':
        """
        Uses LivePerson (https://www.liveperson.com).
        """
        return pulumi.get(self, "live_person_config")

    @property
    @pulumi.getter(name="salesforceLiveAgentConfig")
    def salesforce_live_agent_config(self) -> 'outputs.GoogleCloudDialogflowV2beta1HumanAgentHandoffConfigSalesforceLiveAgentConfigResponse':
        """
        Uses Salesforce Live Agent.
        """
        return pulumi.get(self, "salesforce_live_agent_config")


@pulumi.output_type
class GoogleCloudDialogflowV2beta1HumanAgentHandoffConfigSalesforceLiveAgentConfigResponse(dict):
    """
    Configuration specific to Salesforce Live Agent.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "buttonId":
            suggest = "button_id"
        elif key == "deploymentId":
            suggest = "deployment_id"
        elif key == "endpointDomain":
            suggest = "endpoint_domain"
        elif key == "organizationId":
            suggest = "organization_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDialogflowV2beta1HumanAgentHandoffConfigSalesforceLiveAgentConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDialogflowV2beta1HumanAgentHandoffConfigSalesforceLiveAgentConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDialogflowV2beta1HumanAgentHandoffConfigSalesforceLiveAgentConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 button_id: str,
                 deployment_id: str,
                 endpoint_domain: str,
                 organization_id: str):
        """
        Configuration specific to Salesforce Live Agent.
        :param str button_id: Required. Live Agent chat button ID.
        :param str deployment_id: Required. Live Agent deployment ID.
        :param str endpoint_domain: Required. Domain of the Live Agent endpoint for this agent. You can find the endpoint URL in the `Live Agent settings` page. For example if URL has the form https://d.la4-c2-phx.salesforceliveagent.com/..., you should fill in d.la4-c2-phx.salesforceliveagent.com.
        :param str organization_id: Required. The organization ID of the Salesforce account.
        """
        pulumi.set(__self__, "button_id", button_id)
        pulumi.set(__self__, "deployment_id", deployment_id)
        pulumi.set(__self__, "endpoint_domain", endpoint_domain)
        pulumi.set(__self__, "organization_id", organization_id)

    @property
    @pulumi.getter(name="buttonId")
    def button_id(self) -> str:
        """
        Required. Live Agent chat button ID.
        """
        return pulumi.get(self, "button_id")

    @property
    @pulumi.getter(name="deploymentId")
    def deployment_id(self) -> str:
        """
        Required. Live Agent deployment ID.
        """
        return pulumi.get(self, "deployment_id")

    @property
    @pulumi.getter(name="endpointDomain")
    def endpoint_domain(self) -> str:
        """
        Required. Domain of the Live Agent endpoint for this agent. You can find the endpoint URL in the `Live Agent settings` page. For example if URL has the form https://d.la4-c2-phx.salesforceliveagent.com/..., you should fill in d.la4-c2-phx.salesforceliveagent.com.
        """
        return pulumi.get(self, "endpoint_domain")

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> str:
        """
        Required. The organization ID of the Salesforce account.
        """
        return pulumi.get(self, "organization_id")


@pulumi.output_type
class GoogleCloudDialogflowV2beta1IntentFollowupIntentInfoResponse(dict):
    """
    Represents a single followup intent in the chain.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "followupIntentName":
            suggest = "followup_intent_name"
        elif key == "parentFollowupIntentName":
            suggest = "parent_followup_intent_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDialogflowV2beta1IntentFollowupIntentInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDialogflowV2beta1IntentFollowupIntentInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDialogflowV2beta1IntentFollowupIntentInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 followup_intent_name: str,
                 parent_followup_intent_name: str):
        """
        Represents a single followup intent in the chain.
        :param str followup_intent_name: The unique identifier of the followup intent. Format: `projects//agent/intents/`.
        :param str parent_followup_intent_name: The unique identifier of the followup intent's parent. Format: `projects//agent/intents/`.
        """
        pulumi.set(__self__, "followup_intent_name", followup_intent_name)
        pulumi.set(__self__, "parent_followup_intent_name", parent_followup_intent_name)

    @property
    @pulumi.getter(name="followupIntentName")
    def followup_intent_name(self) -> str:
        """
        The unique identifier of the followup intent. Format: `projects//agent/intents/`.
        """
        return pulumi.get(self, "followup_intent_name")

    @property
    @pulumi.getter(name="parentFollowupIntentName")
    def parent_followup_intent_name(self) -> str:
        """
        The unique identifier of the followup intent's parent. Format: `projects//agent/intents/`.
        """
        return pulumi.get(self, "parent_followup_intent_name")


@pulumi.output_type
class GoogleCloudDialogflowV2beta1IntentMessageBasicCardButtonOpenUriActionResponse(dict):
    """
    Opens the given URI.
    """
    def __init__(__self__, *,
                 uri: str):
        """
        Opens the given URI.
        :param str uri: Required. The HTTP or HTTPS scheme URI.
        """
        pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter
    def uri(self) -> str:
        """
        Required. The HTTP or HTTPS scheme URI.
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class GoogleCloudDialogflowV2beta1IntentMessageBasicCardButtonResponse(dict):
    """
    The button object that appears at the bottom of a card.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "openUriAction":
            suggest = "open_uri_action"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDialogflowV2beta1IntentMessageBasicCardButtonResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDialogflowV2beta1IntentMessageBasicCardButtonResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDialogflowV2beta1IntentMessageBasicCardButtonResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 open_uri_action: 'outputs.GoogleCloudDialogflowV2beta1IntentMessageBasicCardButtonOpenUriActionResponse',
                 title: str):
        """
        The button object that appears at the bottom of a card.
        :param 'GoogleCloudDialogflowV2beta1IntentMessageBasicCardButtonOpenUriActionResponse' open_uri_action: Required. Action to take when a user taps on the button.
        :param str title: Required. The title of the button.
        """
        pulumi.set(__self__, "open_uri_action", open_uri_action)
        pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter(name="openUriAction")
    def open_uri_action(self) -> 'outputs.GoogleCloudDialogflowV2beta1IntentMessageBasicCardButtonOpenUriActionResponse':
        """
        Required. Action to take when a user taps on the button.
        """
        return pulumi.get(self, "open_uri_action")

    @property
    @pulumi.getter
    def title(self) -> str:
        """
        Required. The title of the button.
        """
        return pulumi.get(self, "title")


@pulumi.output_type
class GoogleCloudDialogflowV2beta1IntentMessageBasicCardResponse(dict):
    """
    The basic card message. Useful for displaying information.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "formattedText":
            suggest = "formatted_text"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDialogflowV2beta1IntentMessageBasicCardResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDialogflowV2beta1IntentMessageBasicCardResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDialogflowV2beta1IntentMessageBasicCardResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 buttons: Sequence['outputs.GoogleCloudDialogflowV2beta1IntentMessageBasicCardButtonResponse'],
                 formatted_text: str,
                 image: 'outputs.GoogleCloudDialogflowV2beta1IntentMessageImageResponse',
                 subtitle: str,
                 title: str):
        """
        The basic card message. Useful for displaying information.
        :param Sequence['GoogleCloudDialogflowV2beta1IntentMessageBasicCardButtonResponse'] buttons: Optional. The collection of card buttons.
        :param str formatted_text: Required, unless image is present. The body text of the card.
        :param 'GoogleCloudDialogflowV2beta1IntentMessageImageResponse' image: Optional. The image for the card.
        :param str subtitle: Optional. The subtitle of the card.
        :param str title: Optional. The title of the card.
        """
        pulumi.set(__self__, "buttons", buttons)
        pulumi.set(__self__, "formatted_text", formatted_text)
        pulumi.set(__self__, "image", image)
        pulumi.set(__self__, "subtitle", subtitle)
        pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter
    def buttons(self) -> Sequence['outputs.GoogleCloudDialogflowV2beta1IntentMessageBasicCardButtonResponse']:
        """
        Optional. The collection of card buttons.
        """
        return pulumi.get(self, "buttons")

    @property
    @pulumi.getter(name="formattedText")
    def formatted_text(self) -> str:
        """
        Required, unless image is present. The body text of the card.
        """
        return pulumi.get(self, "formatted_text")

    @property
    @pulumi.getter
    def image(self) -> 'outputs.GoogleCloudDialogflowV2beta1IntentMessageImageResponse':
        """
        Optional. The image for the card.
        """
        return pulumi.get(self, "image")

    @property
    @pulumi.getter
    def subtitle(self) -> str:
        """
        Optional. The subtitle of the card.
        """
        return pulumi.get(self, "subtitle")

    @property
    @pulumi.getter
    def title(self) -> str:
        """
        Optional. The title of the card.
        """
        return pulumi.get(self, "title")


@pulumi.output_type
class GoogleCloudDialogflowV2beta1IntentMessageBrowseCarouselCardBrowseCarouselCardItemOpenUrlActionResponse(dict):
    """
    Actions on Google action to open a given url.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "urlTypeHint":
            suggest = "url_type_hint"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDialogflowV2beta1IntentMessageBrowseCarouselCardBrowseCarouselCardItemOpenUrlActionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDialogflowV2beta1IntentMessageBrowseCarouselCardBrowseCarouselCardItemOpenUrlActionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDialogflowV2beta1IntentMessageBrowseCarouselCardBrowseCarouselCardItemOpenUrlActionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 url: str,
                 url_type_hint: str):
        """
        Actions on Google action to open a given url.
        :param str url: Required. URL
        :param str url_type_hint: Optional. Specifies the type of viewer that is used when opening the URL. Defaults to opening via web browser.
        """
        pulumi.set(__self__, "url", url)
        pulumi.set(__self__, "url_type_hint", url_type_hint)

    @property
    @pulumi.getter
    def url(self) -> str:
        """
        Required. URL
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter(name="urlTypeHint")
    def url_type_hint(self) -> str:
        """
        Optional. Specifies the type of viewer that is used when opening the URL. Defaults to opening via web browser.
        """
        return pulumi.get(self, "url_type_hint")


@pulumi.output_type
class GoogleCloudDialogflowV2beta1IntentMessageBrowseCarouselCardBrowseCarouselCardItemResponse(dict):
    """
    Browsing carousel tile
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "openUriAction":
            suggest = "open_uri_action"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDialogflowV2beta1IntentMessageBrowseCarouselCardBrowseCarouselCardItemResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDialogflowV2beta1IntentMessageBrowseCarouselCardBrowseCarouselCardItemResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDialogflowV2beta1IntentMessageBrowseCarouselCardBrowseCarouselCardItemResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 description: str,
                 footer: str,
                 image: 'outputs.GoogleCloudDialogflowV2beta1IntentMessageImageResponse',
                 open_uri_action: 'outputs.GoogleCloudDialogflowV2beta1IntentMessageBrowseCarouselCardBrowseCarouselCardItemOpenUrlActionResponse',
                 title: str):
        """
        Browsing carousel tile
        :param str description: Optional. Description of the carousel item. Maximum of four lines of text.
        :param str footer: Optional. Text that appears at the bottom of the Browse Carousel Card. Maximum of one line of text.
        :param 'GoogleCloudDialogflowV2beta1IntentMessageImageResponse' image: Optional. Hero image for the carousel item.
        :param 'GoogleCloudDialogflowV2beta1IntentMessageBrowseCarouselCardBrowseCarouselCardItemOpenUrlActionResponse' open_uri_action: Required. Action to present to the user.
        :param str title: Required. Title of the carousel item. Maximum of two lines of text.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "footer", footer)
        pulumi.set(__self__, "image", image)
        pulumi.set(__self__, "open_uri_action", open_uri_action)
        pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Optional. Description of the carousel item. Maximum of four lines of text.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def footer(self) -> str:
        """
        Optional. Text that appears at the bottom of the Browse Carousel Card. Maximum of one line of text.
        """
        return pulumi.get(self, "footer")

    @property
    @pulumi.getter
    def image(self) -> 'outputs.GoogleCloudDialogflowV2beta1IntentMessageImageResponse':
        """
        Optional. Hero image for the carousel item.
        """
        return pulumi.get(self, "image")

    @property
    @pulumi.getter(name="openUriAction")
    def open_uri_action(self) -> 'outputs.GoogleCloudDialogflowV2beta1IntentMessageBrowseCarouselCardBrowseCarouselCardItemOpenUrlActionResponse':
        """
        Required. Action to present to the user.
        """
        return pulumi.get(self, "open_uri_action")

    @property
    @pulumi.getter
    def title(self) -> str:
        """
        Required. Title of the carousel item. Maximum of two lines of text.
        """
        return pulumi.get(self, "title")


@pulumi.output_type
class GoogleCloudDialogflowV2beta1IntentMessageBrowseCarouselCardResponse(dict):
    """
    Browse Carousel Card for Actions on Google. https://developers.google.com/actions/assistant/responses#browsing_carousel
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "imageDisplayOptions":
            suggest = "image_display_options"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDialogflowV2beta1IntentMessageBrowseCarouselCardResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDialogflowV2beta1IntentMessageBrowseCarouselCardResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDialogflowV2beta1IntentMessageBrowseCarouselCardResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 image_display_options: str,
                 items: Sequence['outputs.GoogleCloudDialogflowV2beta1IntentMessageBrowseCarouselCardBrowseCarouselCardItemResponse']):
        """
        Browse Carousel Card for Actions on Google. https://developers.google.com/actions/assistant/responses#browsing_carousel
        :param str image_display_options: Optional. Settings for displaying the image. Applies to every image in items.
        :param Sequence['GoogleCloudDialogflowV2beta1IntentMessageBrowseCarouselCardBrowseCarouselCardItemResponse'] items: Required. List of items in the Browse Carousel Card. Minimum of two items, maximum of ten.
        """
        pulumi.set(__self__, "image_display_options", image_display_options)
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter(name="imageDisplayOptions")
    def image_display_options(self) -> str:
        """
        Optional. Settings for displaying the image. Applies to every image in items.
        """
        return pulumi.get(self, "image_display_options")

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GoogleCloudDialogflowV2beta1IntentMessageBrowseCarouselCardBrowseCarouselCardItemResponse']:
        """
        Required. List of items in the Browse Carousel Card. Minimum of two items, maximum of ten.
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class GoogleCloudDialogflowV2beta1IntentMessageCardButtonResponse(dict):
    """
    Optional. Contains information about a button.
    """
    def __init__(__self__, *,
                 postback: str,
                 text: str):
        """
        Optional. Contains information about a button.
        :param str postback: Optional. The text to send back to the Dialogflow API or a URI to open.
        :param str text: Optional. The text to show on the button.
        """
        pulumi.set(__self__, "postback", postback)
        pulumi.set(__self__, "text", text)

    @property
    @pulumi.getter
    def postback(self) -> str:
        """
        Optional. The text to send back to the Dialogflow API or a URI to open.
        """
        return pulumi.get(self, "postback")

    @property
    @pulumi.getter
    def text(self) -> str:
        """
        Optional. The text to show on the button.
        """
        return pulumi.get(self, "text")


@pulumi.output_type
class GoogleCloudDialogflowV2beta1IntentMessageCardResponse(dict):
    """
    The card response message.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "imageUri":
            suggest = "image_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDialogflowV2beta1IntentMessageCardResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDialogflowV2beta1IntentMessageCardResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDialogflowV2beta1IntentMessageCardResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 buttons: Sequence['outputs.GoogleCloudDialogflowV2beta1IntentMessageCardButtonResponse'],
                 image_uri: str,
                 subtitle: str,
                 title: str):
        """
        The card response message.
        :param Sequence['GoogleCloudDialogflowV2beta1IntentMessageCardButtonResponse'] buttons: Optional. The collection of card buttons.
        :param str image_uri: Optional. The public URI to an image file for the card.
        :param str subtitle: Optional. The subtitle of the card.
        :param str title: Optional. The title of the card.
        """
        pulumi.set(__self__, "buttons", buttons)
        pulumi.set(__self__, "image_uri", image_uri)
        pulumi.set(__self__, "subtitle", subtitle)
        pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter
    def buttons(self) -> Sequence['outputs.GoogleCloudDialogflowV2beta1IntentMessageCardButtonResponse']:
        """
        Optional. The collection of card buttons.
        """
        return pulumi.get(self, "buttons")

    @property
    @pulumi.getter(name="imageUri")
    def image_uri(self) -> str:
        """
        Optional. The public URI to an image file for the card.
        """
        return pulumi.get(self, "image_uri")

    @property
    @pulumi.getter
    def subtitle(self) -> str:
        """
        Optional. The subtitle of the card.
        """
        return pulumi.get(self, "subtitle")

    @property
    @pulumi.getter
    def title(self) -> str:
        """
        Optional. The title of the card.
        """
        return pulumi.get(self, "title")


@pulumi.output_type
class GoogleCloudDialogflowV2beta1IntentMessageCarouselSelectItemResponse(dict):
    """
    An item in the carousel.
    """
    def __init__(__self__, *,
                 description: str,
                 image: 'outputs.GoogleCloudDialogflowV2beta1IntentMessageImageResponse',
                 info: 'outputs.GoogleCloudDialogflowV2beta1IntentMessageSelectItemInfoResponse',
                 title: str):
        """
        An item in the carousel.
        :param str description: Optional. The body text of the card.
        :param 'GoogleCloudDialogflowV2beta1IntentMessageImageResponse' image: Optional. The image to display.
        :param 'GoogleCloudDialogflowV2beta1IntentMessageSelectItemInfoResponse' info: Required. Additional info about the option item.
        :param str title: Required. Title of the carousel item.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "image", image)
        pulumi.set(__self__, "info", info)
        pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Optional. The body text of the card.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def image(self) -> 'outputs.GoogleCloudDialogflowV2beta1IntentMessageImageResponse':
        """
        Optional. The image to display.
        """
        return pulumi.get(self, "image")

    @property
    @pulumi.getter
    def info(self) -> 'outputs.GoogleCloudDialogflowV2beta1IntentMessageSelectItemInfoResponse':
        """
        Required. Additional info about the option item.
        """
        return pulumi.get(self, "info")

    @property
    @pulumi.getter
    def title(self) -> str:
        """
        Required. Title of the carousel item.
        """
        return pulumi.get(self, "title")


@pulumi.output_type
class GoogleCloudDialogflowV2beta1IntentMessageCarouselSelectResponse(dict):
    """
    The card for presenting a carousel of options to select from.
    """
    def __init__(__self__, *,
                 items: Sequence['outputs.GoogleCloudDialogflowV2beta1IntentMessageCarouselSelectItemResponse']):
        """
        The card for presenting a carousel of options to select from.
        :param Sequence['GoogleCloudDialogflowV2beta1IntentMessageCarouselSelectItemResponse'] items: Required. Carousel items.
        """
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GoogleCloudDialogflowV2beta1IntentMessageCarouselSelectItemResponse']:
        """
        Required. Carousel items.
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class GoogleCloudDialogflowV2beta1IntentMessageColumnPropertiesResponse(dict):
    """
    Column properties for TableCard.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "horizontalAlignment":
            suggest = "horizontal_alignment"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDialogflowV2beta1IntentMessageColumnPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDialogflowV2beta1IntentMessageColumnPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDialogflowV2beta1IntentMessageColumnPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 header: str,
                 horizontal_alignment: str):
        """
        Column properties for TableCard.
        :param str header: Required. Column heading.
        :param str horizontal_alignment: Optional. Defines text alignment for all cells in this column.
        """
        pulumi.set(__self__, "header", header)
        pulumi.set(__self__, "horizontal_alignment", horizontal_alignment)

    @property
    @pulumi.getter
    def header(self) -> str:
        """
        Required. Column heading.
        """
        return pulumi.get(self, "header")

    @property
    @pulumi.getter(name="horizontalAlignment")
    def horizontal_alignment(self) -> str:
        """
        Optional. Defines text alignment for all cells in this column.
        """
        return pulumi.get(self, "horizontal_alignment")


@pulumi.output_type
class GoogleCloudDialogflowV2beta1IntentMessageImageResponse(dict):
    """
    The image response message.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessibilityText":
            suggest = "accessibility_text"
        elif key == "imageUri":
            suggest = "image_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDialogflowV2beta1IntentMessageImageResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDialogflowV2beta1IntentMessageImageResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDialogflowV2beta1IntentMessageImageResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 accessibility_text: str,
                 image_uri: str):
        """
        The image response message.
        :param str accessibility_text: A text description of the image to be used for accessibility, e.g., screen readers. Required if image_uri is set for CarouselSelect.
        :param str image_uri: Optional. The public URI to an image file.
        """
        pulumi.set(__self__, "accessibility_text", accessibility_text)
        pulumi.set(__self__, "image_uri", image_uri)

    @property
    @pulumi.getter(name="accessibilityText")
    def accessibility_text(self) -> str:
        """
        A text description of the image to be used for accessibility, e.g., screen readers. Required if image_uri is set for CarouselSelect.
        """
        return pulumi.get(self, "accessibility_text")

    @property
    @pulumi.getter(name="imageUri")
    def image_uri(self) -> str:
        """
        Optional. The public URI to an image file.
        """
        return pulumi.get(self, "image_uri")


@pulumi.output_type
class GoogleCloudDialogflowV2beta1IntentMessageLinkOutSuggestionResponse(dict):
    """
    The suggestion chip message that allows the user to jump out to the app or website associated with this agent.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "destinationName":
            suggest = "destination_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDialogflowV2beta1IntentMessageLinkOutSuggestionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDialogflowV2beta1IntentMessageLinkOutSuggestionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDialogflowV2beta1IntentMessageLinkOutSuggestionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 destination_name: str,
                 uri: str):
        """
        The suggestion chip message that allows the user to jump out to the app or website associated with this agent.
        :param str destination_name: Required. The name of the app or site this chip is linking to.
        :param str uri: Required. The URI of the app or site to open when the user taps the suggestion chip.
        """
        pulumi.set(__self__, "destination_name", destination_name)
        pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter(name="destinationName")
    def destination_name(self) -> str:
        """
        Required. The name of the app or site this chip is linking to.
        """
        return pulumi.get(self, "destination_name")

    @property
    @pulumi.getter
    def uri(self) -> str:
        """
        Required. The URI of the app or site to open when the user taps the suggestion chip.
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class GoogleCloudDialogflowV2beta1IntentMessageListSelectItemResponse(dict):
    """
    An item in the list.
    """
    def __init__(__self__, *,
                 description: str,
                 image: 'outputs.GoogleCloudDialogflowV2beta1IntentMessageImageResponse',
                 info: 'outputs.GoogleCloudDialogflowV2beta1IntentMessageSelectItemInfoResponse',
                 title: str):
        """
        An item in the list.
        :param str description: Optional. The main text describing the item.
        :param 'GoogleCloudDialogflowV2beta1IntentMessageImageResponse' image: Optional. The image to display.
        :param 'GoogleCloudDialogflowV2beta1IntentMessageSelectItemInfoResponse' info: Required. Additional information about this option.
        :param str title: Required. The title of the list item.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "image", image)
        pulumi.set(__self__, "info", info)
        pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Optional. The main text describing the item.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def image(self) -> 'outputs.GoogleCloudDialogflowV2beta1IntentMessageImageResponse':
        """
        Optional. The image to display.
        """
        return pulumi.get(self, "image")

    @property
    @pulumi.getter
    def info(self) -> 'outputs.GoogleCloudDialogflowV2beta1IntentMessageSelectItemInfoResponse':
        """
        Required. Additional information about this option.
        """
        return pulumi.get(self, "info")

    @property
    @pulumi.getter
    def title(self) -> str:
        """
        Required. The title of the list item.
        """
        return pulumi.get(self, "title")


@pulumi.output_type
class GoogleCloudDialogflowV2beta1IntentMessageListSelectResponse(dict):
    """
    The card for presenting a list of options to select from.
    """
    def __init__(__self__, *,
                 items: Sequence['outputs.GoogleCloudDialogflowV2beta1IntentMessageListSelectItemResponse'],
                 subtitle: str,
                 title: str):
        """
        The card for presenting a list of options to select from.
        :param Sequence['GoogleCloudDialogflowV2beta1IntentMessageListSelectItemResponse'] items: Required. List items.
        :param str subtitle: Optional. Subtitle of the list.
        :param str title: Optional. The overall title of the list.
        """
        pulumi.set(__self__, "items", items)
        pulumi.set(__self__, "subtitle", subtitle)
        pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GoogleCloudDialogflowV2beta1IntentMessageListSelectItemResponse']:
        """
        Required. List items.
        """
        return pulumi.get(self, "items")

    @property
    @pulumi.getter
    def subtitle(self) -> str:
        """
        Optional. Subtitle of the list.
        """
        return pulumi.get(self, "subtitle")

    @property
    @pulumi.getter
    def title(self) -> str:
        """
        Optional. The overall title of the list.
        """
        return pulumi.get(self, "title")


@pulumi.output_type
class GoogleCloudDialogflowV2beta1IntentMessageMediaContentResponse(dict):
    """
    The media content card for Actions on Google.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "mediaObjects":
            suggest = "media_objects"
        elif key == "mediaType":
            suggest = "media_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDialogflowV2beta1IntentMessageMediaContentResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDialogflowV2beta1IntentMessageMediaContentResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDialogflowV2beta1IntentMessageMediaContentResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 media_objects: Sequence['outputs.GoogleCloudDialogflowV2beta1IntentMessageMediaContentResponseMediaObjectResponse'],
                 media_type: str):
        """
        The media content card for Actions on Google.
        :param Sequence['GoogleCloudDialogflowV2beta1IntentMessageMediaContentResponseMediaObjectResponse'] media_objects: Required. List of media objects.
        :param str media_type: Optional. What type of media is the content (ie "audio").
        """
        pulumi.set(__self__, "media_objects", media_objects)
        pulumi.set(__self__, "media_type", media_type)

    @property
    @pulumi.getter(name="mediaObjects")
    def media_objects(self) -> Sequence['outputs.GoogleCloudDialogflowV2beta1IntentMessageMediaContentResponseMediaObjectResponse']:
        """
        Required. List of media objects.
        """
        return pulumi.get(self, "media_objects")

    @property
    @pulumi.getter(name="mediaType")
    def media_type(self) -> str:
        """
        Optional. What type of media is the content (ie "audio").
        """
        return pulumi.get(self, "media_type")


@pulumi.output_type
class GoogleCloudDialogflowV2beta1IntentMessageMediaContentResponseMediaObjectResponse(dict):
    """
    Response media object for media content card.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "contentUrl":
            suggest = "content_url"
        elif key == "largeImage":
            suggest = "large_image"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDialogflowV2beta1IntentMessageMediaContentResponseMediaObjectResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDialogflowV2beta1IntentMessageMediaContentResponseMediaObjectResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDialogflowV2beta1IntentMessageMediaContentResponseMediaObjectResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 content_url: str,
                 description: str,
                 icon: 'outputs.GoogleCloudDialogflowV2beta1IntentMessageImageResponse',
                 large_image: 'outputs.GoogleCloudDialogflowV2beta1IntentMessageImageResponse',
                 name: str):
        """
        Response media object for media content card.
        :param str content_url: Required. Url where the media is stored.
        :param str description: Optional. Description of media card.
        :param 'GoogleCloudDialogflowV2beta1IntentMessageImageResponse' icon: Optional. Icon to display above media content.
        :param 'GoogleCloudDialogflowV2beta1IntentMessageImageResponse' large_image: Optional. Image to display above media content.
        :param str name: Required. Name of media card.
        """
        pulumi.set(__self__, "content_url", content_url)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "icon", icon)
        pulumi.set(__self__, "large_image", large_image)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="contentUrl")
    def content_url(self) -> str:
        """
        Required. Url where the media is stored.
        """
        return pulumi.get(self, "content_url")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Optional. Description of media card.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def icon(self) -> 'outputs.GoogleCloudDialogflowV2beta1IntentMessageImageResponse':
        """
        Optional. Icon to display above media content.
        """
        return pulumi.get(self, "icon")

    @property
    @pulumi.getter(name="largeImage")
    def large_image(self) -> 'outputs.GoogleCloudDialogflowV2beta1IntentMessageImageResponse':
        """
        Optional. Image to display above media content.
        """
        return pulumi.get(self, "large_image")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Required. Name of media card.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GoogleCloudDialogflowV2beta1IntentMessageQuickRepliesResponse(dict):
    """
    The quick replies response message.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "quickReplies":
            suggest = "quick_replies"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDialogflowV2beta1IntentMessageQuickRepliesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDialogflowV2beta1IntentMessageQuickRepliesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDialogflowV2beta1IntentMessageQuickRepliesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 quick_replies: Sequence[str],
                 title: str):
        """
        The quick replies response message.
        :param Sequence[str] quick_replies: Optional. The collection of quick replies.
        :param str title: Optional. The title of the collection of quick replies.
        """
        pulumi.set(__self__, "quick_replies", quick_replies)
        pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter(name="quickReplies")
    def quick_replies(self) -> Sequence[str]:
        """
        Optional. The collection of quick replies.
        """
        return pulumi.get(self, "quick_replies")

    @property
    @pulumi.getter
    def title(self) -> str:
        """
        Optional. The title of the collection of quick replies.
        """
        return pulumi.get(self, "title")


@pulumi.output_type
class GoogleCloudDialogflowV2beta1IntentMessageRbmCardContentRbmMediaResponse(dict):
    """
    Rich Business Messaging (RBM) Media displayed in Cards The following media-types are currently supported: Image Types * image/jpeg * image/jpg' * image/gif * image/png Video Types * video/h263 * video/m4v * video/mp4 * video/mpeg * video/mpeg4 * video/webm
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fileUri":
            suggest = "file_uri"
        elif key == "thumbnailUri":
            suggest = "thumbnail_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDialogflowV2beta1IntentMessageRbmCardContentRbmMediaResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDialogflowV2beta1IntentMessageRbmCardContentRbmMediaResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDialogflowV2beta1IntentMessageRbmCardContentRbmMediaResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 file_uri: str,
                 height: str,
                 thumbnail_uri: str):
        """
        Rich Business Messaging (RBM) Media displayed in Cards The following media-types are currently supported: Image Types * image/jpeg * image/jpg' * image/gif * image/png Video Types * video/h263 * video/m4v * video/mp4 * video/mpeg * video/mpeg4 * video/webm
        :param str file_uri: Required. Publicly reachable URI of the file. The RBM platform determines the MIME type of the file from the content-type field in the HTTP headers when the platform fetches the file. The content-type field must be present and accurate in the HTTP response from the URL.
        :param str height: Required for cards with vertical orientation. The height of the media within a rich card with a vertical layout. For a standalone card with horizontal layout, height is not customizable, and this field is ignored.
        :param str thumbnail_uri: Optional. Publicly reachable URI of the thumbnail.If you don't provide a thumbnail URI, the RBM platform displays a blank placeholder thumbnail until the user's device downloads the file. Depending on the user's setting, the file may not download automatically and may require the user to tap a download button.
        """
        pulumi.set(__self__, "file_uri", file_uri)
        pulumi.set(__self__, "height", height)
        pulumi.set(__self__, "thumbnail_uri", thumbnail_uri)

    @property
    @pulumi.getter(name="fileUri")
    def file_uri(self) -> str:
        """
        Required. Publicly reachable URI of the file. The RBM platform determines the MIME type of the file from the content-type field in the HTTP headers when the platform fetches the file. The content-type field must be present and accurate in the HTTP response from the URL.
        """
        return pulumi.get(self, "file_uri")

    @property
    @pulumi.getter
    def height(self) -> str:
        """
        Required for cards with vertical orientation. The height of the media within a rich card with a vertical layout. For a standalone card with horizontal layout, height is not customizable, and this field is ignored.
        """
        return pulumi.get(self, "height")

    @property
    @pulumi.getter(name="thumbnailUri")
    def thumbnail_uri(self) -> str:
        """
        Optional. Publicly reachable URI of the thumbnail.If you don't provide a thumbnail URI, the RBM platform displays a blank placeholder thumbnail until the user's device downloads the file. Depending on the user's setting, the file may not download automatically and may require the user to tap a download button.
        """
        return pulumi.get(self, "thumbnail_uri")


@pulumi.output_type
class GoogleCloudDialogflowV2beta1IntentMessageRbmCardContentResponse(dict):
    """
    Rich Business Messaging (RBM) Card content
    """
    def __init__(__self__, *,
                 description: str,
                 media: 'outputs.GoogleCloudDialogflowV2beta1IntentMessageRbmCardContentRbmMediaResponse',
                 suggestions: Sequence['outputs.GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestionResponse'],
                 title: str):
        """
        Rich Business Messaging (RBM) Card content
        :param str description: Optional. Description of the card (at most 2000 bytes). At least one of the title, description or media must be set.
        :param 'GoogleCloudDialogflowV2beta1IntentMessageRbmCardContentRbmMediaResponse' media: Optional. However at least one of the title, description or media must be set. Media (image, GIF or a video) to include in the card.
        :param Sequence['GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestionResponse'] suggestions: Optional. List of suggestions to include in the card.
        :param str title: Optional. Title of the card (at most 200 bytes). At least one of the title, description or media must be set.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "media", media)
        pulumi.set(__self__, "suggestions", suggestions)
        pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Optional. Description of the card (at most 2000 bytes). At least one of the title, description or media must be set.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def media(self) -> 'outputs.GoogleCloudDialogflowV2beta1IntentMessageRbmCardContentRbmMediaResponse':
        """
        Optional. However at least one of the title, description or media must be set. Media (image, GIF or a video) to include in the card.
        """
        return pulumi.get(self, "media")

    @property
    @pulumi.getter
    def suggestions(self) -> Sequence['outputs.GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestionResponse']:
        """
        Optional. List of suggestions to include in the card.
        """
        return pulumi.get(self, "suggestions")

    @property
    @pulumi.getter
    def title(self) -> str:
        """
        Optional. Title of the card (at most 200 bytes). At least one of the title, description or media must be set.
        """
        return pulumi.get(self, "title")


@pulumi.output_type
class GoogleCloudDialogflowV2beta1IntentMessageRbmCarouselCardResponse(dict):
    """
    Carousel Rich Business Messaging (RBM) rich card. Rich cards allow you to respond to users with more vivid content, e.g. with media and suggestions. If you want to show a single card with more control over the layout, please use RbmStandaloneCard instead.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cardContents":
            suggest = "card_contents"
        elif key == "cardWidth":
            suggest = "card_width"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDialogflowV2beta1IntentMessageRbmCarouselCardResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDialogflowV2beta1IntentMessageRbmCarouselCardResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDialogflowV2beta1IntentMessageRbmCarouselCardResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 card_contents: Sequence['outputs.GoogleCloudDialogflowV2beta1IntentMessageRbmCardContentResponse'],
                 card_width: str):
        """
        Carousel Rich Business Messaging (RBM) rich card. Rich cards allow you to respond to users with more vivid content, e.g. with media and suggestions. If you want to show a single card with more control over the layout, please use RbmStandaloneCard instead.
        :param Sequence['GoogleCloudDialogflowV2beta1IntentMessageRbmCardContentResponse'] card_contents: Required. The cards in the carousel. A carousel must have at least 2 cards and at most 10.
        :param str card_width: Required. The width of the cards in the carousel.
        """
        pulumi.set(__self__, "card_contents", card_contents)
        pulumi.set(__self__, "card_width", card_width)

    @property
    @pulumi.getter(name="cardContents")
    def card_contents(self) -> Sequence['outputs.GoogleCloudDialogflowV2beta1IntentMessageRbmCardContentResponse']:
        """
        Required. The cards in the carousel. A carousel must have at least 2 cards and at most 10.
        """
        return pulumi.get(self, "card_contents")

    @property
    @pulumi.getter(name="cardWidth")
    def card_width(self) -> str:
        """
        Required. The width of the cards in the carousel.
        """
        return pulumi.get(self, "card_width")


@pulumi.output_type
class GoogleCloudDialogflowV2beta1IntentMessageRbmStandaloneCardResponse(dict):
    """
    Standalone Rich Business Messaging (RBM) rich card. Rich cards allow you to respond to users with more vivid content, e.g. with media and suggestions. You can group multiple rich cards into one using RbmCarouselCard but carousel cards will give you less control over the card layout.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cardContent":
            suggest = "card_content"
        elif key == "cardOrientation":
            suggest = "card_orientation"
        elif key == "thumbnailImageAlignment":
            suggest = "thumbnail_image_alignment"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDialogflowV2beta1IntentMessageRbmStandaloneCardResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDialogflowV2beta1IntentMessageRbmStandaloneCardResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDialogflowV2beta1IntentMessageRbmStandaloneCardResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 card_content: 'outputs.GoogleCloudDialogflowV2beta1IntentMessageRbmCardContentResponse',
                 card_orientation: str,
                 thumbnail_image_alignment: str):
        """
        Standalone Rich Business Messaging (RBM) rich card. Rich cards allow you to respond to users with more vivid content, e.g. with media and suggestions. You can group multiple rich cards into one using RbmCarouselCard but carousel cards will give you less control over the card layout.
        :param 'GoogleCloudDialogflowV2beta1IntentMessageRbmCardContentResponse' card_content: Required. Card content.
        :param str card_orientation: Required. Orientation of the card.
        :param str thumbnail_image_alignment: Required if orientation is horizontal. Image preview alignment for standalone cards with horizontal layout.
        """
        pulumi.set(__self__, "card_content", card_content)
        pulumi.set(__self__, "card_orientation", card_orientation)
        pulumi.set(__self__, "thumbnail_image_alignment", thumbnail_image_alignment)

    @property
    @pulumi.getter(name="cardContent")
    def card_content(self) -> 'outputs.GoogleCloudDialogflowV2beta1IntentMessageRbmCardContentResponse':
        """
        Required. Card content.
        """
        return pulumi.get(self, "card_content")

    @property
    @pulumi.getter(name="cardOrientation")
    def card_orientation(self) -> str:
        """
        Required. Orientation of the card.
        """
        return pulumi.get(self, "card_orientation")

    @property
    @pulumi.getter(name="thumbnailImageAlignment")
    def thumbnail_image_alignment(self) -> str:
        """
        Required if orientation is horizontal. Image preview alignment for standalone cards with horizontal layout.
        """
        return pulumi.get(self, "thumbnail_image_alignment")


@pulumi.output_type
class GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedActionRbmSuggestedActionDialResponse(dict):
    """
    Opens the user's default dialer app with the specified phone number but does not dial automatically.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "phoneNumber":
            suggest = "phone_number"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedActionRbmSuggestedActionDialResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedActionRbmSuggestedActionDialResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedActionRbmSuggestedActionDialResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 phone_number: str):
        """
        Opens the user's default dialer app with the specified phone number but does not dial automatically.
        :param str phone_number: Required. The phone number to fill in the default dialer app. This field should be in [E.164](https://en.wikipedia.org/wiki/E.164) format. An example of a correctly formatted phone number: +15556767888.
        """
        pulumi.set(__self__, "phone_number", phone_number)

    @property
    @pulumi.getter(name="phoneNumber")
    def phone_number(self) -> str:
        """
        Required. The phone number to fill in the default dialer app. This field should be in [E.164](https://en.wikipedia.org/wiki/E.164) format. An example of a correctly formatted phone number: +15556767888.
        """
        return pulumi.get(self, "phone_number")


@pulumi.output_type
class GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedActionRbmSuggestedActionOpenUriResponse(dict):
    """
    Opens the user's default web browser app to the specified uri If the user has an app installed that is registered as the default handler for the URL, then this app will be opened instead, and its icon will be used in the suggested action UI.
    """
    def __init__(__self__, *,
                 uri: str):
        """
        Opens the user's default web browser app to the specified uri If the user has an app installed that is registered as the default handler for the URL, then this app will be opened instead, and its icon will be used in the suggested action UI.
        :param str uri: Required. The uri to open on the user device
        """
        pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter
    def uri(self) -> str:
        """
        Required. The uri to open on the user device
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedActionRbmSuggestedActionShareLocationResponse(dict):
    """
    Opens the device's location chooser so the user can pick a location to send back to the agent.
    """
    def __init__(__self__):
        """
        Opens the device's location chooser so the user can pick a location to send back to the agent.
        """
        pass


@pulumi.output_type
class GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedActionResponse(dict):
    """
    Rich Business Messaging (RBM) suggested client-side action that the user can choose from the card.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "openUrl":
            suggest = "open_url"
        elif key == "postbackData":
            suggest = "postback_data"
        elif key == "shareLocation":
            suggest = "share_location"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedActionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedActionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedActionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dial: 'outputs.GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedActionRbmSuggestedActionDialResponse',
                 open_url: 'outputs.GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedActionRbmSuggestedActionOpenUriResponse',
                 postback_data: str,
                 share_location: 'outputs.GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedActionRbmSuggestedActionShareLocationResponse',
                 text: str):
        """
        Rich Business Messaging (RBM) suggested client-side action that the user can choose from the card.
        :param 'GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedActionRbmSuggestedActionDialResponse' dial: Suggested client side action: Dial a phone number
        :param 'GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedActionRbmSuggestedActionOpenUriResponse' open_url: Suggested client side action: Open a URI on device
        :param str postback_data: Opaque payload that the Dialogflow receives in a user event when the user taps the suggested action. This data will be also forwarded to webhook to allow performing custom business logic.
        :param 'GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedActionRbmSuggestedActionShareLocationResponse' share_location: Suggested client side action: Share user location
        :param str text: Text to display alongside the action.
        """
        pulumi.set(__self__, "dial", dial)
        pulumi.set(__self__, "open_url", open_url)
        pulumi.set(__self__, "postback_data", postback_data)
        pulumi.set(__self__, "share_location", share_location)
        pulumi.set(__self__, "text", text)

    @property
    @pulumi.getter
    def dial(self) -> 'outputs.GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedActionRbmSuggestedActionDialResponse':
        """
        Suggested client side action: Dial a phone number
        """
        return pulumi.get(self, "dial")

    @property
    @pulumi.getter(name="openUrl")
    def open_url(self) -> 'outputs.GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedActionRbmSuggestedActionOpenUriResponse':
        """
        Suggested client side action: Open a URI on device
        """
        return pulumi.get(self, "open_url")

    @property
    @pulumi.getter(name="postbackData")
    def postback_data(self) -> str:
        """
        Opaque payload that the Dialogflow receives in a user event when the user taps the suggested action. This data will be also forwarded to webhook to allow performing custom business logic.
        """
        return pulumi.get(self, "postback_data")

    @property
    @pulumi.getter(name="shareLocation")
    def share_location(self) -> 'outputs.GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedActionRbmSuggestedActionShareLocationResponse':
        """
        Suggested client side action: Share user location
        """
        return pulumi.get(self, "share_location")

    @property
    @pulumi.getter
    def text(self) -> str:
        """
        Text to display alongside the action.
        """
        return pulumi.get(self, "text")


@pulumi.output_type
class GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedReplyResponse(dict):
    """
    Rich Business Messaging (RBM) suggested reply that the user can click instead of typing in their own response.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "postbackData":
            suggest = "postback_data"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedReplyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedReplyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedReplyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 postback_data: str,
                 text: str):
        """
        Rich Business Messaging (RBM) suggested reply that the user can click instead of typing in their own response.
        :param str postback_data: Opaque payload that the Dialogflow receives in a user event when the user taps the suggested reply. This data will be also forwarded to webhook to allow performing custom business logic.
        :param str text: Suggested reply text.
        """
        pulumi.set(__self__, "postback_data", postback_data)
        pulumi.set(__self__, "text", text)

    @property
    @pulumi.getter(name="postbackData")
    def postback_data(self) -> str:
        """
        Opaque payload that the Dialogflow receives in a user event when the user taps the suggested reply. This data will be also forwarded to webhook to allow performing custom business logic.
        """
        return pulumi.get(self, "postback_data")

    @property
    @pulumi.getter
    def text(self) -> str:
        """
        Suggested reply text.
        """
        return pulumi.get(self, "text")


@pulumi.output_type
class GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestionResponse(dict):
    """
    Rich Business Messaging (RBM) suggestion. Suggestions allow user to easily select/click a predefined response or perform an action (like opening a web uri).
    """
    def __init__(__self__, *,
                 action: 'outputs.GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedActionResponse',
                 reply: 'outputs.GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedReplyResponse'):
        """
        Rich Business Messaging (RBM) suggestion. Suggestions allow user to easily select/click a predefined response or perform an action (like opening a web uri).
        :param 'GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedActionResponse' action: Predefined client side actions that user can choose
        :param 'GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedReplyResponse' reply: Predefined replies for user to select instead of typing
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "reply", reply)

    @property
    @pulumi.getter
    def action(self) -> 'outputs.GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedActionResponse':
        """
        Predefined client side actions that user can choose
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter
    def reply(self) -> 'outputs.GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedReplyResponse':
        """
        Predefined replies for user to select instead of typing
        """
        return pulumi.get(self, "reply")


@pulumi.output_type
class GoogleCloudDialogflowV2beta1IntentMessageRbmTextResponse(dict):
    """
    Rich Business Messaging (RBM) text response with suggestions.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "rbmSuggestion":
            suggest = "rbm_suggestion"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDialogflowV2beta1IntentMessageRbmTextResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDialogflowV2beta1IntentMessageRbmTextResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDialogflowV2beta1IntentMessageRbmTextResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 rbm_suggestion: Sequence['outputs.GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestionResponse'],
                 text: str):
        """
        Rich Business Messaging (RBM) text response with suggestions.
        :param Sequence['GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestionResponse'] rbm_suggestion: Optional. One or more suggestions to show to the user.
        :param str text: Required. Text sent and displayed to the user.
        """
        pulumi.set(__self__, "rbm_suggestion", rbm_suggestion)
        pulumi.set(__self__, "text", text)

    @property
    @pulumi.getter(name="rbmSuggestion")
    def rbm_suggestion(self) -> Sequence['outputs.GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestionResponse']:
        """
        Optional. One or more suggestions to show to the user.
        """
        return pulumi.get(self, "rbm_suggestion")

    @property
    @pulumi.getter
    def text(self) -> str:
        """
        Required. Text sent and displayed to the user.
        """
        return pulumi.get(self, "text")


@pulumi.output_type
class GoogleCloudDialogflowV2beta1IntentMessageResponse(dict):
    """
    Corresponds to the `Response` field in the Dialogflow console.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "basicCard":
            suggest = "basic_card"
        elif key == "browseCarouselCard":
            suggest = "browse_carousel_card"
        elif key == "carouselSelect":
            suggest = "carousel_select"
        elif key == "linkOutSuggestion":
            suggest = "link_out_suggestion"
        elif key == "listSelect":
            suggest = "list_select"
        elif key == "mediaContent":
            suggest = "media_content"
        elif key == "quickReplies":
            suggest = "quick_replies"
        elif key == "rbmCarouselRichCard":
            suggest = "rbm_carousel_rich_card"
        elif key == "rbmStandaloneRichCard":
            suggest = "rbm_standalone_rich_card"
        elif key == "rbmText":
            suggest = "rbm_text"
        elif key == "simpleResponses":
            suggest = "simple_responses"
        elif key == "tableCard":
            suggest = "table_card"
        elif key == "telephonyPlayAudio":
            suggest = "telephony_play_audio"
        elif key == "telephonySynthesizeSpeech":
            suggest = "telephony_synthesize_speech"
        elif key == "telephonyTransferCall":
            suggest = "telephony_transfer_call"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDialogflowV2beta1IntentMessageResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDialogflowV2beta1IntentMessageResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDialogflowV2beta1IntentMessageResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 basic_card: 'outputs.GoogleCloudDialogflowV2beta1IntentMessageBasicCardResponse',
                 browse_carousel_card: 'outputs.GoogleCloudDialogflowV2beta1IntentMessageBrowseCarouselCardResponse',
                 card: 'outputs.GoogleCloudDialogflowV2beta1IntentMessageCardResponse',
                 carousel_select: 'outputs.GoogleCloudDialogflowV2beta1IntentMessageCarouselSelectResponse',
                 image: 'outputs.GoogleCloudDialogflowV2beta1IntentMessageImageResponse',
                 link_out_suggestion: 'outputs.GoogleCloudDialogflowV2beta1IntentMessageLinkOutSuggestionResponse',
                 list_select: 'outputs.GoogleCloudDialogflowV2beta1IntentMessageListSelectResponse',
                 media_content: 'outputs.GoogleCloudDialogflowV2beta1IntentMessageMediaContentResponse',
                 payload: Mapping[str, str],
                 platform: str,
                 quick_replies: 'outputs.GoogleCloudDialogflowV2beta1IntentMessageQuickRepliesResponse',
                 rbm_carousel_rich_card: 'outputs.GoogleCloudDialogflowV2beta1IntentMessageRbmCarouselCardResponse',
                 rbm_standalone_rich_card: 'outputs.GoogleCloudDialogflowV2beta1IntentMessageRbmStandaloneCardResponse',
                 rbm_text: 'outputs.GoogleCloudDialogflowV2beta1IntentMessageRbmTextResponse',
                 simple_responses: 'outputs.GoogleCloudDialogflowV2beta1IntentMessageSimpleResponsesResponse',
                 suggestions: 'outputs.GoogleCloudDialogflowV2beta1IntentMessageSuggestionsResponse',
                 table_card: 'outputs.GoogleCloudDialogflowV2beta1IntentMessageTableCardResponse',
                 telephony_play_audio: 'outputs.GoogleCloudDialogflowV2beta1IntentMessageTelephonyPlayAudioResponse',
                 telephony_synthesize_speech: 'outputs.GoogleCloudDialogflowV2beta1IntentMessageTelephonySynthesizeSpeechResponse',
                 telephony_transfer_call: 'outputs.GoogleCloudDialogflowV2beta1IntentMessageTelephonyTransferCallResponse',
                 text: 'outputs.GoogleCloudDialogflowV2beta1IntentMessageTextResponse'):
        """
        Corresponds to the `Response` field in the Dialogflow console.
        :param 'GoogleCloudDialogflowV2beta1IntentMessageBasicCardResponse' basic_card: Displays a basic card for Actions on Google.
        :param 'GoogleCloudDialogflowV2beta1IntentMessageBrowseCarouselCardResponse' browse_carousel_card: Browse carousel card for Actions on Google.
        :param 'GoogleCloudDialogflowV2beta1IntentMessageCardResponse' card: Displays a card.
        :param 'GoogleCloudDialogflowV2beta1IntentMessageCarouselSelectResponse' carousel_select: Displays a carousel card for Actions on Google.
        :param 'GoogleCloudDialogflowV2beta1IntentMessageImageResponse' image: Displays an image.
        :param 'GoogleCloudDialogflowV2beta1IntentMessageLinkOutSuggestionResponse' link_out_suggestion: Displays a link out suggestion chip for Actions on Google.
        :param 'GoogleCloudDialogflowV2beta1IntentMessageListSelectResponse' list_select: Displays a list card for Actions on Google.
        :param 'GoogleCloudDialogflowV2beta1IntentMessageMediaContentResponse' media_content: The media content card for Actions on Google.
        :param Mapping[str, str] payload: A custom platform-specific response.
        :param str platform: Optional. The platform that this message is intended for.
        :param 'GoogleCloudDialogflowV2beta1IntentMessageQuickRepliesResponse' quick_replies: Displays quick replies.
        :param 'GoogleCloudDialogflowV2beta1IntentMessageRbmCarouselCardResponse' rbm_carousel_rich_card: Rich Business Messaging (RBM) carousel rich card response.
        :param 'GoogleCloudDialogflowV2beta1IntentMessageRbmStandaloneCardResponse' rbm_standalone_rich_card: Standalone Rich Business Messaging (RBM) rich card response.
        :param 'GoogleCloudDialogflowV2beta1IntentMessageRbmTextResponse' rbm_text: Rich Business Messaging (RBM) text response. RBM allows businesses to send enriched and branded versions of SMS. See https://jibe.google.com/business-messaging.
        :param 'GoogleCloudDialogflowV2beta1IntentMessageSimpleResponsesResponse' simple_responses: Returns a voice or text-only response for Actions on Google.
        :param 'GoogleCloudDialogflowV2beta1IntentMessageSuggestionsResponse' suggestions: Displays suggestion chips for Actions on Google.
        :param 'GoogleCloudDialogflowV2beta1IntentMessageTableCardResponse' table_card: Table card for Actions on Google.
        :param 'GoogleCloudDialogflowV2beta1IntentMessageTelephonyPlayAudioResponse' telephony_play_audio: Plays audio from a file in Telephony Gateway.
        :param 'GoogleCloudDialogflowV2beta1IntentMessageTelephonySynthesizeSpeechResponse' telephony_synthesize_speech: Synthesizes speech in Telephony Gateway.
        :param 'GoogleCloudDialogflowV2beta1IntentMessageTelephonyTransferCallResponse' telephony_transfer_call: Transfers the call in Telephony Gateway.
        :param 'GoogleCloudDialogflowV2beta1IntentMessageTextResponse' text: Returns a text response.
        """
        pulumi.set(__self__, "basic_card", basic_card)
        pulumi.set(__self__, "browse_carousel_card", browse_carousel_card)
        pulumi.set(__self__, "card", card)
        pulumi.set(__self__, "carousel_select", carousel_select)
        pulumi.set(__self__, "image", image)
        pulumi.set(__self__, "link_out_suggestion", link_out_suggestion)
        pulumi.set(__self__, "list_select", list_select)
        pulumi.set(__self__, "media_content", media_content)
        pulumi.set(__self__, "payload", payload)
        pulumi.set(__self__, "platform", platform)
        pulumi.set(__self__, "quick_replies", quick_replies)
        pulumi.set(__self__, "rbm_carousel_rich_card", rbm_carousel_rich_card)
        pulumi.set(__self__, "rbm_standalone_rich_card", rbm_standalone_rich_card)
        pulumi.set(__self__, "rbm_text", rbm_text)
        pulumi.set(__self__, "simple_responses", simple_responses)
        pulumi.set(__self__, "suggestions", suggestions)
        pulumi.set(__self__, "table_card", table_card)
        pulumi.set(__self__, "telephony_play_audio", telephony_play_audio)
        pulumi.set(__self__, "telephony_synthesize_speech", telephony_synthesize_speech)
        pulumi.set(__self__, "telephony_transfer_call", telephony_transfer_call)
        pulumi.set(__self__, "text", text)

    @property
    @pulumi.getter(name="basicCard")
    def basic_card(self) -> 'outputs.GoogleCloudDialogflowV2beta1IntentMessageBasicCardResponse':
        """
        Displays a basic card for Actions on Google.
        """
        return pulumi.get(self, "basic_card")

    @property
    @pulumi.getter(name="browseCarouselCard")
    def browse_carousel_card(self) -> 'outputs.GoogleCloudDialogflowV2beta1IntentMessageBrowseCarouselCardResponse':
        """
        Browse carousel card for Actions on Google.
        """
        return pulumi.get(self, "browse_carousel_card")

    @property
    @pulumi.getter
    def card(self) -> 'outputs.GoogleCloudDialogflowV2beta1IntentMessageCardResponse':
        """
        Displays a card.
        """
        return pulumi.get(self, "card")

    @property
    @pulumi.getter(name="carouselSelect")
    def carousel_select(self) -> 'outputs.GoogleCloudDialogflowV2beta1IntentMessageCarouselSelectResponse':
        """
        Displays a carousel card for Actions on Google.
        """
        return pulumi.get(self, "carousel_select")

    @property
    @pulumi.getter
    def image(self) -> 'outputs.GoogleCloudDialogflowV2beta1IntentMessageImageResponse':
        """
        Displays an image.
        """
        return pulumi.get(self, "image")

    @property
    @pulumi.getter(name="linkOutSuggestion")
    def link_out_suggestion(self) -> 'outputs.GoogleCloudDialogflowV2beta1IntentMessageLinkOutSuggestionResponse':
        """
        Displays a link out suggestion chip for Actions on Google.
        """
        return pulumi.get(self, "link_out_suggestion")

    @property
    @pulumi.getter(name="listSelect")
    def list_select(self) -> 'outputs.GoogleCloudDialogflowV2beta1IntentMessageListSelectResponse':
        """
        Displays a list card for Actions on Google.
        """
        return pulumi.get(self, "list_select")

    @property
    @pulumi.getter(name="mediaContent")
    def media_content(self) -> 'outputs.GoogleCloudDialogflowV2beta1IntentMessageMediaContentResponse':
        """
        The media content card for Actions on Google.
        """
        return pulumi.get(self, "media_content")

    @property
    @pulumi.getter
    def payload(self) -> Mapping[str, str]:
        """
        A custom platform-specific response.
        """
        return pulumi.get(self, "payload")

    @property
    @pulumi.getter
    def platform(self) -> str:
        """
        Optional. The platform that this message is intended for.
        """
        return pulumi.get(self, "platform")

    @property
    @pulumi.getter(name="quickReplies")
    def quick_replies(self) -> 'outputs.GoogleCloudDialogflowV2beta1IntentMessageQuickRepliesResponse':
        """
        Displays quick replies.
        """
        return pulumi.get(self, "quick_replies")

    @property
    @pulumi.getter(name="rbmCarouselRichCard")
    def rbm_carousel_rich_card(self) -> 'outputs.GoogleCloudDialogflowV2beta1IntentMessageRbmCarouselCardResponse':
        """
        Rich Business Messaging (RBM) carousel rich card response.
        """
        return pulumi.get(self, "rbm_carousel_rich_card")

    @property
    @pulumi.getter(name="rbmStandaloneRichCard")
    def rbm_standalone_rich_card(self) -> 'outputs.GoogleCloudDialogflowV2beta1IntentMessageRbmStandaloneCardResponse':
        """
        Standalone Rich Business Messaging (RBM) rich card response.
        """
        return pulumi.get(self, "rbm_standalone_rich_card")

    @property
    @pulumi.getter(name="rbmText")
    def rbm_text(self) -> 'outputs.GoogleCloudDialogflowV2beta1IntentMessageRbmTextResponse':
        """
        Rich Business Messaging (RBM) text response. RBM allows businesses to send enriched and branded versions of SMS. See https://jibe.google.com/business-messaging.
        """
        return pulumi.get(self, "rbm_text")

    @property
    @pulumi.getter(name="simpleResponses")
    def simple_responses(self) -> 'outputs.GoogleCloudDialogflowV2beta1IntentMessageSimpleResponsesResponse':
        """
        Returns a voice or text-only response for Actions on Google.
        """
        return pulumi.get(self, "simple_responses")

    @property
    @pulumi.getter
    def suggestions(self) -> 'outputs.GoogleCloudDialogflowV2beta1IntentMessageSuggestionsResponse':
        """
        Displays suggestion chips for Actions on Google.
        """
        return pulumi.get(self, "suggestions")

    @property
    @pulumi.getter(name="tableCard")
    def table_card(self) -> 'outputs.GoogleCloudDialogflowV2beta1IntentMessageTableCardResponse':
        """
        Table card for Actions on Google.
        """
        return pulumi.get(self, "table_card")

    @property
    @pulumi.getter(name="telephonyPlayAudio")
    def telephony_play_audio(self) -> 'outputs.GoogleCloudDialogflowV2beta1IntentMessageTelephonyPlayAudioResponse':
        """
        Plays audio from a file in Telephony Gateway.
        """
        return pulumi.get(self, "telephony_play_audio")

    @property
    @pulumi.getter(name="telephonySynthesizeSpeech")
    def telephony_synthesize_speech(self) -> 'outputs.GoogleCloudDialogflowV2beta1IntentMessageTelephonySynthesizeSpeechResponse':
        """
        Synthesizes speech in Telephony Gateway.
        """
        return pulumi.get(self, "telephony_synthesize_speech")

    @property
    @pulumi.getter(name="telephonyTransferCall")
    def telephony_transfer_call(self) -> 'outputs.GoogleCloudDialogflowV2beta1IntentMessageTelephonyTransferCallResponse':
        """
        Transfers the call in Telephony Gateway.
        """
        return pulumi.get(self, "telephony_transfer_call")

    @property
    @pulumi.getter
    def text(self) -> 'outputs.GoogleCloudDialogflowV2beta1IntentMessageTextResponse':
        """
        Returns a text response.
        """
        return pulumi.get(self, "text")


@pulumi.output_type
class GoogleCloudDialogflowV2beta1IntentMessageSelectItemInfoResponse(dict):
    """
    Additional info about the select item for when it is triggered in a dialog.
    """
    def __init__(__self__, *,
                 key: str,
                 synonyms: Sequence[str]):
        """
        Additional info about the select item for when it is triggered in a dialog.
        :param str key: Required. A unique key that will be sent back to the agent if this response is given.
        :param Sequence[str] synonyms: Optional. A list of synonyms that can also be used to trigger this item in dialog.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "synonyms", synonyms)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        Required. A unique key that will be sent back to the agent if this response is given.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def synonyms(self) -> Sequence[str]:
        """
        Optional. A list of synonyms that can also be used to trigger this item in dialog.
        """
        return pulumi.get(self, "synonyms")


@pulumi.output_type
class GoogleCloudDialogflowV2beta1IntentMessageSimpleResponseResponse(dict):
    """
    The simple response message containing speech or text.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "displayText":
            suggest = "display_text"
        elif key == "textToSpeech":
            suggest = "text_to_speech"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDialogflowV2beta1IntentMessageSimpleResponseResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDialogflowV2beta1IntentMessageSimpleResponseResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDialogflowV2beta1IntentMessageSimpleResponseResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 display_text: str,
                 ssml: str,
                 text_to_speech: str):
        """
        The simple response message containing speech or text.
        :param str display_text: Optional. The text to display.
        :param str ssml: One of text_to_speech or ssml must be provided. Structured spoken response to the user in the SSML format. Mutually exclusive with text_to_speech.
        :param str text_to_speech: One of text_to_speech or ssml must be provided. The plain text of the speech output. Mutually exclusive with ssml.
        """
        pulumi.set(__self__, "display_text", display_text)
        pulumi.set(__self__, "ssml", ssml)
        pulumi.set(__self__, "text_to_speech", text_to_speech)

    @property
    @pulumi.getter(name="displayText")
    def display_text(self) -> str:
        """
        Optional. The text to display.
        """
        return pulumi.get(self, "display_text")

    @property
    @pulumi.getter
    def ssml(self) -> str:
        """
        One of text_to_speech or ssml must be provided. Structured spoken response to the user in the SSML format. Mutually exclusive with text_to_speech.
        """
        return pulumi.get(self, "ssml")

    @property
    @pulumi.getter(name="textToSpeech")
    def text_to_speech(self) -> str:
        """
        One of text_to_speech or ssml must be provided. The plain text of the speech output. Mutually exclusive with ssml.
        """
        return pulumi.get(self, "text_to_speech")


@pulumi.output_type
class GoogleCloudDialogflowV2beta1IntentMessageSimpleResponsesResponse(dict):
    """
    The collection of simple response candidates. This message in `QueryResult.fulfillment_messages` and `WebhookResponse.fulfillment_messages` should contain only one `SimpleResponse`.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "simpleResponses":
            suggest = "simple_responses"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDialogflowV2beta1IntentMessageSimpleResponsesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDialogflowV2beta1IntentMessageSimpleResponsesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDialogflowV2beta1IntentMessageSimpleResponsesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 simple_responses: Sequence['outputs.GoogleCloudDialogflowV2beta1IntentMessageSimpleResponseResponse']):
        """
        The collection of simple response candidates. This message in `QueryResult.fulfillment_messages` and `WebhookResponse.fulfillment_messages` should contain only one `SimpleResponse`.
        :param Sequence['GoogleCloudDialogflowV2beta1IntentMessageSimpleResponseResponse'] simple_responses: Required. The list of simple responses.
        """
        pulumi.set(__self__, "simple_responses", simple_responses)

    @property
    @pulumi.getter(name="simpleResponses")
    def simple_responses(self) -> Sequence['outputs.GoogleCloudDialogflowV2beta1IntentMessageSimpleResponseResponse']:
        """
        Required. The list of simple responses.
        """
        return pulumi.get(self, "simple_responses")


@pulumi.output_type
class GoogleCloudDialogflowV2beta1IntentMessageSuggestionResponse(dict):
    """
    The suggestion chip message that the user can tap to quickly post a reply to the conversation.
    """
    def __init__(__self__, *,
                 title: str):
        """
        The suggestion chip message that the user can tap to quickly post a reply to the conversation.
        :param str title: Required. The text shown the in the suggestion chip.
        """
        pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter
    def title(self) -> str:
        """
        Required. The text shown the in the suggestion chip.
        """
        return pulumi.get(self, "title")


@pulumi.output_type
class GoogleCloudDialogflowV2beta1IntentMessageSuggestionsResponse(dict):
    """
    The collection of suggestions.
    """
    def __init__(__self__, *,
                 suggestions: Sequence['outputs.GoogleCloudDialogflowV2beta1IntentMessageSuggestionResponse']):
        """
        The collection of suggestions.
        :param Sequence['GoogleCloudDialogflowV2beta1IntentMessageSuggestionResponse'] suggestions: Required. The list of suggested replies.
        """
        pulumi.set(__self__, "suggestions", suggestions)

    @property
    @pulumi.getter
    def suggestions(self) -> Sequence['outputs.GoogleCloudDialogflowV2beta1IntentMessageSuggestionResponse']:
        """
        Required. The list of suggested replies.
        """
        return pulumi.get(self, "suggestions")


@pulumi.output_type
class GoogleCloudDialogflowV2beta1IntentMessageTableCardCellResponse(dict):
    """
    Cell of TableCardRow.
    """
    def __init__(__self__, *,
                 text: str):
        """
        Cell of TableCardRow.
        :param str text: Required. Text in this cell.
        """
        pulumi.set(__self__, "text", text)

    @property
    @pulumi.getter
    def text(self) -> str:
        """
        Required. Text in this cell.
        """
        return pulumi.get(self, "text")


@pulumi.output_type
class GoogleCloudDialogflowV2beta1IntentMessageTableCardResponse(dict):
    """
    Table card for Actions on Google.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "columnProperties":
            suggest = "column_properties"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDialogflowV2beta1IntentMessageTableCardResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDialogflowV2beta1IntentMessageTableCardResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDialogflowV2beta1IntentMessageTableCardResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 buttons: Sequence['outputs.GoogleCloudDialogflowV2beta1IntentMessageBasicCardButtonResponse'],
                 column_properties: Sequence['outputs.GoogleCloudDialogflowV2beta1IntentMessageColumnPropertiesResponse'],
                 image: 'outputs.GoogleCloudDialogflowV2beta1IntentMessageImageResponse',
                 rows: Sequence['outputs.GoogleCloudDialogflowV2beta1IntentMessageTableCardRowResponse'],
                 subtitle: str,
                 title: str):
        """
        Table card for Actions on Google.
        :param Sequence['GoogleCloudDialogflowV2beta1IntentMessageBasicCardButtonResponse'] buttons: Optional. List of buttons for the card.
        :param Sequence['GoogleCloudDialogflowV2beta1IntentMessageColumnPropertiesResponse'] column_properties: Optional. Display properties for the columns in this table.
        :param 'GoogleCloudDialogflowV2beta1IntentMessageImageResponse' image: Optional. Image which should be displayed on the card.
        :param Sequence['GoogleCloudDialogflowV2beta1IntentMessageTableCardRowResponse'] rows: Optional. Rows in this table of data.
        :param str subtitle: Optional. Subtitle to the title.
        :param str title: Required. Title of the card.
        """
        pulumi.set(__self__, "buttons", buttons)
        pulumi.set(__self__, "column_properties", column_properties)
        pulumi.set(__self__, "image", image)
        pulumi.set(__self__, "rows", rows)
        pulumi.set(__self__, "subtitle", subtitle)
        pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter
    def buttons(self) -> Sequence['outputs.GoogleCloudDialogflowV2beta1IntentMessageBasicCardButtonResponse']:
        """
        Optional. List of buttons for the card.
        """
        return pulumi.get(self, "buttons")

    @property
    @pulumi.getter(name="columnProperties")
    def column_properties(self) -> Sequence['outputs.GoogleCloudDialogflowV2beta1IntentMessageColumnPropertiesResponse']:
        """
        Optional. Display properties for the columns in this table.
        """
        return pulumi.get(self, "column_properties")

    @property
    @pulumi.getter
    def image(self) -> 'outputs.GoogleCloudDialogflowV2beta1IntentMessageImageResponse':
        """
        Optional. Image which should be displayed on the card.
        """
        return pulumi.get(self, "image")

    @property
    @pulumi.getter
    def rows(self) -> Sequence['outputs.GoogleCloudDialogflowV2beta1IntentMessageTableCardRowResponse']:
        """
        Optional. Rows in this table of data.
        """
        return pulumi.get(self, "rows")

    @property
    @pulumi.getter
    def subtitle(self) -> str:
        """
        Optional. Subtitle to the title.
        """
        return pulumi.get(self, "subtitle")

    @property
    @pulumi.getter
    def title(self) -> str:
        """
        Required. Title of the card.
        """
        return pulumi.get(self, "title")


@pulumi.output_type
class GoogleCloudDialogflowV2beta1IntentMessageTableCardRowResponse(dict):
    """
    Row of TableCard.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dividerAfter":
            suggest = "divider_after"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDialogflowV2beta1IntentMessageTableCardRowResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDialogflowV2beta1IntentMessageTableCardRowResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDialogflowV2beta1IntentMessageTableCardRowResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cells: Sequence['outputs.GoogleCloudDialogflowV2beta1IntentMessageTableCardCellResponse'],
                 divider_after: bool):
        """
        Row of TableCard.
        :param Sequence['GoogleCloudDialogflowV2beta1IntentMessageTableCardCellResponse'] cells: Optional. List of cells that make up this row.
        :param bool divider_after: Optional. Whether to add a visual divider after this row.
        """
        pulumi.set(__self__, "cells", cells)
        pulumi.set(__self__, "divider_after", divider_after)

    @property
    @pulumi.getter
    def cells(self) -> Sequence['outputs.GoogleCloudDialogflowV2beta1IntentMessageTableCardCellResponse']:
        """
        Optional. List of cells that make up this row.
        """
        return pulumi.get(self, "cells")

    @property
    @pulumi.getter(name="dividerAfter")
    def divider_after(self) -> bool:
        """
        Optional. Whether to add a visual divider after this row.
        """
        return pulumi.get(self, "divider_after")


@pulumi.output_type
class GoogleCloudDialogflowV2beta1IntentMessageTelephonyPlayAudioResponse(dict):
    """
    Plays audio from a file in Telephony Gateway.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "audioUri":
            suggest = "audio_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDialogflowV2beta1IntentMessageTelephonyPlayAudioResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDialogflowV2beta1IntentMessageTelephonyPlayAudioResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDialogflowV2beta1IntentMessageTelephonyPlayAudioResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 audio_uri: str):
        """
        Plays audio from a file in Telephony Gateway.
        :param str audio_uri: Required. URI to a Google Cloud Storage object containing the audio to play, e.g., "gs://bucket/object". The object must contain a single channel (mono) of linear PCM audio (2 bytes / sample) at 8kHz. This object must be readable by the `service-@gcp-sa-dialogflow.iam.gserviceaccount.com` service account where is the number of the Telephony Gateway project (usually the same as the Dialogflow agent project). If the Google Cloud Storage bucket is in the Telephony Gateway project, this permission is added by default when enabling the Dialogflow V2 API. For audio from other sources, consider using the `TelephonySynthesizeSpeech` message with SSML.
        """
        pulumi.set(__self__, "audio_uri", audio_uri)

    @property
    @pulumi.getter(name="audioUri")
    def audio_uri(self) -> str:
        """
        Required. URI to a Google Cloud Storage object containing the audio to play, e.g., "gs://bucket/object". The object must contain a single channel (mono) of linear PCM audio (2 bytes / sample) at 8kHz. This object must be readable by the `service-@gcp-sa-dialogflow.iam.gserviceaccount.com` service account where is the number of the Telephony Gateway project (usually the same as the Dialogflow agent project). If the Google Cloud Storage bucket is in the Telephony Gateway project, this permission is added by default when enabling the Dialogflow V2 API. For audio from other sources, consider using the `TelephonySynthesizeSpeech` message with SSML.
        """
        return pulumi.get(self, "audio_uri")


@pulumi.output_type
class GoogleCloudDialogflowV2beta1IntentMessageTelephonySynthesizeSpeechResponse(dict):
    """
    Synthesizes speech and plays back the synthesized audio to the caller in Telephony Gateway. Telephony Gateway takes the synthesizer settings from `DetectIntentResponse.output_audio_config` which can either be set at request-level or can come from the agent-level synthesizer config.
    """
    def __init__(__self__, *,
                 ssml: str,
                 text: str):
        """
        Synthesizes speech and plays back the synthesized audio to the caller in Telephony Gateway. Telephony Gateway takes the synthesizer settings from `DetectIntentResponse.output_audio_config` which can either be set at request-level or can come from the agent-level synthesizer config.
        :param str ssml: The SSML to be synthesized. For more information, see [SSML](https://developers.google.com/actions/reference/ssml).
        :param str text: The raw text to be synthesized.
        """
        pulumi.set(__self__, "ssml", ssml)
        pulumi.set(__self__, "text", text)

    @property
    @pulumi.getter
    def ssml(self) -> str:
        """
        The SSML to be synthesized. For more information, see [SSML](https://developers.google.com/actions/reference/ssml).
        """
        return pulumi.get(self, "ssml")

    @property
    @pulumi.getter
    def text(self) -> str:
        """
        The raw text to be synthesized.
        """
        return pulumi.get(self, "text")


@pulumi.output_type
class GoogleCloudDialogflowV2beta1IntentMessageTelephonyTransferCallResponse(dict):
    """
    Transfers the call in Telephony Gateway.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "phoneNumber":
            suggest = "phone_number"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDialogflowV2beta1IntentMessageTelephonyTransferCallResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDialogflowV2beta1IntentMessageTelephonyTransferCallResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDialogflowV2beta1IntentMessageTelephonyTransferCallResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 phone_number: str):
        """
        Transfers the call in Telephony Gateway.
        :param str phone_number: Required. The phone number to transfer the call to in [E.164 format](https://en.wikipedia.org/wiki/E.164). We currently only allow transferring to US numbers (+1xxxyyyzzzz).
        """
        pulumi.set(__self__, "phone_number", phone_number)

    @property
    @pulumi.getter(name="phoneNumber")
    def phone_number(self) -> str:
        """
        Required. The phone number to transfer the call to in [E.164 format](https://en.wikipedia.org/wiki/E.164). We currently only allow transferring to US numbers (+1xxxyyyzzzz).
        """
        return pulumi.get(self, "phone_number")


@pulumi.output_type
class GoogleCloudDialogflowV2beta1IntentMessageTextResponse(dict):
    """
    The text response message.
    """
    def __init__(__self__, *,
                 text: Sequence[str]):
        """
        The text response message.
        :param Sequence[str] text: Optional. The collection of the agent's responses.
        """
        pulumi.set(__self__, "text", text)

    @property
    @pulumi.getter
    def text(self) -> Sequence[str]:
        """
        Optional. The collection of the agent's responses.
        """
        return pulumi.get(self, "text")


@pulumi.output_type
class GoogleCloudDialogflowV2beta1IntentParameterResponse(dict):
    """
    Represents intent parameters.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultValue":
            suggest = "default_value"
        elif key == "displayName":
            suggest = "display_name"
        elif key == "entityTypeDisplayName":
            suggest = "entity_type_display_name"
        elif key == "isList":
            suggest = "is_list"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDialogflowV2beta1IntentParameterResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDialogflowV2beta1IntentParameterResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDialogflowV2beta1IntentParameterResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_value: str,
                 display_name: str,
                 entity_type_display_name: str,
                 is_list: bool,
                 mandatory: bool,
                 name: str,
                 prompts: Sequence[str],
                 value: str):
        """
        Represents intent parameters.
        :param str default_value: Optional. The default value to use when the `value` yields an empty result. Default values can be extracted from contexts by using the following syntax: `#context_name.parameter_name`.
        :param str display_name: Required. The name of the parameter.
        :param str entity_type_display_name: Optional. The name of the entity type, prefixed with `@`, that describes values of the parameter. If the parameter is required, this must be provided.
        :param bool is_list: Optional. Indicates whether the parameter represents a list of values.
        :param bool mandatory: Optional. Indicates whether the parameter is required. That is, whether the intent cannot be completed without collecting the parameter value.
        :param str name: The unique identifier of this parameter.
        :param Sequence[str] prompts: Optional. The collection of prompts that the agent can present to the user in order to collect a value for the parameter.
        :param str value: Optional. The definition of the parameter value. It can be: - a constant string, - a parameter value defined as `$parameter_name`, - an original parameter value defined as `$parameter_name.original`, - a parameter value from some context defined as `#context_name.parameter_name`.
        """
        pulumi.set(__self__, "default_value", default_value)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "entity_type_display_name", entity_type_display_name)
        pulumi.set(__self__, "is_list", is_list)
        pulumi.set(__self__, "mandatory", mandatory)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "prompts", prompts)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter(name="defaultValue")
    def default_value(self) -> str:
        """
        Optional. The default value to use when the `value` yields an empty result. Default values can be extracted from contexts by using the following syntax: `#context_name.parameter_name`.
        """
        return pulumi.get(self, "default_value")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        Required. The name of the parameter.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="entityTypeDisplayName")
    def entity_type_display_name(self) -> str:
        """
        Optional. The name of the entity type, prefixed with `@`, that describes values of the parameter. If the parameter is required, this must be provided.
        """
        return pulumi.get(self, "entity_type_display_name")

    @property
    @pulumi.getter(name="isList")
    def is_list(self) -> bool:
        """
        Optional. Indicates whether the parameter represents a list of values.
        """
        return pulumi.get(self, "is_list")

    @property
    @pulumi.getter
    def mandatory(self) -> bool:
        """
        Optional. Indicates whether the parameter is required. That is, whether the intent cannot be completed without collecting the parameter value.
        """
        return pulumi.get(self, "mandatory")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The unique identifier of this parameter.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def prompts(self) -> Sequence[str]:
        """
        Optional. The collection of prompts that the agent can present to the user in order to collect a value for the parameter.
        """
        return pulumi.get(self, "prompts")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        Optional. The definition of the parameter value. It can be: - a constant string, - a parameter value defined as `$parameter_name`, - an original parameter value defined as `$parameter_name.original`, - a parameter value from some context defined as `#context_name.parameter_name`.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GoogleCloudDialogflowV2beta1IntentTrainingPhrasePartResponse(dict):
    """
    Represents a part of a training phrase.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "entityType":
            suggest = "entity_type"
        elif key == "userDefined":
            suggest = "user_defined"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDialogflowV2beta1IntentTrainingPhrasePartResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDialogflowV2beta1IntentTrainingPhrasePartResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDialogflowV2beta1IntentTrainingPhrasePartResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 alias: str,
                 entity_type: str,
                 text: str,
                 user_defined: bool):
        """
        Represents a part of a training phrase.
        :param str alias: Optional. The parameter name for the value extracted from the annotated part of the example. This field is required for annotated parts of the training phrase.
        :param str entity_type: Optional. The entity type name prefixed with `@`. This field is required for annotated parts of the training phrase.
        :param str text: Required. The text for this part.
        :param bool user_defined: Optional. Indicates whether the text was manually annotated. This field is set to true when the Dialogflow Console is used to manually annotate the part. When creating an annotated part with the API, you must set this to true.
        """
        pulumi.set(__self__, "alias", alias)
        pulumi.set(__self__, "entity_type", entity_type)
        pulumi.set(__self__, "text", text)
        pulumi.set(__self__, "user_defined", user_defined)

    @property
    @pulumi.getter
    def alias(self) -> str:
        """
        Optional. The parameter name for the value extracted from the annotated part of the example. This field is required for annotated parts of the training phrase.
        """
        return pulumi.get(self, "alias")

    @property
    @pulumi.getter(name="entityType")
    def entity_type(self) -> str:
        """
        Optional. The entity type name prefixed with `@`. This field is required for annotated parts of the training phrase.
        """
        return pulumi.get(self, "entity_type")

    @property
    @pulumi.getter
    def text(self) -> str:
        """
        Required. The text for this part.
        """
        return pulumi.get(self, "text")

    @property
    @pulumi.getter(name="userDefined")
    def user_defined(self) -> bool:
        """
        Optional. Indicates whether the text was manually annotated. This field is set to true when the Dialogflow Console is used to manually annotate the part. When creating an annotated part with the API, you must set this to true.
        """
        return pulumi.get(self, "user_defined")


@pulumi.output_type
class GoogleCloudDialogflowV2beta1IntentTrainingPhraseResponse(dict):
    """
    Represents an example that the agent is trained on.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "timesAddedCount":
            suggest = "times_added_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDialogflowV2beta1IntentTrainingPhraseResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDialogflowV2beta1IntentTrainingPhraseResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDialogflowV2beta1IntentTrainingPhraseResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 parts: Sequence['outputs.GoogleCloudDialogflowV2beta1IntentTrainingPhrasePartResponse'],
                 times_added_count: int,
                 type: str):
        """
        Represents an example that the agent is trained on.
        :param str name: The unique identifier of this training phrase.
        :param Sequence['GoogleCloudDialogflowV2beta1IntentTrainingPhrasePartResponse'] parts: Required. The ordered list of training phrase parts. The parts are concatenated in order to form the training phrase. Note: The API does not automatically annotate training phrases like the Dialogflow Console does. Note: Do not forget to include whitespace at part boundaries, so the training phrase is well formatted when the parts are concatenated. If the training phrase does not need to be annotated with parameters, you just need a single part with only the Part.text field set. If you want to annotate the training phrase, you must create multiple parts, where the fields of each part are populated in one of two ways: - `Part.text` is set to a part of the phrase that has no parameters. - `Part.text` is set to a part of the phrase that you want to annotate, and the `entity_type`, `alias`, and `user_defined` fields are all set.
        :param int times_added_count: Optional. Indicates how many times this example was added to the intent. Each time a developer adds an existing sample by editing an intent or training, this counter is increased.
        :param str type: Required. The type of the training phrase.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "parts", parts)
        pulumi.set(__self__, "times_added_count", times_added_count)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The unique identifier of this training phrase.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def parts(self) -> Sequence['outputs.GoogleCloudDialogflowV2beta1IntentTrainingPhrasePartResponse']:
        """
        Required. The ordered list of training phrase parts. The parts are concatenated in order to form the training phrase. Note: The API does not automatically annotate training phrases like the Dialogflow Console does. Note: Do not forget to include whitespace at part boundaries, so the training phrase is well formatted when the parts are concatenated. If the training phrase does not need to be annotated with parameters, you just need a single part with only the Part.text field set. If you want to annotate the training phrase, you must create multiple parts, where the fields of each part are populated in one of two ways: - `Part.text` is set to a part of the phrase that has no parameters. - `Part.text` is set to a part of the phrase that you want to annotate, and the `entity_type`, `alias`, and `user_defined` fields are all set.
        """
        return pulumi.get(self, "parts")

    @property
    @pulumi.getter(name="timesAddedCount")
    def times_added_count(self) -> int:
        """
        Optional. Indicates how many times this example was added to the intent. Each time a developer adds an existing sample by editing an intent or training, this counter is increased.
        """
        return pulumi.get(self, "times_added_count")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Required. The type of the training phrase.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GoogleCloudDialogflowV2beta1LoggingConfigResponse(dict):
    """
    Defines logging behavior for conversation lifecycle events.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enableStackdriverLogging":
            suggest = "enable_stackdriver_logging"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDialogflowV2beta1LoggingConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDialogflowV2beta1LoggingConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDialogflowV2beta1LoggingConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enable_stackdriver_logging: bool):
        """
        Defines logging behavior for conversation lifecycle events.
        :param bool enable_stackdriver_logging: Whether to log conversation events like CONVERSATION_STARTED to Stackdriver in the conversation project as JSON format ConversationEvent protos.
        """
        pulumi.set(__self__, "enable_stackdriver_logging", enable_stackdriver_logging)

    @property
    @pulumi.getter(name="enableStackdriverLogging")
    def enable_stackdriver_logging(self) -> bool:
        """
        Whether to log conversation events like CONVERSATION_STARTED to Stackdriver in the conversation project as JSON format ConversationEvent protos.
        """
        return pulumi.get(self, "enable_stackdriver_logging")


@pulumi.output_type
class GoogleCloudDialogflowV2beta1NotificationConfigResponse(dict):
    """
    Defines notification behavior.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "messageFormat":
            suggest = "message_format"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDialogflowV2beta1NotificationConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDialogflowV2beta1NotificationConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDialogflowV2beta1NotificationConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 message_format: str,
                 topic: str):
        """
        Defines notification behavior.
        :param str message_format: Format of message.
        :param str topic: Name of the Pub/Sub topic to publish conversation events like CONVERSATION_STARTED as serialized ConversationEvent protos. Notification works for phone calls, if this topic either is in the same project as the conversation or you grant `service-@gcp-sa-dialogflow.iam.gserviceaccount.com` the `Dialogflow Service Agent` role in the topic project. Format: `projects//locations//topics/`.
        """
        pulumi.set(__self__, "message_format", message_format)
        pulumi.set(__self__, "topic", topic)

    @property
    @pulumi.getter(name="messageFormat")
    def message_format(self) -> str:
        """
        Format of message.
        """
        return pulumi.get(self, "message_format")

    @property
    @pulumi.getter
    def topic(self) -> str:
        """
        Name of the Pub/Sub topic to publish conversation events like CONVERSATION_STARTED as serialized ConversationEvent protos. Notification works for phone calls, if this topic either is in the same project as the conversation or you grant `service-@gcp-sa-dialogflow.iam.gserviceaccount.com` the `Dialogflow Service Agent` role in the topic project. Format: `projects//locations//topics/`.
        """
        return pulumi.get(self, "topic")


@pulumi.output_type
class GoogleCloudDialogflowV2beta1SpeechToTextConfigResponse(dict):
    """
    Configures speech transcription for ConversationProfile.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "speechModelVariant":
            suggest = "speech_model_variant"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDialogflowV2beta1SpeechToTextConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDialogflowV2beta1SpeechToTextConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDialogflowV2beta1SpeechToTextConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 speech_model_variant: str):
        """
        Configures speech transcription for ConversationProfile.
        :param str speech_model_variant: Optional. The speech model used in speech to text. `SPEECH_MODEL_VARIANT_UNSPECIFIED`, `USE_BEST_AVAILABLE` will be treated as `USE_ENHANCED`. It can be overridden in AnalyzeContentRequest and StreamingAnalyzeContentRequest request.
        """
        pulumi.set(__self__, "speech_model_variant", speech_model_variant)

    @property
    @pulumi.getter(name="speechModelVariant")
    def speech_model_variant(self) -> str:
        """
        Optional. The speech model used in speech to text. `SPEECH_MODEL_VARIANT_UNSPECIFIED`, `USE_BEST_AVAILABLE` will be treated as `USE_ENHANCED`. It can be overridden in AnalyzeContentRequest and StreamingAnalyzeContentRequest request.
        """
        return pulumi.get(self, "speech_model_variant")


@pulumi.output_type
class GoogleCloudDialogflowV2beta1SuggestionFeatureResponse(dict):
    """
    The type of Human Agent Assistant API suggestion to perform, and the maximum number of results to return for that type. Multiple `Feature` objects can be specified in the `features` list.
    """
    def __init__(__self__, *,
                 type: str):
        """
        The type of Human Agent Assistant API suggestion to perform, and the maximum number of results to return for that type. Multiple `Feature` objects can be specified in the `features` list.
        :param str type: Type of Human Agent Assistant API feature to request.
        """
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of Human Agent Assistant API feature to request.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GoogleCloudDialogflowV2beta1TextToSpeechSettingsResponse(dict):
    """
    Instructs the speech synthesizer on how to generate the output audio content.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enableTextToSpeech":
            suggest = "enable_text_to_speech"
        elif key == "outputAudioEncoding":
            suggest = "output_audio_encoding"
        elif key == "sampleRateHertz":
            suggest = "sample_rate_hertz"
        elif key == "synthesizeSpeechConfigs":
            suggest = "synthesize_speech_configs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDialogflowV2beta1TextToSpeechSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDialogflowV2beta1TextToSpeechSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDialogflowV2beta1TextToSpeechSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enable_text_to_speech: bool,
                 output_audio_encoding: str,
                 sample_rate_hertz: int,
                 synthesize_speech_configs: Mapping[str, str]):
        """
        Instructs the speech synthesizer on how to generate the output audio content.
        :param bool enable_text_to_speech: Optional. Indicates whether text to speech is enabled. Even when this field is false, other settings in this proto are still retained.
        :param str output_audio_encoding: Required. Audio encoding of the synthesized audio content.
        :param int sample_rate_hertz: Optional. The synthesis sample rate (in hertz) for this audio. If not provided, then the synthesizer will use the default sample rate based on the audio encoding. If this is different from the voice's natural sample rate, then the synthesizer will honor this request by converting to the desired sample rate (which might result in worse audio quality).
        :param Mapping[str, str] synthesize_speech_configs: Optional. Configuration of how speech should be synthesized, mapping from language (https://cloud.google.com/dialogflow/docs/reference/language) to SynthesizeSpeechConfig.
        """
        pulumi.set(__self__, "enable_text_to_speech", enable_text_to_speech)
        pulumi.set(__self__, "output_audio_encoding", output_audio_encoding)
        pulumi.set(__self__, "sample_rate_hertz", sample_rate_hertz)
        pulumi.set(__self__, "synthesize_speech_configs", synthesize_speech_configs)

    @property
    @pulumi.getter(name="enableTextToSpeech")
    def enable_text_to_speech(self) -> bool:
        """
        Optional. Indicates whether text to speech is enabled. Even when this field is false, other settings in this proto are still retained.
        """
        return pulumi.get(self, "enable_text_to_speech")

    @property
    @pulumi.getter(name="outputAudioEncoding")
    def output_audio_encoding(self) -> str:
        """
        Required. Audio encoding of the synthesized audio content.
        """
        return pulumi.get(self, "output_audio_encoding")

    @property
    @pulumi.getter(name="sampleRateHertz")
    def sample_rate_hertz(self) -> int:
        """
        Optional. The synthesis sample rate (in hertz) for this audio. If not provided, then the synthesizer will use the default sample rate based on the audio encoding. If this is different from the voice's natural sample rate, then the synthesizer will honor this request by converting to the desired sample rate (which might result in worse audio quality).
        """
        return pulumi.get(self, "sample_rate_hertz")

    @property
    @pulumi.getter(name="synthesizeSpeechConfigs")
    def synthesize_speech_configs(self) -> Mapping[str, str]:
        """
        Optional. Configuration of how speech should be synthesized, mapping from language (https://cloud.google.com/dialogflow/docs/reference/language) to SynthesizeSpeechConfig.
        """
        return pulumi.get(self, "synthesize_speech_configs")


@pulumi.output_type
class GoogleRpcStatusResponse(dict):
    """
    The `Status` type defines a logical error model that is suitable for different programming environments, including REST APIs and RPC APIs. It is used by [gRPC](https://github.com/grpc). Each `Status` message contains three pieces of data: error code, error message, and error details. You can find out more about this error model and how to work with it in the [API Design Guide](https://cloud.google.com/apis/design/errors).
    """
    def __init__(__self__, *,
                 code: int,
                 details: Sequence[Mapping[str, str]],
                 message: str):
        """
        The `Status` type defines a logical error model that is suitable for different programming environments, including REST APIs and RPC APIs. It is used by [gRPC](https://github.com/grpc). Each `Status` message contains three pieces of data: error code, error message, and error details. You can find out more about this error model and how to work with it in the [API Design Guide](https://cloud.google.com/apis/design/errors).
        :param int code: The status code, which should be an enum value of google.rpc.Code.
        :param Sequence[Mapping[str, str]] details: A list of messages that carry the error details. There is a common set of message types for APIs to use.
        :param str message: A developer-facing error message, which should be in English. Any user-facing error message should be localized and sent in the google.rpc.Status.details field, or localized by the client.
        """
        pulumi.set(__self__, "code", code)
        pulumi.set(__self__, "details", details)
        pulumi.set(__self__, "message", message)

    @property
    @pulumi.getter
    def code(self) -> int:
        """
        The status code, which should be an enum value of google.rpc.Code.
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter
    def details(self) -> Sequence[Mapping[str, str]]:
        """
        A list of messages that carry the error details. There is a common set of message types for APIs to use.
        """
        return pulumi.get(self, "details")

    @property
    @pulumi.getter
    def message(self) -> str:
        """
        A developer-facing error message, which should be in English. Any user-facing error message should be localized and sent in the google.rpc.Status.details field, or localized by the client.
        """
        return pulumi.get(self, "message")


